/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util;

import java.awt.Color;

public class ColorSpectrum {
    double[] value;
    Color[] color;
    int nValue;

    public ColorSpectrum(Color[] color, double[] value) throws IllegalArgumentException {
        this.color = color;
        this.value = value;
        this.verify();
        this.nValue = value == null ? 0 : value.length;
    }

    public Color[] getColor() {
        return this.color;
    }

    public double[] getValue() {
        return this.value;
    }

    public int getValueCount() {
        return this.nValue;
    }

    public Color getColor(double target) {
        if (this.nValue == 0) {
            return this.color[0];
        }
        for (int i = 0; i < this.nValue; ++i) {
            if (!(this.value[i] >= target)) continue;
            return this.color[i];
        }
        return this.color[this.nValue];
    }

    private void verify() {
        if (this.color == null) {
            throw new IllegalArgumentException("A color spectrum must have at least one color");
        }
        if (this.value == null && this.color.length == 1) {
            return;
        }
        if (this.value == null) {
            throw new IllegalArgumentException("The size of the color array must be 1 when value is null");
        }
        if (this.color.length != this.value.length + 1) {
            throw new IllegalArgumentException("The color array must have one more element than the value array");
        }
        int nValue = this.value.length;
        if (nValue > 1) {
            for (int i = 0; i < nValue - 1; ++i) {
                if (!(this.value[i] >= this.value[i + 1])) continue;
                throw new IllegalArgumentException("The value array must be in a ascending order");
            }
        }
    }
}

