/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ChartColorSet;
import quadbase.chart.DataLine;
import quadbase.chart.Point3D;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.util.IGradientPropertySet;
import quadbase.util.internal.Coder;
import quadbase.util.internal.IOUtil;

public class ControlRange
implements IGradientPropertySet {
    private Color color;
    private double startScale;
    private double endScale;
    private double startScale2 = 20.0;
    private double endScale2 = 60.0;
    private boolean scale1Enable = true;
    private boolean scale2Enable = false;
    private boolean showInLegend = false;
    private String title;
    private int appear = 0;
    private int depth = 0;
    private boolean drawBorder = false;
    private boolean drawFullBorder = false;
    private int thickness = 5;
    private int offset;
    private Point center = new Point(0, 0);
    private boolean showLabel = true;
    private Dimension slabelOffset = new Dimension(0, 0);
    private Dimension elabelOffset = new Dimension(0, 0);
    private Color labelColor = Color.black;
    private Font labelFont = CString.defaultfont;
    private boolean showAxis = true;
    private int direction = 0;
    private boolean highlightOverlapArea = false;
    private boolean debug = false;
    private boolean isGradientOn = false;
    private boolean is3DShadingOn = false;
    private double gradientStartX = 0.0;
    private double gradientStartY = 0.0;
    private double gradientEndX = 1.0;
    private double gradientEndY = 1.0;
    private Color gradientDesColor = null;
    private int gradientShade = -2;
    private boolean gradientCyclic = true;
    private boolean percentage = false;

    public ControlRange(double startScale, double endScale, String title, boolean legend) {
        this(startScale, endScale, ChartColorSet.getRandomColor(), title, 5, 0, new Point(0, 0), false, legend);
    }

    public ControlRange(double startScale, double endScale, String title, int thickness, int offset, Point center, boolean drawBorder, boolean showInLegend) {
        this(startScale, endScale, ChartColorSet.getRandomColor(), title, thickness, offset, center, drawBorder, showInLegend);
    }

    public ControlRange(double startScale, double endScale, String title, int thickness, int offset, Point center, boolean drawBorder, boolean showInLegend, boolean showAxis) {
        this(startScale, endScale, ChartColorSet.getRandomColor(), title, thickness, offset, center, drawBorder, showInLegend, showAxis);
    }

    public ControlRange(double startScale, double endScale, Color color, String title, boolean showInLegend) {
        this(startScale, endScale, color, title, 5, 0, new Point(0, 0), false, showInLegend);
    }

    public ControlRange(double startScale, double endScale, Color color, String title, int thickness, int offset, Point center, boolean drawBorder, boolean showInLegend) {
        this(startScale, endScale, color, title, thickness, offset, center, drawBorder, showInLegend, true);
    }

    public ControlRange(double startScale, double endScale, Color color, String title, int thickness, int offset, Point center, boolean drawBorder, boolean showInLegend, boolean showAxis) {
        this.startScale = startScale;
        this.endScale = endScale;
        this.color = color;
        this.title = title;
        this.thickness = thickness;
        this.offset = offset;
        if (center != null) {
            this.center = center;
        }
        this.showAxis = showAxis;
        this.drawBorder = drawBorder;
        this.showInLegend = showInLegend;
    }

    public ControlRange(double startScale, double endScale, String title, int appear, int depth, boolean showInLegend) {
        this(startScale, endScale, ChartColorSet.getRandomColor(), title, appear, depth, showInLegend);
    }

    public ControlRange(double startScale, double endScale, Color color, String title, int appear, int depth, boolean showInLegend) {
        this.startScale = startScale;
        this.endScale = endScale;
        this.color = color;
        this.title = title;
        this.appear = appear;
        this.depth = depth;
        this.showInLegend = showInLegend;
    }

    public ControlRange(ControlRange cr) {
        this.copy(cr);
    }

    public static Vector copy(Vector crl) {
        if (crl == null) {
            return null;
        }
        Vector<ControlRange> newList = new Vector<ControlRange>();
        for (int i = 0; i < crl.size(); ++i) {
            ControlRange tmp = (ControlRange)crl.elementAt(i);
            ControlRange newRange = new ControlRange(tmp.startScale, tmp.endScale, tmp.title, tmp.showInLegend);
            newRange.copy(tmp);
            newList.add(newRange);
        }
        return newList;
    }

    public void copy(ControlRange cr) {
        this.color = cr.color;
        this.startScale = cr.startScale;
        this.endScale = cr.endScale;
        this.startScale2 = cr.startScale2;
        this.endScale2 = cr.endScale2;
        this.scale1Enable = cr.scale1Enable;
        this.scale2Enable = cr.scale2Enable;
        this.showInLegend = cr.showInLegend;
        this.title = cr.title;
        this.appear = cr.appear;
        this.depth = cr.depth;
        this.drawBorder = cr.drawBorder;
        this.drawFullBorder = cr.drawFullBorder;
        this.thickness = cr.thickness;
        this.offset = cr.offset;
        this.center = cr.center;
        this.showLabel = cr.showLabel;
        this.slabelOffset = cr.slabelOffset;
        this.elabelOffset = cr.elabelOffset;
        this.labelColor = cr.labelColor;
        this.labelFont = cr.labelFont;
        this.showAxis = cr.showAxis;
        this.direction = cr.direction;
        this.highlightOverlapArea = cr.highlightOverlapArea;
        this.isGradientOn = cr.isGradientOn;
        this.is3DShadingOn = cr.is3DShadingOn;
        this.gradientStartX = cr.gradientStartX;
        this.gradientStartY = cr.gradientStartY;
        this.gradientEndX = cr.gradientEndX;
        this.gradientEndY = cr.gradientEndY;
        this.gradientDesColor = cr.gradientDesColor;
        this.gradientShade = cr.gradientShade;
        this.gradientCyclic = cr.gradientCyclic;
        this.percentage = cr.percentage;
    }

    public double getStartScale() {
        return this.startScale;
    }

    public double getStartScale(Chart chart) {
        return this.percentage ? this.startScale / 100.0 * ControlRange.getMaxScaleOnAxis(chart) : this.startScale;
    }

    public void setStartScale(double scale) {
        this.startScale = scale;
    }

    public double getEndScale() {
        return this.endScale;
    }

    public double getEndScale(Chart chart) {
        return this.percentage ? this.endScale / 100.0 * ControlRange.getMaxScaleOnAxis(chart) : this.endScale;
    }

    public void setEndScale(double scale) {
        this.endScale = scale;
    }

    public double getStartScale2() {
        return this.startScale2;
    }

    public double getStartScale2(Chart chart) {
        return this.percentage ? this.startScale2 / 100.0 * ControlRange.getMaxValueOnCategoryAxis(chart) : this.startScale2;
    }

    public void setStartScale2(double scale) {
        this.startScale2 = scale;
    }

    public double getEndScale2() {
        return this.endScale2;
    }

    public double getEndScale2(Chart chart) {
        return this.percentage ? this.endScale2 / 100.0 * ControlRange.getMaxValueOnCategoryAxis(chart) : this.endScale2;
    }

    public void setEndScale2(double scale) {
        this.endScale2 = scale;
    }

    public boolean isScale1Enabled() {
        return this.scale1Enable;
    }

    public void setScale1Enabled(boolean b) {
        this.scale1Enable = b;
    }

    public boolean isScale2Enabled() {
        return this.scale2Enable;
    }

    public void setScale2Enabled(boolean b) {
        this.scale2Enable = b;
    }

    public boolean isOverlapAreaHighlighted() {
        return this.highlightOverlapArea;
    }

    public void setOverlapAreaHighlighted(boolean b) {
        this.highlightOverlapArea = b;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int t) {
        this.thickness = t;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Point getCenter() {
        return this.center;
    }

    public void setCenter(Point center) {
        if (center != null) {
            this.center = center;
        }
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean state) {
        this.drawBorder = state;
    }

    public boolean isDrawFullBorder() {
        return this.drawFullBorder;
    }

    public void setDrawFullBorder(boolean state) {
        this.drawFullBorder = state;
    }

    public boolean isShowInLegend() {
        return this.showInLegend;
    }

    public void setShowInLegend(boolean showInLegend) {
        this.showInLegend = showInLegend;
    }

    public int getAppearance() {
        return this.appear;
    }

    public void setAppearance(int appear) {
        this.appear = appear;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeDouble(this.startScale);
        dout.writeDouble(this.endScale);
        IOUtil.writeColor(dout, this.color);
        IOUtil.writeString(dout, Coder.encode(this.title));
        dout.writeInt(this.thickness);
        dout.writeInt(this.offset);
        dout.writeInt(this.center.x);
        dout.writeInt(this.center.y);
        dout.writeBoolean(this.drawBorder);
        dout.writeBoolean(this.showInLegend);
        dout.writeInt(this.depth);
        dout.writeInt(this.appear);
        dout.writeInt(this.direction);
        dout.writeDouble(this.startScale2);
        dout.writeDouble(this.endScale2);
        dout.writeBoolean(this.scale1Enable);
        dout.writeBoolean(this.scale2Enable);
        dout.writeBoolean(this.highlightOverlapArea);
        if (dout instanceof VersioningDataOutput) {
            VersioningDataOutput vdo = (VersioningDataOutput)dout;
            vdo.writeBoolean(this.showAxis, (short)408);
        }
        VersioningDataOutput vOut = (VersioningDataOutput)dout;
        vOut.writeBoolean(this.isGradientEnabled(), (short)4103);
        vOut.writeBoolean(this.is3DShadingEnabled(), (short)4103);
        vOut.writeDouble(this.getGradientStartX(), (short)4103);
        vOut.writeDouble(this.getGradientStartY(), (short)4103);
        vOut.writeDouble(this.getGradientEndX(), (short)4103);
        vOut.writeDouble(this.getGradientEndY(), (short)4103);
        vOut.writeBoolean(this.getGradientDesColor() != null, (short)4103);
        if (this.getGradientDesColor() != null) {
            IOUtil.writeColor(vOut, this.getGradientDesColor(), (short)4103);
        }
        vOut.writeInt(this.getGradientShade(), (short)4103);
        vOut.writeBoolean(this.isGradientCyclic(), (short)4103);
        vOut.writeBoolean(this.percentage, (short)6603);
    }

    public static ControlRange read(DataInput din, int version) throws IOException {
        if (version < 142) {
            return null;
        }
        if (version >= 162) {
            ControlRange range = new ControlRange(din.readDouble(), din.readDouble(), IOUtil.readColor(din), Coder.decode(IOUtil.readString(din, true), version), din.readInt(), din.readInt(), new Point(din.readInt(), din.readInt()), din.readBoolean(), din.readBoolean());
            if (version >= 172) {
                range.setDepth(din.readInt());
                range.setAppearance(din.readInt());
                range.setDirection(din.readInt());
            }
            if (version >= 283) {
                range.setStartScale2(din.readDouble());
                range.setEndScale2(din.readDouble());
                range.setScale1Enabled(din.readBoolean());
                range.setScale2Enabled(din.readBoolean());
            }
            if (version >= 284) {
                range.setOverlapAreaHighlighted(din.readBoolean());
            }
            if (version >= 408) {
                range.setShowAxis(din.readBoolean());
            }
            if (version <= 7099 && version >= 4103) {
                range.setGradientEnabled(din.readBoolean());
                range.set3DShadingEnabled(din.readBoolean());
                range.setGradientStartX(din.readDouble());
                range.setGradientStartY(din.readDouble());
                range.setGradientEndX(din.readDouble());
                range.setGradientEndY(din.readDouble());
                if (din.readBoolean()) {
                    range.setGradientDesColor(IOUtil.readColor(din));
                }
                range.setGradientShade(din.readInt());
                range.setGradientCyclic(din.readBoolean());
            }
            if (version >= 6603) {
                range.setPercentage(din.readBoolean());
            } else {
                range.setPercentage(false);
            }
            return range;
        }
        return new ControlRange(din.readDouble(), din.readDouble(), IOUtil.readColor(din), Coder.decode(IOUtil.readString(din, true), version), din.readBoolean());
    }

    public boolean isHorizontalRange(Chart chart) {
        return DataLine.isBarChartType(chart) || Chart.isCoordinateType(chart.getChartType()) && this.getDirection() == 1;
    }

    public int getX1(Chart chart) {
        Axis a_x = chart.a_x;
        if (this.isHorizontalRange(chart)) {
            if (this.scale1Enable) {
                double start = this.getStartScale(chart);
                if (start >= a_x.maxScale) {
                    return -1;
                }
                if (start < a_x.minScale) {
                    start = a_x.minScale;
                }
                if (this.debug) {
                    System.out.println("X 1");
                }
                return a_x.stepsize.interpolatePixel(start);
            }
            if (this.debug) {
                System.out.println("X 2");
            }
            return a_x.stepsize.interpolatePixel(a_x.minScale);
        }
        if (this.scale2Enable) {
            if (Chart.isCoordinateType(chart.getChartType())) {
                double start = this.getStartScale2(chart);
                if (start >= a_x.maxScale) {
                    return -1;
                }
                if (start < a_x.minScale) {
                    start = a_x.minScale;
                }
                if (this.debug) {
                    System.out.println("X 3");
                }
                return a_x.stepsize.interpolatePixel(start);
            }
            this.setTickerPosition(chart);
            Point3D[] p = chart.a_x.ticker.point;
            int len = p.length;
            if (this.debug) {
                System.out.println("X 4");
            }
            if (len > 1) {
                return (int)Math.round((double)p[0].x + (this.getStartScale2(chart) - (chart.a_x.startp != null && p[0].x - chart.a_x.startp.x > 0 ? 0.5 : 0.0)) * (double)(p[len - 1].x - p[0].x) / (double)(len - 1));
            }
            int minX = a_x.startp.x;
            int maxX = a_x.endp.x;
            return (int)Math.round((double)minX + (this.getStartScale2(chart) > 1.0 ? 1.0 : this.getStartScale2(chart)) * (double)(maxX - minX));
        }
        if (this.debug) {
            System.out.println("X 5");
        }
        return a_x.startp.x;
    }

    public int getX2(Chart chart) {
        Axis a_x = chart.a_x;
        if (this.isHorizontalRange(chart)) {
            if (this.scale1Enable) {
                double end = this.getEndScale(chart);
                if (end <= this.getStartScale(chart)) {
                    return -1;
                }
                if (end > a_x.maxScale) {
                    end = a_x.maxScale;
                }
                if (this.debug) {
                    System.out.println("X 6");
                }
                return a_x.stepsize.interpolatePixel(end);
            }
            if (this.debug) {
                System.out.println("X 7");
            }
            return a_x.stepsize.interpolatePixel(a_x.maxScale);
        }
        if (this.scale2Enable) {
            if (Chart.isCoordinateType(chart.getChartType())) {
                double end = this.getEndScale2(chart);
                if (end <= this.getStartScale2(chart)) {
                    return -1;
                }
                if (end > a_x.maxScale) {
                    end = a_x.maxScale;
                }
                if (this.debug) {
                    System.out.println("X 8");
                }
                return a_x.stepsize.interpolatePixel(end);
            }
            this.setTickerPosition(chart);
            Point3D[] p = chart.a_x.ticker.point;
            int len = p.length;
            if (this.debug) {
                System.out.println("X 9");
            }
            if (len > 1) {
                return (int)Math.round((double)p[0].x + (this.getEndScale2(chart) - (chart.a_x.startp != null && p[0].x - chart.a_x.startp.x > 0 ? 0.5 : 0.0)) * (double)(p[len - 1].x - p[0].x) / (double)(len - 1));
            }
            int minX = a_x.startp.x;
            int maxX = a_x.endp.x;
            return (int)Math.round((double)minX + (this.getEndScale2(chart) > 1.0 ? 1.0 : this.getEndScale2(chart)) * (double)(maxX - minX));
        }
        if (this.debug) {
            System.out.println("X 10");
        }
        return a_x.endp.x;
    }

    public int getY1(Chart chart) {
        Axis a_y = chart.a_y;
        if (this.isHorizontalRange(chart)) {
            if (this.scale2Enable) {
                if (Chart.isCoordinateType(chart.getChartType())) {
                    double start = this.getStartScale2(chart);
                    if (start >= a_y.maxScale) {
                        return -1;
                    }
                    if (start < a_y.minScale) {
                        start = a_y.minScale;
                    }
                    if (this.debug) {
                        System.out.println("Y 1");
                    }
                    return a_y.stepsize.interpolatePixel(start);
                }
                this.setTickerPosition(chart);
                Point3D[] p = chart.a_y.ticker.point;
                int len = p.length;
                if (this.debug) {
                    System.out.println("Y 2");
                }
                if (len > 1) {
                    return (int)Math.round((double)p[0].y + (this.getStartScale2(chart) - (chart.a_y.startp != null && p[0].y - chart.a_y.startp.y > 0 ? 0.5 : 0.0)) * (double)(p[len - 1].y - p[0].y) / (double)(len - 1));
                }
                int minY = a_y.startp.y;
                int maxY = a_y.endp.y;
                return (int)Math.round((double)minY + (this.getStartScale2(chart) > 1.0 ? 1.0 : this.getStartScale2(chart)) * (double)(maxY - minY));
            }
            if (this.debug) {
                System.out.println("Y 3");
            }
            return a_y.startp.y;
        }
        if (this.scale1Enable) {
            double start = this.getStartScale(chart);
            if (start >= a_y.maxScale) {
                return -1;
            }
            if (start < a_y.minScale) {
                start = a_y.minScale;
            }
            if (this.debug) {
                System.out.println("Y 4");
            }
            return a_y.stepsize.interpolatePixel(start);
        }
        if (this.debug) {
            System.out.println("Y 5");
        }
        return a_y.stepsize.interpolatePixel(a_y.minScale);
    }

    public int getY2(Chart chart) {
        Axis a_y = chart.a_y;
        if (this.isHorizontalRange(chart)) {
            if (this.scale2Enable) {
                if (Chart.isCoordinateType(chart.getChartType())) {
                    double end = this.getEndScale2(chart);
                    if (end <= this.getStartScale2(chart)) {
                        return -1;
                    }
                    if (end > a_y.maxScale) {
                        end = a_y.maxScale;
                    }
                    if (this.debug) {
                        System.out.println("Y 6");
                    }
                    return a_y.stepsize.interpolatePixel(end);
                }
                this.setTickerPosition(chart);
                Point3D[] p = chart.a_y.ticker.point;
                int len = p.length;
                if (this.debug) {
                    System.out.println("Y 7");
                }
                if (len > 1) {
                    return (int)Math.round((double)p[0].y + (this.getEndScale2(chart) - (chart.a_y.startp != null && p[0].y - chart.a_y.startp.y > 0 ? 0.5 : 0.0)) * (double)(p[len - 1].y - p[0].y) / (double)(len - 1));
                }
                int minY = a_y.startp.y;
                int maxY = a_y.endp.y;
                return (int)Math.round((double)minY + (this.getEndScale2(chart) > 1.0 ? 1.0 : this.getEndScale2(chart)) * (double)(maxY - minY));
            }
            if (this.debug) {
                System.out.println("Y 8");
            }
            return a_y.endp.y;
        }
        if (this.scale1Enable) {
            double end = this.getEndScale(chart);
            if (end <= this.getStartScale(chart)) {
                return -1;
            }
            if (end > a_y.maxScale) {
                end = a_y.maxScale;
            }
            if (this.debug) {
                System.out.println("Y 9");
            }
            return a_y.stepsize.interpolatePixel(end);
        }
        if (this.debug) {
            System.out.println("Y 10");
        }
        return a_y.stepsize.interpolatePixel(a_y.maxScale);
    }

    private void setTickerPosition(Chart chart) {
        if (chart.a_y.ticker == null || chart.a_x.ticker == null) {
            if (chart.cgraphics == null) {
                chart.cgraphics = new CGraphics(null, chart.component, chart.winHeight, chart.winWidth, chart);
            }
            chart.computeCoord(chart.cgraphics, chart.chartxorigin, chart.chartxorigin + chart.chartwidth, chart.chartyorigin, chart.chartheight + chart.chartyorigin);
        }
    }

    public static double getMaxValueOnValueAxis(Chart chart) {
        if (chart != null) {
            Axis ax = chart.isVertical() ? chart.a_y : chart.a_x;
            return ControlRange.getMaxLimit(ax);
        }
        return Double.MIN_VALUE;
    }

    public static double getMaxValueOnCategoryAxis(Chart chart) {
        if (chart != null) {
            Axis ax = chart.isVertical() ? chart.a_x : chart.a_y;
            return ControlRange.getMaxLimit(ax);
        }
        return Double.MIN_VALUE;
    }

    private static double getMaxLimit(Axis ax) {
        if (ax != null) {
            if (ax.stepsize != null) {
                return ax.stepsize.maxlimit;
            }
            if (ax.ticker != null && ax.ticker.point != null) {
                if (ax.startp != null && ax.startp.x - ax.ticker.point[0].x == 0 && ax.startp.y - ax.ticker.point[0].y == 0) {
                    return ax.ticker.point.length - 1;
                }
                return ax.ticker.point.length;
            }
        }
        return Double.MIN_VALUE;
    }

    public static double getMaxScaleOnAxis(Chart chart) {
        if (chart != null) {
            Axis ax = chart.isVertical() ? chart.a_y : chart.a_x;
            return ControlRange.getMaxScale(ax);
        }
        return Double.MIN_VALUE;
    }

    private static double getMaxScale(Axis ax) {
        if (ax != null) {
            return ax.getMaxScale();
        }
        return Double.MIN_VALUE;
    }

    public void setShowLabel(boolean b) {
        this.showLabel = b;
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public Dimension getStartLabelOffset() {
        return this.slabelOffset;
    }

    public void setStartLabelOffset(Dimension d) {
        this.slabelOffset = d;
    }

    public Dimension getEndLabelOffset() {
        return this.elabelOffset;
    }

    public void setEndLabelOffset(Dimension d) {
        this.elabelOffset = d;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color c) {
        this.labelColor = c;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font f) {
        this.labelFont = f;
    }

    public String toString() {
        return this.title;
    }

    public void setShowAxis(boolean b) {
        this.showAxis = b;
    }

    public boolean isShowAxis() {
        return this.showAxis;
    }

    @Override
    public boolean isGradientEnabled() {
        return this.isGradientOn && IOUtil.isJava2D();
    }

    @Override
    public void setGradientEnabled(boolean b) {
        this.isGradientOn = b;
    }

    @Override
    public boolean is3DShadingEnabled() {
        return this.is3DShadingOn && IOUtil.isJava2D();
    }

    @Override
    public void set3DShadingEnabled(boolean b) {
        this.is3DShadingOn = b;
    }

    @Override
    public double getGradientStartX() {
        return this.gradientStartX;
    }

    @Override
    public double getGradientStartY() {
        return this.gradientStartY;
    }

    @Override
    public double getGradientEndX() {
        return this.gradientEndX;
    }

    @Override
    public double getGradientEndY() {
        return this.gradientEndY;
    }

    @Override
    public Color getGradientDesColor() {
        return this.gradientDesColor;
    }

    @Override
    public int getGradientShade() {
        return this.gradientShade;
    }

    @Override
    public boolean isGradientCyclic() {
        return this.gradientCyclic;
    }

    @Override
    public void setGradientStartX(double x) {
        this.gradientStartX = x;
    }

    @Override
    public void setGradientStartY(double y) {
        this.gradientStartY = y;
    }

    @Override
    public void setGradientEndX(double x) {
        this.gradientEndX = x;
    }

    @Override
    public void setGradientEndY(double y) {
        this.gradientEndY = y;
    }

    @Override
    public void setGradientDesColor(Color c) {
        this.gradientDesColor = c;
    }

    @Override
    public void setGradientShade(int s) {
        this.gradientShade = s;
    }

    @Override
    public void setGradientCyclic(boolean c) {
        this.gradientCyclic = c;
    }

    public boolean isPercentage() {
        return this.percentage;
    }

    public void setPercentage(boolean percentage) {
        this.percentage = percentage;
    }
}

