/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import quadbase.util.PickData;
import quadbase.util.internal.IOUtil;

public class HyperLink {
    public static final String DEFAULT_TARGET = "";
    public String series = "";
    public String category = "";
    public String sumBy = "";
    public String xValue = null;
    public String zValue = null;
    public String link = "";
    public String target = "";
    public String hint = "";
    private HintStyle hintStyle = HintStyle.REPLACE;

    public void setHintStyle(HintStyle style) {
        this.hintStyle = style;
    }

    public HintStyle getHintStyle() {
        return this.hintStyle;
    }

    public HyperLink(PickData pd) {
        this.series = pd.series == null ? DEFAULT_TARGET : pd.series;
        this.category = pd.category == null ? DEFAULT_TARGET : pd.category;
        this.sumBy = pd.sumBy == null ? DEFAULT_TARGET : pd.sumBy;
    }

    public HyperLink() {
    }

    public HyperLink(String series, String category, String sumBy, String link, String target) {
        this.series = series;
        this.category = category;
        this.sumBy = sumBy;
        this.link = link;
        if (target != null) {
            this.target = target;
        }
    }

    public HyperLink(String series, String category, String sumBy, String link) {
        this(series, category, sumBy, link, DEFAULT_TARGET);
    }

    public static HyperLink createHyperLinkForSurfaceChart(String xValue, String zValue, String link, String target) {
        HyperLink hyperLink = new HyperLink();
        if (!xValue.equals("All")) {
            xValue = Double.toString(Double.valueOf(xValue));
        }
        hyperLink.xValue = xValue;
        if (!zValue.equals("All")) {
            zValue = Double.toString(Double.valueOf(zValue));
        }
        hyperLink.zValue = zValue;
        hyperLink.link = link;
        hyperLink.target = target;
        hyperLink.setHintValue(DEFAULT_TARGET);
        return hyperLink;
    }

    public static HyperLink createHyperLinkForSurfaceChart(String xValue, String zValue, String link) {
        return HyperLink.createHyperLinkForSurfaceChart(xValue, zValue, link, DEFAULT_TARGET);
    }

    public static Vector copy(Vector crl) {
        if (crl == null) {
            return null;
        }
        Vector<HyperLink> newList = new Vector<HyperLink>();
        for (int i = 0; i < crl.size(); ++i) {
            HyperLink tmp = (HyperLink)crl.elementAt(i);
            HyperLink link = new HyperLink();
            link.copy(tmp);
            newList.add(link);
        }
        return newList;
    }

    public void copy(HyperLink cr) {
        this.series = cr.series;
        this.category = cr.category;
        this.sumBy = cr.sumBy;
        this.xValue = cr.xValue;
        this.zValue = cr.zValue;
        this.link = cr.link;
        this.target = cr.target;
        this.hint = cr.hint;
        this.setHintStyle(cr.getHintStyle());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HyperLink other = (HyperLink)obj;
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.series == null ? other.series != null : !this.series.equals(other.series)) {
            return false;
        }
        return !(this.sumBy == null ? other.sumBy != null : !this.sumBy.equals(other.sumBy));
    }

    public void write(DataOutput out) throws IOException {
        IOUtil.writeString(out, this.series);
        IOUtil.writeString(out, this.category);
        IOUtil.writeString(out, this.sumBy);
        IOUtil.writeString(out, this.link);
        IOUtil.writeString(out, this.target);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.series == null ? 0 : this.series.hashCode());
        result = 31 * result + (this.sumBy == null ? 0 : this.sumBy.hashCode());
        return result;
    }

    public void writeHint(DataOutput out) throws IOException {
        if (this.hint == null) {
            IOUtil.writeString(out, DEFAULT_TARGET);
        } else {
            IOUtil.writeString(out, this.hint);
        }
    }

    public static HyperLink read(DataInput in, boolean btarget, boolean isUTF) throws IOException {
        return new HyperLink(IOUtil.readString(in, isUTF), IOUtil.readString(in, isUTF), IOUtil.readString(in, isUTF), IOUtil.readString(in, isUTF), btarget ? IOUtil.readString(in, isUTF) : DEFAULT_TARGET);
    }

    public void readHint(DataInput in, boolean isUTF) throws IOException {
        String tmp = IOUtil.readString(in, isUTF);
        this.hint = tmp == null ? DEFAULT_TARGET : tmp;
    }

    public String toString() {
        return "Series = " + this.series + ", category = " + this.category + ", sumBy = " + this.sumBy + ", url = " + this.link + ", target = " + this.target + ", hint = " + this.hint;
    }

    public HyperLink findNewLink(Vector vec) {
        return this.findNewLink(vec, false);
    }

    public HyperLink findNewLink(Vector vec, boolean forLegend) {
        if (vec == null) {
            return null;
        }
        int sz = vec.size();
        int maxMark = 0;
        int index = -1;
        for (int i = 0; i < sz; ++i) {
            int mark = 0;
            HyperLink hlink = (HyperLink)vec.elementAt(i);
            if (hlink.series.equals(this.series)) {
                mark = 250;
            } else {
                if (!hlink.series.equals(DEFAULT_TARGET) || this.series.equals(DEFAULT_TARGET)) continue;
                mark = 25;
            }
            if (hlink.category.equals(this.category)) {
                mark += 200;
            } else if (forLegend && this.category.equals(DEFAULT_TARGET) && !hlink.category.equals(DEFAULT_TARGET)) {
                mark += 20;
            } else {
                if (!hlink.category.equals(DEFAULT_TARGET) || this.category.equals(DEFAULT_TARGET)) continue;
                mark += 20;
            }
            if (hlink.sumBy.equals(this.sumBy)) {
                mark += 100;
            } else {
                if (!hlink.sumBy.equals(DEFAULT_TARGET) || this.sumBy.equals(DEFAULT_TARGET)) continue;
                mark += 10;
            }
            if (mark < maxMark || hlink.link.trim().equals(DEFAULT_TARGET)) continue;
            maxMark = mark;
            index = i;
        }
        HyperLink tempLink = new HyperLink();
        if (index >= 0) {
            tempLink.copy((HyperLink)vec.elementAt(index));
            return tempLink;
        }
        return null;
    }

    public void setHintValue(String hintString) {
        this.hint = hintString;
    }

    public String getHintValue() {
        return this.hint;
    }

    public static enum HintStyle {
        REPLACE,
        ATTACH_START,
        ATTACH_END;

    }
}

