/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util;

import java.math.BigDecimal;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.util.IFormat;

public class NumericFormat
implements IFormat {
    public boolean sciExp;
    public char currencySymbol;
    @Deprecated
    public boolean oneSymPerPage;
    public int currencyPos;
    public int decimal;
    public int rounding;
    public int negative;
    public char decimalSep;
    public char thousandSep;
    public boolean leadingZero;

    public NumericFormat() {
        this.setDefault();
    }

    @Override
    public int getFormatType() {
        return 1;
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            obj = FormatUtil.nullNumeric;
        }
        if (obj instanceof Number) {
            Float f;
            Double d;
            if (obj instanceof Double ? (d = (Double)obj).isNaN() : obj instanceof Float && (f = (Float)obj).isNaN()) {
                return FormatUtil.nullNumeric.toString();
            }
            return this.output(((Number)obj).doubleValue());
        }
        return obj.toString();
    }

    public void setDefault() {
        this.sciExp = false;
        this.currencySymbol = (char)32;
        this.oneSymPerPage = false;
        this.currencyPos = 0;
        this.decimal = 2;
        this.rounding = 1;
        this.negative = 0;
        this.decimalSep = (char)46;
        this.thousandSep = (char)44;
        this.leadingZero = true;
    }

    public void setScientifExp(int precision) {
        this.sciExp = true;
        this.decimal = precision;
        if (this.decimal <= 0) {
            this.decimal = 1;
        }
    }

    public void setFormat(char currSymInit, boolean oneSymPerPageInit, int currencyPosInit, int decimalInit, int roundingInit, int negativeInit, char decimalSepInit, char thousandSepInit, boolean leadingZeroInit) {
        this.sciExp = false;
        this.currencySymbol = currSymInit;
        this.oneSymPerPage = oneSymPerPageInit;
        this.currencyPos = currencyPosInit;
        this.decimal = decimalInit;
        this.rounding = roundingInit;
        this.negative = negativeInit;
        this.decimalSep = decimalSepInit;
        this.thousandSep = thousandSepInit;
        this.leadingZero = leadingZeroInit;
    }

    public String output(double d) {
        int i;
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        boolean isNegative = false;
        boolean nNegIsZero = false;
        String res = "";
        if (d < 0.0) {
            isNegative = true;
            d = -d;
        }
        double dd = d;
        int nIntDigits = 0;
        BigDecimal bigDecimal = new BigDecimal(d + "");
        while (dd >= 1.0) {
            dd /= 10.0;
            bigDecimal = bigDecimal.movePointLeft(1);
            ++nIntDigits;
        }
        int nNegative = 0;
        if (nIntDigits == 0) {
            if (this.sciExp) {
                if (dd != 0.0) {
                    while (dd < 1.0) {
                        dd *= 10.0;
                        ++nNegative;
                    }
                    bigDecimal = bigDecimal.movePointLeft(1);
                    if (--nNegative == 0) {
                        nNegIsZero = true;
                    }
                }
            } else {
                nIntDigits = 1;
                bigDecimal = bigDecimal.movePointLeft(1);
            }
        }
        int n = this.sciExp ? this.decimal + 2 : nIntDigits + this.decimal + 1;
        int[] digits = new int[n];
        for (i = 0; i < n; ++i) {
            bigDecimal = bigDecimal.movePointRight(1);
            int tmp = bigDecimal.intValue();
            bigDecimal = bigDecimal.subtract(new BigDecimal(tmp));
            digits[i] = (char)tmp;
        }
        if (this.sciExp) {
            if (digits[this.decimal + 1] >= 5) {
                for (i = this.decimal; i >= 0; --i) {
                    if (digits[i] != 9) {
                        int n2 = i;
                        digits[n2] = digits[n2] + 1;
                        break;
                    }
                    digits[i] = 0;
                }
                if (i == -1) {
                    for (i = n - 1; i > 0; --i) {
                        digits[i] = digits[i - 1];
                    }
                    ++nIntDigits;
                    digits[0] = 1;
                }
            }
            if (isNegative) {
                res = res + '-';
            }
            res = res + digits[0];
            res = res + '.';
            for (i = 0; i < this.decimal; ++i) {
                res = res + digits[i + 1];
            }
            if (nIntDigits != 0 || nNegative != 0 || nNegIsZero) {
                res = res + 'E';
                if (nNegative == 0 && !nNegIsZero) {
                    res = res + '+';
                    res = res + (nIntDigits - 1) / 10;
                    res = res + (nIntDigits - 1) % 10;
                } else {
                    res = res + '-';
                    res = res + (nNegative + 1) / 10;
                    res = res + (nNegative + 1) % 10;
                }
            }
            return res;
        }
        int rDigit = nIntDigits + this.decimal - this.rounding;
        if (rDigit < 0) {
            rDigit = 0;
        }
        if (rDigit + 1 < digits.length && digits[rDigit + 1] >= 5) {
            for (i = rDigit; i >= 0; --i) {
                if (digits[i] != 9) {
                    int n3 = i;
                    digits[n3] = digits[n3] + 1;
                    break;
                }
                digits[i] = 0;
            }
            if (i == -1) {
                for (i = rDigit; i > 0; --i) {
                    digits[i] = digits[i - 1];
                }
                ++nIntDigits;
                digits[0] = 1;
            }
        }
        for (i = rDigit + 1; i < nIntDigits + this.decimal; ++i) {
            digits[i] = 0;
        }
        char c0 = '-';
        char c1 = '\u0000';
        char c2 = '(';
        if (this.currencySymbol != ' ' && this.currencyPos == 0) {
            res = res + this.currencySymbol;
        }
        if (isNegative) {
            if (this.negative == 0) {
                res = res + c0;
            } else if (this.negative == 1) {
                if (c1 != '\u0000') {
                    res = res + c1;
                }
            } else if (c2 != '\u0000') {
                res = res + c2;
            }
        }
        if (this.currencySymbol != ' ' && this.currencyPos == 1) {
            res = res + this.currencySymbol;
        }
        if (this.leadingZero || nIntDigits != 1 || digits[0] != 0) {
            for (i = 0; i < nIntDigits; ++i) {
                int tempn = nIntDigits - 1 - i;
                res = res + digits[i];
                if (this.thousandSep == 'N' || tempn % 3 != 0 || tempn == 0) continue;
                res = res + this.thousandSep;
            }
        }
        if (this.decimal != 0) {
            res = res + this.decimalSep;
        }
        for (i = 0; i < this.decimal; ++i) {
            res = res + digits[i + nIntDigits];
        }
        c1 = '-';
        c2 = ')';
        if (this.currencySymbol != ' ' && this.currencyPos == 2) {
            res = res + this.currencySymbol;
        }
        if (isNegative) {
            if (this.negative == 1) {
                res = res + c1;
            } else if (this.negative == 2) {
                res = res + c2;
            }
        }
        if (this.currencySymbol != ' ' && this.currencyPos == 3) {
            res = res + this.currencySymbol;
        }
        return res;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< NumericFormat >>\n");
        sb.append("sciExp\t\t= ").append(this.sciExp);
        sb.append("currencySymbol\t= ").append(this.currencySymbol);
        sb.append("oneSymPerPage\t= ").append(this.oneSymPerPage);
        sb.append("currencyPos\t= ").append(this.currencyPos);
        sb.append("decimal\t= ").append(this.decimal);
        sb.append("rounding\t= ").append(this.rounding);
        sb.append("negative\t= ").append(this.negative);
        sb.append("decimalSep\t= ").append(this.decimalSep);
        sb.append("thousandSep\t= ").append(this.thousandSep);
        sb.append("leadingZero\t= ").append(this.leadingZero);
        return sb.toString();
    }
}

