/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.gif;

import quadbase.util.gif.QuantizerBox;

public class ColorQuantizer {
    byte[] Ir;
    byte[] Ig;
    byte[] Ib;
    byte[] lut_r;
    byte[] lut_g;
    byte[] lut_b;
    int size;
    int[] wt;
    int[] mr;
    int[] mg;
    int[] mb;
    float[] gm2;
    int[] Qadd;
    static final byte RED = 2;
    static final byte GREEN = 1;
    static final byte BLUE = 0;

    public ColorQuantizer(byte[] red, byte[] green, byte[] blue, int size) {
        this.Ir = red;
        this.Ig = green;
        this.Ib = blue;
        this.size = size;
        this.gm2 = new float[35937];
        this.wt = new int[35937];
        this.mr = new int[35937];
        this.mg = new int[35937];
        this.mb = new int[35937];
        this.Qadd = new int[size];
    }

    public int quantize(int notargetColor) {
        int k;
        int i;
        this.lut_r = new byte[notargetColor];
        this.lut_g = new byte[notargetColor];
        this.lut_b = new byte[notargetColor];
        QuantizerBox[] cube = new QuantizerBox[notargetColor];
        float[] vv = new float[notargetColor];
        this.hist3d(this.wt, this.mr, this.mg, this.mb, this.gm2);
        this.m3d(this.wt, this.mr, this.mg, this.mb, this.gm2);
        for (i = 0; i < notargetColor; ++i) {
            cube[i] = new QuantizerBox();
        }
        cube[0].b0 = 0;
        cube[0].g0 = 0;
        cube[0].r0 = 0;
        cube[0].b1 = 32;
        cube[0].g1 = 32;
        cube[0].r1 = 32;
        int next = 0;
        for (i = 1; i < notargetColor; ++i) {
            if (this.cut(cube[next], cube[i]) != 0) {
                vv[next] = cube[next].vol > 1 ? this.var(cube[next]) : 0.0f;
                vv[i] = cube[i].vol > 1 ? this.var(cube[i]) : 0.0f;
            } else {
                vv[next] = 0.0f;
                --i;
            }
            next = 0;
            float temp = vv[0];
            for (k = 1; k <= i; ++k) {
                if (!(vv[k] > temp)) continue;
                temp = vv[k];
                next = k;
            }
            if (!(temp <= 0.0f)) continue;
            notargetColor = i + 1;
            break;
        }
        this.gm2 = null;
        byte[] tag = new byte[35937];
        for (k = 0; k < notargetColor; ++k) {
            this.mark(cube[k], k, tag);
            int weight = this.vol(cube[k], this.wt);
            if (weight != 0) {
                this.lut_r[k] = (byte)(this.vol(cube[k], this.mr) / weight);
                this.lut_g[k] = (byte)(this.vol(cube[k], this.mg) / weight);
                this.lut_b[k] = (byte)(this.vol(cube[k], this.mb) / weight);
                continue;
            }
            this.lut_b[k] = 0;
            this.lut_g[k] = 0;
            this.lut_r[k] = 0;
        }
        for (i = 0; i < this.size; ++i) {
            this.Qadd[i] = this.toInt(tag[this.Qadd[i]]);
        }
        return notargetColor;
    }

    public int[] getIndexMap() {
        return this.Qadd;
    }

    public byte[] getRedMap() {
        return this.lut_r;
    }

    public byte[] getGreenMap() {
        return this.lut_g;
    }

    public byte[] getBlueMap() {
        return this.lut_b;
    }

    void hist3d(int[] vwt, int[] vmr, int[] vmg, int[] vmb, float[] m2) {
        int i;
        int[] table = new int[256];
        for (i = 0; i < 256; ++i) {
            table[i] = i * i;
        }
        for (i = 0; i < this.size; ++i) {
            int ind;
            int r = this.toInt(this.Ir[i]);
            int g = this.toInt(this.Ig[i]);
            int b = this.toInt(this.Ib[i]);
            int inr = (r >> 3) + 1;
            int ing = (g >> 3) + 1;
            int inb = (b >> 3) + 1;
            this.Qadd[i] = ind = inr * 1089 + ing * 33 + inb;
            int n = ind;
            vwt[n] = vwt[n] + 1;
            int n2 = ind;
            vmr[n2] = vmr[n2] + r;
            int n3 = ind;
            vmg[n3] = vmg[n3] + g;
            int n4 = ind;
            vmb[n4] = vmb[n4] + b;
            int n5 = ind;
            m2[n5] = m2[n5] + (float)(table[r] + table[g] + table[b]);
        }
    }

    void m3d(int[] vwt, int[] vmr, int[] vmg, int[] vmb, float[] m2) {
        int[] area = new int[33];
        int[] area_r = new int[33];
        int[] area_g = new int[33];
        int[] area_b = new int[33];
        float[] area2 = new float[33];
        for (int r = 1; r <= 32; ++r) {
            for (int i = 0; i <= 32; ++i) {
                area_b[i] = 0;
                area_g[i] = 0;
                area_r[i] = 0;
                area[i] = 0;
                area2[i] = 0;
            }
            for (int g = 1; g <= 32; ++g) {
                int line_b = 0;
                int line_g = 0;
                int line_r = 0;
                int line = 0;
                float line2 = 0;
                for (int b = 1; b <= 32; ++b) {
                    int ind1 = r * 1089 + g * 33 + b;
                    line += vwt[ind1];
                    line_r += vmr[ind1];
                    line_g += vmg[ind1];
                    line_b += vmb[ind1];
                    line2 += m2[ind1];
                    int n = b;
                    area[n] = area[n] + line;
                    int n2 = b;
                    area_r[n2] = area_r[n2] + line_r;
                    int n3 = b;
                    area_g[n3] = area_g[n3] + line_g;
                    int n4 = b;
                    area_b[n4] = area_b[n4] + line_b;
                    int n5 = b;
                    area2[n5] = area2[n5] + line2;
                    int ind2 = ind1 - 1089;
                    vwt[ind1] = vwt[ind2] + area[b];
                    vmr[ind1] = vmr[ind2] + area_r[b];
                    vmg[ind1] = vmg[ind2] + area_g[b];
                    vmb[ind1] = vmb[ind2] + area_b[b];
                    m2[ind1] = m2[ind2] + area2[b];
                }
            }
        }
    }

    int vol(QuantizerBox cube, int[] mmt) {
        return mmt[cube.r1 * 1089 + cube.g1 * 33 + cube.b1] - mmt[cube.r1 * 1089 + cube.g1 * 33 + cube.b0] - mmt[cube.r1 * 1089 + cube.g0 * 33 + cube.b1] + mmt[cube.r1 * 1089 + cube.g0 * 33 + cube.b0] - mmt[cube.r0 * 1089 + cube.g1 * 33 + cube.b1] + mmt[cube.r0 * 1089 + cube.g1 * 33 + cube.b0] + mmt[cube.r0 * 1089 + cube.g0 * 33 + cube.b1] - mmt[cube.r0 * 1089 + cube.g0 * 33 + cube.b0];
    }

    int bottom(QuantizerBox cube, byte dir, int[] mmt) {
        switch (dir) {
            case 2: {
                return -mmt[cube.r0 * 1089 + cube.g1 * 33 + cube.b1] + mmt[cube.r0 * 1089 + cube.g1 * 33 + cube.b0] + mmt[cube.r0 * 1089 + cube.g0 * 33 + cube.b1] - mmt[cube.r0 * 1089 + cube.g0 * 33 + cube.b0];
            }
            case 1: {
                return -mmt[cube.r1 * 1089 + cube.g0 * 33 + cube.b1] + mmt[cube.r1 * 1089 + cube.g0 * 33 + cube.b0] + mmt[cube.r0 * 1089 + cube.g0 * 33 + cube.b1] - mmt[cube.r0 * 1089 + cube.g0 * 33 + cube.b0];
            }
        }
        return -mmt[cube.r1 * 1089 + cube.g1 * 33 + cube.b0] + mmt[cube.r1 * 1089 + cube.g0 * 33 + cube.b0] + mmt[cube.r0 * 1089 + cube.g1 * 33 + cube.b0] - mmt[cube.r0 * 1089 + cube.g0 * 33 + cube.b0];
    }

    int top(QuantizerBox cube, byte dir, int pos, int[] mmt) {
        switch (dir) {
            case 2: {
                return mmt[pos * 1089 + cube.g1 * 33 + cube.b1] - mmt[pos * 1089 + cube.g1 * 33 + cube.b0] - mmt[pos * 1089 + cube.g0 * 33 + cube.b1] + mmt[pos * 1089 + cube.g0 * 33 + cube.b0];
            }
            case 1: {
                return mmt[cube.r1 * 1089 + pos * 33 + cube.b1] - mmt[cube.r1 * 1089 + pos * 33 + cube.b0] - mmt[cube.r0 * 1089 + pos * 33 + cube.b1] + mmt[cube.r0 * 1089 + pos * 33 + cube.b0];
            }
        }
        return mmt[cube.r1 * 1089 + cube.g1 * 33 + pos] - mmt[cube.r1 * 1089 + cube.g0 * 33 + pos] - mmt[cube.r0 * 1089 + cube.g1 * 33 + pos] + mmt[cube.r0 * 1089 + cube.g0 * 33 + pos];
    }

    float var(QuantizerBox cube) {
        float dr = this.vol(cube, this.mr);
        float dg = this.vol(cube, this.mg);
        float db = this.vol(cube, this.mb);
        float xx = this.gm2[cube.r1 * 1089 + cube.g1 * 33 + cube.b1] - this.gm2[cube.r1 * 1089 + cube.g1 * 33 + cube.b0] - this.gm2[cube.r1 * 1089 + cube.g0 * 33 + cube.b1] + this.gm2[cube.r1 * 1089 + cube.g0 * 33 + cube.b0] - this.gm2[cube.r0 * 1089 + cube.g1 * 33 + cube.b1] + this.gm2[cube.r0 * 1089 + cube.g1 * 33 + cube.b0] + this.gm2[cube.r0 * 1089 + cube.g0 * 33 + cube.b1] - this.gm2[cube.r0 * 1089 + cube.g0 * 33 + cube.b0];
        return xx - (dr * dr + dg * dg + db * db) / (float)this.vol(cube, this.wt);
    }

    float maximize(QuantizerBox cube, byte dir, int first, int last, int[] cut, int whole_r, int whole_g, int whole_b, int whole_w) {
        int base_r = this.bottom(cube, dir, this.mr);
        int base_g = this.bottom(cube, dir, this.mg);
        int base_b = this.bottom(cube, dir, this.mb);
        int base_w = this.bottom(cube, dir, this.wt);
        float max = 0.0f;
        cut[0] = -1;
        for (int i = first; i < last; ++i) {
            int half_r = base_r + this.top(cube, dir, i, this.mr);
            int half_g = base_g + this.top(cube, dir, i, this.mg);
            int half_b = base_b + this.top(cube, dir, i, this.mb);
            int half_w = base_w + this.top(cube, dir, i, this.wt);
            if (half_w == 0) continue;
            float temp = ((float)half_r * (float)half_r + (float)half_g * (float)half_g + (float)half_b * (float)half_b) / (float)half_w;
            half_r = whole_r - half_r;
            half_g = whole_g - half_g;
            half_b = whole_b - half_b;
            if ((half_w = whole_w - half_w) == 0 || !((temp += ((float)half_r * (float)half_r + (float)half_g * (float)half_g + (float)half_b * (float)half_b) / (float)half_w) > max)) continue;
            max = temp;
            cut[0] = i;
        }
        return max;
    }

    int cut(QuantizerBox set1, QuantizerBox set2) {
        int dir;
        int[] cutr = new int[1];
        int[] cutg = new int[1];
        int[] cutb = new int[1];
        int whole_r = this.vol(set1, this.mr);
        int whole_g = this.vol(set1, this.mg);
        int whole_b = this.vol(set1, this.mb);
        int whole_w = this.vol(set1, this.wt);
        float maxr = this.maximize(set1, (byte)2, set1.r0 + 1, set1.r1, cutr, whole_r, whole_g, whole_b, whole_w);
        float maxg = this.maximize(set1, (byte)1, set1.g0 + 1, set1.g1, cutg, whole_r, whole_g, whole_b, whole_w);
        float maxb = this.maximize(set1, (byte)0, set1.b0 + 1, set1.b1, cutb, whole_r, whole_g, whole_b, whole_w);
        if (maxr >= maxg && maxr >= maxb) {
            dir = 2;
            if (cutr[0] < 0) {
                return 0;
            }
        } else {
            dir = maxg >= maxr && maxg >= maxb ? 1 : 0;
        }
        set2.r1 = set1.r1;
        set2.g1 = set1.g1;
        set2.b1 = set1.b1;
        switch (dir) {
            case 2: {
                set2.r0 = set1.r1 = cutr[0];
                set2.g0 = set1.g0;
                set2.b0 = set1.b0;
                break;
            }
            case 1: {
                set2.g0 = set1.g1 = cutg[0];
                set2.r0 = set1.r0;
                set2.b0 = set1.b0;
                break;
            }
            case 0: {
                set2.b0 = set1.b1 = cutb[0];
                set2.r0 = set1.r0;
                set2.g0 = set1.g0;
            }
        }
        set1.vol = (set1.r1 - set1.r0) * (set1.g1 - set1.g0) * (set1.b1 - set1.b0);
        set2.vol = (set2.r1 - set2.r0) * (set2.g1 - set2.g0) * (set2.b1 - set2.b0);
        return 1;
    }

    void mark(QuantizerBox cube, int label, byte[] tag) {
        for (int r = cube.r0 + 1; r <= cube.r1; ++r) {
            for (int g = cube.g0 + 1; g <= cube.g1; ++g) {
                for (int b = cube.b0 + 1; b <= cube.b1; ++b) {
                    tag[r * 1089 + g * 33 + b] = (byte)label;
                }
            }
        }
    }

    final int toInt(byte b) {
        return 0xFF & b;
    }
}

