/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.gif;

import java.util.Random;

public class ColorReduceFilter {
    byte[] red;
    byte[] green;
    byte[] blue;
    int width;
    int height;
    static final int LARGE_NUMBER = 1024;
    static final int JITTER_TABLE_SIZE = 1024;
    static final int JITTER_MASK = 1023;
    int[] irand;
    double[] uranx;
    double[] urany;
    Random random;

    public ColorReduceFilter(byte[] red, byte[] green, byte[] blue, int width, int height) {
        int i;
        this.red = red;
        this.blue = blue;
        this.green = green;
        this.width = width;
        this.height = height;
        this.irand = new int[1024];
        this.uranx = new double[1024];
        this.urany = new double[1024];
        this.random = new Random(System.currentTimeMillis());
        for (i = 0; i < 1024; ++i) {
            this.uranx[i] = (double)(this.random.nextInt() % 1024) / 1024.0;
        }
        for (i = 0; i < 1024; ++i) {
            this.urany[i] = (double)(this.random.nextInt() % 1024) / 1024.0;
        }
        for (i = 0; i < 1024; ++i) {
            this.irand[i] = (int)(1024.0 * ((double)(this.random.nextInt() % 1024) / 1024.0));
        }
    }

    public void reduce(int noiselevel) {
        byte[] rgb = new byte[3];
        int k = 0;
        noiselevel = noiselevel > 8 ? 8 : (noiselevel < 0 ? 0 : noiselevel);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                rgb[0] = this.red[k];
                rgb[1] = this.green[k];
                rgb[2] = this.blue[k];
                this.rgbvary(rgb, noiselevel, j, i);
                this.red[k] = rgb[0];
                this.green[k] = rgb[1];
                this.blue[k] = rgb[2];
                ++k;
            }
        }
    }

    public byte[] getRed() {
        return this.red;
    }

    public byte[] getGreen() {
        return this.green;
    }

    public byte[] getBlue() {
        return this.blue;
    }

    final double jitterx(int x, int y, int s) {
        return this.uranx[x + (y << 2) + this.irand[x + s & 0x3FF] & 0x3FF];
    }

    final double jittery(int x, int y, int s) {
        return this.urany[x + (y << 2) + this.irand[x + s & 0x3FF] & 0x3FF];
    }

    void rgbvary(byte[] rgb, int noise_level, int x, int y) {
        if (noise_level == 0) {
            int i = 0;
            while (i <= 2) {
                int n = i++;
                rgb[n] = (byte)(rgb[n] & 0xF8);
            }
            return;
        }
        for (int i = 0; i <= 2; ++i) {
            int c = this.toInt(rgb[i]);
            if (c >= 248) continue;
            int p = c % 8;
            int q = (int)(this.jitterx(x, y, i) * 9.0);
            if (p <= q) {
                rgb[i] = (byte)(c + 8);
            }
            q = 8 * ((int)(this.jittery(x, y, i) * (double)(2 * noise_level) + 0.5) - noise_level);
            if ((q += this.toInt(rgb[i])) >= 0 && q <= 255) {
                rgb[i] = (byte)q;
            }
            int n = i;
            rgb[n] = (byte)(rgb[n] & 0xF8);
        }
    }

    final int toInt(byte b) {
        return 0xFF & b;
    }
}

