/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BMPEncoder {
    int width;
    int height;
    int length;
    int[] pixels;
    byte[] red;
    byte[] green;
    byte[] blue;
    byte[] redTable;
    byte[] greenTable;
    byte[] blueTable;
    byte[] index;
    int nColors;
    boolean trueColor;

    public BMPEncoder(Image image) throws AWTException {
        int j;
        int i;
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        this.length = this.width * this.height;
        this.pixels = new int[this.length];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            if (!grabber.grabPixels()) {
                throw new AWTException("Grabber returned false: " + grabber.status());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.red = new byte[this.length];
        this.green = new byte[this.length];
        this.blue = new byte[this.length];
        int k = 0;
        for (i = this.height - 1; i >= 0; --i) {
            int offset = i * this.width;
            j = 0;
            while (j < this.width) {
                int value = this.pixels[offset + j];
                this.red[k] = (byte)(value & 0xFF);
                this.green[k] = (byte)(value >> 8 & 0xFF);
                this.blue[k] = (byte)(value >> 16 & 0xFF);
                ++j;
                ++k;
            }
        }
        this.redTable = new byte[256];
        this.greenTable = new byte[256];
        this.blueTable = new byte[256];
        this.index = new byte[this.length];
        this.nColors = 0;
        for (i = 0; i < this.length; ++i) {
            for (j = 0; j < this.nColors && (this.red[i] != this.redTable[j] || this.green[i] != this.greenTable[j] || this.blue[i] != this.blueTable[j]); ++j) {
            }
            if (j == this.nColors) {
                if (this.nColors >= 256) {
                    ++this.nColors;
                    break;
                }
                this.redTable[this.nColors] = this.red[i];
                this.greenTable[this.nColors] = this.green[i];
                this.blueTable[this.nColors] = this.blue[i];
                this.index[i] = (byte)(this.nColors & 0xFF);
                ++this.nColors;
                continue;
            }
            this.index[i] = (byte)(j & 0xFF);
        }
        this.trueColor = this.nColors > 256;
    }

    public void write(OutputStream out) throws IOException {
        byte[] bytes = null;
        if (!this.trueColor) {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream dout = new DataOutputStream(bstream);
            int end = 0;
            for (int i = 0; i < this.height; ++i) {
                int m;
                int start = i * this.width;
                end = (i + 1) * this.width;
                int start2 = start;
                do {
                    int len;
                    for (m = start2 + 1; m < end && this.index[m] == this.index[start2]; ++m) {
                    }
                    for (len = m - start2; len >= 255; len -= 255) {
                        dout.writeByte(255);
                        dout.writeByte(this.index[start2]);
                    }
                    if (len > 0) {
                        dout.writeByte(len);
                        dout.writeByte(this.index[start2]);
                    }
                    start2 = m;
                } while (m < end);
                dout.writeByte(0);
                dout.writeByte(0);
            }
            dout.writeByte(0);
            dout.writeByte(1);
            bytes = bstream.toByteArray();
        }
        byte[] bm = new byte[]{66, 77};
        out.write(bm, 0, 2);
        int zeropack = this.trueColor ? this.width * 3 % 4 : this.width % 4;
        if (zeropack != 0) {
            zeropack = 4 - zeropack;
        }
        if (this.trueColor) {
            this.writeDWord(out, 54 + (this.width * 3 + zeropack) * this.height);
        } else {
            this.writeDWord(out, 1078 + bytes.length);
        }
        this.writeWord(out, 0);
        this.writeWord(out, 0);
        if (this.trueColor) {
            this.writeDWord(out, 54);
        } else {
            this.writeDWord(out, 1078);
        }
        this.writeDWord(out, 40);
        this.writeDWord(out, this.width);
        this.writeDWord(out, this.height);
        this.writeWord(out, 1);
        if (this.trueColor) {
            this.writeWord(out, 24);
            this.writeDWord(out, 0);
            this.writeDWord(out, 3 * this.width * this.height);
        } else {
            this.writeWord(out, 8);
            this.writeDWord(out, 1);
            this.writeDWord(out, bytes.length);
        }
        this.writeDWord(out, 0);
        this.writeDWord(out, 0);
        if (this.trueColor) {
            this.writeDWord(out, 0);
            this.writeDWord(out, 0);
        } else {
            this.writeDWord(out, 256);
            this.writeDWord(out, 256);
        }
        if (!this.trueColor) {
            for (int i = 0; i < 256; ++i) {
                out.write(this.redTable[i]);
                out.write(this.greenTable[i]);
                out.write(this.blueTable[i]);
                out.write(0);
            }
        }
        if (this.trueColor) {
            byte[] b = null;
            byte[] c = new byte[3];
            if (zeropack != 0) {
                b = new byte[zeropack];
            }
            int k = 0;
            for (int i = this.height - 1; i >= 0; --i) {
                int j = 0;
                while (j < this.width) {
                    c[0] = this.red[k];
                    c[1] = this.green[k];
                    c[2] = this.blue[k];
                    out.write(c, 0, 3);
                    ++j;
                    ++k;
                }
                if (zeropack == 0) continue;
                out.write(b, 0, zeropack);
            }
        } else {
            out.write(bytes, 0, bytes.length);
        }
    }

    void writeWord(OutputStream out, int w) throws IOException {
        short sw = (short)w;
        out.write((byte)(sw & 0xFF));
        out.write((byte)(sw >> 8 & 0xFF));
    }

    void writeDWord(OutputStream out, int w) throws IOException {
        out.write((byte)(w & 0xFF));
        out.write((byte)(w >> 8 & 0xFF));
        out.write((byte)(w >> 16 & 0xFF));
        out.write((byte)(w >> 24 & 0xFF));
    }
}

