/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.awt.Component;
import java.io.OutputStream;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ExportChart;
import quadbase.common.util.flash.FlashGraphics;
import quadbase.util.PickData;

public class FlashEncoder {
    public static void createFlashImage(ExportChart exportChart, OutputStream out, int width, int height, Component component, boolean generateDrillDownLink, String chartFile, String servletLoc, PickData[] pickData, String[] argv) throws Exception {
        if (out == null) {
            return;
        }
        Chart chart = exportChart.getChart();
        CGraphics.fieldDrillDownMap = false;
        CGraphics.drillDownMap = false;
        FlashGraphics buffer = null;
        try {
            if (generateDrillDownLink) {
                if (chart.currentNode != null && chart.currentNode.getRoot().getChildCount() > 0) {
                    CGraphics.fieldDrillDownMap = true;
                } else {
                    CGraphics.drillDownMap = true;
                }
            }
            buffer = new FlashGraphics(width, height, chart);
            String loc = chartFile;
            if (chart.isFieldDrillDownEnabled() && servletLoc != null) {
                loc = chart.currentNode.getChildAt(0).getFileName();
            }
            buffer.setDrillDownInfo(loc, servletLoc, pickData, argv);
            buffer.initFrameSet(chart.flashFrameCount);
            chart.draw(buffer, component, width, height);
            buffer.export(out);
            buffer.dispose();
        }
        catch (Exception ex) {
            if (buffer != null) {
                try {
                    buffer.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            CGraphics.drillDownMap = false;
            CGraphics.fieldDrillDownMap = false;
            throw ex;
        }
        CGraphics.drillDownMap = false;
        CGraphics.fieldDrillDownMap = false;
    }

    public static void encode(Chart chart, OutputStream out, int width, int height, Component component) throws Exception {
        FlashGraphics buffer = new FlashGraphics(width, height, chart);
        buffer.initFrameSet(chart.flashFrameCount);
        chart.draw(buffer, component, width, height);
        try {
            buffer.export(out);
            buffer.dispose();
        }
        catch (Exception ex) {
            try {
                buffer.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }
}

