/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import quadbase.chart.Chart;
import quadbase.chart.GradientSupport;
import quadbase.chart.QbPattern;
import quadbase.common.util.flash.FlashGraphics;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.IQbGraphics;
import quadbase.common.util.internal.QbGraphics;
import quadbase.util.IGradientSupport;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.IWMFGraphics;
import quadbase.util.internal.SVGEncoder;
import quadbase.util.internal.WMFGraphics;

public class Graphics2DTool {
    public static Shape drawCircle(double centerX, double centerY, double w) {
        return new Ellipse2D.Double(centerX - w / 2.0, centerY - w / 2.0, w, w);
    }

    private static Area intersect(Shape shape1, Shape shape2) {
        Area area1 = new Area(shape1);
        Area area2 = new Area(shape2);
        area1.intersect(area2);
        return area1;
    }

    public static void fillIntersect(Graphics g, Polygon shape1, Shape shape2) {
        Color gColor = g.getColor();
        if (gColor instanceof QbPattern) {
            Graphics2DTool.fillPatternIntersect(g, (QbPattern)gColor, shape1, shape2);
            return;
        }
        if (g instanceof IWMFGraphics || g instanceof IFlashGraphics) {
            g.fillPolygon(shape1);
            return;
        }
        if (g instanceof IQbGraphics && shape2 instanceof Ellipse2D.Double) {
            Ellipse2D.Double circle = (Ellipse2D.Double)shape2;
            ((IQbGraphics)((Object)g)).fillIntersect(shape1, circle.getX(), circle.getY(), circle.getWidth());
            return;
        }
        Area area = Graphics2DTool.intersect(shape1, shape2);
        ((Graphics2D)g).fill(area);
    }

    public static GeneralPath fillOpenArc(Graphics g, int x2, int y2, int width, int height2, int startAngle, int arcAngle, int arcLen, Color bgColor) {
        GeneralPath path = null;
        if (g instanceof IWMFGraphics) {
            g.fillArc(x2, y2, width, height2, startAngle, arcAngle);
            int i = arcLen;
            Color orgColor = g.getColor();
            g.setColor(bgColor);
            g.fillArc(x2 + i, y2 + i, width - 2 * i, height2 - 2 * i, startAngle - 2, arcAngle + 4);
            g.setColor(orgColor);
            return null;
        }
        if (g instanceof IFlashGraphics || g instanceof Graphics2D) {
            path = new GeneralPath();
            Arc2D.Double innerArc = new Arc2D.Double(x2 + arcLen, y2 + arcLen, width - 2 * arcLen, height2 - 2 * arcLen, startAngle + arcAngle, -arcAngle, 0);
            Arc2D.Double outerArc = new Arc2D.Double(x2, y2, width, height2, startAngle, arcAngle, 0);
            path.append(innerArc, false);
            path.append(outerArc, true);
            path.closePath();
            if (g instanceof IFlashGraphics) {
                ((IFlashGraphics)((Object)g)).fill(path);
            } else {
                ((Graphics2D)g).fill(path);
            }
            return path;
        }
        if (g instanceof IQbGraphics) {
            BasicStroke orgstroke = new BasicStroke();
            BasicStroke stroke = new BasicStroke(2.0f);
            ((IQbGraphics)((Object)g)).setBasicStroke(stroke.getLineWidth(), stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), stroke.getDashArray(), stroke.getDashPhase());
            for (int i = 0; i < arcLen; ++i) {
                if (i != 0) {
                    ((IQbGraphics)((Object)g)).drawArc2D(x2 + i, y2 + i, width - 2 * i, height2 - 2 * i, startAngle, arcAngle, 0);
                    continue;
                }
                g.drawArc(x2 + i, y2 + i, width - 2 * i, height2 - 2 * i, startAngle, arcAngle);
            }
            ((IQbGraphics)((Object)g)).setBasicStroke(orgstroke.getLineWidth(), orgstroke.getEndCap(), orgstroke.getLineJoin(), orgstroke.getMiterLimit(), orgstroke.getDashArray(), orgstroke.getDashPhase());
        }
        return null;
    }

    public static void drawIntersect(Graphics g, Polygon shape1, Shape shape2, int thickness) {
        if (g instanceof IWMFGraphics || g instanceof IFlashGraphics) {
            g.drawPolygon(shape1);
            return;
        }
        if (g instanceof IQbGraphics) {
            Ellipse2D.Double circle = (Ellipse2D.Double)shape2;
            ((IQbGraphics)((Object)g)).drawIntersect(shape1, circle.getX(), circle.getY(), circle.getWidth(), thickness);
            return;
        }
        Area area = Graphics2DTool.intersect(shape1, shape2);
        Stroke orgStroke = ((Graphics2D)g).getStroke();
        BasicStroke basicStroke = new BasicStroke(thickness, 0, 0);
        ((Graphics2D)g).setStroke(basicStroke);
        ((Graphics2D)g).draw(area);
        ((Graphics2D)g).setStroke(orgStroke);
    }

    private static void setTexturePaint(Graphics g, QbPattern texturePattern) {
        if (g instanceof IQbGraphics) {
            BufferedImage bImage = texturePattern.getPatternImage();
            if (bImage == null) {
                g.setColor(texturePattern);
                return;
            }
            ((IQbGraphics)((Object)g)).setTexturePaint(texturePattern.getPatternTypeID(), texturePattern);
        } else {
            if (g instanceof IFlashGraphics || IOUtil.isSVGIncluded() && SVGEncoder.isSVGGraphics(g)) {
                g.setColor(texturePattern);
                return;
            }
            if (g instanceof Graphics2D) {
                BufferedImage bImage = texturePattern.getPatternImage();
                if (bImage == null) {
                    g.setColor(texturePattern);
                    return;
                }
                Rectangle2D.Double tr = new Rectangle2D.Double(0.0, 0.0, bImage.getWidth(), bImage.getHeight());
                TexturePaint tp = new TexturePaint(bImage, tr);
                ((Graphics2D)g).setPaint(tp);
            } else {
                g.setColor(texturePattern);
                return;
            }
        }
    }

    public static void fillPatternRect(Graphics g, QbPattern pattern, int x, int y, int w, int h) {
        Graphics2DTool.setTexturePaint(g, pattern);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).fillRect(x, y, w, h);
        } else {
            g.fillRect(x, y, w, h);
        }
    }

    public static void fillPatternOval(Graphics g, QbPattern pattern, int x, int y, int w, int h) {
        Graphics2DTool.setTexturePaint(g, pattern);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).fillOval(x, y, w, h);
        } else {
            g.fillOval(x, y, w, h);
        }
    }

    public static void fillPatternArc(Graphics g, QbPattern pattern, int x, int y, int w, int h, int startAngle, int arcAngle) {
        Graphics2DTool.setTexturePaint(g, pattern);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).fillArc(x, y, w, h, startAngle, arcAngle);
        } else {
            g.fillArc(x, y, w, h, startAngle, arcAngle);
        }
    }

    public static GeneralPath fillPatternOpenArc(Graphics g, QbPattern pattern, int x, int y, int w, int h, int startAngle, int arcAngle, int arcLen, Color bgColor) {
        Graphics2DTool.setTexturePaint(g, pattern);
        return Graphics2DTool.fillOpenArc(g, x, y, w, h, startAngle, arcAngle, arcLen, bgColor);
    }

    public static void fillPatternPolygon(Graphics g, QbPattern pattern, Polygon p) {
        Graphics2DTool.setTexturePaint(g, pattern);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).fillPolygon(p);
        } else {
            g.fillPolygon(p);
        }
    }

    public static void fillPatternShape(Graphics g, QbPattern pattern, Shape shape) {
        Graphics2DTool.setTexturePaint(g, pattern);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).fill(shape);
        } else if (g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g)).fill(shape);
        }
    }

    private static void fillPatternIntersect(Graphics g, QbPattern pattern, Polygon shape1, Shape shape2) {
        if (g instanceof IWMFGraphics || g instanceof IFlashGraphics) {
            g.fillPolygon(shape1);
            return;
        }
        if (g instanceof IQbGraphics && shape2 instanceof Ellipse2D.Double) {
            Ellipse2D.Double circle = (Ellipse2D.Double)shape2;
            ((IQbGraphics)((Object)g)).fillIntersect(shape1, circle.getX(), circle.getY(), circle.getWidth());
            return;
        }
        Area area = Graphics2DTool.intersect(shape1, shape2);
        Graphics2DTool.setTexturePaint(g, pattern);
        ((Graphics2D)g).fill(area);
    }

    public static void fillGradientRect(Graphics g, Chart chart, IGradientSupport gradientSupport, Color color, int x, int y, int w, int h) {
        Graphics2DTool.fillGradientRect(g, chart, color, x, y, w, h, gradientSupport.getGradientStartX(), gradientSupport.getGradientStartY(), gradientSupport.getGradientEndX(), gradientSupport.getGradientEndY(), gradientSupport.getGradientDesColor(), gradientSupport.getGradientShade(), gradientSupport.isGradientCyclic(), gradientSupport.isGradientEnabled(), gradientSupport.is3DShadingEnabled());
    }

    private static void fillGradientRect(Graphics g, Chart chart, Color c, int x, int y, int w, int h, double startX, double startY, double endX, double endY, Color desColor, int shade, boolean cyclic, boolean isGradientAllowed, boolean is3DShadingOn) {
        if (g instanceof IQbGraphics) {
            if (is3DShadingOn && Graphics2DTool.is3DShadingOn(chart, true)) {
                ((IQbGraphics)((Object)g)).setGradientPaint(x, y + h / 2, c, x + w / 2, h / 2 + y, Graphics2DTool.getBrighter(c), true);
            } else if (is3DShadingOn && Graphics2DTool.is3DShadingOn(chart, false)) {
                ((IQbGraphics)((Object)g)).setGradientPaint(x + w / 2, y, c, x + w / 2, h / 2 + y, Graphics2DTool.getBrighter(c), true);
            } else {
                Color color2 = desColor;
                if (desColor == null) {
                    color2 = shade > 0 ? Graphics2DTool.getDarker(c, shade) : Graphics2DTool.getBrighter(c, Math.abs(shade));
                }
                ((IQbGraphics)((Object)g)).setGradientPaint(x + (int)((double)w * startX), y + (int)((double)h * startY), c, x + (int)((double)w * endX), (int)((double)h * endY) + y, color2, cyclic);
            }
        } else if (g instanceof Graphics2D || g instanceof IFlashGraphics) {
            GradientPaint gradientPaint = null;
            if (is3DShadingOn && Graphics2DTool.is3DShadingOn(chart, true)) {
                gradientPaint = new GradientPaint(x, y + h / 2, c, x + w / 2, h / 2 + y, Graphics2DTool.getBrighter(c), true);
            } else if (is3DShadingOn && Graphics2DTool.is3DShadingOn(chart, false)) {
                gradientPaint = new GradientPaint(x + w / 2, y, c, x + w / 2, h / 2 + y, Graphics2DTool.getBrighter(c), true);
            } else {
                Color color2 = desColor;
                if (desColor == null) {
                    color2 = shade > 0 ? Graphics2DTool.getDarker(c, shade) : Graphics2DTool.getBrighter(c, Math.abs(shade));
                }
                gradientPaint = new GradientPaint(x + (int)((double)w * startX), y + (int)((double)h * startY), c, x + (int)((double)w * endX), (int)((double)h * endY) + y, color2, cyclic);
            }
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setPaint(gradientPaint);
            } else {
                ((IFlashGraphics)((Object)g)).setGradientPaint(gradientPaint);
            }
        }
        g.fillRect(x, y, w, h);
    }

    public static void fillGradient3DRect(Graphics g, IGradientSupport gradientSupport, Color c, int x, int y, int w, int h, boolean raised) {
        double startX = gradientSupport.getGradientStartX();
        double startY = gradientSupport.getGradientStartY();
        double endX = gradientSupport.getGradientEndX();
        double endY = gradientSupport.getGradientEndY();
        Color desColor = gradientSupport.getGradientDesColor();
        int shade = gradientSupport.getGradientShade();
        boolean cyclic = gradientSupport.isGradientCyclic();
        if (g instanceof IQbGraphics) {
            Color color2 = desColor;
            if (desColor == null) {
                color2 = shade > 0 ? Graphics2DTool.getDarker(c, shade) : Graphics2DTool.getBrighter(c, Math.abs(shade));
            }
            ((IQbGraphics)((Object)g)).setGradientPaint(x + (int)((double)w * startX), y + (int)((double)h * startY), c, x + (int)((double)w * endX), (int)((double)h * endY) + y, color2, cyclic);
        } else if (g instanceof Graphics2D || g instanceof IFlashGraphics) {
            GradientPaint gradientPaint = null;
            Color color2 = desColor;
            if (desColor == null) {
                color2 = shade > 0 ? Graphics2DTool.getDarker(c, shade) : Graphics2DTool.getBrighter(c, Math.abs(shade));
            }
            gradientPaint = new GradientPaint(x + (int)((double)w * startX), y + (int)((double)h * startY), c, x + (int)((double)w * endX), (int)((double)h * endY) + y, color2, cyclic);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setPaint(gradientPaint);
            } else {
                ((IFlashGraphics)((Object)g)).setGradientPaint(gradientPaint);
            }
        }
        g.fill3DRect(x, y, w, h, raised);
    }

    public static void fillGradientOval(Graphics g, Chart chart, Color color, int x, int y, int w, int h, IGradientSupport gradientSupport) {
        double startX = gradientSupport.getGradientStartX();
        double startY = gradientSupport.getGradientStartY();
        double endX = gradientSupport.getGradientEndX();
        double endY = gradientSupport.getGradientEndY();
        Color desColor = gradientSupport.getGradientDesColor();
        int shade = gradientSupport.getGradientShade();
        boolean cyclic = gradientSupport.isGradientCyclic();
        Color color2 = desColor;
        if (desColor == null) {
            color2 = shade > 0 ? Graphics2DTool.getDarker(color, shade) : Graphics2DTool.getBrighter(color, Math.abs(shade));
        }
        if (g instanceof IQbGraphics) {
            ((IQbGraphics)((Object)g)).setGradientPaint(x + (int)((double)w * startX), y + (int)((double)h * startY), color, x + (int)((double)w * endX), (int)((double)h * endY) + y, color2, cyclic);
        } else if (g instanceof Graphics2D || g instanceof IFlashGraphics) {
            GradientPaint gradientPaint = new GradientPaint(x + (int)((double)w * startX), y + (int)((double)h * startY), color, x + (int)((double)w * endX), (int)((double)h * endY) + y, color2, cyclic);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setPaint(gradientPaint);
            } else {
                ((IFlashGraphics)((Object)g)).setGradientPaint(gradientPaint);
            }
        }
        g.fillOval(x, y, w, h);
    }

    public static void fillGradientArc(Graphics g, Chart chart, Color color, int x, int y, int w, int h, int startAngle, int arcAngle) {
        GradientSupport gradientSupport = chart.getPrimaryDataGradientSupport();
        double startX = gradientSupport.getGradientStartX();
        double startY = gradientSupport.getGradientStartY();
        double endX = gradientSupport.getGradientEndX();
        double endY = gradientSupport.getGradientEndY();
        Color desColor = gradientSupport.getGradientDesColor();
        int shade = gradientSupport.getGradientShade();
        boolean cyclic = gradientSupport.isGradientCyclic();
        Color color2 = desColor;
        if (desColor == null) {
            color2 = shade > 0 ? Graphics2DTool.getDarker(color, shade) : Graphics2DTool.getBrighter(color, Math.abs(shade));
        }
        if (g instanceof IQbGraphics) {
            ((IQbGraphics)((Object)g)).setGradientPaint(x + (int)((double)w * startX), y + (int)((double)h * startY), color, x + (int)((double)w * endX), (int)((double)h * endY) + y, color2, cyclic);
        } else if (g instanceof Graphics2D || g instanceof IFlashGraphics) {
            GradientPaint gradientPaint = new GradientPaint(x + (int)((double)w * startX), y + (int)((double)h * startY), color, x + (int)((double)w * endX), (int)((double)h * endY) + y, color2, cyclic);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setPaint(gradientPaint);
            } else {
                ((IFlashGraphics)((Object)g)).setGradientPaint(gradientPaint);
            }
        }
        g.fillArc(x, y, w, h, startAngle, arcAngle);
    }

    public static GeneralPath fillGradientOpenArc(Graphics g, Chart chart, Color color, int x, int y, int w, int h, int startAngle, int arcAngle, int arcLen, Color bgColor) {
        GradientSupport gradientSupport = chart.getPrimaryDataGradientSupport();
        double startX = gradientSupport.getGradientStartX();
        double startY = gradientSupport.getGradientStartY();
        double endX = gradientSupport.getGradientEndX();
        double endY = gradientSupport.getGradientEndY();
        Color desColor = gradientSupport.getGradientDesColor();
        int shade = gradientSupport.getGradientShade();
        boolean cyclic = gradientSupport.isGradientCyclic();
        Color color2 = desColor;
        if (desColor == null) {
            color2 = shade > 0 ? Graphics2DTool.getDarker(color, shade) : Graphics2DTool.getBrighter(color, Math.abs(shade));
        }
        if (g instanceof IQbGraphics) {
            ((IQbGraphics)((Object)g)).setGradientPaint(x + (int)((double)w * startX), y + (int)((double)h * startY), color, x + (int)((double)w * endX), (int)((double)h * endY) + y, color2, cyclic);
        } else if (g instanceof Graphics2D || g instanceof IFlashGraphics) {
            GradientPaint gradientPaint = new GradientPaint(x + (int)((double)w * startX), y + (int)((double)h * startY), color, x + (int)((double)w * endX), (int)((double)h * endY) + y, color2, cyclic);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setPaint(gradientPaint);
            } else {
                ((IFlashGraphics)((Object)g)).setGradientPaint(gradientPaint);
            }
        }
        return Graphics2DTool.fillOpenArc(g, x, y, w, h, startAngle, arcAngle, arcLen, bgColor);
    }

    public static void fillGradientPolygon(Graphics g, Chart chart, Color color, Polygon p, IGradientSupport gradientSupport) {
        int y2;
        int x2;
        int y1;
        int x1;
        double startX = gradientSupport.getGradientStartX();
        double startY = gradientSupport.getGradientStartY();
        double endX = gradientSupport.getGradientEndX();
        double endY = gradientSupport.getGradientEndY();
        Color desColor = gradientSupport.getGradientDesColor();
        int shade = gradientSupport.getGradientShade();
        boolean cyclic = gradientSupport.isGradientCyclic();
        Color color2 = desColor;
        if (desColor == null) {
            color2 = shade > 0 ? Graphics2DTool.getDarker(color, shade) : Graphics2DTool.getBrighter(color, Math.abs(shade));
        }
        if (Graphics2DTool.isOneGradientArea(chart)) {
            if (chart.is2DimChart()) {
                x1 = chart.chartxorigin + (int)((double)chart.chartwidth * startX);
                y1 = chart.winHeight - chart.chartyorigin - chart.chartheight + (int)((double)chart.chartheight * startY);
                x2 = chart.chartxorigin + (int)((double)chart.chartwidth * endX);
                y2 = chart.winHeight - chart.chartyorigin - chart.chartheight + (int)((double)chart.chartheight * endY);
            } else {
                x1 = chart.xboundmin;
                y1 = chart.yboundmin;
                x2 = chart.xboundmax;
                y2 = chart.yboundmax;
            }
        } else {
            Rectangle rect = p.getBounds();
            x1 = rect.x + (int)((double)rect.width * startX);
            y1 = rect.y + (int)((double)rect.height * startY);
            x2 = rect.x + (int)((double)rect.width * endX);
            y2 = rect.y + (int)((double)rect.height * endY);
        }
        if (g instanceof IQbGraphics) {
            ((IQbGraphics)((Object)g)).setGradientPaint(x1, y1, color, x2, y2, color2, cyclic);
        } else if (g instanceof Graphics2D || g instanceof IFlashGraphics) {
            GradientPaint gradientPaint = new GradientPaint(x1, y1, color, x2, y2, color2, cyclic);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setPaint(gradientPaint);
            } else {
                ((IFlashGraphics)((Object)g)).setGradientPaint(gradientPaint);
            }
        }
        g.fillPolygon(p);
    }

    public static void fillGradientShape(Graphics g, Chart chart, Color color, Shape shape) {
        int y2;
        int x2;
        int y1;
        int x1;
        GradientSupport gradientSupport = chart.getPrimaryDataGradientSupport();
        double startX = gradientSupport.getGradientStartX();
        double startY = gradientSupport.getGradientStartY();
        double endX = gradientSupport.getGradientEndX();
        double endY = gradientSupport.getGradientEndY();
        Color desColor = gradientSupport.getGradientDesColor();
        int shade = gradientSupport.getGradientShade();
        boolean cyclic = gradientSupport.isGradientCyclic();
        Color color2 = desColor;
        if (desColor == null) {
            color2 = shade > 0 ? Graphics2DTool.getDarker(color, shade) : Graphics2DTool.getBrighter(color, Math.abs(shade));
        }
        if (Graphics2DTool.isOneGradientArea(chart)) {
            if (chart.is2DimChart()) {
                x1 = chart.chartxorigin + (int)((double)chart.chartwidth * startX);
                y1 = chart.winHeight - chart.chartyorigin - chart.chartheight + (int)((double)chart.chartheight * startY);
                x2 = chart.chartxorigin + (int)((double)chart.chartwidth * endX);
                y2 = chart.winHeight - chart.chartyorigin - chart.chartheight + (int)((double)chart.chartheight * endY);
            } else {
                x1 = chart.xboundmin;
                y1 = chart.yboundmin;
                x2 = chart.xboundmax;
                y2 = chart.yboundmax;
            }
        } else {
            Rectangle rect = shape.getBounds();
            x1 = rect.x + (int)((double)rect.width * startX);
            y1 = rect.y + (int)((double)rect.height * startY);
            x2 = rect.x + (int)((double)rect.width * endX);
            y2 = rect.y + (int)((double)rect.height * endY);
        }
        if (g instanceof IQbGraphics) {
            ((IQbGraphics)((Object)g)).setGradientPaint(x1, y1, color, x2, y2, color2, cyclic);
        } else if (g instanceof Graphics2D || g instanceof IFlashGraphics) {
            GradientPaint gradientPaint = new GradientPaint(x1, y1, color, x2, y2, color2, cyclic);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setPaint(gradientPaint);
            } else {
                ((IFlashGraphics)((Object)g)).setGradientPaint(gradientPaint);
            }
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).fill(shape);
        } else if (g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g)).fill(shape);
        }
    }

    private static boolean isOneGradientArea(Chart chart) {
        if (chart == null) {
            return false;
        }
        return chart.getChartType() == 7 || chart.getChartType() == 8 || chart.getChartType() == 14 || !chart.is2DimChart() && chart.getChartType() == 6 || !chart.is2DimChart() && chart.getChartType() == 20 || !chart.is2DimChart() && chart.getChartType() == 3 || !chart.is2DimChart() && chart.mData2 != null;
    }

    private static boolean is3DShadingOn(Chart chart, boolean isVert) {
        if (!chart.is2DimChart()) {
            return false;
        }
        int type = chart.getChartType();
        return isVert ? type == 0 || type == 4 || type == 11 || type == 14 : type == 1 || type == 5;
    }

    private static Color getBrighter(Color c) {
        return Graphics2DTool.getBrighter(c, 2);
    }

    public static Color getBrighter(Color c, int level) {
        Color newColor = c;
        if (c.getRed() >= 179 || c.getGreen() >= 179 || c.getBlue() >= 179) {
            newColor = new Color(Math.max(c.getRed(), 40), Math.max(c.getGreen(), 40), Math.max(c.getBlue(), 40));
        }
        for (int i = 0; i < level; ++i) {
            newColor = newColor.brighter();
        }
        return newColor;
    }

    public static Color getDarker(Color c, int level) {
        Color newColor = c;
        for (int i = 0; i < level; ++i) {
            newColor = newColor.darker();
        }
        return newColor;
    }

    public static boolean drawShape(Graphics g, Shape shape, int thickness, float[] dash) {
        if (g instanceof WMFGraphics) {
            return false;
        }
        if (g instanceof IFlashGraphics) {
            ((FlashGraphics)g).draw(shape, thickness);
            return true;
        }
        if (g instanceof QbGraphics) {
            BasicStroke stroke = new BasicStroke(thickness, 0, 1, 10.0f, dash, 0.0f);
            ((QbGraphics)g).fill(stroke.createStrokedShape(shape));
            return true;
        }
        if (g instanceof Graphics2D) {
            BasicStroke stroke = new BasicStroke(thickness, 0, 1, 10.0f, dash, 0.0f);
            ((Graphics2D)g).fill(stroke.createStrokedShape(shape));
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void drawArrow(Graphics g, int chartHeight, int x1, int y1, int x2, int y2, int thick) {
        int i;
        if (thick < 3) {
            ++thick;
        }
        double len = Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
        int arrh = (int)Math.rint((double)thick * 8.0 / 3.0);
        int arrw = (int)Math.rint((double)thick * 5.0);
        int arrd = (int)Math.rint((double)thick * 10.0 / 3.0);
        int y = (int)Math.rint(len + (double)y1 + (double)thick * 3.0 / 4.0);
        int[] yp = new int[]{y, y - arrw, y - arrd, y - arrw};
        int[] xp = new int[]{x1, x1 + arrh, x1, x1 - arrh};
        int[] ptX = new int[4];
        int[] ptY = new int[4];
        double angle = 0.0;
        if (y1 - y2 == 0) {
            if (x2 > x1) {
                angle = 1.5707963267948966;
            } else {
                if (x2 >= x1) return;
                angle = 4.71238898038469;
            }
        } else if (x2 - x1 == 0) {
            if (y2 > y1) {
                angle = 0.0;
            } else {
                if (y2 >= y1) return;
                angle = Math.PI;
            }
        } else {
            angle = Math.atan((double)(x2 - x1) / (double)(y2 - y1));
            if (y2 < y1) {
                angle += Math.PI;
            }
        }
        for (i = 0; i < xp.length; ++i) {
            double width = x1 - xp[i];
            double height = yp[i] - y1;
            double len2 = Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
            double angle2 = angle + Math.atan(width / height);
            ptX[i] = x1 + (int)Math.rint(Math.sin(angle2) * len2);
            ptY[i] = y1 + (int)Math.rint(Math.cos(angle2) * len2);
        }
        for (i = 0; i < ptY.length; ++i) {
            ptY[i] = chartHeight - ptY[i];
        }
        g.fillPolygon(new Polygon(ptX, ptY, ptX.length));
    }
}

