/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.applet.Applet;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.text.NumberFormat;
import quadbase.chart.Chart;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.util.ColorSpectrum;
import quadbase.util.DateTimeFormat;
import quadbase.util.LocaleDateTimeFormat;
import quadbase.util.LocaleNumericFormat;
import quadbase.util.NumericFormat;
import quadbase.util.internal.Coder;

public final class IOUtil {
    public static boolean isUsingEspressOrganizerApplet = false;
    private static Boolean isJava2D = null;
    private static Boolean isJava14 = null;
    private static Boolean isJimiIncluded = null;
    private static Boolean isSVGIncluded = null;
    private static Boolean isFlashIncluded = null;
    private static Boolean isMac = null;

    public static final String readString(DataInput in, boolean isUTF) throws IOException {
        byte c;
        if (isUTF) {
            return in.readUTF();
        }
        int size = 60;
        byte[] barray = new byte[size];
        int i = 0;
        while ((c = in.readByte()) != 0) {
            barray[i++] = c;
            if (i != size) continue;
            byte[] barray2 = new byte[2 * size];
            System.arraycopy(barray, 0, barray2, 0, size);
            size = (short)(size * 2);
            barray = barray2;
        }
        return new String(barray, 0, i);
    }

    public static final String readString(VersioningDataInput in, short featureVersion, short type) throws IOException {
        return in.readUTF(featureVersion, type);
    }

    public static final void writeString(DataOutput out, String string) throws IOException {
        if (string == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(string);
        }
    }

    public static final void writeString(DataOutput out, String string, short version) throws IOException {
        VersioningDataOutput vdo = (VersioningDataOutput)out;
        if (string == null) {
            vdo.writeUTF("", version);
        } else {
            vdo.writeUTF(string, version);
        }
    }

    public static final void writeStr(DataOutput out, String string) throws IOException {
        if (string == null) {
            out.writeBoolean(true);
        } else {
            out.writeBoolean(false);
            out.writeUTF(string);
        }
    }

    public static final void writeColor(DataOutput out, Color color) throws IOException {
        out.writeInt(color.getRGB());
    }

    public static final void writeColor(DataOutput out, Color color, short version) throws IOException {
        VersioningDataOutput vdo = (VersioningDataOutput)out;
        vdo.writeInt(color.getRGB(), version);
    }

    public static final Color readColor(DataInput in) throws IOException {
        return new Color(in.readInt());
    }

    public static final void writeColorList(DataOutput out, Color[] carray) throws IOException {
        int size = carray != null ? carray.length : -1;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeInt(carray[i].getRGB());
        }
    }

    public static final void writeColorList(DataOutput out, Color[] carray, short version) throws IOException {
        int size = carray != null ? carray.length : -1;
        VersioningDataOutput vdo = (VersioningDataOutput)out;
        vdo.writeInt(size, version);
        for (int i = 0; i < size; ++i) {
            vdo.writeInt(carray[i].getRGB(), version);
        }
    }

    public static final Color[] readColorList(DataInput in) throws IOException {
        int size = in.readInt();
        if (size < 0) {
            return null;
        }
        Color[] carray = new Color[size];
        for (int i = 0; i < size; ++i) {
            carray[i] = new Color(in.readInt());
        }
        return carray;
    }

    public static final void writeFont(DataOutput out, Font font) throws IOException {
        IOUtil.writeString(out, font.getName());
        out.writeInt(font.getStyle());
        out.writeInt(font.getSize());
    }

    public static final void writeFont(DataOutput out, Font font, short version) throws IOException {
        VersioningDataOutput vdo = (VersioningDataOutput)out;
        IOUtil.writeString(vdo, font.getName(), version);
        vdo.writeInt(font.getStyle(), version);
        vdo.writeInt(font.getSize(), version);
    }

    public static final Font readFont(DataInput in, boolean isUTF) throws IOException {
        return new Font(IOUtil.readString(in, isUTF), in.readInt(), in.readInt());
    }

    public static final void writeFloats(DataOutput out, float[] farray, int size) throws IOException {
        for (int i = 0; i < size; ++i) {
            out.writeFloat(farray[i]);
        }
    }

    public static final float[] readFloats(DataInput in, int size) throws IOException {
        float[] farray = new float[size];
        for (int i = 0; i < size; ++i) {
            farray[i] = in.readFloat();
        }
        return farray;
    }

    public static final void writeInts(DataOutput out, int[] iarray, int size) throws IOException {
        for (int i = 0; i < size; ++i) {
            out.writeInt(iarray[i]);
        }
    }

    public static final int[] readInts(DataInput in, int size) throws IOException {
        int[] iarray = new int[size];
        for (int i = 0; i < size; ++i) {
            iarray[i] = in.readInt();
        }
        return iarray;
    }

    public static final void writeBooleans(DataOutput out, boolean[] barray) throws IOException {
        int size = barray != null ? barray.length : -1;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeBoolean(barray[i]);
        }
    }

    public static final boolean[] readBooleans(DataInput in) throws IOException {
        int size = in.readInt();
        if (size < 0) {
            return null;
        }
        boolean[] barray = new boolean[size];
        for (int i = 0; i < size; ++i) {
            barray[i] = in.readBoolean();
        }
        return barray;
    }

    public static final void writeLocaleNumericFormat(DataOutput out, LocaleNumericFormat lnf) throws IOException {
        out.writeInt(lnf.getInstanceType());
        NumberFormat nf = lnf.getNumberFormat();
        out.writeInt(nf.getMaximumFractionDigits());
        out.writeInt(nf.getMaximumIntegerDigits());
        out.writeInt(nf.getMinimumFractionDigits());
        out.writeInt(nf.getMinimumIntegerDigits());
        out.writeBoolean(nf.isGroupingUsed());
        out.writeBoolean(nf.isParseIntegerOnly());
    }

    public static final LocaleNumericFormat readLocaleNumericFormat(DataInput in, int version) throws IOException {
        LocaleNumericFormat result;
        int type = in.readInt();
        if (type == 0) {
            result = LocaleNumericFormat.getCurrencyInstance();
        } else if (type == 1) {
            result = LocaleNumericFormat.getNumberInstance();
        } else if (type == 2) {
            result = LocaleNumericFormat.getPercentInstance();
        } else {
            throw new IOException("Illegal LocaleNumericFormat: " + type);
        }
        NumberFormat nf = result.getNumberFormat();
        nf.setMaximumFractionDigits(in.readInt());
        nf.setMaximumIntegerDigits(in.readInt());
        nf.setMinimumFractionDigits(in.readInt());
        nf.setMinimumIntegerDigits(in.readInt());
        nf.setGroupingUsed(in.readBoolean());
        nf.setParseIntegerOnly(in.readBoolean());
        return result;
    }

    public static final void writeNumericFormat(DataOutput out, NumericFormat nf) throws IOException {
        out.writeChar(nf.currencySymbol);
        out.writeBoolean(nf.oneSymPerPage);
        out.writeInt(nf.currencyPos);
        out.writeInt(nf.decimal);
        out.writeInt(nf.rounding);
        out.writeInt(nf.negative);
        out.writeChar(nf.decimalSep);
        out.writeChar(nf.thousandSep);
        out.writeBoolean(nf.leadingZero);
        out.writeBoolean(nf.sciExp);
    }

    public static final NumericFormat readNumericFormat(DataInput in) throws IOException {
        NumericFormat nf = new NumericFormat();
        int decimal = in.readInt();
        nf.setFormat(in.readChar(), in.readBoolean(), in.readInt(), decimal, in.readInt(), in.readInt(), in.readChar(), in.readChar(), in.readBoolean());
        if (in.readBoolean()) {
            nf.setScientifExp(decimal);
        }
        return nf;
    }

    public static final void writeLocaleDateTimeFormat(DataOutput out, LocaleDateTimeFormat ldtf) throws IOException {
        out.writeInt(ldtf.getInstanceType());
        out.writeInt(ldtf.getDateStyle());
        out.writeInt(ldtf.getTimeStyle());
    }

    public static final LocaleDateTimeFormat readLocaleDateTimeFormat(DataInput in, int version) throws IOException {
        int type = in.readInt();
        int dateStyle = in.readInt();
        int timeStyle = in.readInt();
        if (type == LocaleDateTimeFormat.DATE) {
            return LocaleDateTimeFormat.getDateInstance(dateStyle);
        }
        if (type == LocaleDateTimeFormat.TIME) {
            return LocaleDateTimeFormat.getTimeInstance(timeStyle);
        }
        if (type == LocaleDateTimeFormat.DATETIME) {
            return LocaleDateTimeFormat.getDateTimeInstance(dateStyle, timeStyle);
        }
        throw new IOException("Illegal LocaleDateTimeFormat: " + type);
    }

    public static final void writeDateTimeFormat(DataOutput out, DateTimeFormat dt) throws IOException {
        out.writeShort(dt.yearSymbol);
        out.writeShort(dt.monthSymbol);
        out.writeShort(dt.orderSymbol);
        IOUtil.writeString(out, dt.separator1);
        IOUtil.writeString(out, dt.separator2);
        out.writeBoolean(dt.hour24);
        out.writeBoolean(dt.showMinute);
        out.writeBoolean(dt.showSecond);
        IOUtil.writeString(out, dt.hourMinuteSep);
        IOUtil.writeString(out, dt.minuteSecondSep);
        out.writeShort(dt.nanoDecimal);
        out.writeBoolean(dt.timeBeforeDate);
        IOUtil.writeString(out, dt.timeDateSep);
        out.writeBoolean(dt.hidedate);
        out.writeBoolean(dt.hidemonth);
        out.writeBoolean(dt.hideyear);
        out.writeBoolean(dt.fixDigitLen);
        out.writeBoolean(dt.hideTimestampTime);
    }

    public static final DateTimeFormat readDateTimeFormat(DataInput in, int version) throws IOException {
        boolean isUTF = true;
        DateTimeFormat dt = new DateTimeFormat();
        dt.yearSymbol = in.readShort();
        dt.monthSymbol = in.readShort();
        dt.orderSymbol = in.readShort();
        dt.separator1 = IOUtil.readString(in, isUTF);
        dt.separator2 = IOUtil.readString(in, isUTF);
        dt.hour24 = in.readBoolean();
        dt.showMinute = in.readBoolean();
        dt.showSecond = in.readBoolean();
        dt.hourMinuteSep = IOUtil.readString(in, isUTF);
        dt.minuteSecondSep = IOUtil.readString(in, isUTF);
        dt.nanoDecimal = in.readShort();
        dt.timeBeforeDate = in.readBoolean();
        dt.timeDateSep = IOUtil.readString(in, isUTF);
        dt.hidedate = in.readBoolean();
        dt.hidemonth = in.readBoolean();
        dt.hideyear = in.readBoolean();
        dt.fixDigitLen = in.readBoolean();
        dt.hideTimestampTime = in.readBoolean();
        return dt;
    }

    public static final String getHostName(Applet applet) {
        String hostname;
        try {
            hostname = applet.getCodeBase().getHost();
        }
        catch (Exception ex) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex2) {
                hostname = "";
            }
        }
        return hostname;
    }

    public static final String getCodeBase(Applet applet) {
        String s;
        try {
            s = applet.getCodeBase() + "";
            if (isUsingEspressOrganizerApplet) {
                int i = s.lastIndexOf("EspressOrganizer");
                if (i < 0) {
                    return s;
                }
                s = s.substring(0, i) + "EspressChart/";
            }
        }
        catch (Exception ex) {
            return "";
        }
        return s;
    }

    public static final FileInputStream createFileInputStream(String fileName) throws IOException {
        if (isUsingEspressOrganizerApplet) {
            return new FileInputStream(".." + File.separator + "EspressChart" + File.separator + fileName);
        }
        if (ServerMessage.isServlet()) {
            fileName = ServerMessage.getPath(fileName);
        }
        return new FileInputStream(fileName);
    }

    public static final FileOutputStream createFileOutputStream(String fileName) throws IOException {
        if (ServerMessage.isServlet()) {
            fileName = ServerMessage.getPath(fileName);
        }
        return new FileOutputStream(fileName);
    }

    public static final File createFile(String fileName) throws IOException {
        if (isUsingEspressOrganizerApplet) {
            return new File(".." + File.separator + "EspressChart" + File.separator + fileName);
        }
        if (ServerMessage.isServlet()) {
            fileName = ServerMessage.getPath(fileName);
        }
        return new File(fileName);
    }

    private static final String convertString(byte[] b) {
        int i = b.length;
        char[] value = new char[i];
        while (i-- > 0) {
            value[i] = (char)(b[i] & 0xFF);
        }
        return new String(value);
    }

    private static final byte[] convertByte(String s) {
        int n = s.length();
        byte[] b = new byte[n];
        int i = -1;
        while (++i < n) {
            b[i] = (byte)s.charAt(i);
        }
        return b;
    }

    public static final byte[] encode(byte[] b) {
        return IOUtil.convertByte(Coder.encode(IOUtil.convertString(b)));
    }

    public static final byte[] decode(byte[] b, int version) {
        return IOUtil.convertByte(Coder.decode(IOUtil.convertString(b), version));
    }

    public static int[] getImageBuffer(int width, int height, Image image) throws Exception {
        int[] imagebuffer = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, height, imagebuffer, 0, width);
        if (!grabber.grabPixels()) {
            throw new AWTException("Grabber fail : " + grabber.status());
        }
        return imagebuffer;
    }

    public static final String extractHostPath(String filename, Applet applet) {
        int idxS = filename.indexOf("https://", 0);
        if (idxS >= 0) {
            int idx2 = filename.indexOf("/", idxS + 8);
            if (idx2 < 0) {
                return IOUtil.getHostName(applet);
            }
            return filename.substring(idx2 + 1);
        }
        int idx = filename.indexOf("http://", 0);
        if (idx < 0) {
            return filename;
        }
        int idx2 = filename.indexOf("/", idx + 7);
        if (idx2 < 0) {
            return IOUtil.getHostName(applet);
        }
        return filename.substring(idx2 + 1);
    }

    public static String getStackTrace(Throwable e) {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
        e.printStackTrace(new PrintWriter(bstream, true));
        return bstream.toString();
    }

    public static final void writeColorSpectrum(DataOutput out, ColorSpectrum colorSpectrum) throws IOException {
        boolean isSpectrumDefined = colorSpectrum != null;
        out.writeBoolean(isSpectrumDefined);
        if (isSpectrumDefined) {
            double[] value = colorSpectrum.getValue();
            Color[] color = colorSpectrum.getColor();
            int nValue = value == null ? 0 : value.length;
            out.writeInt(nValue);
            for (int i = 0; i < nValue; ++i) {
                out.writeDouble(value[i]);
            }
            int nColor = nValue + 1;
            for (int i = 0; i < nColor; ++i) {
                IOUtil.writeColor(out, color[i]);
            }
        }
    }

    public static final ColorSpectrum readColorSpectrum(DataInput in, int version) throws IOException {
        if (version < 102) {
            return null;
        }
        boolean isSpectrumDefined = in.readBoolean();
        if (isSpectrumDefined) {
            int nValue = in.readInt();
            double[] value = null;
            if (nValue > 0) {
                value = new double[nValue];
                for (int i = 0; i < nValue; ++i) {
                    value[i] = in.readDouble();
                }
            }
            int nColor = nValue + 1;
            Color[] color = new Color[nColor];
            for (int i = 0; i < nColor; ++i) {
                color[i] = IOUtil.readColor(in);
            }
            return new ColorSpectrum(color, value);
        }
        return null;
    }

    public static boolean isJava2D() {
        if (isJava2D != null) {
            return isJava2D;
        }
        try {
            Class<?> objClass = Class.forName("java.awt.Graphics2D");
            if (objClass == null) {
                isJava2D = Boolean.FALSE;
                return isJava2D;
            }
        }
        catch (Exception ex) {
            isJava2D = Boolean.FALSE;
            return isJava2D;
        }
        isJava2D = Boolean.TRUE;
        return isJava2D;
    }

    public static boolean isJimiIncluded() {
        if (isJimiIncluded != null) {
            return isJimiIncluded;
        }
        try {
            Class<?> objClass = Class.forName("com.sun.jimi.core.Jimi");
            if (objClass == null) {
                isJimiIncluded = Boolean.FALSE;
                return isJimiIncluded;
            }
        }
        catch (Exception ex) {
            isJimiIncluded = Boolean.FALSE;
            return isJimiIncluded;
        }
        isJimiIncluded = Boolean.TRUE;
        return isJimiIncluded;
    }

    public static boolean isSVGIncluded() {
        if (isSVGIncluded != null) {
            return isSVGIncluded;
        }
        try {
            Class<?> objClass = Class.forName("org.apache.batik.svggen.SVGGraphics2D");
            if (objClass == null) {
                isSVGIncluded = Boolean.FALSE;
                return isSVGIncluded;
            }
        }
        catch (Exception ex) {
            isSVGIncluded = Boolean.FALSE;
            return isSVGIncluded;
        }
        isSVGIncluded = Boolean.TRUE;
        return isSVGIncluded;
    }

    public static boolean isFlashIncluded() {
        if (isFlashIncluded != null) {
            return isFlashIncluded;
        }
        try {
            Class<?> objClass = Class.forName("com.flagstone.transform.FSBounds");
            if (objClass == null) {
                isFlashIncluded = Boolean.FALSE;
                return isFlashIncluded;
            }
        }
        catch (Exception ex) {
            isFlashIncluded = Boolean.FALSE;
            return isFlashIncluded;
        }
        isFlashIncluded = Boolean.TRUE;
        return isFlashIncluded;
    }

    public static boolean isXMLFormat(String fileName) {
        return fileName.toLowerCase().endsWith(".xml");
    }

    public static Image getOffScreenImage(Chart chart, Component component, int w, int h) {
        Image image = quadbase.common.util.internal.IOUtil.getOffScreenImage(component, w, h);
        int oldwidth = chart.winWidth;
        int oldheight = chart.winHeight;
        float chart_XProp = chart.chart_XProp;
        float chart_YProp = chart.chart_YProp;
        float chart_widthProp = chart.chart_widthProp;
        float chart_heightProp = chart.chart_heightProp;
        if (image != null) {
            Graphics g = image.getGraphics();
            chart.draw(g, component, w, h);
            g.dispose();
        }
        chart.chart_XProp = chart_XProp;
        chart.chart_YProp = chart_YProp;
        chart.chart_widthProp = chart_widthProp;
        chart.chart_heightProp = chart_heightProp;
        chart.setSize(oldwidth, oldheight);
        return image;
    }

    public static boolean isMac() {
        if (isMac != null) {
            return isMac;
        }
        String osSystem = System.getProperty("os.name");
        isMac = osSystem.toLowerCase().startsWith("mac");
        return isMac;
    }

    public static int getRightMouseClickMask() {
        return quadbase.common.util.internal.IOUtil.getRightMouseClickMask();
    }

    public static boolean isRightMouseClicked(MouseEvent e) {
        int mouseMask = e.getModifiers() & 0xFFFFFFEF;
        return mouseMask == IOUtil.getRightMouseClickMask();
    }

    public static boolean isJava14() {
        if (isJava14 != null) {
            return isJava14;
        }
        try {
            Class<?> objClass = Class.forName("javax.print.PrintService");
            if (objClass == null) {
                isJava14 = Boolean.FALSE;
                return isJava14;
            }
        }
        catch (Exception ex) {
            isJava14 = Boolean.FALSE;
            return isJava14;
        }
        isJava14 = Boolean.TRUE;
        return isJava14;
    }
}

