/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.zip.DataFormatException;
import quadbase.chart.Chart;
import quadbase.chart.ReadDataFile;
import quadbase.common.client.FileInfo;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.IQbGraphics;
import quadbase.reportdesigner.util.internal.PNGJimiDecoder;
import quadbase.util.internal.ImageResample;

public class ImageData {
    public static final int CENTER = 0;
    public static final int FIT = 1;
    public static final int TILE = 2;
    public static final int NONE = 3;
    URL url;
    String relativeURL;
    Image image;
    Image newimage;
    int display_option;
    int im_w;
    int im_h;
    int width;
    int height;
    boolean changed;
    boolean failed;
    byte[] byteArray;
    boolean isAppletDesigner = false;

    public ImageData(URL url) {
        this(url, 0);
    }

    public ImageData(URL url, int option) {
        this.setOption(option);
        this.setImage(url);
    }

    public ImageData(URL url, String relativeURL, int option) {
        this.setOption(option);
        this.setRelativeImage(relativeURL);
        if (relativeURL != null) {
            this.setImageFromRelativeURL();
        } else {
            this.setImage(url);
        }
    }

    public void setImage(URL url) {
        this.url = url;
        this.image = null;
        this.changed = true;
        this.failed = false;
    }

    public void setRelativeImage(String relativeURL) {
        this.relativeURL = relativeURL;
    }

    public void setByteArray(byte[] bytes) {
        this.byteArray = bytes;
        this.image = null;
        this.changed = true;
        this.failed = false;
    }

    public void setImage(Image image) {
        if (image == null) {
            return;
        }
        this.image = image;
        this.changed = true;
        this.failed = false;
    }

    public void setOption(int option) {
        this.display_option = option;
        this.changed = true;
    }

    public int getOption() {
        return this.display_option;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getRelativeUrl() {
        return this.relativeURL;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImageFromRelativeURL() {
        if (this.relativeURL == null) {
            return;
        }
        if (!this.isAppletDesigner) {
            this.url = this.getURL(this.relativeURL);
        }
        this.image = null;
        this.changed = true;
        this.failed = false;
    }

    private URL getURL(String s) {
        if (s == null) {
            return null;
        }
        if (!s.toLowerCase().startsWith("file") && !s.toLowerCase().startsWith("http")) {
            try {
                String path = new FileInfo(s).getAbsolutePath();
                if (!(s.toLowerCase().endsWith(".gif") || s.toLowerCase().endsWith(".jpg") || s.toLowerCase().endsWith(".png") || path.endsWith("/") || path.endsWith("\\"))) {
                    path = path + "/";
                }
                return new URL(IOUtil.nameToURL3(path));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return this.url;
            }
        }
        return this.url;
    }

    public void draw(Chart chart, Graphics g, int x, int y, int width, int height, Object comp) {
        ImageObserver obs;
        block27: {
            if (this.url == null || this.display_option == 3) {
                return;
            }
            URL fullURL = this.getURL(this.relativeURL);
            if (this.isAppletDesigner || fullURL == null) {
                fullURL = this.url;
            }
            if (fullURL == null) {
                return;
            }
            if (g instanceof IQbGraphics) {
                if (this.byteArray == null) {
                    ((IQbGraphics)((Object)g)).drawImage(fullURL, this.display_option, x, y, width, height);
                } else {
                    ((IQbGraphics)((Object)g)).drawImage(this.byteArray, this.display_option, x, y, width, height);
                }
                return;
            }
            if (g instanceof IFlashGraphics) {
                try {
                    if (this.byteArray == null) {
                        ((IFlashGraphics)((Object)g)).drawImage(fullURL, this.display_option, x, y, width, height);
                    } else {
                        ((IFlashGraphics)((Object)g)).drawImage(this.byteArray, this.display_option, x, y, width, height);
                    }
                    return;
                }
                catch (DataFormatException dataFormatException) {
                    // empty catch block
                }
            }
            if (this.image == null && !this.failed) {
                this.image = this.byteArray != null ? ImageData.retrieveImage(this.byteArray, (Component)comp) : (this.relativeURL != null ? ImageData.retrieveImage(chart, this.relativeURL, (Component)comp) : ImageData.retrieveImage(chart, fullURL.toString(), (Component)comp));
                if (this.image == null) {
                    this.failed = true;
                    return;
                }
            }
            this.im_w = this.image.getWidth(null);
            this.im_h = this.image.getHeight(null);
            obs = (ImageObserver)comp;
            if (this.width != width || this.height != height) {
                this.changed = true;
            }
            this.width = width;
            this.height = height;
            if ((this.im_w > width || this.im_h > height) && this.display_option != 1 && this.changed) {
                try {
                    if (this.im_w <= width || this.im_w >= width && this.im_h >= height && this.im_h * width >= this.im_w * height) {
                        this.newimage = new ImageResample(this.image).resample(height * this.im_w / this.im_h, height);
                        break block27;
                    }
                    this.newimage = new ImageResample(this.image).resample(width, width * this.im_h / this.im_w);
                }
                catch (Exception ex) {
                    this.newimage = this.image;
                    System.out.println("Exception " + ex.getMessage());
                }
            } else if (this.display_option == 2 || this.display_option == 0 && this.changed) {
                this.newimage = this.image;
            }
        }
        if (this.display_option == 0) {
            g.drawImage(this.newimage, x + (width - this.newimage.getWidth(null)) / 2, y + (height - this.newimage.getHeight(null)) / 2, obs);
        } else if (this.display_option == 2) {
            ImageData.imageTile(g, x, y, width, height, this.newimage, obs);
        } else {
            try {
                if (this.changed) {
                    this.newimage = new ImageResample(this.image).resample(width, height);
                }
            }
            catch (Exception ex) {
                System.out.println("Exception " + ex.getMessage());
                this.newimage = this.image;
            }
            g.drawImage(this.newimage, x, y, width, height, obs);
        }
        this.changed = false;
    }

    public static Image retrieveImage(URL url, Component c) {
        return ImageData.retrieveImage(null, url.toString(), c);
    }

    private static Image retrieveImage(Chart chart, String url, Component c) {
        Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().getImage(url);
            MediaTracker tracker = new MediaTracker(c);
            tracker.addImage(image, 0);
            tracker.waitForID(0);
            if (tracker.isErrorID(0)) {
                throw new IOException("");
            }
        }
        catch (Exception ex) {
            try {
                int nread;
                ReadDataFile readDataFile = new ReadDataFile();
                if (url.startsWith("file:")) {
                    url = url.substring(6);
                }
                DataInputStream instream = readDataFile.getInputStream(chart, url);
                ByteArrayOutputStream boutput = new ByteArrayOutputStream(100);
                DataOutputStream dout = new DataOutputStream(boutput);
                byte[] buf = new byte[100];
                while ((nread = instream.read(buf, 0, 100)) >= 0) {
                    dout.write(buf, 0, nread);
                }
                image = ImageData.retrieveImage(boutput.toByteArray(), c);
                readDataFile.close();
                return image;
            }
            catch (Exception exception) {
                System.out.println("util/internal/ImageData");
                System.out.println("Failed to load image " + url + " " + ex.getMessage());
                image = null;
            }
        }
        return image;
    }

    private static Image retrieveImage(byte[] array, Component c) {
        Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().createImage(array);
            MediaTracker tracker = new MediaTracker(c);
            tracker.addImage(image, 0);
            tracker.waitForID(0);
            if (tracker.isErrorID(0)) {
                throw new IOException("");
            }
        }
        catch (Exception ex) {
            try {
                if (IOUtil.isJimiIncluded()) {
                    image = PNGJimiDecoder.getImage(array);
                }
            }
            catch (Exception ex2) {
                image = null;
            }
        }
        return image;
    }

    public static void imageTile(Graphics g, int x, int y, int width, int height, Image image, ImageObserver obs) {
        int w = image.getWidth(obs);
        int h = image.getHeight(obs);
        if (w == 0 || h == 0) {
            return;
        }
        int col = (int)Math.ceil((double)width / (double)w);
        int row = (int)Math.ceil((double)height / (double)h);
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                g.drawImage(image, j * w + x, i * h + y, w, h, obs);
            }
        }
    }

    public boolean isAppletDesigner() {
        return this.isAppletDesigner;
    }

    public void setAppletDesigner(boolean isAppletDesigner) {
        this.isAppletDesigner = isAppletDesigner;
    }

    public static Dimension getSize(URL url, Component c) {
        Image image = ImageData.retrieveImage(url, c);
        if (image == null) {
            return null;
        }
        return new Dimension(image.getWidth(null), image.getHeight(null));
    }

    public Object clone() {
        ImageData newImg = new ImageData(this.url);
        if (this.relativeURL != null) {
            newImg.relativeURL = this.relativeURL;
        }
        newImg.image = this.image;
        newImg.newimage = this.newimage;
        newImg.display_option = this.display_option;
        newImg.im_w = this.im_w;
        newImg.im_h = this.im_h;
        newImg.width = this.width;
        newImg.height = this.height;
        newImg.changed = this.changed;
        newImg.failed = this.failed;
        if (this.byteArray != null) {
            newImg.byteArray = (byte[])this.byteArray.clone();
        }
        return newImg;
    }
}

