/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ExportChart;

public class ImageEncoder {
    public static Image createImage(ExportChart exportChart, int width, int height, Component component, boolean isGIFDrillDown, boolean generateSubFile) throws Exception {
        Chart chart = exportChart.getChart();
        BufferedImage image = new BufferedImage(width, height, chart.getBufferedImageType());
        Graphics buffer = image.getGraphics();
        int oldwidth = chart.winWidth;
        int oldheight = chart.winHeight;
        float chart_XProp = chart.chart_XProp;
        float chart_YProp = chart.chart_YProp;
        float chart_widthProp = chart.chart_widthProp;
        float chart_heightProp = chart.chart_heightProp;
        if (isGIFDrillDown) {
            if (chart.currentNode != null && chart.currentNode.getRoot().getChildCount() > 0) {
                CGraphics.fieldDrillDownMap = true;
            } else {
                CGraphics.drillDownMap = true;
            }
        }
        chart.imagemap = generateSubFile || chart.getHyperLinkList() != null && chart.getHyperLinkList().size() > 0;
        chart.draw(buffer, component, width, height);
        if (isGIFDrillDown || chart.imagemap) {
            exportChart.createImageMapForFaceObject(chart, isGIFDrillDown);
        }
        chart.imagemap = false;
        CGraphics.drillDownMap = false;
        CGraphics.fieldDrillDownMap = false;
        buffer.dispose();
        if (chart.is2DChart) {
            chart.chart_XProp = chart_XProp;
            chart.chart_YProp = chart_YProp;
        }
        chart.chart_widthProp = chart_widthProp;
        chart.chart_heightProp = chart_heightProp;
        chart.setSize(oldwidth, oldheight);
        return image;
    }

    public static void encode(ExportFormat exportFormat, Image cImage, OutputStream out, int quality) throws Exception {
        ImageEncoder.encode(exportFormat, cImage, out, quality, false);
    }

    public static void encode(ExportFormat exportFormat, Image cImage, OutputStream out, int quality, boolean transparent) throws Exception {
        BufferedImage image;
        if (cImage instanceof BufferedImage) {
            image = (BufferedImage)cImage;
        } else {
            image = new BufferedImage(cImage.getWidth(null), cImage.getHeight(null), transparent ? 3 : 3);
            Graphics buffer = image.getGraphics();
            buffer.drawImage(cImage, 0, 0, null);
            buffer.dispose();
        }
        ImageWriter writer = ImageIO.getImageWritersByFormatName(exportFormat.toString()).next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        if (exportFormat.equals((Object)ExportFormat.JPEG)) {
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality((float)quality / 100.0f);
        }
        writer.setOutput(new MemoryCacheImageOutputStream(out));
        IIOImage ioimage = new IIOImage(image, null, null);
        writer.write(null, ioimage, iwp);
        writer.dispose();
    }

    public static enum ExportFormat {
        JPEG,
        PNG;

    }
}

