/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import quadbase.chart.Chart;
import quadbase.common.util.output.Document;
import quadbase.common.util.output.Jpeg;
import quadbase.common.util.output.Rectangle;
import quadbase.common.util.output.pdf.PdfContentByte;
import quadbase.common.util.output.pdf.PdfWriter;
import quadbase.common.util.output.pdf.QbFontMapper;
import quadbase.util.internal.ImageEncoder;

public class PDFEncoder {
    private boolean j2DRotateEnabled;

    public void export(Chart chart, OutputStream out, int width, int height) throws Exception {
        try {
            if (!(chart.isTranslucent() || chart.hasHighlightOverlapControlArea() || !chart.is2DimChart() && chart.isCircularChart())) {
                this.compromisePdfGraphics(chart);
                Rectangle rect = new Rectangle(0.0f, 0.0f, width + 2, height + 2);
                Document docs = new Document(rect, 1.0f, 0.0f, 1.0f, 0.0f);
                PdfWriter writer = PdfWriter.getInstance(docs, out);
                docs.open();
                PdfContentByte cb = writer.getDirectContent();
                cb.saveState();
                cb.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                QbFontMapper fontMapper = new QbFontMapper(chart.getFontMapping());
                Graphics2D g2 = cb.createGraphics(width, height, fontMapper);
                chart.draw(g2, new Panel(), width, height);
                g2.dispose();
                cb.restoreState();
                docs.close();
                this.unCompromisePdfGraphics(chart);
            } else {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                BufferedImage image = new BufferedImage(width, height, 1);
                Graphics2D graphics = image.createGraphics();
                chart.draw(graphics, new Panel(), width, height);
                graphics.dispose();
                ImageEncoder.encode(ImageEncoder.ExportFormat.JPEG, image, bout, 99);
                Jpeg newImg = new Jpeg(bout.toByteArray());
                newImg.setBorderWidth(0.0f);
                Rectangle rect = new Rectangle(0.0f, 0.0f, width + 2, height + 2);
                Document docs = new Document(rect, 1.0f, 0.0f, 1.0f, 0.0f);
                PdfWriter.getInstance(docs, out);
                docs.open();
                docs.add(newImg);
                docs.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void compromisePdfGraphics(Chart c) {
        this.j2DRotateEnabled = c.isJ2DRotateEnabled();
        c.setJ2DRotateEnabled(true);
    }

    private void unCompromisePdfGraphics(Chart c) {
        c.setJ2DRotateEnabled(this.j2DRotateEnabled);
    }
}

