/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import quadbase.common.formula.Formula;
import quadbase.common.paramquery.ISupportsDefaultSql;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.util.internal.DataType;
import quadbase.util.ICustomParameterDateFormat;
import quadbase.util.IDatabaseInfo;
import quadbase.util.IJNDIDatabaseInfo;
import quadbase.util.IQueryFileInfo;
import quadbase.util.IQueryInParam;
import quadbase.util.IQueryMultiValueInParam;
import quadbase.util.IQueryParamValuesProvider;

public class QbUtil {
    public static final void add(Container x, Component c, GridBagLayout gbl, GridBagConstraints gbc, int gx, int gy, int w, int h) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbl.setConstraints(c, gbc);
        x.add(c);
    }

    public static String escapeHTML(String str) {
        return quadbase.common.util.internal.QbUtil.escapeHTML(str);
    }

    public static String escapeHTMLIfNecessary(String str) {
        return quadbase.common.util.internal.QbUtil.escapeHTMLIfNecessary(str);
    }

    public static Panel labelComponent(String label, Component component) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 5, 2));
        panel.add(new Label(label));
        panel.add(component);
        return panel;
    }

    public static String getFileName(String path) {
        String tmp = path.replace('\\', '/');
        int idx = tmp.lastIndexOf(47);
        if (idx < 0) {
            return path;
        }
        if (idx + 1 < path.length()) {
            return path.substring(idx + 1);
        }
        return path;
    }

    public static IQueryInParam[] getInParam(Object obj) {
        if (obj instanceof quadbase.common.util.IQueryFileInfo) {
            return QbUtil.cast((quadbase.common.util.IQueryFileInfo)obj).getInParam();
        }
        return null;
    }

    public static IQueryFileInfo cast(quadbase.common.util.IQueryFileInfo dbInfo) {
        if (dbInfo instanceof IQueryFileInfo) {
            return (IQueryFileInfo)dbInfo;
        }
        return new CQueryFileInfo(dbInfo);
    }

    public static IDatabaseInfo cast(quadbase.common.util.IDatabaseInfo dbInfo) {
        return new CDatabaseInfo(dbInfo);
    }

    public static IQueryInParam cast(quadbase.common.util.IQueryInParam dbInfo) {
        if (dbInfo instanceof quadbase.common.util.IQueryMultiValueInParam) {
            return new CQueryMultiValueInParam((quadbase.common.util.IQueryMultiValueInParam)dbInfo);
        }
        return new CQueryInParam(dbInfo);
    }

    public static double roundUp(double val) {
        return Math.rint(val * 100.0) / 100.0;
    }

    public static Vector readMultiValues(String valueString) {
        if (valueString == null) {
            return null;
        }
        try {
            Vector<String> vect = new Vector<String>();
            StreamTokenizer st = new StreamTokenizer(new StringReader(valueString));
            int ttype = st.nextToken();
            while (ttype != -1) {
                if (ttype == -2) {
                    vect.addElement(st.nval + "");
                } else if (st.sval != null) {
                    vect.addElement(st.sval);
                }
                ttype = st.nextToken();
            }
            return vect;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Vector getMultiValueObject(int sqlType, String[] strValues) {
        return QbUtil.getMultiValueObject(sqlType, strValues, null);
    }

    public static Vector getMultiValueObject(int sqlType, String[] strValues, String dateFormat) {
        Vector<Object> valueObjects = new Vector<Object>();
        for (String strValue : strValues) {
            valueObjects.addElement(QbUtil.getValueObject(sqlType, strValue, dateFormat));
        }
        return valueObjects;
    }

    public static Object getValueObject(int sqlType, String strValue) {
        return QbUtil.getValueObject(sqlType, strValue, null);
    }

    public static Object getValueObject(int sqlType, String strValue, String dateFormat) {
        Object obj = null;
        try {
            obj = DataType.createObject(strValue, DataType.mapType(sqlType), dateFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static String urlEncode(String s) {
        return quadbase.common.util.internal.QbUtil.urlEncode(s);
    }

    public static String urlEncode2(String s) {
        return quadbase.common.util.internal.QbUtil.encodeURIComponent(s);
    }

    public static String urlEncode2IfNecessary(String s) {
        return quadbase.common.util.internal.QbUtil.urlEncode2IfNecessary(s);
    }

    public static String urlDecode(String s) {
        return quadbase.common.util.internal.QbUtil.urlDecode(s);
    }

    public static String fixUrlString(String url) {
        return quadbase.common.util.internal.QbUtil.fixUrlString(url);
    }

    public static <T> String[] toStringArray(List<T> list) {
        Iterator<T> it = list.iterator();
        String[] result = new String[list.size()];
        int i = 0;
        while (it.hasNext()) {
            result[i] = it.next() + "";
            ++i;
        }
        return result;
    }

    public static class CQueryFileInfo
    extends CDatabaseInfo
    implements IQueryFileInfo {
        quadbase.common.util.IQueryFileInfo dbInfo;

        public CQueryFileInfo(quadbase.common.util.IQueryFileInfo dbInfo) {
            super(dbInfo);
            this.dbInfo = dbInfo;
        }

        public quadbase.common.util.IQueryFileInfo getIQueryFileInfo() {
            return this.dbInfo;
        }

        @Override
        public IQueryInParam[] getInParam() {
            quadbase.common.util.IQueryInParam[] oparam = null;
            if (this.dbInfo instanceof IQueryFileInfo) {
                return ((IQueryFileInfo)this.dbInfo).getInParam();
            }
            if (this.dbInfo instanceof quadbase.reportdesigner.util.IQueryFileInfo) {
                oparam = ((quadbase.reportdesigner.util.IQueryFileInfo)this.dbInfo).getInParam();
            } else if (this.dbInfo instanceof QueryFileInfo) {
                oparam = ((QueryFileInfo)this.dbInfo).getInParam();
            }
            if (oparam == null) {
                return null;
            }
            IQueryInParam[] param = new IQueryInParam[oparam.length];
            for (int i = 0; i < oparam.length; ++i) {
                param[i] = QbUtil.cast(oparam[i]);
            }
            return param;
        }
    }

    public static class CQueryMultiValueInParam
    implements IQueryMultiValueInParam,
    IQueryParamValuesProvider,
    ICustomParameterDateFormat,
    ISupportsDefaultSql {
        quadbase.common.util.IQueryMultiValueInParam param = null;

        public CQueryMultiValueInParam(quadbase.common.util.IQueryMultiValueInParam param) {
            this.param = param;
        }

        public quadbase.common.util.IQueryMultiValueInParam getQueryInParam() {
            return this.param;
        }

        @Override
        public String getParamName() {
            return this.param.getParamName();
        }

        @Override
        public String getPromptName() {
            return this.param.getPromptName();
        }

        @Override
        public void setPromptName(String promptName) {
            this.param.setPromptName(promptName);
        }

        @Override
        public boolean isMapToColumn() {
            return this.param.isMapToColumn();
        }

        @Override
        public void setMapToColumn(boolean mapToColumn) {
            this.param.setMapToColumn(mapToColumn);
        }

        @Override
        public String getTableName() {
            return this.param.getTableName();
        }

        @Override
        public void setTableName(String tableName) {
            this.param.setTableName(tableName);
        }

        @Override
        public String getColumnName() {
            return this.param.getColumnName();
        }

        @Override
        public void setColumnName(String columnName) {
            this.param.setColumnName(columnName);
        }

        @Override
        public int getSqlType() {
            return this.param.getSqlType();
        }

        @Override
        public void setSqlType(int sqlType) {
            this.param.setSqlType(sqlType);
        }

        @Override
        public Object getDefaultValue() {
            return this.param.getDefaultValue();
        }

        @Override
        public Object getDefaultValue(QueryFileInfo qfi) {
            if (this.param instanceof QueryMultiValueInParam) {
                return ((QueryMultiValueInParam)this.param).getDefaultValue(qfi);
            }
            return this.param.getDefaultValue();
        }

        @Override
        public void setDefaultValue(Object defaultValue) {
            this.param.setDefaultValue(defaultValue);
        }

        @Override
        public Object getValue() {
            return this.param.getValue();
        }

        @Override
        public void setValue(Object value) {
            this.param.setValue(value);
        }

        @Override
        public Vector getValues() {
            return this.param.getValues();
        }

        @Override
        public void setValues(Vector vs) {
            this.param.setValues(vs);
        }

        @Override
        public Vector getSelectionChoices() {
            if (this.param instanceof quadbase.common.util.IQueryParamValuesProvider) {
                return ((quadbase.common.util.IQueryParamValuesProvider)((Object)this.param)).getSelectionChoices();
            }
            return null;
        }

        @Override
        public String getDateFormat() {
            if (this.param instanceof quadbase.common.util.ICustomParameterDateFormat) {
                return ((quadbase.common.util.ICustomParameterDateFormat)((Object)this.param)).getDateFormat();
            }
            return null;
        }

        public String getSqlSelect() {
            if (this.param instanceof QueryMultiValueInParam) {
                return ((QueryMultiValueInParam)this.param).getSqlSelect();
            }
            return null;
        }

        @Override
        public String getDefaultSql() {
            if (this.param instanceof QueryMultiValueInParam) {
                return ((QueryMultiValueInParam)this.param).getDefaultSql();
            }
            return null;
        }

        @Override
        public void setDefaultSql(String defaultSql) {
            if (this.param instanceof QueryMultiValueInParam) {
                ((QueryMultiValueInParam)this.param).setDefaultSql(defaultSql);
            }
        }

        public Formula getDefaultValueVariable() {
            if (this.param instanceof QueryMultiValueInParam) {
                return ((QueryMultiValueInParam)this.param).getDefaultValueVariable();
            }
            return null;
        }

        public boolean isAllOptionEnabled() {
            if (this.param instanceof QueryMultiValueInParam) {
                return ((QueryMultiValueInParam)this.param).isAllOptionEnabled();
            }
            return false;
        }

        public String getAllOptionLabel() {
            if (this.param instanceof QueryMultiValueInParam) {
                return ((QueryMultiValueInParam)this.param).getAllOptionLabel();
            }
            return null;
        }

        public boolean isMapToFunctionOnly() {
            if (this.param instanceof QueryMultiValueInParam) {
                return ((QueryMultiValueInParam)this.param).isMapToFunctionOnly();
            }
            return false;
        }
    }

    public static class CQueryInParam
    implements IQueryInParam,
    IQueryParamValuesProvider,
    ICustomParameterDateFormat {
        quadbase.common.util.IQueryInParam param;

        public CQueryInParam(quadbase.common.util.IQueryInParam dbInfo) {
            this.param = dbInfo;
        }

        public quadbase.common.util.IQueryInParam getQueryInParam() {
            return this.param;
        }

        @Override
        public String getParamName() {
            return this.param.getParamName();
        }

        @Override
        public String getPromptName() {
            return this.param.getPromptName();
        }

        @Override
        public void setPromptName(String promptName) {
            this.param.setPromptName(promptName);
        }

        @Override
        public boolean isMapToColumn() {
            return this.param.isMapToColumn();
        }

        @Override
        public void setMapToColumn(boolean mapToColumn) {
            this.param.setMapToColumn(mapToColumn);
        }

        @Override
        public String getTableName() {
            return this.param.getTableName();
        }

        @Override
        public void setTableName(String tableName) {
            this.param.setTableName(tableName);
        }

        @Override
        public String getColumnName() {
            return this.param.getColumnName();
        }

        @Override
        public void setColumnName(String columnName) {
            this.param.setColumnName(columnName);
        }

        @Override
        public int getSqlType() {
            return this.param.getSqlType();
        }

        @Override
        public void setSqlType(int sqlType) {
            this.param.setSqlType(sqlType);
        }

        @Override
        public Object getDefaultValue() {
            return this.param.getDefaultValue();
        }

        public Object getDefaultValue(QueryFileInfo qfi) {
            if (this.param instanceof QueryInParam) {
                return ((QueryInParam)this.param).getDefaultValue(qfi);
            }
            return this.param.getDefaultValue();
        }

        @Override
        public void setDefaultValue(Object defaultValue) {
            this.param.setDefaultValue(defaultValue);
        }

        @Override
        public Object getValue() {
            return this.param.getValue();
        }

        @Override
        public void setValue(Object value) {
            this.param.setValue(value);
        }

        @Override
        public Vector getSelectionChoices() {
            if (this.param instanceof quadbase.common.util.IQueryParamValuesProvider) {
                return ((quadbase.common.util.IQueryParamValuesProvider)((Object)this.param)).getSelectionChoices();
            }
            return null;
        }

        @Override
        public String getDateFormat() {
            if (this.param instanceof quadbase.common.util.ICustomParameterDateFormat) {
                return ((quadbase.common.util.ICustomParameterDateFormat)((Object)this.param)).getDateFormat();
            }
            return null;
        }

        public String getSqlSelect() {
            if (this.param instanceof QueryInParam) {
                return ((QueryInParam)this.param).getSqlSelect();
            }
            return null;
        }

        @Override
        public String getDefaultSql() {
            if (this.param instanceof QueryInParam) {
                return ((QueryInParam)this.param).getDefaultSql();
            }
            return null;
        }

        @Override
        public void setDefaultSql(String defaultSql) {
            if (this.param instanceof QueryInParam) {
                ((QueryInParam)this.param).setDefaultSql(defaultSql);
            }
        }

        public boolean isAllOptionEnabled() {
            if (this.param instanceof QueryInParam) {
                return ((QueryInParam)this.param).isAllOptionEnabled();
            }
            return false;
        }

        public Formula getDefaultValueVariable() {
            if (this.param instanceof QueryInParam) {
                return ((QueryInParam)this.param).getDefaultValueVariable();
            }
            return null;
        }

        public String getAllOptionLabel() {
            if (this.param instanceof QueryInParam) {
                return ((QueryInParam)this.param).getAllOptionLabel();
            }
            return null;
        }

        public boolean isMapToFunctionOnly() {
            if (this.param instanceof QueryInParam) {
                return ((QueryInParam)this.param).isMapToFunctionOnly();
            }
            return false;
        }
    }

    public static class CDatabaseInfo
    implements IDatabaseInfo,
    IJNDIDatabaseInfo {
        quadbase.common.util.IDatabaseInfo dbInfo;
        quadbase.common.util.IJNDIDatabaseInfo jndiInfo;
        boolean isUseJNDIDataSource;

        public CDatabaseInfo(quadbase.common.util.IDatabaseInfo dbInfo) {
            if (dbInfo instanceof QueryFileInfo && ((QueryFileInfo)dbInfo).isUseJNDIDataSource()) {
                this.jndiInfo = (quadbase.common.util.IJNDIDatabaseInfo)((Object)dbInfo);
                this.isUseJNDIDataSource = true;
            }
            this.dbInfo = dbInfo;
        }

        public CDatabaseInfo(quadbase.common.util.IJNDIDatabaseInfo jndiInfo) {
            this.jndiInfo = jndiInfo;
            this.isUseJNDIDataSource = true;
        }

        @Override
        public String getURLString() {
            return this.dbInfo.getURLString();
        }

        @Override
        public String getDriverName() {
            return this.dbInfo.getDriverName();
        }

        @Override
        public String getUserID() {
            return this.dbInfo.getUserID();
        }

        @Override
        public String getPassword() {
            return this.dbInfo.getPassword();
        }

        @Override
        public Connection getConnection() {
            return this.dbInfo.getConnection();
        }

        @Override
        public String getQuery() {
            return this.dbInfo.getQuery();
        }

        @Override
        public String getJNDIName() {
            return this.jndiInfo.getJNDIName();
        }

        @Override
        public Hashtable getEnvProperties() {
            return this.jndiInfo.getEnvProperties();
        }

        public boolean isUseJNDIDataSource() {
            return this.isUseJNDIDataSource;
        }

        @Override
        public Connection openConnection() {
            return this.dbInfo.getConnection();
        }
    }
}

