/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class WMF {
    private int maxobjectsize = 0;
    private Vector wmf = new Vector(1000, 1000);
    private Vector handles = new Vector();
    private String[][] fontnames = new String[][]{{"helvetica", "Arial"}, {"timesroman", "Times New Roman"}, {"courier", "Courier New"}, {"zapfdingsbat", "Windings"}};
    String license = "commercial version";
    public static final int PS_SOLID = 0;
    public static final int PS_DASH = 1;
    public static final int PS_DOT = 2;
    public static final int PS_DASHDOT = 3;
    public static final int PS_DASHDOTDOT = 4;
    public static final int PS_NULL = 5;
    public static final int PS_INSIDEFRAME = 6;
    public static final int BS_SOLID = 0;
    public static final int BS_HOLLOW = 1;
    public static final int BS_NULL = 1;
    public static final int BS_HATCHED = 2;
    public static final int BS_PATTERN = 3;
    private static final int BS_DIBPATTERN = 5;
    public static final int HS_HORIZONTAL = 0;
    public static final int HS_VERTICAL = 1;
    public static final int HS_FDIAGONAL = 2;
    public static final int HS_BDIAGONAL = 3;
    public static final int HS_CROSS = 4;
    public static final int HS_DIAGCROSS = 5;
    public static final int DIB_RGB_COLORS = 0;
    public static final int DIB_PAL_COLORS = 1;
    public static final int FW_DONTCARE = 100;
    public static final int FW_THIN = 100;
    public static final int FW_NORMAL = 400;
    public static final int FW_BOLD = 700;
    public static final int FW_BLACK = 900;
    public static final byte ANSI_CHARSET = 0;
    public static final byte DEFAULT_CHARSET = 1;
    public static final byte SYMBOL_CHARSET = 2;
    public static final byte SHIFTJIS_CHARSET = -128;
    public static final byte OEM_CHARSET = -1;
    public static final byte OUT_DEFAULT_PRECIS = 0;
    public static final byte OUT_STRING_PRECIS = 1;
    public static final byte OUT_CHARACTER_PRECIS = 2;
    public static final byte OUT_STROKE_PRECIS = 3;
    public static final byte OUT_TT_PRECIS = 4;
    public static final byte OUT_DEVICE_PRECIS = 5;
    public static final byte OUT_RASTER_PRECIS = 6;
    public static final byte CLIP_DEFAULT_PRECIS = 0;
    public static final byte CLIP_CHARACTER_PRECIS = 1;
    public static final byte CLIP_STROKE_PRECIS = 2;
    public static final byte CLIP_MASK = 15;
    public static final byte CLIP_LH_ANGLES = 16;
    public static final byte CLIP_TT_ALWAYS = 32;
    public static final byte DEFAULT_QUALITY = 0;
    public static final byte DRAFT_QUALITY = 1;
    public static final byte PROOF_QUALITY = 2;
    public static final byte DEFAULT_PITCH = 0;
    public static final byte FIXED_PITCH = 1;
    public static final byte VARIABLE_PITCH = 2;
    public static final byte FF_DONTCARE = 0;
    public static final byte FF_ROMAN = 16;
    public static final byte FF_SWISS = 32;
    public static final byte FF_MODERN = 48;
    public static final byte FF_SCRIPT = 64;
    public static final byte FF_DECORATIVE = 80;
    public static final int TRANSPARENT = 1;
    public static final int OPAQUE = 2;
    public static final int MM_TEXT = 1;
    public static final int MM_LOMETRIC = 2;
    public static final int MM_HIMETRIC = 3;
    public static final int MM_LOENGLISH = 4;
    public static final int MM_HIENGLISH = 5;
    public static final int MM_HITWIPS = 6;
    public static final int MM_ISOTROPIC = 7;
    public static final int MM_ANISOTROPIC = 8;
    public static final int ALTERNATE = 1;
    public static final int WINDING = 2;
    public static final int STRETCH_ANDSCANS = 1;
    public static final int STRETCH_ORSCANS = 2;
    public static final int STRETCH_DELETESCANS = 3;
    public static final int TA_TOP = 0;
    public static final int TA_BOTTOM = 8;
    public static final int TA_BASELINE = 24;
    public static final int TA_LEFT = 0;
    public static final int TA_RIGHT = 2;
    public static final int TA_CENTER = 6;
    public static final int TA_NOUPDATECP = 0;
    public static final int TA_UPDATECP = 1;
    public static final int R2_BLACK = 1;
    public static final int R2_NOTMERGEPEN = 2;
    public static final int R2_MASKNOTPENNOT = 3;
    public static final int R2_NOTCOPYPEN = 4;
    public static final int R2_MASKPENNOT = 5;
    public static final int R2_NOT = 6;
    public static final int R2_XORPEN = 7;
    public static final int R2_NOTMASKPEN = 8;
    public static final int R2_MASKPEN = 9;
    public static final int R2_NOTXORPEN = 10;
    public static final int R2_NOP = 11;
    public static final int R2_MERGENOTPEN = 12;
    public static final int R2_COPYPEN = 13;
    public static final int R2_MERGEPENNOT = 14;
    public static final int R2_MERGEPEN = 15;
    public static final int R2_WHITE = 16;
    public static final int ETO_OPAQUE = 2;
    public static final int ETO_CLIPPED = 4;
    public static final int BLACKNESS = 66;
    public static final int NOTSRCERASE = 1114278;
    public static final int NOTSRCCOPY = 0x330008;
    public static final int SRCERASE = 4457256;
    public static final int DSTINVERT = 0x550009;
    public static final int PATINVERT = 5898313;
    public static final int SRCINVERT = 0x660046;
    public static final int SRCAND = 8913094;
    public static final int MERGEPAINT = 12255782;
    public static final int SRCCOPY = 0xCC0020;
    public static final int SRCPAINT = 15597702;
    public static final int PATCOPY = 15728673;
    public static final int PATPAINT = 16452105;
    public static final int WHITENESS = 16711778;

    private void outputWord(OutputStream out, int value) throws IOException {
        byte[] word = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8)};
        out.write(word);
    }

    private void outputInteger(OutputStream out, int value) throws IOException {
        this.outputWord(out, this.lowWord(value));
        this.outputWord(out, this.highWord(value));
    }

    private int lowWord(int value) {
        return value & 0xFFFF;
    }

    private int highWord(int value) {
        return (value & 0xFFFF0000) >> 16;
    }

    private int calcChecksum(int x1, int x2, int x3, int x4, int x5) {
        int sum = 39622;
        sum ^= 0xCDD7;
        sum ^= x1;
        sum ^= x2;
        sum ^= x3;
        sum ^= x4;
        return sum ^= x5;
    }

    private void writePlaceableHeader(OutputStream out, int x, int y, int width, int height, int dpi) throws IOException {
        this.outputInteger(out, -1698247209);
        this.outputWord(out, 0);
        this.outputWord(out, x);
        this.outputWord(out, y);
        this.outputWord(out, width);
        this.outputWord(out, height);
        this.outputWord(out, dpi);
        this.outputInteger(out, 0);
        this.outputWord(out, this.calcChecksum(dpi, x, y, width, height));
    }

    private void writeHeader(OutputStream out) throws IOException {
        this.deleteObjects();
        this.metaRecord(0, 0);
        this.outputWord(out, 1);
        this.outputWord(out, 9);
        this.outputWord(out, 768);
        this.outputInteger(out, this.wmf.size() + 9);
        this.outputWord(out, this.handles.size());
        this.outputInteger(out, this.maxobjectsize);
        this.outputWord(out, 0);
    }

    private void deleteObjects() {
        for (int i = 0; i < this.handles.size(); ++i) {
            if (!((Boolean)this.handles.elementAt(i)).booleanValue()) continue;
            this.deleteObject(i);
        }
    }

    private void writeBody(OutputStream out) throws IOException {
        for (int i = 0; i < this.wmf.size(); ++i) {
            this.outputWord(out, (Integer)this.wmf.elementAt(i));
        }
    }

    private void maxObjectSize(int size) {
        if (size > this.maxobjectsize) {
            this.maxobjectsize = size;
        }
    }

    protected void metaRecord(int id, int wordparams) {
        int size = wordparams + 3;
        this.writeInteger(size);
        this.writeWord(id);
        this.maxObjectSize(size);
    }

    protected void writeWord(int value) {
        this.wmf.addElement(value);
    }

    protected void writeInteger(int value) {
        this.writeWord(this.lowWord(value));
        this.writeWord(this.highWord(value));
    }

    protected void writeColor(Color color) {
        this.writeInteger(color.getRed() & 0xFF | color.getGreen() << 8 & 0xFF00 | color.getBlue() << 16 & 0xFF0000);
    }

    protected void writeBitmap(int[] tmppix, int width, int height) {
        int j;
        int w1 = (width * 3 + 3) / 4 * 4;
        byte[] pix = new byte[w1 * height];
        for (j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                int index = i * 3 + j * w1;
                int pixel = tmppix[i + j * width];
                pix[index + 2] = (byte)(pixel >> 16 & 0xFF);
                pix[index + 1] = (byte)(pixel >> 8 & 0xFF);
                pix[index] = (byte)(pixel & 0xFF);
            }
        }
        this.writeInteger(40);
        this.writeInteger(width);
        this.writeInteger(height);
        this.writeWord(1);
        this.writeWord(24);
        this.writeInteger(0);
        this.writeInteger(0);
        this.writeInteger(0);
        this.writeInteger(0);
        this.writeInteger(0);
        this.writeInteger(0);
        for (j = height - 1; j >= 0; --j) {
            int shift = j * w1;
            for (int i = 0; i < w1; i += 2) {
                int index = i + shift;
                this.writeWord(pix[index + 1] << 8 & 0xFF00 | pix[index] & 0xFF);
            }
        }
    }

    protected int addHandle() {
        for (int i = 0; i < this.handles.size(); ++i) {
            if (((Boolean)this.handles.elementAt(i)).booleanValue()) continue;
            this.handles.setElementAt(Boolean.TRUE, i);
            return i;
        }
        this.handles.addElement(Boolean.TRUE);
        return this.handles.size() - 1;
    }

    public String translateFontName(String name) {
        String transname = name;
        for (String[] fontname : this.fontnames) {
            if (!name.equalsIgnoreCase(fontname[0])) continue;
            transname = fontname[1];
        }
        return transname;
    }

    public void setTranslateFontNames(String[][] names) {
        this.fontnames = names;
    }

    public String[][] getTranslateFontNames() {
        return this.fontnames;
    }

    public void writePlaceableWMF(OutputStream out, int x, int y, int width, int height, int dpi) throws IOException {
        this.writePlaceableHeader(out, x, y, width, height, dpi);
        this.writeWMF(out);
    }

    public void writeWMF(OutputStream out) throws IOException {
        this.writeHeader(out);
        this.writeBody(out);
    }

    public void selectObject(int index) {
        if (index >= this.handles.size() || !((Boolean)this.handles.elementAt(index)).booleanValue()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.metaRecord(301, 1);
        this.writeWord(index);
    }

    public void deleteObject(int index) {
        if (index >= this.handles.size() || !((Boolean)this.handles.elementAt(index)).booleanValue()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.metaRecord(496, 1);
        this.writeWord(index);
        this.handles.setElementAt(Boolean.FALSE, index);
    }

    public int createPenIndirect(int style, int width, Color foreground) {
        this.metaRecord(762, 5);
        this.writeWord(style);
        this.writeInteger(width);
        this.writeColor(foreground);
        return this.addHandle();
    }

    public int createBrushIndirect(int style, Color foreground, int hatch) {
        this.metaRecord(764, 4);
        this.writeWord(style);
        this.writeColor(foreground);
        this.writeWord(hatch);
        return this.addHandle();
    }

    public int createPatternBrush(int[] pix, int width, int height) {
        int w1 = (width * 3 + 3) / 4 * 4;
        this.metaRecord(322, 22 + w1 / 2 * height);
        this.writeWord(3);
        this.writeWord(0);
        this.writeBitmap(pix, width, height);
        return this.addHandle();
    }

    public int createFont(Font font, int escapement, boolean underline, boolean strikeout) {
        int weight = 400;
        if (font.isBold()) {
            weight = 700;
        }
        return this.createFontIndirect(-font.getSize(), 0, escapement, 0, weight, font.isItalic(), underline, strikeout, (byte)0, (byte)0, (byte)0, (byte)0, (byte)0, this.translateFontName(font.getName()));
    }

    public int createFontIndirect(int height, int width, int escapement, int orientation, int weight, boolean italic, boolean underline, boolean strikeout, byte charset, byte outprecision, byte clipprecision, byte quality, byte pitchandfamiliy, String name) {
        this.metaRecord(763, 9 + (name.length() + 2) / 2);
        this.writeWord(height);
        this.writeWord(width);
        this.writeWord(escapement);
        this.writeWord(orientation);
        this.writeWord(weight);
        int word = 0;
        if (italic) {
            word = 1;
        }
        if (underline) {
            word += 256;
        }
        this.writeWord(word);
        word = charset << 8 & 0xFF00;
        if (strikeout) {
            ++word;
        }
        this.writeWord(word);
        this.writeWord(outprecision | clipprecision << 8 & 0xFF00);
        this.writeWord(quality | pitchandfamiliy << 8 & 0xFF00);
        byte[] bytes = new byte[name.length() + 2];
        name.getBytes(0, name.length(), bytes, 0);
        bytes[bytes.length - 2] = 0;
        bytes[bytes.length - 1] = 0;
        for (int i = 0; i < bytes.length / 2; ++i) {
            this.writeWord(bytes[i * 2] | bytes[i * 2 + 1] << 8 & 0xFF00);
        }
        return this.addHandle();
    }

    public void setWindowOrg(int x, int y) {
        this.metaRecord(523, 2);
        this.writeWord(y);
        this.writeWord(x);
    }

    public void setWindowExt(int width, int height) {
        this.metaRecord(524, 2);
        this.writeWord(height);
        this.writeWord(width);
    }

    public void offsetWindowOrg(int x, int y) {
        this.metaRecord(527, 2);
        this.writeWord(y);
        this.writeWord(x);
    }

    public void scaleWindowExt(int xnum, int xdenom, int ynum, int ydenom) {
        this.metaRecord(1024, 4);
        this.writeWord(ydenom);
        this.writeWord(ynum);
        this.writeWord(xdenom);
        this.writeWord(xnum);
    }

    public void setViewportOrg(int x, int y) {
        this.metaRecord(525, 2);
        this.writeWord(y);
        this.writeWord(x);
    }

    public void setViewportExt(int width, int height) {
        this.metaRecord(526, 2);
        this.writeWord(height);
        this.writeWord(width);
    }

    public void offsetViewportOrg(int x, int y) {
        this.metaRecord(529, 2);
        this.writeWord(y);
        this.writeWord(x);
    }

    public void scaleViewportExt(int xnum, int xdenom, int ynum, int ydenom) {
        this.metaRecord(1042, 4);
        this.writeWord(ydenom);
        this.writeWord(ynum);
        this.writeWord(xdenom);
        this.writeWord(xnum);
    }

    public void setTextColor(Color textcolor) {
        this.metaRecord(521, 2);
        this.writeColor(textcolor);
    }

    public void setBKMode(int mode) {
        this.metaRecord(258, 1);
        this.writeWord(mode);
    }

    public void setBKColor(Color bkcolor) {
        this.metaRecord(513, 2);
        this.writeColor(bkcolor);
    }

    public void setMapMode(int mode) {
        this.metaRecord(259, 1);
        this.writeWord(mode);
    }

    public void setPolyFillMode(int mode) {
        this.metaRecord(262, 1);
        this.writeWord(mode);
    }

    public void setStretchBltMode(int mode) {
        this.metaRecord(263, 1);
        this.writeWord(mode);
    }

    public void setTextAlign(int align) {
        this.metaRecord(302, 1);
        this.writeWord(align);
    }

    public void setROP2(int mode) {
        this.metaRecord(260, 1);
        this.writeWord(mode);
    }

    public void setTextCharacterExtra(int charextra) {
        this.metaRecord(264, 1);
        this.writeWord(charextra);
    }

    public void setTextJustification(int breakextra, int breakcount) {
        this.metaRecord(522, 2);
        this.writeWord(breakcount);
        this.writeWord(breakextra);
    }

    public void moveTo(int x, int y) {
        this.metaRecord(532, 2);
        this.writeWord(y);
        this.writeWord(x);
    }

    public void lineTo(int x, int y) {
        this.metaRecord(531, 2);
        this.writeWord(y);
        this.writeWord(x);
    }

    public void arc(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        this.metaRecord(2071, 8);
        this.writeWord(y4);
        this.writeWord(x4);
        this.writeWord(y3);
        this.writeWord(x3);
        this.writeWord(y2);
        this.writeWord(x2);
        this.writeWord(y1);
        this.writeWord(x1);
    }

    public void chord(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        this.metaRecord(2096, 8);
        this.writeWord(y4);
        this.writeWord(x4);
        this.writeWord(y3);
        this.writeWord(x3);
        this.writeWord(y2);
        this.writeWord(x2);
        this.writeWord(y1);
        this.writeWord(x1);
    }

    public void pie(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        this.metaRecord(2074, 8);
        this.writeWord(y4);
        this.writeWord(x4);
        this.writeWord(y3);
        this.writeWord(x3);
        this.writeWord(y2);
        this.writeWord(x2);
        this.writeWord(y1);
        this.writeWord(x1);
    }

    public void rectangle(int x1, int y1, int x2, int y2) {
        this.metaRecord(1051, 4);
        this.writeWord(y2);
        this.writeWord(x2);
        this.writeWord(y1);
        this.writeWord(x1);
    }

    public void ellipse(int x1, int y1, int x2, int y2) {
        this.metaRecord(1048, 4);
        this.writeWord(y2);
        this.writeWord(x2);
        this.writeWord(y1);
        this.writeWord(x1);
    }

    public void roundRect(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.metaRecord(1564, 6);
        this.writeWord(y3);
        this.writeWord(x3);
        this.writeWord(y2);
        this.writeWord(x2);
        this.writeWord(y1);
        this.writeWord(x1);
    }

    public void polygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.metaRecord(804, 1 + 2 * nPoints);
        this.writeWord(nPoints);
        for (int i = 0; i < nPoints; ++i) {
            this.writeWord(xPoints[i]);
            this.writeWord(yPoints[i]);
        }
    }

    public void polyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.metaRecord(805, 1 + 2 * nPoints);
        this.writeWord(nPoints);
        for (int i = 0; i < nPoints; ++i) {
            this.writeWord(xPoints[i]);
            this.writeWord(yPoints[i]);
        }
    }

    public void textOut(int x, int y, String str) {
        this.metaRecord(1313, 3 + (str.length() + 1) / 2);
        this.writeWord(str.length());
        byte[] bytes = new byte[str.length() + 1];
        str.getBytes(0, str.length(), bytes, 0);
        bytes[bytes.length - 1] = 0;
        for (int i = 0; i < bytes.length / 2; ++i) {
            int word = 0;
            word = bytes[i * 2] | bytes[i * 2 + 1] << 8 & 0xFF00;
            this.writeWord(word);
        }
        this.writeWord(y);
        this.writeWord(x);
    }

    public void extTextOut(int x, int y, int options, Rectangle rect, String str) {
        this.extTextOut(x, y, options, rect, str, null);
    }

    public void extTextOut(int x, int y, int options, Rectangle rect, String str, int[] dx) {
        int i;
        int recordlength = 4 + (str.length() + 1) / 2;
        if (options != 0) {
            recordlength += 4;
        }
        if (dx != null) {
            recordlength += str.length();
        }
        this.metaRecord(2610, recordlength);
        this.writeWord(y);
        this.writeWord(x);
        this.writeWord(str.length());
        this.writeWord(options);
        if (options != 0) {
            this.writeWord(rect.x);
            this.writeWord(rect.y);
            this.writeWord(rect.width);
            this.writeWord(rect.height);
        }
        byte[] bytes = new byte[str.length() + 1];
        str.getBytes(0, str.length(), bytes, 0);
        bytes[bytes.length - 1] = 0;
        for (i = 0; i < bytes.length / 2; ++i) {
            int word = 0;
            word = bytes[i * 2] | bytes[i * 2 + 1] << 8 & 0xFF00;
            this.writeWord(word);
        }
        if (dx != null) {
            for (i = 0; i < str.length(); ++i) {
                this.writeWord(dx[i]);
            }
        }
    }

    public void escape(int number, byte[] data) {
        this.metaRecord(1574, 2 + (data.length + 1) / 2);
        this.writeWord(number);
        this.writeWord(data.length);
        byte[] newdata = new byte[(data.length + 1) / 2 * 2];
        System.arraycopy(data, 0, newdata, 0, data.length);
        for (int i = 0; i < newdata.length; i += 2) {
            this.writeWord(newdata[i] | newdata[i + 1] << 8 & 0xFF00);
        }
    }

    public void setPixel(int x, int y, Color pixelcolor) {
        this.metaRecord(1055, 4);
        this.writeColor(pixelcolor);
        this.writeWord(y);
        this.writeWord(x);
    }

    public void stretchBlt(int dx, int dy, int dwidth, int dheight, int sx, int sy, int swidth, int sheight, int rop, int[] pix, int width, int height) {
        int w1 = (width * 3 + 3) / 4 * 4;
        this.metaRecord(2881, 30 + w1 / 2 * height);
        this.writeInteger(rop);
        this.writeWord(sheight);
        this.writeWord(swidth);
        this.writeWord(sy);
        this.writeWord(sx);
        this.writeWord(dheight);
        this.writeWord(dwidth);
        this.writeWord(dy);
        this.writeWord(dx);
        this.writeBitmap(pix, width, height);
    }

    public void bitBlt(int dx, int dy, int dwidth, int dheight, int sx, int sy, int rop, int[] pix, int width, int height) {
        int w1 = (width * 3 + 3) / 4 * 4;
        this.metaRecord(2368, 28 + w1 / 2 * height);
        this.writeInteger(rop);
        this.writeWord(sy);
        this.writeWord(sx);
        this.writeWord(dheight);
        this.writeWord(dwidth);
        this.writeWord(dy);
        this.writeWord(dx);
        this.writeBitmap(pix, width, height);
    }

    public void patBlt(int x, int y, int width, int height, int rop) {
        this.metaRecord(1565, 6);
        this.writeInteger(rop);
        this.writeWord(height);
        this.writeWord(width);
        this.writeWord(y);
        this.writeWord(x);
    }
}

