/*
 * Decompiled with CFR 0.152.
 */
package quadbase.util.internal;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.text.AttributedCharacterIterator;
import quadbase.util.internal.IWMFGraphics;
import quadbase.util.internal.WMF;

public class WMFGraphics
extends Graphics
implements IWMFGraphics {
    WMF wmf;
    Color foreground;
    Color background;
    Font font = new Font("Helvetica", 0, 12);
    int penstyle = 0;
    int penwidth = 0;
    int brushfillstyle = 0;
    int brushhatch = 0;
    int fontescapement = 0;
    Image brushpattern = null;
    int penhandle;
    int brushhandle;
    int fonthandle;
    boolean drawBorder = false;

    public WMFGraphics(WMF wmf, int width, int height) {
        this(wmf, width, height, Color.black, Color.white);
    }

    public WMFGraphics(WMF wmf, int width, int height, Color foreground, Color background) {
        this.foreground = foreground;
        this.background = background;
        this.setWMF(wmf, width, height);
        this.reset();
    }

    private void setup(int width, int height) {
        this.wmf.setMapMode(8);
        this.wmf.setWindowOrg(0, 0);
        this.wmf.setWindowExt(width, height);
        this.wmf.setTextAlign(24);
        this.wmf.setBKMode(1);
        this.wmf.setBKColor(this.background);
        this.wmf.setTextColor(this.foreground);
        this.wmf.setPolyFillMode(1);
        this.wmf.setStretchBltMode(3);
        this.wmf.setROP2(13);
        this.wmf.setTextCharacterExtra(0);
    }

    @Override
    public void reset() {
        this.setPenStyle(0);
        this.setPenWidth(0);
        this.setBrushFillStyle(0);
        this.setBrushHatch(0);
        this.setFontEscapement(0);
    }

    @Override
    public void setPenStyle(int style) {
        this.penstyle = style;
        this.setGDIPen();
    }

    @Override
    public int getPenStyle() {
        return this.penstyle;
    }

    @Override
    public void setPenWidth(int width) {
        this.penwidth = width;
        this.setGDIPen();
    }

    @Override
    public int getPenWidth() {
        return this.penwidth;
    }

    @Override
    public void setBrushFillStyle(int style) {
        this.brushfillstyle = style;
    }

    @Override
    public int getBrushFillStyle() {
        return this.brushfillstyle;
    }

    @Override
    public void setBrushHatch(int hatch) {
        this.brushhatch = hatch;
    }

    @Override
    public int getBrushHatch() {
        return this.brushhatch;
    }

    @Override
    public void setBrushPattern(Image pattern) {
        this.brushpattern = pattern;
    }

    @Override
    public Image getBrushPattern() {
        return this.brushpattern;
    }

    @Override
    public void setFontEscapement(int escapement) {
        this.fontescapement = escapement;
        this.setGDIFont();
    }

    @Override
    public int getFontEscapement() {
        return this.fontescapement;
    }

    public void setWMF(WMF newwmf, int width, int height) {
        this.wmf = newwmf;
        this.penhandle = this.wmf.createPenIndirect(this.penstyle, this.penwidth, this.foreground);
        this.wmf.selectObject(this.penhandle);
        this.brushhandle = this.wmf.createBrushIndirect(1, this.foreground, this.brushhatch);
        this.wmf.selectObject(this.brushhandle);
        this.fonthandle = this.wmf.createFont(this.font, this.fontescapement, false, false);
        this.wmf.selectObject(this.fonthandle);
        this.setup(width, height);
    }

    public WMF getWMF() {
        return this.wmf;
    }

    @Override
    public int setGDIPen() {
        this.wmf.deleteObject(this.penhandle);
        this.wmf.createPenIndirect(this.penstyle, this.penwidth, this.foreground);
        this.wmf.selectObject(this.penhandle);
        return this.penhandle;
    }

    @Override
    public int setGDIHollowBrush() {
        this.wmf.deleteObject(this.brushhandle);
        this.wmf.createBrushIndirect(1, this.foreground, this.brushhatch);
        this.wmf.selectObject(this.brushhandle);
        return this.brushhandle;
    }

    @Override
    public int setGDIFillBrush() {
        block7: {
            this.wmf.deleteObject(this.brushhandle);
            if (this.brushfillstyle == 3) {
                if (this.brushpattern != null) {
                    int w = this.brushpattern.getWidth(null);
                    int h = this.brushpattern.getHeight(null);
                    int[] pix = new int[w * h];
                    PixelGrabber pg = new PixelGrabber(this.brushpattern, 0, 0, w, h, pix, 0, w);
                    try {
                        pg.grabPixels();
                        if ((pg.status() & 0x80) != 0) {
                            this.wmf.createBrushIndirect(0, this.foreground, this.brushhatch);
                            break block7;
                        }
                        this.wmf.createPatternBrush(pix, w, h);
                    }
                    catch (InterruptedException e) {
                        this.wmf.createBrushIndirect(0, this.foreground, this.brushhatch);
                    }
                } else {
                    this.wmf.createBrushIndirect(0, this.foreground, this.brushhatch);
                }
            } else {
                this.wmf.createBrushIndirect(this.brushfillstyle, this.foreground, this.brushhatch);
            }
        }
        this.wmf.selectObject(this.brushhandle);
        return this.brushhandle;
    }

    @Override
    public int setGDIFont() {
        this.wmf.deleteObject(this.fonthandle);
        this.wmf.createFont(this.font, this.fontescapement, false, false);
        this.wmf.selectObject(this.fonthandle);
        return this.fonthandle;
    }

    @Override
    public void deleteGDIObjects() {
        this.wmf.deleteObject(this.penhandle);
        this.wmf.deleteObject(this.brushhandle);
        this.wmf.deleteObject(this.fonthandle);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Color old = this.foreground;
        this.setColor(this.background);
        this.fillRect(x, y, width, height);
        this.setColor(old);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        System.err.println("clipRect not supported");
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        System.err.println("copyArea not supported");
    }

    @Override
    public Graphics create() {
        System.err.println("create not supported");
        return null;
    }

    @Override
    public Graphics create(int x, int y, int width, int height) {
        System.err.println("create not supported");
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        int xmiddle = x + width / 2;
        int ymiddle = y + height / 2;
        this.wmf.arc(x, y, x + width + 1, y + height + 1, xmiddle + (int)Math.round((double)width * Math.sin(Math.PI * 2 * (double)(startAngle + 90) / 360.0)), ymiddle + (int)Math.round((double)height * Math.cos(Math.PI * 2 * (double)(startAngle + 90) / 360.0)), xmiddle + (int)Math.round((double)width * Math.sin(Math.PI * 2 * (double)(startAngle + arcAngle + 90) / 360.0)), ymiddle + (int)Math.round((double)height * Math.cos(Math.PI * 2 * (double)(startAngle + arcAngle + 90) / 360.0)));
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, x + width, y + height, 0, 0, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        int w = img.getWidth(observer);
        int h = img.getHeight(observer);
        int[] pix = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pix, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            return false;
        }
        if ((pg.status() & 0x80) != 0) {
            return false;
        }
        int dwidth = dx2 - dx1;
        int dheight = dy2 - dy1;
        int swidth = sx2 - sx1;
        int sheight = sy2 - sy1;
        int tmp = sy2;
        sy2 = h - sy1;
        sy1 = h - tmp;
        if (dwidth < 0 != swidth < 0) {
            this.flipHorizontal(pix, w, h);
            sx1 = swidth < 0 ? w - sx1 : w - sx2;
        }
        if (dwidth < 0) {
            dx1 = dx2;
            if (swidth < 0) {
                sx1 = sx2;
            }
            dwidth = -dwidth;
        }
        if (swidth < 0) {
            swidth = -swidth;
        }
        if (dheight < 0 != sheight < 0) {
            this.flipVertical(pix, w, h);
            sy1 = sheight < 0 ? h - sy1 : h - sy2;
        }
        if (dheight < 0) {
            dy1 = dy2;
            if (sheight < 0) {
                sy1 = sy2;
            }
            dheight = -dheight;
        }
        if (sheight < 0) {
            sheight = -sheight;
        }
        int backrgb = bgcolor.getRGB();
        for (int i = 0; i < pix.length; ++i) {
            if ((pix[i] & 0xFF000000) != 0) continue;
            pix[i] = backrgb;
        }
        this.wmf.stretchBlt(dx1, dy1, dwidth, dheight, sx1, sy1, swidth, sheight, 0xCC0020, pix, w, h);
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        int w = img.getWidth(observer);
        int h = img.getHeight(observer);
        int[] pix = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pix, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            return false;
        }
        if ((pg.status() & 0x80) != 0) {
            return false;
        }
        int dwidth = dx2 - dx1;
        int dheight = dy2 - dy1;
        int swidth = sx2 - sx1;
        int sheight = sy2 - sy1;
        int tmp = sy2;
        sy2 = h - sy1;
        sy1 = h - tmp;
        if (dwidth < 0 != swidth < 0) {
            this.flipHorizontal(pix, w, h);
            sx1 = swidth < 0 ? w - sx1 : w - sx2;
        }
        if (dwidth < 0) {
            dx1 = dx2;
            if (swidth < 0) {
                sx1 = sx2;
            }
            dwidth = -dwidth;
        }
        if (swidth < 0) {
            swidth = -swidth;
        }
        if (dheight < 0 != sheight < 0) {
            this.flipVertical(pix, w, h);
            sy1 = sheight < 0 ? h - sy1 : h - sy2;
        }
        if (dheight < 0) {
            dy1 = dy2;
            if (sheight < 0) {
                sy1 = sy2;
            }
            dheight = -dheight;
        }
        if (sheight < 0) {
            sheight = -sheight;
        }
        int[] mask = new int[pix.length];
        for (int i = 0; i < pix.length; ++i) {
            if ((pix[i] & 0xFF000000) == 0) {
                mask[i] = -1;
                pix[i] = 0;
                continue;
            }
            mask[i] = 0;
        }
        this.wmf.stretchBlt(dx1, dy1, dwidth, dheight, sx1, sy1, swidth, sheight, 8913094, mask, w, h);
        this.wmf.stretchBlt(dx1, dy1, dwidth, dheight, sx1, sy1, swidth, sheight, 15597702, pix, w, h);
        return true;
    }

    private void flipHorizontal(int[] pix, int width, int height) {
        for (int i = 0; i < height; ++i) {
            int shift = i * height;
            for (int j = 0; j < width / 2; ++j) {
                int tmp = pix[shift + j];
                pix[shift + j] = pix[shift + width - 1 - j];
                pix[shift + width - 1 - j] = tmp;
            }
        }
    }

    private void flipVertical(int[] pix, int width, int height) {
        int[] line = new int[width];
        for (int i = 0; i < height / 2; ++i) {
            System.arraycopy(pix, i * width, line, 0, width);
            System.arraycopy(pix, (height - i - 1) * width, pix, i * width, width);
            System.arraycopy(line, 0, pix, (height - i - 1) * width, width);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.wmf.moveTo(x1, y1);
        this.wmf.lineTo(x2, y2);
        this.wmf.setPixel(x2, y2, this.getColor());
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.wmf.ellipse(x, y, x + width + 1, y + height + 1);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.wmf.polygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.wmf.polyline(xPoints, yPoints, nPoints);
        this.wmf.setPixel(xPoints[nPoints - 1], yPoints[nPoints - 1], this.getColor());
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.wmf.rectangle(x, y, x + width + 1, y + height + 1);
    }

    @Override
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.drawRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.wmf.roundRect(x, y, x + width + 1, y + height + 1, arcWidth, arcHeight);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.wmf.textOut(x, y, str);
    }

    @Override
    public void drawString(AttributedCharacterIterator text, int x, int y) {
        System.err.println("drawString(java.text.AttributedCharacterIterator,..) not supported");
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.setGDIFillBrush();
        int xmiddle = x + width / 2;
        int ymiddle = y + height / 2;
        this.wmf.pie(x, y, x + width + 1, y + height + 1, xmiddle + (int)Math.round((double)width * Math.sin(Math.PI * 2 * (double)(startAngle + 90) / 360.0)), ymiddle + (int)Math.round((double)height * Math.cos(Math.PI * 2 * (double)(startAngle + 90) / 360.0)), xmiddle + (int)Math.round((double)width * Math.sin(Math.PI * 2 * (double)(startAngle + arcAngle + 90) / 360.0)), ymiddle + (int)Math.round((double)height * Math.cos(Math.PI * 2 * (double)(startAngle + arcAngle + 90) / 360.0)));
        this.setGDIHollowBrush();
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.setGDIFillBrush();
        this.drawOval(x, y, width, height);
        this.setGDIHollowBrush();
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.setGDIFillBrush();
        this.drawPolygon(xPoints, yPoints, nPoints);
        this.setGDIHollowBrush();
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.setGDIFillBrush();
        this.drawRect(x, y, width, height);
        this.setGDIHollowBrush();
    }

    @Override
    public void setDrawBorderFor3DRect(boolean b) {
        this.drawBorder = b;
    }

    @Override
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.fillRect(x, y, width, height);
        if (this.drawBorder) {
            Color backupColor = this.foreground;
            this.setColor(Color.black);
            this.drawRect(x, y, width, height);
            this.setColor(backupColor);
        }
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.setGDIFillBrush();
        this.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.setGDIHollowBrush();
    }

    @Override
    public Shape getClip() {
        return null;
    }

    @Override
    public Rectangle getClipRect() {
        return null;
    }

    @Override
    public Rectangle getClipBounds() {
        System.err.println("getClipBounds not supported");
        return null;
    }

    @Override
    public Color getColor() {
        return this.foreground;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
    }

    @Override
    public void setClip(Shape clip) {
    }

    @Override
    public void setColor(Color newcolor) {
        this.foreground = newcolor;
        this.setGDIPen();
        this.wmf.setTextColor(this.foreground);
    }

    @Override
    public void setFont(Font newfont) {
        this.font = newfont;
        this.setGDIFont();
    }

    @Override
    public void setPaintMode() {
        System.err.println("setPaintMode not supported");
    }

    @Override
    public void setXORMode(Color c1) {
        System.err.println("setXORMode not supported");
    }

    @Override
    public void translate(int x, int y) {
        this.wmf.setWindowOrg(-x, -y);
    }
}

