/*
 * Decompiled with CFR 0.152.
 */
package quadbase.ChartAPI;

import java.applet.Applet;
import java.io.PrintStream;
import quadbase.ChartAPI.DBInfo;
import quadbase.ChartAPI.DbData;
import quadbase.chart.ColData;
import quadbase.chart.DBAccess;
import quadbase.chart.DataFileInput;
import quadbase.chart.EJBAccess;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.util.IDatabaseInfo;
import quadbase.util.IQueryFileInfo;
import quadbase.util.IResultSet;
import quadbase.util.ISpreadSheetModel;
import quadbase.util.internal.TransposeRS;

public class DataSheet {
    private ColData[] colData = null;
    boolean doTranspose = false;
    boolean[] transposeCol;
    Object source = null;
    int dataFileType = 0;

    public DataSheet(Applet applet, IDatabaseInfo dbInfo, boolean doTranspose) {
        this(applet, dbInfo, doTranspose, null);
    }

    public DataSheet(Applet applet, IDatabaseInfo dbInfo, boolean doTranspose, int[] transposeColIdx) {
        try {
            ServerMessage.setApplet(applet);
            boolean[] transposeCol = TransposeRS.getTransposeColumn(transposeColIdx);
            if (dbInfo instanceof IQueryFileInfo) {
                QueryFileInfo queryFileInfo = new QueryFileInfo((IQueryFileInfo)dbInfo);
                this.colData = DBAccess.retrieveResult(QueryFileInfo.getDBAccessParameter(queryFileInfo), queryFileInfo, true, doTranspose, transposeCol, null, null);
            } else {
                this.colData = DBInfo.getColData(dbInfo, doTranspose, transposeCol);
            }
            this.createColDataFail();
            this.source = dbInfo;
            this.doTranspose = doTranspose;
            this.transposeCol = transposeCol;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public DataSheet(Applet applet, String dataFile, boolean doTranspose) {
        this(applet, dataFile, doTranspose, null, 0);
    }

    public DataSheet(Applet applet, String dataFile, boolean doTranspose, int[] transposeColIdx) {
        this(applet, dataFile, doTranspose, transposeColIdx, 0);
    }

    public DataSheet(Applet applet, String dataFile, boolean doTranspose, int[] transposeColIdx, int dataFileType) {
        try {
            ServerMessage.setApplet(applet);
            this.dataFileType = dataFileType;
            int tmp = 2;
            if (dataFileType == 3) {
                tmp = 6;
            } else if (dataFileType == 2) {
                tmp = 4;
            }
            boolean[] transposeCol = TransposeRS.getTransposeColumn(transposeColIdx);
            this.colData = new DataFileInput().readProcessedData(dataFile, doTranspose, transposeCol, null, tmp);
            this.createColDataFail();
            this.source = dataFile;
            this.doTranspose = doTranspose;
            this.transposeCol = transposeCol;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public DataSheet(Applet applet, IResultSet data, boolean doTranspose) {
        this(applet, data, doTranspose, null);
    }

    public DataSheet(Applet applet, IResultSet data, boolean doTranspose, int[] transposeColIdx) {
        try {
            ServerMessage.setApplet(applet);
            boolean[] transposeCol = TransposeRS.getTransposeColumn(transposeColIdx);
            if (doTranspose) {
                data = TransposeRS.doTranspose(data, transposeCol);
            }
            this.colData = data instanceof DbData ? ((DbData)data).getColData() : ColData.getColData(data);
            this.createColDataFail();
            this.source = null;
            this.doTranspose = doTranspose;
            this.transposeCol = transposeCol;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public DataSheet(Applet applet, EJBInfo ejbInfo) {
        this(applet, ejbInfo, false, null);
    }

    public DataSheet(Applet applet, EJBInfo ejbInfo, boolean doTranspose) {
        this(applet, ejbInfo, doTranspose, null);
    }

    public DataSheet(Applet applet, EJBInfo ejbInfo, boolean doTranspose, int[] transposeColIdx) {
        try {
            ServerMessage.setApplet(applet);
            boolean[] transposeCol = TransposeRS.getTransposeColumn(transposeColIdx);
            this.colData = EJBAccess.retrieveResult(ejbInfo.getJNDIName(), ejbInfo.getHomeName(), ejbInfo.getRemoteName(), ejbInfo.getSelectedMethodName(), ejbInfo.getSelectedMethodParamVal(), ejbInfo.getEnvironment(), doTranspose, transposeCol, null, null);
            this.createColDataFail();
            this.source = ejbInfo;
            this.doTranspose = doTranspose;
            this.transposeCol = transposeCol;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public DataSheet(Applet applet, XMLFileQueryInfo xmlFileQueryInfo, boolean doTranspose, int[] transposeColIdx) {
        try {
            ServerMessage.setApplet(applet);
            boolean[] transposeCol = TransposeRS.getTransposeColumn(transposeColIdx);
            this.colData = new DataFileInput().readProcessedData(xmlFileQueryInfo.getFileName(), doTranspose, transposeCol, null, null, xmlFileQueryInfo, 7);
            this.createColDataFail();
            this.source = xmlFileQueryInfo;
            this.doTranspose = doTranspose;
            this.transposeCol = transposeCol;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public DataSheet(Applet applet, ISpreadSheetModel spreadSheet) {
        try {
            ServerMessage.setApplet(applet);
            this.colData = ColData.getColData(spreadSheet);
            this.createColDataFail();
            this.source = null;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    private void createColDataFail() throws Exception {
        if (this.colData == null || this.colData.length <= 0) {
            throw new Exception("Fail to create data sheet");
        }
    }

    public void transpose() throws Exception {
        this.transpose(null);
    }

    public void transpose(int[] transposeCol) throws Exception {
        boolean[] transposeColData = TransposeRS.getTransposeColumn(transposeCol);
        IResultSet rs = TransposeRS.doTranspose(this.colData, transposeColData);
        if (rs != null) {
            this.colData = ColData.getColData(rs);
        }
        this.doTranspose = true;
        this.transposeCol = transposeColData;
    }

    public int getRowCount() {
        return this.colData[0].getDataSet().size();
    }

    public int getColumnCount() {
        return this.colData.length - 1;
    }

    public Object[] getRow(int no) {
        if (no >= this.colData[0].getDataSet().size()) {
            return null;
        }
        Object[] record = new Object[this.colData.length - 1];
        for (int i = 0; i < record.length; ++i) {
            record[i] = this.colData[i].getDataSet().elementAt(no);
        }
        return record;
    }

    public void addRow(Object[] record) {
        int nRow = this.getRowCount();
        int nCol = this.getColumnCount();
        if (record == null || record.length != nCol) {
            return;
        }
        for (int i = 0; i < record.length; ++i) {
            this.colData[i].add(record[i]);
            this.colData[i].bGenUniqueName = false;
        }
        Integer lastElt = null;
        if (this.colData[nCol].getDataSet().size() >= 0) {
            lastElt = (Integer)this.colData[nCol].getDataSet().elementAt(this.colData[nCol].getDataSet().size() - 1);
        }
        if (lastElt != null) {
            int idx = nRow != 0 ? lastElt : -1;
            this.colData[nCol].add(idx + 1);
        }
    }

    public void deleteRow(int no) {
        int nRow = this.getRowCount();
        int nCol = this.getColumnCount();
        if (no >= nRow || nRow == 0) {
            return;
        }
        for (int i = 0; i <= nCol; ++i) {
            this.colData[i].getDataSet().removeElementAt(no);
            this.colData[i].bGenUniqueName = false;
        }
    }

    public void updateRow(Object[] record, int no) {
        if (no >= this.colData[0].getSize()) {
            return;
        }
        int nCol = this.getColumnCount();
        if (record == null || record.length != nCol) {
            return;
        }
        for (int i = 0; i < record.length; ++i) {
            this.colData[i].getDataSet().setElementAt(record[i], no);
            this.colData[i].bGenUniqueName = false;
        }
    }

    public void print(PrintStream out, int separator, int format) {
        ColData.print(out, this.colData, separator, format);
    }

    ColData[] getColData() {
        return this.colData;
    }

    Object getSource() {
        return this.source;
    }

    int getSourceType() {
        if (this.source == null) {
            return 0;
        }
        if (this.source instanceof IDatabaseInfo) {
            return 1;
        }
        if (this.source instanceof XMLFileQueryInfo) {
            return 7;
        }
        if (this.source instanceof EJBInfo) {
            return 5;
        }
        if (this.dataFileType == 2) {
            return 4;
        }
        if (this.dataFileType == 3) {
            return 6;
        }
        return 2;
    }

    boolean isTranspose() {
        return this.doTranspose;
    }

    int[] getTransposedColumn() {
        return TransposeRS.getTransposeIndex(this.transposeCol);
    }
}

