/*
 * Decompiled with CFR 0.152.
 */
package quadbase.ChartAPI;

import quadbase.chart.ColData;
import quadbase.chart.IOUtil2;
import quadbase.common.util.internal.DataType;
import quadbase.util.IRSMetaData;
import quadbase.util.IResultSet;

public class DbData
implements IResultSet {
    ColData[] colData = null;
    IResultSet rs;

    public DbData(String[] dataType, String[] fieldName, String[][] records) throws IllegalArgumentException {
        if (dataType == null || fieldName == null || records == null) {
            throw new IllegalArgumentException("[DbData] Invalid null input");
        }
        int recsize = dataType.length;
        if (fieldName.length != recsize) {
            throw new IllegalArgumentException("[DbData] Length of dataType must equal to length of fieldName");
        }
        int recNo = records.length;
        int i = 0;
        int j = 0;
        for (i = 0; i < recNo; ++i) {
            if (records[i].length == recsize) continue;
            throw new IllegalArgumentException("[DbData] Length of record in position " + i + " must equal to " + recsize);
        }
        this.colData = new ColData[recsize + 1];
        for (i = 0; i < recsize; ++i) {
            this.colData[i] = new ColData(fieldName[i], DataType.findType(dataType[i]), this.colData.length);
        }
        try {
            for (i = 0; i < recNo; ++i) {
                for (j = 0; j < recsize; ++j) {
                    this.colData[j].add(DataType.createObject(records[i][j], this.colData[j].getDataType()));
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Data type and value don't match in record " + i + " field " + j);
        }
        this.colData[recsize] = new ColData("qbCount", 4, this.colData.length);
        for (i = 0; i < recNo; ++i) {
            this.colData[recsize].add(i);
        }
        this.rs = ColData.getResultSet(this.colData);
    }

    public DbData(String[] fieldName, Object[][] records) throws IllegalArgumentException {
        if (fieldName == null || records == null) {
            throw new IllegalArgumentException("[DbData] Invalid null input");
        }
        int recsize = fieldName.length;
        int recNo = records.length;
        if (recNo == 0) {
            throw new IllegalArgumentException("[DbData] No record input");
        }
        int i = 0;
        int j = 0;
        int[] dataType = new int[recsize];
        block2: for (i = 0; i < recsize; ++i) {
            for (j = 0; j < recNo; ++j) {
                if (records[j][i] == null) continue;
                dataType[i] = DataType.findType(records[j][i]);
                continue block2;
            }
        }
        for (i = 0; i < recNo; ++i) {
            if (records[i].length != recsize) {
                throw new IllegalArgumentException("[DbData] Length of record in position " + i + " must equal to " + recsize);
            }
            for (j = 0; j < recsize; ++j) {
                if (records[i][j] == null || DataType.findType(records[i][j]) == dataType[j]) continue;
                throw new IllegalArgumentException("[DbData] mismatch Object type, record " + i + " field " + j + " and record 0 field " + j);
            }
        }
        this.colData = new ColData[recsize + 1];
        for (i = 0; i < recsize; ++i) {
            this.colData[i] = new ColData(fieldName[i], dataType[i], this.colData.length);
        }
        try {
            for (i = 0; i < recNo; ++i) {
                for (j = 0; j < recsize; ++j) {
                    this.colData[j].add(records[i][j]);
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Data type and value don't match in record " + i + " field " + j);
        }
        this.colData[recsize] = new ColData("qbCount", 4, this.colData.length);
        for (i = 0; i < recNo; ++i) {
            this.colData[recsize].add(i);
        }
        this.rs = ColData.getResultSet(this.colData);
    }

    public DbData(ColData[] colData) {
        this.colData = colData;
        this.rs = ColData.getResultSet(colData);
    }

    public DbData(String s) throws IllegalArgumentException {
        try {
            this.colData = IOUtil2.getColData(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.rs = ColData.getResultSet(this.colData);
    }

    public ColData[] getColData() {
        return this.colData;
    }

    @Deprecated
    public String[] getFieldName() {
        String[] sarray = new String[this.colData.length - 1];
        for (int i = 0; i < this.colData.length - 1; ++i) {
            sarray[i] = this.colData[i].getName();
        }
        return sarray;
    }

    @Deprecated
    public int[] getFieldType() {
        int[] iarray = new int[this.colData.length - 1];
        for (int i = 0; i < this.colData.length - 1; ++i) {
            iarray[i] = this.colData[i].getOriginalDataType();
        }
        return iarray;
    }

    public Object[][] getData() {
        Object[][] data = new Object[this.colData[0].getSize()][this.colData.length - 1];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = this.colData[j].getDataSet().elementAt(i);
            }
        }
        return data;
    }

    @Override
    public final boolean next() throws Exception {
        return this.rs.next();
    }

    @Override
    public final void close() throws Exception {
        this.rs.close();
    }

    @Override
    public final IRSMetaData getMetaData() throws Exception {
        return this.rs.getMetaData();
    }

    @Override
    public final Object getObject(int col) throws Exception {
        return this.rs.getObject(col);
    }
}

