/*
 * Decompiled with CFR 0.152.
 */
package quadbase.ChartAPI;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import quadbase.ChartAPI.ColInfo;
import quadbase.ChartAPI.DBInfo;
import quadbase.ChartAPI.DataSheet;
import quadbase.ChartAPI.DbData;
import quadbase.ChartAPI.DrillDownChart;
import quadbase.ChartAPI.IExportConstants;
import quadbase.ChartAPI.QbChartBasic;
import quadbase.chart.AddOnChart;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.ColMetaData;
import quadbase.chart.DBAccess;
import quadbase.chart.DataFileInput;
import quadbase.chart.DrillDownNode;
import quadbase.chart.DrillHistory;
import quadbase.chart.EJBAccess;
import quadbase.chart.ExcelAccess;
import quadbase.chart.GraphicsTable;
import quadbase.chart.LoadChart;
import quadbase.chart.OLAPAccess;
import quadbase.chart.PreprocInfo;
import quadbase.chart.ReadDataFile;
import quadbase.chart.ReloadChart;
import quadbase.chart.SOAPAccess;
import quadbase.chart.SalesForceAccess;
import quadbase.chart.SaveChart;
import quadbase.chart.ValueTable;
import quadbase.common.client.ServerMessage;
import quadbase.common.param.ChartParameterPage;
import quadbase.common.param.HtmlParameterPageWriter;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.IAlertable;
import quadbase.common.util.ICustomParameterDateFormat;
import quadbase.common.util.IDatabaseInfo;
import quadbase.common.util.internal.ClassFileUtil;
import quadbase.common.util.internal.CopyFile;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IChart;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.QbConnection;
import quadbase.common.util.internal.QbDebug;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.util.I3DControlPanel;
import quadbase.util.I3DPropertySet;
import quadbase.util.IAggregationInfo;
import quadbase.util.IAnnotationSet;
import quadbase.util.IAxis;
import quadbase.util.IAxisRuler;
import quadbase.util.IBoxPropertySet;
import quadbase.util.IBubblePropertySet;
import quadbase.util.ICanvas;
import quadbase.util.IChartGraphics;
import quadbase.util.IChartTypeConstants;
import quadbase.util.IColumnMap;
import quadbase.util.IControlRangeSet;
import quadbase.util.ICustomizeImageMapDataHintBox;
import quadbase.util.IDataLineSet;
import quadbase.util.IDataPointSet;
import quadbase.util.IDialPropertySet;
import quadbase.util.IDoughnutPropertySet;
import quadbase.util.IDrillDown;
import quadbase.util.IDropBarSet;
import quadbase.util.IFlashHintBoxPropertySet;
import quadbase.util.IFloatingLineSet;
import quadbase.util.IFloatingTextSet;
import quadbase.util.IGanttPropertySet;
import quadbase.util.IHistogramInfo;
import quadbase.util.IHyperLinkSet;
import quadbase.util.IInputData;
import quadbase.util.ILegend;
import quadbase.util.ILinePropertySet;
import quadbase.util.IMouseEventSet;
import quadbase.util.INoDataToPlotMessage;
import quadbase.util.IOLAPResultSet;
import quadbase.util.IOverlayPropertySet;
import quadbase.util.IPiePropertySet;
import quadbase.util.IPlot;
import quadbase.util.IPolarPropertySet;
import quadbase.util.IPopupMenu;
import quadbase.util.IQueryFileInfo;
import quadbase.util.IQueryInParam;
import quadbase.util.IQueryMultiValueInParam;
import quadbase.util.IRadarPropertySet;
import quadbase.util.IResultSet;
import quadbase.util.ISecondaryChart;
import quadbase.util.ISpreadSheetModel;
import quadbase.util.IStringCustomizer;
import quadbase.util.ISurfacePropertySet;
import quadbase.util.ITable;
import quadbase.util.ITextString;
import quadbase.util.ITrendLineSet;
import quadbase.util.IZoomInfo;
import quadbase.util.PickData;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.QbUtil;
import quadbase.util.internal.TransposeRS;

public class QbChart
extends QbChartBasic
implements IChartTypeConstants,
IExportConstants,
IChart,
IAlertable {
    public static final int VIEW2D = 0;
    public static final int VIEW3D = 1;
    public static final int OLAPDATA_TRANSPOSECOLBREAK = 0;
    public static final int OLAPDATA_DIRECT = 1;
    public static final int OLAPDATA_CONCATENATELABEL = 2;
    private static final String[] deftype = new String[]{"string", "int"};
    private static final String[] defname = new String[]{"", ""};
    private static final String[][] defdata = new String[0][];
    private boolean[] selectAllInfo;
    private boolean[] needUpdate;

    public QbChart() {
        this((Applet)null, 0, 0, (IResultSet)new DbData(deftype, defname, defdata), (IColumnMap)new ColInfo(-1, 0, -1, 1));
    }

    public QbChart(Chart chart) {
        this.chart = chart;
        this.initDrillDownTree(chart, null);
    }

    public QbChart(Applet applet, String fileName) {
        this(applet, fileName, false);
    }

    public QbChart(Applet applet, String fileName, Object[] parameter) {
        this.initQbChartWithParamObjs(applet, fileName, parameter, false, false);
    }

    public QbChart(Applet applet, String fileName, Object[] parameter, boolean isEnterpriseServer) {
        this.initQbChartWithParamObjs(applet, fileName, parameter, isEnterpriseServer, false);
    }

    public QbChart(Applet applet, String fileName, Object[] parameter, Properties props) {
        boolean isEnterpriseServer = false;
        boolean useBackupData = false;
        if (props != null) {
            String str1 = (String)props.get("prompt parameter");
            if (str1 != null && str1.equalsIgnoreCase("false")) {
                isEnterpriseServer = true;
            }
            if ((str1 = (String)props.get("use backup data")) != null && str1.equalsIgnoreCase("true")) {
                useBackupData = true;
            }
        }
        this.initQbChartWithParamObjs(applet, fileName, parameter, isEnterpriseServer, useBackupData);
    }

    private void initQbChartWithParamObjs(Applet applet, String fileName, Object[] parameter, boolean isEnterpriseServer, boolean useBackupData) {
        ServerMessage.setApplet(applet);
        try {
            Vector<Object[]> p = new Vector<Object[]>();
            p.addElement(parameter);
            this.chart = this.loadChartFromFile(fileName, isEnterpriseServer, p, useBackupData);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        finally {
            if (!forExportOnly && this.errorMessage == null) {
                this.initPanel();
                this.vpanel3d.filename = fileName;
            }
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
    }

    public QbChart(Applet applet, String fileName, boolean isEnterpriseServer) {
        ServerMessage.setApplet(applet);
        try {
            this.chart = this.loadChartFromFile(fileName, isEnterpriseServer);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        finally {
            if (!forExportOnly && this.errorMessage == null) {
                this.initPanel();
                this.vpanel3d.filename = fileName;
            }
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
    }

    @Deprecated
    public QbChart(Frame frame, String fileName) {
        this((Applet)null, fileName);
    }

    public QbChart(Applet applet, int dimension, int chartType, quadbase.util.IDatabaseInfo dbinfo, IColumnMap cmap) {
        this(applet, dimension, chartType, dbinfo, cmap, null);
    }

    @Deprecated
    public QbChart(Frame frame, int dimension, int chartType, quadbase.util.IDatabaseInfo dbinfo, IColumnMap cmap) {
        this((Applet)null, dimension, chartType, dbinfo, cmap, null);
    }

    public QbChart(Applet applet, int dimension, int chartType, quadbase.util.IDatabaseInfo dbinfo, IColumnMap cmap, String template) {
        this(applet, dimension, chartType, dbinfo, false, cmap, template);
    }

    public QbChart(Applet applet, int dimension, int chartType, quadbase.util.IDatabaseInfo dbinfo, boolean doTransposeData, IColumnMap cmap, String template) {
        this(applet, dimension, chartType, dbinfo, doTransposeData, null, cmap, template);
    }

    public QbChart(Applet applet, int dimension, int chartType, quadbase.util.IDatabaseInfo dbinfo, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template) {
        try {
            this.createFromIDatabaseInfo(applet, dimension, chartType, dbinfo, doTransposeData, TransposeRS.getTransposeColumn(transposeCol), cmap, template);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
    }

    @Deprecated
    public QbChart(Frame frame, int dimension, int chartType, quadbase.util.IDatabaseInfo dbinfo, IColumnMap cmap, String template) {
        this((Applet)null, dimension, chartType, dbinfo, cmap, template);
    }

    @Deprecated
    public QbChart(Applet applet, int dimension, int chartType, String dataFile, IColumnMap cmap) {
        this(applet, dimension, chartType, dataFile, cmap, null);
    }

    @Deprecated
    public QbChart(Frame frame, int dimension, int chartType, String dataFile, IColumnMap cmap) {
        this((Applet)null, dimension, chartType, dataFile, cmap, null);
    }

    public QbChart(Applet applet, int dimension, int chartType, EJBInfo ejbInfo, IColumnMap cmap, String template) {
        this(applet, dimension, chartType, ejbInfo.getJNDIName(), ejbInfo.getHomeName(), ejbInfo.getRemoteName(), ejbInfo.getSelectedMethodName(), ejbInfo.getSelectedMethodParamVal(), ejbInfo.getEnvironment(), cmap, template, false, null);
    }

    public QbChart(Frame frame, int dimension, int chartType, EJBInfo ejbInfo, IColumnMap cmap, String template) {
        this((Applet)null, dimension, chartType, ejbInfo, cmap, template);
    }

    public QbChart(Applet applet, int dimension, int chartType, String jndiName, String homeName, String remoteName, String selectedMethodName, Object[] selectedMethodParamVal, IColumnMap cmap, String template) {
        this(applet, dimension, chartType, jndiName, homeName, remoteName, selectedMethodName, selectedMethodParamVal, null, cmap, template, false, null);
    }

    public QbChart(Frame frame, int dimension, int chartType, String jndiName, String homeName, String remoteName, String selectedMethodName, Object[] selectedMethodParamVal, IColumnMap cmap, String template) {
        this(null, dimension, chartType, jndiName, homeName, remoteName, selectedMethodName, selectedMethodParamVal, null, cmap, template, false, null);
    }

    public QbChart(Applet applet, int dimension, int chartType, String jndiName, String homeName, String remoteName, String selectedMethodName, Object[] selectedMethodParamVal, Hashtable<String, String> environment, IColumnMap cmap, String template, boolean doTransposeData, boolean[] transposeCol) {
        ColData[] colData;
        ServerMessage.setApplet(applet);
        try {
            colData = EJBAccess.retrieveResult(jndiName, homeName, remoteName, selectedMethodName, selectedMethodParamVal, environment, doTransposeData, transposeCol, null, null);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (colData == null) {
            throw new IllegalArgumentException("Invalid argument(s).  Cannot create the chart");
        }
        this.createChart(dimension, chartType, colData, cmap, template);
        this.chart.jndiName = jndiName;
        this.chart.homeName = homeName;
        this.chart.remoteName = remoteName;
        this.chart.selectedMethodName = selectedMethodName;
        this.chart.selectedMethodParamVal = selectedMethodParamVal;
        this.chart.environment = environment;
        this.chart.setTransposed(doTransposeData, transposeCol);
    }

    public QbChart(Applet applet, int dimension, int chartType, SOAPQueryFileInfo soapInfo, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template) {
        this(applet, dimension, chartType, soapInfo, doTransposeData, transposeCol, cmap, template, false);
    }

    public QbChart(Applet applet, int dimension, int chartType, SOAPQueryFileInfo soapInfo, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template, boolean disableParamDialog) {
        ServerMessage.setApplet(applet);
        boolean[] transposeColBool = TransposeRS.getTransposeColumn(transposeCol);
        try {
            if (!disableParamDialog && soapInfo.isParameterized()) {
                try {
                    QueryFileInfo.getParameter(soapInfo, false, disableParamDialog, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ColData[] colData = SOAPAccess.retrieveResult(soapInfo, doTransposeData, transposeColBool);
            this.createChart(dimension, chartType, colData, cmap, template);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
        this.chart.setTransposed(doTransposeData, transposeColBool);
        this.chart.sourceData = 12;
        this.chart.soapInfo = soapInfo;
        if (soapInfo.isParameterized()) {
            this.chart.dbInfo = soapInfo;
            this.chart.setQueryFileInfo(soapInfo);
        }
    }

    public QbChart(Applet applet, int dimension, int chartType, SalesForceQueryFileInfo sfQueryInfo, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template) {
        this(applet, dimension, chartType, sfQueryInfo, doTransposeData, transposeCol, cmap, template, false);
    }

    public QbChart(Applet applet, int dimension, int chartType, SalesForceQueryFileInfo sfQueryInfo, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template, boolean disableParamDialog) {
        ServerMessage.setApplet(applet);
        try {
            if (!disableParamDialog && sfQueryInfo.getInParam() != null) {
                try {
                    QueryFileInfo.getParameter(sfQueryInfo, false, disableParamDialog, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ColData[] colData = SalesForceAccess.getColData(sfQueryInfo, doTransposeData, transposeCol);
            this.createChart(dimension, chartType, colData, cmap, template);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
        this.chart.setTransposed(doTransposeData, TransposeRS.getTransposeColumn(transposeCol));
        this.chart.sourceData = 11;
        this.chart.sfQueryInfo = sfQueryInfo;
        if (sfQueryInfo.isParameterized()) {
            this.chart.dbInfo = sfQueryInfo;
            this.chart.setQueryFileInfo(sfQueryInfo);
        }
    }

    public QbChart(Applet applet, int dimension, int chartType, ExcelFileInfo excelInfo, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template) {
        ServerMessage.setApplet(applet);
        try {
            ColData[] colData = ExcelAccess.getColData(excelInfo, doTransposeData, transposeCol);
            this.createChart(dimension, chartType, colData, cmap, template);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
        this.chart.setTransposed(doTransposeData, TransposeRS.getTransposeColumn(transposeCol));
        this.chart.sourceData = 13;
        this.chart.excelInfo = excelInfo;
    }

    public QbChart(Applet applet, int dimension, int chartType, String connectionString, String MDXQuery, int inputMethod, IColumnMap cmap, String template, boolean doTransposeData, boolean[] transposeCol) {
        this(applet, dimension, chartType, null, connectionString, MDXQuery, null, null, null, inputMethod, cmap, template, doTransposeData, transposeCol);
    }

    public QbChart(Applet applet, int dimension, int chartType, String uri, String datasource, String catalog, String MDXQuery, int inputMethod, IColumnMap cmap, String template, boolean doTransposeData, boolean[] transposeCol) {
        this(applet, dimension, chartType, null, null, MDXQuery, uri, datasource, catalog, inputMethod, cmap, template, doTransposeData, transposeCol);
    }

    public QbChart(Applet applet, int dimension, int chartType, IOLAPResultSet olapRS, int inputMethod, IColumnMap cmap, String template, boolean doTransposeData, boolean[] transposeCol) {
        this(applet, dimension, chartType, olapRS, null, null, null, null, null, inputMethod, cmap, template, doTransposeData, transposeCol);
    }

    private QbChart(Applet applet, int dimension, int chartType, IOLAPResultSet olapRS, String connectionString, String MDXQuery, String uri, String datasource, String catalog, int inputMethod, IColumnMap cmap, String template, boolean doTransposeData, boolean[] transposeCol) {
        ColData[] colData;
        ServerMessage.setApplet(applet);
        try {
            OLAPAccess olapAccess = new OLAPAccess(olapRS, connectionString, MDXQuery, uri, datasource, catalog);
            colData = olapAccess.retrieveResult(inputMethod);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (colData == null) {
            throw new IllegalArgumentException("Invalid argument(s).  Cannot create the chart");
        }
        this.createChart(dimension, chartType, colData, cmap, template);
        this.chart.olapRS = olapRS;
        if (connectionString != null) {
            this.chart.mondrianConnectionString = connectionString;
        }
        this.chart.MDXQuery = MDXQuery;
        if (uri != null) {
            this.chart.xmlaURI = uri;
        }
        if (datasource != null) {
            this.chart.xmlaDataSource = datasource;
        }
        if (catalog != null) {
            this.chart.xmlaCatalog = catalog;
        }
        this.chart.inputMethod = inputMethod;
        this.chart.sourceData = 10;
        this.chart.setTransposed(doTransposeData, transposeCol);
    }

    @Deprecated
    public QbChart(Applet applet, int dimension, int chartType, String dataFile, IColumnMap cmap, String template) {
        this(applet, dimension, chartType, dataFile, false, cmap, template);
    }

    @Deprecated
    public QbChart(Applet applet, int dimension, int chartType, String dataFile, boolean doTransposeData, IColumnMap cmap, String template) {
        this(applet, dimension, chartType, dataFile, doTransposeData, null, cmap, template);
    }

    @Deprecated
    public QbChart(Applet applet, int dimension, int chartType, String dataFile, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template) {
        try {
            this.createFromDataFile(applet, dimension, chartType, dataFile, doTransposeData, TransposeRS.getTransposeColumn(transposeCol), cmap, template, 2);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
    }

    public QbChart(Applet applet, int dimension, int chartType, int fileType, String filename, boolean doTransposeData, IColumnMap cmap, String template) throws Exception {
        this(applet, dimension, chartType, fileType, filename, doTransposeData, null, cmap, template);
    }

    public QbChart(Applet applet, int dimension, int chartType, int fileType, String filename, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template) throws Exception {
        if (fileType == 1) {
            QueryFileInfo info = QueryFileInfo.readFile(filename);
            this.createFromIDatabaseInfo(applet, dimension, chartType, info, doTransposeData, TransposeRS.getTransposeColumn(transposeCol), cmap, template);
            this.chart.queryFilename = filename;
        } else if (fileType == 0 || fileType == 2 || fileType == 3) {
            int tmp = 2;
            if (fileType == 3) {
                tmp = 6;
            } else if (fileType == 2) {
                tmp = 4;
            }
            this.createFromDataFile(applet, dimension, chartType, filename, doTransposeData, TransposeRS.getTransposeColumn(transposeCol), cmap, template, tmp);
        } else {
            throw new IllegalArgumentException("Illegal fileType");
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
    }

    public QbChart(Applet applet, int dimension, int chartType, XMLFileQueryInfo xmlInfo, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template) throws Exception {
        int tmp = 7;
        this.createFromDataFile(applet, dimension, chartType, xmlInfo.getFileName(), xmlInfo, doTransposeData, TransposeRS.getTransposeColumn(transposeCol), cmap, template, tmp);
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
    }

    public QbChart(Applet applet, int dimension, int chartType, String className, QueryInParamSet queryInParamSet, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template) throws Exception {
        int tmp = 6;
        this.createFromDataFile(applet, dimension, chartType, className, null, queryInParamSet, doTransposeData, TransposeRS.getTransposeColumn(transposeCol), cmap, template, tmp);
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
    }

    public QbChart(Frame frame, int dimension, int chartType, XMLFileQueryInfo xmlInfo, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template) throws Exception {
        this((Applet)null, dimension, chartType, xmlInfo, doTransposeData, transposeCol, cmap, template);
    }

    public static final void setDebugMode(int mode) {
        QbDebug.setDebugMode(mode);
    }

    public static final void setDebugMode(String mode) {
        QbDebug.setDebugMode(mode);
    }

    private void createFromIDatabaseInfo(Applet applet, int dimension, int chartType, IDatabaseInfo dbinfo, boolean doTransposeData, boolean[] transposeCol, IColumnMap cmap, String template) throws Exception {
        this.createFromIDatabaseInfo(applet, dimension, chartType, dbinfo, doTransposeData, transposeCol, cmap, template, !QbChart.isChartServerUsed());
    }

    private void createFromIDatabaseInfo(Applet applet, int dimension, int chartType, IDatabaseInfo dbinfo, boolean doTransposeData, boolean[] transposeCol, IColumnMap cmap, String template, boolean disableParamDialog) throws Exception {
        ServerMessage.setApplet(applet);
        ColData[] colData = null;
        QueryFileInfo queryFileInfo = null;
        if (dbinfo instanceof IQueryFileInfo) {
            queryFileInfo = new QueryFileInfo((IQueryFileInfo)dbinfo);
            if (!disableParamDialog) {
                colData = DBAccess.retrieveResult(QueryFileInfo.getDBAccessParameter(queryFileInfo), queryFileInfo, true, doTransposeData, transposeCol, null, null);
            } else {
                QueryFileInfo.verify(queryFileInfo);
                colData = DBAccess.retrieveResult(QueryFileInfo.getParameter(queryFileInfo, false, disableParamDialog, true), queryFileInfo, true, doTransposeData, transposeCol, null, null);
            }
        } else {
            colData = DBInfo.getColData(dbinfo, doTransposeData, transposeCol);
        }
        this.createChart(dimension, chartType, colData, cmap, template);
        if (this.errorMessage != null && this.errorMessage.equalsIgnoreCase(SURFACEDATAERROR)) {
            throw new IllegalArgumentException("The data cannot plot a 3D surface chart");
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Invalid argument(s).  Cannot create the chart");
        }
        this.chart.setTransposed(doTransposeData, transposeCol);
        this.chart.sourceData = 1;
        this.chart.dbInfo = queryFileInfo != null ? queryFileInfo : new DBInfo(dbinfo);
        if (dbinfo instanceof IQueryFileInfo) {
            this.chart.queryFilename = null;
            this.chart.setQueryFileInfo(queryFileInfo);
        } else {
            this.chart.queryFilename = null;
            this.chart.setQueryFileInfo(null);
        }
    }

    private void createFromDataFile(Applet applet, int dimension, int chartType, String dataFile, boolean doTransposeData, boolean[] transposeCol, IColumnMap cmap, String template, int dataFileType) throws Exception {
        this.createFromDataFile(applet, dimension, chartType, dataFile, null, doTransposeData, transposeCol, cmap, template, dataFileType);
    }

    private void createFromDataFile(Applet applet, int dimension, int chartType, String dataFile, XMLFileQueryInfo xmlFileQueryInfo, boolean doTransposeData, boolean[] transposeCol, IColumnMap cmap, String template, int dataFileType) throws Exception {
        ServerMessage.setApplet(applet);
        ColData[] colData = null;
        QueryClassFileInfo classInfo = null;
        QueryXMLFileInfo queryXMLFileInfo = null;
        boolean disableParamDialog = !QbChart.isChartServerUsed();
        Vector<QueryInParamSet> paramV = null;
        if (dataFileType == 6 && ClassFileUtil.isParameterized(dataFile)) {
            classInfo = new QueryClassFileInfo(dataFile);
            if (!disableParamDialog) {
                paramV = QueryFileInfo.getParameter(classInfo, false, false, true);
                colData = new DataFileInput().readProcessedData(dataFile, doTransposeData, transposeCol, null, null, paramV.elementAt(0));
            } else {
                colData = new DataFileInput().readProcessedData(dataFile, doTransposeData, transposeCol, null, null, null, dataFileType);
            }
        } else if (dataFileType == 7 && xmlFileQueryInfo.getInParam() != null) {
            queryXMLFileInfo = new QueryXMLFileInfo(xmlFileQueryInfo);
            queryXMLFileInfo.setInSet(xmlFileQueryInfo.getInSet());
            if (!disableParamDialog) {
                try {
                    QueryFileInfo.getParameter(queryXMLFileInfo, false, false, true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                colData = new DataFileInput().readProcessedData(dataFile, doTransposeData, transposeCol, null, null, xmlFileQueryInfo, dataFileType);
            } else {
                colData = new DataFileInput().readProcessedData(dataFile, doTransposeData, transposeCol, null, null, xmlFileQueryInfo, dataFileType);
            }
        } else {
            colData = new DataFileInput().readProcessedData(dataFile, doTransposeData, transposeCol, null, null, xmlFileQueryInfo, dataFileType);
        }
        this.createChart(dimension, chartType, colData, cmap, template);
        if (this.errorMessage != null && this.errorMessage.equalsIgnoreCase(SURFACEDATAERROR)) {
            throw new IllegalArgumentException("The data cannot plot a 3D surface chart");
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Invalid argument(s).  Cannot create the chart");
        }
        this.chart.sourceData = dataFileType;
        this.chart.xmlFileQueryInfo = xmlFileQueryInfo;
        this.chart.sourceFile = dataFile;
        this.chart.setTransposed(doTransposeData, transposeCol);
        if (classInfo != null) {
            this.chart.dbInfo = classInfo;
        } else if (queryXMLFileInfo != null) {
            this.chart.dbInfo = queryXMLFileInfo;
        }
    }

    private void createFromDataFile(Applet applet, int dimension, int chartType, String dataFile, XMLFileQueryInfo xmlFileQueryInfo, QueryInParamSet queryInParamSet, boolean doTransposeData, boolean[] transposeCol, IColumnMap cmap, String template, int dataFileType) throws Exception {
        ColData[] colData;
        ServerMessage.setApplet(applet);
        QueryClassFileInfo classInfo = null;
        if (dataFileType == 6 && ClassFileUtil.isParameterized(dataFile)) {
            classInfo = new QueryClassFileInfo(dataFile);
            if (queryInParamSet == null) {
                Vector<QueryInParamSet> paramV = null;
                paramV = QueryFileInfo.getParameter(classInfo, false, false, true);
                queryInParamSet = paramV.elementAt(0);
            }
            colData = new DataFileInput().readProcessedData(dataFile, doTransposeData, transposeCol, null, null, queryInParamSet);
        } else {
            colData = new DataFileInput().readProcessedData(dataFile, doTransposeData, transposeCol, null, null, xmlFileQueryInfo, dataFileType);
        }
        this.createChart(dimension, chartType, colData, cmap, template);
        if (this.chart == null) {
            throw new IllegalArgumentException("Invalid argument(s).  Cannot create the chart");
        }
        this.chart.sourceData = dataFileType;
        this.chart.xmlFileQueryInfo = xmlFileQueryInfo;
        this.chart.sourceFile = dataFile;
        this.chart.setTransposed(doTransposeData, transposeCol);
        if (xmlFileQueryInfo != null && xmlFileQueryInfo.getInSet() != null) {
            this.chart.dbInfo = new QueryXMLFileInfo(xmlFileQueryInfo);
        }
    }

    @Deprecated
    public QbChart(Frame frame, int dimension, int chartType, String dataFile, IColumnMap cmap, String template) {
        this((Applet)null, dimension, chartType, dataFile, cmap, template);
    }

    @Deprecated
    public QbChart(Applet applet, int dimension, int chartType, IResultSet data, IColumnMap cmap) {
        this(applet, dimension, chartType, data, cmap, null);
    }

    @Deprecated
    public QbChart(Frame frame, int dimension, int chartType, IResultSet data, IColumnMap cmap) {
        this((Applet)null, dimension, chartType, data, cmap, null);
    }

    public QbChart(Applet applet, int dimension, int chartType, IResultSet data, IColumnMap cmap, String template) {
        this(applet, dimension, chartType, data, false, cmap, template);
    }

    public QbChart(Applet applet, int dimension, int chartType, IResultSet data, boolean doTransposeData, IColumnMap cmap, String template) {
        this(applet, dimension, chartType, data, doTransposeData, null, cmap, template);
    }

    public QbChart(Applet applet, int dimension, int chartType, IResultSet data, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template) {
        ColData[] colData;
        ServerMessage.setApplet(applet);
        try {
            if (doTransposeData) {
                data = TransposeRS.doTranspose(data, TransposeRS.getTransposeColumn(transposeCol));
            }
            colData = data instanceof DbData ? ((DbData)data).getColData() : ColData.getColData(data);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        this.createChart(dimension, chartType, colData, cmap, template);
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
        this.chart.sourceData = 0;
    }

    @Deprecated
    public QbChart(Frame frame, int dimension, int chartType, IResultSet data, IColumnMap cmap, String template) {
        this((Applet)null, dimension, chartType, data, cmap, template);
    }

    public QbChart(Applet applet, int dimension, int chartType, ISpreadSheetModel sheet, IColumnMap cmap, String template) {
        ServerMessage.setApplet(applet);
        this.spreadSheet = sheet;
        ColData[] colData = ColData.getColData(sheet);
        this.createChart(dimension, chartType, colData, cmap, template);
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
        this.chart.sourceData = 0;
        this.spreadSheetListener = new QbChartBasic.CSpreadSheetListener(this);
        sheet.addSpreadSheetModelListener(this.spreadSheetListener);
    }

    public QbChart(Applet applet, int dimension, int chartType, DataSheet[] dataSheet, boolean doTransposeData, IColumnMap cmap, String template) {
        this(applet, dimension, chartType, dataSheet, doTransposeData, null, cmap, template);
    }

    public QbChart(Applet applet, int dimension, int chartType, DataSheet[] dataSheet, boolean doTransposeData, int[] transposeCol, IColumnMap cmap, String template) {
        block9: {
            try {
                IResultSet rs;
                ServerMessage.setApplet(applet);
                if (dataSheet == null || dataSheet.length <= 0) {
                    throw new IllegalArgumentException("DataSheet is null");
                }
                Vector<ColData[]> colList = new Vector<ColData[]>();
                Object[] source = new Object[dataSheet.length];
                int[] sourceType = new int[dataSheet.length];
                boolean[] doTranspose = new boolean[dataSheet.length];
                Object[] transposeColList = new Object[dataSheet.length];
                for (int i = 0; i < dataSheet.length; ++i) {
                    colList.addElement(dataSheet[i].getColData());
                    if (source == null || sourceType == null || doTranspose == null || transposeColList == null) continue;
                    if (dataSheet[i].getSource() == null) {
                        source = null;
                        sourceType = null;
                        doTranspose = null;
                        transposeColList = null;
                        continue;
                    }
                    source[i] = dataSheet[i].getSource();
                    sourceType[i] = dataSheet[i].getSourceType();
                    doTranspose[i] = dataSheet[i].isTranspose();
                    transposeColList[i] = dataSheet[i].transposeCol;
                }
                ColData[] colData = ColData.merge(colList, true);
                boolean[] transposeColSet = TransposeRS.getTransposeColumn(transposeCol);
                if (doTransposeData && (rs = TransposeRS.doTranspose(colData, transposeColSet)) != null) {
                    colData = ColData.getColData(rs);
                }
                this.createChart(dimension, chartType, colData, cmap, template);
                if (this.chart != null) {
                    if (source != null) {
                        this.chart.sourceData = 3;
                        this.chart.sourceList = source;
                        this.chart.sourceType = sourceType;
                        this.chart.transposeColList = transposeColList;
                        this.chart.doTranspose = doTranspose;
                        this.chart.setTransposed(doTransposeData, transposeColSet);
                    } else {
                        this.chart.sourceData = 0;
                    }
                    break block9;
                }
                throw new IllegalArgumentException("Cannot Create Chart");
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.toString());
            }
        }
    }

    public QbChart(QbChart qbchart) {
        if (qbchart == null) {
            throw new IllegalArgumentException("Null chart object");
        }
        try {
            this.chart = Chart.createChart(this, qbchart.chart.chartType, qbchart.chart.is2DimChart(), qbchart.chart, null);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        finally {
            if (!forExportOnly && this.errorMessage == null) {
                this.initPanel();
                this.vpanel3d.filename = qbchart.vpanel3d.filename;
            }
            this.ctemplate = qbchart.ctemplate;
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
    }

    public QbChart(Applet applet, byte[] chartData) {
        this(applet, chartData, false);
    }

    public QbChart(Applet applet, byte[] chartData, boolean template) {
        this(applet, chartData, template, null);
    }

    public QbChart(Applet applet, byte[] chartData, boolean template, Properties props) {
        ServerMessage.setApplet(applet);
        if (chartData == null) {
            throw new IllegalArgumentException("Null chart object");
        }
        try {
            boolean isEnterpriseServer = QbChart.isForExportOnly();
            boolean useBackupData = false;
            FileInMemTable subFilesTable = null;
            if (props != null) {
                String str1 = (String)props.get("prompt parameter");
                if (str1 != null && str1.equalsIgnoreCase("false")) {
                    isEnterpriseServer = true;
                }
                if ((str1 = (String)props.get("use backup data")) != null && str1.equalsIgnoreCase("true")) {
                    useBackupData = true;
                }
                subFilesTable = (FileInMemTable)props.get("SubFilesTable");
            }
            LoadChart lc = new LoadChart();
            if (subFilesTable != null) {
                lc.setSubFilesTable(subFilesTable);
            }
            lc.setUsingBackupData(useBackupData);
            this.chart = lc.load(this, new DataInputStream(new ByteArrayInputStream(chartData)), template, null, isEnterpriseServer);
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        finally {
            if (!forExportOnly && this.errorMessage == null) {
                this.initPanel();
            }
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
    }

    protected QbChart(boolean forReport) {
    }

    public QbChart(Frame frame, String fileName, Object req) {
        this((Applet)null, fileName, req);
    }

    public QbChart(Applet applet, String fileName, Object req) {
        if (req instanceof Object[]) {
            this.initQbChartWithParamObjs(applet, fileName, (Object[])req, false, false);
            return;
        }
        Object[] paramValueArr = this.getParamInput(req);
        ServerMessage.setApplet(applet);
        try {
            if (this.needUpdate == null && this.selectAllInfo != null) {
                int len = this.selectAllInfo.length;
                this.needUpdate = new boolean[len];
                for (int cnt = 0; cnt < len; ++cnt) {
                    this.needUpdate[cnt] = true;
                }
            }
            this.chart = this.loadChartFromFile(fileName, true);
            IInputData inputData = this.gethInputData();
            if (inputData.getDatabaseInfo() != null && inputData.getDatabaseInfo() instanceof IQueryFileInfo) {
                IQueryFileInfo queryInfo = (IQueryFileInfo)inputData.getDatabaseInfo();
                IQueryInParam[] queryParamSet = QbUtil.getInParam(queryInfo);
                int queryCt = 0;
                if (queryParamSet != null) {
                    queryCt = queryParamSet.length;
                    for (int i = 0; i < queryCt; ++i) {
                        try {
                            QbUtil.CQueryInParam cqip;
                            String dateFormat = null;
                            if (queryParamSet[i] instanceof ICustomParameterDateFormat && !queryParamSet[i].isMapToColumn()) {
                                dateFormat = ((ICustomParameterDateFormat)((Object)queryParamSet[i])).getDateFormat();
                            }
                            if (queryParamSet[i] instanceof IQueryMultiValueInParam) {
                                ((IQueryMultiValueInParam)queryParamSet[i]).setValues(QbUtil.getMultiValueObject(queryParamSet[i].getSqlType(), (String[])paramValueArr[i], dateFormat));
                                if (this.selectAllInfo == null || !this.needUpdate[i]) continue;
                                if (this.selectAllInfo[i]) {
                                    ((IQueryMultiValueInParam)queryParamSet[i]).setValue("SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                                    continue;
                                }
                                ((IQueryMultiValueInParam)queryParamSet[i]).setValue("NOT_-_SELECT_-_ALL_-_MULTIPLE_-_VALUES");
                                continue;
                            }
                            String[] temp = (String[])paramValueArr[i];
                            if (temp.length == 3) {
                                if (temp[2] == null || temp[2].equals("")) {
                                    temp[2] = "2003";
                                }
                                String date = temp[0] + "/" + temp[1] + "/" + temp[2];
                                queryParamSet[i].setValue(QbUtil.getValueObject(queryParamSet[i].getSqlType(), date, "MM/dd/yyyy"));
                                continue;
                            }
                            boolean isAll = false;
                            if (queryParamSet[i] instanceof QbUtil.CQueryInParam && (cqip = (QbUtil.CQueryInParam)queryParamSet[i]).isAllOptionEnabled() && cqip.getAllOptionLabel() != null && cqip.getAllOptionLabel().equals(temp[0])) {
                                isAll = true;
                                queryParamSet[i].setValue(cqip.getAllOptionLabel());
                            }
                            if (isAll) continue;
                            queryParamSet[i].setValue(QbUtil.getValueObject(queryParamSet[i].getSqlType(), temp[0], dateFormat));
                            continue;
                        }
                        catch (Exception ex) {
                            throw new Exception("Invalid input in " + paramValueArr[i]);
                        }
                    }
                    this.refresh();
                }
            }
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            throw new IllegalArgumentException(this.errorMessage);
        }
        if (this.chart == null) {
            throw new IllegalArgumentException("Cannot Create Chart");
        }
    }

    private Object[] getParamInput(Object reqObj) {
        int paramSetSize = 0;
        Class<?> reqClass = null;
        Method getParamValsMethod = null;
        Object returnObj = null;
        Object[] paramValueArr = null;
        try {
            reqClass = reqObj.getClass();
            getParamValsMethod = reqClass.getMethod("getParameterValues", String.class);
            returnObj = getParamValsMethod.invoke(reqObj, "paramSetSize");
            if (returnObj != null) {
                paramSetSize = Integer.valueOf(((String[])returnObj)[0]);
            }
            paramValueArr = new Object[paramSetSize];
            this.selectAllInfo = new boolean[paramSetSize];
            for (int i = 0; i < paramSetSize; ++i) {
                getParamValsMethod = reqClass.getMethod("getParameterValues", String.class);
                paramValueArr[i] = returnObj = getParamValsMethod.invoke(reqObj, "paramValue_" + i);
                returnObj = getParamValsMethod.invoke(reqObj, "paramValue_" + i + "_SelectAll");
                if (returnObj == null) continue;
                this.selectAllInfo[i] = ((String[])returnObj)[0].equals("true");
            }
        }
        catch (NoSuchMethodException ne) {
            ne.printStackTrace();
        }
        catch (IllegalAccessException ae) {
            ae.printStackTrace();
        }
        catch (InvocationTargetException ie) {
            ie.printStackTrace();
        }
        return paramValueArr;
    }

    public final boolean isBackgroundTransparent() {
        return this.chart.isBackgroundTransparent();
    }

    public final void setBackgroundTransparent(boolean b) {
        this.chart.setBackgroundTransparent(b);
    }

    public final boolean isDrawBorderForWMF() {
        return this.chart.isDrawBorderForWMF();
    }

    public final void setDrawBorderForWMF(boolean b) {
        this.chart.setDrawBorderForWMF(b);
    }

    public final void setChartGraphics(IChartGraphics chartGraphics) {
        this.chart.setChartGraphics(chartGraphics);
    }

    public final void setAddOnChart(QbChart[] qbCharts) {
        if (qbCharts == null) {
            this.chart.setAddOnChart(null);
            return;
        }
        Chart[] charts = new Chart[qbCharts.length];
        for (int i = 0; i < qbCharts.length; ++i) {
            charts[i] = qbCharts[i].chart;
        }
        this.chart.setAddOnChart(new AddOnChart(this.chart, charts));
    }

    public final void setStringCustomizer(IStringCustomizer stringCustomizer) {
        this.chart.setStringCustomizer(stringCustomizer);
    }

    public void setRenderingHint(Object hintKey, Object hintValue) {
        this.chart.setRenderingHint(hintKey, hintValue);
    }

    public void applyAntiAliasToChartAreaOnly(boolean b) {
        this.chart.setAntiAliasForChartOnly = b;
    }

    public void forceApplyAntiAliasToHorizontalText(boolean b) {
        this.chart.setAntiAliasForText(b);
    }

    public void setGradientEnabled(boolean b) {
        this.chart.getPrimaryDataGradientSupport().setGradientEnabled(b);
    }

    public boolean isGradientEnabled() {
        return this.chart.getPrimaryDataGradientSupport().isGradientEnabled();
    }

    public void set3DShadingEnabled(boolean b) {
        this.chart.getPrimaryDataGradientSupport().set3DShadingEnabled(b);
    }

    public boolean is3DShadingEnabled() {
        return this.chart.getPrimaryDataGradientSupport().is3DShadingEnabled();
    }

    public void setApplyGradientToChartDataOnly(boolean b) {
        this.chart.getPrimaryDataGradientSupport().setApplyGradientToChartDataOnly(b);
    }

    public boolean isApplyGradientToChartDataOnly() {
        return this.chart.getPrimaryDataGradientSupport().isApplyGradientToChartDataOnly();
    }

    public double getGradientStartX() {
        return this.chart.getPrimaryDataGradientSupport().getGradientStartX();
    }

    public double getGradientStartY() {
        return this.chart.getPrimaryDataGradientSupport().getGradientStartY();
    }

    public double getGradientEndX() {
        return this.chart.getPrimaryDataGradientSupport().getGradientEndX();
    }

    public double getGradientEndY() {
        return this.chart.getPrimaryDataGradientSupport().getGradientEndY();
    }

    public Color getGradientDesColor() {
        return this.chart.getPrimaryDataGradientSupport().getGradientDesColor();
    }

    public int getGradientShade() {
        return this.chart.getPrimaryDataGradientSupport().getGradientShade();
    }

    public boolean isGradientCyclic() {
        return this.chart.getPrimaryDataGradientSupport().isGradientCyclic();
    }

    public void setGradientStartX(double x) {
        this.chart.getPrimaryDataGradientSupport().setGradientStartX(x);
    }

    public void setGradientStartY(double y) {
        this.chart.getPrimaryDataGradientSupport().setGradientStartY(y);
    }

    public void setGradientEndX(double x) {
        this.chart.getPrimaryDataGradientSupport().setGradientEndX(x);
    }

    public void setGradientEndY(double y) {
        this.chart.getPrimaryDataGradientSupport().setGradientEndY(y);
    }

    public void setGradientDesColor(Color c) {
        this.chart.getPrimaryDataGradientSupport().setGradientDesColor(c);
    }

    public void setGradientShade(int s) {
        this.chart.getPrimaryDataGradientSupport().setGradientShade(s);
    }

    public void setGradientCyclic(boolean c) {
        this.chart.getPrimaryDataGradientSupport().setGradientCyclic(c);
    }

    public final void setImageMapDataHintBoxHandle(ICustomizeImageMapDataHintBox val) {
        this.chart.setCustomizeImageMapDataHintBox(val);
    }

    public ICustomizeImageMapDataHintBox getImageMapDataHintBoxHandle() {
        return this.chart.getCustomizeImageMapDataHintBox();
    }

    public final IChartGraphics getChartGraphics() {
        return this.chart.getChartGraphics();
    }

    public final Image export() {
        return this.chart.exportImageObject(this.chart.winWidth, this.chart.winHeight);
    }

    public byte[] exportChartToByteArray() throws Exception {
        return this.exportChartToByteArray(false);
    }

    public byte[] exportChartToByteArray(boolean template) throws Exception {
        SaveChart saveChart = new SaveChart(this.chart);
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        saveChart.saveToDataOutput(out, template);
        out.close();
        fstream.close();
        return fstream.toByteArray();
    }

    public String exportChartToString() throws Exception {
        byte[] byte_array = this.exportChartToByteArray();
        StringBuffer temp = new StringBuffer(byte_array.length);
        for (byte element : byte_array) {
            temp = temp.append(element + " ");
        }
        return temp.toString();
    }

    public void export(int format, String filename) throws IOException {
        this.export(format, filename, filename, 0, 0, false);
    }

    public void export(int format, String filename, int w, int h) throws IOException {
        this.export(format, filename, filename, w, h, false);
    }

    public void export(int format, String filename, String subFilename) throws IOException {
        if ((format == 0 || format == 5) && subFilename != null) {
            this.export(format, filename, subFilename, 0, 0, true);
        } else {
            this.export(format, filename, subFilename, 0, 0, false);
        }
    }

    private Dimension getExportSize(int w, int h) {
        if (w <= 0) {
            w = this.chart.getSize().width;
        }
        if (h <= 0) {
            h = this.chart.getSize().height;
        }
        if (w <= 0) {
            w = 400;
        }
        if (h <= 0) {
            h = 500;
        }
        return new Dimension(w, h);
    }

    public void export(int format, String filename, String subFilename, int w, int h) throws IOException {
        if ((format == 0 || format == 5) && subFilename != null) {
            this.export(format, filename, subFilename, w, h, true);
        }
        this.export(format, filename, subFilename, w, h, false);
    }

    public void export(int format, String filename, String subFilename, int w, int h, boolean generateSubFile) throws IOException {
        this.export(format, filename, subFilename, w, h, generateSubFile, 99);
    }

    public void export(int format, String filename, int w, int h, int option) throws IOException {
        this.export(format, filename, filename, w, h, false, option);
    }

    public void export(int format, String filename, String subFilename, int w, int h, boolean generateSubFile, int option) throws IOException {
        this.export(format, filename, subFilename, w, h, generateSubFile, option, (int)this.chart.flashFrameRate, true);
    }

    public void export(int format, String filename, String subFilename, int w, int h, boolean generateSubFile, int option, int option2, boolean enableAnimationForFlash) throws IOException {
        if (filename == null) {
            throw new IOException("No filename specified");
        }
        Dimension size = this.getExportSize(w, h);
        if (!enableAnimationForFlash) {
            option = 1;
        }
        if (format == 15) {
            if (option > 0 && option <= 50) {
                this.chart.flashFrameCount = option;
            }
            if (option2 > 0 && option2 <= 99) {
                this.chart.flashFrameRate = option2;
            }
        }
        try {
            this.chart.get_directExport(filename, subFilename, format, size.width, size.height, this, generateSubFile, option);
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    public void export(int format, String filename, String drillDownChartName, String servletLoc) throws Exception {
        this.export(format, filename, drillDownChartName, 0, 0, servletLoc, null, null, 99);
    }

    public void export(int format, String filename, String drillDownChartName, int w, int h, String servletLoc) throws Exception {
        this.export(format, filename, drillDownChartName, w, h, servletLoc, null, null, 99);
    }

    public void export(int format, String filename, String drillDownChartName, int w, int h, String servletLoc, String[] argv) throws Exception {
        this.export(format, filename, drillDownChartName, w, h, servletLoc, null, argv, 99);
    }

    public void export(int format, String filename, String drillDownChartName, String servletLoc, PickData[] pickData) throws Exception {
        this.export(format, filename, drillDownChartName, 0, 0, servletLoc, pickData, null, 99);
    }

    public void export(int format, String filename, String drillDownChartName, int w, int h, String servletLoc, PickData[] pickData) throws Exception {
        this.export(format, filename, drillDownChartName, w, h, servletLoc, pickData, null, 99);
    }

    public void export(int format, String filename, String drillDownChartName, int w, int h, String servletLoc, PickData[] pickData, String[] argv) throws Exception {
        this.export(format, filename, drillDownChartName, w, h, servletLoc, pickData, null, 99);
    }

    public void export(int format, String filename, String chartLocation, int w, int h, String servletLoc, PickData[] pickData, String[] argv, int option) throws Exception {
        this.export(format, filename, chartLocation, w, h, servletLoc, pickData, argv, option, this.chart.flashFrameRate, true);
    }

    public void export(int format, String filename, String chartLocation, int w, int h, String servletLoc, PickData[] pickData, String[] argv, int option, float option2, boolean enableAnimationForFlash) throws Exception {
        if (filename == null) {
            throw new IOException("No filename specified");
        }
        if (!enableAnimationForFlash) {
            option = 1;
        }
        Dimension size = this.getExportSize(w, h);
        if (format == 15) {
            if (option > 0 && option <= 50) {
                this.chart.flashFrameCount = option;
            }
            if (option2 > 0.0f && option2 <= 99.0f) {
                this.chart.flashFrameRate = option2;
            }
        }
        if (this.chart.isFieldDrillDownEnabled()) {
            this.chart.get_directExport(filename, chartLocation, format, size.width, size.height, this, servletLoc, null, argv, option);
            return;
        }
        if (this.chart.drillDownVector == null || this.chart.drillDownVector.size() <= 0) {
            this.chart.get_directExport(filename, filename, format, size.width, size.height, this, true, option);
            return;
        }
        if (pickData == null || pickData.length == 0) {
            this.chart.get_directExport(filename, chartLocation, format, size.width, size.height, this, servletLoc, null, argv, option);
            return;
        }
        Chart sChart = this.getDrillDownLevelChart(this.chart, pickData);
        sChart.setBackgroundTransparent(this.chart.isBackgroundTransparent());
        if (this.chart.drillDownVector.size() > pickData.length) {
            sChart.get_directExport(filename, chartLocation, format, size.width, size.height, this, servletLoc, pickData, argv, option);
        } else {
            sChart.get_directExport(filename, filename, format, size.width, size.height, this, true, option);
        }
    }

    public void export(int format, OutputStream image, OutputStream subFile, String filename, String chartLocation, int w, int h, String servletLoc, PickData[] pickData, String[] argv, int option) throws Exception {
        this.export(format, image, subFile, filename, chartLocation, w, h, servletLoc, pickData, argv, option, this.chart.flashFrameRate, true);
    }

    public void export(int format, OutputStream image, OutputStream subFile, String filename, String chartLocation, int w, int h, String servletLoc, PickData[] pickData, String[] argv, int option, float option2, boolean enableAnimationForFlash) throws Exception {
        Dimension size = this.getExportSize(w, h);
        if (!enableAnimationForFlash) {
            option = 1;
        }
        if (format == 15) {
            if (option > 0 && option <= 50) {
                this.chart.flashFrameCount = option;
            }
            if (option2 > 0.0f && option2 <= 99.0f) {
                this.chart.flashFrameRate = option2;
            }
        }
        if (this.chart.isFieldDrillDownEnabled()) {
            this.chart.get_directExport(image, subFile, filename, chartLocation, format, size.width, size.height, this, servletLoc, null, argv, option);
            return;
        }
        if (this.chart.drillDownVector == null || this.chart.drillDownVector.size() <= 0) {
            this.chart.get_directExport(image, subFile, filename, format, size.width, size.height, this, true, option);
            return;
        }
        if (pickData == null || pickData.length == 0) {
            this.chart.get_directExport(image, subFile, filename, chartLocation, format, size.width, size.height, this, servletLoc, null, argv, option);
            return;
        }
        Chart sChart = this.getDrillDownLevelChart(this.chart, pickData);
        sChart.setBackgroundTransparent(this.chart.isBackgroundTransparent());
        if (this.chart.drillDownVector.size() > pickData.length) {
            sChart.get_directExport(image, subFile, filename, chartLocation, format, size.width, size.height, this, servletLoc, pickData, argv, option);
        } else {
            sChart.get_directExport(image, subFile, filename, format, size.width, size.height, this, true, option);
        }
    }

    public void setDrillDownPath(String path) {
        this.chart.setDrillDownPath(path);
    }

    public boolean isFieldDrillDownEnabled() {
        return this.chart.isFieldDrillDownEnabled();
    }

    public boolean isFieldDrillDownChart() {
        return this.chart.isFieldDrillDownChart();
    }

    private Chart getDrillDownLevelChart(Chart chart, PickData[] pickData) throws Exception {
        Chart sChart = chart;
        int level = pickData.length - 1;
        chart.resetDrillNumber();
        Vector<ColMetaData> originalMetaData = ReloadChart.getMetaDataInfo(chart);
        DrillHistory drillHistory = new DrillHistory(chart, originalMetaData);
        sChart.valueTable.setDrillHistory(drillHistory);
        while (chart.getDrillNumber() < level) {
            chart.incrementDrillNumber();
        }
        int[] map = chart.getDrillDownMap();
        int dim = chart.getDrillDownDimension();
        int cType = chart.getDrillDownType();
        boolean dType = chart.isDrillDown2D();
        int valCol = chart.getValueMap();
        int subvalCol = chart.getSubValueMap();
        if (chart.summaryChart) {
            valCol = chart.originalMap[valCol];
            if (subvalCol >= 0) {
                subvalCol = chart.originalMap[subvalCol];
            }
        }
        PreprocInfo tsInfo = drillHistory.createPreprocInfo(map, dim, valCol, subvalCol, cType, dType, chart.primaryAggregate, chart.secondaryAggregate);
        ValueTable valueTableSave = sChart.valueTable;
        ColData[] colData = null;
        for (PickData element : pickData) {
            colData = drillHistory.nextDrill(element, tsInfo);
        }
        Chart tempChart = Chart.createChart(this, cType, dType, null, colData, null);
        tempChart.setSubFilesTable(chart.getSubFilesTable());
        if (tempChart.notEnoughData()) {
            chart.usedColumns = null;
            chart.valueTable.setDrillHistory(null);
            chart.resetDrillNumber();
            throw new Exception("DrillDown:  Not enough data available to plot");
        }
        sChart = tempChart;
        drillHistory.setChartType(sChart, tsInfo);
        chart.incrementDrillNumber();
        if (valueTableSave != null) {
            sChart.valueTable = new ValueTable(sChart, valueTableSave);
        }
        String tplName = null;
        int num = chart.getDrillNumber() - 1;
        if (num < 0) {
            num = 0;
        }
        if (chart.drillTemplateName != null && !chart.drillTemplateName.trim().equals("")) {
            int index = chart.drillTemplateName.indexOf(58);
            tplName = index < 0 ? chart.drillTemplatePath + chart.drillTemplateName + num + ".tpl" : chart.drillTemplateName + num + ".tpl";
        }
        if (tplName != null) {
            ReadDataFile readfile = new ReadDataFile();
            DataInputStream din = null;
            try {
                din = readfile.getInputStream(chart, tplName);
                sChart = new LoadChart().loadTemplate(sChart, din);
            }
            catch (Exception ex) {
                try {
                    readfile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (sChart.showTable()) {
            GraphicsTable.recoverTableSize(sChart);
        }
        chart.usedColumns = null;
        chart.valueTable.setDrillHistory(null);
        chart.resetDrillNumber();
        return sChart;
    }

    public static int getPickDataCount(String param) {
        String sep = "$_$";
        String tmp = param.substring(0, param.indexOf(sep));
        return Integer.valueOf(tmp);
    }

    public static PickData[] toPickData(String param) {
        String sep = "$_$";
        int slen = sep.length();
        String tmp = param.substring(0, param.indexOf(sep));
        param = param.substring(param.indexOf(sep) + slen);
        int level = Integer.valueOf(tmp);
        if (level < 1) {
            return null;
        }
        PickData[] pickData = new PickData[level];
        for (int i = 0; i < level; ++i) {
            pickData[i] = new PickData();
            pickData[i].categoryName = param.substring(0, param.indexOf(sep));
            if (pickData[i].categoryName.equals("null")) {
                pickData[i].categoryName = null;
            }
            param = param.substring(param.indexOf(sep) + slen);
            pickData[i].category = param.substring(0, param.indexOf(sep));
            if (pickData[i].category.equals("null")) {
                pickData[i].category = null;
            }
            param = param.substring(param.indexOf(sep) + slen);
            pickData[i].seriesName = param.substring(0, param.indexOf(sep));
            if (pickData[i].seriesName.equals("null")) {
                pickData[i].seriesName = null;
            }
            param = param.substring(param.indexOf(sep) + slen);
            pickData[i].series = param.substring(0, param.indexOf(sep));
            if (pickData[i].series.equals("null")) {
                pickData[i].series = null;
            }
            param = param.substring(param.indexOf(sep) + slen);
            pickData[i].sumByName = param.substring(0, param.indexOf(sep));
            if (pickData[i].sumByName.equals("null")) {
                pickData[i].sumByName = null;
            }
            param = param.substring(param.indexOf(sep) + slen);
            pickData[i].sumBy = param.substring(0, param.indexOf(sep));
            if (pickData[i].sumBy.equals("null")) {
                pickData[i].sumBy = null;
            }
            param = param.substring(param.indexOf(sep) + slen);
        }
        return pickData;
    }

    public void export(int format, OutputStream out) throws IOException {
        this.export(format, out, 0, 0);
    }

    public void export(int format, OutputStream out, int w, int h) throws IOException {
        this.export(format, out, w, h, 99);
    }

    public void export(int format, OutputStream out, int w, int h, int option) throws IOException {
        this.export(format, out, null, null, w, h, false, option);
    }

    public void export(int format, OutputStream image, OutputStream subFile, String fileName, int w, int h, boolean generateSubFile, int option) throws IOException {
        this.export(format, image, subFile, fileName, w, h, generateSubFile, option, (int)this.chart.flashFrameRate, true);
    }

    public void export(int format, OutputStream image, OutputStream subFile, String fileName, int w, int h, boolean generateSubFile, int option, int option2, boolean enableAnimationForFlash) throws IOException {
        try {
            if (this.gethDataPoints().gethLabel().isVisible()) {
                BufferedImage bImage = new BufferedImage(this.gethCanvas().getSize().width, this.gethCanvas().getSize().height, 1);
                this.draw(bImage.getGraphics(), null, this.gethCanvas().getSize().width, this.gethCanvas().getSize().height);
            }
        }
        catch (Exception bImage) {
            // empty catch block
        }
        Dimension size = this.getExportSize(w, h);
        if (!enableAnimationForFlash) {
            option = 1;
        }
        if (format == 15) {
            if (option > 0 && option <= 50) {
                this.chart.flashFrameCount = option;
            }
            if (option2 > 0 && option2 <= 99) {
                this.chart.flashFrameRate = option2;
            }
        }
        try {
            this.chart.get_directExport(image, subFile, fileName, format, size.width, size.height, this, generateSubFile, option);
        }
        catch (Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    public void exportDataFile(String fileName, int separator, int format) throws Exception {
        if (fileName == null) {
            throw new IOException("No filename specified");
        }
        this.chart.exportDataFile(fileName, separator, format);
    }

    public void exportDataFile(PrintStream out, int separator, int format) throws Exception {
        this.chart.exportDataFile(out, separator, format);
    }

    @Override
    public final synchronized void refresh() throws IOException, SQLException, ClassNotFoundException {
        if (this.chart.sourceData == 0 && this.spreadSheet != null) {
            this.chart.setNewData(ColData.getColData(this.spreadSheet));
            return;
        }
        this.chart.usedColumns = null;
        this.chart = ReloadChart.reloadData(this.chart, false);
        if (this.chart.drillDownVector != null && this.vpanel3d != null && this.chart.drillDownVector.size() > 0 || this.chart.isDynamicDrillDown && this.vpanel3d != null) {
            this.vpanel3d.parentChart = this.chart;
            this.vpanel3d.parentChart.summaryChart = true;
        }
        this.setrepaint(true);
    }

    @Override
    public Chart setNewData(ColData[] colData) throws Exception {
        return this.chart;
    }

    public void repaintPanel() {
        if (this.vpanel != null) {
            this.vpanel.repaint();
        }
    }

    public void draw(Graphics g, Component component, int width, int height) {
        this.chart.draw(g, component, width, height);
    }

    public final void setApplet(Applet applet) {
        ServerMessage.setApplet(applet);
    }

    public final Applet getApplet() {
        return ServerMessage.getApplet();
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    protected void finalize() throws Throwable {
        ServerMessage.setComponent(null);
    }

    public int getDrillDownChartCount() {
        if (this.chart != null && this.chart.currentNode != null) {
            return this.chart.currentNode.getChildCount();
        }
        return 0;
    }

    public DrillDownChart getDrillDownChartAt(int index) throws Exception {
        if (this.chart != null && this.chart.currentNode != null) {
            DrillDownNode node = this.chart.currentNode.getChildAt(index);
            if (node.getDrillDownChart() != null) {
                return (DrillDownChart)node.getDrillDownChart();
            }
            LoadChart lc = new LoadChart();
            lc.setSubFilesTable(this.chart.getSubFilesTable());
            Chart ddr = lc.loadChartFromFile(this, node.getFileName(), null);
            ddr.currentNode = node;
            DrillDownChart ret = new DrillDownChart(ddr);
            node.setDrillDownChart(ret);
            return ret;
        }
        return null;
    }

    public DrillDownChart getDrillDownChart(String name) throws Exception {
        if (this.chart != null && this.chart.currentNode != null) {
            for (int i = 0; i < this.chart.currentNode.getChildCount(); ++i) {
                DrillDownNode node = this.chart.currentNode.getChildAt(i);
                if (!node.getName().equals(name)) continue;
                if (node.getDrillDownChart() != null) {
                    return (DrillDownChart)node.getDrillDownChart();
                }
                LoadChart lc = new LoadChart();
                lc.setSubFilesTable(this.chart.getSubFilesTable());
                Chart ddr = lc.loadChartFromFile(this, node.getFileName(), null);
                ddr.currentNode = node;
                DrillDownChart ret = new DrillDownChart(ddr);
                node.setDrillDownChart(ret);
                return ret;
            }
        }
        return null;
    }

    public DrillDownChart createDrillDownChart(String name, int chartDim, int chartType, quadbase.util.IDatabaseInfo dbInfo, boolean doTransposeData, int[] transposeCol, IColumnMap mapping, String template, int[] columnMapping) throws Exception {
        return this.createDrillDownChart(name, chartDim, chartType, dbInfo, doTransposeData, transposeCol, mapping, template, columnMapping, true);
    }

    public DrillDownChart createDrillDownChart(String name, int chartDim, int chartType, quadbase.util.IDatabaseInfo dbInfo, boolean doTransposeData, int[] transposeCol, IColumnMap mapping, String template, int[] columnMapping, boolean prevParamPrompt) throws Exception {
        if (!(dbInfo instanceof IQueryFileInfo)) {
            throw new IllegalArgumentException("Drill-down charts must use a parameterized query.");
        }
        if (columnMapping.length != ((IQueryFileInfo)dbInfo).getInParam().length) {
            throw new IllegalArgumentException("The number of column mapping indices does not match the number of parameters in the query.");
        }
        for (int i = 0; i < this.chart.currentNode.getChildCount(); ++i) {
            if (!this.chart.currentNode.getChildAt(i).getName().equals(name)) continue;
            throw new IllegalArgumentException("A drill-down chart already exists with the given name.");
        }
        DrillDownNode node = this.chart.currentNode.createNewChild(name);
        node.setColumnMapping(columnMapping);
        node.setSaved(false);
        try {
            DrillDownChart ret = new DrillDownChart();
            super.createFromIDatabaseInfo(ServerMessage.getApplet(), chartDim, chartType, dbInfo, doTransposeData, TransposeRS.getTransposeColumn(transposeCol), mapping, template, true);
            ret.chart.currentNode = node;
            node.setDrillDownChart(ret);
            ret.getChart().setPrevParamPrompt(prevParamPrompt);
            return ret;
        }
        catch (Exception ex) {
            this.chart.currentNode.remove(node);
            throw ex;
        }
    }

    public void updateDrillDownCharts() throws Exception {
        this.saveDrillDownCharts(this.chart.currentNode, false);
    }

    private void saveDrillDownCharts(DrillDownNode parent, boolean updateFileName) throws Exception {
        int i;
        if (parent == null) {
            return;
        }
        Vector<DrillDownNode> children = new Vector<DrillDownNode>();
        for (i = 0; i < parent.getChildCount(); ++i) {
            children.addElement(parent.getChildAt(i));
        }
        parent.removeAllChildren();
        for (i = 0; i < children.size(); ++i) {
            DrillDownNode newChild = null;
            DrillDownNode oldChild = (DrillDownNode)children.elementAt(i);
            if (updateFileName || !oldChild.isSaved()) {
                newChild = parent.createNewChild(oldChild.getName());
                newChild.setColumnMapping(oldChild.getColumnMapping());
                newChild.setDrillDownChart(oldChild.getDrillDownChart());
                newChild.setSaved(oldChild.isSaved());
                for (int j = 0; j < oldChild.getChildCount(); ++j) {
                    newChild.add(oldChild.getChildAt(j));
                }
            } else {
                newChild = oldChild;
                parent.add(newChild);
            }
            Chart temp = null;
            if (newChild.getDrillDownChart() != null) {
                temp = ((QbChart)newChild.getDrillDownChart()).chart;
                Dimension dim = temp.getSize();
                String fName = newChild.getFileName();
                fName = fName.substring(0, fName.length() - 4);
                temp.get_directExport(fName, null, 5, dim.width, dim.height, this, false, 99);
                newChild.setSaved(true);
                continue;
            }
            if (!updateFileName) continue;
            CopyFile.copy(oldChild.getFileName(), newChild.getFileName());
        }
    }

    @Override
    public final Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    @Override
    public final void setPreferredSize(Dimension d) {
        this.width = d.width;
        this.height = d.height;
    }

    public final int getModifier() {
        return this.vpanel.getModifier();
    }

    public Object getArgument() {
        return this.eventArg;
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setChart(new LoadChart().load(this, in, false, null));
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        new SaveChart(this.chart).saveToDataOutput(out, false);
    }

    void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException("EspressChart only implements the java.io.Externalizable interface. Please use writeExternal()");
    }

    public static String getVersion() {
        return SaveChart.VERSIONNAME + " (VERSION " + 6612 + " Update " + SaveChart.UPDATE_VERSION + ")";
    }

    public static boolean isChartServerUsed() {
        return ServerMessage.useServer;
    }

    public static void setChartServerUsed(boolean b) {
        if (ServerMessage.useServer && !b) {
            ServerMessage.useServer = b;
            LCKey.resetLicense();
        }
        if (!ServerMessage.isServletServer()) {
            ServerMessage.useServer = b;
        }
    }

    public static void setChartServerUsed(int num) {
        if (!ServerMessage.isServletServer()) {
            ServerMessage.useServer = num != 0;
        }
    }

    public static void setChartServerUsed(String str) {
        if (!ServerMessage.isServletServer()) {
            ServerMessage.useServer = str.equalsIgnoreCase("true");
        }
    }

    public static boolean isEspressManagerUsed() {
        return ServerMessage.useServer;
    }

    public static void setEspressManagerUsed(boolean b) {
        if (!ServerMessage.isServletServer()) {
            ServerMessage.useServer = b;
        }
    }

    public static void setEspressManagerUsed(int num) {
        if (!ServerMessage.isServletServer()) {
            ServerMessage.useServer = num != 0;
        }
    }

    public static void setQueryTimeout(int seconds) {
        QbConnection.setQueryTimeout(seconds);
    }

    public static int getQueryTimeout() {
        return QbConnection.getQueryTimeout();
    }

    public static void setEspressManagerUsed(String str) {
        if (!ServerMessage.isServletServer()) {
            ServerMessage.useServer = str.equalsIgnoreCase("true");
        }
    }

    public static void setConnectURLForServer(String comm_url) {
        ServerMessage.setConnectURL(comm_url);
    }

    public static void useHttp(boolean b) {
        if (b) {
            ServerMessage.useHttp();
        } else {
            ServerMessage.useSocket();
        }
    }

    public static void setServletRunner(String comm_url) {
        ServerMessage.setConnectServlet(comm_url);
    }

    public static void useServlet(boolean b) {
        if (b) {
            ServerMessage.useServlet();
        } else {
            ServerMessage.useSocket();
        }
    }

    public static void setServletContext(String context) {
        ServerMessage.setServletContext(context);
    }

    public static String getServletContext() {
        return ServerMessage.getServletContext();
    }

    public static boolean isForExportOnly() {
        return forExportOnly;
    }

    public static void setForExportOnly(boolean state) {
        Chart.setForExportOnly(state);
        forExportOnly = state;
    }

    public static int getMaxRecordInMemory() {
        return ServerMessage.getPagingThreshold();
    }

    public static void setMaxRecordInMemory(int r) {
        ServerMessage.setPagingThreshold(r);
    }

    public static int getFileRecordBufferSize() {
        return ServerMessage.getPageBufferSize();
    }

    public static void setFileRecordBufferSize(int r) throws Exception {
        ServerMessage.setPageBufferSize(r);
    }

    public static int getMaxCharForRecordFile() {
        return ServerMessage.getMaxFieldSize();
    }

    public static void setMaxCharForRecordFile(int r) throws Exception {
        ServerMessage.setMaxFieldSize(r);
    }

    public static int getPagingThreshold() {
        return ServerMessage.getPagingThreshold();
    }

    public static void setPagingThreshold(int r) {
        ServerMessage.setPagingThreshold(r);
    }

    public static int getPageBufferSize() {
        return ServerMessage.getPageBufferSize();
    }

    public static void setPageBufferSize(int r) throws Exception {
        ServerMessage.setPageBufferSize(r);
    }

    public static int getMaxFieldSize() {
        return ServerMessage.getMaxFieldSize();
    }

    public static void setMaxFieldSize(int r) throws Exception {
        ServerMessage.setMaxFieldSize(r);
    }

    public static int getTotalPageBufferSize() {
        return ServerMessage.getTotalPageBufferSize();
    }

    public static void setTotalPageBufferSize(int r) throws Exception {
        ServerMessage.setTotalPageBufferSize(r);
    }

    public static String getTempDirectory() {
        return ServerMessage.getTempDirectory();
    }

    public static void setTempDirectory(String str) {
        ServerMessage.setTempDirectory(str);
    }

    public void setAdjustFont(boolean state) {
        this.chart.setAdjustFont(state);
    }

    public boolean isAdjustFont() {
        return this.chart.isAdjustFont();
    }

    @Deprecated
    public String getHTMLParamPage(String servletName) {
        return this.getHTMLParamPage(null, -1, servletName);
    }

    @Deprecated
    public String getHTMLParamPage(String chartLoc, int format, String servletName) {
        boolean isParamChart = this.getParamChart(chartLoc);
        if (isParamChart) {
            ChartParameterPage paramPage = this.getParameterPage(chartLoc, format, servletName);
            if (paramPage == null) {
                return null;
            }
            StringWriter strBuf = new StringWriter(2048);
            BufferedWriter out = new BufferedWriter(strBuf);
            HtmlParameterPageWriter writer = new HtmlParameterPageWriter(paramPage, out);
            try {
                writer.writePage();
                out.flush();
                out.close();
                return strBuf.toString();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Deprecated
    public String getHTMLParamPageBody(String servletName) {
        return this.getHTMLParamPageBody(null, -1, servletName);
    }

    @Deprecated
    public String getHTMLParamPageBody(String chartLoc, int format, String servletName) {
        boolean isParamChart = this.getParamChart(chartLoc);
        if (isParamChart) {
            ChartParameterPage paramPage = this.getParameterPage(chartLoc, format, servletName);
            if (paramPage == null) {
                return null;
            }
            StringWriter strBuf = new StringWriter(2048);
            BufferedWriter out = new BufferedWriter(strBuf);
            HtmlParameterPageWriter writer = new HtmlParameterPageWriter(paramPage, out);
            try {
                writer.writeBody();
                out.flush();
                out.close();
                return strBuf.toString();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Deprecated
    public String getHTMLParamPageBlock() {
        boolean isParamChart = this.getParamChart(null);
        if (isParamChart) {
            ChartParameterPage paramPage = this.getParameterPage(null, -1, null);
            if (paramPage == null) {
                return null;
            }
            StringWriter strBuf = new StringWriter(2048);
            BufferedWriter out = new BufferedWriter(strBuf);
            HtmlParameterPageWriter writer = new HtmlParameterPageWriter(paramPage, out);
            try {
                writer.writeParamTable();
                out.flush();
                out.close();
                return strBuf.toString();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private boolean getParamChart(String chartLoc) {
        IInputData inputData;
        quadbase.util.IDatabaseInfo dbInfo;
        try {
            if (this.chart == null) {
                this.chart = this.loadChartFromFile(chartLoc, true);
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        boolean isParamChart = true;
        if (this.chart != null && (dbInfo = (inputData = this.gethInputData()).getDatabaseInfo()) != null && dbInfo instanceof quadbase.common.util.IQueryFileInfo) {
            isParamChart = true;
        }
        return isParamChart;
    }

    @Deprecated
    public static void setGIFEnable(String serialNumber, String key) throws Exception {
    }

    public void setBufferedImageUsed(boolean state) {
        this.chart.setBufferedImageUsed(state);
    }

    public boolean isBufferedImageUsed() {
        return this.chart.isBufferedImageUsed();
    }

    public void setBufferedImageType(int imageType) {
        this.chart.setBufferedImageType(imageType);
    }

    public int getBufferedImageType() {
        return this.chart.getBufferedImageType();
    }

    public void setGrayscaleForExport(boolean isGrayscale) {
        if (isGrayscale) {
            this.chart.setBufferedImageType(10);
        } else {
            this.chart.setBufferedImageType(1);
        }
    }

    public boolean isGrayscaleForExport() {
        return this.chart.getBufferedImageType() == 10;
    }

    public final String getTemplateFile() {
        return this.ctemplate;
    }

    public final void applyTemplateFile(String fileName) throws IOException {
        try {
            this.chart = this.loadTemplate(fileName);
        }
        catch (Exception ex) {
            throw new IOException("Failed to apply template " + ex.toString());
        }
        this.ctemplate = fileName;
        this.setrepaint(true);
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.chart != null) {
            this.chart.setLocale(locale);
        }
    }

    @Override
    public void setPanelBorder(Object border) {
        super.setPanelBorder(border);
        if (this.vpanel != null) {
            this.vpanel.setPanelBorder(border);
        }
        if (this.vpanel3d != null) {
            this.vpanel3d.setPanelBorder(border);
        }
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        if (this.vpanel != null) {
            this.vpanel.setOpaque(isOpaque);
        }
        if (this.vpanel3d != null) {
            this.vpanel3d.setOpaque(isOpaque);
        }
    }

    @Override
    public Locale getLocale() throws IllegalComponentStateException {
        if (this.chart.getLocale() != null) {
            return this.chart.getLocale();
        }
        return super.getLocale();
    }

    public TimeZone getTimeZone() {
        return this.chart.getTimeZone();
    }

    public void setTimeZone(TimeZone zone) {
        this.chart.setTimeZone(zone);
    }

    public final String getFile() {
        return this.vpanel3d.filename;
    }

    public final void loadFile(String fileName) throws IOException {
        try {
            this.chart = this.loadChartFromFile(fileName);
        }
        catch (Exception ex) {
            throw new IOException("Failed to load chart file " + fileName + " " + ex.toString());
        }
        this.setrepaint(true);
        this.vpanel3d.filename = fileName;
        this.ctemplate = null;
    }

    public final int getDimension() {
        return this.chart.is2DimChart() ? 0 : 1;
    }

    public final void setDimension(int d) {
        this.chart = Chart.createChart(this, this.chart.getChartType(), d == 0, this.chart, null);
        this.setrepaint(true);
    }

    public final int getType() {
        return this.chart.getChartType();
    }

    public final void setType(int type) {
        this.chart = Chart.createChart(this, type, this.chart.is2DimChart(), this.chart, null);
        this.setrepaint(true);
    }

    public boolean isPrintKeyEnabled() {
        return this.vpanel.printing;
    }

    public void setPrintKeyEnabled(boolean b) {
        this.vpanel.printing = b;
    }

    public boolean isRefreshEnabled() {
        return this.vpanel.refreshData;
    }

    public void setRefreshEnabled(boolean b) {
        this.vpanel.refreshData = b;
    }

    public final boolean isHiLowAsCandleStick() {
        return this.chart.getCandleStick();
    }

    public final void setHiLowAsCandleStick(boolean b) {
        this.chart.setCandleStick(b);
        this.setrepaint(true);
    }

    @Deprecated
    public static void setScrollBarOption(int option) {
        System.out.println("This method is no longer existed!");
        System.out.println("Please see quadbase.util.ICanvas.setScrollBarOption");
    }

    public final I3DControlPanel geth3DControlPanel() {
        return new QbChartBasic.ControlPanel(this);
    }

    public final I3DPropertySet geth3DProperties() {
        return new QbChartBasic.C3DPropertySet(this);
    }

    public final ITextString gethMainTitle() {
        return new QbChartBasic.CMainTitle(this);
    }

    public final ILegend gethLegend() {
        return new QbChartBasic.CLegend(this, true);
    }

    public final ILegend gethLegend2() {
        return new QbChartBasic.CLegend(this, false);
    }

    public final IAxis gethXAxis() {
        return new QbChartBasic.CAxis(this, 0, this.chart.getCategoryIndex());
    }

    public final IAxis gethYAxis() {
        return new QbChartBasic.CAxis(this, 1, this.chart.getPrimaryIndex());
    }

    public final IAxis gethZAxis() {
        int colIndex = -1;
        if (this.chart.is2DimChart()) {
            return new QbChartBasic.CAxis(this, 2, this.chart.getSumByIndex());
        }
        colIndex = this.chart.chartType == 2 || this.chart.chartType == 13 || this.chart.chartType == 12 ? this.chart.getCoordMap()[2] : (this.chart.isStackType() ? this.chart.getSumByIndex() : this.chart.getSeriesIndex());
        return new QbChartBasic.CAxis(this, 2, colIndex);
    }

    public final IAxis gethAxis(int idx) {
        return new QbChartBasic.CAxis(this, idx + 4, idx + 4);
    }

    public final ICanvas gethCanvas() {
        return new QbChartBasic.CCanvas(this);
    }

    public final IHyperLinkSet gethHyperLinks() {
        return new QbChartBasic.CHyperLinkSet(this);
    }

    @Deprecated
    public final ITrendLineSet gethTrendLines() {
        return new QbChartBasic.CTrendLineSet(this);
    }

    public final IDataLineSet gethDataLines() {
        return new QbChartBasic.CDataLineSet(this);
    }

    public final IControlRangeSet gethControlRanges() {
        return new QbChartBasic.CControlRangeSet(this);
    }

    public final IDropBarSet gethDropBars() {
        return new QbChartBasic.CDropBarSet(this);
    }

    public final IAnnotationSet gethAnnotations() {
        return new QbChartBasic.CAnnotationSet(this);
    }

    public final IFloatingLineSet gethFloatingLines() {
        return new QbChartBasic.CFloatingLineSet(this);
    }

    public final IFloatingTextSet gethFloatingText() {
        return new QbChartBasic.CFloatingTextSet(this);
    }

    public final IPlot gethChartPlot() {
        return new QbChartBasic.CPlot(this);
    }

    public final IInputData gethInputData() {
        return new QbChartBasic.CInputData(this);
    }

    public final IDataPointSet gethDataPoints() {
        return new QbChartBasic.CDataPointSet(this);
    }

    public final IBubblePropertySet gethBubbleProperties() {
        return new QbChartBasic.CBubblePropertySet(this);
    }

    public final IFlashHintBoxPropertySet gethFlashHintBoxProperties() {
        return new QbChartBasic.CFlashHintBoxPropertySet(this);
    }

    public final IPiePropertySet gethPieProperties() {
        return new QbChartBasic.CPiePropertySet(this);
    }

    public final ISurfacePropertySet gethSurfaceProperties() {
        return new QbChartBasic.CSurfacePropertySet(this);
    }

    public final IDoughnutPropertySet gethDoughnutProperties() {
        return new QbChartBasic.CDoughnutPropertySet(this);
    }

    public final IOverlayPropertySet gethOverlayProperties() {
        return new QbChartBasic.COverlayPropertySet(this);
    }

    public final IRadarPropertySet gethRadarProperties() {
        return new QbChartBasic.CRadarPropertySet(this);
    }

    public final IPolarPropertySet gethPolarProperties() {
        return new QbChartBasic.CPolarPropertySet(this);
    }

    public final ILinePropertySet gethLineProperties() {
        return new QbChartBasic.CLinePropertySet(this);
    }

    public final IGanttPropertySet gethGanttProperties() {
        return new QbChartBasic.CGanttPropertySet(this);
    }

    public final IDialPropertySet gethDialProperties() {
        return new QbChartBasic.CDialPropertySet(this);
    }

    public final IBoxPropertySet gethBoxProperties() {
        return new QbChartBasic.CBoxPropertySet(this);
    }

    public final ISecondaryChart gethSecondaryChart() {
        return new QbChartBasic.CSecondaryChart(this);
    }

    public final IAxisRuler gethXRuler() {
        return new QbChartBasic.CAxisRuler(this, 0);
    }

    public final IAxisRuler gethYRuler() {
        return new QbChartBasic.CAxisRuler(this, 1);
    }

    public final IZoomInfo gethZoomInfo() {
        return new QbChartBasic.CZoomInfo(this);
    }

    public final IDrillDown gethDrillDown() {
        return new QbChartBasic.CDrillDown(this);
    }

    public final ITable gethTable() {
        return new QbChartBasic.CTable(this);
    }

    public final IHistogramInfo gethHistogramInfo() {
        return new QbChartBasic.CHistogramInfo(this);
    }

    public final IAggregationInfo gethAggregationInfo() {
        return new QbChartBasic.CAggregationInfo(this);
    }

    public final IMouseEventSet gethMouseEvents() {
        return new QbChartBasic.CMouseEventSet(this);
    }

    public final IPopupMenu gethPopupMenu() {
        return new QbChartBasic.CPopupMenu(this);
    }

    public final INoDataToPlotMessage gethNoDataToPlotMessage() {
        return new QbChartBasic.CNoDataToPlotMessage(this);
    }

    public static void setServerAddress(String address) throws UnknownHostException {
        ServerMessage.setAddress(address);
    }

    public static void setServerPortNumber(int port) {
        ServerMessage.setPortNumber(port);
    }

    public static void setServerHosts(Vector<String> hostnames) {
        ServerMessage.setHosts(hostnames);
    }

    public ChartParameterPage getParameterPage(String chartLoc, int format, String servletName) {
        boolean isParamChart = this.getParamChart(chartLoc);
        if (!isParamChart) {
            return null;
        }
        return this.chart.getParameterPage(chartLoc, format, servletName);
    }

    public static boolean useSingleTableForDistinctParamValue() {
        return ServerMessage.useSingleTableForDistinctParamValue();
    }

    public static void setUseSingleTableForDistinctParamValue(boolean state) {
        ServerMessage.setUseSingleTableForDistinctParamValue(state);
    }

    public static String getUpdateVersion() {
        return SaveChart.getUpdateVersion();
    }

    public void saveAs(String filename, String relativeDomainPath, boolean ignoreDrilldowns) {
        this.saveChart(this.getChart(), filename, ignoreDrilldowns);
    }

    void saveChart(Chart chart, String file, boolean ignoreDrilldowns) {
        if (file == null) {
            return;
        }
        if (file.endsWith(".xml")) {
            file = file.substring(0, file.length() - 4);
        }
        if (!(file.endsWith(".tpl") || file.endsWith(".cht") || file.endsWith(".qch"))) {
            file = file + ".cht";
        }
        try {
            SaveChart saveChart = new SaveChart(chart);
            if (chart.currentNode != null && !ignoreDrilldowns) {
                saveChart.setDrillDownNode(chart.currentNode);
            }
            if (file.endsWith(".xml")) {
                String chartName = chart.getXMLChartLocation();
                this.saveToFile(chart, saveChart, chartName.substring(0, chartName.length() - 4), chartName.endsWith(".tpl"));
                saveChart.createXMLChartFile(file, chart.getXMLChartLocation());
            } else {
                this.saveToFile(chart, saveChart, file.substring(0, file.length() - 4), file.endsWith(".tpl"));
            }
            chart.currentNode.setFileName(file);
            if (!ignoreDrilldowns) {
                this.copyChildNodes(chart.currentNode);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }

    void saveToFile(Chart chart, SaveChart saveChart, String fileName, boolean template) throws Exception {
        if (chart.currentNode != null) {
            chart.currentNode.setFileName(fileName + (template ? ".tpl" : ".cht"));
        }
        saveChart.saveToFile(fileName, template);
    }

    private void copyChildNodes(DrillDownNode node) {
        int i;
        Vector<DrillDownNode> children = new Vector<DrillDownNode>();
        for (i = 0; i < node.getChildCount(); ++i) {
            children.addElement(node.getChildAt(i));
        }
        node.removeAllChildren();
        for (i = 0; i < children.size(); ++i) {
            DrillDownNode oldChild = (DrillDownNode)children.elementAt(i);
            DrillDownNode newChild = node.createNewChild(oldChild.getName());
            newChild.setColumnMapping(oldChild.getColumnMapping());
            try {
                CopyFile.copy(oldChild.getFileName(), newChild.getFileName());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (oldChild.isLeaf()) continue;
            for (int j = 0; j < oldChild.getChildCount(); ++j) {
                newChild.add(oldChild.getChildAt(j));
            }
            this.copyChildNodes(newChild);
        }
    }

    @Override
    public String[] getAllAlertIds() {
        return this.chart.getAllAlertIds();
    }

    @Override
    public String[] getTriggeredAlertIds() {
        return this.chart.getTriggeredAlertIds();
    }

    @Override
    public Map<String, Vector<String>> getTriggeredAlertDetails() {
        return this.chart.getTriggeredAlertDetails();
    }
}

