/*
 * Decompiled with CFR 0.152.
 */
package quadbase.ChartAPI;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.DataInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import quadbase.ChartAPI.AxisScale;
import quadbase.ChartAPI.ColInfo;
import quadbase.ChartAPI.DBInfo;
import quadbase.ChartAPI.DbData;
import quadbase.ChartAPI.IMiscConstants;
import quadbase.ChartAPI.PickObj;
import quadbase.ChartAPI.QbChartPanel;
import quadbase.ChartAPI.TextString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.DBAccess;
import quadbase.chart.DataFileInput;
import quadbase.chart.DataLine;
import quadbase.chart.DrillDownNode;
import quadbase.chart.ExcelAccess;
import quadbase.chart.HiLowMap;
import quadbase.chart.IPieChart;
import quadbase.chart.Legend;
import quadbase.chart.LoadChart;
import quadbase.chart.PreprocInfo;
import quadbase.chart.PropCString;
import quadbase.chart.ReadDataFile;
import quadbase.chart.ReloadChart;
import quadbase.chart.SalesForceAccess;
import quadbase.chart.TrendLine;
import quadbase.chartviewer.AxisRuler;
import quadbase.chartviewer.IChartHolder;
import quadbase.chartviewer.ViewPanel;
import quadbase.chartviewer.Viewer3DPanel;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.util.ColorSpectrum;
import quadbase.util.ControlRange;
import quadbase.util.HyperLink;
import quadbase.util.I3DControlPanel;
import quadbase.util.I3DPropertySet;
import quadbase.util.IAggregationInfo;
import quadbase.util.IAnnotation;
import quadbase.util.IAnnotationSet;
import quadbase.util.IAxis;
import quadbase.util.IAxisRuler;
import quadbase.util.IBoxPropertySet;
import quadbase.util.IBubblePropertySet;
import quadbase.util.ICanvas;
import quadbase.util.IColumnMap;
import quadbase.util.IControlLine;
import quadbase.util.IControlRangeSet;
import quadbase.util.ICustomizeImageMapDataHintBox;
import quadbase.util.IDataLabelInfo;
import quadbase.util.IDataLine;
import quadbase.util.IDataLineSet;
import quadbase.util.IDataPointSet;
import quadbase.util.IDatabaseInfo;
import quadbase.util.IDialPropertySet;
import quadbase.util.IDoughnutPropertySet;
import quadbase.util.IDrillDown;
import quadbase.util.IDropBarSet;
import quadbase.util.IFlashHintBoxPropertySet;
import quadbase.util.IFloatingLineSet;
import quadbase.util.IFloatingTextSet;
import quadbase.util.IFormat;
import quadbase.util.IFunction;
import quadbase.util.IFunctionLine;
import quadbase.util.IGanttPropertySet;
import quadbase.util.IHint;
import quadbase.util.IHintBoxInfo;
import quadbase.util.IHistogramInfo;
import quadbase.util.IHorzVertLine;
import quadbase.util.IHyperLinkSet;
import quadbase.util.IInputData;
import quadbase.util.ILabel;
import quadbase.util.ILegend;
import quadbase.util.ILinePropertySet;
import quadbase.util.IMapConstants;
import quadbase.util.IMouseEventSet;
import quadbase.util.INoDataToPlotMessage;
import quadbase.util.IOverlayPropertySet;
import quadbase.util.IPiePropertySet;
import quadbase.util.IPlot;
import quadbase.util.IPolarPropertySet;
import quadbase.util.IPopupMenu;
import quadbase.util.IQueryFileInfo;
import quadbase.util.IRadarPropertySet;
import quadbase.util.IReferenceObj;
import quadbase.util.IResultSet;
import quadbase.util.IRow;
import quadbase.util.ISecondaryChart;
import quadbase.util.ISpreadSheetModel;
import quadbase.util.ISpreadSheetModelListener;
import quadbase.util.ISurfacePropertySet;
import quadbase.util.ITable;
import quadbase.util.IText;
import quadbase.util.ITextString;
import quadbase.util.ITrendLine;
import quadbase.util.ITrendLineSet;
import quadbase.util.IZoomInfo;
import quadbase.util.LocaleNumericFormat;
import quadbase.util.NumericFormat;
import quadbase.util.PickData;
import quadbase.util.Point_3D;
import quadbase.util.PolyLine;
import quadbase.util.Position;
import quadbase.util.SpreadSheetModelEvent;
import quadbase.util.internal.BooleanCompare;
import quadbase.util.internal.DateCompare;
import quadbase.util.internal.ICompareObject;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.ImageData;
import quadbase.util.internal.NumberCompare;
import quadbase.util.internal.QbUtil;
import quadbase.util.internal.StringCompare;
import quadbase.util.internal.TransposeRS;

public abstract class QbChartBasic
extends QbChartPanel
implements ActionListener,
IMiscConstants,
IMapConstants,
Externalizable,
IChartHolder {
    protected static boolean forExportOnly = false;
    static final int VIEW2D = 0;
    static final int VIEW3D = 1;
    protected Chart chart;
    String errorMessage = null;
    Frame frame = null;
    String ctemplate = null;
    Viewer3DPanel vpanel3d = null;
    ViewPanel vpanel = null;
    Object eventArg;
    IColumnMap newColInfo;
    ISpreadSheetModel spreadSheet;
    ISpreadSheetModelListener spreadSheetListener;
    Vector<MouseListener> mouseListenerList = new Vector();
    Vector<MouseMotionListener> mouseMotionListenerList = new Vector();
    Vector<KeyListener> keyListenerList = new Vector();
    int width = 500;
    int height = 375;
    protected DrillDownNode root = null;
    protected static String SURFACEDATAERROR = "The data cannot plot a 3D surface chart";

    void setChart(Chart chart) {
        this.chart = chart;
        this.removeAll();
        this.initPanel();
        this.setrepaint(true);
        this.invalidate();
    }

    @Override
    public void setChartHolder(Chart chart) {
        this.chart = chart;
    }

    @Override
    public void setViewPanel(ViewPanel vpanel) {
        this.vpanel = vpanel;
        this.vpanel.addActionListener(this);
    }

    void setDataMap(IColumnMap c) throws IllegalArgumentException {
        if (c instanceof ColInfo) {
            ((ColInfo)c).setDataColumn(this.chart);
            return;
        }
        int category = c.getColumn(0);
        int series = c.getColumn(1);
        int subvalue = c.getColumn(4);
        int subseries = c.getColumn(12);
        if (this.chart.getChartType() == 9 || this.chart.getChartType() == 18 || this.chart.getChartType() == 10) {
            this.chart.setDataColumn(series, category, -1, c.getColumn(8), c.getColumn(9), c.getColumn(11), c.getColumn(10), subvalue, subseries);
        } else {
            this.chart.setDataColumn(series, category, c.getColumn(2), c.getColumn(3), c.getColumn(5), c.getColumn(6), c.getColumn(7), subvalue, subseries);
        }
    }

    protected void createChart(int dimension, int chartType, ColData[] data, IColumnMap cinfo, String templatename) {
        if (this.errorMessage == null) {
            if (templatename != null && !templatename.toLowerCase().endsWith(".tpl")) {
                throw new IllegalArgumentException("applied template must be of type TPL (template)");
            }
            try {
                if (cinfo == null && templatename != null) {
                    cinfo = new ColInfo(LoadChart.getColInfo(this, templatename));
                }
                if (data != null) {
                    this.chart = Chart.createChart(this, chartType, dimension == 0, null, data);
                } else if (this.chart != null) {
                    this.chart = Chart.createChart(this, chartType, dimension == 0, this.chart, null);
                } else {
                    throw new IllegalArgumentException("Null data argument");
                }
                if (cinfo != null) {
                    this.setDataMap(cinfo);
                }
            }
            catch (Exception ex) {
                this.errorMessage = chartType == 12 ? SURFACEDATAERROR : IOUtil.getStackTrace(ex);
                return;
            }
            if (templatename != null) {
                try {
                    this.chart = this.loadTemplate(templatename);
                }
                catch (Exception ex) {
                    this.errorMessage = "Failed to load template " + ex.toString();
                }
                this.ctemplate = templatename;
            }
        }
        if (this.chart.getChartType() == 2) {
            this.chart.setLabelDateTimeDisplay(0, DataType.isDateTime(this.chart.colData[this.chart.coordCol[0]].axisType));
            this.chart.setLabelDateTimeDisplay(1, DataType.isDateTime(this.chart.colData[this.chart.coordCol[1]].axisType));
            if (!this.chart.is2DimChart()) {
                this.chart.setLabelDateTimeDisplay(2, DataType.isDateTime(this.chart.colData[this.chart.coordCol[2]].axisType));
            }
        }
        this.initDrillDownTree(this.chart, null);
        this.initPanel();
    }

    Chart readChart(DataInputStream din, boolean btemplate) {
        return this.readChart(din, btemplate, false);
    }

    Chart readChart(DataInputStream din, boolean btemplate, boolean isEnterprise) {
        return this.readChart(din, btemplate, isEnterprise, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Chart readChart(DataInputStream din, boolean btemplate, boolean isEnterprise, Vector parameters, boolean useBackupData) {
        Chart newchart = null;
        try {
            LoadChart lc = new LoadChart();
            lc.setUsingBackupData(useBackupData);
            lc.setParameterField(parameters);
            newchart = lc.load(this, din, btemplate, null, isEnterprise);
            if (this.chart != null) {
                newchart.mergeSubFilesTable(this.chart.getSubFilesTable());
            }
            Vector<DrillDownNode> childNodes = lc.getChildNodes();
            this.initDrillDownTree(newchart, lc.getDrillDownNode(), childNodes);
            this.errorMessage = lc.getErrorMessage();
        }
        catch (Exception ex) {
            this.errorMessage = IOUtil.getStackTrace(ex);
            ex.printStackTrace();
        }
        finally {
            if (din != null) {
                try {
                    din.close();
                }
                catch (Exception exception) {}
            }
        }
        return newchart;
    }

    void initDrillDownTree(Chart r, DrillDownNode node) {
        this.initDrillDownTree(r, node, null);
    }

    void initDrillDownTree(Chart r, DrillDownNode node, Vector<DrillDownNode> childNodes) {
        if (node != null) {
            this.root = node;
        } else {
            this.root = new DrillDownNode("ROOT");
            if (childNodes != null) {
                for (int i = 0; i < childNodes.size(); ++i) {
                    this.root.add(childNodes.elementAt(i));
                }
            }
        }
        if (r != null) {
            r.currentNode = this.root;
        }
    }

    void initPanel() {
        if (forExportOnly) {
            return;
        }
        this.setLayout(new BorderLayout());
        if (this.errorMessage == null) {
            String currFile = null;
            if (this.vpanel3d != null) {
                currFile = this.vpanel3d.filename;
            }
            this.vpanel3d = new Viewer3DPanel(this.chart, this);
            this.vpanel3d.filename = currFile;
            this.vpanel = this.vpanel3d.viewPanel;
            this.add("Center", this.vpanel3d);
            this.vpanel.addActionListener(this);
            for (MouseListener mouseListener : this.mouseListenerList) {
                this.vpanel.addMouseListener(mouseListener);
            }
            for (EventListener eventListener : this.mouseMotionListenerList) {
                this.vpanel.addMouseMotionListener((MouseMotionListener)eventListener);
            }
        } else {
            this.add("Center", new TextArea(this.errorMessage, 20, 8));
        }
    }

    @Override
    public final void paint(Graphics g) {
        if (this.newColInfo != null) {
            try {
                this.setDataMap(this.newColInfo);
                this.newColInfo = null;
            }
            catch (Exception ex) {
                this.newColInfo = null;
                System.out.println(ex);
            }
            this.setrepaint(true);
        }
        super.paint(g);
    }

    @Override
    public final void paintAll(Graphics g) {
        this.paint(g);
        if (!this.vpanel3d.chart.is2DimChart() && this.vpanel3d.navexist) {
            this.vpanel3d.getControlPanel().paintAll(g);
        }
    }

    @Override
    public final void printAll(Graphics g) {
        super.printAll(g);
    }

    @Override
    public final void print(Graphics g) {
        super.print(g);
    }

    public abstract void refresh() throws IOException, SQLException, ClassNotFoundException;

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = this.vpanel3d.getValue();
        this.eventArg = obj instanceof PickData ? new PickObj((PickData)obj) : obj;
        this.fireEvent(this, 0, this.vpanel3d.getModifier());
    }

    Chart loadTemplate(String templatename) throws Exception {
        return this.chart.loadTemplate(templatename);
    }

    Chart loadChartFromFile(String urlname) throws IOException {
        return this.loadChartFromFile(urlname, false);
    }

    Chart loadChartFromFile(String urlname, boolean isEnterpriseServer) throws IOException {
        return this.loadChartFromFile(urlname, isEnterpriseServer, null, false);
    }

    Chart loadChartFromFile(String urlname, Vector parameters) throws IOException {
        return this.loadChartFromFile(urlname, false, parameters, false);
    }

    Chart loadChartFromFile(String urlname, boolean isEnterpriseServer, Vector parameters, boolean useBackupData) throws IOException {
        ReadDataFile readfile = new ReadDataFile();
        try {
            if (IOUtil.isXMLFormat(urlname)) {
                return readfile.createXMLChart(urlname, this, isEnterpriseServer, parameters);
            }
            DataInputStream din = readfile.getInputStream(this.chart, urlname);
            Chart newchart = this.readChart(din, urlname.endsWith(".tpl"), isEnterpriseServer, parameters, useBackupData);
            readfile.close();
            return newchart;
        }
        catch (Exception ex) {
            try {
                readfile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(ex.toString());
        }
    }

    Object[] getValidRow(IRow r) {
        try {
            int l = this.chart.getColData().length - 1;
            Object[] rec = new Object[l];
            for (int i = 1; i <= l; ++i) {
                rec[i - 1] = r.getObject(i);
            }
            return this.getValidRecord(rec);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to read row : " + ex);
        }
    }

    Object[] getValidRecord(Object rec) {
        Object[] newRecord;
        if (rec == null || !(rec instanceof Object[])) {
            throw new IllegalArgumentException("Record must be instance of String array or Object array");
        }
        ColData[] colData = this.chart.getColData();
        int len = colData.length - 1;
        if (rec instanceof String[]) {
            String[] sarray = (String[])rec;
            if (sarray.length != len) {
                throw new IllegalArgumentException("Record size must be equal to " + len);
            }
            newRecord = new Object[len];
            for (int i = 0; i < len; ++i) {
                newRecord[i] = DataType.createObject(sarray[i], colData[i].getDataType());
            }
        } else {
            newRecord = (Object[])rec;
            for (int i = 0; i < len; ++i) {
                if (DataType.match(colData[i].getOriginalDataType(), newRecord[i])) continue;
                throw new IllegalArgumentException("Record type mismatch in field " + i + ". Data Type must be " + DataType.getTypeName(colData[i].getOriginalDataType()));
            }
        }
        return newRecord;
    }

    int searchRecord(ColData[] cdata, String[] sarray) throws IllegalArgumentException {
        Object[] newRecord = this.getValidRecord(sarray);
        int size = cdata[0].getSize();
        for (int i = size - 1; i >= 0; --i) {
            boolean bfind = true;
            for (int j = 0; j < cdata.length - 1; ++j) {
                if (cdata[j].getData(i).toString().equals(newRecord[j].toString())) continue;
                bfind = false;
                break;
            }
            if (!bfind) continue;
            return i;
        }
        return -1;
    }

    void setrepaint(boolean reset) {
        if (reset) {
            this.chart.newSurface();
        }
        if (!forExportOnly) {
            if (this.vpanel3d != null) {
                this.vpanel3d.setChart(this.chart);
            }
            if (this.vpanel != null) {
                this.vpanel.setrepaint(this.chart);
            }
        }
    }

    Vector checkLine(Object value) throws IllegalArgumentException {
        if (!(value instanceof Vector)) {
            throw new IllegalArgumentException("value must be instance of Vector");
        }
        Vector vec = (Vector)value;
        for (int i = 0; i < vec.size(); ++i) {
            if (vec.elementAt(i) instanceof Point_3D) continue;
            throw new IllegalArgumentException("Element of vector must be instance of Point_3D");
        }
        return vec;
    }

    HyperLink checkHyperLink(Object value) throws IllegalArgumentException {
        if (!(value instanceof HyperLink)) {
            throw new IllegalArgumentException("value must be instance of HyperLink");
        }
        return (HyperLink)value;
    }

    Vector checkHyperLinkList(Object value) throws IllegalArgumentException {
        if (!(value instanceof Vector)) {
            throw new IllegalArgumentException("value must be instance of Vector");
        }
        Vector vec = (Vector)value;
        for (int i = 0; i < vec.size(); ++i) {
            if (!(vec.elementAt(i) instanceof HyperLink)) {
                throw new IllegalArgumentException("value must be instanceof HyperLink in element " + i);
            }
            HyperLink hlink = (HyperLink)vec.elementAt(i);
            if (hlink.series == null) {
                hlink.series = "";
            }
            if (hlink.category == null) {
                hlink.category = "";
            }
            if (hlink.sumBy != null) continue;
            hlink.sumBy = "";
        }
        return vec;
    }

    Vector checkFaceHyperLinkList(Object value) throws IllegalArgumentException {
        if (!(value instanceof Vector)) {
            throw new IllegalArgumentException("value must be instance of Vector");
        }
        Vector vec = (Vector)value;
        return vec;
    }

    TextString checkTextString(Object value) throws IllegalArgumentException {
        if (!(value instanceof TextString)) {
            throw new IllegalArgumentException("value must be instance of TextString");
        }
        return (TextString)value;
    }

    Float[] toUserScale(Float[] values) {
        Float[] v = new Float[values.length];
        for (int i = 0; i < values.length; ++i) {
            v[i] = Float.valueOf(values[i].floatValue() / 1000.0f);
        }
        return v;
    }

    float[] toSpaceScale(float[] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] * 1000.0f;
        }
        return values;
    }

    String[] checkStrArr(Object value) throws IllegalArgumentException {
        String[] sarray;
        if (!(value instanceof String[])) {
            if (!(value instanceof Object[])) {
                throw new IllegalArgumentException("Value must be instance of String array or Object array");
            }
            Object[] objarr = (Object[])value;
            sarray = new String[objarr.length];
            for (int i = 0; i < sarray.length; ++i) {
                sarray[i] = objarr[i].toString();
            }
        } else {
            sarray = (String[])value;
        }
        return sarray;
    }

    IFormat checkNumericFormat(Object value) throws IllegalArgumentException {
        if (!(value instanceof NumericFormat) && !(value instanceof LocaleNumericFormat)) {
            throw new IllegalArgumentException("Value must be instance of NumericFormat or LocaleNumericFormat");
        }
        return (IFormat)value;
    }

    int checkInt(Object value) throws IllegalArgumentException {
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException("Value must be instance of Integer");
        }
        return (Integer)value;
    }

    String checkString(Object value) throws IllegalArgumentException {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Value must be instance of String");
        }
        return (String)value;
    }

    String[] checkStringArray(Object value) throws IllegalArgumentException {
        if (!(value instanceof String[])) {
            throw new IllegalArgumentException("Value must be instance of String array");
        }
        return (String[])value;
    }

    Color checkColor(Object value) throws IllegalArgumentException {
        if (!(value instanceof Color)) {
            throw new IllegalArgumentException("Value must be instance of Color");
        }
        return (Color)value;
    }

    boolean checkBoolean(Object value) throws IllegalArgumentException {
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("Value must be instance of Boolean");
        }
        return (Boolean)value;
    }

    boolean[] checkbooleans(Object value) throws IllegalArgumentException {
        if (!(value instanceof boolean[])) {
            throw new IllegalArgumentException("Value must be instance of boolean[]");
        }
        return (boolean[])value;
    }

    Font checkFont(Object value) throws IllegalArgumentException {
        if (!(value instanceof Font)) {
            throw new IllegalArgumentException("Value must be instance of Font");
        }
        return (Font)value;
    }

    double checkDouble(Object value) throws IllegalArgumentException {
        if (!(value instanceof Double)) {
            throw new IllegalArgumentException("Value must be instance of Double");
        }
        return (Double)value;
    }

    double checkNumber(Object value) throws IllegalArgumentException {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Value must be a number");
        }
        return ((Number)value).doubleValue();
    }

    float checkFloat(Object value, boolean range) throws IllegalArgumentException {
        if (!(value instanceof Float)) {
            throw new IllegalArgumentException("Value must be instance of Float");
        }
        float v = ((Float)value).floatValue();
        if (range) {
            if (v > 1.0f) {
                v = 1.0f;
            } else if (v < 0.0f) {
                v = 0.0f;
            }
        }
        return v;
    }

    Float[] checkFloatArray(Object value) throws IllegalArgumentException {
        if (!(value instanceof Float[])) {
            throw new IllegalArgumentException("Value must be instance of Float array");
        }
        return (Float[])value;
    }

    AxisScale checkAxisScale(Object value) throws IllegalArgumentException {
        if (!(value instanceof AxisScale)) {
            throw new IllegalArgumentException("Value must be instance of AxisScale");
        }
        return (AxisScale)value;
    }

    int[] integerToIntArray(Object value) {
        if (!(value instanceof Integer[])) {
            throw new IllegalArgumentException("Value must be instance of Integer array");
        }
        Integer[] input = (Integer[])value;
        int[] result = new int[input.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = input[i];
        }
        return result;
    }

    float[] checkFloats(Object value, int len) throws IllegalArgumentException {
        if (!(value instanceof Float[])) {
            throw new IllegalArgumentException("Value must be instance of Float array of length" + len);
        }
        Float[] farray = (Float[])value;
        if (farray.length != len) {
            throw new IllegalArgumentException("Array must be of length " + len);
        }
        float[] f = new float[len];
        for (int i = 0; i < len; ++i) {
            f[i] = farray[i].floatValue();
        }
        return f;
    }

    Float[] getFloats(float[] farray) {
        Float[] f = new Float[farray.length];
        for (int i = 0; i < f.length; ++i) {
            f[i] = Float.valueOf(farray[i]);
        }
        return f;
    }

    TextString[] getTextList(Vector vec) {
        if (vec == null) {
            return null;
        }
        TextString[] sarray = new TextString[vec.size()];
        for (int i = 0; i < sarray.length; ++i) {
            sarray[i] = new TextString((PropCString)vec.elementAt(i));
        }
        return sarray;
    }

    TrendLine checkTrendLine(Object value) throws IllegalArgumentException {
        if (!(value instanceof TrendLine)) {
            throw new IllegalArgumentException("value must be instance of TrendLine");
        }
        return (TrendLine)value;
    }

    Vector checkTrendLineList(Object value) throws IllegalArgumentException {
        if (!(value instanceof Vector)) {
            throw new IllegalArgumentException("value must be instance of TrendLine");
        }
        Vector vec = (Vector)value;
        for (int i = 0; i < vec.size(); ++i) {
            if (vec.elementAt(i) instanceof TrendLine) continue;
            throw new IllegalArgumentException("vlaue must be instanceof TrendLine in element " + i);
        }
        return vec;
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        this.keyListenerList.addElement(l);
        this.vpanel.addKeyListener(l);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        this.keyListenerList.removeElement(l);
        this.vpanel.removeKeyListener(l);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.mouseListenerList.addElement(l);
        this.vpanel.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.mouseListenerList.removeElement(l);
        this.vpanel.removeMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.mouseMotionListenerList.addElement(l);
        this.vpanel.addMouseMotionListener(l);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        this.mouseMotionListenerList.removeElement(l);
        this.vpanel.removeMouseMotionListener(l);
    }

    public Chart getChart() {
        return this.chart;
    }

    class CPopupMenu
    implements IPopupMenu {
        CPopupMenu() {
        }

        @Override
        public final boolean isPopupMenuEnabled() {
            return QbChartBasic.this.chart.isPopupMenuEnabled();
        }

        @Override
        public final void setPopupMenuEnabled(boolean b) {
            QbChartBasic.this.chart.setPopupMenuEnabled(b);
        }

        @Override
        public final boolean isDimMenuEnabled() {
            return QbChartBasic.this.chart.isDimMenuEnabled();
        }

        @Override
        public final void setDimMenuEnabled(boolean b) {
            QbChartBasic.this.chart.setDimMenuEnabled(b);
        }

        @Override
        public final boolean isTypeMenuEnabled() {
            return QbChartBasic.this.chart.isTypeMenuEnabled();
        }

        @Override
        public final void setTypeMenuEnabled(boolean b) {
            QbChartBasic.this.chart.setTypeMenuEnabled(b);
        }
    }

    class CMouseEventSet
    implements IMouseEventSet {
        CMouseEventSet() {
        }

        @Override
        public final boolean isDragEnabled() {
            return QbChartBasic.this.vpanel.isDragEnabled();
        }

        @Override
        public final void setDragEnabled(boolean b) {
            QbChartBasic.this.vpanel.setDragEnabled(b);
        }

        @Override
        public final int getDragModifier() {
            return QbChartBasic.this.vpanel.getDragModifier();
        }

        @Override
        public final void setDragModifier(int m) {
            QbChartBasic.this.vpanel.setDragModifier(m);
        }

        @Override
        public final int getDragClickCount() {
            return QbChartBasic.this.vpanel.getDragClickCount();
        }

        @Override
        public final void setDragClickCount(int c) {
            QbChartBasic.this.vpanel.setDragClickCount(c);
        }

        @Override
        public final boolean isResizeEnabled() {
            return QbChartBasic.this.vpanel.isResizeEnabled();
        }

        @Override
        public final void setResizeEnabled(boolean b) {
            QbChartBasic.this.vpanel.setResizeEnabled(b);
        }

        @Override
        public final int getResizeModifier() {
            return QbChartBasic.this.vpanel.getResizeModifier();
        }

        @Override
        public final void setResizeModifier(int m) {
            QbChartBasic.this.vpanel.setResizeModifier(m);
        }

        @Override
        public final int getResizeClickCount() {
            return QbChartBasic.this.vpanel.getResizeClickCount();
        }

        @Override
        public final void setResizeClickCount(int c) {
            QbChartBasic.this.vpanel.setResizeClickCount(c);
        }

        @Override
        public final boolean isResizeCanvasEnabled() {
            return QbChartBasic.this.vpanel.isResizeCanvasEnabled();
        }

        @Override
        public final void setResizeCanvasEnabled(boolean b) {
            QbChartBasic.this.vpanel.setResizeCanvasEnabled(b);
        }

        @Override
        public final int getResizeCanvasModifier() {
            return QbChartBasic.this.vpanel.getResizeCanvasModifier();
        }

        @Override
        public final void setResizeCanvasModifier(int m) {
            QbChartBasic.this.vpanel.setResizeCanvasModifier(m);
        }

        @Override
        public final int getResizeCanvasClickCount() {
            return QbChartBasic.this.vpanel.getResizeCanvasClickCount();
        }

        @Override
        public final void setResizeCanvasClickCount(int c) {
            QbChartBasic.this.vpanel.setResizeCanvasClickCount(c);
        }

        @Override
        public final boolean isForwardLinkEnabled() {
            return QbChartBasic.this.vpanel.isForwardLinkEnabled();
        }

        @Override
        public final void setForwardLinkEnabled(boolean b) {
            QbChartBasic.this.vpanel.setForwardLinkEnabled(b);
        }

        @Override
        public final int getForwardLinkModifier() {
            return QbChartBasic.this.vpanel.getForwardLinkModifier();
        }

        @Override
        public final void setForwardLinkModifier(int m) {
            QbChartBasic.this.vpanel.setForwardLinkModifier(m);
        }

        @Override
        public final int getForwardLinkClickCount() {
            return QbChartBasic.this.vpanel.getForwardLinkClickCount();
        }

        @Override
        public final void setForwardLinkClickCount(int c) {
            QbChartBasic.this.vpanel.setForwardLinkClickCount(c);
        }

        @Override
        public final int getBackLinkModifier() {
            return QbChartBasic.this.vpanel.getBackLinkModifier();
        }

        @Override
        public final void setBackLinkModifier(int m) {
            QbChartBasic.this.vpanel.setBackLinkModifier(m);
        }

        @Override
        public final boolean isBackLinkEnabled() {
            return QbChartBasic.this.vpanel.isBackLinkEnabled();
        }

        @Override
        public final void setBackLinkEnabled(boolean b) {
            QbChartBasic.this.vpanel.setBackLinkEnabled(b);
        }

        @Override
        public final int getBackLinkClickCount() {
            return QbChartBasic.this.vpanel.getBackLinkClickCount();
        }

        @Override
        public final void setBackLinkClickCount(int c) {
            QbChartBasic.this.vpanel.setBackLinkClickCount(c);
        }

        @Override
        public final boolean areZoomEventsEnabled() {
            return QbChartBasic.this.vpanel.areZoomEventsEnabled();
        }

        @Override
        public final void setZoomEventsEnabled(boolean b) {
            QbChartBasic.this.vpanel.setZoomEventsEnabled(b);
        }

        @Override
        public final int getZoomModifier() {
            return QbChartBasic.this.vpanel.getZoomModifier();
        }

        @Override
        public final void setZoomModifier(int m) {
            QbChartBasic.this.vpanel.setZoomModifier(m);
        }

        @Override
        public final int getZoomClickCount() {
            return QbChartBasic.this.vpanel.getZoomClickCount();
        }

        @Override
        public final void setZoomClickCount(int c) {
            QbChartBasic.this.vpanel.setZoomClickCount(c);
        }

        @Override
        public final int getUndoZoomModifier() {
            return QbChartBasic.this.vpanel.getUndoZoomModifier();
        }

        @Override
        public final void setUndoZoomModifier(int m) {
            QbChartBasic.this.vpanel.setUndoZoomModifier(m);
        }

        @Override
        public final int getUndoZoomClickCount() {
            return QbChartBasic.this.vpanel.getUndoZoomClickCount();
        }

        @Override
        public final void setUndoZoomClickCount(int c) {
            QbChartBasic.this.vpanel.setUndoZoomClickCount(c);
        }
    }

    class CSpreadSheetListener
    implements ISpreadSheetModelListener {
        CSpreadSheetListener() {
        }

        @Override
        public void spreadSheetChanged(SpreadSheetModelEvent e) {
            if (e.getSource() != QbChartBasic.this.spreadSheet) {
                return;
            }
            int row = e.getRow();
            int col = e.getColumn();
            if (row > 0 && col > 0) {
                int rowId = (row - 1) * QbChartBasic.this.spreadSheet.getColumnCount() + col - 1;
                Object[] rec = QbChartBasic.this.chart.getRecord(rowId);
                rec[2] = QbChartBasic.this.spreadSheet.getValueAt(row, col);
                QbChartBasic.this.chart.setRecord(rec, rowId);
            } else {
                QbChartBasic.this.chart = QbChartBasic.this.chart.setNewData(ColData.getColData(QbChartBasic.this.spreadSheet));
            }
            QbChartBasic.this.chart.originalColDataFromMemSource = null;
            QbChartBasic.this.setrepaint(true);
            QbChartBasic.this.repaint();
        }
    }

    class CZoomInfo
    implements IZoomInfo {
        CZoomInfo() {
        }

        @Override
        public final boolean isZoomEnabled() {
            return QbChartBasic.this.chart.isTimeChart();
        }

        @Override
        public final void setZoomEnabled(boolean isZoomEnabled) {
            int categoryType = QbChartBasic.this.chart.getCategoryType();
            if (categoryType != 92 && categoryType != 91 && categoryType != 93) {
                throw new IllegalArgumentException("Zoom can only be done on: time series data");
            }
            QbChartBasic.this.chart.setTimeChart(isZoomEnabled);
            if (isZoomEnabled && (QbChartBasic.this.chart.getChartType() == 9 || QbChartBasic.this.chart.getChartType() == 10)) {
                this.setAggregateOperator(1);
            }
        }

        @Override
        public final int getAggregateOperator() {
            return QbChartBasic.this.chart.getPreprocInfo().aggrOp[0];
        }

        @Override
        public final void setAggregateOperator(int op) {
            if (op < 0 || op >= 11) {
                throw new IllegalArgumentException("Invalid aggregate type:" + op);
            }
            PreprocInfo tsInfo = QbChartBasic.this.chart.getPreprocInfo();
            QbChartBasic.this.chart.getPreprocInfo().aggrOp[0] = op;
            QbChartBasic.this.chart.primaryAggregate = op;
            if (QbChartBasic.this.chart.getChartType() == 9) {
                tsInfo.aggrOp[0] = 1;
                tsInfo.aggrColIndex[0] = QbChartBasic.this.chart.hilowCol.hi + 1;
                tsInfo.aggrOp[2] = 2;
                tsInfo.aggrColIndex[2] = QbChartBasic.this.chart.hilowCol.low + 1;
            } else if (QbChartBasic.this.chart.getChartType() == 10) {
                tsInfo.aggrOp[0] = 1;
                tsInfo.aggrColIndex[0] = QbChartBasic.this.chart.hilowCol.hi + 1;
                tsInfo.aggrOp[2] = 2;
                tsInfo.aggrColIndex[2] = QbChartBasic.this.chart.hilowCol.low + 1;
                tsInfo.aggrOp[3] = 5;
                tsInfo.aggrColIndex[3] = QbChartBasic.this.chart.hilowCol.open + 1;
                tsInfo.aggrOp[4] = 6;
                tsInfo.aggrColIndex[4] = QbChartBasic.this.chart.hilowCol.close + 1;
            }
        }

        @Override
        public final int getSecondaryAggregateOperator() {
            return QbChartBasic.this.chart.getPreprocInfo().aggrOp[1];
        }

        @Override
        public final void setSecondaryAggregateOperator(int op) {
            if (op < 0 || op >= 11) {
                throw new IllegalArgumentException("Invalid aggregate type:" + op);
            }
            QbChartBasic.this.chart.getPreprocInfo().aggrOp[1] = op;
            QbChartBasic.this.chart.secondaryAggregate = op;
        }

        @Override
        public void setLinearScale(boolean isLinear) {
            QbChartBasic.this.chart.getPreprocInfo().isLinear = isLinear;
            if (isLinear) {
                QbChartBasic.this.chart.setFieldOrder(new ColInfo((Chart)QbChartBasic.this.chart).categoryDim, true);
            }
        }

        @Override
        public final boolean isLinearScale() {
            return QbChartBasic.this.chart.getPreprocInfo().isLinear;
        }

        @Override
        public Date getLowerBound() {
            return (Date)QbChartBasic.this.chart.getPreprocInfo().lBound;
        }

        @Override
        public final void setLowerBound(Date lb) {
            Timestamp lt = lb == null || lb instanceof Timestamp ? (Timestamp)lb : new Timestamp(lb.getTime());
            QbChartBasic.this.chart.getPreprocInfo().lBound = lt;
        }

        @Override
        public Date getUpperBound() {
            return (Date)QbChartBasic.this.chart.getPreprocInfo().uBound;
        }

        @Override
        public final void setUpperBound(Date ub) {
            Timestamp ut = ub == null || ub instanceof Timestamp ? (Timestamp)ub : new Timestamp(ub.getTime());
            QbChartBasic.this.chart.getPreprocInfo().uBound = ut;
        }

        @Override
        public final int getScaleUnit() {
            return QbChartBasic.this.chart.getPreprocInfo().unit;
        }

        @Override
        public final int getScaleValue() {
            return QbChartBasic.this.chart.getPreprocInfo().intervalNum.intValue();
        }

        @Override
        public final void setScale(int value, int unit) {
            QbChartBasic.this.chart.getPreprocInfo().unit = unit;
            QbChartBasic.this.chart.getPreprocInfo().intervalNum = value;
        }

        @Override
        public final int getMinScaleUnit() {
            return QbChartBasic.this.chart.getPreprocInfo().lUnit;
        }

        @Override
        public final int getMinScaleValue() {
            return QbChartBasic.this.chart.getPreprocInfo().lInterval;
        }

        @Override
        public final void setMinScale(int value, int unit) {
            QbChartBasic.this.chart.getPreprocInfo().lUnit = unit;
            QbChartBasic.this.chart.getPreprocInfo().lInterval = value;
        }

        @Override
        public final int getMaxScaleUnit() {
            return QbChartBasic.this.chart.getPreprocInfo().uUnit;
        }

        @Override
        public final int getMaxScaleValue() {
            return QbChartBasic.this.chart.getPreprocInfo().uInterval;
        }

        @Override
        public final void setMaxScale(int value, int unit) {
            QbChartBasic.this.chart.getPreprocInfo().uUnit = unit;
            QbChartBasic.this.chart.getPreprocInfo().uInterval = value;
        }
    }

    class CDrillDown
    implements IDrillDown {
        CDrillDown() {
        }

        @Override
        public final void setDrillName(String drillName) {
            QbChartBasic.this.chart.drillTemplateName = drillName;
        }

        @Override
        public final String getDrillName() {
            return QbChartBasic.this.chart.drillTemplateName;
        }

        @Override
        public final void resetDrillDown() throws IOException, SQLException, ClassNotFoundException {
            QbChartBasic.this.vpanel.isDrillDownDefined = false;
            QbChartBasic.this.chart.drillDownVector = null;
            QbChartBasic.this.chart.usedColumns = null;
            QbChartBasic.this.chart.summaryChart = false;
            QbChartBasic.this.chart.drillNumber = 0;
            QbChartBasic.this.chart.valueTable.setDrillHistory(null);
            QbChartBasic.this.chart.setTimeChart(false);
            QbChartBasic.this.chart.isDynamicDrillDown = false;
            QbChartBasic.this.refresh();
        }

        @Override
        public final void setDynamicDrillDown(boolean b) throws IOException, SQLException, ClassNotFoundException {
            if (b) {
                QbChartBasic.this.chart.isDynamicDrillDown = true;
                QbChartBasic.this.chart.summaryChart = true;
                QbChartBasic.this.refresh();
            } else {
                this.resetDrillDown();
            }
        }

        @Override
        public final boolean isPreSetDrillDown() {
            return QbChartBasic.this.chart.drillDownVector != null && QbChartBasic.this.chart.drillDownVector.size() > 0;
        }

        @Override
        public final int countDrillDownLevel() {
            if (QbChartBasic.this.chart.drillDownVector == null) {
                return -1;
            }
            return QbChartBasic.this.chart.drillDownVector.size();
        }

        @Override
        public final boolean isDynamicDrillDown() {
            return QbChartBasic.this.chart.isDynamicDrillDown;
        }

        @Override
        public final void setAggregateOperator(int aggOp) {
            QbChartBasic.this.chart.primaryAggregate = aggOp;
        }

        @Override
        public final int getAggregateOperator() {
            return QbChartBasic.this.chart.primaryAggregate;
        }

        @Override
        public final void setSecondaryAggregateOperator(int aggOp) {
            QbChartBasic.this.chart.secondaryAggregate = aggOp;
        }

        public final int getSecondaryAggregateOperator() {
            return QbChartBasic.this.chart.secondaryAggregate;
        }

        @Override
        public final void addDrillDown(int cType, int categoryIndex, int seriesIndex, int sumbyIndex, boolean isDrill2D) throws IOException, SQLException, ClassNotFoundException {
            int dim = 0;
            if (seriesIndex >= 0) {
                ++dim;
            }
            if (sumbyIndex >= 0) {
                ++dim;
            }
            if (categoryIndex >= 0) {
                ++dim;
            }
            int[] map = new int[dim];
            int i = 0;
            if (seriesIndex >= 0) {
                map[i] = seriesIndex;
                ++i;
            }
            map[i] = categoryIndex;
            ++i;
            if (sumbyIndex >= 0) {
                map[i] = sumbyIndex;
                ++i;
            }
            QbChartBasic.this.chart.addDrillDown(cType, map, dim, isDrill2D);
            QbChartBasic.this.vpanel.isDrillDownDefined = true;
            if (QbChartBasic.this.chart.drillDownVector != null && QbChartBasic.this.chart.drillDownVector.size() == 1) {
                QbChartBasic.this.chart.summaryChart = true;
                QbChartBasic.this.refresh();
            }
        }

        @Override
        public final void insertDrillDownAt(int number, int cType, int categoryIndex, int seriesIndex, int sumbyIndex, boolean isDrill2D) throws IOException, SQLException, ClassNotFoundException {
            int dim = 0;
            if (seriesIndex >= 0) {
                ++dim;
            }
            if (sumbyIndex >= 0) {
                ++dim;
            }
            if (categoryIndex >= 0) {
                ++dim;
            }
            int[] map = new int[dim];
            int i = 0;
            if (seriesIndex >= 0) {
                map[i] = seriesIndex;
                ++i;
            }
            map[i] = categoryIndex;
            ++i;
            if (sumbyIndex >= 0) {
                map[i] = sumbyIndex;
                ++i;
            }
            QbChartBasic.this.chart.insertDrillDownAt(number, cType, map, dim, isDrill2D);
            QbChartBasic.this.vpanel.isDrillDownDefined = true;
            if (QbChartBasic.this.chart.drillDownVector != null && QbChartBasic.this.chart.drillDownVector.size() == 1) {
                QbChartBasic.this.chart.summaryChart = true;
                QbChartBasic.this.refresh();
            }
        }

        @Override
        public final void removeDrillDown(int number) throws IOException, SQLException, ClassNotFoundException {
            QbChartBasic.this.chart.removeDrillDown(number);
            if (QbChartBasic.this.chart.drillDownVector == null || QbChartBasic.this.chart.drillDownVector.size() == 0) {
                this.resetDrillDown();
            }
        }
    }

    class CTable
    implements ITable {
        CTable() {
        }

        @Override
        public final void update() {
        }

        @Override
        public final void setVisible(boolean show) {
            QbChartBasic.this.chart.gt.setVisible(QbChartBasic.this.chart, show);
            QbChartBasic.this.setrepaint(true);
        }

        public final void setColorSymbolsVisible(boolean showColorSymbols) {
            QbChartBasic.this.chart.gt.setShowColorSymbols(showColorSymbols);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean isVisible() {
            return QbChartBasic.this.chart.showTable();
        }

        @Override
        public final void setPosition(Position position) {
            QbChartBasic.this.chart.gt.relX = position.getX();
            QbChartBasic.this.chart.gt.relY = position.getY();
        }

        @Override
        public final void moveTable(int x, int y) {
            QbChartBasic.this.chart.gt.x = x;
            QbChartBasic.this.chart.gt.y = y;
        }

        @Override
        public final void refreshTable() {
        }

        @Override
        public final void setTranspose(boolean isTranspose) {
            boolean isVisible = QbChartBasic.this.chart.showTable();
            boolean isDifferent = this.getTranspose() != isTranspose;
            Point pos = this.getTablePosition();
            if (isVisible && isDifferent) {
                this.setVisible(false);
                QbChartBasic.this.setrepaint(true);
            }
            boolean bl = QbChartBasic.this.chart.gt.isHorizontal = !isTranspose;
            if (isVisible && isDifferent) {
                QbChartBasic.this.chart.gt.clearNoSave();
                this.setVisible(true);
                this.moveTable(pos.x, pos.y);
                QbChartBasic.this.setrepaint(true);
            }
        }

        @Override
        public final boolean getTranspose() {
            if (QbChartBasic.this.chart.showTable()) {
                return !QbChartBasic.this.chart.gt.isHorizontal;
            }
            return false;
        }

        @Override
        public void setSecondaryDataShownInPrimaryTab(boolean b) {
            QbChartBasic.this.chart.setSecondaryDataShownInPrimaryTab(b);
        }

        @Override
        public boolean isSecondaryDataShownInPrimaryTab() {
            return QbChartBasic.this.chart.isSecondaryDataShownInPrimaryTab();
        }

        @Override
        public void setHeaderTitleAlignment(short alignment) {
            QbChartBasic.this.chart.gt.alignCatTitle = alignment;
        }

        @Override
        public short getHeaderTitleAlignment() {
            return QbChartBasic.this.chart.gt.alignCatTitle;
        }

        @Override
        public void setHeaderValueAlignment(short alignment) {
            QbChartBasic.this.chart.gt.alignCatValue = alignment;
        }

        @Override
        public short getHeaderValueAlignment() {
            return QbChartBasic.this.chart.gt.alignCatValue;
        }

        @Override
        public void setContentTitleAlignment(short alignment) {
            QbChartBasic.this.chart.gt.alignPrimTitle = alignment;
        }

        @Override
        public short getContentTitleAlignment() {
            return QbChartBasic.this.chart.gt.alignPrimTitle;
        }

        @Override
        public void setContentValueAlignment(short alignment) {
            QbChartBasic.this.chart.gt.alignPrimValue = alignment;
        }

        @Override
        public short getContentValueAlignment() {
            return QbChartBasic.this.chart.gt.alignPrimValue;
        }

        @Override
        public void setSecondaryTitleAlignment(short alignment) {
            QbChartBasic.this.chart.gt.alignSecTitle = alignment;
        }

        @Override
        public short getSecondaryTitleAlignment() {
            return QbChartBasic.this.chart.gt.alignSecTitle;
        }

        @Override
        public void setSecondaryValueAlignment(short alignment) {
            QbChartBasic.this.chart.gt.alignSecValue = alignment;
        }

        @Override
        public short getSecondaryValueAlignment() {
            return QbChartBasic.this.chart.gt.alignSecValue;
        }

        @Override
        public final void setRelativePosition(int direction) {
            boolean isDifferent;
            boolean isVisible = QbChartBasic.this.chart.showTable();
            boolean bl = isDifferent = this.getRelativePosition() != direction;
            if (isVisible && isDifferent) {
                this.setVisible(false);
                QbChartBasic.this.setrepaint(true);
            }
            QbChartBasic.this.chart.gt.direction = direction;
            if (isVisible && isDifferent) {
                QbChartBasic.this.chart.gt.clearNoSave();
                this.setVisible(true);
                QbChartBasic.this.setrepaint(true);
            }
        }

        @Override
        public final int getRelativePosition() {
            if (QbChartBasic.this.chart.showTable()) {
                return QbChartBasic.this.chart.gt.direction;
            }
            return -1;
        }

        @Override
        public final Point getTablePosition() {
            if (QbChartBasic.this.chart.showTable()) {
                return new Point(QbChartBasic.this.chart.gt.x, QbChartBasic.this.chart.gt.y);
            }
            return new Point(0, 0);
        }

        @Override
        public final int getTableWidth() {
            if (QbChartBasic.this.chart.showTable()) {
                return QbChartBasic.this.chart.gt.getWidth();
            }
            return 0;
        }

        @Override
        public final int getColumnCount() {
            if (!QbChartBasic.this.chart.showTable()) {
                return 0;
            }
            return QbChartBasic.this.chart.gt.cBorder.length;
        }

        @Override
        public final void setTableWidth(int width) {
            if (!QbChartBasic.this.chart.showTable()) {
                return;
            }
            int ct = this.getColumnCount();
            int cWidth = (int)Math.rint((double)width / (double)ct);
            for (int i = 0; i < ct; ++i) {
                this.setColumnWidth(i, cWidth);
            }
        }

        @Override
        public final void setColumnWidth(int columnIndex, int width) {
            if (!QbChartBasic.this.chart.showTable()) {
                return;
            }
            QbChartBasic.this.chart.gt.cBorder[columnIndex] = width;
        }

        @Override
        public final int getColumnWidth(int columnIndex) {
            if (!QbChartBasic.this.chart.showTable()) {
                return -1;
            }
            return QbChartBasic.this.chart.gt.cBorder[columnIndex];
        }

        @Override
        public final int getTableHeight() {
            if (QbChartBasic.this.chart.showTable()) {
                return QbChartBasic.this.chart.gt.getHeight();
            }
            return 0;
        }

        @Override
        public final boolean isTableDrawn() {
            return this.isVisible();
        }

        @Override
        public final void setTableDrawn(boolean drawn) {
            this.setVisible(drawn);
        }

        @Override
        public final boolean hasTabPanel() {
            if (QbChartBasic.this.chart.showTable()) {
                return QbChartBasic.this.chart.gt.tabPanel;
            }
            return false;
        }

        @Override
        public void setHeaderBackgroundColor(Color headerColor) {
            QbChartBasic.this.chart.gt.headColor = headerColor;
        }

        @Override
        public final Color getHeaderBackgroundColor() {
            return QbChartBasic.this.chart.gt.headColor;
        }

        @Override
        public final void setCellBackgroundColor(Color cellColor) {
            QbChartBasic.this.chart.gt.cellColor = cellColor;
        }

        @Override
        public final Color getCellBackgroundColor() {
            return QbChartBasic.this.chart.gt.cellColor;
        }

        @Override
        public void setHeaderTextColor(Color headerTextColor) {
            QbChartBasic.this.chart.gt.headTextColor = headerTextColor;
        }

        @Override
        public final Color getHeaderTextColor() {
            return QbChartBasic.this.chart.gt.headTextColor;
        }

        @Override
        public void setCellTextColor(Color cellTextColor) {
            QbChartBasic.this.chart.gt.cellTextColor = cellTextColor;
        }

        @Override
        public final Color getCellTextColor() {
            return QbChartBasic.this.chart.gt.cellTextColor;
        }

        @Override
        public final void setHeaderFont(Font headerFont) {
            QbChartBasic.this.chart.gt.headFont = headerFont;
            QbChartBasic.this.chart.gt.resizeTableByFontSize();
            QbChartBasic.this.setrepaint(true);
            QbChartBasic.this.repaint();
        }

        @Override
        public final Font getHeaderFont() {
            return QbChartBasic.this.chart.gt.headFont;
        }

        @Override
        public final void setCellFont(Font cellFont) {
            QbChartBasic.this.chart.gt.cellFont = cellFont;
            QbChartBasic.this.chart.gt.resizeTableByFontSize();
            QbChartBasic.this.setrepaint(true);
            QbChartBasic.this.repaint();
        }

        @Override
        public final Font getCellFont() {
            return QbChartBasic.this.chart.gt.cellFont;
        }
    }

    class CAggregationInfo
    implements IAggregationInfo {
        CAggregationInfo() {
        }

        @Override
        public final boolean isAggregatedChart() {
            return QbChartBasic.this.chart.isAggregationChart();
        }

        @Override
        public final void setAggregatedChart(boolean state) {
            QbChartBasic.this.chart.setAggregationChart(state);
        }

        @Override
        public final void setAggregateOperator(int aggOp) {
            QbChartBasic.this.chart.primaryAggregate = aggOp;
        }

        @Override
        public final int getAggregateOperator() {
            return QbChartBasic.this.chart.primaryAggregate;
        }

        @Override
        public final void setSecondaryAggregateOperator(int aggOp) {
            QbChartBasic.this.chart.secondaryAggregate = aggOp;
        }

        @Override
        public final int getSecondaryAggregateOperator() {
            return QbChartBasic.this.chart.secondaryAggregate;
        }
    }

    class CHistogramInfo
    implements IHistogramInfo {
        CHistogramInfo() {
        }

        @Override
        public final boolean isHistogram() {
            return QbChartBasic.this.chart.isHistogram();
        }

        @Override
        public final void setHistogram(boolean histState) {
            int categoryType = QbChartBasic.this.chart.getCategoryType();
            if (categoryType == 92 || categoryType == 91 || categoryType == 93) {
                throw new IllegalArgumentException("Can't set histogram for Time\tDate\tTimestamp");
            }
            QbChartBasic.this.chart.setHistogram(histState);
        }

        public final boolean isShowPercentage() {
            return QbChartBasic.this.chart.isShowPercentage();
        }

        public final void setShowPercentage(boolean showPercentage) {
            QbChartBasic.this.chart.setShowPercentage(showPercentage);
        }

        public final int getBinNumber() {
            return QbChartBasic.this.chart.getBinNumber();
        }

        @Override
        public final boolean isLinearScale() {
            return QbChartBasic.this.chart.getPreprocInfo().isLinear;
        }

        @Override
        public void setLinearScale(boolean isLinear) {
            QbChartBasic.this.chart.getPreprocInfo().isLinear = isLinear;
        }

        @Override
        public final Object getLowerBound() {
            return QbChartBasic.this.chart.getPreprocInfo().lBound;
        }

        @Override
        public void setLowerBound(Object lowerBound) {
            QbChartBasic.this.chart.getPreprocInfo().lBound = lowerBound;
        }

        @Override
        public final Object getUpperBound() {
            return QbChartBasic.this.chart.getPreprocInfo().uBound;
        }

        @Override
        public void setUpperBound(Object upperBound) {
            QbChartBasic.this.chart.getPreprocInfo().uBound = upperBound;
        }

        @Override
        public final boolean isRounded() {
            return QbChartBasic.this.chart.getPreprocInfo().bRounded;
        }

        @Override
        public final void setRounded(boolean rounded) {
            QbChartBasic.this.chart.getPreprocInfo().bRounded = rounded;
        }

        @Override
        public final Number getScale() {
            return QbChartBasic.this.chart.getPreprocInfo().intervalNum;
        }

        @Override
        public final void setScale(Number value) {
            QbChartBasic.this.chart.getPreprocInfo().intervalNum = value;
        }
    }

    class CSecondaryChart
    implements ISecondaryChart {
        CSecondaryChart() {
        }

        @Override
        public final int getCombinationType() {
            return QbChartBasic.this.chart.getComboType();
        }

        @Override
        public final void setCombinationType(int comboType) {
            QbChartBasic.this.chart.setComboType(comboType);
            if (!QbChartBasic.this.chart.is2DimChart()) {
                QbChartBasic.this.setrepaint(true);
            }
        }

        @Override
        public final ILegend gethLegend() {
            return new CLegend(false);
        }

        @Override
        public final IAxis gethAxis() {
            return new CAxis(3, QbChartBasic.this.chart.getSecondaryIndex());
        }

        @Override
        public final int[] getLineStyles() {
            return QbChartBasic.this.chart.getLineStyle2();
        }

        @Override
        public final void setLineStyles(int[] style) {
            QbChartBasic.this.chart.setLineStyle2(style);
            QbChartBasic.this.setrepaint(false);
        }

        @Override
        public final int[] getDataLineThickness() {
            return QbChartBasic.this.chart.getDataLineThickness2();
        }

        @Override
        public final void setDataLineThickness(int[] thickness) {
            QbChartBasic.this.chart.setDataLineThickness2(thickness);
            QbChartBasic.this.setrepaint(false);
        }

        @Override
        public final boolean arePointsVisible() {
            return QbChartBasic.this.chart.getPointState2();
        }

        @Override
        public final void setPointsVisible(boolean b) {
            QbChartBasic.this.chart.setPointState2(b);
        }

        @Override
        public final boolean isPointBorderVisible() {
            return QbChartBasic.this.chart.isDrawPointBorder2();
        }

        @Override
        public final void setPointBorderVisible(boolean b) {
            QbChartBasic.this.chart.setDrawPointBorder2(b);
        }

        @Override
        public final boolean isPointBorderColorBlack() {
            return QbChartBasic.this.chart.getDrawPointBorderColor().getRGB() == Color.black.getRGB();
        }

        @Override
        public final void setPointBorderColorBlack(boolean b) {
            QbChartBasic.this.chart.setDrawPointBorderColor2(b ? Color.black : Color.yellow);
        }

        @Override
        public final void setConnectLinesVisible(boolean b) {
            QbChartBasic.this.chart.setLineState2(b);
        }

        @Override
        public final boolean areConnectLinesVisible() {
            return QbChartBasic.this.chart.getLineState2();
        }

        @Override
        public final boolean isStepLineDrawn() {
            return QbChartBasic.this.chart.getStepLineState2();
        }

        @Override
        public final double getStepLineRatio() {
            return QbChartBasic.this.chart.getStepLineRatio2();
        }

        @Override
        public final void setStepLineRatio(double ratio) {
            QbChartBasic.this.chart.setStepLineRatio2(ratio);
        }

        @Override
        public final void setStepLineDrawn(boolean b) {
            this.setStepLineDrawn(b, 1.0);
        }

        @Override
        public final void setSelectiveStepLineDrawn(boolean[] b) {
            QbChartBasic.this.chart.setSelectiveStepLineState2(b);
        }

        @Override
        public final boolean[] getSelectiveStepLineDrawn() {
            return QbChartBasic.this.chart.getSelectiveStepLineState2();
        }

        @Override
        public final boolean isSelectiveStepLineUsed() {
            return QbChartBasic.this.chart.isSelectiveStepLineUsed2();
        }

        @Override
        public final void setStepLineDrawn(boolean b, double ratio) {
            QbChartBasic.this.chart.setStepLineState2(b);
            QbChartBasic.this.chart.setStepLineRatio2(ratio);
        }

        @Override
        public final void setValueSortOrder(int type) {
            QbChartBasic.this.chart.sortValue = type == 0 ? 3 : 4;
            QbChartBasic.this.chart.setValueOrder(false, type == 0);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final int[] getPointShapes() {
            return QbChartBasic.this.chart.getDataShape2();
        }

        @Override
        public final void setPointShapes(int[] shape) {
            QbChartBasic.this.chart.setDataShape2(shape);
            QbChartBasic.this.setrepaint(false);
        }

        @Override
        public final int[] getPointSizes() {
            return QbChartBasic.this.chart.getDataSize2();
        }

        @Override
        public final void setPointSizes(int[] size) {
            QbChartBasic.this.chart.setDataSize2(size);
            QbChartBasic.this.setrepaint(false);
        }

        @Override
        public final Color[] getColors() {
            return QbChartBasic.this.chart.getDataColor2();
        }

        @Override
        public final void setColors(Color[] color) {
            QbChartBasic.this.chart.setDataColor2(color);
            QbChartBasic.this.chart.clearChartDataSet2();
            QbChartBasic.this.setrepaint(false);
        }

        @Override
        public final IAxisRuler gethAxisRuler() {
            return new CAxisRuler(3);
        }

        @Override
        public final void setSwapAxis(boolean state) {
            QbChartBasic.this.chart.setSwapAxis(state);
        }

        @Override
        public final boolean isSwapAxis() {
            return QbChartBasic.this.chart.isSwapAxis();
        }

        @Override
        public final void setAlignAxisScale(boolean state) {
            QbChartBasic.this.chart.setJoinAxis(state);
        }

        @Override
        public final boolean isAlignAxisScale() {
            return QbChartBasic.this.chart.isJoinAxis();
        }

        @Override
        public final void setUsingPrimaryAxis(boolean state) {
            QbChartBasic.this.chart.setShowDoubleValueForLine(state);
        }

        @Override
        public final boolean isUsingPrimaryAxis() {
            return QbChartBasic.this.chart.isShowDoubleValueForLine();
        }

        @Override
        public void setGradientEnabled(boolean b) {
            QbChartBasic.this.chart.getSecondaryDataGradientSupport().setGradientEnabled(b);
        }

        @Override
        public boolean isGradientEnabled() {
            return QbChartBasic.this.chart.getSecondaryDataGradientSupport().isGradientEnabled();
        }

        @Override
        public void set3DShadingEnabled(boolean b) {
            QbChartBasic.this.chart.getSecondaryDataGradientSupport().set3DShadingEnabled(b);
        }

        @Override
        public boolean is3DShadingEnabled() {
            return QbChartBasic.this.chart.getSecondaryDataGradientSupport().is3DShadingEnabled();
        }

        @Override
        public double getGradientStartX() {
            return QbChartBasic.this.chart.getSecondaryDataGradientSupport().getGradientStartX();
        }

        @Override
        public double getGradientStartY() {
            return QbChartBasic.this.chart.getSecondaryDataGradientSupport().getGradientStartY();
        }

        @Override
        public double getGradientEndX() {
            return QbChartBasic.this.chart.getSecondaryDataGradientSupport().getGradientEndX();
        }

        @Override
        public double getGradientEndY() {
            return QbChartBasic.this.chart.getSecondaryDataGradientSupport().getGradientEndY();
        }

        @Override
        public Color getGradientDesColor() {
            return QbChartBasic.this.chart.getSecondaryDataGradientSupport().getGradientDesColor();
        }

        @Override
        public int getGradientShade() {
            return QbChartBasic.this.chart.getSecondaryDataGradientSupport().getGradientShade();
        }

        @Override
        public boolean isGradientCyclic() {
            return QbChartBasic.this.chart.getSecondaryDataGradientSupport().isGradientCyclic();
        }

        @Override
        public void setGradientStartX(double x) {
            QbChartBasic.this.chart.getSecondaryDataGradientSupport().setGradientStartX(x);
        }

        @Override
        public void setGradientStartY(double y) {
            QbChartBasic.this.chart.getSecondaryDataGradientSupport().setGradientStartY(y);
        }

        @Override
        public void setGradientEndX(double x) {
            QbChartBasic.this.chart.getSecondaryDataGradientSupport().setGradientEndX(x);
        }

        @Override
        public void setGradientEndY(double y) {
            QbChartBasic.this.chart.getSecondaryDataGradientSupport().setGradientEndY(y);
        }

        @Override
        public void setGradientDesColor(Color c) {
            QbChartBasic.this.chart.getSecondaryDataGradientSupport().setGradientDesColor(c);
        }

        @Override
        public void setGradientShade(int s) {
            QbChartBasic.this.chart.getSecondaryDataGradientSupport().setGradientShade(s);
        }

        @Override
        public void setGradientCyclic(boolean c) {
            QbChartBasic.this.chart.getSecondaryDataGradientSupport().setGradientCyclic(c);
        }
    }

    class CDataPointSet
    implements IDataPointSet {
        CDataPointSet() {
        }

        @Override
        public final String[] getOrder(int seriesType) {
            switch (seriesType) {
                case 0: {
                    return QbChartBasic.this.chart.getFieldOrder(new ColInfo((Chart)QbChartBasic.this.chart).categoryDim);
                }
                case 1: {
                    return QbChartBasic.this.chart.getFieldOrder(new ColInfo((Chart)QbChartBasic.this.chart).seriesDim);
                }
                case 2: {
                    return QbChartBasic.this.chart.getFieldOrder(new ColInfo((Chart)QbChartBasic.this.chart).sumByDim);
                }
            }
            throw new IllegalArgumentException("Unsupported map type :" + seriesType);
        }

        @Override
        public final void setOrder(int seriesType, String[] data) {
            switch (seriesType) {
                case 0: {
                    QbChartBasic.this.chart.setDataOrdering(new ColInfo((Chart)QbChartBasic.this.chart).categoryDim, 3);
                    QbChartBasic.this.chart.setFieldOrder(new ColInfo((Chart)QbChartBasic.this.chart).categoryDim, data);
                    break;
                }
                case 1: {
                    QbChartBasic.this.chart.setDataOrdering(new ColInfo((Chart)QbChartBasic.this.chart).seriesDim, 3);
                    QbChartBasic.this.chart.setFieldOrder(new ColInfo((Chart)QbChartBasic.this.chart).seriesDim, data);
                    break;
                }
                case 2: {
                    QbChartBasic.this.chart.setDataOrdering(new ColInfo((Chart)QbChartBasic.this.chart).sumByDim, 3);
                    QbChartBasic.this.chart.setFieldOrder(new ColInfo((Chart)QbChartBasic.this.chart).sumByDim, data);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid series type :" + seriesType);
                }
            }
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final void reverseOrder(int seriesType) {
            String[] origArr = this.getOrder(seriesType);
            String[] replArr = new String[origArr.length];
            for (int i = 0; i < origArr.length; ++i) {
                replArr[i] = origArr[origArr.length - 1 - i];
            }
            this.setOrder(seriesType, replArr);
            if (QbChartBasic.this.chart.legend.getReverse()) {
                QbChartBasic.this.chart.legend.setReverse(false);
            } else {
                QbChartBasic.this.chart.legend.setReverse(true);
            }
        }

        @Override
        public final int getSortOrder(int seriesType) {
            int dataDim = -1;
            switch (seriesType) {
                case 0: {
                    dataDim = new ColInfo((Chart)QbChartBasic.this.chart).categoryDim;
                    break;
                }
                case 1: {
                    dataDim = new ColInfo((Chart)QbChartBasic.this.chart).seriesDim;
                    break;
                }
                case 2: {
                    dataDim = new ColInfo((Chart)QbChartBasic.this.chart).sumByDim;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid series type :" + seriesType);
                }
            }
            int val = QbChartBasic.this.chart.getDataOrdering(dataDim);
            switch (val) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 0: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            throw new IllegalArgumentException("Invalid data ordering value!");
        }

        @Override
        public final void setSortOrder(int seriesType, int type) {
            int dataDim = -1;
            switch (seriesType) {
                case 0: {
                    dataDim = new ColInfo((Chart)QbChartBasic.this.chart).categoryDim;
                    break;
                }
                case 1: {
                    dataDim = new ColInfo((Chart)QbChartBasic.this.chart).seriesDim;
                    break;
                }
                case 2: {
                    dataDim = new ColInfo((Chart)QbChartBasic.this.chart).sumByDim;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid series type :" + seriesType);
                }
            }
            switch (type) {
                case 0: {
                    QbChartBasic.this.chart.setDataOrdering(dataDim, 1);
                    QbChartBasic.this.chart.setFieldOrder(dataDim, true);
                    break;
                }
                case 1: {
                    QbChartBasic.this.chart.setDataOrdering(dataDim, 2);
                    QbChartBasic.this.chart.setFieldOrder(dataDim, false);
                    break;
                }
                case 2: {
                    QbChartBasic.this.chart.setDataOrdering(dataDim, 0);
                    if (dataDim == -1) break;
                    QbChartBasic.this.chart.setFieldOrder(dataDim, QbChartBasic.this.chart.colData[dataDim].getOriginalFieldName());
                    break;
                }
                case 3: {
                    QbChartBasic.this.chart.setDataOrdering(new ColInfo((Chart)QbChartBasic.this.chart).sumByDim, 3);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid order type :" + type);
                }
            }
        }

        @Override
        public final void setSortByOriginalOrder(int seriesType) {
            int dim = -1;
            switch (seriesType) {
                case 0: {
                    dim = new ColInfo((Chart)QbChartBasic.this.chart).categoryDim;
                    break;
                }
                case 1: {
                    dim = new ColInfo((Chart)QbChartBasic.this.chart).seriesDim;
                    break;
                }
                case 2: {
                    dim = new ColInfo((Chart)QbChartBasic.this.chart).sumByDim;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid series type :" + seriesType);
                }
            }
            QbChartBasic.this.chart.setDataOrdering(dim, 0);
            QbChartBasic.this.chart.setFieldOrder(dim, QbChartBasic.this.chart.colData[dim].getOriginalFieldName());
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final void setValueSortOrder(int type) {
            QbChartBasic.this.chart.sortValue = type == 0 ? 1 : (type == 1 ? 2 : 0);
            if (QbChartBasic.this.chart.sortValue != 0) {
                QbChartBasic.this.chart.setValueOrder(true, type == 0);
                QbChartBasic.this.setrepaint(true);
            } else {
                int dim = new ColInfo((Chart)QbChartBasic.this.chart).categoryDim;
                if (dim >= 0) {
                    try {
                        QbChartBasic.this.chart.setDataOrdering(dim, 0);
                        QbChartBasic.this.chart.setFieldOrder(dim, QbChartBasic.this.chart.colData[dim].getOriginalFieldName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((dim = new ColInfo((Chart)QbChartBasic.this.chart).seriesDim) >= 0) {
                    try {
                        QbChartBasic.this.chart.setDataOrdering(dim, 0);
                        QbChartBasic.this.chart.setFieldOrder(dim, QbChartBasic.this.chart.colData[dim].getOriginalFieldName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((dim = new ColInfo((Chart)QbChartBasic.this.chart).sumByDim) >= 0) {
                    try {
                        QbChartBasic.this.chart.setDataOrdering(dim, 0);
                        QbChartBasic.this.chart.setFieldOrder(dim, QbChartBasic.this.chart.colData[dim].getOriginalFieldName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                QbChartBasic.this.setrepaint(true);
            }
        }

        @Override
        public final int getValueSortOrder() {
            if (QbChartBasic.this.chart.sortValue == 1) {
                return 0;
            }
            if (QbChartBasic.this.chart.sortValue == 2) {
                return 1;
            }
            return 2;
        }

        @Override
        public final void setSortSeriesByValue(boolean state) {
            if (state) {
                QbChartBasic.this.chart.sortSeriesByValue();
                QbChartBasic.this.setrepaint(true);
            }
        }

        @Override
        public final void setTopNValue(boolean enable, int b) throws Exception {
            if (QbChartBasic.this.chart.dataDim != 1) {
                throw new Exception("This feature only works with chart with category only.");
            }
            if (this.getValueSortOrder() == 0 || this.getSortOrder(0) == 0) {
                if (enable) {
                    QbChartBasic.this.chart.setMaxNumberOfCategories(b);
                } else {
                    QbChartBasic.this.chart.setMaxNumberOfCategories(-1);
                }
            } else {
                throw new Exception("This feature only works with ascending data chart");
            }
        }

        @Override
        public final void setBottomNValue(boolean enable, int b) throws Exception {
            if (QbChartBasic.this.chart.dataDim != 1) {
                throw new Exception("This feature only works with chart with category only.");
            }
            if (this.getValueSortOrder() == 1 || this.getSortOrder(0) == 1) {
                if (enable) {
                    QbChartBasic.this.chart.setMaxNumberOfCategories(b);
                } else {
                    QbChartBasic.this.chart.setMaxNumberOfCategories(-1);
                }
            } else {
                throw new Exception("This feature only works with decending data chart");
            }
        }

        @Override
        public final int getTopNValue() {
            if (QbChartBasic.this.chart.dataDim != 1) {
                return -1;
            }
            if (this.getValueSortOrder() == 0 || this.getSortOrder(0) == 0) {
                return QbChartBasic.this.chart.maxDataLen;
            }
            return -1;
        }

        @Override
        public final int getBottomNValue() {
            if (QbChartBasic.this.chart.dataDim != 1) {
                return -1;
            }
            if (this.getValueSortOrder() == 1 || this.getSortOrder(0) == 1) {
                return QbChartBasic.this.chart.maxDataLen;
            }
            return -1;
        }

        @Override
        public final ILabel gethLabel() {
            return new CDataTopLabel();
        }

        @Override
        public final Color getTopLabelColorOnNegativeSide() {
            return QbChartBasic.this.chart.getTopValueColorOnNegativeSide();
        }

        @Override
        public final void setTopLabelColorOnNegativeSide(Color c) {
            QbChartBasic.this.chart.setTopValueColorOnNegativeSide(c);
        }

        @Override
        public final int getTopLabelAlignment() {
            return QbChartBasic.this.chart.topLabel_Alignment;
        }

        @Override
        public final void setTopLabelAlignment(int align) {
            QbChartBasic.this.chart.topLabel_Alignment = align;
        }

        @Override
        public final int getStackLabelAlignment() {
            return QbChartBasic.this.chart.stackLabel_Alignment;
        }

        @Override
        public final void setStackLabelAlignment(int align) {
            QbChartBasic.this.chart.stackLabel_Alignment = align;
        }

        @Override
        public final ILabel gethSecondaryLabel() {
            return new CDataTopLabel2();
        }

        @Override
        public final void setStackSectionLabelVisible(boolean b) {
            QbChartBasic.this.chart.setStackLabelState(b);
        }

        @Override
        public final boolean isStackSectionLabelVisible() {
            return QbChartBasic.this.chart.getStackLabelState();
        }

        @Override
        public final void setStackSectionTotalLabelVisible(boolean b) {
            QbChartBasic.this.chart.setStackTotalLabelState(b);
        }

        @Override
        public final boolean isStackSectionTotalLabelVisible() {
            return QbChartBasic.this.chart.getStackTotalLabelState();
        }

        @Override
        public void setDataLabelInfo(IDataLabelInfo data) {
            QbChartBasic.this.chart.setPrimaryDataLabelInfo(data);
        }

        @Override
        public void setSecondaryDataLabelInfo(IDataLabelInfo data) {
            QbChartBasic.this.chart.setSecondaryDataLabelInfo(data);
        }

        @Override
        public boolean isLabelOnPositiveSide() {
            return QbChartBasic.this.chart.isLabelOnPositiveSide();
        }

        @Override
        public void setLabelOnPositiveSide(boolean state) {
            QbChartBasic.this.chart.setLabelOnPositiveSide(state);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public boolean isLabelOnNegativeSide() {
            return QbChartBasic.this.chart.isLabelOnNegativeSide();
        }

        @Override
        public void setLabelOnNegativeSide(boolean state) {
            QbChartBasic.this.chart.setLabelOnNegativeSide(state);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public boolean isShowSeriesInTopLabel() {
            return QbChartBasic.this.chart.isShowSeriesInTopLabel();
        }

        @Override
        public void showSeriesInTopLabel(boolean b) {
            QbChartBasic.this.chart.showSeriesInTopLabel(b);
        }

        @Override
        public boolean isJava2DRotateTextEnabled() {
            return QbChartBasic.this.chart.isJ2DRotateEnabled();
        }

        @Override
        public void setJava2DRotateTextEnabled(boolean b) {
            QbChartBasic.this.chart.setJ2DRotateEnabled(b);
        }

        @Override
        public int getMaxDisplayCharactersForText() {
            return QbChartBasic.this.chart.getCutOffThresholdForText();
        }

        @Override
        public void setMaxDisplayCharactersForText(int b) {
            QbChartBasic.this.chart.setCutOffThresholdForText(b);
        }

        @Override
        public boolean isDisableJava2DForStraightText() {
            return QbChartBasic.this.chart.isDisableJava2DForStraightText();
        }

        @Override
        public void setDisableJava2DForStraightText(boolean b) {
            QbChartBasic.this.chart.setDisableJava2DForStraightText(b);
        }

        @Override
        public boolean isUniqueColumnColorForColumnChart() {
            return QbChartBasic.this.chart.isUniqueColorForCol();
        }

        @Override
        public void setUniqueColumnColorForColumnChart(boolean b) {
            QbChartBasic.this.chart.setUniqueColorForCol(b);
            this.setSingleColorForCategories(!b);
        }

        @Override
        public void setUniqueBarColorForBarChart(boolean b) {
            QbChartBasic.this.chart.setUniqueColorForCol(b);
            this.setSingleColorForCategories(!b);
        }

        @Override
        public final Color[] getColors() {
            return QbChartBasic.this.chart.getDataColor();
        }

        @Override
        public final void setColors(Color[] color) {
            this.setColors(color, color[0]);
        }

        @Override
        public final void setColors(Color[] color, Color rootColor) {
            QbChartBasic.this.chart.setDataColor(color, rootColor);
            QbChartBasic.this.chart.clearChartDataSet();
            QbChartBasic.this.setrepaint(false);
        }

        @Override
        public boolean isSingleColorForCategories() {
            return QbChartBasic.this.chart.isSingleColorForCategories();
        }

        @Override
        public void setSingleColorForCategories(boolean b) {
            QbChartBasic.this.chart.setSingleColorForCategories(b);
        }

        @Override
        public boolean isSaveColorsForCategories() {
            return QbChartBasic.this.chart.isSaveColorsForCategories();
        }

        @Override
        public void setSaveColorsForCategories(boolean b) {
            QbChartBasic.this.chart.setSaveColorsForCategories(b);
        }

        @Override
        public final IHint gethHint() {
            return new CDataHint();
        }

        @Override
        public String getReplacedText(String originalText) {
            return QbChartBasic.this.chart.valueTable.findUniqueKeyValue(originalText);
        }

        @Override
        public final void replace(String originalText, String replacedText) {
            QbChartBasic.this.chart.valueTable.addUniqueKeyValue(originalText, replacedText);
        }

        @Override
        public Enumeration<String> getOriginalTextList() {
            return QbChartBasic.this.chart.valueTable.getUniqueKeyList();
        }

        @Override
        public Enumeration<String> getReplacedTextList() {
            return QbChartBasic.this.chart.valueTable.getUniqueElementList();
        }

        @Override
        public final float getBarGapToWidthRatio() {
            return (float)QbChartBasic.this.chart.getBarwidthRatio();
        }

        @Override
        public final void setBarGapToWidthRatio(float x) {
            QbChartBasic.this.chart.setBarwidthRatio(x);
        }

        @Override
        public final float getMaxBarWidthRatioToPlotArea() {
            return (float)QbChartBasic.this.chart.getMaxBarWidthRatioToPlotArea();
        }

        @Override
        public final void setMaxBarWidthRatioToPlotArea(float x) {
            QbChartBasic.this.chart.setMaxBarWidthRatioToPlotArea(x);
        }

        @Override
        public final boolean isEndToEnd() {
            return !QbChartBasic.this.chart.showOffsetTicker();
        }

        @Override
        public final void setEndToEnd(boolean b) {
            QbChartBasic.this.chart.setOffsetTicker(!b);
        }

        @Override
        public final boolean isBorderVisible() {
            return QbChartBasic.this.chart.getDataBorder();
        }

        @Override
        public final void setBorderVisible(boolean b) {
            QbChartBasic.this.chart.setDataBorder(b);
            if (QbChartBasic.this.vpanel3d != null && QbChartBasic.this.vpanel3d.getControlPanel() != null) {
                QbChartBasic.this.vpanel3d.getControlPanel().setDrawMode();
            }
        }

        @Override
        public final boolean isBlackBorderVisibleForWhiteArea() {
            return QbChartBasic.this.chart.isDrawBorderForWhiteArea();
        }

        @Override
        public final void setBlackBorderVisibleForWhiteArea(boolean b) {
            QbChartBasic.this.chart.setDrawBorderForWhiteArea(b);
        }

        @Override
        public int getDataBorderThickness() {
            return QbChartBasic.this.chart.getDataBorderThickness();
        }

        @Override
        public void setDataBorderThickness(int i) {
            QbChartBasic.this.chart.setDataBorderThickness(i);
        }

        @Override
        public Color getDataBorderColor() {
            return QbChartBasic.this.chart.getDataBorderColor();
        }

        @Override
        public void setDataBorderColor(Color c) {
            QbChartBasic.this.chart.setDataBorderColor(c);
        }

        @Override
        public final boolean areConnectLinesVisible() {
            return QbChartBasic.this.chart.getLineState();
        }

        @Override
        public final void setConnectLinesVisible(boolean b) {
            QbChartBasic.this.chart.setLineState(b);
        }

        @Override
        public final boolean isShowShadowOnLine() {
            return QbChartBasic.this.chart.isShowShadowOnLine();
        }

        @Override
        public final void setShowShadowOnLine(boolean b) {
            QbChartBasic.this.chart.setShowShadowOnLine(b);
        }

        @Override
        public final boolean isShowShadowOnPoint() {
            return QbChartBasic.this.chart.isShowShadowOnPoint();
        }

        @Override
        public final void setShowShadowOnPoint(boolean b) {
            QbChartBasic.this.chart.setShowShadowOnPoint(b);
        }

        @Override
        public final int getLineThickness() {
            return QbChartBasic.this.chart.getDataLineThickness()[0];
        }

        @Override
        public final void setLineThickness(int thickness) {
            QbChartBasic.this.chart.setDataLineThickness(thickness);
        }

        @Override
        public final int getLineXOffset() {
            return QbChartBasic.this.chart.get_xshift();
        }

        @Override
        public final void setLineXOffset(int offset) {
            QbChartBasic.this.chart.set_xshift(offset);
        }

        @Override
        public final boolean isDottedLineForNull() {
            return QbChartBasic.this.chart.getNullDataLine();
        }

        @Override
        public final void setDottedLineForNull(boolean b) {
            QbChartBasic.this.chart.setNullDataLine(b);
            QbChartBasic.this.chart.applyLineStyleToNullData(false);
        }

        @Override
        public final void setDataLineForNull(boolean b, boolean drawDottedLine) {
            QbChartBasic.this.chart.setNullDataLine(b);
            QbChartBasic.this.chart.applyLineStyleToNullData(!drawDottedLine);
        }

        @Override
        public final boolean isShowNullInScatter() {
            return QbChartBasic.this.chart.isShowNullInScatter();
        }

        @Override
        public final void setShowNullInScatter(boolean b) {
            QbChartBasic.this.chart.setShowNullInScatter(b);
        }

        @Override
        public final boolean isZeroAsNullData() {
            return QbChartBasic.this.chart.isZeroAsNullData();
        }

        @Override
        public final void setZeroAsNullData(boolean b) {
            QbChartBasic.this.chart.setZeroAsNullData(b);
        }

        @Override
        public final boolean isNullDataAsZero() {
            return QbChartBasic.this.chart.isNullDataAsZero();
        }

        @Override
        public final void setNullDataAsZero(boolean b) {
            QbChartBasic.this.chart.setNullDataAsZero(b);
        }

        @Override
        public final boolean isDrawNullColumn() {
            return QbChartBasic.this.chart.isDrawNullColumn();
        }

        @Override
        public final void setDrawNullColumn(boolean b) {
            QbChartBasic.this.chart.setDrawNullColumn(b);
        }

        @Override
        public final String getNullColumnName() {
            return QbChartBasic.this.chart.getNullColumnName();
        }

        @Override
        public final void setNullColumnName(String str) {
            QbChartBasic.this.chart.setNullColumnName(str);
        }

        @Override
        public final boolean isAreaVisible() {
            return QbChartBasic.this.chart.getAreaState();
        }

        @Override
        public final void setAreaVisible(boolean b) {
            QbChartBasic.this.chart.setAreaState(b);
        }

        @Override
        public final boolean arePointsVisible() {
            return QbChartBasic.this.chart.getPointState();
        }

        @Override
        public final void setPointsVisible(boolean b) {
            QbChartBasic.this.chart.setPointState(b);
        }

        @Override
        public final boolean arePointsUniformForLine() {
            return QbChartBasic.this.chart.isSyncPointColorForLine();
        }

        @Override
        public final void setPointsUniformForLine(boolean b) {
            QbChartBasic.this.chart.setSyncPointColorForLine(b);
        }

        @Override
        public final boolean isPointBorderVisible() {
            return QbChartBasic.this.chart.isDrawPointBorder();
        }

        @Override
        public final void setPointBorderVisible(boolean b) {
            QbChartBasic.this.chart.setDrawPointBorder(b);
        }

        @Override
        public final boolean isPointBorderColorBlack() {
            return QbChartBasic.this.chart.getDrawPointBorderColor().getRGB() == Color.black.getRGB();
        }

        @Override
        public final void setPointBorderColorBlack(boolean b) {
            QbChartBasic.this.chart.setDrawPointBorderColor(b ? Color.black : Color.yellow);
        }

        @Override
        public final int[] getPointsShapes() {
            return QbChartBasic.this.chart.getDataPtShapes();
        }

        @Override
        public final void setPointsShapes(int[] shapes) {
            QbChartBasic.this.chart.setDataPtShapes(shapes);
            QbChartBasic.this.setrepaint(false);
        }

        @Override
        public final int[] getPointShapes() {
            return QbChartBasic.this.chart.getDataShape();
        }

        @Override
        public final void setPointShapes(int[] shapes) {
            QbChartBasic.this.chart.setDataShape(shapes);
            QbChartBasic.this.setrepaint(false);
        }

        @Override
        public final int[] getPointSizes() {
            return QbChartBasic.this.chart.getDataSize();
        }

        @Override
        public final void setPointSizes(int[] size) {
            QbChartBasic.this.chart.setDataSize(size);
            QbChartBasic.this.setrepaint(false);
        }

        @Override
        public final int[] getLineStyles() {
            return QbChartBasic.this.chart.getLineStyle();
        }

        @Override
        public final void setLineStyles(int[] style) {
            QbChartBasic.this.chart.setLineStyle(style);
            QbChartBasic.this.setrepaint(false);
        }

        @Override
        public final int[] getDataLineThickness() {
            return QbChartBasic.this.chart.getDataLineThickness();
        }

        @Override
        public final void setDataLineThickness(int[] thickness) {
            QbChartBasic.this.chart.setDataLineThickness(thickness);
            QbChartBasic.this.setrepaint(false);
        }

        @Override
        public final boolean[] areHidden(int colIndex) {
            return QbChartBasic.this.chart.getHideDataItems(colIndex);
        }

        @Override
        public final void setHidden(int colIndex, boolean[] b) {
            QbChartBasic.this.chart.setHideDataItems(colIndex, b);
        }

        @Override
        public final int getGridStep(int colIndex) {
            return this.getTickerStep(colIndex);
        }

        @Override
        public final void setGridStep(int colIndex, int stepSize) {
            this.setTickerStep(colIndex, stepSize);
        }

        @Override
        public final int getTickerStep(int colIndex) {
            return QbChartBasic.this.chart.getTickerStepSize(colIndex);
        }

        @Override
        public final void setTickerStep(int colIndex, int stepSize) {
            QbChartBasic.this.chart.setTickerStepSize(colIndex, stepSize);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public IFormat getLabelFormat(int colIndex) {
            return QbChartBasic.this.chart.getLabelFormat(colIndex);
        }

        @Override
        public final void setLabelFormat(int colIndex, IFormat format) {
            QbChartBasic.this.chart.setLabelFormat(colIndex, format);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final int getLabelUnit(int colIndex) {
            return QbChartBasic.this.chart.colData[colIndex].sepUnit;
        }

        @Override
        public final int getLabelStep(int colIndex) {
            return QbChartBasic.this.chart.getLabelStepSize(colIndex);
        }

        @Override
        public final void setLabelStep(int colIndex, int size) {
            QbChartBasic.this.chart.setLabelStepSize(colIndex, size);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final int getMaxLabelAndTickerCount(int colIndex) {
            return QbChartBasic.this.chart.getMaxLabelAndTickerCount(colIndex);
        }

        @Override
        public final void setMaxLabelAndTickerCount(int colIndex, int size) {
            QbChartBasic.this.chart.setMaxLabelAndTickerCount(colIndex, size);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final void setLabelStep(int colIndex, int size, int unit, boolean isAscending, Date startingDate) {
            QbChartBasic.this.chart.setLabelStepSize(colIndex, size);
            int type = QbChartBasic.this.chart.colData[colIndex].getOriginalDataType();
            if (type == 92 || type == 91 || type == 93) {
                QbChartBasic.this.chart.setLabelStepSize(colIndex, size);
                QbChartBasic.this.chart.setLabelStepUnit(colIndex, unit);
                QbChartBasic.this.chart.setLabelOrdering(colIndex, isAscending);
                QbChartBasic.this.chart.setLabelStartingDate(colIndex, isAscending, startingDate);
            }
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final void setLimitAtAxisScale(boolean b) {
            QbChartBasic.this.chart.setDataLimitAtAxisScale(b);
        }

        @Override
        public final boolean isLimitAtAxisScale() {
            return QbChartBasic.this.chart.isDataLimitAtAxisScale();
        }

        @Override
        public final boolean isTranslucent() {
            return QbChartBasic.this.chart.isTranslucent();
        }

        @Override
        public final void setTranslucent(boolean b) {
            QbChartBasic.this.chart.setTranslucent(b);
        }

        @Override
        public final float getTranslucentValue() {
            return QbChartBasic.this.chart.getTranslucentValue();
        }

        @Override
        public final void setTranslucentValue(float f) {
            QbChartBasic.this.chart.setTranslucentValue(f);
        }

        @Override
        public final void setPositionFromOrigin(float midPoint) {
            QbChartBasic.this.chart.setPositionFromOrigin(midPoint);
        }

        @Override
        public final void setCandleStickWidth(float cWidth) {
            cWidth = cWidth > 1.0f ? 1.0f : cWidth;
            cWidth = cWidth < 0.1f ? 0.1f : cWidth;
            QbChartBasic.this.chart.setCandleWidth(cWidth);
        }

        @Override
        public final float getCandleStickWidth() {
            return QbChartBasic.this.chart.getCandleWidth();
        }

        @Override
        public final void setCandleStickColors(Color upTickColor, Color downTickColor) {
            QbChartBasic.this.chart.setCandleColors(upTickColor, downTickColor);
        }

        @Override
        public final Color getCandleStickUpColor() {
            return QbChartBasic.this.chart.getCandleUpColor();
        }

        @Override
        public final Color getCandleStickDownColor() {
            return QbChartBasic.this.chart.getCandleDownColor();
        }

        @Override
        public final void setXAxisDrawnAtTop(boolean bTop) {
            QbChartBasic.this.chart.setXAxisAtTop(bTop);
        }

        @Override
        public final boolean isXAxisDrawnAtTop() {
            return QbChartBasic.this.chart.isXAxisAtTop();
        }

        @Override
        public final void setConnectLinesInOriginalOrder(boolean origOrder) {
            QbChartBasic.this.chart.setLineInOriginalOrder(origOrder);
        }

        @Override
        public final boolean isConnectLinesInOriginalOrder() {
            return QbChartBasic.this.chart.isLineInOriginalOrder();
        }

        @Override
        public final void setMaxYCutOffPointForScatter(Double d) {
            QbChartBasic.this.chart.setAreaCutOffPoint(d);
        }

        @Override
        public final Double getMaxYCutOffPointForScatter() {
            return QbChartBasic.this.chart.getAreaCutOffPoint();
        }

        @Override
        public final void setColorSeparators(Color[] color, Object[] value, int type) {
            if (value == null || color == null) {
                return;
            }
            int count = value.length;
            if (color.length <= count) {
                count = color.length - 1;
            }
            if (type == 0) {
                QbChartBasic.this.chart.setDataOrdering(0, 1);
            } else {
                QbChartBasic.this.chart.setDataOrdering(0, 2);
            }
            try {
                QbChartBasic.this.refresh();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Object[] fieldName = QbChartBasic.this.chart.colData[QbChartBasic.this.chart.mDataMap[0]].getFieldName();
            Color[] newColor = new Color[fieldName.length];
            for (int i = 0; i < fieldName.length; ++i) {
                for (int j = 0; j < count; ++j) {
                    ICompareObject f;
                    ICompareObject v;
                    if (fieldName[i] instanceof Number && value[j] instanceof Number) {
                        v = new NumberCompare((Number)value[j]);
                        if (((NumberCompare)v).greaterThan(type == 0, f = new NumberCompare((Number)fieldName[i]))) {
                            newColor[i] = color[j];
                            break;
                        }
                    } else if (fieldName[i] instanceof Date && value[j] instanceof Date && ((DateCompare)(v = new DateCompare((Date)value[j]))).greaterThan(type == 0, f = new DateCompare((Date)fieldName[i]))) {
                        newColor[i] = color[j];
                        break;
                    }
                    if (fieldName[i] instanceof String && value[j] instanceof String && ((StringCompare)(v = new StringCompare((String)value[j]))).greaterThan(type == 0, f = new StringCompare((String)fieldName[i]))) {
                        newColor[i] = color[j];
                        break;
                    }
                    if (!(fieldName[i] instanceof Boolean) || !(value[j] instanceof Boolean) || !((BooleanCompare)(v = new BooleanCompare((Boolean)value[j]))).greaterThan(type == 0, f = new BooleanCompare((Boolean)fieldName[i]))) continue;
                    newColor[i] = color[j];
                    break;
                }
                if (newColor[i] != null) continue;
                newColor[i] = color[count];
            }
            this.setColors(newColor);
        }
    }

    class CDialPropertySet
    implements IDialPropertySet {
        CDialPropertySet() {
        }

        @Override
        public int getNeedleCount() {
            return QbChartBasic.this.chart.getHandLength() != null ? QbChartBasic.this.chart.getHandLength().length : 0;
        }

        @Override
        public final double getNeedleLength(int i) {
            if (QbChartBasic.this.chart.getHandLength() == null || i >= QbChartBasic.this.chart.getHandLength().length) {
                return -1.0;
            }
            return QbChartBasic.this.chart.getHandLength()[i];
        }

        @Override
        public final void setNeedleLength(int i, double len) {
            double[] handLength = QbChartBasic.this.chart.getHandLength();
            if (handLength == null || i >= handLength.length) {
                return;
            }
            handLength[i] = len;
            QbChartBasic.this.chart.setHandLength(handLength);
        }

        @Override
        public final double getCenterPointRadius() {
            return QbChartBasic.this.chart.getRadiusForInternalDial();
        }

        @Override
        public final void setCenterPointRadius(double r) {
            QbChartBasic.this.chart.setRadiusForInternalDial(r);
        }

        @Override
        public final Color getCenterPointColor() {
            return QbChartBasic.this.chart.getCenterColorForDial();
        }

        @Override
        public final void setCenterPointColor(Color c) {
            QbChartBasic.this.chart.setCenterColorForDial(c);
        }

        @Override
        public final double getStartAngle() {
            return QbChartBasic.this.chart.getStartAngleForDial();
        }

        @Override
        public final void setStartAngle(double angle) {
            QbChartBasic.this.chart.setStartAngleForDial(angle);
        }

        @Override
        public final double getEndAngle() {
            return QbChartBasic.this.chart.getEndAngleForDial();
        }

        @Override
        public final void setEndAngle(double angle) {
            QbChartBasic.this.chart.setEndAngleForDial(angle);
        }

        @Override
        public final Dimension getLabelOffset(int index) {
            return QbChartBasic.this.chart.getLabelOffset(index);
        }

        @Override
        public final void setLabelOffset(int index, Dimension dim) {
            QbChartBasic.this.chart.setLabelOffset(index, dim);
        }

        @Override
        public final void setLabelOffset(Dimension[] dim) {
            QbChartBasic.this.chart.setLabelOffset(dim);
        }

        @Override
        public final int countLabelOffset() {
            return QbChartBasic.this.chart.countLabelOffset();
        }

        @Override
        public int getHandCount() {
            return this.getNeedleCount();
        }

        @Override
        public final double getHandLength(int i) {
            return this.getNeedleLength(i);
        }

        @Override
        public final void setHandLength(int i, double len) {
            this.setNeedleLength(i, len);
        }

        @Override
        public final boolean isDrawFullCircle() {
            return QbChartBasic.this.chart.isDrawFullCircleForDial();
        }

        @Override
        public final void setDrawFullCircle(boolean b) {
            QbChartBasic.this.chart.setDrawFullCircleForDial(b);
        }

        @Override
        public int getSubTickerLength() {
            return QbChartBasic.this.chart.getSubTickerLength();
        }

        @Override
        public void setSubTickerLength(int t) {
            QbChartBasic.this.chart.setSubTickerLength(t);
        }

        @Override
        public int getTickerLength() {
            return QbChartBasic.this.chart.getTickerLength();
        }

        @Override
        public void setTickerLength(int t) {
            QbChartBasic.this.chart.setTickerLength(t);
        }

        @Override
        public boolean is3DShadowForTickerOn() {
            return QbChartBasic.this.chart.is3DShadowForTickerOn();
        }

        @Override
        public void set3DShadowForTickerOn(boolean b) {
            QbChartBasic.this.chart.set3DShadowForTickerOn(b);
        }

        @Override
        public int getSubTickerCount() {
            return QbChartBasic.this.chart.getSubTickerCount();
        }

        @Override
        public void setSubTickerCount(int ct) {
            QbChartBasic.this.chart.setSubTickerCount(ct);
        }

        @Override
        public int getSubTickerThickness() {
            return QbChartBasic.this.chart.getSubTickerThickness();
        }

        @Override
        public void setSubTickerThickness(int t) {
            QbChartBasic.this.chart.setSubTickerThickness(t);
        }

        @Override
        public boolean isPointerUsed() {
            return QbChartBasic.this.chart.isPointerUsed();
        }

        @Override
        public void setPointerUsed(boolean b) {
            QbChartBasic.this.chart.setPointerUsed(b);
        }

        @Override
        public int getNeedleStyle() {
            return QbChartBasic.this.chart.getNeedleOption();
        }

        @Override
        public void setNeedleStyle(int style) {
            QbChartBasic.this.chart.setNeedleOption(style);
        }
    }

    class CPolarPropertySet
    implements IPolarPropertySet {
        CPolarPropertySet() {
        }

        @Override
        public int getSectorCount() {
            return QbChartBasic.this.chart.getNoSectionForPolar();
        }

        @Override
        public void setSectorCount(int ct) {
            QbChartBasic.this.chart.setNoSectionForPolar(ct);
        }

        @Override
        public double getStartAngle() {
            double val = QbChartBasic.this.chart.getStartAngleForPolar();
            if (QbChartBasic.this.chart.isRadianForPolar()) {
                return val;
            }
            return val * 180.0 / Math.PI;
        }

        @Override
        public void setStartAngle(double angle) {
            if (!QbChartBasic.this.chart.isRadianForPolar()) {
                angle = angle * Math.PI / 180.0;
            }
            QbChartBasic.this.chart.setStartAngleForPolar(angle);
        }

        @Override
        public boolean isAngleInRadian() {
            return QbChartBasic.this.chart.isRadianForPolar();
        }

        @Override
        public void setAngleInRadian(boolean b) {
            QbChartBasic.this.chart.setRadianForPolar(b);
        }

        @Override
        public boolean isClockwise() {
            return QbChartBasic.this.chart.isClockWiseForPolar();
        }

        @Override
        public void setClockwise(boolean state) {
            QbChartBasic.this.chart.setClockWiseForPolar(state);
        }

        @Override
        public final Dimension getLabelOffset(int index) {
            return QbChartBasic.this.chart.getLabelOffset(index);
        }

        @Override
        public final void setLabelOffset(int index, Dimension dim) {
            QbChartBasic.this.chart.setLabelOffset(index, dim);
        }

        @Override
        public final void setLabelOffset(Dimension[] dim) {
            QbChartBasic.this.chart.setLabelOffset(dim);
        }

        @Override
        public final int countLabelOffset() {
            return QbChartBasic.this.chart.countLabelOffset();
        }
    }

    class CBoxPropertySet
    implements IBoxPropertySet {
        CBoxPropertySet() {
        }

        @Override
        public final void setLayout(int x) {
            QbChartBasic.this.chart.setLayout(x);
        }

        @Override
        public final int getLayout() {
            return QbChartBasic.this.chart.getLayout();
        }
    }

    class CGanttPropertySet
    implements IGanttPropertySet {
        CGanttPropertySet() {
        }

        @Override
        public final boolean isTranslucent() {
            return QbChartBasic.this.chart.isTranslucent();
        }

        @Override
        public final void setTranslucent(boolean b) {
            QbChartBasic.this.chart.setTranslucent(b);
        }

        public final float getTranslucentValue() {
            return QbChartBasic.this.chart.getTranslucentValue();
        }

        public final void setTranslucentValue(float f) {
            QbChartBasic.this.chart.setTranslucentValue(f);
        }

        @Override
        public final boolean isDateTimeDisplay() {
            return QbChartBasic.this.chart.isLabelDateTimeDisplay(0);
        }

        @Override
        public final void setDateTimeDisplay(boolean b) {
            QbChartBasic.this.chart.setLabelDateTimeDisplay(0, b);
        }

        @Override
        public final IFormat getAxisLabelFormat() {
            return QbChartBasic.this.chart.getGanttLabelFormat();
        }

        @Override
        public final void setAxisLabelFormat(IFormat format) {
            QbChartBasic.this.chart.setGanttLabelFormat(format);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean isOriginAutomatic() {
            return QbChartBasic.this.chart.getAxisAutoOrigin(0);
        }

        @Override
        public final void setOriginAutomatic(boolean b) {
            QbChartBasic.this.chart.setAxisAutoOrigin(0, b);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean isScaleAutomatic() {
            return QbChartBasic.this.chart.getAxisAutoScale(0);
        }

        @Override
        public final void setScaleAutomatic(boolean b) {
            QbChartBasic.this.chart.setAxisAutoScale(0, b);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final long getMinScale() {
            return (long)QbChartBasic.this.chart.getAxisMinScale(0);
        }

        @Override
        public final void setMinScale(Date minScale) {
            QbChartBasic.this.chart.setAxisMinScale(0, minScale.getTime());
            if (!this.isOriginAutomatic()) {
                this.setOriginAutomatic(true);
            }
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final long getMaxScale() {
            return (long)QbChartBasic.this.chart.getAxisMaxScale(0);
        }

        @Override
        public final void setMaxScale(Date maxScale) {
            QbChartBasic.this.chart.setAxisMaxScale(0, maxScale.getTime());
            if (!this.isOriginAutomatic()) {
                this.setOriginAutomatic(true);
            }
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final long getScaleStep() {
            return (long)QbChartBasic.this.chart.getAxisStepMonth(0) * 732L * 3600000L + (long)QbChartBasic.this.chart.getAxisStepSize(0);
        }

        @Override
        public final void setScaleStep(Date step) {
            QbChartBasic.this.chart.setAxisStepSize(0, step.getTime());
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final void setScaleStep(int y, int m, int d, int hr, int min) {
            QbChartBasic.this.chart.setAxisStepSize(0, y, m, d, hr, min);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean isDisplayByWeek() {
            return QbChartBasic.this.chart.isDisplayByWeek(0);
        }

        @Override
        public final void setDisplayByWeek(boolean b) {
            QbChartBasic.this.chart.setDisplayByWeek(0, b);
        }

        @Override
        public final boolean isArrowsDrawn() {
            return QbChartBasic.this.chart.isGanttArrowsDrawn();
        }

        @Override
        public final void setArrowsDrawn(boolean b) {
            QbChartBasic.this.chart.setGanttArrowsDrawn(b);
        }
    }

    class CLinePropertySet
    implements ILinePropertySet {
        CLinePropertySet() {
        }

        @Override
        public final boolean isStepLineDrawn() {
            return QbChartBasic.this.chart.getStepLineState();
        }

        @Override
        public final double getStepLineRatio() {
            return QbChartBasic.this.chart.getStepLineRatio();
        }

        @Override
        public final void setStepLineRatio(double ratio) {
            QbChartBasic.this.chart.setStepLineRatio(ratio);
        }

        @Override
        public final void setStepLineDrawn(boolean b) {
            this.setStepLineDrawn(b, 1.0);
        }

        @Override
        public final void setSelectiveStepLineDrawn(boolean[] b) {
            QbChartBasic.this.chart.setSelectiveStepLineState(b);
        }

        @Override
        public final boolean[] getSelectiveStepLineDrawn() {
            return QbChartBasic.this.chart.getSelectiveStepLineState();
        }

        @Override
        public final boolean isSelectiveStepLineUsed() {
            return QbChartBasic.this.chart.isSelectiveStepLineUsed();
        }

        @Override
        public final void setStepLineDrawn(boolean b, double ratio) {
            QbChartBasic.this.chart.setStepLineState(b);
            QbChartBasic.this.chart.setStepLineRatio(ratio);
        }

        @Override
        public final void setLayout(int x) {
            QbChartBasic.this.chart.setLayout(x);
        }

        @Override
        public final int getLayout() {
            return QbChartBasic.this.chart.getLayout();
        }

        @Override
        public final void setAreaVisible(boolean state) {
            QbChartBasic.this.chart.setDrawAreaUnderLine(state);
        }

        @Override
        public final boolean isAreaVisible() {
            return QbChartBasic.this.chart.isDrawAreaUnderLine();
        }

        @Override
        public final void setAreaColors(Color colorAbove, Color colorBelow) {
            QbChartBasic.this.chart.setAreaUnderLineColors(colorAbove, colorBelow);
        }

        @Override
        public final Color getAreaColorAbove() {
            return QbChartBasic.this.chart.getAreaUnderLineColorAbove();
        }

        @Override
        public final Color getAreaColorBelow() {
            return QbChartBasic.this.chart.getAreaUnderLineColorBelow();
        }

        @Override
        public final void setDataDrawnOnTop(boolean state) {
            QbChartBasic.this.chart.setDataDrawnOnTop(state);
        }

        @Override
        public final boolean isDataDrawnOnTop() {
            return QbChartBasic.this.chart.isDataDrawnOnTop();
        }
    }

    class CRadarPropertySet
    implements IRadarPropertySet {
        CRadarPropertySet() {
        }

        @Override
        public final Dimension getLabelOffset(int index) {
            return QbChartBasic.this.chart.getLabelOffset(index);
        }

        @Override
        public final void setLabelOffset(int index, Dimension dim) {
            QbChartBasic.this.chart.setLabelOffset(index, dim);
        }

        @Override
        public final void setLabelOffset(Dimension[] dim) {
            QbChartBasic.this.chart.setLabelOffset(dim);
        }

        @Override
        public final int countLabelOffset() {
            return QbChartBasic.this.chart.countLabelOffset();
        }

        @Override
        public final void setSynchronizeRadarAxes(boolean b) {
            QbChartBasic.this.chart.setSynchronizeRadarAxis(b);
        }

        @Override
        public final boolean isSynchronizeRadarAxes() {
            return QbChartBasic.this.chart.isSynchronizeRadarAxis();
        }

        @Override
        public final void setDrawCircularGrid(boolean b) {
            QbChartBasic.this.chart.setDrawCircularGrid(b);
        }

        @Override
        public final boolean isDrawCircularGrid() {
            return QbChartBasic.this.chart.isDrawCircularGrid();
        }

        @Override
        public final void setAreaCutOffPoint(Double d) {
            QbChartBasic.this.chart.setAreaCutOffPoint(d);
        }

        @Override
        public final Double getAreaCutOffPoint() {
            return QbChartBasic.this.chart.getAreaCutOffPoint();
        }
    }

    class COverlayPropertySet
    implements IOverlayPropertySet {
        COverlayPropertySet() {
        }

        @Override
        public int getLayerCount() {
            return QbChartBasic.this.chart.getSeriesType() != null ? QbChartBasic.this.chart.getSeriesType().length : 0;
        }

        @Override
        public final int getLayerType(int i) {
            if (QbChartBasic.this.chart.getSeriesType() == null || i >= QbChartBasic.this.chart.getSeriesType().length) {
                return -1;
            }
            return QbChartBasic.this.chart.getSeriesType()[i];
        }

        @Override
        public final void setLayerType(int i, int chartType) {
            if (chartType != -1 && chartType != 7 && chartType != 3 && chartType != 0) {
                return;
            }
            int[] seriesType = QbChartBasic.this.chart.getSeriesType();
            if (seriesType == null || i >= seriesType.length) {
                return;
            }
            seriesType[i] = chartType;
            QbChartBasic.this.chart.setSeriesType(seriesType, true);
        }

        @Override
        public final boolean getAxisPosition(int i) {
            if (QbChartBasic.this.chart.getAxisPosition() == null || i >= QbChartBasic.this.chart.getAxisPosition().length) {
                return false;
            }
            return QbChartBasic.this.chart.getAxisPosition()[i] == -2;
        }

        @Override
        public final void setAxisPosition(int i, boolean useSecondaryAxis) {
            int[] axisPos = QbChartBasic.this.chart.getAxisPosition();
            if (axisPos == null || i >= axisPos.length) {
                return;
            }
            axisPos[i] = useSecondaryAxis ? -2 : -1;
            QbChartBasic.this.chart.setAxisPosition(axisPos, true);
        }

        @Override
        public final int getAxis(int i) {
            if (QbChartBasic.this.chart.getAxisPosition() == null || i >= QbChartBasic.this.chart.getAxisPosition().length) {
                return -1;
            }
            return QbChartBasic.this.chart.getAxisPosition()[i] == i ? -3 : QbChartBasic.this.chart.getAxisPosition()[i];
        }

        @Override
        public final void setAxis(int i, int assignedAxis) {
            int[] axisPos = QbChartBasic.this.chart.getAxisPosition();
            if (axisPos == null || i >= axisPos.length) {
                return;
            }
            axisPos[i] = assignedAxis == -3 ? i : assignedAxis;
            QbChartBasic.this.chart.setAxisPosition(axisPos, true);
        }

        @Override
        public final boolean isAutoAxisPosition() {
            return QbChartBasic.this.chart.isAutoAxisPosition();
        }

        @Override
        public final void setAutoAxisPosition(boolean b) {
            QbChartBasic.this.chart.setAutoAxisPosition(b);
        }

        @Override
        public final int getAxisGapOffset() {
            return QbChartBasic.this.chart.getAxisGapOffset();
        }

        @Override
        public final void setAxisGapOffset(int offset) {
            QbChartBasic.this.chart.setAxisGapOffset(offset);
        }

        @Override
        public final boolean isOverlayTransparent() {
            return QbChartBasic.this.chart.isTranslucent();
        }

        @Override
        public final void setOverlayTransparent(boolean b) {
            QbChartBasic.this.chart.setTranslucent(b);
        }

        public final float getTranslucentValue() {
            return QbChartBasic.this.chart.getTranslucentValue();
        }

        public final void setTranslucentValue(float f) {
            QbChartBasic.this.chart.setTranslucentValue(f);
        }
    }

    class CSurfacePropertySet
    implements ISurfacePropertySet {
        CSurfacePropertySet() {
        }

        @Override
        public final Color getSurfaceColor() {
            return QbChartBasic.this.chart.get3DSurfaceColor();
        }

        @Override
        public final void setSurfaceColor(Color color) {
            QbChartBasic.this.chart.set3DSurfaceColor(color);
        }
    }

    class CDoughnutPropertySet
    extends CPiePropertySet
    implements IDoughnutPropertySet {
        CDoughnutPropertySet() {
        }

        @Override
        public final int getArcLengthRatio() {
            return QbChartBasic.this.chart.getDoughnutArcLength();
        }

        @Override
        public final void setArcLengthRatio(int ratio) {
            QbChartBasic.this.chart.setDoughnutArcLength(ratio);
        }
    }

    class CPiePropertySet
    implements IPiePropertySet {
        CPiePropertySet() {
        }

        @Override
        public final int getRotationAngle() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getRotateAngle();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public final void setRotationAngle(int angle) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setRotateAngle(angle);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean isExploded(int sliceId) {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getPieSlice(sliceId);
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public final void setExploded(int sliceId, boolean b) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setPieSlice(sliceId, b);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean isExplodeUsingSectorGap() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().isSectorGapEnabled();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public final void setExplodeUsingSectorGap(boolean state) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setSectorGapEnabled(state);
        }

        @Override
        public final float getExplodeRadialPos() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return (float)((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getSliceDistance();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public final void setExplodeRadialPos(float x) {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                if (x < 0.0f) {
                    x = 0.0f;
                } else if (x > 2.0f) {
                    x = 2.0f;
                }
            } else {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setSliceDistance(x);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final float getLabelRadialPos() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return (float)((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getFontDistance();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public final void setLabelRadialPos(float p) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setFontDistance(p);
        }

        @Override
        public final ILabel gethLabel(int sliceId) {
            return this.gethLabel(0, sliceId);
        }

        @Override
        public final ILabel gethLabel(final int pieId, final int sliceId) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            return new ILabel(){

                @Override
                public Color getColor() {
                    return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getLabelColor();
                }

                @Override
                public void setColor(Color c) {
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setLabelColor(c);
                }

                @Override
                public Font getFont() {
                    return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getLabelFont();
                }

                @Override
                public void setFont(Font f) {
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setLabelFont(f);
                }

                @Override
                public int getAngle() {
                    return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getLabelAngle();
                }

                @Override
                public void setAngle(int angle) {
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setLabelAngle(angle);
                }

                @Override
                public final boolean isVisible() {
                    return QbChartBasic.this.chart.getLabelState();
                }

                @Override
                public final void setVisible(boolean b) {
                    QbChartBasic.this.chart.setLabelState(b);
                }

                @Override
                public final Dimension getOffset() {
                    return new Dimension((int)((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getOffset(0, true, pieId, sliceId), (int)((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getOffset(0, false, pieId, sliceId));
                }

                @Override
                public final void setOffset(Dimension offset) {
                    int ph;
                    int pw;
                    if (QbChartBasic.this.chart.is2DChart) {
                        pw = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().piewidth[pieId];
                        ph = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().pieheight[pieId];
                    } else {
                        pw = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().piewidth[pieId] * 2;
                        ph = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().pieheight[pieId] * 2;
                    }
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setOffset(0, true, (float)offset.width / (float)pw, pieId, sliceId);
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setOffset(0, false, (float)offset.height / (float)ph, pieId, sliceId);
                }

                @Override
                public final IFormat getFormat() {
                    throw new IllegalArgumentException("Format not supported for pie labels.");
                }

                @Override
                public final void setFormat(IFormat f) {
                    throw new IllegalArgumentException("Format not supported for pie labels.");
                }
            };
        }

        @Override
        public final ILabel gethValueLabel(int sliceId) {
            return this.gethValueLabel(0, sliceId);
        }

        @Override
        public final ILabel gethValueLabel(final int pieId, final int sliceId) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            return new ILabel(){

                @Override
                public Color getColor() {
                    return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getValueColor();
                }

                @Override
                public void setColor(Color c) {
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setValueColor(c);
                }

                @Override
                public Font getFont() {
                    return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getValueFont();
                }

                @Override
                public void setFont(Font f) {
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setValueFont(f);
                }

                @Override
                public int getAngle() {
                    return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getValueAngle();
                }

                @Override
                public void setAngle(int angle) {
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setValueAngle(angle);
                }

                @Override
                public final boolean isVisible() {
                    return QbChartBasic.this.chart.getValueState();
                }

                @Override
                public final void setVisible(boolean b) {
                    QbChartBasic.this.chart.setValueState(b);
                }

                @Override
                public final Dimension getOffset() {
                    return new Dimension((int)((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getOffset(1, true, pieId, sliceId), (int)((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getOffset(1, false, pieId, sliceId));
                }

                @Override
                public final void setOffset(Dimension offset) {
                    int ph;
                    int pw;
                    if (QbChartBasic.this.chart.is2DChart) {
                        pw = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().piewidth[pieId];
                        ph = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().pieheight[pieId];
                    } else {
                        pw = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().piewidth[pieId] * 2;
                        ph = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().pieheight[pieId] * 2;
                    }
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setOffset(1, true, (float)offset.width / (float)pw, pieId, sliceId);
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setOffset(1, false, (float)offset.height / (float)ph, pieId, sliceId);
                }

                @Override
                public final IFormat getFormat() {
                    throw new IllegalArgumentException("Format not supported for pie values.");
                }

                @Override
                public final void setFormat(IFormat f) {
                    throw new IllegalArgumentException("Format not supported for pie values.");
                }
            };
        }

        @Override
        public final ILabel gethPercentLabel(int sliceId) {
            return this.gethPercentLabel(0, sliceId);
        }

        @Override
        public final ILabel gethPercentLabel(final int pieId, final int sliceId) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            return new ILabel(){

                @Override
                public Color getColor() {
                    return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getPercentColor();
                }

                @Override
                public void setColor(Color c) {
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setPercentColor(c);
                }

                @Override
                public Font getFont() {
                    return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getPercentFont();
                }

                @Override
                public void setFont(Font f) {
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setPercentFont(f);
                }

                @Override
                public int getAngle() {
                    return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getPercentAngle();
                }

                @Override
                public void setAngle(int angle) {
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setPercentAngle(angle);
                }

                @Override
                public final boolean isVisible() {
                    return QbChartBasic.this.chart.getPercentState();
                }

                @Override
                public final void setVisible(boolean b) {
                    QbChartBasic.this.chart.setPercentState(b);
                }

                @Override
                public final Dimension getOffset() {
                    return new Dimension((int)((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getOffset(2, true, pieId, sliceId), (int)((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getOffset(2, false, pieId, sliceId));
                }

                @Override
                public final void setOffset(Dimension offset) {
                    int ph;
                    int pw;
                    if (QbChartBasic.this.chart.is2DChart) {
                        pw = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().piewidth[pieId];
                        ph = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().pieheight[pieId];
                    } else {
                        pw = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().piewidth[pieId] * 2;
                        ph = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().pieheight[pieId] * 2;
                    }
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setOffset(2, true, (float)offset.width / (float)pw, pieId, sliceId);
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setOffset(2, false, (float)offset.height / (float)ph, pieId, sliceId);
                }

                @Override
                public final IFormat getFormat() {
                    return QbChartBasic.this.chart.getSpecNumericFormat();
                }

                @Override
                public void setFormat(IFormat f) {
                    QbChartBasic.this.chart.setSpecNumericFormat(QbChartBasic.this.checkNumericFormat(f));
                }
            };
        }

        @Override
        public final ILabel gethCategoryLabel(final int pieId) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            return new ILabel(){

                @Override
                public Color getColor() {
                    return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getCatLabelColor();
                }

                @Override
                public void setColor(Color c) {
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setCatLabelColor(c);
                }

                @Override
                public Font getFont() {
                    return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getCatLabelFont();
                }

                @Override
                public void setFont(Font f) {
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setCatLabelFont(f);
                }

                @Override
                public int getAngle() {
                    return ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getCatLabelAngle();
                }

                @Override
                public void setAngle(int angle) {
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setCatLabelAngle(angle);
                }

                @Override
                public final boolean isVisible() {
                    return QbChartBasic.this.chart.getCatLabelState();
                }

                @Override
                public final void setVisible(boolean b) {
                    QbChartBasic.this.chart.setCatLabelState(b);
                }

                @Override
                public final Dimension getOffset() {
                    return new Dimension((int)((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getOffset(3, true, pieId, 0), (int)((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().getOffset(3, false, pieId, 0));
                }

                @Override
                public final void setOffset(Dimension offset) {
                    int ph;
                    int pw;
                    if (QbChartBasic.this.chart.is2DChart) {
                        pw = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().piewidth[pieId];
                        ph = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().pieheight[pieId];
                    } else {
                        pw = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().piewidth[pieId] * 2;
                        ph = ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().pieheight[pieId] * 2;
                    }
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setOffset(3, true, (float)offset.width / (float)pw, pieId, 0);
                    ((IPieChart)((Object)QbChartBasic.this.chart)).getPieChart().setOffset(3, false, (float)offset.height / (float)ph, pieId, 0);
                }

                @Override
                public final IFormat getFormat() {
                    throw new IllegalArgumentException("Format not supported for pie values.");
                }

                @Override
                public final void setFormat(IFormat f) {
                    throw new IllegalArgumentException("Format not supported for pie values.");
                }
            };
        }

        @Override
        public final int getSectorCount() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return QbChartBasic.this.chart.getPieSectors();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public final void setSectorCount(int numSectors) {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                QbChartBasic.this.chart.setPieSectors(numSectors);
                if (!QbChartBasic.this.chart.is2DimChart()) {
                    QbChartBasic.this.setrepaint(true);
                }
            } else {
                throw new IllegalArgumentException("Not a pie chart!");
            }
        }

        @Override
        public final void setValueVisibleInLegend(boolean b) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            QbChartBasic.this.chart.setValueInLegend(b);
        }

        @Override
        public final boolean isValueVisibleInLegend() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return QbChartBasic.this.chart.isValueInLegend();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public final void setPercentVisibleInLegend(boolean b) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            QbChartBasic.this.chart.setSmartState(b);
        }

        @Override
        public final boolean isPercentVisibleInLegend() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return QbChartBasic.this.chart.getSmartState();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public final void setRadialBorderDrawnForZero(boolean b) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            QbChartBasic.this.chart.setRadialBorderState(b);
        }

        @Override
        public final boolean isRadialBorderDrawnForZero() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return QbChartBasic.this.chart.getRadialBorderState();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public final void setZeroLabelsVisible(boolean b) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            QbChartBasic.this.chart.setZeroLabelsVisibleState(b);
        }

        @Override
        public final boolean isZeroLabelsVisible() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return QbChartBasic.this.chart.getZeroLabelsVisibleState();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public final char getSepSymbol() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return QbChartBasic.this.chart.legend.getPieSepSymbol();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public final void setSepSymbol(char c) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            QbChartBasic.this.chart.legend.setPieSepSymbol(c);
        }

        @Override
        public final void setBorderColor(Color newColor) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            QbChartBasic.this.chart.setPieBorderColor(newColor);
        }

        @Override
        public final Color getBorderColor() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return QbChartBasic.this.chart.getPieBorderColor();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public final void setExtendLineDrawn(boolean drawn) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            QbChartBasic.this.chart.setPieExtendLineDrawn(drawn);
        }

        @Override
        public final boolean isExtendLineDrawn() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return QbChartBasic.this.chart.isPieExtendLineDrawn();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public final void setPieLabelAtTheSide(boolean drawn) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            QbChartBasic.this.chart.setPieLabelAtTheSide(drawn);
        }

        @Override
        public final boolean isPieLabelAtTheSide() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return QbChartBasic.this.chart.isPieLabelAtTheSide();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public void setPiePerRow(int nPie) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            QbChartBasic.this.chart.setPiePerRow(nPie);
        }

        @Override
        public int getPiePerRow() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return QbChartBasic.this.chart.getPiePerRow();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public void setDrawLinearly(boolean b) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            QbChartBasic.this.chart.setDrawLinearlyForPies(b);
        }

        @Override
        public boolean isDrawLinearly() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return QbChartBasic.this.chart.isDrawLinearlyForPies();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public void setBestFit(boolean b) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            QbChartBasic.this.chart.setBestFitForPies(b);
        }

        @Override
        public boolean isBestFit(boolean b) {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return QbChartBasic.this.chart.isBestFitForPies();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public void setGapRatioBetweenPies(double ratio) {
            if (!(QbChartBasic.this.chart instanceof IPieChart)) {
                throw new IllegalArgumentException("Not a pie chart!");
            }
            QbChartBasic.this.chart.setGapRatioBetweenPies(ratio);
        }

        @Override
        public double getGapRatioBetweenPies() {
            if (QbChartBasic.this.chart instanceof IPieChart) {
                return QbChartBasic.this.chart.getGapRatioBetweenPies();
            }
            throw new IllegalArgumentException("Not a pie chart!");
        }

        @Override
        public void setOthersThresholdPercentage(double threshold) {
            QbChartBasic.this.chart.setPieGroupOthersLimit(threshold);
        }

        @Override
        public double getOthersThresholdPercentage() {
            return QbChartBasic.this.chart.getPieGroupOthersLimit();
        }

        @Override
        public void setDisplayNameForOthers(String name) {
            QbChartBasic.this.chart.setPieGroupOthersName(name);
        }

        @Override
        public String getDisplayNameForOthers() {
            return QbChartBasic.this.chart.getPieGroupOthersName();
        }

        @Override
        public double getColorThresholdForPie() {
            return QbChartBasic.this.chart.getColorThresholdForPie();
        }

        @Override
        public void setColorThresholdForPie(double i) {
            QbChartBasic.this.chart.setColorThresholdForPie(i);
        }

        @Override
        public Color[] getColorArrayForPieThreshold() {
            return QbChartBasic.this.chart.getColorArrayForPieThreshold();
        }

        @Override
        public void setColorArrayForPieThreshold(Color[] colors) {
            QbChartBasic.this.chart.setColorArrayForPieThreshold(colors);
        }
    }

    class CFlashHintBoxPropertySet
    implements IFlashHintBoxPropertySet {
        CFlashHintBoxPropertySet() {
        }

        @Override
        public Font getFont() {
            return QbChartBasic.this.chart.flashHintFont;
        }

        @Override
        public void setFont(Font font) {
            QbChartBasic.this.chart.flashHintFont = font;
        }

        @Override
        public Color getFontColor() {
            return QbChartBasic.this.chart.flashHintFontColor;
        }

        @Override
        public void setFontColor(Color c) {
            QbChartBasic.this.chart.flashHintFontColor = c;
        }

        @Override
        public Color getBackgroundColor() {
            return QbChartBasic.this.chart.flashHintBgColor;
        }

        @Override
        public void setBackgroundColor(Color c) {
            QbChartBasic.this.chart.flashHintBgColor = c;
        }

        @Override
        public Color getBorderColor() {
            return QbChartBasic.this.chart.flashHintBorderColor;
        }

        @Override
        public void setBorderColor(Color c) {
            QbChartBasic.this.chart.flashHintBorderColor = c;
        }

        @Override
        public boolean isHintBoxEnabled() {
            return QbChartBasic.this.chart.flashEnableHintBox;
        }

        @Override
        public void setHintBoxEnabled(boolean b) {
            QbChartBasic.this.chart.flashEnableHintBox = b;
        }

        @Override
        public final void setCustomizeDataHintBoxHandle(ICustomizeImageMapDataHintBox val) {
            QbChartBasic.this.chart.setCustomizeImageMapDataHintBox(val);
        }

        @Override
        public ICustomizeImageMapDataHintBox getCustomizeDataHintBoxHandle() {
            return QbChartBasic.this.chart.getCustomizeImageMapDataHintBox();
        }
    }

    class CBubblePropertySet
    implements IBubblePropertySet {
        CBubblePropertySet() {
        }

        @Override
        public final int getDrawMode() {
            return QbChartBasic.this.chart.bubbleDrawMode;
        }

        @Override
        public final void setDrawMode(int mode) {
            QbChartBasic.this.chart.bubbleDrawMode = mode;
        }

        @Override
        public final void setBlackBorderVisible(boolean visible) {
            QbChartBasic.this.chart.setDataBorder(visible);
        }

        @Override
        public final boolean isBlackBorderVisible() {
            return QbChartBasic.this.chart.getDataBorder();
        }

        @Override
        public final double getAxisUnitToRadiusRatio() {
            return QbChartBasic.this.chart.axisUnitToRadiusRatio;
        }

        @Override
        public void setAxisUnitToRadiusRatio(double ratio) {
            QbChartBasic.this.chart.axisUnitToRadiusRatio = ratio;
        }

        @Override
        public final void setAreaProportionalToValue(boolean state) {
            QbChartBasic.this.chart.setBubbleAreaToValue(state);
        }

        @Override
        public final boolean isAreaProportionalToValue() {
            return QbChartBasic.this.chart.getBubbleAreaToValue();
        }

        @Override
        public final void set3DShading(boolean state) {
            QbChartBasic.this.chart.set3DBubblesDrawn(state, 66);
        }

        @Override
        public final void set3DShading(boolean state, int light) {
            light = light > 100 ? 100 : light;
            light = light < 1 ? 1 : light;
            QbChartBasic.this.chart.set3DBubblesDrawn(state, light);
        }

        @Override
        public final boolean is3DShading() {
            return QbChartBasic.this.chart.is3DBubblesDrawn();
        }

        @Override
        public final int get3DLightIntensity() {
            return QbChartBasic.this.chart.get3DBubblesLight();
        }
    }

    class CHyperLinkHint
    implements IHint {
        CHyperLinkHint() {
        }

        @Override
        public final void setEnabled(boolean b) {
            QbChartBasic.this.vpanel.showLink = b;
        }

        @Override
        public final boolean isEnabled() {
            return QbChartBasic.this.vpanel.showLink;
        }

        @Override
        public final Color getBackgroundColor() {
            return QbChartBasic.this.vpanel.linkBgColor;
        }

        @Override
        public final void setBackgroundColor(Color c) {
            QbChartBasic.this.vpanel.linkBgColor = c;
        }

        @Override
        public final Color getBorderColor() {
            return QbChartBasic.this.vpanel.linkBorderColor;
        }

        @Override
        public final void setBorderColor(Color c) {
            QbChartBasic.this.vpanel.linkBorderColor = c;
        }

        @Override
        public final void setHintBoxInfo(IHintBoxInfo hintBoxInfo) {
            if (QbChartBasic.this.vpanel3d != null) {
                QbChartBasic.this.vpanel3d.setHintBoxInfo(hintBoxInfo);
            }
        }

        @Override
        public final PickData getPickData(int x, int y) {
            if (QbChartBasic.this.vpanel != null) {
                return QbChartBasic.this.vpanel.getPickData(x, y);
            }
            return null;
        }

        @Override
        public final Dimension getOffset() {
            return QbChartBasic.this.vpanel.getHyperLinkOffset();
        }

        @Override
        public final void setOffset(Dimension offset) {
            QbChartBasic.this.vpanel.setHyperLinkOffset(offset);
        }

        @Override
        public final IText gethText() {
            return new IText(){

                @Override
                public final Color getColor() {
                    return QbChartBasic.this.vpanel.linkFontColor;
                }

                @Override
                public final void setColor(Color c) {
                    QbChartBasic.this.vpanel.linkFontColor = c;
                }

                @Override
                public final Font getFont() {
                    return QbChartBasic.this.vpanel.linkFont;
                }

                @Override
                public final void setFont(Font f) {
                    QbChartBasic.this.vpanel.linkFont = f;
                }

                @Override
                public final int getAngle() {
                    return 0;
                }

                @Override
                public final void setAngle(int angle) {
                    throw new IllegalArgumentException("Cannot set angle for hint");
                }
            };
        }
    }

    class CDataHint
    implements IHint {
        CDataHint() {
        }

        @Override
        public final void setEnabled(boolean b) {
            QbChartBasic.this.chart.setShowDataState(b);
        }

        @Override
        public final boolean isEnabled() {
            return QbChartBasic.this.chart.getShowDataState();
        }

        @Override
        public final Color getBackgroundColor() {
            return QbChartBasic.this.vpanel.dataBgColor;
        }

        @Override
        public final void setBackgroundColor(Color c) {
            QbChartBasic.this.vpanel.linkBgColor = c;
            QbChartBasic.this.vpanel.dataBgColor = c;
        }

        @Override
        public final Color getBorderColor() {
            return QbChartBasic.this.vpanel.dataBorderColor;
        }

        @Override
        public final void setBorderColor(Color c) {
            QbChartBasic.this.vpanel.linkBorderColor = c;
            QbChartBasic.this.vpanel.dataBorderColor = c;
        }

        @Override
        public final void setHintBoxInfo(IHintBoxInfo hintBoxInfo) {
            if (QbChartBasic.this.vpanel3d != null) {
                QbChartBasic.this.vpanel3d.setHintBoxInfo(hintBoxInfo);
            }
        }

        @Override
        public final PickData getPickData(int x, int y) {
            if (QbChartBasic.this.vpanel != null) {
                return QbChartBasic.this.vpanel.getPickData(x, y);
            }
            return null;
        }

        @Override
        public final Dimension getOffset() {
            return QbChartBasic.this.vpanel.getHintBoxOffset();
        }

        @Override
        public final void setOffset(Dimension offset) {
            QbChartBasic.this.vpanel.setHintBoxOffset(offset);
        }

        @Override
        public final IText gethText() {
            return new IText(){

                @Override
                public final Color getColor() {
                    return QbChartBasic.this.vpanel.dataFontColor;
                }

                @Override
                public final void setColor(Color c) {
                    QbChartBasic.this.vpanel.linkFontColor = c;
                    QbChartBasic.this.vpanel.dataFontColor = c;
                }

                @Override
                public final Font getFont() {
                    return QbChartBasic.this.vpanel.dataFont;
                }

                @Override
                public final void setFont(Font f) {
                    QbChartBasic.this.vpanel.linkFont = f;
                    QbChartBasic.this.vpanel.dataFont = f;
                }

                @Override
                public final int getAngle() {
                    return 0;
                }

                @Override
                public final void setAngle(int angle) {
                    throw new IllegalArgumentException("Cannot set angle for hint");
                }
            };
        }
    }

    class CInputData
    implements IInputData {
        CInputData() {
        }

        private void preparePaint() {
            if (!forExportOnly && QbChartBasic.this.vpanel3d != null) {
                QbChartBasic.this.vpanel3d.filename = null;
            }
            if (QbChartBasic.this.newColInfo != null) {
                try {
                    QbChartBasic.this.setDataMap(QbChartBasic.this.newColInfo);
                    QbChartBasic.this.newColInfo = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            QbChartBasic.this.setrepaint(true);
        }

        private Chart setNewData(ColData[] colData) {
            return this.setNewData(colData, true);
        }

        private Chart setNewData(ColData[] colData, boolean reloadData) {
            if (QbChartBasic.this.chart.isAggregationChart() || QbChartBasic.this.chart.isHistogram() || QbChartBasic.this.chart.isDrillDownDefined() || QbChartBasic.this.chart.isFieldDrillDownChart() || QbChartBasic.this.chart.isTimeChart()) {
                try {
                    if ((QbChartBasic.this.chart.sourceData == 0 || QbChartBasic.this.chart.sourceData == 14) && QbChartBasic.this.spreadSheet != null) {
                        QbChartBasic.this.chart.setNewData(ColData.getColData(QbChartBasic.this.spreadSheet));
                        return QbChartBasic.this.chart;
                    }
                    QbChartBasic.this.chart.usedColumns = null;
                    if (reloadData) {
                        QbChartBasic.this.chart = ReloadChart.reloadData(QbChartBasic.this.chart, false);
                    }
                    return QbChartBasic.this.chart;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return QbChartBasic.this.chart;
                }
            }
            if (QbChartBasic.this.newColInfo == null) {
                return QbChartBasic.this.chart.setNewData(colData);
            }
            int dim = 0;
            int[] map = new int[3];
            if (QbChartBasic.this.newColInfo.getColumn(1) >= 0) {
                map[dim] = QbChartBasic.this.newColInfo.getColumn(1);
                ++dim;
            }
            if (QbChartBasic.this.newColInfo.getColumn(0) >= 0) {
                map[dim] = QbChartBasic.this.newColInfo.getColumn(0);
                ++dim;
            }
            if (QbChartBasic.this.newColInfo.getColumn(2) >= 0) {
                map[dim] = QbChartBasic.this.newColInfo.getColumn(2);
                ++dim;
            }
            if (Chart.isCoordinateType(QbChartBasic.this.chart.getChartType())) {
                int[] val = new int[]{QbChartBasic.this.newColInfo.getColumn(5), QbChartBasic.this.newColInfo.getColumn(6), QbChartBasic.this.newColInfo.getColumn(7)};
                QbChartBasic.this.chart.coordCol = val;
            }
            if (QbChartBasic.this.chart.getChartType() == 9 || QbChartBasic.this.chart.getChartType() == 10 || QbChartBasic.this.chart.getChartType() == 18) {
                QbChartBasic.this.chart.hilowCol = new HiLowMap(QbChartBasic.this.newColInfo.getColumn(8), QbChartBasic.this.newColInfo.getColumn(9), QbChartBasic.this.newColInfo.getColumn(10), QbChartBasic.this.newColInfo.getColumn(11));
            }
            QbChartBasic.this.chart.valueCol = QbChartBasic.this.newColInfo.getColumn(3);
            QbChartBasic.this.chart.subvalueCol = QbChartBasic.this.newColInfo.getColumn(4);
            return QbChartBasic.this.chart.setNewData(colData, map, dim);
        }

        @Override
        public final IColumnMap getColumnMap() {
            return new ColInfo(QbChartBasic.this.chart);
        }

        @Override
        public final void setColumnMap(IColumnMap map) {
            QbChartBasic.this.newColInfo = map;
            try {
                QbChartBasic.this.setDataMap(map);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public final String getDataFile() {
            if (QbChartBasic.this.chart.sourceData == 2) {
                return QbChartBasic.this.chart.sourceFile;
            }
            return null;
        }

        @Override
        public final void setDataFile(String fileName) throws IOException {
            this.setDataFile(fileName, null);
        }

        @Override
        public final void setDataFile(String fileName, String encoding) throws IOException {
            try {
                QbChartBasic.this.chart = this.setNewData(new DataFileInput().readProcessedData(fileName, QbChartBasic.this.chart.isTransposed(), QbChartBasic.this.chart.transposeCol, null, encoding));
            }
            catch (Exception ex) {
                throw new IOException(ex.toString());
            }
            QbChartBasic.this.chart.sourceData = 2;
            QbChartBasic.this.chart.sourceFile = fileName;
            QbChartBasic.this.chart.sourceFileEncoding = encoding;
            this.preparePaint();
        }

        @Override
        public final String getClassFile() {
            if (QbChartBasic.this.chart.sourceData == 6) {
                return QbChartBasic.this.chart.sourceFile;
            }
            return null;
        }

        @Override
        public final void setClassFile(String className) throws IOException {
            try {
                QbChartBasic.this.chart = QbChartBasic.this.chart.setNewData(new DataFileInput().readProcessedData(className, QbChartBasic.this.chart.isTransposed(), QbChartBasic.this.chart.transposeCol, null, 6));
            }
            catch (Exception ex) {
                throw new IOException(ex.toString());
            }
            QbChartBasic.this.chart.sourceData = 6;
            QbChartBasic.this.chart.sourceFile = className;
            this.preparePaint();
        }

        @Override
        public final XMLFileQueryInfo getXMLFileQueryInfo() {
            return QbChartBasic.this.chart.getXMLFileQueryInfo();
        }

        @Override
        public final void setXMLFileQueryInfo(XMLFileQueryInfo xmlInfo) {
            try {
                QbChartBasic.this.chart = QbChartBasic.this.chart.setNewData(new DataFileInput().readProcessedData(xmlInfo.getFileName(), QbChartBasic.this.chart.isTransposed(), QbChartBasic.this.chart.transposeCol, null, null, xmlInfo, 7));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            QbChartBasic.this.chart.sourceData = 7;
            QbChartBasic.this.chart.sourceFile = xmlInfo.getFileName();
            QbChartBasic.this.chart.setXMLFileQueryInfo(xmlInfo);
            this.preparePaint();
        }

        @Override
        public final String getXMLFile() {
            if (QbChartBasic.this.chart.sourceData == 7) {
                XMLFileQueryInfo xmlInfo = this.getXMLFileQueryInfo();
                if (xmlInfo != null) {
                    return this.getXMLFileQueryInfo().getFileName();
                }
                return null;
            }
            return QbChartBasic.this.chart.sourceFile;
        }

        @Override
        public final void setXMLFile(String xmlFile) throws IOException {
            if (QbChartBasic.this.chart.sourceData == 7) {
                XMLFileQueryInfo xmlInfo = this.getXMLFileQueryInfo();
                if (xmlFile == null || xmlInfo == null) {
                    throw new IOException("Failed to set the xml data file");
                }
                xmlInfo.setFileName(xmlFile);
                xmlInfo.setData(null);
                try {
                    QbChartBasic.this.chart = QbChartBasic.this.chart.setNewData(new DataFileInput().readProcessedData(xmlFile, QbChartBasic.this.chart.isTransposed(), QbChartBasic.this.chart.transposeCol, null, null, xmlInfo, 7));
                }
                catch (Exception ex) {
                    throw new IOException(ex.toString());
                }
                QbChartBasic.this.chart.sourceFile = xmlInfo.getFileName();
                QbChartBasic.this.chart.setXMLFileQueryInfo(xmlInfo);
            } else {
                try {
                    QbChartBasic.this.chart = QbChartBasic.this.chart.setNewData(new DataFileInput().readProcessedData(xmlFile, QbChartBasic.this.chart.isTransposed(), QbChartBasic.this.chart.transposeCol, null, null, null, 4));
                }
                catch (Exception ex) {
                    throw new IOException(ex.toString());
                }
                QbChartBasic.this.chart.sourceFile = xmlFile;
                QbChartBasic.this.chart.sourceData = 4;
            }
            this.preparePaint();
        }

        @Override
        public final String getDTDFile() {
            XMLFileQueryInfo xmlInfo = this.getXMLFileQueryInfo();
            if (xmlInfo != null) {
                return this.getXMLFileQueryInfo().getDTDName();
            }
            return null;
        }

        @Override
        public final boolean isSpreadSheetFormat() {
            return QbChartBasic.this.chart.isTransposed;
        }

        @Override
        public int[] getTransposedColumn() {
            return TransposeRS.getTransposeIndex(QbChartBasic.this.chart.getTransposeColumn());
        }

        public void setTransposedColumn(int[] cols) {
            QbChartBasic.this.chart.setTransposed(true, TransposeRS.getTransposeColumn(cols));
        }

        @Override
        public final void setSpreadSheetFormat(boolean b) {
            this.setSpreadSheetFormat(b, null);
        }

        @Override
        public final void setSpreadSheetFormat(boolean b, int[] transposeCol) {
            QbChartBasic.this.chart.setTransposed(b, TransposeRS.getTransposeColumn(transposeCol));
        }

        @Override
        public final IDatabaseInfo getDatabaseInfo() {
            if (QbChartBasic.this.chart.getQueryFileInfo() != null) {
                return QbUtil.cast(QbChartBasic.this.chart.getQueryFileInfo());
            }
            if (QbChartBasic.this.chart.dbInfo != null) {
                return QbUtil.cast(QbChartBasic.this.chart.dbInfo);
            }
            return null;
        }

        @Override
        public final void setDatabaseInfo(IDatabaseInfo dbinfo) throws Exception {
            this.setDatabaseInfo(dbinfo, true);
        }

        @Override
        public final void setDatabaseInfo(IDatabaseInfo dbinfo, boolean useNewData) throws Exception {
            ColData[] data = null;
            boolean failed = false;
            if (dbinfo instanceof IQueryFileInfo) {
                QueryFileInfo queryFileInfo = new QueryFileInfo((IQueryFileInfo)dbinfo, useNewData);
                try {
                    if (useNewData) {
                        data = DBAccess.retrieveResult(QueryFileInfo.getDBAccessParameter(queryFileInfo), queryFileInfo, true, QbChartBasic.this.chart.isTransposed, QbChartBasic.this.chart.transposeCol, null, null);
                    }
                }
                catch (Exception e) {
                    QbChartBasic.this.errorMessage = "Error in setDatabaseInfo";
                    failed = true;
                    e.printStackTrace();
                }
                QbChartBasic.this.chart.queryFilename = null;
                QbChartBasic.this.chart.setQueryFileInfo(queryFileInfo);
                QbChartBasic.this.chart.dbInfo = queryFileInfo;
            } else {
                try {
                    if (useNewData) {
                        data = DBInfo.getColData(dbinfo, QbChartBasic.this.chart.isTransposed, QbChartBasic.this.chart.transposeCol);
                    }
                }
                catch (Exception e) {
                    QbChartBasic.this.errorMessage = "Error in setDatabaseInfo";
                    failed = true;
                    e.printStackTrace();
                }
                QbChartBasic.this.chart.queryFilename = null;
                QbChartBasic.this.chart.setQueryFileInfo(null);
                QbChartBasic.this.chart.dbInfo = new DBInfo(dbinfo);
            }
            if (!failed && useNewData) {
                QbChartBasic.this.chart = this.setNewData(data);
            }
            QbChartBasic.this.chart.sourceData = 1;
            this.preparePaint();
        }

        @Override
        public final String getQueryFilename() {
            if (QbChartBasic.this.chart.sourceData == 2) {
                return QbChartBasic.this.chart.queryFilename;
            }
            return null;
        }

        @Override
        public final void setQueryFilename(String filename) throws Exception {
            QueryFileInfo temp = QueryFileInfo.readFile(filename);
            this.setDatabaseInfo(QbUtil.cast(temp));
            QbChartBasic.this.chart.queryFilename = filename;
        }

        @Override
        public IQueryFileInfo readQueryFile(String filename) throws Exception {
            return QbUtil.cast(QueryFileInfo.readFile(filename));
        }

        @Override
        public final void addRow(IRow r) {
            Object[] records = QbChartBasic.this.getValidRow(r);
            QbChartBasic.this.chart.addRecord(records);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final void deleteRow(int rowId) {
            if (rowId >= QbChartBasic.this.chart.getDataRowSize()) {
                throw new IllegalArgumentException("Row ID must be less than " + QbChartBasic.this.chart.getDataRowSize());
            }
            QbChartBasic.this.chart.removeRecord(rowId);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final void updateRow(int rowId, IRow r) {
            Object[] newrec = QbChartBasic.this.getValidRow(r);
            QbChartBasic.this.chart.setRecord(newrec, rowId);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final IRow getRow(final int rowId) {
            return new IRow(){
                Object[] row;
                {
                    this.row = QbChartBasic.this.chart.getRecord(rowId);
                }

                @Override
                public Object getObject(int i) {
                    if (i <= 0 || i > this.row.length) {
                        throw new IllegalArgumentException("Invalid index :" + i);
                    }
                    return this.row[i - 1];
                }
            };
        }

        @Override
        public final int getRowCount() {
            return QbChartBasic.this.chart.getDataRowSize();
        }

        @Override
        public final int matchRecord(IRow r) {
            Object[] newrec = QbChartBasic.this.getValidRow(r);
            return QbChartBasic.this.searchRecord(QbChartBasic.this.chart.getColData(), QbChartBasic.this.checkStrArr(newrec));
        }

        @Override
        public final IResultSet getData() {
            return ColData.getResultSet(QbChartBasic.this.chart.getColData());
        }

        @Override
        public final void setData(IResultSet rs) throws Exception {
            this.setData(rs, true);
        }

        @Override
        public final void setData(IResultSet rs, boolean reloadData) throws Exception {
            ColData[] colData;
            if (rs instanceof DbData) {
                colData = ((DbData)rs).getColData();
                QbChartBasic.this.chart = this.setNewData(colData, reloadData);
            } else {
                colData = ColData.getColData(rs);
                QbChartBasic.this.chart = this.setNewData(colData, reloadData);
            }
            QbChartBasic.this.chart.originalColDataFromMemSource = colData;
            QbChartBasic.this.chart.sourceData = 0;
            this.preparePaint();
        }

        @Override
        public final ISpreadSheetModel getSpreadSheetModel() {
            return QbChartBasic.this.spreadSheet;
        }

        @Override
        public final void setSpreadSheetModel(ISpreadSheetModel sheet) {
            ColData[] colDataArray = null;
            QbChartBasic.this.spreadSheet = sheet;
            if (sheet == null) {
                return;
            }
            if (QbChartBasic.this.spreadSheetListener == null) {
                QbChartBasic.this.spreadSheetListener = new CSpreadSheetListener();
            }
            sheet.addSpreadSheetModelListener(QbChartBasic.this.spreadSheetListener);
            colDataArray = ColData.getColData(sheet);
            QbChartBasic.this.chart = QbChartBasic.this.chart.setNewData(colDataArray);
            QbChartBasic.this.chart.originalColDataFromMemSource = null;
            QbChartBasic.this.chart.sourceData = 0;
            this.preparePaint();
        }

        @Override
        public SalesForceQueryFileInfo getSalesForceQueryInfo() {
            return QbChartBasic.this.chart.sfQueryInfo;
        }

        @Override
        public void setSalesForceQueryInfo(SalesForceQueryFileInfo sfQueryInfo) throws Exception {
            ColData[] data = SalesForceAccess.getColData(sfQueryInfo, QbChartBasic.this.chart.isTransposed, QbChartBasic.this.chart.transposeCol, QbChartBasic.this.chart.tsInfo);
            QbChartBasic.this.chart = QbChartBasic.this.chart.setNewData(data);
            QbChartBasic.this.chart.sourceData = 11;
            QbChartBasic.this.chart.sfQueryInfo = sfQueryInfo;
            if (sfQueryInfo.isParameterized()) {
                QbChartBasic.this.chart.dbInfo = sfQueryInfo;
            }
        }

        @Override
        public ExcelFileInfo getExcelFileInfo() {
            return QbChartBasic.this.chart.excelInfo;
        }

        @Override
        public void setExcelFileInfo(ExcelFileInfo excelInfo) throws Exception {
            ColData[] data = ExcelAccess.getColData(excelInfo, QbChartBasic.this.chart.isTransposed, QbChartBasic.this.chart.transposeCol, QbChartBasic.this.chart.tsInfo, 0, -1);
            QbChartBasic.this.chart = QbChartBasic.this.chart.setNewData(data);
            QbChartBasic.this.chart.sourceData = 13;
            QbChartBasic.this.chart.excelInfo = excelInfo;
        }
    }

    class CPlot
    implements IPlot {
        CPlot() {
        }

        @Override
        public final float getRelativeWidth() {
            return QbChartBasic.this.chart.getChartWidthProp();
        }

        @Override
        public final void setRelativeWidth(float width) {
            QbChartBasic.this.chart.setChartWidthProp(width);
        }

        @Override
        public final float getRelativeHeight() {
            return QbChartBasic.this.chart.getChartHeightProp();
        }

        @Override
        public final void setRelativeHeight(float height) {
            QbChartBasic.this.chart.setChartHeightProp(height);
        }

        @Override
        public Position getPosition() {
            return new Position(QbChartBasic.this.chart.getChart_XProp(), QbChartBasic.this.chart.getChart_YProp());
        }

        @Override
        public final void setPosition(Position p) {
            QbChartBasic.this.chart.setChart_XProp(p.getX());
            QbChartBasic.this.chart.setChart_YProp(p.getY());
        }

        @Override
        public final boolean isBorderVisible() {
            return QbChartBasic.this.chart.getBorderState();
        }

        @Override
        public final void setBorderVisible(boolean b) {
            QbChartBasic.this.chart.setBorderState(b);
        }

        @Override
        public final Color getBorderColor() {
            return QbChartBasic.this.chart.getBorder().areaColor;
        }

        @Override
        public final void setBorderColor(Color c) {
            QbChartBasic.this.chart.getBorder().areaColor = c;
        }

        @Override
        public final int getBorderThickness() {
            return QbChartBasic.this.chart.getBorderThickness();
        }

        @Override
        public final void setBorderThickness(int x) {
            QbChartBasic.this.chart.setBorderThickness(x);
        }

        @Override
        public final boolean isBackgroundVisible() {
            return QbChartBasic.this.chart.getBackgroundState();
        }

        @Override
        public final void setBackgroundVisible(boolean b) {
            QbChartBasic.this.chart.setBackgroundState(b);
        }

        @Override
        public final Color getBackgroundColor() {
            return QbChartBasic.this.chart.getBackground().areaColor;
        }

        @Override
        public final void setBackgroundColor(Color c) {
            QbChartBasic.this.chart.getBackground().areaColor = c;
            if (!QbChartBasic.this.chart.is2DimChart()) {
                QbChartBasic.this.chart.a_x.setColor(c);
            }
        }

        @Override
        public final int getAppearance() {
            return QbChartBasic.this.chart.getBackground().appearance;
        }

        @Override
        public final void setAppearance(int x) {
            QbChartBasic.this.chart.getBackground().appearance = x;
        }

        @Override
        public final int getCutCornerWidth() {
            return QbChartBasic.this.chart.getBackground().getCutCornerWidth();
        }

        @Override
        public final void setCutCornerWidth(int w) {
            QbChartBasic.this.chart.getBackground().setCutCornerWidth(w);
        }

        @Override
        public final int getDepth() {
            return QbChartBasic.this.chart.getBackground().depth;
        }

        @Override
        public final void setDepth(int x) {
            QbChartBasic.this.chart.getBackground().depth = x;
        }

        @Override
        public final void setDialBGState(boolean state) {
            if (QbChartBasic.this.chart.chartType == 17) {
                QbChartBasic.this.chart.setDialPlotBGImageState(state);
            }
        }

        @Override
        public final void setDialBGImage(URL url, String relativeURL, int option) {
            if (QbChartBasic.this.chart.chartType == 17) {
                QbChartBasic.this.chart.setDialPlotBGImage(url, relativeURL, option);
            }
        }

        @Override
        public final void setDialBGRatio(double ratio) {
            if (QbChartBasic.this.chart.chartType == 17) {
                QbChartBasic.this.chart.setDialPlotBGRatio(ratio);
            }
        }

        @Override
        public final void setDialBGImage(URL url, int option) {
            if (QbChartBasic.this.chart.chartType == 17) {
                QbChartBasic.this.chart.setDialPlotBGImage(url, option);
            }
        }

        @Override
        public final boolean getDialBGState() {
            return QbChartBasic.this.chart.getDialPlotBGImageState();
        }

        @Override
        public final URL getDialBGImageURL() {
            return QbChartBasic.this.chart.getDialPlotBGImage().getUrl();
        }

        @Override
        public final String getDialBGImageRelativeURL() {
            return QbChartBasic.this.chart.getDialPlotBGImage().getRelativeUrl();
        }

        @Override
        public final double getDialBGRatio() {
            return QbChartBasic.this.chart.getDialPlotBGRatio();
        }

        @Override
        public final void setDialFGState(boolean state) {
            if (QbChartBasic.this.chart.chartType == 17) {
                QbChartBasic.this.chart.setDialPlotFGImageState(state);
            }
        }

        @Override
        public final void setDialFGImage(URL url, String relativeURL, int option) {
            if (QbChartBasic.this.chart.chartType == 17) {
                QbChartBasic.this.chart.setDialPlotFGImage(url, relativeURL, option);
            }
        }

        @Override
        public final void setDialFGRatio(double ratio) {
            if (QbChartBasic.this.chart.chartType == 17) {
                QbChartBasic.this.chart.setDialPlotFGRatio(ratio);
            }
        }

        @Override
        public final void setDialFGImage(URL url, int option) {
            if (QbChartBasic.this.chart.chartType == 17) {
                QbChartBasic.this.chart.setDialPlotFGImage(url, option);
            }
        }

        @Override
        public final boolean getDialFGState() {
            return QbChartBasic.this.chart.getDialPlotFGImageState();
        }

        @Override
        public final URL getDialFGImageURL() {
            return QbChartBasic.this.chart.getDialPlotFGImage().getUrl();
        }

        @Override
        public final String getDialFGImageRelativeURL() {
            return QbChartBasic.this.chart.getDialPlotFGImage().getRelativeUrl();
        }

        @Override
        public final double getDialFGRatio() {
            return QbChartBasic.this.chart.getDialPlotFGRatio();
        }

        @Override
        public void setGradientEnabled(boolean b) {
            QbChartBasic.this.chart.getBackground().setGradientEnabled(b);
        }

        @Override
        public boolean isGradientEnabled() {
            return QbChartBasic.this.chart.getBackground().isGradientEnabled();
        }

        @Override
        public void set3DShadingEnabled(boolean b) {
            QbChartBasic.this.chart.getBackground().set3DShadingEnabled(b);
        }

        @Override
        public boolean is3DShadingEnabled() {
            return QbChartBasic.this.chart.getBackground().is3DShadingEnabled();
        }

        @Override
        public double getGradientStartX() {
            return QbChartBasic.this.chart.getBackground().getGradientStartX();
        }

        @Override
        public double getGradientStartY() {
            return QbChartBasic.this.chart.getBackground().getGradientStartY();
        }

        @Override
        public double getGradientEndX() {
            return QbChartBasic.this.chart.getBackground().getGradientEndX();
        }

        @Override
        public double getGradientEndY() {
            return QbChartBasic.this.chart.getBackground().getGradientEndY();
        }

        @Override
        public Color getGradientDesColor() {
            return QbChartBasic.this.chart.getBackground().getGradientDesColor();
        }

        @Override
        public int getGradientShade() {
            return QbChartBasic.this.chart.getBackground().getGradientShade();
        }

        @Override
        public boolean isGradientCyclic() {
            return QbChartBasic.this.chart.getBackground().isGradientCyclic();
        }

        @Override
        public void setGradientStartX(double x) {
            QbChartBasic.this.chart.getBackground().setGradientStartX(x);
        }

        @Override
        public void setGradientStartY(double y) {
            QbChartBasic.this.chart.getBackground().setGradientStartY(y);
        }

        @Override
        public void setGradientEndX(double x) {
            QbChartBasic.this.chart.getBackground().setGradientEndX(x);
        }

        @Override
        public void setGradientEndY(double y) {
            QbChartBasic.this.chart.getBackground().setGradientEndY(y);
        }

        @Override
        public void setGradientDesColor(Color c) {
            QbChartBasic.this.chart.getBackground().setGradientDesColor(c);
        }

        @Override
        public void setGradientShade(int s) {
            QbChartBasic.this.chart.getBackground().setGradientShade(s);
        }

        @Override
        public void setGradientCyclic(boolean c) {
            QbChartBasic.this.chart.getBackground().setGradientCyclic(c);
        }
    }

    class CFloatingLineSet
    implements IFloatingLineSet {
        CFloatingLineSet() {
        }

        @Override
        public final void add(PolyLine t) {
            QbChartBasic.this.chart.addLine(t);
        }

        @Override
        public final void remove(PolyLine t) {
            QbChartBasic.this.chart.removeLine(t);
        }

        @Override
        public final void removeAll() {
            QbChartBasic.this.chart.removeAllLine();
        }

        @Override
        public final Enumeration elements() {
            return QbChartBasic.this.chart.getLineList().elements();
        }

        @Override
        public final void set(Enumeration e) {
            Vector<PolyLine> lines = new Vector<PolyLine>();
            while (e.hasMoreElements()) {
                Object x = e.nextElement();
                if (x instanceof PolyLine) {
                    lines.addElement((PolyLine)x);
                    continue;
                }
                throw new IllegalArgumentException("Invalid object type:" + x);
            }
            QbChartBasic.this.chart.setPolyLines(lines);
        }
    }

    class CAnnotationSet
    implements IAnnotationSet {
        CAnnotationSet() {
        }

        @Override
        public Vector getAnnotationList() {
            return QbChartBasic.this.chart.annotationSet.getAnnotationList();
        }

        @Override
        public IAnnotation newAnnotation(String text) {
            return QbChartBasic.this.chart.annotationSet.newAnnotation(text);
        }

        @Override
        public IAnnotation newAnnotation(String[] text) {
            return QbChartBasic.this.chart.annotationSet.newAnnotation(text);
        }

        @Override
        public IAnnotation newAnnotation(String[] text, int[] shape, Color[] color) {
            return QbChartBasic.this.chart.annotationSet.newAnnotation(text, shape, color);
        }

        @Override
        public IAnnotation newAnnotation(String text, IReferenceObj refObj) {
            return QbChartBasic.this.chart.annotationSet.newAnnotation(text, refObj);
        }

        @Override
        public IAnnotation newAnnotation(String[] text, IReferenceObj refObj) {
            return QbChartBasic.this.chart.annotationSet.newAnnotation(text, refObj);
        }

        @Override
        public IAnnotation newAnnotation(String[] text, int[] shape, Color[] color, IReferenceObj refObj) {
            return QbChartBasic.this.chart.annotationSet.newAnnotation(text, shape, color, refObj);
        }

        @Override
        public void addAnnotation(IAnnotation anno) {
            QbChartBasic.this.chart.annotationSet.addAnnotation(anno);
        }

        @Override
        public boolean removeAnnotation(IAnnotation anno) {
            return QbChartBasic.this.chart.annotationSet.removeAnnotation(anno);
        }
    }

    class CDropBarSet
    implements IDropBarSet {
        CDropBarSet() {
        }

        @Override
        public int getSeriesCount() {
            if (QbChartBasic.this.chart.dataDim >= 2) {
                return QbChartBasic.this.chart.mDataLen[0];
            }
            return 0;
        }

        @Override
        public boolean isVisible() {
            return QbChartBasic.this.chart.isShowDropBarForLine();
        }

        @Override
        public void setVisible(boolean b) {
            QbChartBasic.this.chart.setShowDropBarForLine(b);
        }

        @Override
        public boolean isBorderVisible() {
            return QbChartBasic.this.chart.getDropBarBorderState();
        }

        @Override
        public void setBorderVisible(boolean b) {
            QbChartBasic.this.chart.setDropBarBorderState(b);
        }

        @Override
        public Color getUpBarColor() {
            return QbChartBasic.this.chart.getDropBarColor();
        }

        @Override
        public void setUpBarColor(Color c) {
            QbChartBasic.this.chart.setDropBarColor(c);
        }

        @Override
        public Color getDownBarColor() {
            return QbChartBasic.this.chart.getDropBarColor2();
        }

        @Override
        public void setDownBarColor(Color c) {
            QbChartBasic.this.chart.setDropBarColor2(c);
        }

        @Override
        public int[] getSeriesSet() {
            int[] range = new int[]{QbChartBasic.this.chart.getDropBarSeries1(), QbChartBasic.this.chart.getDropBarSeries2()};
            return range;
        }

        @Override
        public void setSeriesSet(int seriesA, int seriesB) {
            QbChartBasic.this.chart.setDropBarSeries1(seriesA);
            QbChartBasic.this.chart.setDropBarSeries2(seriesB);
        }
    }

    class CControlRangeSet
    implements IControlRangeSet {
        CControlRangeSet() {
        }

        @Override
        public int size() {
            return QbChartBasic.this.chart.getControlRangeList().size();
        }

        @Override
        public int indexOf(ControlRange c) {
            return QbChartBasic.this.chart.getControlRangeList().indexOf(c);
        }

        @Override
        public void addElement(ControlRange c) {
            QbChartBasic.this.chart.getControlRangeList().addElement(c);
        }

        @Override
        public ControlRange elementAt(int i) {
            return QbChartBasic.this.chart.getControlRangeList().elementAt(i);
        }

        @Override
        public void insertElementAt(ControlRange c, int i) {
            QbChartBasic.this.chart.getControlRangeList().insertElementAt(c, i);
        }

        @Override
        public void removeAllElements() {
            QbChartBasic.this.chart.getControlRangeList().removeAllElements();
        }

        @Override
        public void removeElement(ControlRange c) {
            QbChartBasic.this.chart.getControlRangeList().removeElement(c);
        }

        @Override
        public void removeElementAt(int i) {
            QbChartBasic.this.chart.getControlRangeList().removeElementAt(i);
        }

        @Override
        public int getThickness() {
            return QbChartBasic.this.chart.getControlRangeThickness();
        }

        @Override
        public void setThickness(int t) {
            QbChartBasic.this.chart.setControlRangeThickness(t);
        }
    }

    class CDataLineSet
    implements IDataLineSet {
        CDataLineSet() {
        }

        @Override
        public ITrendLine newTrendLine(int linetype, int coeff, String title) {
            return QbChartBasic.this.chart.dataLineSet.newTrendLine(linetype, coeff, title);
        }

        @Override
        public IHorzVertLine newHorzVertLine(int linetype, String label) {
            return QbChartBasic.this.chart.dataLineSet.newHorzVertLine(linetype, label);
        }

        @Override
        public IControlLine newControlLine(int linetype, String label) {
            return QbChartBasic.this.chart.dataLineSet.newControlLine(linetype, label);
        }

        @Override
        public IControlLine newControlLine(int linetype, String label, int level) {
            return QbChartBasic.this.chart.dataLineSet.newControlLine(linetype, label, level);
        }

        @Override
        public IFunctionLine newFunctionLine(IFunction function, String label) {
            return QbChartBasic.this.chart.dataLineSet.newFunctionLine(function, label);
        }

        @Override
        public final void add(IDataLine l) {
            QbChartBasic.this.chart.dataLineSet.updateDataLine(l);
        }

        @Override
        public final void remove(IDataLine l) {
            QbChartBasic.this.chart.dataLineSet.removeDataLine(l);
            QbChartBasic.this.setrepaint(!QbChartBasic.this.chart.is2DimChart());
        }

        @Override
        public final void removeAll() {
            QbChartBasic.this.chart.dataLineSet.getDataLineList().removeAllElements();
            QbChartBasic.this.setrepaint(!QbChartBasic.this.chart.is2DimChart());
        }

        @Override
        public final Enumeration elements() {
            return QbChartBasic.this.chart.dataLineSet.getDataLineList().elements();
        }

        @Override
        public final void set(Enumeration e) {
            Vector<DataLine> v = new Vector<DataLine>();
            while (e.hasMoreElements()) {
                v.addElement((DataLine)e.nextElement());
            }
            QbChartBasic.this.chart.dataLineSet.setDataLineList(v);
            QbChartBasic.this.setrepaint(!QbChartBasic.this.chart.is2DimChart());
        }
    }

    class CTrendLineSet
    implements ITrendLineSet {
        CTrendLineSet() {
        }

        @Override
        public ITrendLine newInstance() {
            return QbChartBasic.this.chart.dataLineSet.newTrendLine(QbChartBasic.this.chart);
        }

        @Override
        public final void add(ITrendLine l) {
            QbChartBasic.this.chart.dataLineSet.updateDataLine(l);
        }

        @Override
        public final void remove(ITrendLine l) {
            QbChartBasic.this.chart.dataLineSet.removeDataLine(l);
            QbChartBasic.this.setrepaint(!QbChartBasic.this.chart.is2DimChart());
        }

        @Override
        public final void removeAll() {
            QbChartBasic.this.chart.dataLineSet.getDataLineList().removeAllElements();
            QbChartBasic.this.setrepaint(!QbChartBasic.this.chart.is2DimChart());
        }

        @Override
        public final Enumeration elements() {
            return QbChartBasic.this.chart.dataLineSet.getDataLineList().elements();
        }

        @Override
        public final void set(Enumeration e) {
            Vector<DataLine> v = new Vector<DataLine>();
            while (e.hasMoreElements()) {
                v.addElement((DataLine)e.nextElement());
            }
            QbChartBasic.this.chart.dataLineSet.setDataLineList(v);
            QbChartBasic.this.setrepaint(!QbChartBasic.this.chart.is2DimChart());
        }
    }

    class CHyperLinkSet
    implements IHyperLinkSet {
        CHyperLinkSet() {
        }

        @Override
        public final void add(HyperLink l) {
            if (QbChartBasic.this.chart.chartType == 12) {
                String hint = "";
                if (l.hint != null) {
                    hint = l.hint;
                }
                QbChartBasic.this.chart.addNewSurfaceLink(l.link, l.target, hint, l.xValue, l.zValue);
            } else {
                QbChartBasic.this.chart.updateHyperLink(l);
            }
        }

        @Override
        public final HyperLink match(HyperLink l) {
            if (QbChartBasic.this.chart.chartType == 12) {
                return QbChartBasic.this.chart.closestMatch(l);
            }
            return l.findNewLink(QbChartBasic.this.chart.getHyperLinkList());
        }

        @Override
        public final void remove(HyperLink l) {
            if (QbChartBasic.this.chart.chartType == 12) {
                QbChartBasic.this.chart.removeSurfaceLink(QbChartBasic.this.chart.findSurfaceLink(l));
            } else {
                QbChartBasic.this.chart.removeHyperLink(QbChartBasic.this.chart.findLink(l));
            }
        }

        @Override
        public final void removeAll() {
            if (QbChartBasic.this.chart.chartType == 12) {
                QbChartBasic.this.chart.removeAllSurfaceLink();
            } else {
                QbChartBasic.this.chart.getHyperLinkList().removeAllElements();
            }
        }

        @Override
        public final Enumeration elements() {
            if (QbChartBasic.this.chart.chartType == 12) {
                throw new IllegalArgumentException("elements() not supported for surface chart!");
            }
            return QbChartBasic.this.chart.getHyperLinkList().elements();
        }

        @Override
        public final void set(Enumeration e) {
            Vector v = new Vector();
            while (e.hasMoreElements()) {
                v.addElement(e.nextElement());
            }
            if (QbChartBasic.this.chart.chartType == 12) {
                throw new IllegalArgumentException("Surface chart does not support set(Enumeration e)");
            }
            QbChartBasic.this.chart.setHyperLinkList(QbChartBasic.this.checkHyperLinkList(v));
        }

        @Override
        public final IHint gethHint() {
            return new CHyperLinkHint();
        }
    }

    class CFloatingTextSet
    implements IFloatingTextSet {
        CFloatingTextSet() {
        }

        @Override
        public final void add(ITextString t) {
            QbChartBasic.this.chart.addText(t);
        }

        @Override
        public final void remove(ITextString t) {
            QbChartBasic.this.chart.removeText(t);
        }

        @Override
        public final void removeAll() {
            QbChartBasic.this.chart.getTextList().removeAllElements();
        }

        @Override
        public final Enumeration elements() {
            return QbChartBasic.this.chart.getTextList().elements();
        }

        @Override
        public final void set(Enumeration e) {
            QbChartBasic.this.chart.getTextList().removeAllElements();
            while (e.hasMoreElements()) {
                ITextString t = (ITextString)e.nextElement();
                if (t instanceof TextString) {
                    QbChartBasic.this.chart.addText(((TextString)t).pstring);
                    continue;
                }
                QbChartBasic.this.chart.addText(t);
            }
        }
    }

    class CCanvas
    implements ICanvas {
        CCanvas() {
        }

        @Override
        public final Dimension getSize() {
            return new Dimension(QbChartBasic.this.chart.getSize());
        }

        @Override
        public final void setSize(Dimension d) {
            if (d.width <= 0 || d.height <= 0) {
                throw new IllegalArgumentException("Size must be greater than zero");
            }
            if (QbChartBasic.this.chart.showTable()) {
                QbChartBasic.this.chart.gt.x = (int)((double)QbChartBasic.this.chart.gt.x * ((double)d.width / (double)QbChartBasic.this.chart.winWidth));
                QbChartBasic.this.chart.gt.y = (int)((double)QbChartBasic.this.chart.gt.y * ((double)d.height / (double)QbChartBasic.this.chart.winHeight));
            }
            Dimension od = QbChartBasic.this.chart.getSize();
            float ratio = ((float)(d.width - od.width) / (float)od.width + (float)(d.height - od.height) / (float)od.height) / 2.0f;
            QbChartBasic.this.chart.resizeFont(ratio);
            if (forExportOnly) {
                QbChartBasic.this.chart.setSize(d);
            } else {
                QbChartBasic.this.vpanel.setSize(d);
            }
        }

        @Override
        public final float getFontResizeRatio() {
            return QbChartBasic.this.chart.getFontResizeRatio();
        }

        @Override
        public final void setFontResizeRatio(float ratio) {
            QbChartBasic.this.chart.setFontResizeRatio(ratio);
        }

        @Override
        public final int getScrollBarOption() {
            return QbChartBasic.this.chart.getScrollBarOption();
        }

        @Override
        public final void setScrollBarOption(int option) {
            QbChartBasic.this.chart.setScrollBarOption(option);
            QbChartBasic.this.vpanel3d.setViewPanel(QbChartBasic.this.chart);
        }

        @Override
        public final Component getCanvasArea() {
            return QbChartBasic.this.vpanel;
        }

        @Override
        public final boolean isFitOnCanvas() {
            return QbChartBasic.this.chart.isFitOnCanvas();
        }

        @Override
        public final void setFitOnCanvas(boolean state) {
            QbChartBasic.this.chart.setFitOnCanvas(state);
        }

        @Override
        public final boolean isChartVisible() {
            return QbChartBasic.this.chart.isChartVisible();
        }

        @Override
        public final void setChartVisible(boolean b) {
            QbChartBasic.this.chart.setChartVisible(b);
        }

        @Override
        public final boolean isBackgroundVisible() {
            return QbChartBasic.this.chart.getDesktopArea().drawArea;
        }

        @Override
        public final void setBackgroundVisible(boolean b) {
            QbChartBasic.this.chart.getDesktopArea().drawArea = b;
        }

        @Override
        public final Color getBackgroundColor() {
            return QbChartBasic.this.chart.getDesktopArea().areaColor;
        }

        @Override
        public final void setBackgroundColor(Color c) {
            QbChartBasic.this.chart.getDesktopArea().areaColor = c;
        }

        @Override
        public final URL getBackgroundImageURL() {
            return QbChartBasic.this.chart.getBackgroundImage().getUrl();
        }

        @Override
        public final void setBackgroundImageURL(URL url) {
            QbChartBasic.this.chart.setBackgroundImage(url, 0);
            QbChartBasic.this.chart.getBackgroundImage().setImage(ImageData.retrieveImage(url, (Component)QbChartBasic.this));
        }

        @Override
        public final int getImageMode() {
            return QbChartBasic.this.chart.getBackgroundImage().getOption();
        }

        @Override
        public final void setImageMode(int x) {
            QbChartBasic.this.chart.getBackgroundImage().setOption(x);
        }

        @Override
        public final boolean isReferenceAtTop() {
            return QbChartBasic.this.chart.isReferenceAtTop();
        }

        @Override
        public final void setReferenceAtTop(boolean b) {
            QbChartBasic.this.chart.setReferenceAtTop(b);
        }

        @Override
        public void setGradientEnabled(boolean b) {
            QbChartBasic.this.chart.getDesktopArea().setGradientEnabled(b);
        }

        @Override
        public boolean isGradientEnabled() {
            return QbChartBasic.this.chart.getDesktopArea().isGradientEnabled();
        }

        @Override
        public void set3DShadingEnabled(boolean b) {
            QbChartBasic.this.chart.getDesktopArea().set3DShadingEnabled(b);
        }

        @Override
        public boolean is3DShadingEnabled() {
            return QbChartBasic.this.chart.getDesktopArea().is3DShadingEnabled();
        }

        @Override
        public double getGradientStartX() {
            return QbChartBasic.this.chart.getDesktopArea().getGradientStartX();
        }

        @Override
        public double getGradientStartY() {
            return QbChartBasic.this.chart.getDesktopArea().getGradientStartY();
        }

        @Override
        public double getGradientEndX() {
            return QbChartBasic.this.chart.getDesktopArea().getGradientEndX();
        }

        @Override
        public double getGradientEndY() {
            return QbChartBasic.this.chart.getDesktopArea().getGradientEndY();
        }

        @Override
        public Color getGradientDesColor() {
            return QbChartBasic.this.chart.getDesktopArea().getGradientDesColor();
        }

        @Override
        public int getGradientShade() {
            return QbChartBasic.this.chart.getDesktopArea().getGradientShade();
        }

        @Override
        public boolean isGradientCyclic() {
            return QbChartBasic.this.chart.getDesktopArea().isGradientCyclic();
        }

        @Override
        public void setGradientStartX(double x) {
            QbChartBasic.this.chart.getDesktopArea().setGradientStartX(x);
        }

        @Override
        public void setGradientStartY(double y) {
            QbChartBasic.this.chart.getDesktopArea().setGradientStartY(y);
        }

        @Override
        public void setGradientEndX(double x) {
            QbChartBasic.this.chart.getDesktopArea().setGradientEndX(x);
        }

        @Override
        public void setGradientEndY(double y) {
            QbChartBasic.this.chart.getDesktopArea().setGradientEndY(y);
        }

        @Override
        public void setGradientDesColor(Color c) {
            QbChartBasic.this.chart.getDesktopArea().setGradientDesColor(c);
        }

        @Override
        public void setGradientShade(int s) {
            QbChartBasic.this.chart.getDesktopArea().setGradientShade(s);
        }

        @Override
        public void setGradientCyclic(boolean c) {
            QbChartBasic.this.chart.getDesktopArea().setGradientCyclic(c);
        }
    }

    public class CAxisRuler
    implements IAxisRuler {
        int axisId;

        CAxisRuler(int ax) {
            this.axisId = ax;
        }

        @Override
        public final boolean isVisible() {
            AxisRuler ruler = QbChartBasic.this.vpanel3d.getRuler();
            switch (this.axisId) {
                case 0: {
                    return ruler.isVisibleXRuler();
                }
                case 1: {
                    return ruler.isVisibleYRuler();
                }
                case 3: {
                    return ruler.isVisibleSRuler();
                }
            }
            return false;
        }

        @Override
        public final void setVisible(boolean b) {
            AxisRuler ruler = QbChartBasic.this.vpanel3d.getRuler();
            switch (this.axisId) {
                case 0: {
                    ruler.setVisibleXRuler(b);
                    break;
                }
                case 1: {
                    ruler.setVisibleYRuler(b);
                    break;
                }
                case 3: {
                    ruler.setVisibleSRuler(b);
                }
            }
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean isLabelVisible() {
            AxisRuler ruler = QbChartBasic.this.vpanel3d.getRuler();
            switch (this.axisId) {
                case 0: {
                    return ruler.isVisibleXLabel();
                }
                case 1: {
                    return ruler.isVisibleYLabel();
                }
                case 3: {
                    return ruler.isVisibleSLabel();
                }
            }
            return false;
        }

        @Override
        public final void setLabelVisible(boolean b) {
            AxisRuler ruler = QbChartBasic.this.vpanel3d.getRuler();
            switch (this.axisId) {
                case 0: {
                    ruler.setVisibleXLabel(b);
                    break;
                }
                case 1: {
                    ruler.setVisibleYLabel(b);
                    break;
                }
                case 3: {
                    ruler.setVisibleSLabel(b);
                }
            }
            QbChartBasic.this.setrepaint(true);
        }
    }

    class CAxis
    implements IAxis {
        int axisId;
        int columnIndex;
        boolean isOffsetCalled = false;

        CAxis(int axisId, int columnIndex) {
            this.axisId = axisId;
            this.columnIndex = columnIndex;
        }

        @Override
        public final Color getColor() {
            return QbChartBasic.this.chart.getAxisColor(this.axisId);
        }

        @Override
        public final void setColor(Color c) {
            QbChartBasic.this.chart.setAxisColor(c, this.axisId);
        }

        @Override
        public final boolean hasArrowhead() {
            return QbChartBasic.this.chart.getArrowState();
        }

        @Override
        public final void setArrowhead(boolean b) {
            QbChartBasic.this.chart.setArrowState(b);
        }

        @Override
        public final int getThickness() {
            return QbChartBasic.this.chart.getAxisThickness();
        }

        @Override
        public final void setThickness(int t) {
            QbChartBasic.this.chart.setAxisThickness(t);
        }

        @Override
        public final boolean isVisible() {
            return QbChartBasic.this.chart.getAxisState(this.axisId);
        }

        @Override
        public final void setVisible(boolean b) {
            QbChartBasic.this.chart.setAxisState(this.axisId, b);
        }

        @Override
        public final boolean isScaleAutomatic() {
            return QbChartBasic.this.chart.getAxisAutoScale(this.axisId);
        }

        @Override
        public final void setScaleAutomatic(boolean b) {
            QbChartBasic.this.chart.setAxisAutoScale(this.axisId, b);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean isDisplayLabelAsDate() {
            return QbChartBasic.this.chart.getAxisDisplayLabelAsDate(this.axisId);
        }

        @Override
        public final void setDisplayLabelAsDate(boolean b) {
            QbChartBasic.this.chart.setAxisDisplayLabelAsDate(this.axisId, b);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean isOriginAutomatic() {
            return QbChartBasic.this.chart.getAxisAutoOrigin(this.axisId);
        }

        @Override
        public final void setOriginAutomatic(boolean b) {
            QbChartBasic.this.chart.setAxisAutoOrigin(this.axisId, b);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean isAxisPaddingAdded() {
            return QbChartBasic.this.chart.isAxisPaddingAdded(this.axisId);
        }

        @Override
        public final void setAxisPaddingAdded(boolean b) {
            QbChartBasic.this.chart.setAxisPaddingAdded(this.axisId, b);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean isLogScale() {
            return QbChartBasic.this.chart.getAxisLogScale(this.axisId);
        }

        @Override
        public final void setLogScale(boolean b) {
            QbChartBasic.this.chart.setAxisLogScale(this.axisId, b);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean isShowLogValue() {
            return QbChartBasic.this.chart.isShowLogValue(this.axisId);
        }

        @Override
        public final void setShowLogValue(boolean b) {
            QbChartBasic.this.chart.setShowLogValue(this.axisId, b);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean getLogSubTickersState() {
            return QbChartBasic.this.chart.getLogSubTickersState(this.axisId);
        }

        @Override
        public final void setLogSubTickersState(boolean b) {
            QbChartBasic.this.chart.setLogSubTickersState(this.axisId, b);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final double getBaseForLog() {
            return QbChartBasic.this.chart.getBaseForLog(this.axisId);
        }

        @Override
        public final void setBaseForLog(double b) {
            QbChartBasic.this.chart.setBaseForLog(this.axisId, b);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final ITextString gethTitle() {
            return new ITextString(){

                @Override
                public final String getValue() {
                    return QbChartBasic.this.chart.getAxisTitle(CAxis.this.axisId);
                }

                @Override
                public final void setValue(String value) {
                    QbChartBasic.this.chart.setAxisTitle(value, CAxis.this.axisId);
                }

                @Override
                public final Color getColor() {
                    return QbChartBasic.this.chart.getAxisTitleColor(CAxis.this.axisId);
                }

                @Override
                public final void setColor(Color c) {
                    QbChartBasic.this.chart.setAxisTitleColor(c, CAxis.this.axisId);
                }

                @Override
                public final Font getFont() {
                    return QbChartBasic.this.chart.getAxisTitleFont(CAxis.this.axisId);
                }

                @Override
                public final void setFont(Font f) {
                    QbChartBasic.this.chart.setAxisTitleFont(CAxis.this.axisId, f, this.getAngle());
                }

                @Override
                public final int getAngle() {
                    return QbChartBasic.this.chart.getAxisTitleAngle(CAxis.this.axisId);
                }

                @Override
                public void setAngle(int angle) {
                    QbChartBasic.this.chart.setAxisTitleFont(CAxis.this.axisId, this.getFont(), angle);
                }

                @Override
                public final Dimension getOffset() {
                    return new Dimension(QbChartBasic.this.chart.getAxisTitle_HOffset(CAxis.this.axisId), QbChartBasic.this.chart.getAxisTitle_VOffset(CAxis.this.axisId));
                }

                @Override
                public final void setOffset(Dimension offset) {
                    QbChartBasic.this.chart.setAxisTitle_HOffset(CAxis.this.axisId, offset.width);
                    QbChartBasic.this.chart.setAxisTitle_VOffset(CAxis.this.axisId, offset.height);
                }

                @Override
                public final Position getPosition() {
                    throw new IllegalArgumentException("Get position not supported for axis title.");
                }

                @Override
                public final void setPosition(Position pos) {
                    throw new IllegalArgumentException("Set position not supported for axis title.");
                }
            };
        }

        @Override
        public final ILabel gethLabel() {
            return new ILabel(){

                @Override
                public final Color getColor() {
                    return QbChartBasic.this.chart.getLabelColor(CAxis.this.axisId);
                }

                @Override
                public final void setColor(Color c) {
                    QbChartBasic.this.chart.setLabelColor(CAxis.this.axisId, c);
                }

                @Override
                public final Font getFont() {
                    return QbChartBasic.this.chart.getTickerFont(CAxis.this.axisId);
                }

                @Override
                public void setFont(Font f) {
                    QbChartBasic.this.chart.setTickerFont(CAxis.this.axisId, f, QbChartBasic.this.chart.getTickerAngle(CAxis.this.axisId));
                }

                @Override
                public final int getAngle() {
                    return QbChartBasic.this.chart.getTickerAngle(CAxis.this.axisId);
                }

                @Override
                public void setAngle(int angle) {
                    QbChartBasic.this.chart.setTickerFont(CAxis.this.axisId, QbChartBasic.this.chart.getTickerFont(CAxis.this.axisId), angle);
                }

                @Override
                public final boolean isVisible() {
                    return QbChartBasic.this.chart.getTickerLabelState(CAxis.this.axisId);
                }

                @Override
                public final void setVisible(boolean b) {
                    QbChartBasic.this.chart.setTickerLabelState(CAxis.this.axisId, b);
                }

                @Override
                public final Dimension getOffset() {
                    return new Dimension(QbChartBasic.this.chart.getTickerDisplacement(CAxis.this.axisId), QbChartBasic.this.chart.getTickerWidth(CAxis.this.axisId));
                }

                @Override
                public final void setOffset(Dimension offset) {
                    QbChartBasic.this.chart.setTickerDisplacement(CAxis.this.axisId, offset.width);
                    QbChartBasic.this.chart.setTickerWidth(CAxis.this.axisId, offset.height);
                }

                @Override
                public final IFormat getFormat() {
                    if (CAxis.this.axisId == 1 && QbChartBasic.this.chart.chartType == 11) {
                        return QbChartBasic.this.chart.getSpecNumericFormat();
                    }
                    if (CAxis.this.columnIndex == -1 && QbChartBasic.this.chart.secData != null) {
                        return QbChartBasic.this.chart.secData.dataFormat;
                    }
                    if (CAxis.this.columnIndex > 3 && QbChartBasic.this.chart.axisData != null && QbChartBasic.this.chart.axisData.length < CAxis.this.columnIndex - 4 && QbChartBasic.this.chart.axisData[CAxis.this.columnIndex - 4] != null) {
                        return QbChartBasic.this.chart.axisData[CAxis.this.columnIndex - 4].dataFormat;
                    }
                    return QbChartBasic.this.chart.colData[CAxis.this.columnIndex].dataFormat;
                }

                @Override
                public final void setFormat(IFormat f) {
                    if (CAxis.this.axisId == 1 && QbChartBasic.this.chart.chartType == 11) {
                        QbChartBasic.this.chart.setSpecNumericFormat(f);
                    } else if (CAxis.this.columnIndex == -1 && QbChartBasic.this.chart.secData != null) {
                        QbChartBasic.this.chart.secData.dataFormat = f;
                    } else if (CAxis.this.axisId <= 3) {
                        QbChartBasic.this.chart.colData[CAxis.this.columnIndex].dataFormat = f;
                    } else if (CAxis.this.columnIndex > 3 && QbChartBasic.this.chart.axisData != null) {
                        QbChartBasic.this.chart.axisData[CAxis.this.columnIndex - 4].dataFormat = f;
                    } else {
                        QbChartBasic.this.chart.colData[CAxis.this.columnIndex].dataFormat = f;
                    }
                }
            };
        }

        @Override
        public final int getLabelRowCount() {
            if (this.axisId == 0) {
                return QbChartBasic.this.chart.get_xlabelrow();
            }
            return -1;
        }

        @Override
        public final void setLabelRowCount(int numRows) {
            if (this.axisId != 0) {
                throw new IllegalArgumentException("Rows applicable only to X axis.");
            }
            QbChartBasic.this.chart.set_xlabelrow(numRows);
        }

        @Override
        public final boolean isLabelOutsidePlotArea() {
            if (this.axisId != 0 && this.axisId != 1) {
                return false;
            }
            return QbChartBasic.this.chart.isLabelOutsidePlotArea(this.axisId);
        }

        @Override
        public final void setLabelOutsidePlotArea(boolean b) {
            if (this.axisId != 0 && this.axisId != 1) {
                return;
            }
            QbChartBasic.this.chart.setLabelOutsidePlotArea(this.axisId, b);
        }

        @Override
        public final boolean areTickersVisible() {
            return QbChartBasic.this.chart.getTickerLineState(this.axisId);
        }

        @Override
        public final void setTickersVisible(boolean b) {
            QbChartBasic.this.chart.setTickerLineState(this.axisId, b);
        }

        @Override
        public final boolean areTickersInward() {
            return QbChartBasic.this.chart.isTickerDrawInward(this.axisId);
        }

        @Override
        public final void setTickersInward(boolean b) {
            QbChartBasic.this.chart.setTickerDrawInward(this.axisId, b);
        }

        @Override
        public final Color getTickerColor() {
            return QbChartBasic.this.chart.getTickerColor(this.axisId);
        }

        @Override
        public final void setTickerColor(Color c) {
            QbChartBasic.this.chart.setTickerColor(this.axisId, c);
        }

        @Override
        public final Color getGridColor() {
            return QbChartBasic.this.chart.getGridColor(this.axisId);
        }

        @Override
        public final void setGridColor(Color c) {
            QbChartBasic.this.chart.setGridColor(this.axisId, c);
        }

        @Override
        public final int getGridThickness() {
            return QbChartBasic.this.chart.getGridThickness(this.axisId);
        }

        @Override
        public final void setGridThickness(int t) {
            QbChartBasic.this.chart.setGridThickness(this.axisId, t);
        }

        @Override
        public final int getGridLineStyle() {
            return QbChartBasic.this.chart.getGridLineStyle(this.axisId);
        }

        @Override
        public final void setGridLineStyle(int t) {
            QbChartBasic.this.chart.setGridLineStyle(this.axisId, t);
        }

        @Override
        public final boolean isSkipGridOffset() {
            return QbChartBasic.this.chart.isSkipGridOffset(this.axisId);
        }

        @Override
        public final void setSkipGridOffset(boolean t) {
            QbChartBasic.this.chart.setSkipGridOffset(this.axisId, t);
        }

        @Override
        public final boolean isGridVisible() {
            return QbChartBasic.this.chart.getGridState(this.axisId);
        }

        @Override
        public final void setGridVisible(boolean b) {
            QbChartBasic.this.chart.setGridState(this.axisId, b);
        }

        @Override
        public final double getGridHeightRatio() {
            return QbChartBasic.this.chart.getGridLine2DRatio(this.axisId);
        }

        @Override
        public final void setGridHeightRatio(double b) {
            QbChartBasic.this.chart.setGridLine2DRatio(this.axisId, b);
        }

        @Override
        public final boolean isGridAlignedWithTicker() {
            return QbChartBasic.this.chart.isGridAlignedWithTicker();
        }

        @Override
        public final void setGridAlignedWithTicker(boolean b) {
            QbChartBasic.this.chart.setGridAlignedWithTicker(b);
        }

        @Override
        public final boolean isGridInFront() {
            return QbChartBasic.this.chart.isGridInFront();
        }

        @Override
        public final void setGridInFront(boolean b) {
            QbChartBasic.this.chart.setGridInFront(b);
        }

        @Override
        public final Number getMinScale() {
            return QbChartBasic.this.chart.getAxisMinScale(this.axisId);
        }

        @Override
        public final void setMinScale(Number minScale) {
            QbChartBasic.this.chart.setAxisMinScale(this.axisId, minScale.doubleValue());
            if (!this.isOffsetCalled && !this.isOriginAutomatic()) {
                this.setOriginAutomatic(true);
            }
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final Number getMaxScale() {
            return QbChartBasic.this.chart.getAxisMaxScale(this.axisId);
        }

        @Override
        public final void setMaxScale(Number maxScale) {
            QbChartBasic.this.chart.setAxisMaxScale(this.axisId, maxScale.doubleValue());
            if (!this.isOffsetCalled && !this.isOriginAutomatic()) {
                this.setOriginAutomatic(true);
            }
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final Number getScaleStep() {
            return (double)((long)QbChartBasic.this.chart.getAxisStepMonth(this.axisId) * 732L * 3600000L) + QbChartBasic.this.chart.getAxisStepSize(this.axisId);
        }

        @Override
        public final void setScaleStep(Number step) {
            QbChartBasic.this.chart.setAxisStepSize(this.axisId, step.doubleValue());
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final Number getOffset() {
            if (this.axisId == 0) {
                return QbChartBasic.this.chart.getUserOriginX();
            }
            if (this.axisId == 1) {
                return QbChartBasic.this.chart.getUserOriginY();
            }
            return 0.0;
        }

        @Override
        public final void setOffset(Number num) {
            this.isOffsetCalled = true;
            if (this.isOriginAutomatic()) {
                this.setOriginAutomatic(false);
            }
            if (this.axisId == 0) {
                QbChartBasic.this.chart.setUserOriginX(num.doubleValue());
            } else if (this.axisId == 1) {
                QbChartBasic.this.chart.setUserOriginY(num.doubleValue());
            } else {
                throw new IllegalArgumentException("Offset applicable only to X and Y axes.");
            }
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final Object[] getOriginalTickerLabels(boolean formatedLabel) {
            if (!QbChartBasic.this.chart.isComputed()) {
                QbChartBasic.this.chart.validatePosition();
            }
            return QbChartBasic.this.chart.getOriginalTickerLabels(this.axisId, formatedLabel);
        }

        @Override
        public final int getTickerLabelsCount() {
            return QbChartBasic.this.chart.getOriginalTickerLabels(this.axisId, false).length;
        }

        @Override
        public final void setTickerLabels(String[] label) {
            QbChartBasic.this.chart.setTickerLabels(this.axisId, label);
        }

        @Override
        public final void setDateTimeDisplay(boolean b) {
            QbChartBasic.this.chart.setLabelDateTimeDisplay(this.axisId, b);
        }

        @Override
        public final boolean isDateTimeDisplay() {
            return QbChartBasic.this.chart.isLabelDateTimeDisplay(this.axisId);
        }

        @Override
        public final void setScaleStep(int y, int m, int d, int hr, int min) {
            QbChartBasic.this.chart.setAxisStepSize(this.axisId, y, m, d, hr, min);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final boolean isDisplayByWeek() {
            return QbChartBasic.this.chart.isDisplayByWeek(this.axisId);
        }

        @Override
        public final void setDisplayByWeek(boolean b) {
            QbChartBasic.this.chart.setDisplayByWeek(this.axisId, b);
        }

        @Override
        public final int getTickerStep() {
            return QbChartBasic.this.chart.getTickerStepSizeByAxis(this.axisId);
        }

        @Override
        public final void setTickerStep(int stepSize) {
            QbChartBasic.this.chart.setTickerStepSizeByAxis(this.axisId, stepSize);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public IFormat getLabelFormat() {
            return QbChartBasic.this.chart.getLabelFormatByAxis(this.axisId);
        }

        @Override
        public final void setLabelFormat(IFormat format) {
            QbChartBasic.this.chart.setLabelFormatByAxis(this.axisId, format);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final int getLabelUnit() {
            return QbChartBasic.this.chart.getAxisByID((int)this.axisId).columnField.sepUnit;
        }

        @Override
        public final int getLabelStep() {
            return QbChartBasic.this.chart.getLabelStepSizeByAxis(this.axisId);
        }

        @Override
        public final void setLabelStep(int size) {
            QbChartBasic.this.chart.setLabelStepSizeByAxis(this.axisId, size);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public final int getMaxLabelAndTickerCount() {
            return QbChartBasic.this.chart.getMaxLabelAndTickerCountByAxis(this.axisId);
        }

        @Override
        public final void setMaxLabelAndTickerCount(int size) {
            QbChartBasic.this.chart.setMaxLabelAndTickerCountByAxis(this.axisId, size);
            QbChartBasic.this.setrepaint(true);
        }
    }

    class CLegend
    implements ILegend {
        boolean isPrimary;

        CLegend(boolean primary) {
            this.isPrimary = primary;
        }

        @Override
        public final IText gethText() {
            final Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return new IText(){

                @Override
                public final Color getColor() {
                    return l.getfontColor();
                }

                @Override
                public final void setColor(Color c) {
                    l.setfontColor(c);
                }

                @Override
                public final Font getFont() {
                    return l.getFont();
                }

                @Override
                public final void setFont(Font f) {
                    l.setFont(f, l.getAngle());
                }

                @Override
                public final int getAngle() {
                    return l.getAngle();
                }

                @Override
                public final void setAngle(int angle) {
                    l.setAngle(angle);
                }
            };
        }

        @Override
        public boolean isVisible() {
            return this.isPrimary ? QbChartBasic.this.chart.getLegendState() : QbChartBasic.this.chart.getLegendState2();
        }

        @Override
        public final void setVisible(boolean b) {
            if (this.isPrimary) {
                QbChartBasic.this.chart.setLegendState(b);
            } else {
                QbChartBasic.this.chart.setLegendState2(b);
            }
        }

        @Override
        public final int getAppearance() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.getBackground().getAppearance();
        }

        @Override
        public final void setAppearance(int x) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.getBackground().setAppearance(x);
        }

        @Override
        public final Position getPosition() {
            if (this.isPrimary) {
                return new Position(QbChartBasic.this.chart.getLegendXOffset(), QbChartBasic.this.chart.getLegendYOffset());
            }
            return new Position(QbChartBasic.this.chart.getLegendXOffset2(), QbChartBasic.this.chart.getLegendYOffset2());
        }

        @Override
        public final void setPosition(Position p) {
            if (this.isPrimary) {
                QbChartBasic.this.chart.setLegendXOffset(p.getX());
                QbChartBasic.this.chart.setLegendYOffset(p.getY());
            } else {
                QbChartBasic.this.chart.setLegendXOffset2(p.getX());
                QbChartBasic.this.chart.setLegendYOffset2(p.getY());
            }
        }

        @Override
        public final int getDepth() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.getBackground().depth;
        }

        @Override
        public final void setDepth(int x) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.getBackground().depth = x;
        }

        @Override
        public final int getLayout() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.getLayout();
        }

        @Override
        public final void setLayout(int x) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.setLayout(x);
        }

        @Override
        public final int getNumberOfFixedColumn() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.getNumberOfFixedColumn();
        }

        @Override
        public final void setNumberOfFixedColumn(int val) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.setNumberOfFixedColumn(val);
        }

        @Override
        public final boolean isBackgroundVisible() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.getBackground().drawArea;
        }

        @Override
        public final void setBackgroundVisible(boolean b) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.getBackground().drawArea = b;
        }

        @Override
        public final Color getBackgroundColor() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.getBackground().areaColor;
        }

        @Override
        public final void setBackgroundColor(Color c) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.getBackground().areaColor = c;
        }

        @Override
        public final Color getBorderColor() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.getBorder().areaColor;
        }

        @Override
        public final void setBorderColor(Color c) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.getBorder().areaColor = c;
        }

        @Override
        public final boolean isBorderVisible() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.getBorder().drawBorder;
        }

        @Override
        public final void setBorderVisible(boolean b) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.getBorder().drawBorder = b;
        }

        @Override
        public final int getBorderThickness() {
            return 0;
        }

        @Override
        public final void setBorderThickness(int x) {
        }

        @Override
        public final boolean areLabelsReversed() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.getReverse();
        }

        @Override
        public final void setLabelsReversed(boolean b) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.setReverse(b);
        }

        @Override
        public final boolean[] areItemsHidden(int colIndex) {
            return QbChartBasic.this.chart.getLegendItems(colIndex);
        }

        @Override
        public final void setItemsHidden(int colIndex, boolean[] b) {
            QbChartBasic.this.chart.setLegendItems(colIndex, b);
        }

        @Override
        public final float getRelativeWidth() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return (float)l.getWidth() / (float)QbChartBasic.this.chart.winWidth;
        }

        @Override
        public final void setRelativeWidth(float width) {
            throw new IllegalArgumentException("Resizing not enabled for legend.");
        }

        @Override
        public final float getRelativeHeight() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return (float)l.getHeight() / (float)QbChartBasic.this.chart.winHeight;
        }

        @Override
        public final void setDrawSymbols(boolean drawSym) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.drawSymbols(drawSym);
        }

        @Override
        public final boolean areSymbolsDrawn() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.areSymbolsDrawn();
        }

        @Override
        public final void setDrawSymbolWithLine(boolean drawSymWithLine) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.setDrawSymbolWithLine(drawSymWithLine);
        }

        @Override
        public final boolean isDrawSymbolWithLine() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.isDrawSymbolWithLine();
        }

        @Override
        public final void setRelativeHeight(float height) {
            throw new IllegalArgumentException("Resizing not enabled for legend.");
        }

        @Override
        public final void setSymbolSizeRatio(int ratio) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.setPointSizeRatio(ratio);
        }

        @Override
        public final int getSymbolSizeRatio() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.getPointSizeRatio();
        }

        @Override
        public final int getCutCornerWidth() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.area.getCutCornerWidth();
        }

        @Override
        public final void setCutCornerWidth(int w) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.area.setCutCornerWidth(w);
            l.framearea.setCutCornerWidth(w);
        }

        @Override
        public final void setDialBGState(boolean state) {
        }

        @Override
        public final void setDialBGImage(URL url, String relativeURL, int option) {
        }

        @Override
        public final void setDialBGRatio(double ratio) {
        }

        @Override
        public final void setDialBGImage(URL url, int option) {
        }

        @Override
        public final boolean getDialBGState() {
            return false;
        }

        @Override
        public final URL getDialBGImageURL() {
            return null;
        }

        @Override
        public final String getDialBGImageRelativeURL() {
            return null;
        }

        @Override
        public final double getDialBGRatio() {
            return 0.0;
        }

        @Override
        public final void setDialFGState(boolean state) {
        }

        @Override
        public final void setDialFGImage(URL url, String relativeURL, int option) {
        }

        @Override
        public final void setDialFGRatio(double ratio) {
        }

        @Override
        public final void setDialFGImage(URL url, int option) {
        }

        @Override
        public final boolean getDialFGState() {
            return false;
        }

        @Override
        public final URL getDialFGImageURL() {
            return null;
        }

        @Override
        public final String getDialFGImageRelativeURL() {
            return null;
        }

        @Override
        public final double getDialFGRatio() {
            return 0.0;
        }

        @Override
        public void setGradientEnabled(boolean b) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.area.setGradientEnabled(b);
        }

        @Override
        public boolean isGradientEnabled() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.area.isGradientEnabled();
        }

        @Override
        public void set3DShadingEnabled(boolean b) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.area.set3DShadingEnabled(b);
        }

        @Override
        public boolean is3DShadingEnabled() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.area.is3DShadingEnabled();
        }

        @Override
        public double getGradientStartX() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.area.getGradientStartX();
        }

        @Override
        public double getGradientStartY() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.area.getGradientStartY();
        }

        @Override
        public double getGradientEndX() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.area.getGradientEndX();
        }

        @Override
        public double getGradientEndY() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.area.getGradientEndY();
        }

        @Override
        public Color getGradientDesColor() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.area.getGradientDesColor();
        }

        @Override
        public int getGradientShade() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.area.getGradientShade();
        }

        @Override
        public boolean isGradientCyclic() {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            return l.area.isGradientCyclic();
        }

        @Override
        public void setGradientStartX(double x) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.area.setGradientStartX(x);
        }

        @Override
        public void setGradientStartY(double y) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.area.setGradientStartY(y);
        }

        @Override
        public void setGradientEndX(double x) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.area.setGradientEndX(x);
        }

        @Override
        public void setGradientEndY(double y) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.area.setGradientEndY(y);
        }

        @Override
        public void setGradientDesColor(Color c) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.area.setGradientDesColor(c);
        }

        @Override
        public void setGradientShade(int s) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.area.setGradientShade(s);
        }

        @Override
        public void setGradientCyclic(boolean c) {
            Legend l = this.isPrimary ? QbChartBasic.this.chart.legend : QbChartBasic.this.chart.legend2;
            l.area.setGradientCyclic(c);
        }
    }

    protected class CDataTopLabel2
    implements ILabel {
        protected CDataTopLabel2() {
        }

        @Override
        public final Color getColor() {
            return QbChartBasic.this.chart.getTopValueColor2();
        }

        @Override
        public final void setColor(Color c) {
            QbChartBasic.this.chart.setTopValueColor2(c);
        }

        @Override
        public final Font getFont() {
            return QbChartBasic.this.chart.getTopValueFont2();
        }

        @Override
        public final void setFont(Font f) {
            QbChartBasic.this.chart.setTopValueFont2(f, QbChartBasic.this.chart.getTopValueAngle2());
        }

        @Override
        public final int getAngle() {
            return QbChartBasic.this.chart.getTopValueAngle2();
        }

        @Override
        public final void setAngle(int angle) {
            QbChartBasic.this.chart.setTopValueFont2(QbChartBasic.this.chart.getTopValueFont2(), angle);
        }

        @Override
        public final boolean isVisible() {
            return QbChartBasic.this.chart.getTopValueState2();
        }

        @Override
        public final void setVisible(boolean b) {
            QbChartBasic.this.chart.setTopValueState2(b);
        }

        @Override
        public final Dimension getOffset() {
            return QbChartBasic.this.chart.getTopValueOffset2();
        }

        @Override
        public final void setOffset(Dimension offset) {
            QbChartBasic.this.chart.setTopValueOffset2(offset.width, offset.height);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public IFormat getFormat() {
            throw new IllegalArgumentException("Format not supported for data top labels.");
        }

        @Override
        public void setFormat(IFormat f) {
            throw new IllegalArgumentException("Format not supported for data top labels.");
        }
    }

    protected class CDataTopLabel
    implements ILabel {
        protected CDataTopLabel() {
        }

        @Override
        public final Color getColor() {
            return QbChartBasic.this.chart.getTopValueColor();
        }

        @Override
        public final void setColor(Color c) {
            QbChartBasic.this.chart.setTopValueColor(c);
        }

        @Override
        public final Font getFont() {
            return QbChartBasic.this.chart.getTopValueFont();
        }

        @Override
        public final void setFont(Font f) {
            QbChartBasic.this.chart.setTopValueFont(f, QbChartBasic.this.chart.getTopValueAngle());
        }

        @Override
        public final int getAngle() {
            return QbChartBasic.this.chart.getTopValueAngle();
        }

        @Override
        public final void setAngle(int angle) {
            QbChartBasic.this.chart.setTopValueFont(QbChartBasic.this.chart.getTopValueFont(), angle);
        }

        @Override
        public final boolean isVisible() {
            return QbChartBasic.this.chart.getTopValueState();
        }

        @Override
        public final void setVisible(boolean b) {
            QbChartBasic.this.chart.setTopValueState(b);
        }

        @Override
        public final Dimension getOffset() {
            return QbChartBasic.this.chart.getTopValueOffset();
        }

        @Override
        public final void setOffset(Dimension offset) {
            QbChartBasic.this.chart.setTopValueOffset(offset.width, offset.height);
            QbChartBasic.this.setrepaint(true);
        }

        @Override
        public IFormat getFormat() {
            throw new IllegalArgumentException("Format not supported for data top labels.");
        }

        @Override
        public void setFormat(IFormat f) {
            throw new IllegalArgumentException("Format not supported for data top labels.");
        }
    }

    protected class CNoDataToPlotMessage
    implements INoDataToPlotMessage {
        protected CNoDataToPlotMessage() {
        }

        @Override
        public final Color getColor() {
            return QbChartBasic.this.chart.getNoDataToPlotMessageColor();
        }

        @Override
        public final void setColor(Color c) {
            QbChartBasic.this.chart.setNoDataToPlotMessageColor(c);
        }

        @Override
        public final Font getFont() {
            return QbChartBasic.this.chart.getNoDataToPlotMessageFont();
        }

        @Override
        public final void setFont(Font f) {
            QbChartBasic.this.chart.setNoDataToPlotMessageFont(f);
        }

        @Override
        public final int getAngle() {
            return QbChartBasic.this.chart.getNoDataToPlotMessageAngle();
        }

        @Override
        public final void setAngle(int angle) {
            QbChartBasic.this.chart.setNoDataToPlotMessageAngle(angle);
        }

        @Override
        public final String getMessage() {
            return QbChartBasic.this.chart.getNoDataToPlotMessage();
        }

        @Override
        public final void setMessage(String msg) {
            QbChartBasic.this.chart.setNoDataToPlotMessage(msg);
        }

        @Override
        public final boolean isVisible() {
            return QbChartBasic.this.chart.isNoDataToPlotMessageVisible();
        }

        @Override
        public final void setVisible(boolean b) {
            QbChartBasic.this.chart.setNoDataToPlotMessageVisible(b);
        }
    }

    protected final class CMainTitle
    implements ITextString {
        protected CMainTitle() {
        }

        @Override
        public final String getValue() {
            return QbChartBasic.this.chart.getTitle();
        }

        @Override
        public final void setValue(String value) {
            QbChartBasic.this.chart.setTitle(value);
        }

        @Override
        public final Color getColor() {
            return QbChartBasic.this.chart.getMainTitleColor();
        }

        @Override
        public final void setColor(Color c) {
            QbChartBasic.this.chart.setMainTitleColor(c);
        }

        @Override
        public final Font getFont() {
            return QbChartBasic.this.chart.getMainTitleFont();
        }

        @Override
        public final void setFont(Font f) {
            QbChartBasic.this.chart.setMainTitleFont(f);
        }

        @Override
        public final int getAngle() {
            return QbChartBasic.this.chart.getMainTitleAngle();
        }

        @Override
        public final void setAngle(int angle) {
            QbChartBasic.this.chart.setMainTitleAngle(angle);
        }

        @Override
        public Position getPosition() {
            return new Position(QbChartBasic.this.chart.getTitleXOffset(), QbChartBasic.this.chart.getTitleYOffset());
        }

        @Override
        public final void setPosition(Position pos) {
            QbChartBasic.this.chart.setTitleXOffset(pos.getX());
            QbChartBasic.this.chart.setTitleYOffset(pos.getY());
        }

        @Override
        public final Dimension getOffset() {
            return new Dimension(0, 0);
        }

        @Override
        public final void setOffset(Dimension offset) {
            throw new IllegalArgumentException("Offsets not supported for chart title.");
        }
    }

    class C3DPropertySet
    implements I3DPropertySet {
        C3DPropertySet() {
        }

        @Override
        public int getAnimationSpeed() {
            return (int)(QbChartBasic.this.chart.getAnimateSpeed() * 50.0 / Math.PI);
        }

        @Override
        public void setAnimationSpeed(int value) {
            if (value < 0) {
                throw new IllegalArgumentException("Value must be >= 0");
            }
            QbChartBasic.this.chart.setAnimateSpeed((double)value * Math.PI / 50.0);
        }

        @Override
        public final int getRenderMode() {
            return QbChartBasic.this.chart.get3DDrawType();
        }

        @Override
        public final void setRenderMode(int mode) {
            QbChartBasic.this.chart.set3DDrawType(mode);
        }

        @Override
        public final void setViewDirection(Point_3D[] view) {
            QbChartBasic.this.chart.setViewDirection(view);
        }

        @Override
        public final Point_3D[] getViewDirection() {
            return QbChartBasic.this.chart.getViewDirection();
        }

        @Override
        public final void setViewTranslation(Point_3D p) {
            QbChartBasic.this.chart.setViewTranslation(p);
        }

        @Override
        public final Point_3D getViewTranslation() {
            return QbChartBasic.this.chart.getViewTranslation();
        }

        @Override
        public final void move(boolean rotateMode, int step, int direction) {
            QbChartBasic.this.vpanel3d.getControlPanel().navigate(rotateMode, step, direction);
        }

        @Override
        public final void setLightPosition(Point_3D p) {
            QbChartBasic.this.chart.setLightPosition(p);
        }

        @Override
        public final Point_3D getLightPosition() {
            return QbChartBasic.this.chart.getLightPosition();
        }

        @Override
        public final Color getAmbientLight() {
            return QbChartBasic.this.chart.getAmbientLight();
        }

        @Override
        public final void setAmbientLight(Color c) {
            QbChartBasic.this.chart.setAmbientLight(c);
        }

        @Override
        public final Color getLight() {
            return QbChartBasic.this.chart.getLightIntensity();
        }

        @Override
        public final void setLight(Color light) {
            QbChartBasic.this.chart.setLightIntensity(light);
        }

        @Override
        public int getZoomFactor() {
            return (int)(100.0f * (1.0f - QbChartBasic.this.chart.getZoomfactor() / 4000.0f));
        }

        @Override
        public final void setZoomFactor(int zoom) {
            if (zoom < 0 || zoom >= 100) {
                throw new IllegalArgumentException("The zoom factor must be an integer between 0 and 99");
            }
            QbChartBasic.this.chart.setZoomfactor((float)(1.0 - (double)zoom / 100.0) * 4.0f * 1000.0f);
            if (QbChartBasic.this.vpanel3d != null) {
                QbChartBasic.this.vpanel3d.getControlPanel().setZoomMeter();
            }
        }

        @Override
        public final float getXScale() {
            return QbChartBasic.this.chart.getX_scale();
        }

        @Override
        public final void setXScale(float scale) {
            QbChartBasic.this.chart.scaleSpace(scale, QbChartBasic.this.chart.getY_scale(), QbChartBasic.this.chart.getZ_scale());
            if (QbChartBasic.this.vpanel3d != null) {
                QbChartBasic.this.vpanel3d.getControlPanel().setXScale();
            }
        }

        @Override
        public final float getYScale() {
            return QbChartBasic.this.chart.getY_scale();
        }

        @Override
        public final void setYScale(float scale) {
            QbChartBasic.this.chart.scaleSpace(QbChartBasic.this.chart.getX_scale(), scale, QbChartBasic.this.chart.getZ_scale());
            if (QbChartBasic.this.vpanel3d != null) {
                QbChartBasic.this.vpanel3d.getControlPanel().setYScale();
            }
        }

        @Override
        public final float getZScale() {
            return QbChartBasic.this.chart.getZ_scale();
        }

        @Override
        public final void setZScale(float scale) {
            QbChartBasic.this.chart.scaleSpace(QbChartBasic.this.chart.getX_scale(), QbChartBasic.this.chart.getY_scale(), scale);
            if (QbChartBasic.this.vpanel3d != null) {
                QbChartBasic.this.vpanel3d.getControlPanel().setZScale();
            }
        }

        @Override
        public final float getBarWidthToThicknessRatio() {
            return (float)QbChartBasic.this.chart.getThickRatio();
        }

        @Override
        public final void setBarWidthToThicknessRatio(float d) {
            QbChartBasic.this.chart.setThickRatio(d);
            if (QbChartBasic.this.vpanel3d != null) {
                QbChartBasic.this.vpanel3d.getControlPanel().setThickScale();
            }
        }

        @Override
        public final int getScatterCubeWidth() {
            return QbChartBasic.this.chart.getScatterCubeWidth();
        }

        @Override
        public final void setScatterCubeWidth(int val) {
            QbChartBasic.this.chart.setScatterCubeWidth(val);
        }

        @Override
        public final boolean isWallFrameVisible() {
            return QbChartBasic.this.chart.getWallFrameState();
        }

        @Override
        public final void setWallFrameVisible(boolean b) {
            QbChartBasic.this.chart.setWallFrame(b);
        }

        @Override
        public final Color getWallColor() {
            return QbChartBasic.this.chart.getWallBackground().areaColor;
        }

        @Override
        public final void setWallColor(Color c) {
            QbChartBasic.this.chart.getWallBackground().areaColor = c;
        }

        @Override
        public final ColorSpectrum getColorSpectrum() {
            return QbChartBasic.this.chart.getColorSpectrum();
        }

        @Override
        public void setColorSpectrum(ColorSpectrum colorSpectrum) {
            QbChartBasic.this.chart.setColorSpectrum(colorSpectrum);
        }

        @Override
        public boolean is3DApproximationUsed() {
            return QbChartBasic.this.chart.is3DApproximationUsed;
        }

        @Override
        public void set3DApproximationUsed(boolean state) {
            this.set3DApproximationUsed(state, 100);
        }

        @Override
        public void set3DApproximationUsed(boolean state, int nDataPoint) {
            QbChartBasic.this.chart.is3DApproximationUsed = state;
            QbChartBasic.this.chart.approximationThreshold = nDataPoint;
        }

        @Override
        public int getApproximationThreshold() {
            return QbChartBasic.this.chart.approximationThreshold;
        }

        @Override
        public void useDefault3DDisplayView() {
            QbChartBasic.this.chart.setAdjust3DDisplayView(true);
        }

        @Override
        public boolean isDrawSeriesOnCategoryAxis() {
            return QbChartBasic.this.chart.isDrawSeriesOnCategoryAxis();
        }

        @Override
        public void setDrawSeriesOnCategoryAxis(boolean b) {
            QbChartBasic.this.chart.setDrawSeriesOnCategoryAxis(b);
        }
    }

    protected final class ControlPanel
    implements I3DControlPanel {
        protected ControlPanel() {
        }

        @Override
        public final boolean isVisible() {
            return QbChartBasic.this.vpanel3d.navexist;
        }

        @Override
        public final void setVisible(boolean b) {
            QbChartBasic.this.vpanel3d.setNavControl(b);
        }

        @Override
        public final Color getColor() {
            return QbChartBasic.this.vpanel3d == null ? Color.lightGray : QbChartBasic.this.vpanel3d.getControlPanel().getBackground();
        }

        @Override
        public final void setColor(Color c) {
            if (QbChartBasic.this.vpanel3d.getControlPanel() != null) {
                QbChartBasic.this.vpanel3d.getControlPanel().setBackground(c);
            }
        }

        @Override
        public boolean isGouraudButtonVisible() {
            return QbChartBasic.this.vpanel3d.getControlPanel().getGouraudButton();
        }

        @Override
        public void setGouraudButtonVisible(boolean b) {
            QbChartBasic.this.vpanel3d.getControlPanel().setGouraudButton(b);
        }

        @Override
        public boolean isAnimationButtonVisible() {
            return QbChartBasic.this.vpanel3d.getControlPanel().getAnimateButton();
        }

        @Override
        public void setAnimationButtonVisible(boolean b) {
            QbChartBasic.this.vpanel3d.getControlPanel().setAnimateButton(b);
        }

        @Override
        public void setAnimationButtonOn(boolean b) {
            QbChartBasic.this.vpanel3d.getControlPanel().setAnimationButtonOn(b);
        }

        @Override
        public boolean isSpeedControlVisible() {
            return QbChartBasic.this.vpanel3d.getControlPanel().getSpeedControl();
        }

        @Override
        public void setSpeedControlVisible(boolean b) {
            QbChartBasic.this.vpanel3d.getControlPanel().setSpeedControl(b);
        }

        @Override
        public final void setToggleEnabled(boolean b) {
            QbChartBasic.this.vpanel.btogglepanel = b;
        }

        @Override
        public final boolean isToggleEnabled() {
            return QbChartBasic.this.vpanel.btogglepanel;
        }

        @Override
        public void setToolTipEnabled(boolean b) {
            QbChartBasic.this.vpanel3d.getControlPanel().setToolTipEnabled(b);
        }

        @Override
        public boolean isToolTipEnabled() {
            return QbChartBasic.this.vpanel3d.getControlPanel().isToolTipEnabled();
        }
    }
}

