/*
 * Decompiled with CFR 0.152.
 */
package quadbase.ChartAPI;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import quadbase.ChartAPI.QbChart;
import quadbase.awt.BorderPanel;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ChartPanel;

public class QbChartCustomizer
extends BorderPanel
implements Customizer,
ActionListener,
ItemListener {
    protected PropertyChangeSupport butler = new PropertyChangeSupport(this);
    protected QbChart qbChart;
    protected ChartMain designer;
    protected Button b;
    protected Checkbox serverCheck;

    public QbChartCustomizer() {
        super("EspressChart Customizer ");
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.b = new Button("Show");
        Panel p = new Panel();
        p.setLayout(new GridLayout(2, 1, 5, 5));
        this.serverCheck = new Checkbox("Use chart server", true);
        p.add(this.serverCheck);
        p.add(new Label("Show chart designer : "));
        this.add("Center", p);
        this.add("South", this.b);
        this.designer = new ChartMain(new ChartPanel(null));
        this.designer.setBean(true);
        this.designer.addActionListener((ActionListener)this);
        this.b.addActionListener(this);
        this.serverCheck.addItemListener(this);
        this.designer.init();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 145);
    }

    @Override
    public void setObject(Object bean) {
        try {
            this.qbChart = (QbChart)bean;
        }
        catch (Exception e) {
            System.out.println("Invalid bean object type");
            return;
        }
        if (this.qbChart.chart != null) {
            Chart c = this.qbChart.chart;
            this.designer.setNewChart(Chart.createChart((Component)this.designer.chartPanel, c.getChartType(), c.is2DimChart(), c, null));
        } else {
            System.out.println("Null bean object!");
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.butler.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.butler.removePropertyChangeListener(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.designer) {
            switch (e.getID()) {
                case 0: {
                    this.update();
                    break;
                }
                case 1: {
                    this.reset();
                    break;
                }
            }
        } else if (e.getSource() == this.b) {
            this.designer.setVisible(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.serverCheck) {
            QbChart.setChartServerUsed(this.serverCheck.getState());
        }
    }

    void reset() {
        Chart c = this.qbChart.chart;
        this.designer.setNewChart(Chart.createChart((Component)this.designer.chartPanel, c.getChartType(), c.is2DimChart(), c, null));
    }

    void update() {
        Chart c = this.designer.getChart();
        this.qbChart.setChart(Chart.createChart((Component)this.designer.chartPanel, c.getChartType(), c.is2DimChart(), c, null));
        this.qbChart.vpanel3d.filename = this.designer.getChartFile();
        this.qbChart.vpanel3d.setNavControl(this.designer.showNavButtons());
        this.qbChart.repaint();
        this.butler.firePropertyChange(null, null, null);
    }
}

