/*
 * Decompiled with CFR 0.152.
 */
package quadbase.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;

public class BorderPanel
extends Panel {
    public static final int SOLID = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int IN = 3;
    public static final int OUT = 4;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int DEFAULT_STYLE = 3;
    public static final int DEFAULT_THICKNESS = 10;
    public static final int DEFAULT_SOLID_THICKNESS = 4;
    public static final int DEFAULT_RAISED_THICKNESS = 2;
    public static final int DEFAULT_LOWERED_THICKNESS = 2;
    public static final int DEFAULT_IN_THICKNESS = 10;
    public static final int DEFAULT_OUT_THICKNESS = 10;
    public static final int DEFAULT_GAP = 5;
    public static final Color DEFAULT_COLOR = Color.black;
    public static final Font DEFAULT_FONT = new Font("Dialog", 0, 14);
    public static final int DEFAULT_ALIGNMENT = 0;
    private int style = 3;
    private int thickness = 10;
    private int gap = 5;
    private Color color = DEFAULT_COLOR;
    private Font font = DEFAULT_FONT;
    private String text = null;
    private int alignment = 0;

    public BorderPanel() {
    }

    public BorderPanel(String text) {
        this();
        this.style = 3;
        this.text = text;
    }

    public BorderPanel(Color color, int thickness) {
        this();
        this.style = 0;
        this.color = color;
        this.thickness = thickness;
    }

    public BorderPanel(int style) {
        this();
        int thickness;
        switch (style) {
            case 0: {
                thickness = 4;
                break;
            }
            case 1: 
            case 2: {
                thickness = 2;
                break;
            }
            default: {
                thickness = 10;
            }
        }
        this.style = style;
        this.thickness = thickness;
    }

    public BorderPanel(int style, int thickness) {
        this();
        this.style = style;
        this.thickness = thickness;
    }

    @Override
    public Insets getInsets() {
        int adjustment = 0;
        if ((this.style == 3 || this.style == 4) && this.text != null && this.text.length() > 0) {
            try {
                Graphics graphics = this.getGraphics();
                int height = graphics.getFontMetrics(this.font).getHeight();
                if (height > this.thickness) {
                    adjustment = height - this.thickness;
                }
                graphics.dispose();
            }
            catch (Exception graphics) {
                // empty catch block
            }
        }
        int dist = this.thickness + this.gap;
        return new Insets(dist + adjustment, dist, dist, dist);
    }

    public BorderPanel setStyle(int style) {
        this.style = style;
        this.doLayout();
        this.repaint();
        return this;
    }

    public int getStyle() {
        return this.style;
    }

    public BorderPanel setThickness(int thickness) {
        if (thickness > 0) {
            this.thickness = thickness;
            this.doLayout();
            this.repaint();
        }
        return this;
    }

    public int getThickness() {
        return this.thickness;
    }

    public BorderPanel setGap(int gap) {
        if (gap > -1) {
            this.gap = gap;
            this.doLayout();
            this.repaint();
        }
        return this;
    }

    public int getGap() {
        return this.gap;
    }

    public BorderPanel setColor(Color color) {
        this.color = color;
        if (this.style == 0 || this.style == 3 || this.style == 4) {
            this.repaint();
        }
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public BorderPanel setTextFont(Font font) {
        if (font != null) {
            this.font = font;
            if (this.style == 3 || this.style == 4) {
                this.doLayout();
                this.repaint();
            }
        }
        return this;
    }

    public Font getTextFont() {
        return this.font;
    }

    public BorderPanel setText(String text) {
        this.text = text;
        if (this.style == 3 || this.style == 4) {
            this.doLayout();
            this.repaint();
        }
        return this;
    }

    public String getText() {
        return this.text;
    }

    public BorderPanel setAlignment(int alignment) {
        this.alignment = alignment;
        if (this.style == 3 || this.style == 4) {
            this.doLayout();
            this.repaint();
        }
        return this;
    }

    public int getAlignment() {
        return this.alignment;
    }

    @Override
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        int width = size.width;
        int height = size.height;
        Color light = this.getBackground().brighter().brighter().brighter();
        Color dark = this.getBackground().darker().darker();
        switch (this.style) {
            case 1: 
            case 2: {
                int i;
                Color topleft = null;
                Color bottomright = null;
                if (this.style == 1) {
                    topleft = light;
                    bottomright = dark;
                } else {
                    topleft = dark;
                    bottomright = light;
                }
                g.setColor(topleft);
                for (i = 0; i < this.thickness; ++i) {
                    g.drawLine(i, i, width - i - 2, i);
                    g.drawLine(i, i + 1, i, height - i - 1);
                }
                g.setColor(bottomright);
                for (i = 0; i < this.thickness; ++i) {
                    g.drawLine(i + 1, height - i - 1, width - i - 1, height - i - 1);
                    g.drawLine(width - i - 1, i, width - i - 1, height - i - 2);
                }
                break;
            }
            case 3: 
            case 4: {
                int adjust1 = 0;
                int adjust2 = 0;
                Font oldfont = g.getFont();
                g.setFont(this.font);
                FontMetrics fm = g.getFontMetrics();
                int ascent = fm.getAscent();
                if (this.style == 3) {
                    adjust1 = 1;
                } else {
                    adjust2 = 1;
                }
                int adjustment = 0;
                if (this.text != null && this.text.length() > 0 && ascent > this.thickness) {
                    adjustment = (ascent - this.thickness) / 2;
                }
                int x = this.thickness / 2;
                int y = this.thickness / 2 + adjustment;
                int w = width - this.thickness - 1;
                int h = height - this.thickness - 1 - adjustment;
                g.setColor(light);
                g.drawRect(x + adjust1, y + adjust1, w, h);
                g.setColor(dark);
                g.drawRect(x + adjust2, y + adjust2, w, h);
                if (this.text != null && this.text.length() > 0) {
                    int offset;
                    int textwidth;
                    int fontheight = fm.getHeight();
                    int strwidth = fm.stringWidth(this.text);
                    if (strwidth > (textwidth = width - 2 * (this.thickness + 5))) {
                        strwidth = textwidth;
                    }
                    switch (this.alignment) {
                        case 1: {
                            offset = (width - strwidth) / 2;
                            break;
                        }
                        case 2: {
                            offset = width - strwidth - this.thickness - 5;
                            break;
                        }
                        default: {
                            offset = this.thickness + 5;
                        }
                    }
                    g.clearRect(offset - 5, 0, strwidth + 10, fontheight);
                    g.clipRect(offset, 0, strwidth, fontheight);
                    g.setColor(this.color);
                    g.drawString(this.text, offset, ascent);
                    g.clipRect(0, 0, width, height);
                }
                g.setFont(oldfont);
                break;
            }
            default: {
                g.setColor(this.color);
                for (int i = 0; i < this.thickness; ++i) {
                    g.drawRect(i, i, width - 2 * i - 1, height - 2 * i - 1);
                }
            }
        }
    }
}

