/*
 * Decompiled with CFR 0.152.
 */
package quadbase.awt;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import quadbase.awt.CanvasAction;

public class ImageLabel
extends CanvasAction {
    protected Image image;
    public static String defaultImageString = "http://java.sun.com/lib/images/logo.java.color-transp.55x60.gif";
    protected String imageString = "<Existing Image>";
    protected int margin = 0;
    protected Color marginColor = null;
    protected int width;
    protected int height;
    protected boolean explicitSize = false;
    private int explicitWidth = 0;
    private int explicitHeight = 0;
    private MediaTracker tracker;
    private static int lastTrackerID = 0;
    private int currentTrackerID;
    private boolean doneLoading = false;
    private Container parentContainer;

    public ImageLabel() {
        this(defaultImageString);
    }

    public ImageLabel(String imageURLString) {
        this(ImageLabel.makeURL(imageURLString));
    }

    public ImageLabel(String imageString, boolean isURL) {
        this(isURL ? ImageLabel.getImage(ImageLabel.makeURL(imageString)) : ImageLabel.getImage(imageString));
    }

    public ImageLabel(URL imageURL) {
        this(ImageLabel.getImage(imageURL));
        this.imageString = imageURL.toExternalForm();
    }

    public ImageLabel(Image image) {
        this.image = image;
        this.tracker = new MediaTracker(this);
        this.currentTrackerID = lastTrackerID++;
        this.tracker.addImage(image, this.currentTrackerID);
        this.waitForImage(false);
    }

    public void waitForImage(boolean doLayout) {
        if (!this.doneLoading) {
            try {
                this.tracker.waitForID(this.currentTrackerID);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                System.out.println("Error loading " + this.imageString + ": " + e.getMessage());
            }
            if (this.tracker.isErrorID(0)) {
                new Throwable("Error loading image " + this.imageString).printStackTrace();
            }
            this.doneLoading = true;
            this.width = this.explicitWidth != 0 ? this.explicitWidth : this.image.getWidth(this) + 2 * this.margin;
            this.height = this.explicitHeight != 0 ? this.explicitHeight : this.image.getHeight(this) + 2 * this.margin;
            this.setSize(this.width, this.height);
            this.parentContainer = this.getParent();
            if (this.parentContainer != null && doLayout) {
                this.setBackground(this.parentContainer.getBackground());
                this.parentContainer.doLayout();
            }
        }
    }

    public void centerAt(int x, int y) {
        this.setLocation(x - this.width / 2, y - this.height / 2);
    }

    @Override
    public synchronized boolean contains(int x, int y) {
        return x >= 0 && x <= this.width && y >= 0 && y <= this.height;
    }

    @Override
    public void paint(Graphics g) {
        if (!this.doneLoading) {
            this.waitForImage(true);
        } else {
            if (this.explicitSize) {
                g.drawImage(this.image, this.margin, this.margin, this.width - 2 * this.margin, this.height - 2 * this.margin, this);
            } else {
                g.drawImage(this.image, this.margin, this.margin, this);
            }
            this.drawRect(g, 0, 0, this.width - 1, this.height - 1, this.margin, this.marginColor);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.doneLoading) {
            this.waitForImage(false);
        }
        return new Dimension(this.width, this.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setSize(int width, int height) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (width > 0) {
                this.explicitWidth = width;
            }
            if (height > 0) {
                this.explicitHeight = height;
            }
        }
        super.setSize(width, height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (!this.doneLoading) {
            this.explicitSize = true;
            if (width > 0) {
                this.explicitWidth = width;
            }
            if (height > 0) {
                this.explicitHeight = height;
            }
        }
        super.setBounds(x, y, width, height);
    }

    protected void drawRect(Graphics g, int left, int top, int width, int height, int lineThickness, Color rectangleColor) {
        g.setColor(rectangleColor);
        for (int i = 0; i < lineThickness; ++i) {
            g.drawRect(left, top, width, height);
            if (i >= lineThickness - 1) continue;
            ++left;
            ++top;
            width -= 2;
            height -= 2;
        }
    }

    private static URL makeURL(String s) {
        URL u = null;
        try {
            u = new URL(s);
        }
        catch (MalformedURLException m) {
            System.out.println("Bad URL " + s + ": " + m);
            m.printStackTrace();
        }
        return u;
    }

    private static Image getImage(Object url) {
        if (url instanceof URL) {
            return Toolkit.getDefaultToolkit().getImage((URL)url);
        }
        return Toolkit.getDefaultToolkit().getImage((String)url);
    }
}

