/*
 * Decompiled with CFR 0.152.
 */
package quadbase.awt;

import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import quadbase.awt.CanvasAction;

public class SlideBar
extends CanvasAction {
    private transient int last;
    private double max;
    private double min;
    private double value;
    private boolean vertical;
    private String hintText;
    private AppletContext app = null;
    private transient double s;
    private transient int width;
    private transient int height;
    private transient int slidemax;
    private transient int slidemin;

    public SlideBar(double min, double max, boolean vertical) {
        this.vertical = vertical;
        this.max = max;
        this.value = this.min = min;
        this.addMouseMotionListener(this);
    }

    public void setValue(double value) {
        this.value = Math.max(this.min, Math.min(value, this.max));
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
            graphics.dispose();
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public double getValue() {
        return this.value;
    }

    private void setparam() {
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.slidemax = (this.vertical ? this.height : this.width) - 4;
        this.slidemin = 4;
        this.s = (double)(this.slidemax - this.slidemin) / (this.max - this.min);
    }

    @Override
    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        this.setparam();
        if (this.width * this.height <= 0) {
            return;
        }
        Image offScreenImage = this.createImage(this.width, this.height);
        Graphics backbuffer = offScreenImage.getGraphics();
        backbuffer.setColor(this.getBackground());
        backbuffer.fillRect(0, 0, this.width, this.height);
        if (this.vertical) {
            int p = (int)((double)this.slidemin + (this.max - this.value) * this.s);
            this.drawRectangle(backbuffer, this.width / 2 - 1, this.slidemin, 2, this.slidemax);
            backbuffer.setColor(Color.lightGray);
            backbuffer.fill3DRect(this.width / 2 - 4, p - 2, 8, 4, true);
        } else {
            int p = (int)((double)this.slidemin + (this.value - this.min) * this.s);
            this.drawRectangle(backbuffer, this.slidemin, this.height / 2 - 1, this.slidemax, 2);
            backbuffer.setColor(Color.lightGray);
            backbuffer.fill3DRect(p - 2, this.height / 2 - 4, 4, 8, true);
        }
        g.drawImage(offScreenImage, 0, 0, this);
    }

    private void drawRectangle(Graphics g, int x, int y, int width, int height) {
        g.setColor(Color.gray);
        g.fillRect(x, y, width, height);
        g.setColor(Color.darkGray);
        g.drawLine(x, y, x + width, y);
        g.drawLine(x, y, x, y + height);
        g.setColor(Color.white);
        g.drawLine(x + width, y, x + width, y + height);
        g.drawLine(x, y + height, x + width, y + height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.vertical ? new Dimension(10, 30) : new Dimension(50, 10);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.last = this.vertical ? e.getY() : e.getX();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.setparam();
        this.value = this.vertical ? (this.value += (double)(this.last - y) / this.s) : (this.value += (double)(x - this.last) / this.s);
        this.setValue(this.value);
        this.last = this.vertical ? y : x;
        this.fireEvent(this, 1);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.fireEvent(this, 0);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.app != null) {
            this.app.showStatus(this.hintText);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.app != null) {
            this.app.showStatus("");
        }
    }

    public final void setHint(AppletContext app, String hintText) {
        this.app = app;
        this.hintText = hintText;
    }
}

