/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.lib3d.HiddenSurface;

public class AddOnChart {
    Chart[] charts = null;
    Chart baseChart;

    public AddOnChart(Chart baseChart, Chart[] charts) {
        this.charts = charts;
        this.baseChart = baseChart;
    }

    public int size() {
        if (this.charts == null) {
            return 0;
        }
        return this.charts.length;
    }

    public void addChart(CGraphics graphics) {
        for (Chart chart : this.charts) {
            this.setPosition(chart, graphics);
            if (this.baseChart.is2DimChart() && chart.is2DimChart()) {
                chart.drawChart(graphics);
                chart.drawLabel(graphics);
                continue;
            }
            ((Chart3D)chart).hiddenSurface.draw(graphics, ((Chart3D)chart).space);
        }
    }

    private void setPosition(Chart chart, CGraphics graphics) {
        chart.chart_XProp = this.baseChart.chart_XProp;
        chart.chart_YProp = this.baseChart.chart_YProp;
        chart.chart_widthProp = this.baseChart.chart_widthProp;
        chart.chart_heightProp = this.baseChart.chart_heightProp;
        if (Chart.isCoordinateType(this.baseChart.getChartType()) && Chart.isCoordinateType(chart.getChartType())) {
            this.setAxisScale(chart, 0);
            this.setAxisScale(chart, 1);
            if (!this.baseChart.is2DimChart() && !chart.is2DimChart()) {
                this.setAxisScale(chart, 2);
            }
        } else {
            int axisID = this.getAxisID();
            if (axisID != -1) {
                this.setAxisScale(chart, axisID);
            }
        }
        if (!this.baseChart.is2DimChart() && !chart.is2DimChart()) {
            this.set3DProperties((Chart3D)this.baseChart, (Chart3D)chart);
        }
        chart.calculatePosition(graphics.g, this.baseChart.component, this.baseChart.winWidth, this.baseChart.winHeight);
    }

    private void set3DProperties(Chart3D baseChart, Chart3D chart) {
        if (chart.a_x != null) {
            chart.a_x.bshow = false;
        }
        if (chart.a_y != null) {
            chart.a_y.bshow = false;
        }
        if (chart.a_z != null) {
            chart.a_z.bshow = false;
        }
        if (chart.a_s != null) {
            chart.a_s.bshow = false;
        }
        chart.setViewPoint(baseChart.getViewPoint());
        chart.setViewDirection(baseChart.getViewDirection());
        chart.setViewTranslate(baseChart.getViewTranslate());
        chart.setViewTranslation(baseChart.getViewTranslation());
        chart.setLightPos(baseChart.getLightPos());
        chart.setLightPosition(baseChart.getLightPosition());
        chart.setAmbientLight(baseChart.getAmbientLight());
        chart.setAmbient(baseChart.getAmbient());
        chart.setIntensity(baseChart.getIntensity());
        chart.setLightIntensity(baseChart.getLightIntensity());
        chart.setZoomfactor(baseChart.getZoomfactor());
        if (chart.thickRatio != baseChart.thickRatio) {
            chart.thickRatio = baseChart.thickRatio;
            ((HiddenSurface)chart.gethiddenSurface()).reset();
        }
        if (chart.xscale != baseChart.xscale || chart.yscale != baseChart.yscale || chart.zscale != baseChart.zscale) {
            chart.scaleSpace(baseChart.xscale, baseChart.yscale, baseChart.zscale);
        }
    }

    private int getAxisID() {
        int type = this.baseChart.getChartType();
        if (type == 0 || type == 3 || type == 4 || type == 7 || type == 8 || type == 9 || type == 10 || type == 11 || type == 14 || type == 2) {
            return 1;
        }
        if (type == 1 || type == 5) {
            return 0;
        }
        return -1;
    }

    private void setAxisScale(Chart chart, int axisID) {
        chart.setAxisAutoScale(axisID, false);
        chart.setAxisMinScale(axisID, this.baseChart.getAxisMinScale(axisID));
        chart.setAxisMaxScale(axisID, this.baseChart.getAxisMaxScale(axisID));
        chart.setAxisStepSize(axisID, this.baseChart.getAxisStepSize(axisID));
        chart.setAxisAutoOrigin(axisID, false);
        if (axisID == 0) {
            chart.setUserOriginX(this.baseChart.getUserOriginX());
        } else if (axisID == 1) {
            chart.setUserOriginY(this.baseChart.getUserOriginY());
        }
    }
}

