/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Chart;
import quadbase.chart.DrillDownNode;
import quadbase.chart.GradientSupport;
import quadbase.chart.HintInterface;
import quadbase.chart.ImageMapNode;
import quadbase.chart.Line;
import quadbase.chart.MultiDimData;
import quadbase.chart.QbPattern;
import quadbase.common.awt.Arc;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.output.pdf.PdfGraphics2D;
import quadbase.util.HyperLink;
import quadbase.util.IGradientSupport;
import quadbase.util.PickData;
import quadbase.util.internal.Graphics2DTool;
import quadbase.util.internal.IWMFGraphics;
import quadbase.util.internal.RenderingChart;

public class CGraphics {
    private static final Logger LOGGER = Logger.getLogger(CGraphics.class.getName());
    public int height;
    public int width;
    public Graphics g;
    public Chart chart;
    public Component component;
    boolean reverse = true;
    public boolean imagemap = false;
    public static boolean drillDownMap = false;
    public static boolean fieldDrillDownMap = false;
    public static boolean qbImageMap = false;
    public Vector<ImageMapNode> maplist;
    public int minX = -1;
    public int minY = -1;
    public int maxX;
    public int maxY;
    private static final int UP = 1;
    private static final int DOWN = 2;

    public CGraphics(Graphics _g, Component _component, int _h, int _w, Chart _chart) {
        this.component = _component != null ? _component : ServerMessage.getComponent();
        this.height = _h;
        this.width = _w;
        this.g = _g != null ? _g : IOUtil.getOffScreenGraphics();
        this.chart = _chart;
    }

    public void setX(int x) {
        if (this.minX == -1) {
            this.minX = x;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (x < this.minX) {
            this.minX = x;
        }
    }

    public void setY(int y) {
        if (this.minY == -1) {
            this.minY = y;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (y < this.minY) {
            this.minY = y;
        }
    }

    public final void showHint(String s) {
        if (this.component == null) {
            return;
        }
        if (this.component instanceof HintInterface) {
            ((HintInterface)((Object)this.component)).displayHint(s);
        }
    }

    public final void enableImageMap() {
        this.imagemap = true;
        if (this.maplist == null) {
            this.maplist = new Vector();
        }
    }

    public final void drawLine(GeneralPath path, int thickness) {
        this.drawLine(path, thickness, null);
    }

    public final void drawLine(GeneralPath path, int thickness, float[] dash) {
        boolean state = Graphics2DTool.drawShape(this.g, path, thickness, dash);
        if (!state) {
            PathIterator it = path.getPathIterator(null);
            float[] af = new float[6];
            int prevX = 0;
            int prevY = 0;
            while (!it.isDone()) {
                switch (it.currentSegment(af)) {
                    case 1: {
                        this.fillLine(prevX, prevY, (int)af[0], (int)((float)this.height - af[1]), thickness);
                        break;
                    }
                }
                prevX = (int)af[0];
                prevY = (int)((float)this.height - af[1]);
                it.next();
            }
        }
    }

    public final void fillArea(int x, int y, int x2, int y2, int appear) {
        this.fillArea(x, y, x2, y2, appear, 1, null, false, 0, null);
    }

    public final void fillArea(int x, int y, int x2, int y2, int appear, int depth, MultiDimData data, boolean cutCorner, int cutArea, IGradientSupport gradientSupport) {
        this.setX(x);
        this.setY(y);
        this.setX(x2);
        this.setY(y2);
        if (this.reverse) {
            if (y > y2) {
                if (x2 > x) {
                    this.fillRect(x, this.height - y, x2 - x, y - y2, appear, depth, data, cutCorner, cutArea, gradientSupport);
                } else {
                    this.fillRect(x2, this.height - y, x - x2, y - y2, appear, depth, data, cutCorner, cutArea, gradientSupport);
                }
            } else if (x2 > x) {
                this.fillRect(x, this.height - y2, x2 - x, y2 - y, appear, depth, data, cutCorner, cutArea, gradientSupport);
            } else {
                this.fillRect(x2, this.height - y2, x - x2, y2 - y, appear, depth, data, cutCorner, cutArea, gradientSupport);
            }
        } else if (y > y2) {
            if (x2 > x) {
                this.fillRect(x, y, x2 - x, y - y2, appear, depth, data, cutCorner, cutArea, gradientSupport);
            } else {
                this.fillRect(x2, y, x - x2, y - y2, appear, depth, data, cutCorner, cutArea, gradientSupport);
            }
        } else if (x2 > x) {
            this.fillRect(x, y2, x2 - x, y2 - y, appear, depth, data, cutCorner, cutArea, gradientSupport);
        } else {
            this.fillRect(x2, y2, x - x2, y2 - y, appear, depth, data, cutCorner, cutArea, gradientSupport);
        }
    }

    public final boolean containsArea(int x, int y, int x2, int y2, int nX, int nY) {
        if (this.reverse) {
            if (y > y2) {
                if (x2 > x) {
                    return new Rectangle(x, this.height - y, x2 - x, y - y2).contains(nX, nY);
                }
                return new Rectangle(x2, this.height - y, x - x2, y - y2).contains(nX, nY);
            }
            if (x2 > x) {
                return new Rectangle(x, this.height - y2, x2 - x, y2 - y).contains(nX, nY);
            }
            return new Rectangle(x2, this.height - y2, x - x2, y2 - y).contains(nX, nY);
        }
        if (y > y2) {
            if (x2 > x) {
                return new Rectangle(x, y, x2 - x, y - y2).contains(nX, nY);
            }
            return new Rectangle(x2, y, x - x2, y - y2).contains(nX, nY);
        }
        if (x2 > x) {
            return new Rectangle(x, y2, x2 - x, y2 - y).contains(nX, nY);
        }
        return new Rectangle(x2, y2, x - x2, y2 - y).contains(nX, nY);
    }

    public void fillRect(int x, int y, int w, int h) {
        this.g.fillRect(x, y, w, h);
    }

    public void drawRect(int x, int y, int w, int h) {
        this.g.drawRect(x, y, w, h);
    }

    final void fillRect(int x, int y, int w, int h, int appear) {
        this.fillRect(x, y, w, h, appear, 1, null);
    }

    private void fillRect(int x, int y, int w, int h, int appear, int depth, MultiDimData data) {
        this.fillRect(x, y, w, h, appear, depth, data, false, 0, null);
    }

    final void fillRect(int x, int y, int w, int h, int appear, int depth, MultiDimData data, boolean cutCorner, int cutArea, IGradientSupport gradientSupport) {
        boolean setToolTipsForFlash = false;
        if (data != null) {
            HyperLink lnk;
            if (this.imagemap && (lnk = CGraphics.getLink(data)) != null) {
                this.maplist.addElement(new ImageMapNode(new Rectangle(x, y, w, h), lnk.link, lnk.target, lnk.hint));
            }
            if (this.g instanceof IFlashGraphics) {
                ((IFlashGraphics)((Object)this.g)).setToolTipsAndLink(data);
                setToolTipsForFlash = true;
            }
        }
        if (w <= 1) {
            if (w > 0 || h > 0) {
                this.g.drawLine(x, y, x, y + h);
            }
            if (setToolTipsForFlash) {
                ((IFlashGraphics)((Object)this.g)).resetToolTipsAndLink();
            }
            return;
        }
        if (h <= 1) {
            this.g.drawLine(x, y, x + w, y);
            if (setToolTipsForFlash) {
                ((IFlashGraphics)((Object)this.g)).resetToolTipsAndLink();
            }
            return;
        }
        switch (appear) {
            case 1: {
                Color gColor;
                if (depth == 1) {
                    gColor = this.g.getColor();
                    if (gColor instanceof QbPattern && ((QbPattern)gColor).getPatternTypeID() != 0 || gradientSupport != null && (gradientSupport.isGradientEnabled() || gradientSupport.is3DShadingEnabled())) {
                        this.fill2DPatternRect(this.g, x, y, w, h, true, gradientSupport);
                        break;
                    }
                    if (gradientSupport != null && (gradientSupport.isGradientEnabled() || gradientSupport.is3DShadingEnabled())) {
                        Graphics2DTool.fillGradient3DRect(this.g, gradientSupport, gColor, x, y, w, h, true);
                        break;
                    }
                    this.g.fill3DRect(x, y, w, h, true);
                    break;
                }
                this.fill3DEffectRect(x, y, w, h, true, depth, gradientSupport);
                break;
            }
            case 2: {
                Color gColor;
                if (depth == 1) {
                    gColor = this.g.getColor();
                    if (gColor instanceof QbPattern && ((QbPattern)gColor).getPatternTypeID() != 0 || gradientSupport != null && (gradientSupport.isGradientEnabled() || gradientSupport.is3DShadingEnabled())) {
                        this.fill2DPatternRect(this.g, x, y, w, h, false, gradientSupport);
                        break;
                    }
                    if (gradientSupport != null && (gradientSupport.isGradientEnabled() || gradientSupport.is3DShadingEnabled())) {
                        Graphics2DTool.fillGradient3DRect(this.g, gradientSupport, gColor, x, y, w, h, false);
                        break;
                    }
                    this.g.fill3DRect(x, y, w, h, false);
                    break;
                }
                this.fill3DEffectRect(x, y, w, h, false, depth, gradientSupport);
                break;
            }
            case 3: {
                Color c = this.g.getColor();
                this.g.setColor(Color.black);
                this.g.fillRect(x + depth, y + depth, w, h);
                if (c instanceof QbPattern && ((QbPattern)c).getPatternTypeID() != 0) {
                    Graphics2DTool.fillPatternRect(this.g, (QbPattern)c, x, y, w, h);
                    break;
                }
                if (gradientSupport != null && (gradientSupport.isGradientEnabled() || gradientSupport.is3DShadingEnabled())) {
                    Graphics2DTool.fillGradientRect(this.g, this.chart, gradientSupport, c, x, y, w, h);
                    break;
                }
                this.g.setColor(c);
                this.g.fillRect(x, y, w, h);
                break;
            }
            case 4: {
                int nPoint = 6;
                int[] xPoints = new int[nPoint];
                int[] yPoints = new int[nPoint];
                int idx = 0;
                if (cutCorner) {
                    xPoints[idx] = x + cutArea;
                    yPoints[idx++] = y;
                    xPoints[idx] = x;
                    yPoints[idx++] = y + cutArea;
                }
                xPoints[idx] = x;
                yPoints[idx++] = y + h;
                if (cutCorner) {
                    xPoints[idx] = x + w - cutArea;
                    yPoints[idx++] = y + h;
                    xPoints[idx] = x + w;
                    yPoints[idx++] = y + h - cutArea;
                }
                xPoints[idx] = x + w;
                yPoints[idx++] = y;
                Color c = this.g.getColor();
                Polygon p = new Polygon(xPoints, yPoints, nPoint);
                if (c instanceof QbPattern && ((QbPattern)c).getPatternTypeID() != 0) {
                    Graphics2DTool.fillPatternPolygon(this.g, (QbPattern)c, p);
                    break;
                }
                if (gradientSupport != null && (gradientSupport.isGradientEnabled() || gradientSupport.is3DShadingEnabled())) {
                    Graphics2DTool.fillGradientPolygon(this.g, this.chart, c, p, gradientSupport);
                    break;
                }
                this.g.setColor(c);
                this.g.fillPolygon(xPoints, yPoints, nPoint);
                break;
            }
            default: {
                Color gColor = this.g.getColor();
                if (gColor instanceof QbPattern && ((QbPattern)gColor).getPatternTypeID() != 0) {
                    Graphics2DTool.fillPatternRect(this.g, (QbPattern)gColor, x, y, w, h);
                    break;
                }
                if (gradientSupport != null && (gradientSupport.isGradientEnabled() || gradientSupport.is3DShadingEnabled())) {
                    Graphics2DTool.fillGradientRect(this.g, this.chart, gradientSupport, gColor, x, y, w, h);
                    break;
                }
                this.g.fillRect(x, y, w, h);
            }
        }
        if (setToolTipsForFlash) {
            ((IFlashGraphics)((Object)this.g)).resetToolTipsAndLink();
        }
    }

    final void fill2DPatternRect(Graphics g, int x, int y, int w, int h, boolean raise, IGradientSupport gradientSupport) {
        Color gColor = g.getColor();
        if (!(gColor instanceof QbPattern) && !gradientSupport.isGradientEnabled() && !gradientSupport.is3DShadingEnabled() || g instanceof IWMFGraphics) {
            LOGGER.fine("CGraphics.fill3DTextureRext:: Error in casting");
            g.fill3DRect(x, y, w, h, raise);
            return;
        }
        if (gColor instanceof QbPattern) {
            if (((QbPattern)gColor).getPatternTypeID() != 0) {
                Graphics2DTool.fillPatternRect(g, (QbPattern)gColor, x, y, w, h);
            } else if (((QbPattern)gColor).getPatternImage() != null) {
                Graphics2DTool.fillPatternRect(g, (QbPattern)gColor, x, y, w, h);
            } else {
                Graphics2DTool.fillGradientRect(g, this.chart, gradientSupport, gColor, x, y, w, h);
            }
        } else {
            Graphics2DTool.fillGradientRect(g, this.chart, gradientSupport, gColor, x, y, w, h);
        }
        --w;
        --h;
        if (raise) {
            g.setColor(gColor.brighter());
            g.drawLine(x, y, x + w, y);
            g.setColor(gColor.darker());
            g.drawLine(x + w, y, x + w, y + h);
            g.drawLine(x, y + h, x + w, y + h);
            g.setColor(gColor.brighter());
            g.drawLine(x, y, x, y + h);
        } else {
            g.setColor(gColor.darker());
            g.drawLine(x, y, x + w, y);
            g.drawLine(x, y, x, y + h);
            g.setColor(gColor.brighter());
            g.drawLine(x + w, y, x + w, y + h);
            g.drawLine(x, y + h, x + w, y + h);
        }
    }

    private void fill3DEffectRect(int x, int y, int w, int h, boolean raise, int depth, IGradientSupport gradientSupport) {
        if (gradientSupport != null && (gradientSupport.isGradientEnabled() || gradientSupport.is3DShadingEnabled())) {
            Graphics2DTool.fillGradientRect(this.g, this.chart, gradientSupport, this.g.getColor(), x, y, w, h);
        } else {
            this.g.fillRect(x, y, w, h);
        }
        Color c = this.g.getColor();
        this.g.setColor(raise ? c.brighter() : c.darker());
        int[] xp = new int[4];
        int[] yp = new int[4];
        xp[0] = x - depth;
        yp[0] = y - depth;
        xp[1] = x + w + depth;
        yp[1] = y - depth;
        xp[2] = x + w;
        yp[2] = y;
        xp[3] = x;
        yp[3] = y;
        Polygon p = new Polygon(xp, yp, 4);
        if (gradientSupport != null && (gradientSupport.isGradientEnabled() || gradientSupport.is3DShadingEnabled())) {
            Graphics2DTool.fillGradientPolygon(this.g, this.chart, this.g.getColor(), p, gradientSupport);
        } else {
            this.g.fillPolygon(p);
        }
        xp[1] = x;
        yp[1] = y;
        xp[2] = x;
        yp[2] = y + h;
        xp[3] = x - depth;
        yp[3] = y + h + depth;
        p = new Polygon(xp, yp, 4);
        if (gradientSupport != null && (gradientSupport.isGradientEnabled() || gradientSupport.is3DShadingEnabled())) {
            Graphics2DTool.fillGradientPolygon(this.g, this.chart, this.g.getColor(), p, gradientSupport);
        } else {
            this.g.fillPolygon(p);
        }
        this.g.setColor(raise ? c.darker() : c.brighter());
        xp[0] = x + w;
        yp[0] = y + h;
        xp[1] = x + w + depth;
        yp[1] = y + h + depth;
        xp[2] = xp[3];
        yp[2] = yp[3];
        xp[3] = x;
        yp[3] = y + h;
        p = new Polygon(xp, yp, 4);
        if (gradientSupport != null && (gradientSupport.isGradientEnabled() || gradientSupport.is3DShadingEnabled())) {
            Graphics2DTool.fillGradientPolygon(this.g, this.chart, this.g.getColor(), p, gradientSupport);
        } else {
            this.g.fillPolygon(p);
        }
        xp[3] = xp[1];
        yp[3] = yp[1];
        xp[1] = x + w;
        yp[1] = y;
        xp[2] = x + w + depth;
        yp[2] = y - depth;
        p = new Polygon(xp, yp, 4);
        if (gradientSupport != null && (gradientSupport.isGradientEnabled() || gradientSupport.is3DShadingEnabled())) {
            Graphics2DTool.fillGradientPolygon(this.g, this.chart, this.g.getColor(), p, gradientSupport);
        } else {
            this.g.fillPolygon(p);
        }
        this.g.setColor(c);
    }

    public final void drawBorder(int x, int y, int x2, int y2, int thickness, boolean cutCorner, int cornerArea) {
        if (x == 0 && x2 == 0 || y == 0 && y2 == 0) {
            return;
        }
        if (y == y2) {
            this.drawLine(x, y, x2 - 1, y);
            return;
        }
        if (y > y2) {
            if (x2 > x) {
                this.drawRects(x, this.height - y, x2 - x, y - y2, thickness, cutCorner, cornerArea);
            } else {
                this.drawRects(x2, this.height - y, x - x2, y - y2, thickness, cutCorner, cornerArea);
            }
        } else if (x2 > x) {
            this.drawRects(x, this.height - y2, x2 - x, y2 - y, thickness, cutCorner, cornerArea);
        } else {
            this.drawRects(x2, this.height - y2, x - x2, y2 - y, thickness, cutCorner, cornerArea);
        }
    }

    private void drawRects(int x, int y, int w, int h, int thickness, boolean cutCorner, int cornerArea) {
        int initX = x + thickness / 2;
        int initY = y + thickness / 2;
        int initH = h - thickness;
        int initW = w - thickness;
        for (int i = 0; i < thickness; ++i) {
            int dx = initX - i;
            int dy = initY - i;
            int dh = initH + 2 * i;
            int dw = initW + 2 * i;
            if (dx < 0) {
                dw += dx;
                dx = 0;
            }
            if (dy < 0) {
                dh += dy;
                dy = 0;
            }
            this.drawRect(this.g, dx, dy, dw, dh, cutCorner, cornerArea);
        }
    }

    private void drawRect(Graphics g, int x, int y, int w, int h, boolean cutCorner, int cutArea) {
        if (cutCorner) {
            int nPoint = 6;
            int[] xPoints = new int[nPoint];
            int[] yPoints = new int[nPoint];
            int idx = 0;
            if (cutCorner) {
                xPoints[idx] = x + cutArea;
                yPoints[idx++] = y;
                xPoints[idx] = x;
                yPoints[idx++] = y + cutArea;
            }
            xPoints[idx] = x;
            yPoints[idx++] = y + h;
            if (cutCorner) {
                xPoints[idx] = x + w - cutArea;
                yPoints[idx++] = y + h;
                xPoints[idx] = x + w;
                yPoints[idx++] = y + h - cutArea;
            }
            xPoints[idx] = x + w;
            yPoints[idx++] = y;
            g.drawPolygon(xPoints, yPoints, nPoint);
        } else {
            g.drawRect(x, y, w, h);
        }
    }

    final void drawOval(int x, int y, int x2, int y2) {
        if (y > y2) {
            if (x2 > x) {
                this.g.drawOval(x, this.height - y, x2 - x, y - y2);
            } else {
                this.g.drawOval(x2, this.height - y, x - x2, y - y2);
            }
        } else if (x2 > x) {
            this.g.drawOval(x, this.height - y2, x2 - x, y2 - y);
        } else {
            this.g.drawOval(x2, this.height - y2, x - x2, y2 - y);
        }
    }

    final void fillOval(int x, int y, int x2, int y2, MultiDimData data, boolean show3DEffect) {
        int x3;
        int x1;
        int y3;
        int y1;
        if (y > y2) {
            y1 = this.height - y;
            y3 = y - y2;
            if (x2 > x) {
                x1 = x;
                x3 = x2 - x;
            } else {
                x1 = x2;
                x3 = x - x2;
            }
        } else {
            y1 = this.height - y2;
            y3 = y2 - y;
            if (x2 > x) {
                x1 = x;
                x3 = x2 - x;
            } else {
                x1 = x2;
                x3 = x - x2;
            }
        }
        Color c = this.g.getColor();
        boolean setToolTipsForFlash = false;
        if (data != null) {
            HyperLink lnk;
            if (this.imagemap && (lnk = CGraphics.getLink(data)) != null) {
                this.maplist.addElement(new ImageMapNode(new Arc(x1, y1, x3, y3, 0, 360), lnk.link, lnk.target, lnk.hint));
            }
            if (this.g instanceof IFlashGraphics) {
                ((IFlashGraphics)((Object)this.g)).setToolTipsAndLink(data);
                setToolTipsForFlash = true;
            }
        }
        GradientSupport gradientSupport = null;
        if (data != null) {
            GradientSupport gradientSupport2 = gradientSupport = data.isPrimary() ? this.chart.getPrimaryDataGradientSupport() : this.chart.getSecondaryDataGradientSupport();
        }
        if (c instanceof QbPattern) {
            if (((QbPattern)c).getPatternTypeID() != 0) {
                Graphics2DTool.fillPatternOval(this.g, (QbPattern)c, x1, y1, x3, y3);
            } else if (((QbPattern)c).getPatternImage() != null) {
                Graphics2DTool.fillPatternOval(this.g, (QbPattern)c, x1, y1, x3, y3);
            } else if (gradientSupport != null && gradientSupport.isGradientEnabled()) {
                Graphics2DTool.fillGradientOval(this.g, this.chart, c, x1, y1, x3, y3, gradientSupport);
            } else {
                this.g.fillOval(x1, y1, x3, y3);
            }
        } else if (gradientSupport != null && gradientSupport.isGradientEnabled()) {
            Graphics2DTool.fillGradientOval(this.g, this.chart, c, x1, y1, x3, y3, gradientSupport);
        } else {
            this.g.fillOval(x1, y1, x3, y3);
        }
        if (show3DEffect) {
            this.g.setColor(c.brighter());
            this.g.drawArc(x1, y1, x3, y3, 45, 180);
            this.g.setColor(c.darker());
            this.g.drawArc(x1, y1, x3 - 1, y3 - 1, 45, -180);
            this.g.setColor(c);
        }
        if (setToolTipsForFlash) {
            ((IFlashGraphics)((Object)this.g)).resetToolTipsAndLink();
        }
    }

    public final void setColor(Color c) {
        this.g.setColor(c);
    }

    public final void fillLine(int x1, int y1, int x2, int y2, int thick, int style) {
        this.fillLine(x1, y1, x2, y2, thick, null, style, false);
    }

    public final void fillLine(int x1, int y1, int x2, int y2, int thick) {
        this.fillLine(x1, y1, x2, y2, thick, null, 0, false);
    }

    public final void fillLine(int x1, int y1, int x2, int y2, int thick, MultiDimData data) {
        this.fillLine(x1, y1, x2, y2, thick, data, 0, false);
    }

    public final void fillLine(int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style, boolean drawBorder) {
        this.fillLine(x1, y1, x2, y2, thick, data, style, drawBorder, true);
    }

    public final void fillLine(int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style) {
        this.fillLine(x1, y1, x2, y2, thick, data, style, false);
    }

    public final void fillLine(int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style, boolean drawBorder, boolean draw3DRect) {
        this.fillLine(x1, y1, x2, y2, thick, data, style, drawBorder, draw3DRect, Color.black);
    }

    public final void fillLine(int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style, boolean drawBorder, boolean draw3DRect, Color borderColor) {
        this.fillLine(x1, y1, x2, y2, thick, data, style, drawBorder, draw3DRect, borderColor, false);
    }

    public final void fillLine(int x1, int y1, int x2, int y2, int thick, MultiDimData data, int style, boolean drawBorder, boolean draw3DRect, Color borderColor, boolean useLineStyle) {
        this.setX(x1);
        this.setX(x2);
        this.setY(y1);
        this.setY(y2);
        if (this.reverse) {
            y1 = this.height - y1;
            y2 = this.height - y2;
        }
        if (style == 0) {
            Line.drawLine(this, x1, y1, x2, y2, thick, this.g.getColor(), data, drawBorder, draw3DRect, borderColor);
        } else {
            Line.drawLine(this, x1, y1, x2, y2, thick, this.g.getColor(), data, style, borderColor, useLineStyle);
        }
    }

    public final void drawLine(int x1, int y1, int x2, int y2) {
        this.setX(x1);
        this.setX(x2);
        this.setY(y1);
        this.setY(y2);
        if (this.reverse) {
            y1 = this.height - y1;
            y2 = this.height - y2;
        }
        this.g.drawLine(x1, y1, x2, y2);
    }

    public final void drawArrow(int x1, int y1, int x2, int y2, int thick) {
        Graphics2DTool.drawArrow(this.g, this.height, x1, y1, x2, y2, thick);
    }

    public final void fillArc(int x, int y, int width, int height2, int startAngle, int arcAngle, MultiDimData data, boolean drawDataBorder, boolean showBlackLine) {
        this.fillArc(x, y, width, height2, startAngle, arcAngle, data, drawDataBorder, showBlackLine, Color.black);
    }

    public final void fillArc(int x, int y, int width, int height2, int startAngle, int arcAngle, MultiDimData data, boolean drawDataBorder, boolean showBlackLine, Color borderColor) {
        if (data != null) {
            HyperLink lnk;
            if (this.imagemap && (lnk = CGraphics.getLink(data)) != null) {
                this.maplist.addElement(new ImageMapNode(new Arc(x, this.height - y, width, height2, startAngle, arcAngle), lnk.link, lnk.target, lnk.hint));
            }
            if (this.g instanceof IFlashGraphics) {
                ((IFlashGraphics)((Object)this.g)).setToolTipsAndLink(data);
            }
        }
        int x2 = Math.round((float)x - (float)width / 2.0f);
        int y2 = Math.round((float)(this.height - y) - (float)height2 / 2.0f);
        Color gColor = this.g.getColor();
        if (gColor instanceof QbPattern) {
            if (((QbPattern)gColor).getPatternTypeID() != 0) {
                Graphics2DTool.fillPatternArc(this.g, (QbPattern)gColor, x2, y2, width, height2, startAngle, arcAngle);
            } else if (((QbPattern)gColor).getPatternImage() != null) {
                Graphics2DTool.fillPatternArc(this.g, (QbPattern)gColor, x2, y2, width, height2, startAngle, arcAngle);
            } else if (this.chart.getPrimaryDataGradientSupport().isGradientEnabled()) {
                Graphics2DTool.fillGradientArc(this.g, this.chart, gColor, x2, y2, width, height2, startAngle, arcAngle);
            } else {
                this.g.fillArc(x2, y2, width, height2, startAngle, arcAngle);
            }
        } else if (this.chart.getPrimaryDataGradientSupport().isGradientEnabled()) {
            Graphics2DTool.fillGradientArc(this.g, this.chart, gColor, x2, y2, width, height2, startAngle, arcAngle);
        } else {
            this.g.fillArc(x2, y2, width, height2, startAngle, arcAngle);
        }
        if (drawDataBorder) {
            boolean showLines;
            this.g.setColor(borderColor);
            boolean bl = showLines = showBlackLine && (arcAngle != 0 && arcAngle != 360 || this.chart.getRadialBorderState());
            if (this.g instanceof Graphics2D && showLines) {
                Graphics2D g2d = (Graphics2D)this.g;
                Stroke oldStroke = g2d.getStroke();
                g2d.setStroke(new BasicStroke(1.0f, 0, 1));
                g2d.draw(new Arc2D.Double(x2, y2, width, height2, startAngle, arcAngle, 2));
                g2d.setStroke(oldStroke);
            } else {
                this.g.drawArc(x2, y2, width, height2, startAngle, arcAngle);
                double a = (double)(arcAngle + startAngle) * Math.PI / 180.0;
                if (!showLines) {
                    return;
                }
                this.drawColorLine(x, y, (int)Math.round((double)x + (double)width * Math.cos(a) / 2.0), (int)Math.round((double)y + (double)height2 * Math.sin(a) / 2.0), borderColor);
                a = (double)startAngle * Math.PI / 180.0;
                this.drawColorLine(x, y, (int)Math.round((double)x + (double)width * Math.cos(a) / 2.0), y + (int)Math.round((double)height2 * Math.sin(a) / 2.0), borderColor);
            }
        }
        if (this.g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)this.g)).resetToolTipsAndLink();
        }
    }

    public final void fillDoughnutArc(int x, int y, int w, int h, int startAngle, int arcAngle, MultiDimData data, boolean drawDataBorder, boolean showBlackLine, Color borderColor, int arcLenRatio) {
        boolean setToolTipsForFlash = false;
        if (data != null) {
            HyperLink lnk;
            if (this.imagemap && (lnk = CGraphics.getLink(data)) != null) {
                this.maplist.addElement(new ImageMapNode(new Arc(x, this.height - y, w, h, startAngle, arcAngle, arcLenRatio), lnk.link, lnk.target, lnk.hint));
            }
            if (this.g instanceof IFlashGraphics) {
                ((IFlashGraphics)((Object)this.g)).setToolTipsAndLink(data);
                setToolTipsForFlash = true;
            }
        }
        int x2 = Math.round((float)x - (float)w / 2.0f);
        int y2 = Math.round((float)(this.height - y) - (float)h / 2.0f);
        int arcLen = w * arcLenRatio / 100 / 2;
        Color gColor = this.g.getColor();
        GeneralPath path = null;
        path = gColor instanceof QbPattern && (((QbPattern)gColor).getPatternTypeID() != 0 || ((QbPattern)gColor).getPatternImage() != null) ? Graphics2DTool.fillPatternOpenArc(this.g, (QbPattern)gColor, x2, y2, w, h, startAngle, arcAngle, arcLen, this.chart.desktopArea.areaColor) : (this.chart.getPrimaryDataGradientSupport().isGradientEnabled() ? Graphics2DTool.fillGradientOpenArc(this.g, this.chart, gColor, x2, y2, w, h, startAngle, arcAngle, arcLen, this.chart.desktopArea.areaColor) : Graphics2DTool.fillOpenArc(this.g, x2, y2, w, h, startAngle, arcAngle, arcLen, this.chart.desktopArea.areaColor));
        if (drawDataBorder) {
            this.g.setColor(borderColor);
            if (path != null && this.g instanceof Graphics2D) {
                ((Graphics2D)this.g).draw(path);
            } else {
                this.g.drawArc(x2, y2, w, h, startAngle, arcAngle);
                this.g.drawArc(x2 + arcLen, y2 + arcLen, w - 2 * arcLen, h - 2 * arcLen, startAngle, arcAngle);
                double a = (double)(arcAngle + startAngle) * Math.PI / 180.0;
                if (!showBlackLine || (arcAngle == 0 || arcAngle == 360) && !this.chart.getRadialBorderState()) {
                    return;
                }
                this.drawColorLine((int)Math.round((double)x + ((double)w - 2.0 * (double)arcLen) * Math.cos(a) / 2.0), (int)Math.round((double)y + ((double)h - 2.0 * (double)arcLen) * Math.sin(a) / 2.0), (int)Math.round((double)x + (double)w * Math.cos(a) / 2.0), (int)Math.round((double)y + (double)h * Math.sin(a) / 2.0), borderColor);
                a = (double)startAngle * Math.PI / 180.0;
                this.drawColorLine((int)Math.round((double)x + (double)(w - 2 * arcLen) * Math.cos(a) / 2.0), (int)Math.round((double)y + (double)(h - 2 * arcLen) * Math.sin(a) / 2.0), (int)Math.round((double)x + (double)w * Math.cos(a) / 2.0), y + (int)Math.round((double)h * Math.sin(a) / 2.0), borderColor);
            }
        }
        if (setToolTipsForFlash) {
            ((IFlashGraphics)((Object)this.g)).resetToolTipsAndLink();
        }
    }

    public final void drawArc(int x, int y, int width, int height2, int startAngle, int arcAngle) {
        this.g.drawArc(x - width / 2, this.height - y - height2 / 2, width, height2, startAngle, arcAngle);
    }

    final void setFont(Font f, boolean unicode) {
        if (this.g instanceof PdfGraphics2D) {
            ((PdfGraphics2D)this.g).setFont(f, unicode);
        } else {
            this.g.setFont(f);
        }
    }

    public final FontMetrics getFontMetrics(Font f) {
        if (this.g instanceof PdfGraphics2D) {
            return IOUtil.getOffScreenGraphics().getFontMetrics(f);
        }
        return this.g.getFontMetrics(f);
    }

    final void drawString(String str, int x, int y) {
        if (this.chart != null && this.chart.getStringCustomizer() != null) {
            str = this.chart.getStringCustomizer().encodeString(str);
        }
        boolean restoreRendering = false;
        if (this.chart != null && this.chart.isAntiAliasForText() && !this.chart.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.chart.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(this.g, this.chart.renderingKey, this.chart.renderingValue);
        }
        if (this.reverse) {
            this.g.drawString(str, x, this.height - y);
        } else {
            this.g.drawString(str, x, y);
        }
        if (restoreRendering) {
            this.chart.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(this.g, this.chart.renderingKey, this.chart.renderingValue);
        }
    }

    public final void fillPolygon(Polygon p, MultiDimData data) {
        GradientSupport gradientSupport = null;
        if (data != null) {
            gradientSupport = this.chart.getPrimaryDataGradientSupport();
            if (data.isSecondary()) {
                gradientSupport = this.chart.getSecondaryDataGradientSupport();
            }
        }
        this.fillPolygon(p, data, gradientSupport);
    }

    public final void fillPolygon(Polygon p, MultiDimData data, IGradientSupport gradientSupport) {
        int[] yp = new int[p.npoints];
        for (int i = 0; i < p.npoints; ++i) {
            yp[i] = this.height - p.ypoints[i];
        }
        Polygon q = new Polygon(p.xpoints, yp, p.npoints);
        Color gColor = this.g.getColor();
        boolean setToolTipsForFlash = false;
        if (data != null) {
            HyperLink lnk;
            if (this.imagemap && (lnk = CGraphics.getLink(data)) != null) {
                this.maplist.addElement(new ImageMapNode(q, lnk.link, lnk.target, lnk.hint));
            }
            if (this.g instanceof IFlashGraphics) {
                setToolTipsForFlash = true;
                ((IFlashGraphics)((Object)this.g)).setToolTipsAndLink(data);
            }
        }
        if (gColor instanceof QbPattern) {
            if (((QbPattern)gColor).getPatternTypeID() != 0) {
                Graphics2DTool.fillPatternPolygon(this.g, (QbPattern)gColor, q);
            } else if (((QbPattern)gColor).getPatternImage() != null) {
                Graphics2DTool.fillPatternPolygon(this.g, (QbPattern)gColor, q);
            } else if (gradientSupport != null && gradientSupport.isGradientEnabled()) {
                Graphics2DTool.fillGradientPolygon(this.g, this.chart, gColor, q, gradientSupport);
            } else {
                this.g.fillPolygon(q);
            }
        } else if (gradientSupport != null && gradientSupport.isGradientEnabled()) {
            Graphics2DTool.fillGradientPolygon(this.g, this.chart, gColor, q, gradientSupport);
        } else {
            this.g.fillPolygon(q);
        }
        if (setToolTipsForFlash) {
            ((IFlashGraphics)((Object)this.g)).resetToolTipsAndLink();
        }
    }

    public boolean setPolygonLink(Polygon q, MultiDimData data) {
        if (data != null) {
            HyperLink lnk;
            if (this.imagemap && (lnk = CGraphics.getLink(data)) != null) {
                this.maplist.addElement(new ImageMapNode(q, lnk.link, lnk.target, lnk.hint));
            }
            if (this.g instanceof IFlashGraphics) {
                ((IFlashGraphics)((Object)this.g)).setToolTipsAndLink(data);
                return true;
            }
        }
        return false;
    }

    public void resetPolygonLink() {
        if (this.g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)this.g)).resetToolTipsAndLink();
        }
    }

    final void fillPolygon(Polygon p) {
        this.fillPolygon(p, null);
    }

    public static final HyperLink getLink(MultiDimData data) {
        return CGraphics.getLink(data, false);
    }

    public static final HyperLink getLink(MultiDimData data, boolean forLegend) {
        HyperLink lnk;
        if (data == null) {
            return null;
        }
        String str = data.chart.getInformation(data);
        str = data.chart.customizeImageMapDataHintBox(str);
        if (data.plotData != null && !data.plotData.isPieOthersSector()) {
            if (fieldDrillDownMap) {
                return CGraphics.getFieldDrillDownLink(data.chart, data.chart.pickdata);
            }
            if (drillDownMap) {
                HyperLink lnk2 = CGraphics.getDrillDownLink(data.chart.pickdata);
                lnk2.target = data.chart.getHtmlTarget();
                return lnk2;
            }
            int[] rptMapping = data.chart.getReportDrillDownMapping();
            if (rptMapping != null) {
                return CGraphics.getReportDrillDownLink(data.chart, data.chart.pickdata, rptMapping, data.chart.getReportDrillDownLinkPrefix());
            }
        }
        HyperLink newLink = new HyperLink(data.chart.pickdata);
        if (forLegend && data.chart.dataDim > 1) {
            newLink.category = "";
        }
        if ((lnk = newLink.findNewLink(data.chart.getHyperLinkList(), forLegend)) != null) {
            String hint = lnk.hint;
            hint = hint == null ? "" : hint.replace("\n", "\u001d/");
            HyperLink.HintStyle tempStyle = qbImageMap ? HyperLink.HintStyle.ATTACH_END : lnk.getHintStyle();
            switch (tempStyle) {
                case ATTACH_START: {
                    lnk.setHintValue(hint + str);
                    break;
                }
                case ATTACH_END: {
                    lnk.setHintValue(str + hint);
                    break;
                }
            }
            if (data.chart.isChartInReport() && lnk.link != null && (lnk.link.toLowerCase().endsWith(".cht") || lnk.link.toLowerCase().endsWith(".tpl"))) {
                lnk.link = "";
            }
            if ("".equals(lnk.target)) {
                lnk.target = data.chart.getHtmlTarget();
            }
            return lnk;
        }
        if (data.chart.chartType == 12) {
            return null;
        }
        if (!forLegend) {
            lnk = new HyperLink();
            lnk.target = data.chart.getHtmlTarget();
            lnk.setHintValue(str);
        }
        return lnk;
    }

    public static HyperLink getDrillDownLink(PickData pickdata) {
        String sep = "$_$";
        String param = pickdata.categoryName + sep + pickdata.category + sep;
        param = pickdata.seriesName == null ? param + "null" + sep + "null" + sep : param + pickdata.seriesName + sep + pickdata.series + sep;
        param = pickdata.sumByName == null ? param + "null" + sep + "null" + sep : param + pickdata.sumByName + sep + pickdata.sumBy + sep;
        HyperLink lnk = new HyperLink();
        lnk.link = param;
        lnk.target = "";
        lnk.setHintValue(pickdata.toString());
        return lnk;
    }

    private static HyperLink getFieldDrillDownLink(Chart chart, PickData pickdata) {
        if (chart.currentNode.getChildCount() <= 0) {
            return null;
        }
        DrillDownNode cNode = chart.currentNode.getChildAt(0);
        int[] mapping = cNode.getColumnMapping();
        if (mapping == null) {
            LOGGER.warning("CGraphics: Mapping is null!");
            return null;
        }
        StringBuffer paramStr = new StringBuffer();
        for (int i = 0; i < mapping.length; ++i) {
            paramStr.append("&PARAM" + i + "=");
            String param = chart.colData[mapping[i]].getName();
            if (param.equals(pickdata.valueName)) {
                Object val = DataType.createObject(pickdata.value + "", chart.colData[i].getDataType());
                paramStr.append(QbUtil.urlEncode(DataType.write(val)));
                continue;
            }
            if (param.equals(pickdata.seriesName)) {
                paramStr.append(QbUtil.urlEncode(DataType.write(pickdata.series)));
                continue;
            }
            if (!param.equals(pickdata.categoryName)) continue;
            paramStr.append(QbUtil.urlEncode(DataType.write(pickdata.category)));
        }
        HyperLink lnk = new HyperLink();
        lnk.link = paramStr.toString();
        lnk.target = chart.getHtmlTarget();
        lnk.setHintValue(pickdata.toString());
        return lnk;
    }

    private static HyperLink getReportDrillDownLink(Chart chart, PickData pickdata, int[] mapping, String linkPrefix) {
        StringBuffer paramStr = new StringBuffer();
        String sepBASE = "&PARAM";
        for (int i = 0; i < mapping.length; ++i) {
            String param = chart.colData[mapping[i]].getName();
            Object value = null;
            if (param.equals(pickdata.valueName)) {
                value = DataType.createObject(pickdata.value + "", chart.colData[mapping[i]].getDataType());
            } else if (param.equals(pickdata.seriesName)) {
                value = DataType.createObject(pickdata.series + "", chart.colData[mapping[i]].getDataType());
            } else if (param.equals(pickdata.categoryName)) {
                value = DataType.createObject(pickdata.category + "", chart.colData[mapping[i]].getDataType());
            } else if (param.equals(pickdata.sumByName)) {
                value = DataType.createObject(pickdata.sumBy + "", chart.colData[mapping[i]].getDataType());
            }
            try {
                paramStr.append(sepBASE).append(i).append("=").append(QbUtil.urlEncode(DataType.write(value)));
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to create drilldown link", ex);
            }
        }
        HyperLink lnk = new HyperLink();
        lnk.link = linkPrefix + paramStr.toString();
        if (linkPrefix.indexOf("moveToPage(") > -1) {
            lnk.link = lnk.link + "'); return false;";
        }
        lnk.target = chart.getHtmlTarget();
        lnk.setHintValue(pickdata.toString());
        return lnk;
    }

    public String[] findLinkContaining(int x, int y) {
        String[] tmpArr = null;
        for (int i = 0; i < this.maplist.size(); ++i) {
            if (!(this.maplist.elementAt((int)i).obj instanceof Rectangle) || !((Rectangle)this.maplist.elementAt((int)i).obj).contains(x, y)) continue;
            tmpArr = new String[]{this.maplist.elementAt((int)i).link, this.maplist.elementAt((int)i).target};
            i += this.maplist.size();
        }
        return tmpArr;
    }

    final void drawColorLine(int x1, int y1, int x2, int y2, Color color) {
        this.g.setColor(color);
        this.g.drawLine(x1, this.height - y1, x2, this.height - y2);
    }

    public final void drawLineForArea(Polygon p, boolean left, boolean right, Color color) {
        this.g.setColor(color);
        this.g.drawLine(p.xpoints[0], this.height - p.ypoints[0], p.xpoints[1], this.height - p.ypoints[1]);
        this.g.drawLine(p.xpoints[3], this.height - p.ypoints[3], p.xpoints[2], this.height - p.ypoints[2]);
        if (left) {
            if (p.xpoints[0] < p.xpoints[1]) {
                this.g.drawLine(p.xpoints[0], this.height - p.ypoints[0], p.xpoints[3], this.height - p.ypoints[3]);
            } else {
                this.g.drawLine(p.xpoints[1], this.height - p.ypoints[1], p.xpoints[2], this.height - p.ypoints[2]);
            }
        } else if (right) {
            if (p.xpoints[0] > p.xpoints[1]) {
                this.g.drawLine(p.xpoints[0], this.height - p.ypoints[0], p.xpoints[3], this.height - p.ypoints[3]);
            } else {
                this.g.drawLine(p.xpoints[1], this.height - p.ypoints[1], p.xpoints[2], this.height - p.ypoints[2]);
            }
        }
    }

    public final void fillPolygon(Vector<Integer> vectorX, Vector<Integer> vectorY) {
        if (this.chart.chartType != 3 || this.chart.dataDim != 1 || !this.chart.isDrawAreaUnderLine()) {
            return;
        }
        if (vectorX.size() != vectorY.size()) {
            LOGGER.warning("An error has occured in drawing the area under the line");
        }
        int lastYValue = this.height - vectorY.elementAt(vectorY.size() - 1);
        Vector<Integer> xVec = new Vector<Integer>();
        Vector<Integer> yVec = new Vector<Integer>();
        xVec.add(vectorX.elementAt(0));
        yVec.add(lastYValue);
        int direction = -1;
        for (int i = 1; i < vectorY.size(); ++i) {
            int yPT = this.height - vectorY.elementAt(i);
            if (direction == -1) {
                direction = lastYValue > yPT ? 1 : 2;
                xVec.add(vectorX.elementAt(i));
                yVec.add(yPT);
                continue;
            }
            if (direction == 1 && lastYValue > yPT || direction == 2 && lastYValue < yPT) {
                xVec.add(vectorX.elementAt(i));
                yVec.add(yPT);
                continue;
            }
            if (lastYValue == yPT) {
                xVec.add(vectorX.elementAt(i));
                yVec.add(yPT);
                if (direction == 1) {
                    this.g.setColor(this.chart.upAreaColor);
                } else {
                    this.g.setColor(this.chart.downAreaColor);
                }
                int[] xINT = new int[xVec.size()];
                int[] yINT = new int[yVec.size()];
                for (int j = 0; j < xINT.length; ++j) {
                    xINT[j] = (Integer)xVec.elementAt(j);
                    yINT[j] = (Integer)yVec.elementAt(j);
                }
                this.g.fillPolygon(xINT, yINT, xINT.length);
                xVec = new Vector();
                yVec = new Vector();
                xVec.add(vectorX.elementAt(i));
                yVec.add(yPT);
                direction = -1;
                continue;
            }
            int lastX = (Integer)xVec.elementAt(xVec.size() - 1);
            int lastY = (Integer)yVec.elementAt(yVec.size() - 1);
            int desX = vectorX.elementAt(i);
            int bkX = (lastYValue - lastY) * (desX - lastX) / (yPT - lastY) + lastX;
            xVec.add(bkX);
            yVec.add(lastYValue);
            if (direction == 1) {
                this.g.setColor(this.chart.upAreaColor);
            } else {
                this.g.setColor(this.chart.downAreaColor);
            }
            int[] xINT = new int[xVec.size()];
            int[] yINT = new int[yVec.size()];
            for (int j = 0; j < xINT.length; ++j) {
                xINT[j] = (Integer)xVec.elementAt(j);
                yINT[j] = (Integer)yVec.elementAt(j);
            }
            this.g.fillPolygon(xINT, yINT, xINT.length);
            xVec = new Vector();
            yVec = new Vector();
            xVec.add(bkX);
            yVec.add(lastYValue);
            xVec.add(desX);
            yVec.add(yPT);
            direction = direction == 1 ? 2 : 1;
        }
    }
}

