/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.AddOnChart;
import quadbase.chart.AnnotationSet;
import quadbase.chart.Area;
import quadbase.chart.Axis;
import quadbase.chart.CAnnotation;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.ChartColorSet;
import quadbase.chart.ColData;
import quadbase.chart.ColMetaData;
import quadbase.chart.ControlLine;
import quadbase.chart.Coordinate;
import quadbase.chart.DataAttribute;
import quadbase.chart.DataLine;
import quadbase.chart.DataLineSet;
import quadbase.chart.DrillDownInfo;
import quadbase.chart.DrillDownNode;
import quadbase.chart.ExportChart;
import quadbase.chart.GradientSupport;
import quadbase.chart.GraphicsTable;
import quadbase.chart.HiLowData;
import quadbase.chart.HiLowMap;
import quadbase.chart.HorzVertLine;
import quadbase.chart.IPieChart;
import quadbase.chart.Legend;
import quadbase.chart.Line;
import quadbase.chart.LoadChart;
import quadbase.chart.MultiDimData;
import quadbase.chart.OffsetCString;
import quadbase.chart.PlotData;
import quadbase.chart.Point3D;
import quadbase.chart.PreprocInfo;
import quadbase.chart.PropCString;
import quadbase.chart.ReadDataFile;
import quadbase.chart.ReloadChart;
import quadbase.chart.StepSize;
import quadbase.chart.Ticker;
import quadbase.chart.TrendLine;
import quadbase.chart.ValueTable;
import quadbase.chart.WriteDataFile;
import quadbase.chart.chart2d.types2d.general2d.LineChart2D;
import quadbase.chart.chart3d.FaceHyperLink;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.param.ChartParameterPage;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.IAlertable;
import quadbase.common.util.IOLAPResultSet;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.IQbGraphics;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.OrgUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.util.ColorSpectrum;
import quadbase.util.ControlRange;
import quadbase.util.HyperLink;
import quadbase.util.IAnnotation;
import quadbase.util.IChartGraphics;
import quadbase.util.IChartTypeConstants;
import quadbase.util.ICustomizeImageMapDataHintBox;
import quadbase.util.IDataLabelInfo;
import quadbase.util.IFormat;
import quadbase.util.IQueryInParam;
import quadbase.util.IReferenceObj;
import quadbase.util.IStringCustomizer;
import quadbase.util.ITextString;
import quadbase.util.LocaleDateTimeFormat;
import quadbase.util.LocaleNumericFormat;
import quadbase.util.NumericFormat;
import quadbase.util.PickData;
import quadbase.util.Point_2D;
import quadbase.util.Point_3D;
import quadbase.util.PolyLine;
import quadbase.util.Position;
import quadbase.util.internal.CreateChart;
import quadbase.util.internal.Graphics2DTool;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.ImageData;
import quadbase.util.internal.RenderingChart;

public abstract class Chart
implements IChartTypeConstants,
IReferenceObj,
IAlertable {
    public static final int PRECISION = 1000;
    public static final int NONE = 0;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    public static final int SEC_ASCENDING = 3;
    public static final int SEC_DESCENDING = 4;
    public static final String[] stypeName = new String[]{LanguageEncoder.getText("Column"), LanguageEncoder.getText("Bar"), LanguageEncoder.getText("Scatter"), LanguageEncoder.getText("Line"), LanguageEncoder.getText("Stack Column"), LanguageEncoder.getText("Stack Bar"), LanguageEncoder.getText("Pie"), LanguageEncoder.getText("Area"), LanguageEncoder.getText("Stack Area"), LanguageEncoder.getText("High Low"), LanguageEncoder.getText("HLCO"), LanguageEncoder.getText("100% Column"), LanguageEncoder.getText("Surface"), LanguageEncoder.getText("Bubble"), LanguageEncoder.getText("Overlay"), LanguageEncoder.getText("Box"), LanguageEncoder.getText("Radar"), LanguageEncoder.getText("Dial"), LanguageEncoder.getText("Gantt"), LanguageEncoder.getText("Polar"), LanguageEncoder.getText("Doughnut")};
    public static final int TOP_ALIGNMENT = 0;
    public static final int CENTER_ALIGNMENT = 1;
    public static final int BOTTOM_ALIGNMENT = 2;
    public static final int TOP_ALIGNMENT_INWARD = 3;
    public static final int BOTTOM_ALIGNMENT_INWARD = 4;
    public static final int XAXIS = 0;
    public static final int YAXIS = 1;
    public static final int BOTH = 2;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected static final IllegalArgumentException nocategoryError = new IllegalArgumentException("No category data to plot.");
    protected static final IllegalArgumentException nonumericError = new IllegalArgumentException("No numeric data to plot.");
    protected static final IllegalArgumentException notenoughError = new IllegalArgumentException("Not enough data column to plot.");
    private static final Logger LOGGER = Logger.getLogger(Chart.class.getName());
    public static boolean ENABLEMINMAXERRORCHECK = true;
    public static boolean DEFAULTSINGLECOLORFORCATEGORIES = true;
    private static boolean forExportOnly = false;
    public Component component;
    public CString mainTitle;
    public Axis[] axis;
    public Axis a_x;
    public Axis a_y;
    public Axis a_z;
    public Axis a_s;
    public Legend legend;
    public Legend legend2;
    public int chartType;
    public Area background;
    public Area border;
    public ColData[] colData;
    public boolean[] usedColumns = null;
    public ColData[] originalColDataFromMemSource = null;
    public Vector<DrillDownInfo> drillDownVector = null;
    public int drillNumber = 0;
    public boolean isDynamicDrillDown = false;
    public String drillTemplateName = null;
    public String drillTemplatePath = "drilltemplates/";
    public int primaryAggregate = -1;
    public int secondaryAggregate = -1;
    public int countUnusedCol = -1;
    public MultiDimData mData = null;
    public MultiDimData mData2 = null;
    public int[] mDataLen;
    public int maxDataLen = -1;
    public boolean is2DChart = true;
    public boolean isAggregationChart = false;
    public boolean summaryChart = false;
    public int dataDim = 1;
    public int nCol;
    public int nRow;
    public int valueCol;
    public int subvalueCol;
    public int[] coordCol;
    public int[] mDataMap;
    public int[] originalMap;
    public HiLowMap originalHiLowMap;
    public boolean processedChart = false;
    public HiLowMap hilowCol;
    public boolean[] displayByWeek = new boolean[3];
    public boolean bvalueCol;
    public boolean[] bcoordCol;
    public boolean[] bmDataMap;
    public double minvalue = Double.MAX_VALUE;
    public double maxvalue = -1.7976931348623157E308;
    public double avgvalue = 0.0;
    public double minvalue2 = Double.MAX_VALUE;
    public double maxvalue2 = -1.7976931348623157E308;
    public int chartxorigin;
    public int chartyorigin;
    public int chartwidth;
    public int chartheight;
    public Coordinate minCoord;
    public Coordinate maxCoord;
    public int winWidth;
    public int winHeight;
    public Random random;
    public boolean showChart = true;
    public boolean showArea = true;
    public boolean showPoint = false;
    public boolean showPoint2 = false;
    public boolean showLine = false;
    public boolean showLine2 = true;
    public boolean showArrow = true;
    public boolean showTopValue = false;
    public boolean showStackLabel = false;
    public boolean showStackTotalLabel = true;
    public boolean showWallFrame = false;
    public boolean showData = true;
    public boolean showStepLine = false;
    public double stepRatio = 0.5;
    public boolean showStepLine2 = false;
    public double stepRatio2 = 0.5;
    public boolean[] selectStep;
    public boolean isSelectiveStep = false;
    public int hLineX1;
    public int hLineX2;
    public int hLineY;
    public boolean dataDrawnOnTop = false;
    public boolean addNewColumnFromDataMapping = false;
    public Area desktopArea;
    public boolean isBackgroundTransparent = false;
    public double barwidthRatio = 1.0;
    public double thickRatio = 1.0;
    public double maxBarWidthRatioToPlotArea = 1.0;
    public int xboundmin;
    public int xboundmax;
    public int yboundmin;
    public int yboundmax;
    public CGraphics cgraphics;
    public Vector<Object> renderingKey = new Vector();
    public Vector<Object> renderingValue = new Vector();
    public boolean setAntiAliasForChartOnly = false;
    public float legend_XProp = 0.9f;
    public float legend_YProp = 0.5f;
    public float legend2_XProp = 0.9f;
    public float legend2_YProp = 0.3f;
    public float title_XProp = 0.5f;
    public float title_YProp = 0.85f;
    public float chart_XProp = 0.2f;
    public float chart_YProp = 0.2f;
    public float chart_widthProp = 0.6f;
    public float chart_heightProp = 0.6f;
    public boolean j2DRotateText = true;
    public boolean disableJava2DForStraightText = false;
    public boolean bubbleAreaRelativeToValue = false;
    public boolean bubble3D = false;
    public int bubble3DLight = 66;
    public boolean[] labelDateTime = new boolean[]{true, true, true};
    public int ganttOrigLabelsLength;
    public long refreshInterval = 0L;
    public boolean disableSchedule = true;
    public Font topvalueLabel_font = CString.defaultfont;
    public Color topvalueLabel_color = Color.black;
    public Color topvalueNegativeLabel_color = null;
    public int topvalueLabel_angle = 0;
    public int toplabel_offset_up = 10;
    public int toplabel_offset_side = 0;
    public int toplabel_offset3D_up = 50;
    public int toplabel_offset3D_side = 0;
    public int toplabel_count = 0;
    public boolean isLabelOnPositiveSide;
    public int topLabel_Alignment = 0;
    public int stackLabel_Alignment = 1;
    public int topLabel2_Alignment = 0;
    public Vector topLabels = new Vector();
    public Vector topLabels2 = new Vector();
    public Font topvalueLabel2_font = CString.defaultfont;
    public Color topvalueLabel2_color = Color.black;
    public int topvalueLabel2_angle = 0;
    public int toplabel2_offset_up = 10;
    public int toplabel2_offset_side = 0;
    public int toplabel2_offset3D_up = 50;
    public int toplabel2_offset3D_side = 0;
    public int toplabel2_count = 0;
    public ImageData backgroundImage;
    public boolean showbackgroundImage = false;
    public Vector<ITextString> stringList;
    public boolean showStringList = true;
    public Vector<PolyLine> lineList = new Vector();
    public DataLineSet dataLineSet = null;
    public AnnotationSet annotationSet = new AnnotationSet(this);
    public int axisThickness = 2;
    public boolean drawDataBorder = false;
    public boolean drawBorderForWhiteArea = false;
    public int dataBorderThickness = 1;
    public Color dataBorderColor = Color.black;
    public boolean xAxisAtTop = false;
    public boolean connectLineOrder = false;
    public boolean candleStick = false;
    public float candleWidth = 0.3f;
    public Color candleUpColor = Color.green;
    public Color candleDownColor = Color.red;
    public int yAxisCenter;
    public int comboType = 0;
    public int comboSeries = -1;
    public DBInfoBasic dbInfo;
    public Vector parameters;
    public String registryID;
    public String dataSourceID;
    public String dataSourceLoc;
    public String sourceFile;
    public String sourceFileEncoding = null;
    public Object[] sourceList;
    public int[] sourceType;
    public boolean[] doTranspose;
    public Object[] transposeColList;
    public XMLFileQueryInfo xmlFileQueryInfo;
    public SalesForceQueryFileInfo sfQueryInfo;
    public String jndiName;
    public String homeName;
    public String remoteName;
    public String selectedMethodName;
    public Object[] selectedMethodParamVal;
    public Hashtable<String, String> environment;
    public SOAPQueryFileInfo soapInfo;
    public ExcelFileInfo excelInfo;
    public IOLAPResultSet olapRS;
    public String mondrianConnectionString = "";
    public String MDXQuery = "";
    public String xmlaURI = "";
    public String xmlaDataSource = "";
    public String xmlaCatalog = "";
    public int inputMethod = 0;
    public int sourceData;
    public boolean isTransposed = false;
    public boolean[] transposeCol;
    public PickData pickdata = new PickData();
    public OffsetCString targetstr;
    public String targetName;
    public boolean imagemap = false;
    public Vector<HyperLink> hyperlinkList;
    public ICustomizeImageMapDataHintBox customizeImageMapDataHintBox;
    public boolean remakeTable = false;
    public int x_shift = 0;
    public int xlabelrow = 1;
    public boolean showNulldataLine = true;
    public boolean applyLineStyleToNullData = false;
    public boolean zeroAsNullData = false;
    public boolean nullDataAsZero = false;
    public boolean formatHint = true;
    public Graphics g;
    public float[] vAxisScale = new float[3];
    public float xmin = 0.0f;
    public float ymin = 0.0f;
    public float xratio = 1.0f;
    public float yratio = 1.0f;
    public boolean isXZoomed = false;
    public boolean isYZoomed = false;
    public boolean isTSChart = false;
    public PreprocInfo tsInfo;
    public String queryFilename;
    public transient boolean doDrawAnnotation = true;
    public ValueTable valueTable = new ValueTable(this);
    public FontMetrics fm = null;
    public int aTCX = 0;
    public int aTCY = 0;
    public boolean tableInPanel = false;
    public GraphicsTable gt = null;
    public Area farea;
    public boolean drillshift = false;
    public Vector<FaceHyperLink> surfaceHyperLinkList;
    public boolean showSeriesInTopLabel;
    public ColData secData = null;
    public ColData[] axisData = null;
    public Axis[] colDataAxis = null;
    public int bubbleDrawMode = 0;
    public double axisUnitToRadiusRatio = 1.0;
    public boolean is3DApproximationUsed = true;
    public int approximationThreshold = 100;
    public boolean showShadowOnLine = false;
    public boolean drawBorderForWMF = true;
    public DrillDownNode currentNode;
    public ChartColorSet chartColorSet = new ChartColorSet(false);
    public ChartColorSet chartColorSet2 = null;
    public int sortValue = 0;
    public FileInMemTable subFilesTable = new FileInMemTable();
    public double flashRatio = 1.0;
    public int flashFrameCount = 12;
    public float flashFrameRate = 20.0f;
    public int flashRotateAngle = 60;
    public boolean flashIsFirstLoopForPie = false;
    public Font flashHintFont = new Font("Dialog", 0, 10);
    public Color flashHintFontColor = Color.black;
    public Color flashHintBgColor = Color.yellow;
    public Color flashHintBorderColor = Color.black;
    public boolean flashEnableHintBox = true;
    public boolean colDataHasChangedBecauseOfAggrHistZoom = false;
    protected int scrollBarOption = 0;
    protected int nreal;
    protected int nint;
    protected int nstring;
    protected int ndatetime;
    protected int ntime;
    protected int[] nrealcol;
    protected int[] nintcol;
    protected int[] nstringcol;
    protected int[] ndatetimecol;
    protected int[] ntimecol;
    protected Area wallbackground;
    protected ImageData dialPlotFGImage;
    protected boolean showDialPlotFGImage = false;
    protected double dialFGPlotSizeRatio = 1.1;
    protected ImageData dialPlotBGImage;
    protected boolean showDialPlotBGImage = false;
    protected double dialBGPlotSizeRatio = 1.1;
    protected boolean isAdjustFont = true;
    protected boolean enablePopupMenu = true;
    protected boolean enableTypeMenu = true;
    protected boolean enableDimMenu = true;
    protected boolean autoRotate = false;
    protected boolean isReferenceAtTop = false;
    protected QueryFileInfo queryFileInfo;
    protected Color surfaceColor = Color.red;
    protected ColorSpectrum colorSpectrum;
    protected int noSectionForPolar = 4;
    protected double startAngleForPolar = 0.0;
    protected boolean isRadianForPolar = true;
    protected boolean clockWiseForPolar = true;
    protected boolean adjust3DView = true;
    protected boolean adjustScaleOnly = true;
    boolean isComputed = false;
    String[][] customDataOrdering;
    DataAttribute unusedDataAttribute = null;
    DataAttribute unusedDataAttribute2 = null;
    Color upAreaColor = Color.pink;
    Color downAreaColor = Color.green;
    int cutOffThresholdForText = -1;
    String xmlChartLocation;
    int originalSourceData;
    double pieOthersLimit = 0.0;
    String pieOthersName = "Others";
    double colorThresholdForPie = -1.0;
    Color[] colorArrayForPieThreshold = null;
    boolean isSubFieldDrillDownChart = false;
    Hashtable<String, String> fontMapping = new Hashtable();
    boolean singleColorForCategories = DEFAULTSINGLECOLORFORCATEGORIES;
    private int[] dataPtShapes = null;
    private int[] dataPtSizes = null;
    private boolean histogram = false;
    private boolean showPercentage = false;
    private int binNumber = 0;
    private boolean isDataLimitAtAxisScale = false;
    private boolean drawPointBorder = false;
    private boolean drawPointBorder2 = false;
    private Color drawPointBorderColor = Color.black;
    private Color drawPointBorderColor2 = Color.black;
    private boolean showTopValue2 = false;
    private boolean drawAreaUnderLine = false;
    private boolean showOffsetTicker = false;
    private IChartGraphics chartGraphics;
    private AddOnChart addOnChart;
    private boolean setAntiAliasForText = false;
    private boolean redrawToFitCanvas = false;
    private float xGap = -1.0f;
    private float fontResizeRatio = 0.0f;
    private Point3D ganttEndPoint = null;
    private boolean isGanttArrows = false;
    private boolean isLabelOnNegativeSide = false;
    private boolean showNoDataToPlotMsg = true;
    private String noDataToPlotMsg = "No Data To Plot";
    private Font noDataToPlotMsgFont = QbUtil.getDefaultFont(new Font("TimesRoman", 3, 14), new Font("Dialog", 3, 14));
    private Color noDataToPlotMsgColor = Color.blue;
    private int noDataToPlotMsgAngle = 0;
    private boolean drawConnectLineArrows = false;
    private boolean isJoinAxis = false;
    private boolean isGridAlignedWithTicker = false;
    private boolean isGridInFront = false;
    private int dbSourceType = -1;
    private byte[][] queryFileBytes = null;
    private boolean showNullInScatter = true;
    private int scatterCubeWidth = 30;
    private boolean drawNullColumn = false;
    private String nullColumnName = "NULL";
    private int zoomOption = -1;
    private Vector<float[]> xZoomList = new Vector();
    private Vector<float[]> yZoomList = new Vector();
    private float firstvminFlt;
    private float firstvmaxFlt;
    private float firstvstepFlt;
    private float lastvminFlt;
    private float lastvmaxFlt;
    private float lastvstepFlt;
    private boolean isVerticalChart = false;
    private boolean showSecDataInPrimaryTab = false;
    private boolean showDoubleValueForLine = false;
    private boolean syncPointColor = true;
    private boolean showDropBarForLine = false;
    private boolean dropBarBorder = false;
    private Color dropBarColor = Color.orange;
    private Color dropBarColor2 = Color.yellow;
    private int dropBarSeries1 = 0;
    private int dropBarSeries2 = 1;
    private boolean doTranslucent = false;
    private float translucentValue = 0.5f;
    private boolean autoAxisPosition = true;
    private int axisGapOffset = 0;
    private double startingAngleForDial = 0.0;
    private double endingAngleForDial = 360.0;
    private Vector<ControlRange> controlRangeList = new Vector();
    private double radiusForInternalDial = 0.0;
    private boolean drawFullCircleForDial = true;
    private int tickerLength = 3;
    private int subTickerLength = 3;
    private boolean turnOn3DShadowForTicker = true;
    private int subTickerCount = 0;
    private int subTickerThickness = 1;
    private boolean usePointer = false;
    private int needleOption = 3;
    private int orient = 0;
    private boolean drawSeriesOnCategoryAxis = false;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private boolean useBufferedImage = true;
    private int imageType = 1;
    private boolean showShadowOnPoint = true;
    private Locale locale;
    private TimeZone timeZone;
    private IDataLabelInfo primaryDataLabelInfo = null;
    private IDataLabelInfo secondaryDataLabelInfo = null;
    private String servletDirectory = "servlet/";
    private int paramPageLayout = 1;
    private boolean paramPageResetEnabled = true;
    private String[] paramPageChartDisplayTypes = null;
    private String extraFormContent = "";
    private boolean saveColorsForCategories = false;
    private Color[] dataColors;
    private int[] rptMapping = null;
    private boolean isChartInReport = false;
    private String rptDrillLinkPrefix = "";
    private String htmlTarget = "";
    private IStringCustomizer stringCustomizer = null;
    private boolean synchronizeRadarAxis = true;
    private boolean drawCircularGrid = false;
    private Double areaCutOffPoint = null;
    private boolean uniqueColorForCol = false;
    private GradientSupport primaryDataGradientSupport = new GradientSupport();
    private GradientSupport secondaryDataGradientSupport = new GradientSupport();
    private boolean isPrevParamPrompt = true;
    private boolean changing3DChartType = true;

    public Chart(int _chartType, boolean is2DChart, Chart _chart) {
        LCKey.isValidEC();
        if (IOUtil.isMac() && !IOUtil.isJava14()) {
            this.j2DRotateText = false;
        }
        this.chartType = _chartType;
        this.is2DChart = is2DChart;
        if (this.chartType == _chart.getChartType()) {
            this.changing3DChartType = _chart.changing3DChartType;
        }
        this.originalMap = new int[5];
        this.originalMap = _chart.originalMap;
        this.originalHiLowMap = new HiLowMap();
        if (_chart.originalHiLowMap != null) {
            this.originalHiLowMap.copy(_chart.originalHiLowMap);
        }
        this.colData = ColData.copyColData(_chart.colData);
        this.originalColDataFromMemSource = _chart.originalColDataFromMemSource;
        this.nCol = this.colData.length - 1;
        this.nreal = _chart.nreal;
        this.nint = _chart.nint;
        this.nstring = _chart.nstring;
        this.ndatetime = _chart.ndatetime;
        this.nrealcol = _chart.nrealcol;
        this.nintcol = _chart.nintcol;
        this.nstringcol = _chart.nstringcol;
        this.ndatetimecol = _chart.ndatetimecol;
        this.ntimecol = _chart.ntimecol;
        this.nRow = _chart.nRow;
        this.axis = new Axis[4];
        this.minCoord = new Coordinate();
        this.maxCoord = new Coordinate();
        this.coordCol = new int[3];
        this.mDataMap = new int[this.nCol];
        this.mDataLen = new int[this.nCol];
        this.random = new Random(System.currentTimeMillis());
        this.bvalueCol = _chart.bvalueCol;
        this.bcoordCol = new boolean[3];
        this.bmDataMap = new boolean[Math.max(this.nCol, 3)];
        this.hilowCol = new HiLowMap();
        this.copyChartAttributes(_chart);
        if (!this.isCircularChart() && _chart.isCircularChart()) {
            this.flashFrameCount = 12;
            this.flashFrameRate = 20.0f;
        } else if (this.isCircularChart() && !_chart.isCircularChart()) {
            this.flashFrameCount = 30;
            this.flashFrameRate = 20.0f;
        }
    }

    public Chart(Component component, int _chartType, boolean is2DChart, ColData[] _colData) {
        this(component, _chartType, is2DChart, _colData, null);
    }

    public Chart(Component component, int _chartType, boolean is2DChart, ColData[] _colData, boolean[] usedColumnsList) {
        int i;
        LCKey.isValidEC();
        this.changing3DChartType = true;
        if (IOUtil.isMac() && !IOUtil.isJava14()) {
            this.j2DRotateText = false;
        }
        this.farea = this.newArea();
        this.farea.drawArea = true;
        this.farea.drawBorder = true;
        this.farea.depth = 5;
        this.component = component;
        this.chartType = _chartType;
        this.is2DChart = is2DChart;
        this.colData = _colData;
        this.subvalueCol = -1;
        this.nCol = this.colData.length - 1;
        this.nrealcol = new int[this.nCol];
        this.nintcol = new int[this.nCol];
        this.nstringcol = new int[this.nCol];
        this.ndatetimecol = new int[this.nCol];
        this.ntimecol = new int[this.nCol];
        boolean checkUsedColumns = false;
        if (usedColumnsList != null) {
            checkUsedColumns = true;
        }
        this.originalMap = new int[5];
        for (i = 0; i < 5; ++i) {
            this.originalMap[1] = -1;
        }
        this.originalHiLowMap = new HiLowMap();
        for (i = 0; i < this.nCol; ++i) {
            if (checkUsedColumns && usedColumnsList[i]) continue;
            int dtype = this.colData[i].dataType;
            if (DataType.isDateTime(dtype)) {
                this.ndatetimecol[this.ndatetime++] = i;
                this.nstringcol[this.nstring++] = i;
                if (!DataType.isTime(dtype)) continue;
                this.ntimecol[this.ntime++] = i;
                continue;
            }
            if (!DataType.isNumeric(dtype)) {
                this.nstringcol[this.nstring++] = i;
                continue;
            }
            if (DataType.isInt(dtype) || dtype == 5) {
                this.nintcol[this.nint++] = i;
                continue;
            }
            this.nrealcol[this.nreal++] = i;
        }
        if (checkUsedColumns) {
            ++this.nreal;
        }
        this.nRow = this.colData[0].getSize();
        this.axis = new Axis[4];
        this.minCoord = new Coordinate();
        this.maxCoord = new Coordinate();
        this.coordCol = new int[3];
        this.bcoordCol = new boolean[3];
        this.background = this.newArea(new Color(247, 247, 219));
        this.border = this.newArea(Color.black);
        this.border.drawBorder = false;
        this.border.drawArea = false;
        this.wallbackground = this.newArea(new Color(188, 188, 184));
        this.background.drawBorder = false;
        this.background.drawArea = false;
        this.wallbackground.drawBorder = false;
        this.wallbackground.drawArea = true;
        this.desktopArea = QbUtil.usePatch ? this.newArea(Color.lightGray) : this.newArea(new Color(255, 255, 255));
        this.desktopArea.drawArea = true;
        this.bcoordCol[0] = false;
        this.bcoordCol[1] = false;
        this.bcoordCol[2] = false;
        this.mainTitle = new CString("", QbUtil.getDefaultFont(new Font("TimesRoman", 1, 22), new Font("Dialog", 1, 18)), 3);
        Font f = QbUtil.getDefaultFont(new Font("Courier", 1, 12), new Font("Dialog", 1, 10));
        this.a_x = this.axis[0] = this.setAxis(0, new CString("", f, 0), !is2DChart);
        this.a_y = this.axis[1] = this.setAxis(1, new CString("", f, 4), !is2DChart);
        this.a_y.title.setDirection(2);
        this.a_z = this.axis[2] = this.setAxis(2, new CString("", f, 0), !is2DChart);
        this.a_s = this.axis[3] = this.setAxis(3, new CString("", f, 0), !is2DChart);
        this.a_s.title.setDirection(2);
        this.a_s.bshow = false;
        this.mDataMap = new int[this.nCol];
        this.mDataLen = new int[this.nCol];
        this.bmDataMap = new boolean[Math.max(this.nCol, 3)];
        this.bvalueCol = false;
        for (i = 0; i < this.bmDataMap.length; ++i) {
            this.bmDataMap[i] = false;
        }
        this.random = new Random(System.currentTimeMillis());
        this.hilowCol = new HiLowMap();
        this.stringList = new Vector();
        this.hyperlinkList = new Vector();
        this.surfaceHyperLinkList = new Vector();
        this.isTSChart = false;
        this.tsInfo = new PreprocInfo(93);
        this.dataLineSet = this.newDataLineSet();
        String className = "quadbase.chart.GraphicsTable";
        Object obj = this.getPluginObject(className, null, null);
        if (obj != null) {
            this.gt = (GraphicsTable)obj;
        } else {
            this.gt = null;
            this.tableInPanel = false;
        }
        for (ColData element : this.colData) {
            if (element.isDrawNullColumn() == this.isDrawNullColumn()) continue;
            this.setDrawNullColumn(element.isDrawNullColumn());
            break;
        }
        for (ColData element : this.colData) {
            if (element.getNullColumnName().equals(this.getNullColumnName())) continue;
            this.setNullColumnName(element.getNullColumnName());
            break;
        }
        this.setLabelOnPositiveSide(!is2DChart);
        if (IOUtil.isJava2D()) {
            this.renderingKey.addElement(RenderingHints.KEY_ANTIALIASING);
            this.renderingValue.addElement(RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.setAntiAliasEnabled(true);
        if (this.isCircularChart()) {
            this.flashFrameCount = 30;
            this.flashFrameRate = 20.0f;
        }
    }

    public static boolean isForExportOnly() {
        return forExportOnly;
    }

    public static void setForExportOnly(boolean state) {
        forExportOnly = state;
    }

    public static ByteArrayInputStream getSubFileStream(FileInMemTable subFilesTable, String fileName) {
        LOGGER.finest("FILE NAME = " + fileName);
        LOGGER.finest("CHART GET FILE STREAM - " + subFilesTable.toString());
        byte[] bytes = subFilesTable.get(fileName);
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public static boolean replaceSubFile(FileInMemTable subFileTable, byte[] barray, String filename, boolean isReportPakFile) {
        if (barray == null) {
            LOGGER.log(Level.FINEST, "Byte array is null, FILE NAME = " + filename, new Exception());
        }
        if (subFileTable != null) {
            LOGGER.finest("REPLACE SUB FILE SIZE = " + subFileTable.size());
            LOGGER.finest("REPLACE FILE NAME = " + filename);
            byte[] chartByteArray = subFileTable.get(filename);
            if (chartByteArray != null) {
                subFileTable.put(filename, barray);
                LOGGER.finest("REPLACE ADDR = " + filename);
                return true;
            }
            if (OrgUtil.isPackChartData(filename) || isReportPakFile) {
                subFileTable.put(filename, barray);
                LOGGER.finest("NEW ADDR = " + filename);
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean fileExists(Chart chart, String filename) throws Exception {
        byte[] obj;
        if (chart != null && (obj = chart.getSubFilesTable().get(filename)) != null) {
            return true;
        }
        return new FileInfo(filename).exists();
    }

    public static void setLocale(IFormat format, Locale locale) {
        if (locale == null || format == null) {
            return;
        }
        if (format instanceof LocaleNumericFormat) {
            ((LocaleNumericFormat)format).setLocale(locale);
        } else if (format instanceof LocaleDateTimeFormat) {
            ((LocaleDateTimeFormat)format).setLocale(locale);
        }
    }

    public static void setTimeZone(IFormat format, TimeZone zone) {
        if (zone == null || format == null) {
            return;
        }
        if (format instanceof LocaleDateTimeFormat) {
            ((LocaleDateTimeFormat)format).setTimeZone(zone);
        }
    }

    private static void setDrawNullColumn(boolean b, ColData[] colData) {
        if (colData != null) {
            for (ColData element : colData) {
                element.setDrawNullColumn(b);
            }
        }
    }

    private static void setNullColumnName(String str, ColData[] colData) {
        if (colData != null) {
            for (ColData element : colData) {
                element.setNullColumnName(str);
            }
        }
    }

    public static boolean isCoordinateType(int chartType) {
        return chartType == 2 || chartType == 12 || chartType == 13 || chartType == 19;
    }

    protected static String formatLabel(Object obj, IFormat dataFormat) {
        if (dataFormat != null) {
            return dataFormat.format(obj);
        }
        return obj.toString();
    }

    public static boolean isValidChartType(boolean is2DChart, int chartType) {
        if (is2DChart) {
            return chartType >= 0 && (chartType < 12 || chartType == 13 || chartType == 14 || chartType == 15 || chartType == 16 || chartType == 17 || chartType == 18 || chartType == 19 || chartType == 20);
        }
        return chartType >= 0 && chartType <= 12 || chartType == 20;
    }

    public static final boolean isCircularChart(int chartType) {
        return chartType == 6 || chartType == 20;
    }

    public static final boolean isStackChart(int chartType) {
        return chartType == 4 || chartType == 5 || chartType == 8;
    }

    public static final Chart createChart(Component component, int chartType, boolean is2DChart, Chart _chart, ColData[] colData) throws IllegalArgumentException {
        return Chart.createChart(component, chartType, is2DChart, _chart, colData, null);
    }

    public static final Chart createChart(Component component, int chartType, boolean is2DChart, Chart _chart, ColData[] colData, boolean[] usedColumnsList) throws IllegalArgumentException {
        Chart chart = null;
        String className = null;
        String folderName = null;
        if (colData == null && _chart == null) {
            throw new IllegalArgumentException("Null argument !");
        }
        if (!Chart.isValidChartType(is2DChart, chartType)) {
            throw new IllegalArgumentException("Unknown chart Type " + chartType + " !");
        }
        folderName = chartType == 10 || chartType == 9 ? "hilow" : (chartType == 11 || chartType == 8 || chartType == 5 || chartType == 4 ? "stack" : "general");
        className = is2DChart ? "quadbase.chart.chart2d.types2d." + folderName + "2d." + CHARTTYPENAME[chartType] + "2D" : "quadbase.chart.chart3d.types3d." + folderName + "3d." + CHARTTYPENAME[chartType] + "3D";
        try {
            Class<?> objClass = Class.forName(className);
            if (!DrillDownInfo.checkDrillDownType(chartType)) {
                if (_chart == null) {
                    Object[] argsValue = new Object[2];
                    Class[] argsClass = new Class[2];
                    Object[] newObj = new Object[]{Array.newInstance(ColData.class, 1)};
                    argsValue[0] = component;
                    argsValue[1] = colData;
                    argsClass[0] = Component.class;
                    argsClass[1] = newObj[0].getClass();
                    Constructor<?> objCons = objClass.getConstructor(argsClass);
                    chart = (Chart)objCons.newInstance(argsValue);
                } else {
                    Object[] argsValue = new Object[1];
                    Class[] argsClass = new Class[1];
                    argsValue[0] = _chart;
                    argsClass[0] = Chart.class;
                    Constructor<?> objCons = objClass.getConstructor(argsClass);
                    chart = (Chart)objCons.newInstance(argsValue);
                    if (chart.chartType != _chart.chartType && _chart.isSaveColorsForCategories() && _chart.chartColorSet.isDataPointsColorsMapped()) {
                        chart.makeTable(true, false);
                    }
                    chart.makeTable(true, true);
                }
            } else if (_chart == null) {
                Object[] argsValue = new Object[3];
                Class[] argsClass = new Class[3];
                Object[] newObj = new Object[]{Array.newInstance(ColData.class, 1), Array.newInstance(Boolean.TYPE, 1)};
                argsValue[0] = component;
                argsValue[1] = colData;
                argsValue[2] = usedColumnsList;
                argsClass[0] = Component.class;
                argsClass[1] = newObj[0].getClass();
                argsClass[2] = newObj[1].getClass();
                Constructor<?> objCons = objClass.getConstructor(argsClass);
                chart = (Chart)objCons.newInstance(argsValue);
            } else {
                Object[] argsValue = new Object[1];
                Class[] argsClass = new Class[1];
                argsValue[0] = _chart;
                argsClass[0] = Chart.class;
                Constructor<?> objCons = objClass.getConstructor(argsClass);
                chart = (Chart)objCons.newInstance(argsValue);
                if (chart.chartType != _chart.chartType) {
                    if (_chart.isSaveColorsForCategories() && _chart.chartColorSet.isDataPointsColorsMapped()) {
                        chart.makeTable(true, false);
                    } else {
                        chart.makeTable(true, true);
                    }
                }
            }
        }
        catch (Exception ex) {
            String errorMsg = IOUtil.getStackTrace(ex);
            if (errorMsg.indexOf("No category data to plot") >= 0) {
                throw nocategoryError;
            }
            if (errorMsg.indexOf("No numeric data to plot") >= 0) {
                throw nonumericError;
            }
            if (errorMsg.indexOf("Not enough data column to plot") >= 0) {
                throw notenoughError;
            }
            ex.printStackTrace();
            try {
                chart = CreateChart.createChart(component, chartType, is2DChart, _chart, colData, usedColumnsList);
            }
            catch (Exception ex2) {
                throw new IllegalArgumentException("Failed to create chart" + ex.toString());
            }
        }
        if (_chart != null) {
            chart.copyChartAttributes3D(_chart);
            if (_chart.getComboType() > 0) {
                chart.setComboType(_chart.getComboType());
            }
        }
        return chart;
    }

    public static String TypeName(int ctype, boolean is2D) {
        if (is2D) {
            return "2D " + stypeName[ctype] + " Chart";
        }
        if (ctype != 2) {
            return "3D " + stypeName[ctype] + " Chart";
        }
        return "3D XYZ Chart";
    }

    public static final boolean stackType(int ctype) {
        return ctype == 4 || ctype == 5 || ctype == 8 || ctype == 11;
    }

    public static final boolean isHiLowChart(int ctype) {
        return ctype == 9 || ctype == 10 || ctype == 18;
    }

    public static boolean equalsIgnoreAggr(String name1, String name2) {
        String str2;
        String str1;
        if (name1.length() > name2.length()) {
            str1 = name1;
            str2 = name2;
        } else {
            str1 = name2;
            str2 = name1;
        }
        if (str1.equals("count_" + str2)) {
            return true;
        }
        if (str1.equals("max_" + str2)) {
            return true;
        }
        if (str1.equals("min_" + str2)) {
            return true;
        }
        if (str1.equals("sum_" + str2)) {
            return true;
        }
        if (str1.equals("avg_" + str2)) {
            return true;
        }
        if (str1.equals("first_" + str2)) {
            return true;
        }
        if (str1.equals("last_" + str2)) {
            return true;
        }
        if (str1.equals("sumsquare_" + str2)) {
            return true;
        }
        if (str1.equals("variance_" + str2)) {
            return true;
        }
        if (str1.equals("stddev_" + str2)) {
            return true;
        }
        return str1.equals("countdistinct_" + str2);
    }

    public String[] getParamPageChartDisplayTypes() {
        return this.paramPageChartDisplayTypes;
    }

    public void setParamPageChartDisplayTypes(String[] formats) {
        this.paramPageChartDisplayTypes = formats;
    }

    public String getExtraFormContent() {
        return this.extraFormContent;
    }

    public void setExtraFormContent(String extra) {
        this.extraFormContent = extra;
    }

    public boolean isPrevParamPrompt() {
        return true;
    }

    public void setPrevParamPrompt(boolean isPrevParamPrompt) {
        this.isPrevParamPrompt = isPrevParamPrompt;
    }

    public IStringCustomizer getStringCustomizer() {
        return this.stringCustomizer;
    }

    public void setStringCustomizer(IStringCustomizer customizer) {
        this.stringCustomizer = customizer;
    }

    public Vector<IQueryInParam> getQueryParameters() {
        Vector<IQueryInParam> queryParameters;
        block3: {
            IQueryInParam[] params;
            block2: {
                IQueryInParam[] params2;
                queryParameters = new Vector<IQueryInParam>();
                if (this.dbInfo == null || !(this.dbInfo instanceof IQueryFileInfo)) break block2;
                for (IQueryInParam param : params2 = quadbase.util.internal.QbUtil.getInParam(this.dbInfo)) {
                    queryParameters.addElement(param);
                }
                break block3;
            }
            if (this.dbInfo == null || !(this.dbInfo instanceof QueryXMLFileInfo)) break block3;
            for (IQueryInParam param : params = quadbase.util.internal.QbUtil.getInParam(((QueryXMLFileInfo)this.dbInfo).getXMLFileQueryInfo())) {
                queryParameters.addElement(param);
            }
        }
        return queryParameters;
    }

    public boolean isChanging3DChartType() {
        return this.changing3DChartType;
    }

    public void setChanging3DChartType(boolean b) {
        this.changing3DChartType = b;
    }

    private Object getPluginObject(String className, Class<?>[] argsClass, Object[] argsValue) {
        try {
            Class<?> objClass = Class.forName(className);
            Constructor<?> objCons = objClass.getConstructor(argsClass);
            return objCons.newInstance(argsValue);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to load plugin object.", e);
            return null;
        }
    }

    public boolean showTable() {
        return this.gt != null && this.tableInPanel;
    }

    public GraphicsTable getTable() {
        return this.gt;
    }

    public boolean isSecondaryDataShownInPrimaryTab() {
        return this.showSecDataInPrimaryTab && !this.isOverlayCombo();
    }

    public void setSecondaryDataShownInPrimaryTab(boolean b) {
        this.showSecDataInPrimaryTab = b;
    }

    public String customizeImageMapDataHintBox(String str) {
        if (this.customizeImageMapDataHintBox != null) {
            return this.customizeImageMapDataHintBox.customizeHintBox(str);
        }
        return str;
    }

    public ICustomizeImageMapDataHintBox getCustomizeImageMapDataHintBox() {
        return this.customizeImageMapDataHintBox;
    }

    public void setCustomizeImageMapDataHintBox(ICustomizeImageMapDataHintBox x) {
        this.customizeImageMapDataHintBox = x;
    }

    public FileInMemTable getSubFilesTable() {
        return this.subFilesTable;
    }

    public void setSubFilesTable(FileInMemTable subFilesTable) {
        this.subFilesTable = subFilesTable;
    }

    public ByteArrayInputStream getSubFileStream(String fileName) {
        return Chart.getSubFileStream(this.subFilesTable, fileName);
    }

    public void putChartFileIntoMemoryTable(String fileName, byte[] value) {
        if (value == null) {
            LOGGER.log(Level.FINEST, "Value is null, FILE NAME = " + fileName, new Exception());
        }
        LOGGER.log(Level.FINEST, "Saving chart, FILE NAME = " + fileName + ", to the memory table");
        this.subFilesTable.put(fileName, value);
    }

    public boolean isPACFile() {
        return this.getSubFilesTable().size() > 0;
    }

    public String getPACFileName(String chtFileName) {
        if (chtFileName.toLowerCase().endsWith(".pac")) {
            return chtFileName;
        }
        if (chtFileName.toLowerCase().endsWith(".cht")) {
            return chtFileName.substring(0, chtFileName.length() - 4) + ".pac";
        }
        return chtFileName + ".pac";
    }

    public void mergeSubFilesTable(FileInMemTable tbl) {
        if (tbl == null) {
            return;
        }
        Enumeration e = this.subFilesTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            byte[] value = this.subFilesTable.get(key);
            tbl.put(key, value);
        }
        this.subFilesTable = tbl;
    }

    public abstract Image exportImageObject(int var1, int var2);

    public abstract ExportChart createExportChart();

    public void get_directExport(String filename, String mapFilename, int format, int w, int h, Component component, boolean generateDataMapFile, int quality) throws Exception {
        this.createExportChart().do_directExport(filename, mapFilename, format, w, h, component, generateDataMapFile, quality);
    }

    public void get_directExport(String filename, String drillDownChartName, int format, int w, int h, Component component, String servletLoc, PickData[] pickData, String[] argv, int quality) throws Exception {
        this.createExportChart().do_directExport(filename, drillDownChartName, format, w, h, component, servletLoc, pickData, argv, quality);
    }

    public synchronized void get_directExport(OutputStream image, OutputStream subFile, String fileName, int format, int w, int h, Component component, boolean generateDataMapFile, int quality) throws Exception {
        this.createExportChart().do_directExport(image, subFile, fileName, fileName, null, format, w, h, component, null, null, null, generateDataMapFile, quality);
    }

    public void get_directExport(OutputStream image, OutputStream subFile, String fileName, String chartLocation, int format, int w, int h, Component component, String servletLoc, PickData[] pickData, String[] argv, int quality) throws Exception {
        this.createExportChart().do_directExport(image, subFile, fileName, fileName, chartLocation, format, w, h, component, servletLoc, pickData, argv, true, quality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDataFile(String filename, int separator, int format) throws Exception {
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(1024);
        PrintStream pout = new PrintStream(fstream);
        try {
            pout = new PrintStream(fstream);
            this.exportDataFile(pout, separator, format);
            if (format == 1) {
                new WriteDataFile().output(fstream.toByteArray(), filename + ".xml");
            } else {
                new WriteDataFile().output(fstream.toByteArray(), filename + ".txt");
            }
        }
        finally {
            fstream.close();
        }
    }

    public void exportDataFile(PrintStream pout, int separator, int format) throws Exception {
        if (!this.processedChart) {
            ColData.print(pout, this.colData, separator, format);
        } else {
            ColData.print(pout, ReloadChart.getOriginalColData(this, true), separator, format);
        }
    }

    public boolean isBufferedImageUsed() {
        return this.useBufferedImage && IOUtil.isJava2D();
    }

    public void setBufferedImageUsed(boolean b) {
        this.useBufferedImage = b;
    }

    public int getBufferedImageType() {
        return this.isBackgroundTransparent ? 3 : this.imageType;
    }

    public void setBufferedImageType(int imageType) {
        this.imageType = imageType;
    }

    public boolean isJ2DRotateEnabled() {
        return this.j2DRotateText;
    }

    public void setJ2DRotateEnabled(boolean b) {
        this.j2DRotateText = b;
    }

    public boolean isDisableJava2DForStraightText() {
        return this.disableJava2DForStraightText;
    }

    public void setDisableJava2DForStraightText(boolean b) {
        this.disableJava2DForStraightText = b;
    }

    public void setAdjust3DDisplayView(boolean b) {
        this.adjust3DView = b;
    }

    public GradientSupport getPrimaryDataGradientSupport() {
        return this.primaryDataGradientSupport;
    }

    public GradientSupport getSecondaryDataGradientSupport() {
        return this.secondaryDataGradientSupport;
    }

    public int getCutOffThresholdForText() {
        return this.cutOffThresholdForText;
    }

    public void setCutOffThresholdForText(int i) {
        this.cutOffThresholdForText = i;
        if (this.legend != null) {
            this.legend.invalidate();
        }
        if (this.legend2 != null) {
            this.legend2.invalidate();
        }
        if (this.mainTitle != null) {
            this.mainTitle.invalid = true;
            this.mainTitle.initFont = true;
        }
        for (int j = 0; j < this.axis.length; ++j) {
            if (this.axis[j] == null || this.axis[j].title == null) continue;
            this.axis[j].title.invalid = true;
            this.axis[j].title.initFont = true;
            if (this.axis[j].ticker.label == null) continue;
            for (int k = 0; k < this.axis[j].ticker.label.length; ++k) {
                this.axis[j].ticker.label[k].invalid = true;
            }
        }
    }

    public abstract Axis setAxis(int var1, CString var2, boolean var3);

    public abstract float getlookfrom_x();

    public abstract float getlookto_x();

    public abstract float getlightpos_x();

    public abstract float getlookfrom_y();

    public abstract float getlookto_y();

    public abstract float getlightpos_y();

    public abstract float getlookfrom_z();

    public abstract float getlookto_z();

    public abstract float getlightpos_z();

    public abstract void setlookfrom_x(float var1);

    public abstract void setlookfrom_y(float var1);

    public abstract void setlookfrom_z(float var1);

    public abstract Object getSpace();

    public abstract Object gethiddenSurface();

    public abstract void copyChartAttributes3D(Chart var1);

    public abstract Area newArea();

    public abstract Area newArea(Color var1);

    public abstract Area copyArea(Area var1);

    protected abstract Axis copyAxis(Axis var1);

    protected abstract DataLineSet newDataLineSet();

    protected abstract DataLineSet newDataLineSet(DataLineSet var1);

    public Color get3DSurfaceColor() {
        return this.surfaceColor;
    }

    public void set3DSurfaceColor(Color color) {
        this.surfaceColor = color;
    }

    public boolean isShowSeriesInTopLabel() {
        return this.showSeriesInTopLabel;
    }

    public void showSeriesInTopLabel(boolean b) {
        this.showSeriesInTopLabel = b;
    }

    public boolean isTranslucentSupport() {
        return IOUtil.isJava2D() && this.doTranslucent;
    }

    public boolean isTranslucent() {
        return this.doTranslucent;
    }

    public void setTranslucent(boolean b) {
        this.doTranslucent = this.chartType == 13 && this.bubble3D ? false : b;
    }

    public float getTranslucentValue() {
        return this.translucentValue;
    }

    public void setTranslucentValue(float b) {
        this.translucentValue = b;
    }

    public Vector<ControlRange> getControlRangeList() {
        return this.controlRangeList;
    }

    public void setControlRangeList(Vector<ControlRange> v) {
        this.controlRangeList = v;
    }

    public boolean isControlRangeEnabled() {
        return !Chart.isCircularChart(this.chartType) && this.chartType != 16 && this.chartType != 19 && this.is2DimChart();
    }

    public boolean isZoomScrollEnabled() {
        if (!this.is2DChart) {
            return false;
        }
        if (this.isTimeChart()) {
            return false;
        }
        if (this.dataLineSet != null && this.dataLineSet.getDataLineList() != null && this.dataLineSet.getDataLineList().size() > 0) {
            return false;
        }
        if (this.subvalueCol >= 0) {
            return false;
        }
        if (this.chartType == 13) {
            return false;
        }
        if (this.chartType == 19) {
            return false;
        }
        if (this.chartType == 6) {
            return false;
        }
        if (this.chartType == 20) {
            return false;
        }
        if (this.chartType == 17) {
            return false;
        }
        if (this.chartType == 18) {
            return false;
        }
        if (this.chartType == 12) {
            return false;
        }
        if (this.chartType == 16) {
            return false;
        }
        if (this.chartType == 14) {
            if (this.colDataAxis == null) {
                return true;
            }
            for (Axis colDataAxi : this.colDataAxis) {
                if (colDataAxi == null) continue;
                return false;
            }
        }
        if (this.chartType == 15 && this.orient == 1) {
            return false;
        }
        if (this.chartType == 3) {
            if (this.orient == 1) {
                return false;
            }
            if (this.showDropBarForLine) {
                return false;
            }
            if (this.showStepLine) {
                return false;
            }
        } else if (this.chartType != 2 && this.showLine) {
            return false;
        }
        return true;
    }

    public int getZoomOption() {
        return this.zoomOption;
    }

    public void setZoomOption(int option) {
        this.zoomOption = option;
    }

    public boolean isVertical() {
        return this.chartType != 1 && (this.chartType != 15 || this.orient != 0) && this.chartType != 18 && this.chartType != 5;
    }

    public double getStartAngleForDial() {
        return this.startingAngleForDial;
    }

    public void setStartAngleForDial(double angle) {
        this.startingAngleForDial = angle;
    }

    public double getEndAngleForDial() {
        return this.endingAngleForDial;
    }

    public void setEndAngleForDial(double angle) {
        this.endingAngleForDial = angle;
    }

    public double getRadiusForInternalDial() {
        return this.radiusForInternalDial;
    }

    public void setRadiusForInternalDial(double p) {
        this.radiusForInternalDial = p;
    }

    public Color getCenterColorForDial() {
        return Color.black;
    }

    public void setCenterColorForDial(Color c) {
    }

    public boolean isDrawFullCircleForDial() {
        return this.drawFullCircleForDial;
    }

    public void setDrawFullCircleForDial(boolean b) {
        this.drawFullCircleForDial = b;
    }

    public int getSubTickerLength() {
        return this.subTickerLength;
    }

    public void setSubTickerLength(int t) {
        this.subTickerLength = t;
    }

    public int getTickerLength() {
        return this.tickerLength;
    }

    public void setTickerLength(int t) {
        this.tickerLength = t;
    }

    public boolean is3DShadowForTickerOn() {
        return this.turnOn3DShadowForTicker;
    }

    public void set3DShadowForTickerOn(boolean b) {
        this.turnOn3DShadowForTicker = b;
    }

    public int getSubTickerCount() {
        return this.subTickerCount;
    }

    public void setSubTickerCount(int ct) {
        this.subTickerCount = ct;
    }

    public int getSubTickerThickness() {
        return this.subTickerThickness;
    }

    public void setSubTickerThickness(int t) {
        this.subTickerThickness = t;
    }

    public boolean isPointerUsed() {
        return this.usePointer;
    }

    public void setPointerUsed(boolean b) {
        this.usePointer = b;
        this.needleOption = b ? 1 : 3;
    }

    public int getNeedleOption() {
        return this.needleOption;
    }

    public void setNeedleOption(int v) {
        this.needleOption = v;
    }

    public double getPieGroupOthersLimit() {
        return this.pieOthersLimit;
    }

    public void setPieGroupOthersLimit(double limit) {
        if (!Chart.isCircularChart(this.chartType) && this.colData[this.mDataMap[0]].isPieWithOthers()) {
            this.remakeTable = true;
            this.colData[this.mDataMap[0]].bGenUniqueName = false;
            this.colData[this.mDataMap[0]].setPieWithOthers(false);
            return;
        }
        if (limit <= 0.0 && this.pieOthersLimit <= 0.0 || !Chart.isCircularChart(this.chartType)) {
            return;
        }
        if (Chart.isCircularChart(this.chartType) && (this.pieOthersLimit <= 0.0 && limit > 0.0 || this.pieOthersLimit > 0.0 && limit <= 0.0)) {
            this.remakeTable = true;
            this.colData[this.mDataMap[0]].bGenUniqueName = false;
            this.colData[this.mDataMap[0]].setPieWithOthers(limit > 0.0);
        }
        this.pieOthersLimit = limit;
    }

    public boolean isPieOthersLimitOn() {
        return Chart.isCircularChart(this.chartType) && this.pieOthersLimit > 0.0;
    }

    public String getPieGroupOthersName() {
        return this.pieOthersName;
    }

    public void setPieGroupOthersName(String s) {
        this.pieOthersName = s;
        this.colData[this.mDataMap[0]].setPieOthersSectorName(s);
    }

    public double getColorThresholdForPie() {
        return this.colorThresholdForPie;
    }

    public void setColorThresholdForPie(double i) {
        this.colorThresholdForPie = i;
    }

    public Color[] getColorArrayForPieThreshold() {
        return this.colorArrayForPieThreshold;
    }

    public void setColorArrayForPieThreshold(Color[] colors) {
        this.colorArrayForPieThreshold = colors;
    }

    public int getNoSectionForPolar() {
        return this.noSectionForPolar;
    }

    public void setNoSectionForPolar(int i) {
        this.noSectionForPolar = i;
        this.startAngleForPolar = this.calulateStartAngleForPolar(this.startAngleForPolar);
    }

    public double getStartAngleForPolar() {
        return this.startAngleForPolar;
    }

    public void setStartAngleForPolar(double i) {
        this.startAngleForPolar = this.calulateStartAngleForPolar(i);
    }

    public boolean isRadianForPolar() {
        return this.isRadianForPolar;
    }

    public void setRadianForPolar(boolean b) {
        this.isRadianForPolar = b;
    }

    public boolean isClockWiseForPolar() {
        return this.clockWiseForPolar;
    }

    public void setClockWiseForPolar(boolean b) {
        this.clockWiseForPolar = b;
    }

    public double calulateStartAngleForPolar(double stAngle) {
        double secAngle = Math.PI * 2 / (double)this.noSectionForPolar;
        return Math.rint(stAngle / secAngle) * secAngle;
    }

    public void setLayout(int x, boolean isLoadingChart) {
        if (!isLoadingChart && this.orient != x) {
            this.swapAxisProperties();
        }
        this.orient = x;
    }

    public int getLayout() {
        return this.orient;
    }

    public void setLayout(int x) {
        this.setLayout(x, false);
    }

    public int getControlRangeThickness() {
        int t = 0;
        for (int i = 0; i < this.controlRangeList.size(); ++i) {
            int n = this.controlRangeList.elementAt(i).getThickness();
            if (n <= t) continue;
            t = n;
        }
        return t;
    }

    public void setControlRangeThickness(int t) {
        for (int i = 0; i < this.controlRangeList.size(); ++i) {
            this.controlRangeList.elementAt(i).setThickness(t);
        }
    }

    public int countLabelOffset() {
        return 0;
    }

    public void setLabelOffset(int categoryIndex, Dimension dim) {
    }

    public void setLabelOffset(Dimension[] dim) {
    }

    public Dimension getLabelOffset(int categoryIndex) {
        return new Dimension(0, 0);
    }

    public void drawAxis(CGraphics g, Axis axis) {
    }

    public boolean isSynchronizeRadarAxis() {
        return this.synchronizeRadarAxis;
    }

    public void setSynchronizeRadarAxis(boolean b) {
        this.synchronizeRadarAxis = b;
    }

    public boolean isDrawCircularGrid() {
        return this.drawCircularGrid;
    }

    public void setDrawCircularGrid(boolean b) {
        this.drawCircularGrid = b;
    }

    public boolean isAreaCutOffSupport() {
        if (this.chartType == 16) {
            return IOUtil.isJava2D() && this.areaCutOffPoint != null;
        }
        if (this.chartType == 2 && this.is2DimChart()) {
            return this.areaCutOffPoint != null;
        }
        return false;
    }

    public Double getAreaCutOffPoint() {
        return this.areaCutOffPoint;
    }

    public void setAreaCutOffPoint(Double d) {
        this.areaCutOffPoint = d;
    }

    public void drawTickerForRadar(CGraphics g, Axis axis) {
    }

    public boolean isShowDoubleValueForLine() {
        return this.showDoubleValueForLine && this.chartType == 3 && this.subvalueCol >= 0 && this.is2DimChart();
    }

    public void setShowDoubleValueForLine(boolean state) {
        if (this.chartType == 3 && this.subvalueCol >= 0 && this.is2DimChart()) {
            if (state) {
                this.setPointState2(true);
            } else {
                this.setPointState2(this.showPoint2);
            }
        }
        this.showDoubleValueForLine = state;
    }

    public boolean isSyncPointColorForLine() {
        return this.syncPointColor;
    }

    public void setSyncPointColorForLine(boolean state) {
        this.syncPointColor = state;
    }

    public boolean isShowDropBarForLine() {
        return this.showDropBarForLine && this.chartType == 3 && this.dataDim >= 2 && this.is2DimChart() && this.mDataLen[0] >= 2;
    }

    public void setShowDropBarForLine(boolean state) {
        if (this.chartType == 3 && this.dataDim >= 2 && this.is2DimChart() && this.mDataLen[0] >= 2) {
            this.setOffsetTicker(state);
        }
        this.showDropBarForLine = state;
    }

    public int getDropBarSeries1() {
        return this.dropBarSeries1;
    }

    public void setDropBarSeries1(int ser) {
        this.dropBarSeries1 = ser;
    }

    public int getDropBarSeries2() {
        return this.dropBarSeries2;
    }

    public void setDropBarSeries2(int ser) {
        this.dropBarSeries2 = ser;
    }

    public Color getDropBarColor() {
        return this.dropBarColor;
    }

    public void setDropBarColor(Color c) {
        this.dropBarColor = c;
    }

    public Color getDropBarColor2() {
        return this.dropBarColor2;
    }

    public void setDropBarColor2(Color c) {
        this.dropBarColor2 = c;
    }

    public boolean getDropBarBorderState() {
        return this.dropBarBorder;
    }

    public void setDropBarBorderState(boolean b) {
        this.dropBarBorder = b;
    }

    public boolean getStepLineState() {
        return this.showStepLine;
    }

    public void setStepLineState(boolean b) {
        this.showStepLine = b;
        int bLength = this.chartType == 8 || this.chartType == 5 || this.chartType == 4 ? this.mDataLen[this.dataDim - 1] : (this.dataDim > 1 ? this.mDataLen[0] : 1);
        this.selectStep = new boolean[bLength];
        for (int i = 0; i < bLength; ++i) {
            this.selectStep[i] = this.showStepLine;
        }
    }

    public boolean isSelectiveStepLineUsed() {
        return this.isSelectiveStep;
    }

    public void setSelectiveStepLineState(boolean[] b, boolean override) {
        this.isSelectiveStep = true;
        this.showStepLine = true;
        int bLength = 20;
        if (this.chartType == 8 || this.chartType == 5 || this.chartType == 4) {
            bLength = this.mDataLen[this.dataDim - 1];
        } else {
            int n = bLength = this.dataDim > 1 ? this.mDataLen[0] : 1;
        }
        if (override) {
            bLength = Math.min(bLength, b.length);
        }
        this.selectStep = new boolean[bLength];
        for (int i = 0; i < bLength; ++i) {
            this.selectStep[i] = b[i];
        }
    }

    public boolean[] getSelectiveStepLineState() {
        return this.selectStep;
    }

    public void setSelectiveStepLineState(boolean[] b) {
        this.setSelectiveStepLineState(b, false);
    }

    public double getStepLineRatio() {
        return this.stepRatio;
    }

    public void setStepLineRatio(double r) {
        this.stepRatio = r > 0.999999 ? 0.999999 : (r < 0.0105 ? 0.0105 : r);
    }

    public boolean getStepLineState2() {
        return this.showStepLine2;
    }

    public void setStepLineState2(boolean b) {
        this.showStepLine2 = b;
        int bLength = 20;
        bLength = this.chartType == 8 || this.chartType == 5 || this.chartType == 4 ? this.mDataLen[this.dataDim - 1] : (this.dataDim > 1 ? this.mDataLen[0] : 1);
        this.selectStep = new boolean[bLength];
        for (int i = 0; i < bLength; ++i) {
            this.selectStep[i] = this.showStepLine2;
        }
    }

    public boolean isSelectiveStepLineUsed2() {
        return this.isSelectiveStep;
    }

    public void setSelectiveStepLineState2(boolean[] b, boolean override) {
        this.isSelectiveStep = true;
        this.showStepLine2 = true;
        int bLength = 20;
        if (this.chartType == 8 || this.chartType == 5 || this.chartType == 4) {
            bLength = this.mDataLen[this.dataDim - 1];
        } else {
            int n = bLength = this.dataDim > 1 ? this.mDataLen[0] : 1;
        }
        if (override) {
            bLength = Math.min(bLength, b.length);
        }
        this.selectStep = new boolean[bLength];
        for (int i = 0; i < bLength; ++i) {
            this.selectStep[i] = b[i];
        }
    }

    public boolean[] getSelectiveStepLineState2() {
        return this.selectStep;
    }

    public void setSelectiveStepLineState2(boolean[] b) {
        this.setSelectiveStepLineState2(b, false);
    }

    public double getStepLineRatio2() {
        return this.stepRatio2;
    }

    public void setStepLineRatio2(double r) {
        this.stepRatio2 = r > 0.999999 ? 0.999999 : (r < 0.0105 ? 0.0105 : r);
    }

    public boolean isDrawAreaUnderLine() {
        return this.drawAreaUnderLine;
    }

    public void setDrawAreaUnderLine(boolean state) {
        this.drawAreaUnderLine = state;
    }

    public void setAreaUnderLineColors(Color colorAbove, Color colorBelow) {
        this.upAreaColor = colorAbove;
        this.downAreaColor = colorBelow;
    }

    public Color getAreaUnderLineColorAbove() {
        return this.upAreaColor;
    }

    public Color getAreaUnderLineColorBelow() {
        return this.downAreaColor;
    }

    public boolean isDataDrawnOnTop() {
        return this.dataDrawnOnTop;
    }

    public void setDataDrawnOnTop(boolean state) {
        this.dataDrawnOnTop = state;
    }

    public boolean isDrawSeriesOnCategoryAxis() {
        return this.drawSeriesOnCategoryAxis;
    }

    public void setDrawSeriesOnCategoryAxis(boolean b) {
        this.drawSeriesOnCategoryAxis = b;
        if (!this.is2DimChart()) {
            this.newSurface();
        }
    }

    public boolean isShowShadowOnLine() {
        return this.showShadowOnLine;
    }

    public void setShowShadowOnLine(boolean b) {
        this.showShadowOnLine = b;
    }

    public boolean isShowShadowOnPoint() {
        return this.showShadowOnPoint;
    }

    public void setShowShadowOnPoint(boolean b) {
        this.showShadowOnPoint = b;
    }

    public boolean isDrawBorderForWMF() {
        return this.drawBorderForWMF;
    }

    public void setDrawBorderForWMF(boolean b) {
        this.drawBorderForWMF = b;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale l) {
        this.locale = l;
        for (ColData element : this.colData) {
            Chart.setLocale(element.dataFormat, this.locale);
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone zone) {
        this.timeZone = zone;
        for (ColData element : this.colData) {
            Chart.setTimeZone(element.dataFormat, zone);
        }
    }

    public void doTypeMapping() {
    }

    private void swapAxisProperties() {
        StepSize tmpStep = this.a_x.stepsize;
        this.a_x.stepsize = this.a_y.stepsize;
        this.a_y.stepsize = tmpStep;
        if (this.a_y.title.automatic) {
            this.a_y.title.setDirection(2);
        }
        if (this.a_x.title.automatic) {
            this.a_x.title.setDirection(0);
        }
        Color color1 = this.getTickerColor(0);
        Color color2 = this.getTickerColor(1);
        Font font1 = this.getTickerFont(0);
        Font font2 = this.getTickerFont(1);
        this.setTickerColor(0, color2);
        this.setTickerColor(1, color1);
        this.setTickerFont(0, font2);
        this.setTickerFont(1, font1);
        double logBase = this.a_x.logBase;
        boolean logScale = this.a_x.logScale;
        boolean isShowLogValue = this.a_x.isShowLogValue();
        boolean isShowSubTickers = this.a_x.isShowSubTickers();
        this.a_x.logBase = this.a_y.logBase;
        this.a_x.logScale = this.a_y.logScale;
        this.a_x.setShowLogValue(this.a_y.isShowLogValue());
        this.a_x.setShowSubTickers(this.a_y.isShowSubTickers());
        this.a_y.logBase = logBase;
        this.a_y.logScale = logScale;
        this.a_y.setShowLogValue(isShowLogValue);
        this.a_y.setShowSubTickers(isShowSubTickers);
    }

    protected void copyChartAttributes(Chart _chart) {
        int i;
        this.component = _chart.component;
        for (i = 0; i < 4; ++i) {
            this.axis[i] = this.copyAxis(_chart.axis[i]);
            this.setAxisState(i, _chart.axis[i].bshow);
        }
        this.a_x = this.axis[0];
        this.a_y = this.axis[1];
        this.a_z = this.axis[2];
        this.a_s = this.axis[3];
        if (DataLine.isBarChartType(_chart) != DataLine.isBarChartType(this)) {
            this.swapAxisProperties();
        }
        boolean match = true;
        this.summaryChart = _chart.summaryChart;
        this.isDynamicDrillDown = _chart.isDynamicDrillDown;
        this.drillNumber = _chart.drillNumber;
        if (_chart.drillDownVector != null) {
            this.drillDownVector = (Vector)_chart.drillDownVector.clone();
        }
        this.drillTemplateName = _chart.drillTemplateName;
        this.drillTemplatePath = _chart.drillTemplatePath;
        this.primaryAggregate = _chart.primaryAggregate;
        this.secondaryAggregate = _chart.secondaryAggregate;
        if (_chart.usedColumns != null) {
            this.usedColumns = (boolean[])_chart.usedColumns.clone();
        }
        this.unusedDataAttribute = _chart.unusedDataAttribute;
        this.unusedDataAttribute2 = _chart.unusedDataAttribute2;
        for (i = 0; i < 5; ++i) {
            this.originalMap[i] = _chart.originalMap[i];
        }
        this.originalHiLowMap.copy(_chart.originalHiLowMap);
        this.processedChart = _chart.processedChart;
        this.histogram = _chart.histogram;
        this.showPercentage = _chart.showPercentage;
        this.binNumber = _chart.binNumber;
        this.isAggregationChart = _chart.isAggregationChart;
        this.colDataHasChangedBecauseOfAggrHistZoom = _chart.colDataHasChangedBecauseOfAggrHistZoom;
        this.originalColDataFromMemSource = _chart.originalColDataFromMemSource;
        if (_chart.colData.length == this.colData.length) {
            for (i = 0; i < this.colData.length; ++i) {
                if (this.colData[i].dataType == _chart.colData[i].dataType) continue;
                match = false;
                break;
            }
        } else {
            match = false;
        }
        if (match) {
            for (i = 0; i < 3; ++i) {
                this.coordCol[i] = _chart.coordCol[i];
                this.bcoordCol[i] = _chart.bcoordCol[i];
            }
            for (i = 0; i <= this.nCol; ++i) {
                this.colData[i].copyAttributes(_chart.colData[i]);
            }
            this.secData = _chart.secData;
            this.axisData = _chart.axisData;
            this.colDataAxis = _chart.colDataAxis;
        }
        this.mainTitle = _chart.mainTitle.copy();
        if (match) {
            System.arraycopy(_chart.bmDataMap, 0, this.bmDataMap, 0, this.nCol <= _chart.bmDataMap.length ? this.nCol : _chart.bmDataMap.length);
            this.parameters = _chart.parameters;
            System.arraycopy(_chart.mDataMap, 0, this.mDataMap, 0, this.nCol <= _chart.mDataMap.length ? this.nCol : _chart.mDataMap.length);
            this.valueCol = _chart.valueCol;
            this.subvalueCol = _chart.subvalueCol;
            System.arraycopy(_chart.mDataLen, 0, this.mDataLen, 0, this.nCol);
            this.hilowCol.copy(_chart.hilowCol);
        } else {
            this.subvalueCol = -1;
        }
        this.background = this.copyArea(_chart.background);
        this.border = this.copyArea(_chart.border);
        this.showPoint = (_chart.chartType == 2 || _chart.chartType == 13 || _chart.chartType == 19) && this.chartType != 2 && this.chartType != 13 && this.chartType != 19 ? false : (_chart.chartType != 2 && _chart.chartType != 13 && _chart.chartType != 19 && (this.chartType == 2 || this.chartType == 13 || this.chartType == 19) ? true : _chart.showPoint);
        this.showLine = _chart.chartType == 3 && this.chartType != 3 || _chart.chartType == 14 && this.chartType != 14 ? false : (_chart.chartType == 14 && this.chartType == 14 && _chart.dataDim != this.dataDim ? (this.dataDim == 2 ? true : _chart.showLine) : _chart.showLine);
        if (_chart.chartType == 3 && this.chartType != 3) {
            this.showStepLine = false;
            this.isSelectiveStep = false;
            this.selectStep = null;
        } else {
            this.showStepLine = _chart.showStepLine;
            this.isSelectiveStep = _chart.isSelectiveStep;
            this.selectStep = _chart.selectStep;
        }
        if (_chart.getComboType() == 0 && this.getComboType() != 0) {
            this.showStepLine2 = false;
            this.isSelectiveStep = false;
            this.selectStep = null;
        } else {
            this.showStepLine2 = _chart.showStepLine2;
            this.isSelectiveStep = _chart.isSelectiveStep;
            this.selectStep = _chart.selectStep;
        }
        this.useBufferedImage = _chart.useBufferedImage;
        this.imageType = _chart.imageType;
        this.showChart = _chart.showChart;
        this.showArea = _chart.showArea;
        this.showPoint2 = _chart.showPoint2;
        this.drawPointBorder = _chart.drawPointBorder;
        this.drawPointBorder2 = _chart.drawPointBorder2;
        this.drawPointBorderColor = _chart.drawPointBorderColor;
        this.drawPointBorderColor2 = _chart.drawPointBorderColor2;
        this.stepRatio = _chart.stepRatio;
        this.stepRatio2 = _chart.stepRatio2;
        this.showLine2 = _chart.showLine2;
        this.showData = _chart.showData;
        this.showTopValue = _chart.showTopValue;
        this.showTopValue2 = _chart.showTopValue2;
        this.showStackLabel = _chart.showStackLabel;
        this.showStackTotalLabel = _chart.showStackTotalLabel;
        this.showArrow = _chart.showArrow;
        this.showWallFrame = _chart.showWallFrame;
        this.thickRatio = _chart.thickRatio;
        this.barwidthRatio = _chart.barwidthRatio;
        this.maxBarWidthRatioToPlotArea = _chart.maxBarWidthRatioToPlotArea;
        this.j2DRotateText = _chart.j2DRotateText;
        this.disableJava2DForStraightText = _chart.disableJava2DForStraightText;
        this.cutOffThresholdForText = _chart.cutOffThresholdForText;
        this.showOffsetTicker = _chart.showOffsetTicker;
        this.wallbackground = this.copyArea(_chart.wallbackground);
        this.desktopArea = this.copyArea(_chart.desktopArea);
        this.isBackgroundTransparent = _chart.isBackgroundTransparent;
        this.isTransposed = _chart.isTransposed;
        this.transposeCol = _chart.transposeCol;
        this.isDataLimitAtAxisScale = _chart.isDataLimitAtAxisScale;
        this.copyChartAttributes3D(_chart);
        this.setChartGraphics(_chart.getChartGraphics());
        this.renderingKey = _chart.renderingKey;
        this.renderingValue = _chart.renderingValue;
        this.setAntiAliasForChartOnly = _chart.setAntiAliasForChartOnly;
        this.setAntiAliasForText = _chart.setAntiAliasForText;
        this.primaryDataGradientSupport.copy(_chart.primaryDataGradientSupport);
        this.secondaryDataGradientSupport.copy(_chart.secondaryDataGradientSupport);
        this.customizeImageMapDataHintBox = _chart.customizeImageMapDataHintBox;
        if (_chart.legend != null && this.legend != null) {
            this.legend.copyAttrib(_chart.legend);
        }
        if (_chart.legend2 != null && this.legend2 != null) {
            this.legend2.copyAttrib(_chart.legend2);
        }
        this.legend_XProp = _chart.legend_XProp;
        this.legend_YProp = _chart.legend_YProp;
        this.legend2_XProp = _chart.legend2_XProp;
        this.legend2_YProp = _chart.legend2_YProp;
        this.title_XProp = _chart.title_XProp;
        this.title_YProp = _chart.title_YProp;
        this.chart_XProp = _chart.chart_XProp;
        this.chart_YProp = _chart.chart_YProp;
        this.chart_widthProp = _chart.chart_widthProp;
        this.chart_heightProp = _chart.chart_heightProp;
        this.xGap = _chart.xGap;
        this.fontResizeRatio = _chart.fontResizeRatio;
        this.stringList = _chart.stringList;
        this.hyperlinkList = HyperLink.copy(_chart.hyperlinkList);
        this.dataLineSet = this.newDataLineSet(_chart.dataLineSet);
        this.annotationSet = new AnnotationSet(this, _chart.annotationSet);
        this.flashRatio = _chart.flashRatio;
        this.flashFrameCount = _chart.flashFrameCount;
        this.flashFrameRate = _chart.flashFrameRate;
        this.flashRotateAngle = _chart.flashRotateAngle;
        this.flashHintFont = _chart.flashHintFont;
        this.flashHintFontColor = _chart.flashHintFontColor;
        this.flashHintBgColor = _chart.flashHintBgColor;
        this.flashHintBorderColor = _chart.flashHintBorderColor;
        this.flashEnableHintBox = _chart.flashEnableHintBox;
        this.lineList = _chart.lineList != null ? (Vector<Object>)_chart.lineList.clone() : _chart.lineList;
        this.refreshInterval = _chart.refreshInterval;
        this.disableSchedule = _chart.disableSchedule;
        this.topvalueLabel_font = _chart.topvalueLabel_font;
        this.topvalueLabel_color = _chart.topvalueLabel_color;
        this.topvalueNegativeLabel_color = _chart.topvalueNegativeLabel_color;
        this.topvalueLabel_angle = _chart.topvalueLabel_angle;
        this.toplabel_offset_up = _chart.toplabel_offset_up;
        this.toplabel_offset3D_up = _chart.toplabel_offset3D_up;
        this.toplabel_offset_side = _chart.toplabel_offset_side;
        this.toplabel_offset3D_side = _chart.toplabel_offset3D_side;
        this.topLabel_Alignment = _chart.topLabel_Alignment;
        this.stackLabel_Alignment = _chart.stackLabel_Alignment;
        this.topvalueLabel2_font = _chart.topvalueLabel2_font;
        this.topvalueLabel2_color = _chart.topvalueLabel2_color;
        this.topvalueLabel2_angle = _chart.topvalueLabel2_angle;
        this.toplabel2_offset_up = _chart.toplabel2_offset_up;
        this.toplabel2_offset3D_up = _chart.toplabel2_offset3D_up;
        this.toplabel2_offset_side = _chart.toplabel2_offset_side;
        this.toplabel2_offset3D_side = _chart.toplabel2_offset3D_side;
        this.topLabel2_Alignment = _chart.topLabel2_Alignment;
        this.isLabelOnPositiveSide = _chart.isLabelOnPositiveSide;
        this.isLabelOnNegativeSide = _chart.isLabelOnNegativeSide;
        this.drawAreaUnderLine = _chart.drawAreaUnderLine;
        this.upAreaColor = _chart.upAreaColor;
        this.downAreaColor = _chart.downAreaColor;
        this.dataDrawnOnTop = _chart.dataDrawnOnTop;
        this.backgroundImage = _chart.backgroundImage != null ? (ImageData)_chart.backgroundImage.clone() : null;
        this.showbackgroundImage = _chart.showbackgroundImage;
        if (_chart.chartType == 17) {
            this.showDialPlotBGImage = _chart.showDialPlotBGImage;
            this.showDialPlotFGImage = _chart.showDialPlotFGImage;
            this.dialPlotBGImage = _chart.dialPlotBGImage != null ? (ImageData)_chart.dialPlotBGImage.clone() : null;
            this.dialPlotFGImage = _chart.dialPlotFGImage != null ? (ImageData)_chart.dialPlotFGImage.clone() : null;
            this.dialBGPlotSizeRatio = _chart.dialBGPlotSizeRatio;
            this.dialFGPlotSizeRatio = _chart.dialFGPlotSizeRatio;
        }
        this.showNoDataToPlotMsg = _chart.showNoDataToPlotMsg;
        this.noDataToPlotMsg = _chart.noDataToPlotMsg;
        this.noDataToPlotMsgFont = _chart.noDataToPlotMsgFont;
        this.noDataToPlotMsgColor = _chart.noDataToPlotMsgColor;
        this.noDataToPlotMsgAngle = _chart.noDataToPlotMsgAngle;
        this.dbInfo = _chart.dbInfo;
        this.sourceFile = _chart.sourceFile;
        this.xmlFileQueryInfo = _chart.xmlFileQueryInfo;
        this.sfQueryInfo = _chart.sfQueryInfo;
        this.excelInfo = _chart.excelInfo;
        this.jndiName = _chart.jndiName;
        this.homeName = _chart.homeName;
        this.remoteName = _chart.remoteName;
        this.selectedMethodName = _chart.selectedMethodName;
        this.selectedMethodParamVal = _chart.selectedMethodParamVal;
        this.environment = _chart.environment;
        this.soapInfo = _chart.soapInfo;
        this.olapRS = _chart.olapRS;
        this.mondrianConnectionString = _chart.mondrianConnectionString;
        this.MDXQuery = _chart.MDXQuery;
        this.xmlaURI = _chart.xmlaURI;
        this.xmlaDataSource = _chart.xmlaDataSource;
        this.xmlaCatalog = _chart.xmlaCatalog;
        this.inputMethod = _chart.inputMethod;
        this.sourceList = _chart.sourceList;
        this.sourceType = _chart.sourceType;
        this.registryID = _chart.registryID;
        this.dataSourceID = _chart.dataSourceID;
        this.dataSourceLoc = _chart.dataSourceLoc;
        this.doTranspose = _chart.doTranspose;
        this.transposeColList = _chart.transposeColList;
        this.sourceData = _chart.sourceData;
        this.originalSourceData = _chart.originalSourceData;
        this.xmlChartLocation = _chart.xmlChartLocation;
        this.dbSourceType = _chart.dbSourceType;
        this.queryFileBytes = _chart.queryFileBytes;
        this.axisThickness = _chart.axisThickness;
        this.x_shift = _chart.x_shift;
        this.xlabelrow = _chart.xlabelrow;
        this.drawDataBorder = _chart.drawDataBorder;
        this.drawBorderForWhiteArea = _chart.drawBorderForWhiteArea;
        this.dataBorderThickness = _chart.dataBorderThickness;
        this.dataBorderColor = _chart.dataBorderColor;
        this.uniqueColorForCol = _chart.uniqueColorForCol;
        this.xAxisAtTop = _chart.xAxisAtTop;
        this.connectLineOrder = _chart.connectLineOrder;
        this.drawConnectLineArrows = _chart.drawConnectLineArrows;
        this.candleStick = _chart.candleStick;
        this.candleWidth = _chart.candleWidth;
        this.candleUpColor = _chart.candleUpColor;
        this.candleDownColor = _chart.candleDownColor;
        this.displayByWeek = _chart.displayByWeek;
        this.showNulldataLine = _chart.showNulldataLine;
        this.applyLineStyleToNullData = _chart.applyLineStyleToNullData;
        this.zeroAsNullData = _chart.zeroAsNullData;
        this.nullDataAsZero = _chart.nullDataAsZero;
        this.drawNullColumn = _chart.drawNullColumn;
        this.nullColumnName = _chart.nullColumnName;
        this.showNullInScatter = _chart.showNullInScatter;
        this.scatterCubeWidth = _chart.scatterCubeWidth;
        this.formatHint = _chart.formatHint;
        if (this.chartType == _chart.chartType) {
            if (_chart.comboType != 3) {
                this.comboType = _chart.comboType;
            } else if (this.is2DimChart() == _chart.is2DimChart()) {
                this.setComboType(_chart.getComboType());
            }
        }
        this.setComboSeries(_chart.getComboSeries());
        this.winWidth = _chart.winWidth;
        this.winHeight = _chart.winHeight;
        this.scrollBarOption = _chart.scrollBarOption;
        this.isAdjustFont = _chart.isAdjustFont;
        this.enablePopupMenu = _chart.enablePopupMenu;
        this.enableTypeMenu = _chart.enableTypeMenu;
        this.enableDimMenu = _chart.enableDimMenu;
        this.autoRotate = _chart.autoRotate;
        this.isReferenceAtTop = _chart.isReferenceAtTop;
        this.isTSChart = _chart.isTSChart;
        this.tsInfo = new PreprocInfo(_chart.tsInfo);
        this.queryFilename = _chart.queryFilename;
        this.queryFileInfo = _chart.queryFileInfo;
        this.vAxisScale = _chart.vAxisScale;
        this.zoomOption = _chart.zoomOption;
        this.xmin = _chart.xmin;
        this.ymin = _chart.ymin;
        this.xratio = _chart.xratio;
        this.yratio = _chart.yratio;
        this.isXZoomed = _chart.isXZoomed;
        this.isYZoomed = _chart.isYZoomed;
        this.firstvminFlt = _chart.firstvminFlt;
        this.firstvstepFlt = _chart.firstvstepFlt;
        this.firstvmaxFlt = _chart.firstvmaxFlt;
        this.lastvminFlt = _chart.lastvminFlt;
        this.lastvstepFlt = _chart.lastvstepFlt;
        this.lastvmaxFlt = _chart.lastvmaxFlt;
        this.isVerticalChart = _chart.isVerticalChart;
        this.valueTable = new ValueTable(this, _chart.valueTable);
        this.setSwapAxis(_chart.isSwapAxis());
        this.isJoinAxis = _chart.isJoinAxis;
        this.synchronizeRadarAxis = _chart.synchronizeRadarAxis;
        this.drawCircularGrid = _chart.drawCircularGrid;
        this.areaCutOffPoint = _chart.areaCutOffPoint;
        this.isGridAlignedWithTicker = _chart.isGridAlignedWithTicker;
        this.isGridInFront = _chart.isGridInFront;
        this.tableInPanel = _chart.tableInPanel;
        this.showSecDataInPrimaryTab = _chart.showSecDataInPrimaryTab;
        if (_chart.gt != null) {
            this.gt = new GraphicsTable();
            this.gt.copy(_chart.gt, this);
        }
        this.aTCX = _chart.aTCX;
        this.aTCY = _chart.aTCY;
        this.farea = _chart.farea;
        this.showShadowOnLine = _chart.showShadowOnLine;
        this.showShadowOnPoint = _chart.showShadowOnPoint;
        this.showDoubleValueForLine = _chart.showDoubleValueForLine;
        this.syncPointColor = _chart.syncPointColor;
        this.showDropBarForLine = _chart.showDropBarForLine;
        this.dropBarSeries1 = _chart.dropBarSeries1;
        this.dropBarSeries2 = _chart.dropBarSeries2;
        this.dropBarColor = _chart.dropBarColor;
        this.dropBarColor2 = _chart.dropBarColor2;
        this.dropBarBorder = _chart.dropBarBorder;
        this.showSeriesInTopLabel = _chart.showSeriesInTopLabel;
        this.doTranslucent = _chart.doTranslucent;
        this.translucentValue = _chart.translucentValue;
        this.setStartAngleForDial(_chart.getStartAngleForDial());
        this.setEndAngleForDial(_chart.getEndAngleForDial());
        this.setControlRangeList(ControlRange.copy(_chart.getControlRangeList()));
        this.setRadiusForInternalDial(_chart.getRadiusForInternalDial());
        this.setCenterColorForDial(_chart.getCenterColorForDial());
        this.setDrawFullCircleForDial(_chart.isDrawFullCircleForDial());
        this.setSubTickerLength(_chart.subTickerLength);
        this.setTickerLength(_chart.tickerLength);
        this.set3DShadowForTickerOn(_chart.turnOn3DShadowForTicker);
        this.setSubTickerCount(_chart.subTickerCount);
        this.setSubTickerThickness(_chart.subTickerThickness);
        this.setPointerUsed(_chart.isPointerUsed());
        this.needleOption = _chart.needleOption;
        this.setLayout(_chart.getLayout());
        this.setPieGroupOthersLimit(_chart.getPieGroupOthersLimit());
        this.setPieGroupOthersName(_chart.getPieGroupOthersName());
        this.colorThresholdForPie = _chart.colorThresholdForPie;
        this.colorArrayForPieThreshold = _chart.colorArrayForPieThreshold;
        this.set3DSurfaceColor(_chart.get3DSurfaceColor());
        this.surfaceHyperLinkList = _chart.surfaceHyperLinkList;
        this.bubbleDrawMode = _chart.bubbleDrawMode;
        this.axisUnitToRadiusRatio = _chart.axisUnitToRadiusRatio;
        this.bubbleAreaRelativeToValue = _chart.bubbleAreaRelativeToValue;
        this.bubble3D = _chart.bubble3D;
        this.bubble3DLight = _chart.bubble3DLight;
        this.setPieGroupOthersName(_chart.getPieGroupOthersName());
        this.setPieGroupOthersLimit(_chart.getPieGroupOthersLimit());
        this.noSectionForPolar = _chart.noSectionForPolar;
        this.startAngleForPolar = _chart.startAngleForPolar;
        this.isRadianForPolar = _chart.isRadianForPolar;
        this.clockWiseForPolar = _chart.clockWiseForPolar;
        this.labelDateTime = _chart.labelDateTime;
        this.ganttOrigLabelsLength = _chart.ganttOrigLabelsLength;
        this.ganttEndPoint = _chart.ganttEndPoint;
        this.isGanttArrows = _chart.isGanttArrows;
        this.is3DApproximationUsed = _chart.is3DApproximationUsed;
        this.approximationThreshold = _chart.approximationThreshold;
        this.drawSeriesOnCategoryAxis = _chart.drawSeriesOnCategoryAxis;
        this.setLocale(_chart.getLocale());
        this.setTimeZone(_chart.getTimeZone());
        this.setPrimaryDataLabelInfo(_chart.getPrimaryDataLabelInfo());
        this.setSecondaryDataLabelInfo(_chart.getSecondaryDataLabelInfo());
        this.stringCustomizer = _chart.getStringCustomizer();
        this.dataColors = _chart.dataColors;
        this.sortValue = _chart.sortValue;
        this.maxDataLen = _chart.maxDataLen;
        this.currentNode = _chart.currentNode;
        this.isSubFieldDrillDownChart = _chart.isSubFieldDrillDownChart;
        this.saveColorsForCategories = _chart.isSaveColorsForCategories();
        this.customDataOrdering = _chart.customDataOrdering;
        this.chartColorSet = _chart.chartColorSet.cloneAndResetColorIndex();
        if (_chart.mData2 != null && _chart.chartColorSet2 != null) {
            this.chartColorSet2 = _chart.chartColorSet2.cloneAndResetColorIndex();
        }
        this.singleColorForCategories = _chart.singleColorForCategories;
        this.autoAxisPosition = _chart.autoAxisPosition;
        this.axisGapOffset = _chart.axisGapOffset;
        this.fontMapping = _chart.fontMapping;
        this.isPrevParamPrompt = _chart.isPrevParamPrompt;
        this.dataPtShapes = _chart.getDataPtShapes();
        this.dataPtSizes = _chart.getDataPtSizes();
        this.subFilesTable = _chart.subFilesTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chart loadTemplate(String templatename) throws Exception {
        Chart newchart = null;
        ReadDataFile readfile = new ReadDataFile();
        try {
            if (IOUtil.isXMLFormat(templatename)) {
                newchart = readfile.applyXMLTemplate(templatename, this.component, this);
            } else {
                LoadChart loadChart = new LoadChart();
                loadChart.subFilesTable = this.subFilesTable;
                newchart = loadChart.loadTemplate(this, readfile.getInputStream(this, templatename));
            }
        }
        finally {
            try {
                readfile.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, "Failed to close ReadDataFile", e);
            }
        }
        return newchart;
    }

    public abstract MultiDimData setMultiDimData(int var1, Chart var2, MultiDimData var3);

    private void setMultiDimData2() {
        try {
            if (this.isSecOverlayAvailable() && this.isOverlayCombo()) {
                this.colData[this.getComboSeries()].retrieveField();
                this.colData[this.getComboSeries()].creatHashTable();
                Chart newChart = Chart.createChart(this.component, 14, true, this, null);
                newChart.setDataColumn(this.getComboSeries(), this.getCategoryIndex(), -1, this.getSecondaryIndex(), -1, -1, -1, -1, -1);
                this.mData2 = newChart.mData;
                this.colData[this.getComboSeries()] = newChart.colData[this.getComboSeries()];
                newChart.a_x = newChart.axis[0] = this.a_x;
                this.topLabels2 = newChart.topLabels2;
                int[] axisPosition = new int[this.colData[this.getComboSeries()].getNumField()];
                for (int i = 0; i < axisPosition.length; ++i) {
                    axisPosition[i] = -2;
                }
                this.setAxisPosition(axisPosition);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to set MultiDimData2", ex);
        }
    }

    private void mapMultiDimData() {
        int[] location = new int[this.dataDim];
        for (int recNo = 0; recNo < this.nRow; ++recNo) {
            boolean notnull = true;
            for (int i = 0; i < this.dataDim; ++i) {
                location[i] = this.colData[this.mDataMap[i]].mapHashTable(recNo);
                if (location[i] != -999) continue;
                notnull = false;
                break;
            }
            if (!notnull) continue;
            this.mData.add(location, recNo, true);
            if (!this.showLegend2()) continue;
            this.mData2.add(location, recNo, false);
        }
    }

    public void makeTable() {
        this.makeTable(true, true);
    }

    private void makeTable(boolean reCalculate3DViewAndScale, boolean doNotClearDataPointsColorsMapped) {
        boolean secMdata;
        int i;
        if (reCalculate3DViewAndScale) {
            this.adjust3DView = true;
            this.adjustScaleOnly = true;
        } else {
            this.adjust3DView = false;
        }
        this.setDrawNullColumn(this.isDrawNullColumn());
        this.setNullColumnName(this.getNullColumnName());
        for (i = 0; i < this.dataDim; ++i) {
            this.bmDataMap[i] = true;
            int colno = this.mDataMap[i];
            this.colData[colno].bGenUniqueName = false;
            this.colData[colno].clearHashTable();
            this.colData[colno].retrieveField();
            this.colData[colno].creatHashTable();
            this.mDataLen[i] = this.colData[colno].getNumField();
        }
        for (i = this.dataDim; i < this.bmDataMap.length; ++i) {
            this.bmDataMap[i] = false;
        }
        this.mData = this.setMultiDimData(0, this, null);
        if (this.subvalueCol >= 0 && !Chart.isCircularChart(this.chartType) && this.chartType != 16 && this.chartType != 17 && !Chart.isCoordinateType(this.chartType)) {
            this.mData2 = this.setMultiDimData(0, this, null);
            secMdata = true;
        } else {
            this.mData2 = null;
            secMdata = false;
        }
        this.mapMultiDimData();
        this.setMultiDimData2();
        this.setMultiDimDataShape(this.mData);
        if (this.isStackType()) {
            this.syncColor();
        } else {
            this.setAutomatic(secMdata);
        }
        if (!doNotClearDataPointsColorsMapped) {
            this.chartColorSet.setDataPointsColorsMapped(false);
            if (this.chartColorSet2 != null) {
                this.chartColorSet2.setDataPointsColorsMapped(false);
            }
        }
        this.reassignDataColors();
        for (int j = 0; j < this.dataDim; ++j) {
            if (this.colData[this.mDataMap[j]].getDataOrder() == 0) continue;
            this.performColDataSort();
            break;
        }
        if (this.getSortValue() != 0) {
            this.performValueSort();
        }
        Legend oldlegend = this.legend;
        this.legend = new Legend(this.mData, this);
        this.legend.copyAttrib(oldlegend);
        if (oldlegend == null && this.isStackType()) {
            this.legend.reverse = true;
        }
        oldlegend = this.legend2;
        this.legend2 = new Legend(this.mData2, this);
        this.legend2.copyAttrib(oldlegend);
        this.setMaxNumberOfCategories(this.maxDataLen);
    }

    public void setMaxNumberOfCategories(int maxDataLen) {
        if (this.dataDim != 1) {
            return;
        }
        this.mData = this.mData.resortOriginalMultiDimData();
        if (this.mData2 != null) {
            this.mData2 = this.mData2.resortOriginalMultiDimData();
        }
        this.maxDataLen = maxDataLen;
        if (this.dataDim == 1 && maxDataLen > 0 && this.mDataLen[0] > maxDataLen) {
            MultiDimData newMData2;
            this.maxDataLen = maxDataLen;
            MultiDimData newMData = (MultiDimData)this.mData.topNMultiDimData(maxDataLen);
            if (newMData != null) {
                this.mData = newMData;
                this.mDataLen[0] = maxDataLen;
            }
            if (this.mData2 != null && (newMData2 = (MultiDimData)this.mData2.topNMultiDimData(maxDataLen)) != null) {
                this.mData2 = newMData2;
            }
        } else if (this.dataDim != 2 || maxDataLen <= 0 || this.mDataLen[1] > maxDataLen) {
            // empty if block
        }
        this.remakeTable = true;
    }

    public void makeTable(MultiDimData data, MultiDimData data2) {
        this.makeTable(data, data2, true);
    }

    public void makeTable(MultiDimData data, MultiDimData data2, boolean reCalculate3DViewAndScale) {
        this.makeTable(reCalculate3DViewAndScale, true);
        new DataAttribute(data, false, this.is2DChart, this.chartType, false, data.chart.isUniqueColorForCol()).loadAttribute(this.mData, this.is2DChart, this.chartType, this.mData.chart.isUniqueColorForCol());
        if (this.showLegend2() && data2 != null) {
            new DataAttribute(data2, true, data2.chart.is2DChart, data2.chart.chartType).loadAttribute(this.mData2, this.mData2.chart.is2DChart, this.mData2.chart.chartType);
        }
    }

    public abstract void reCreateTable();

    private void reCreateMultiDimData2() {
        if (!this.is2DimChart() || this.mData2 == null) {
            return;
        }
        if (this.isOverlayCombo()) {
            if (this.mData2.chart.getChartType() != 14) {
                this.reCreateTable();
            } else if (this.mData2.chart.getSeriesIndex() != this.getComboSeries()) {
                this.reCreateTable();
            }
        } else if (this.subvalueCol >= 0 && this.getComboType() != 3 && this.getChartType() != 14 && this.mData2.chart.getChartType() == 14) {
            this.reCreateTable();
        }
    }

    public void copyTable(Chart _chart) {
        for (int i = 0; i < this.dataDim; ++i) {
            int colno = this.mDataMap[i];
            this.colData[colno].clearHashTable();
            this.colData[colno].retrieveField();
            this.colData[colno].creatHashTable();
            this.mDataLen[i] = this.colData[colno].getNumField();
        }
        this.mData = this.setMultiDimData(0, this, null);
        this.mData2 = this.subvalueCol >= 0 && !Chart.isCircularChart(this.chartType) && this.chartType != 16 && this.chartType != 17 && !Chart.isCoordinateType(this.chartType) ? this.setMultiDimData(0, this, null) : null;
        this.mapMultiDimData();
        this.setMultiDimData2();
        new DataAttribute(_chart.mData, false, _chart.is2DChart, _chart.chartType, false, _chart.isUniqueColorForCol()).loadAttribute(this.mData, this.is2DChart, this.chartType, this.isUniqueColorForCol());
        if (_chart.mData2 != null && this.mData2 != null) {
            new DataAttribute(_chart.mData2, true, _chart.mData2.chart.is2DChart, _chart.mData2.chart.chartType).loadAttribute(this.mData2, this.mData2.chart.is2DChart, this.mData2.chart.chartType);
        }
        this.legend = new Legend(this.mData, this);
        this.legend.copyAttrib(_chart.legend);
        this.legend2 = new Legend(this.mData2, _chart);
        this.legend2.copyAttrib(_chart.legend2);
        this.setMaxNumberOfCategories(_chart.maxDataLen);
    }

    public void setChartType(int[] map, int dim, HiLowMap data, int subvalue) {
        this.checkMapRange(map, true);
        this.checkMapRange(data.hi, true);
        this.checkMapRange(data.low, true);
        if (data.close >= 0) {
            this.checkMapRange(data.close, true);
        }
        if (data.open >= 0) {
            this.checkMapRange(data.open, true);
        }
        this.hilowCol = data;
        this.valueCol = data.hi;
        this.coordCol[0] = data.hi;
        this.coordCol[1] = data.low;
        this.bcoordCol[1] = true;
        this.bcoordCol[0] = true;
        this.subvalueCol = subvalue;
        this.setChartType(map, dim);
    }

    public void setChartType(int[] map, int dim, int[] val) {
        this.checkMapRange(map, false);
        this.checkMapRange(val[0], true);
        this.checkMapRange(val[1], true);
        this.coordCol[0] = val[0];
        this.coordCol[1] = val[1];
        this.bcoordCol[1] = true;
        this.bcoordCol[0] = true;
        if (!this.is2DChart || this.chartType == 13 || this.chartType == 19) {
            if (val[2] < 0) {
                this.bcoordCol[2] = false;
            } else {
                this.checkMapRange(val[2], true);
                this.coordCol[2] = val[2];
                this.bcoordCol[2] = true;
            }
        }
        this.setChartType(map, dim);
    }

    public void setChartType(int[] map, int dim, int val, int subval) {
        if (this.colData.length > val) {
            if (this.nRow > 0) {
                this.checkMapRange(map, true);
                this.checkMapRange(val, true);
            }
            int n = this.subvalueCol = subval >= this.nCol || subval >= 0 && !this.colData[subval].isNumeric() ? -1 : subval;
            if (!this.colData[val].isNumeric() && !this.colData[val].isDateTime()) {
                throw new IllegalArgumentException("Column " + val + " does not contain numeric values.");
            }
            this.valueCol = val;
            this.bvalueCol = true;
            this.setChartType(map, dim);
        }
    }

    public int[] createOriginalMap() {
        int dim = 1;
        int[] map = null;
        int i = 0;
        if (this.seriesExists()) {
            ++dim;
        }
        if (this.sumByExists()) {
            ++dim;
        }
        map = new int[dim];
        if (this.seriesExists()) {
            map[i] = this.originalMap[this.getSeriesIndex()];
            ++i;
        }
        map[i] = this.originalMap[this.getCategoryIndex()];
        ++i;
        if (this.sumByExists()) {
            map[i] = this.originalMap[this.getSumByIndex()];
        }
        this.valueCol = this.originalMap[this.getPrimaryIndex()];
        if (this.getSecondaryIndex() >= 0) {
            this.subvalueCol = this.originalMap[this.getSecondaryIndex()];
        }
        return map;
    }

    public boolean seriesExists() {
        boolean exists = false;
        exists = this.isStackType() ? this.dataDim != 2 : this.dataDim != 1;
        return exists;
    }

    public boolean sumByExists() {
        return this.isStackType();
    }

    private void setChartType(int[] map, int dim) {
        int i;
        if (this.dataDim == 2 && dim == 1) {
            this.uniqueColorForCol = false;
        }
        this.dataDim = dim;
        for (i = 0; i < this.dataDim; ++i) {
            this.mDataMap[i] = map[i];
            this.bmDataMap[i] = true;
        }
        for (i = this.dataDim; i < this.bmDataMap.length; ++i) {
            this.bmDataMap[i] = false;
        }
        this.reCreateTable();
        this.doTypeMapping();
    }

    private void checkValidRange(int c, String s, boolean numeric, int min, int max) throws IllegalArgumentException {
        if (c >= max || c < min) {
            throw new IllegalArgumentException(s + " column must be >= 0 and < " + max);
        }
        if (numeric) {
            if (!this.isValueCol(c)) {
                throw new IllegalArgumentException(s + " column type must be of numeric value");
            }
        } else if (!this.isStringCol(c)) {
            throw new IllegalArgumentException(s + " column type must be of discrete value");
        }
    }

    private void checkValidRange2(int c, String s, boolean numeric, int min, int max) throws IllegalArgumentException {
        if (c >= max) {
            throw new IllegalArgumentException(s + " column must be <= " + max);
        }
        if (numeric) {
            if (c >= min && !this.isValueCol(c)) {
                throw new IllegalArgumentException(s + " column type must be of numeric value");
            }
        } else if (c >= min && !this.isStringCol(c)) {
            throw new IllegalArgumentException(s + " column type must be of discrete value");
        }
    }

    private void checkMapRange(int[] v, boolean isval) {
        for (int element : v) {
            this.checkMapRange(element, isval);
        }
    }

    private void checkMapRange(int v, boolean isval) {
        if (v < this.nCol) {
            return;
        }
        if (!isval && v == this.nCol && Chart.isCoordinateType(this.chartType)) {
            return;
        }
    }

    public void setDataColumn(int series, int category, int sumBy, int value, int xvalue, int yvalue, int zvalue, int subvalue, int subseries) throws IllegalArgumentException {
        int ncol = this.getDataColumnNo();
        this.checkValidRange2(series, "Series", false, 0, ncol);
        if (this.isSecOverlayAvailable()) {
            this.checkValidRange2(subseries, "Sub series", false, 0, ncol);
            this.setComboSeries(subseries);
        }
        this.checkValidRange2(sumBy, "SumBy", false, 0, ncol);
        if (Chart.isCoordinateType(this.chartType)) {
            this.checkValidRange(xvalue, "X axis", true, 0, ncol);
            this.checkValidRange(yvalue, "Y axis", true, 0, ncol);
            this.checkValidRange2(zvalue, "Z axis", true, 0, ncol);
            int[] vals = new int[]{xvalue, yvalue, zvalue};
            if (series < 0) {
                int[] map = new int[]{ncol};
                this.setChartType(map, 1, vals);
            } else {
                int[] map = new int[]{series, ncol};
                this.setChartType(map, 2, vals);
            }
        } else {
            if (subvalue >= 0) {
                this.checkValidRange(subvalue, "Sub value", true, 0, ncol);
            }
            if (this.isHiLow()) {
                this.checkValidRange(value, "High", true, 0, ncol);
                this.checkValidRange(xvalue, "Low", true, 0, ncol);
                this.checkValidRange2(yvalue, "Close", true, 0, ncol);
                this.checkValidRange2(zvalue, "Open", true, 0, ncol);
                int[] map = series < 0 ? new int[]{category} : new int[]{series, category};
                this.setChartType(map, series < 0 ? 1 : 2, new HiLowMap(value, xvalue, zvalue, yvalue), subvalue);
            } else {
                this.checkValidRange(value, "Value", true, 0, ncol);
                if (this.isStackType()) {
                    if (sumBy < 0) {
                        throw new IllegalArgumentException("SumBy column must be >= 0");
                    }
                    if (series < 0 || this.chartType == 8 && this.is2DChart) {
                        int[] map = new int[]{category, sumBy};
                        this.setChartType(map, 2, value, subvalue);
                    } else {
                        int[] map = new int[]{series, category, sumBy};
                        this.setChartType(map, 3, value, subvalue);
                    }
                } else if (series < 0) {
                    int[] map = new int[]{category};
                    this.setChartType(map, 1, value, subvalue);
                } else if (this.chartType == 17) {
                    int[] map = new int[]{category};
                    this.setChartType(map, 1, value, subvalue);
                } else {
                    int[] map = new int[]{series, category};
                    this.setChartType(map, 2, value, subvalue);
                }
            }
        }
    }

    public boolean isDataSourceAvail() {
        if (this.colData != null) {
            return true;
        }
        try {
            ColData[] _colData = ReloadChart.getOriginalColData(this, true);
            return _colData != null;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "isDataSourceAvail test failed", ex);
            return false;
        }
    }

    public int getOriginalSourceData() {
        return this.originalSourceData;
    }

    public void setOriginalSourceData(int i) {
        this.originalSourceData = i;
    }

    public Chart setNewData(ColData[] newdata, int[] map, int dim) {
        int i;
        this.dataDim = dim;
        this.mDataMap = new int[this.dataDim];
        for (i = 0; i < this.dataDim; ++i) {
            this.mDataMap[i] = map[i];
            this.bmDataMap[i] = true;
        }
        for (i = this.dataDim; i < this.bmDataMap.length; ++i) {
            this.bmDataMap[i] = false;
        }
        return this.setNewData(newdata);
    }

    public Chart setNewData(ColData[] newdata) {
        return this.setNewData(newdata, false);
    }

    public Chart setNewData(ColData[] newdata, boolean forceSetColData) {
        int i;
        Chart.setDrawNullColumn(this.isDrawNullColumn(), newdata);
        Chart.setNullColumnName(this.getNullColumnName(), newdata);
        Chart newchart = Chart.createChart(this.component, this.chartType, this.is2DChart, null, newdata, this.usedColumns);
        newchart.subFilesTable = this.subFilesTable;
        newchart.setChanging3DChartType(this.isChanging3DChartType());
        newchart.copyChartAttributes(this);
        GraphicsTable.recoverTableSize(newchart);
        if (Chart.isCircularChart(this.chartType)) {
            ((IPieChart)((Object)newchart)).copyAttributes((IPieChart)((Object)this));
        }
        int[][] order = new int[newdata.length][];
        try {
            if (Chart.isCoordinateType(this.chartType)) {
                if (!this.bcoordCol[2] && this.chartType != 19 && this.chartType != 13) {
                    this.coordCol[2] = -1;
                }
                newchart.setChartType(this.mDataMap, this.dataDim, this.coordCol);
            } else if (this.isHiLow()) {
                newchart.setChartType(this.mDataMap, this.dataDim, this.hilowCol, this.subvalueCol);
            } else {
                newchart.setChartType(this.mDataMap, this.dataDim, this.valueCol, this.subvalueCol);
            }
            block4: for (i = 0; i < newdata.length; ++i) {
                for (ColData element : this.colData) {
                    if ((!DataType.isCompatibleSQLTypes(newdata[i].originalType, element.originalType) || !newdata[i].getName().equals(element.getName())) && !Chart.equalsIgnoreAggr(newdata[i].getName(), element.getName())) continue;
                    newdata[i].copyDataFormat(element);
                    if (element.fieldName != null && newdata[i].fieldName != null) {
                        order[i] = newdata[i].getNewOrder(element.fieldName);
                    }
                    if (order[i] == null) continue block4;
                    newdata[i].copyAttributes(element);
                    continue block4;
                }
            }
            if (this.colDataHasChangedBecauseOfAggrHistZoom || this.isDrillDownDefined() || newchart.isDrillDownDefined() || forceSetColData) {
                this.colData = newdata;
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.SEVERE, "Failed to set new data", ex);
        }
        for (i = 0; i < this.dataDim; ++i) {
            int dataOrder;
            if (i >= this.mDataMap.length || this.mDataMap[i] >= order.length || order[this.mDataMap[i]] == null || (dataOrder = newchart.colData[newchart.mDataMap[i]].dataOrder) != 3) continue;
            newchart.setFieldOrder(i, order[this.mDataMap[i]]);
        }
        newchart.performColDataSort();
        newchart.performValueSort();
        if (this.dataColors != null) {
            this.setDataColor(this.getDataColor());
        }
        try {
            new DataAttribute(this.mData, false, this.is2DChart, this.chartType, false, this.isUniqueColorForCol(), newchart.mData, this.unusedDataAttribute, this.chartColorSet).loadAttribute(newchart.mData, newchart.is2DChart, newchart.chartType, newchart.isUniqueColorForCol());
        }
        catch (Exception ex) {
            this.colData = newdata;
            new DataAttribute(this.mData, false, this.is2DChart, this.chartType, false, this.isUniqueColorForCol()).loadAttribute(newchart.mData, newchart.is2DChart, newchart.chartType, newchart.isUniqueColorForCol());
            LOGGER.log(Level.FINE, "Failed to create DataAttribute", ex);
        }
        if (this.getDataPtShapes() != null) {
            int newLen = newchart.getDataShape().length;
            int[] dataPtShapes = new int[newLen];
            for (int i2 = 0; i2 < newLen; ++i2) {
                dataPtShapes[i2] = i2 >= this.getDataPtShapes().length ? newchart.getDataShape()[i2] : this.getDataPtShapes()[i2];
            }
            newchart.setDataShape(dataPtShapes);
        }
        if (this.getDataPtSizes() != null) {
            int newLen2;
            int newLen = newchart.getDataPtSizes().length;
            int[] dataPtSizes = newLen < (newLen2 = newchart.getDataShape().length) ? new int[newLen2] : new int[newLen];
            for (int i3 = 0; i3 < newLen; ++i3) {
                dataPtSizes[i3] = i3 >= this.getDataPtSizes().length ? newchart.getDataPtSizes()[i3] : this.getDataPtSizes()[i3];
            }
            newchart.setDataSize(dataPtSizes);
        }
        if (this.mData2 != null && newchart.mData2 != null) {
            new DataAttribute(this.mData2, true, this.mData2.chart.is2DChart, this.mData2.chart.chartType, false, false, newchart.mData2, this.unusedDataAttribute2, this.chartColorSet2).loadAttribute(newchart.mData2, newchart.mData2.chart.is2DChart, newchart.mData2.chart.chartType);
        }
        newchart.setTickerOrder();
        return newchart;
    }

    void performColDataSort() {
        block6: for (int i = 0; i < this.dataDim; ++i) {
            switch (this.colData[this.mDataMap[i]].getDataOrder()) {
                case 0: {
                    this.setFieldOrder(i, this.colData[this.mDataMap[i]].fieldName);
                    continue block6;
                }
                case 1: {
                    this.setFieldOrder(i, true);
                    continue block6;
                }
                case 2: {
                    this.setFieldOrder(i, false);
                    continue block6;
                }
                case 3: {
                    this.setFieldOrder(i, this.getFieldOrder(i));
                }
            }
        }
    }

    void performValueSort() {
        if (this.sortValue != 0) {
            if (this.sortValue == 1) {
                this.setValueOrder(true, true);
            } else if (this.sortValue == 2) {
                this.setValueOrder(true, false);
            } else if (this.sortValue == 3) {
                this.setValueOrder(false, true);
            } else {
                this.setValueOrder(false, false);
            }
        }
    }

    public int getSortValue() {
        return this.sortValue;
    }

    public void setSortValue(int b) {
        this.sortValue = b;
    }

    public int getDBSourceType() {
        return this.dbSourceType;
    }

    public void setDBSourceType(int i) {
        this.dbSourceType = i;
    }

    public byte[][] getQueryFileBytes() {
        return this.queryFileBytes;
    }

    public void setQueryFileBytes(byte[][] bytes) {
        this.queryFileBytes = bytes;
    }

    public void setTickerOrder() {
        for (int k = 0; k < this.dataDim; ++k) {
            ColData cd = this.colData[this.mDataMap[k]];
            if (cd.sepUnit == -1) continue;
            Object[] name = cd.getSortOrder(cd.isAscending);
            this.setFieldOrder(k, name);
        }
    }

    public String[] getFieldOrder(int dimension) {
        if (dimension < 0) {
            return null;
        }
        if (this.customDataOrdering == null || this.dataDim != this.customDataOrdering.length || dimension >= this.customDataOrdering.length || this.customDataOrdering[dimension] == null) {
            if (this.mDataMap.length > dimension && this.colData[this.mDataMap[dimension]] != null) {
                Object[] fieldNames = this.colData[this.mDataMap[dimension]].getFieldName();
                String[] order = new String[fieldNames.length];
                for (int i = 0; i < fieldNames.length; ++i) {
                    order[i] = fieldNames[i].toString();
                }
                return order;
            }
            return null;
        }
        return this.customDataOrdering[dimension];
    }

    public void setFieldOrder(int dimension, boolean ascending) {
        if (dimension >= this.dataDim || dimension < 0) {
            return;
        }
        int[] order = this.colData[this.mDataMap[dimension]].setSortOrder(ascending);
        if (order == null) {
            return;
        }
        this.setFieldOrder(dimension, order, false);
    }

    public void setDataOrdering(int dimension, int order) {
        if (dimension >= this.dataDim || dimension < 0) {
            return;
        }
        this.colData[this.mDataMap[dimension]].setDataOrder(order);
    }

    public int getDataOrdering(int dimension) {
        if (dimension >= this.dataDim || dimension < 0) {
            return 0;
        }
        return this.colData[this.mDataMap[dimension]].getDataOrder();
    }

    public void setFieldOrder(int dimension, Object[] fname) {
        if (dimension >= this.dataDim || dimension < 0) {
            return;
        }
        if (this.customDataOrdering == null || this.dataDim > this.customDataOrdering.length) {
            this.customDataOrdering = new String[this.dataDim][];
        }
        this.customDataOrdering[dimension] = new String[fname.length];
        for (int i = 0; i < fname.length; ++i) {
            if (fname[i] == null) continue;
            this.customDataOrdering[dimension][i] = fname[i].toString();
        }
        int[] order = this.colData[this.mDataMap[dimension]].getNewOrder(fname);
        if (order == null) {
            return;
        }
        this.setFieldOrder(dimension, order);
    }

    public void setFieldOrder(int dimension, int[] order) {
        this.setFieldOrder(dimension, order, true);
    }

    public abstract void setFieldOrder(int var1, int[] var2, boolean var3);

    public void setValueOrder(boolean isPrimary, boolean asc) {
        if (!isPrimary && this.subvalueCol < 0) {
            return;
        }
        MultiDimData md = isPrimary ? this.mData : this.mData2;
        int colIndex = this.mDataMap[this.dataDim - 1];
        Number[] vals = new Number[this.colData[colIndex].getNumField()];
        int[] loc = new int[this.dataDim];
        Arrays.fill(loc, 0);
        for (int i = 0; i < vals.length; ++i) {
            loc[this.dataDim - 1] = i;
            Object element = md.getElement(loc);
            if (element instanceof Time) {
                vals[i] = ((Time)element).getTime();
                continue;
            }
            if (!(element instanceof Number)) continue;
            vals[i] = (Number)element;
        }
        int[] order = this.sortIndex(vals, asc);
        this.setFieldOrder(this.dataDim - 1, order);
    }

    public void sortSeriesByValue() {
        if (this.chartType != 7 && this.chartType != 0 || this.dataDim < 2) {
            return;
        }
        int[] seriesSum = new int[this.mDataLen[0]];
        for (int s = 0; s < this.mDataLen[0]; ++s) {
            for (int c = 0; c < this.mDataLen[1]; ++c) {
                int n = s;
                seriesSum[n] = seriesSum[n] + (int)this.mData.multiData[s].multiData[c].plotData.getValue();
            }
        }
        int[] sortedSum = new int[seriesSum.length];
        for (int i = 0; i < sortedSum.length; ++i) {
            sortedSum[i] = seriesSum[i];
        }
        boolean[] seriesUsed = new boolean[seriesSum.length];
        int seriesDim = 0;
        String[] origOrder = this.getFieldOrder(seriesDim);
        Object[] newOrder = new String[seriesSum.length];
        Arrays.sort(sortedSum);
        for (int j = seriesSum.length - 1; j >= 0; --j) {
            for (int k = 0; k < seriesSum.length; ++k) {
                if (sortedSum[j] != seriesSum[k] || seriesUsed[k]) continue;
                seriesUsed[k] = true;
                newOrder[seriesSum.length - 1 - j] = origOrder[k].toString();
                k += seriesSum.length;
            }
        }
        this.setFieldOrder(seriesDim, newOrder);
    }

    private int[] sortIndex(Number[] array, boolean isAsc) {
        int i;
        int n = array.length;
        double[] keys = new double[n];
        int[] index = new int[n];
        for (i = 0; i < n; ++i) {
            keys[i] = array[i] != null ? array[i].doubleValue() : 0.0;
            index[i] = i;
        }
        for (i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!(isAsc && keys[i] > keys[j]) && (isAsc || !(keys[i] < keys[j]))) continue;
                double tmp = keys[i];
                keys[i] = keys[j];
                keys[j] = tmp;
                int tmpIndex = index[i];
                index[i] = index[j];
                index[j] = tmpIndex;
            }
        }
        return index;
    }

    public void setAutomatic(boolean secondary) {
        if (secondary && this.isOverlayCombo()) {
            secondary = false;
        }
        if (this.dataDim == 1) {
            for (int i = 0; i < this.mDataLen[0]; ++i) {
                MultiDimData md = this.mData.multiData[i];
                md.area.automatic = this.chartType == 15 || this.chartType == 17 || this.chartType == 6 || this.chartType == 20 ? false : (this.chartType == 0 || this.chartType == 1 ? this.isSingleColorForCategories() : true);
                md.point.automatic = this.chartType != 17;
                if (!secondary) continue;
                md = this.mData2.multiData[i];
                md.area.automatic = true;
                md.point.automatic = true;
            }
        } else {
            MultiDimData md3 = null;
            for (int i = 0; i < this.mDataLen[0]; ++i) {
                MultiDimData md = this.mData.multiData[i];
                md.area.automatic = false;
                md.point.automatic = false;
                if (secondary) {
                    md3 = this.mData2.multiData[i];
                    md3.area.automatic = false;
                    md3.point.automatic = false;
                }
                for (int j = 0; j < this.mDataLen[1]; ++j) {
                    MultiDimData md2 = md.multiData[j];
                    md2.area.automatic = !this.uniqueColorForCol;
                    md2.point.automatic = md2.area.automatic;
                    if (!secondary || md3 == null) continue;
                    md2 = md3.multiData[j];
                    md2.area.automatic = true;
                    md2.point.automatic = true;
                }
            }
        }
    }

    public abstract void setRandomColor3D(Color var1);

    public void setColorSetForValueAxis(int colorSetIndex, boolean colorSetChange) {
        this.chartColorSet.resetColorIndex();
        this.chartColorSet.setColorSetIndex(colorSetIndex);
        if (colorSetChange) {
            this.chartColorSet.setChartDataPointsColors(new Color[0]);
            this.chartColorSet.setDataPointsColorsMapped(false);
        }
        if (this.mData.multiData.length > 0 && this.mData.multiData[0].area.automatic && this.mData.multiData[0].multiData == null) {
            this.mData.area.areaColor = this.mData.point.color = this.chartColorSet.getNextColor(this.mData.area.areaColor);
        }
        this.mData.assignColors(this.mData.area, false, this.chartColorSet);
        if (Chart.isCircularChart(this.chartType)) {
            this.mData.setFaceColor(this.mData.area);
        }
        this.setRandomColor3D(ChartColorSet.getRandomColor());
    }

    public void setColorSetForSecondValueAxis(int colorSetIndex, boolean colorSetChange) {
        if (this.showLegend2() && this.chartColorSet2 != null) {
            this.chartColorSet2.resetColorIndex();
            this.chartColorSet2.setColorSetIndex(colorSetIndex);
            if (colorSetChange) {
                this.chartColorSet2.setChartDataPointsColors(new Color[0]);
                this.chartColorSet2.setDataPointsColorsMapped(false);
            }
            if (this.mData2.multiData.length > 0 && this.mData2.multiData[0].area.automatic && this.mData2.multiData[0].multiData == null) {
                this.mData2.area.areaColor = this.mData2.point.color = this.chartColorSet2.getNextColor(this.mData2.area.areaColor);
            }
            this.mData2.assignColors(this.mData2.area, false, this.chartColorSet2);
            this.setRandomColor3D(ChartColorSet.getRandomColor());
        }
    }

    public boolean isUniqueColorForCol() {
        return this.uniqueColorForCol && (this.chartType == 0 || this.chartType == 1) && this.dataDim == 2;
    }

    public void setUniqueColorForCol(boolean b) {
        this.uniqueColorForCol = b;
    }

    public boolean isSingleColorForCategories() {
        return this.singleColorForCategories && (this.chartType == 0 || this.chartType == 1) && this.dataDim == 1;
    }

    public void setSingleColorForCategories(boolean b) {
        if (this.singleColorForCategories != b) {
            this.singleColorForCategories = b;
            this.makeTable();
        }
    }

    public boolean isSaveColorsForCategories() {
        return this.saveColorsForCategories && !this.isSingleColorForCategories() || this.chartType == 14;
    }

    public void setSaveColorsForCategories(boolean b) {
        this.saveColorsForCategories = b;
    }

    public void syncColor() {
        this.mData.chart.syncColor(this.mData, this.chartColorSet);
        if (this.showLegend2() && !this.isOverlayCombo()) {
            this.mData2.chart.syncColor(this.mData2, this.chartColorSet2);
        }
    }

    public abstract void mddSetColor(MultiDimData var1, MultiDimData var2);

    private void syncColor(MultiDimData data, ChartColorSet colorSet) {
        block8: {
            block7: {
                if (colorSet != null) {
                    colorSet.resetColorIndex();
                }
                if (data.chart.dataDim != 2) break block7;
                for (int i = 0; i < data.chart.mDataLen[1]; ++i) {
                    MultiDimData b = data.multiData[0].multiData[i];
                    b.area.automatic = false;
                    int shape = b.point.shape;
                    int size = b.point.size;
                    b.point.automatic = false;
                    b.point.color = b.area.areaColor;
                    data.chart.mddSetColor(b, b);
                    b.setFaceColor(b.area.areaColor);
                    for (int j = 1; j < data.chart.mDataLen[0]; ++j) {
                        if (j >= data.multiData.length) {
                            return;
                        }
                        MultiDimData a = data.multiData[j].multiData[i];
                        data.chart.mddSetColor(a, b);
                        a.setFaceColor(b.area.areaColor);
                        a.area.automatic = false;
                        a.point.automatic = false;
                        a.point.setShape(shape);
                        a.point.setSize(size);
                        a.point.setColor(b.point.color);
                    }
                }
                break block8;
            }
            if (data.chart.dataDim != 3) break block8;
            for (int i = 0; i < data.chart.mDataLen[0]; ++i) {
                for (int j = 0; j < data.chart.mDataLen[2]; ++j) {
                    MultiDimData b = data.multiData[i].multiData[0].multiData[j];
                    b.area.automatic = false;
                    int shape = b.point.shape;
                    int size = b.point.size;
                    b.point.automatic = false;
                    b.point.color = b.area.areaColor;
                    data.chart.mddSetColor(b, b);
                    b.setFaceColor(b.area.areaColor);
                    for (int k = 1; k < data.chart.mDataLen[1]; ++k) {
                        MultiDimData a = data.multiData[i].multiData[k].multiData[j];
                        data.chart.mddSetColor(a, b);
                        a.setFaceColor(b.point.color);
                        a.area.automatic = false;
                        a.point.automatic = false;
                        a.point.setShape(shape);
                        a.point.setSize(size);
                        a.point.setColor(b.point.color);
                    }
                }
            }
        }
    }

    private void setMultiDimDataShape(MultiDimData data) {
        if (!data.chart.isStackType()) {
            for (int i = 0; i < data.chart.mDataLen[0]; ++i) {
                data.multiData[i].point.setShape(i % 10);
            }
        } else if (data.chart.dataDim == 2) {
            MultiDimData data2 = data.multiData[0];
            for (int i = 0; i < data.chart.mDataLen[1]; ++i) {
                data2.multiData[i].point.setShape(i % 10);
            }
        } else {
            for (int i = 0; i < data.chart.mDataLen[0]; ++i) {
                MultiDimData data2 = data.multiData[i].multiData[0];
                for (int j = 0; j < data.chart.mDataLen[2]; ++j) {
                    data2.multiData[j].point.setShape((i + j) % 10);
                }
            }
        }
    }

    public final void prepareLabel() {
        this.prepareLabel(true);
    }

    public abstract void prepareLabel(boolean var1);

    public void setDefault() {
        this.axis[0].setShowSubTickers(false);
        this.axis[1].setShowSubTickers(false);
        this.axis[2].setShowSubTickers(false);
        this.axis[2].autoscale = true;
        this.axis[1].autoscale = true;
        this.axis[0].autoscale = true;
        this.axis[2].logScale = false;
        this.axis[1].logScale = false;
        this.axis[0].logScale = false;
        this.axis[2].stepScaleMonth = 0;
        this.axis[1].stepScaleMonth = 0;
        this.axis[0].stepScaleMonth = 0;
        this.axis[2].axisShift = 0.0;
        this.axis[1].axisShift = 0.0;
        this.axis[0].axisShift = 0.0;
        this.axis[0].setShowLogValue(false);
        this.axis[1].setShowLogValue(false);
        this.axis[2].setShowLogValue(false);
    }

    protected void checkSpecialColumn(int min_dim) throws IllegalArgumentException {
        if (this.mDataMap[0] == this.nCol) {
            if (this.dataDim >= 2) {
                this.mDataMap[0] = this.mDataMap[1];
                if (this.dataDim == 3) {
                    this.mDataMap[1] = this.mDataMap[2];
                }
            }
            --this.dataDim;
            this.bmDataMap[this.dataDim] = false;
        } else if (this.dataDim >= 2 && this.mDataMap[1] == this.nCol) {
            if (this.dataDim == 3) {
                this.mDataMap[1] = this.mDataMap[2];
                this.dataDim = 2;
                this.bmDataMap[2] = false;
            } else {
                this.dataDim = 1;
                this.bmDataMap[1] = false;
            }
        }
        if (this.dataDim < min_dim) {
            if (this.nstring == 0) {
                if (this.nint + this.nreal < min_dim) {
                    throw nocategoryError;
                }
                if (min_dim == 1) {
                    this.mDataMap[0] = this.nint > 0 ? this.nintcol[0] : this.nrealcol[0];
                } else {
                    this.mDataMap[1] = this.nint == 0 ? this.nrealcol[0] : (this.nint == 1 && this.nintcol[0] != this.mDataMap[0] ? this.nintcol[0] : (this.nintcol[0] == this.mDataMap[0] ? this.nintcol[1] : this.nintcol[0]));
                }
            } else if (this.nstring == 1) {
                if (min_dim == 1) {
                    this.mDataMap[0] = this.nstringcol[0];
                } else {
                    if (this.nint + this.nreal < 1) {
                        throw nocategoryError;
                    }
                    this.mDataMap[1] = this.nint >= 1 ? (this.nstringcol[0] == this.mDataMap[0] ? this.nintcol[0] : this.nstringcol[0]) : (this.nstringcol[0] == this.mDataMap[0] ? this.nrealcol[0] : this.nstringcol[0]);
                }
            } else if (min_dim == 1) {
                this.mDataMap[0] = this.nstringcol[0];
            } else {
                this.mDataMap[1] = this.mDataMap[0] == this.nstringcol[0] ? this.nstringcol[1] : this.nstringcol[0];
            }
            this.dataDim = min_dim;
            this.bmDataMap[0] = true;
            if (min_dim == 2) {
                this.bmDataMap[1] = true;
            }
            this.addNewColumnFromDataMapping = true;
        }
    }

    public IChartGraphics getChartGraphics() {
        return this.chartGraphics;
    }

    public void setChartGraphics(IChartGraphics cg) {
        this.chartGraphics = cg;
    }

    public AddOnChart getAddOnChart() {
        return this.addOnChart;
    }

    public void setAddOnChart(AddOnChart cg) {
        this.addOnChart = cg;
    }

    public void setRenderingHint(Object key, Object value) {
        if (!IOUtil.isJava2D()) {
            return;
        }
        if (key != RenderingHints.KEY_ANTIALIASING) {
            this.renderingKey.addElement(key);
            this.renderingValue.addElement(value);
        } else {
            this.renderingValue.setElementAt(value, 0);
        }
    }

    public boolean isAntiAliasEnabled() {
        if (!IOUtil.isJava2D()) {
            return false;
        }
        return this.renderingValue.elementAt(0) == RenderingHints.VALUE_ANTIALIAS_ON;
    }

    public void setAntiAliasEnabled(boolean state) {
        if (!IOUtil.isJava2D()) {
            return;
        }
        Object value = RenderingHints.VALUE_ANTIALIAS_ON;
        if (!state) {
            value = RenderingHints.VALUE_ANTIALIAS_OFF;
        }
        if (this.renderingValue.size() == 0) {
            this.renderingValue.addElement(value);
        } else {
            this.renderingValue.setElementAt(value, 0);
        }
    }

    public boolean isAntiAliasForText() {
        return this.setAntiAliasForText;
    }

    public void setAntiAliasForText(boolean b) {
        this.setAntiAliasForText = b;
    }

    public abstract void calcForDraw(int var1);

    public abstract void doNewSurface();

    public abstract void doComputeDataLines();

    protected synchronized void calculatePosition(Graphics g, Component _component, int width, int height) {
        if (this.remakeTable) {
            this.reCreateTable();
        }
        this.reCreateMultiDimData2();
        this.winWidth = width;
        this.winHeight = height;
        this.component = _component;
        this.chartxorigin = (int)((float)width * this.chart_XProp);
        this.chartyorigin = (int)((float)height * this.chart_YProp);
        this.chartwidth = (int)((float)width * this.chart_widthProp);
        this.chartheight = (int)((float)height * this.chart_heightProp);
        if (this.notEnoughData()) {
            return;
        }
        this.calcForDraw(height);
        if (this.mData2 != null && this != this.mData2.chart) {
            this.mData2.chart.winWidth = this.winWidth;
            this.mData2.chart.winHeight = this.winHeight;
            this.mData2.chart.component = this.component;
            this.mData2.chart.chartxorigin = this.chartxorigin;
            this.mData2.chart.chartyorigin = this.chartyorigin;
            this.mData2.chart.chartwidth = this.chartwidth;
            this.mData2.chart.chartheight = this.chartheight;
        }
        this.mainTitle.setpos(new Point3D((int)((float)width * this.title_XProp), (int)((float)height * this.title_YProp)));
        this.mainTitle.setPlacement(1);
        this.a_x.title.setpos(new Point3D(width / 2, this.chartheight - 10));
        this.a_x.title.setPlacement(3);
        this.a_y.title.setpos(new Point3D(this.chartxorigin - 10, height / 2));
        for (int i = 0; i < 4; ++i) {
            this.axis[i].setorigin(this.chartxorigin, this.chartyorigin);
        }
        this.border.setpos(this.chartxorigin, this.chartyorigin, this.chartxorigin + this.chartwidth, this.chartyorigin + this.chartheight);
        this.doNewSurface();
        CGraphics cg = new CGraphics(g, this.component, height, width, this);
        if (this.cgraphics == null) {
            this.cgraphics = cg;
        }
        if (this.isDataValid()) {
            this.computeCoord(cg, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
            if (this.fm != null) {
                LOGGER.finest("fontmetrix: " + this.fm.toString());
            }
            this.updateBackground();
            this.doComputeDataLines();
            this.legend.setpos((int)((float)width * this.legend_XProp), (int)((float)height * this.legend_YProp));
            this.legend2.setpos((int)((float)width * this.legend2_XProp), (int)((float)height * this.legend2_YProp));
            this.annotationSet.invalidate();
        }
        this.isComputed = true;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component _component) {
        this.component = _component;
    }

    public final synchronized void draw(Graphics g, Component _component, int width, int height) {
        this.calculatePosition(g, _component, width, height);
        this.draw(g);
    }

    public void resetXY() {
        this.maxY = 0;
        this.minY = 0;
        this.maxX = 0;
        this.minX = 0;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void doChartRendering(Graphics g) {
        if (IOUtil.isJava2D()) {
            RenderingChart.setRenderingHint(g, this.renderingKey, this.renderingValue);
        }
    }

    public void draw(Graphics g) {
        boolean isOutsidePlotAreaText = CString.isOutsidePlotAreaText();
        Shape clip = g.getClip();
        g.setClip(0, 0, this.winWidth, this.winHeight);
        this.resetXY();
        this.cgraphics = new CGraphics(g, this.component, this.winHeight, this.winWidth, this);
        if (g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g)).resetBuffer();
        }
        if (this.showTable() && !this.gt.shift) {
            this.gt.calculatePosition(this, this.cgraphics);
        }
        this.g = g;
        if (this.component == null) {
            return;
        }
        if (this.imagemap) {
            this.cgraphics.enableImageMap();
        }
        if (IOUtil.isJava2D()) {
            RenderingChart.setRenderingHint(g, this.renderingKey, this.renderingValue);
        }
        if (this.desktopArea.drawArea) {
            g.setColor(this.desktopArea.areaColor);
            if (this.desktopArea.isGradientEnabled()) {
                Graphics2DTool.fillGradientRect(g, this, this.desktopArea, this.desktopArea.areaColor, 0, 0, this.winWidth, this.winHeight);
            } else {
                g.fillRect(0, 0, this.winWidth, this.winHeight);
            }
        }
        if (!this.notEnoughData()) {
            this.drawBackgroundImage(g, this.component);
            this.drawDialPlotBGImage(g, this.component);
            if (this.chartGraphics != null) {
                this.chartGraphics.initializeGraphics(g, this.winWidth, this.winHeight);
            }
            if (!this.isComputed) {
                this.calculatePosition(g, this.component, this.winWidth, this.winHeight);
            }
            if (this.isChartVisible()) {
                if (g instanceof IQbGraphics) {
                    ((IQbGraphics)((Object)g)).setChartTab();
                }
                this.draw(this.cgraphics);
                if (g instanceof IQbGraphics) {
                    ((IQbGraphics)((Object)g)).setEndTab();
                }
            }
            if (this.showTable()) {
                CString.setOutsidePlotAreaText(true);
                this.gt.draw(this, this.cgraphics);
                CString.setOutsidePlotAreaText(isOutsidePlotAreaText);
            }
        } else if (this.showNoDataToPlotMsg && this.noDataToPlotMsg != null && !this.noDataToPlotMsg.trim().equals("")) {
            CString str = new CString(this.noDataToPlotMsg, this.noDataToPlotMsgFont, new Point3D(this.winWidth / 2, this.winHeight / 2), this.noDataToPlotMsgColor, 0, this.noDataToPlotMsgAngle);
            str.draw(this.cgraphics);
            return;
        }
        CString.setOutsidePlotAreaText(true);
        this.drawLineList(this.cgraphics);
        this.drawStringList(this.cgraphics);
        this.annotationSet.draw(this.cgraphics);
        CString.setOutsidePlotAreaText(isOutsidePlotAreaText);
        this.legend.draw(this.cgraphics);
        if (this.legend2 != null && this.legend2.showLegend) {
            if (this instanceof LineChart2D) {
                if (!this.isShowDoubleValueForLine()) {
                    this.legend2.draw(this.cgraphics);
                }
            } else {
                this.legend2.draw(this.cgraphics);
            }
        }
        if (this.redrawChartToFitCanvas(this.cgraphics, g)) {
            return;
        }
        if (!(this.showTable() || this.chartType == 13 || Chart.isCircularChart(this.chartType) && this.is2DimChart() || this.backgroundImage != null && this.showbackgroundImage || !this.isDataValid())) {
            this.computeBoundingBox();
            this.cgraphics.setX(this.xboundmin);
            this.cgraphics.setX(this.xboundmax);
            this.cgraphics.setY(this.yboundmin);
            this.cgraphics.setY(this.yboundmax);
            int offset = this.winHeight / 100 + 2;
            this.minX = Math.max(this.cgraphics.minX - offset, 0);
            this.maxX = Math.min(this.cgraphics.maxX + offset, this.winWidth);
            if (this.is2DimChart()) {
                this.maxY = this.winHeight - this.cgraphics.minY;
                this.minY = this.winHeight - this.cgraphics.maxY;
            } else {
                this.minY = this.cgraphics.minY;
                this.maxY = this.cgraphics.maxY;
            }
            this.minY = Math.max(this.minY - offset, 0);
            this.maxY = Math.min(this.maxY + offset, this.winHeight);
        } else if (!this.is2DimChart() && ServerMessage.isEvalVersion()) {
            this.computeBoundingBox();
        }
        if (this.addOnChart != null) {
            this.addOnChart.addChart(this.cgraphics);
        }
        if (this.chartGraphics != null) {
            this.chartGraphics.finalizeGraphics(g, this.winWidth, this.winHeight);
        }
        this.drawDialPlotFGImage(g, this.component);
        if (ServerMessage.isEvalVersion()) {
            int xpos = 5;
            int ypos = 0;
            ypos = this.is2DimChart() || Chart.isCircularChart(this.chartType) ? (int)((1.0f - this.chart_YProp - this.chart_heightProp) * (float)this.winHeight) : this.winHeight - this.yboundmax;
            double delta = this.is2DChart ? 0.18 : 0.0;
            CString.setOutsidePlotAreaText(true);
            new CString("Evaluation copy,\nplease contact sales@quadbase.com \nfor purchasing information.", new Font("Dialog", 0, 8), new Point3D(xpos, ypos), this.desktopArea.areaColor.getRed() < 120 && this.desktopArea.areaColor.getGreen() < 120 && this.desktopArea.areaColor.getBlue() < 120 ? Color.white : Color.gray, 5).draw(this.cgraphics);
            if (this.chartGraphics != null) {
                new CString("Evaluation copy,\n please contact sales@quadbase.com \n for purchasing information.", new Font("Dialog", 0, 8), new Point3D(xpos, ypos -= (int)((double)this.winHeight - delta + 0.03)), this.desktopArea.areaColor.getRed() < 120 && this.desktopArea.areaColor.getGreen() < 120 && this.desktopArea.areaColor.getBlue() < 120 ? Color.gray : Color.white, 5).draw(this.cgraphics);
            }
            CString.setOutsidePlotAreaText(isOutsidePlotAreaText);
        }
        g.setClip(clip);
    }

    private boolean redrawChartToFitCanvas(CGraphics cgraphics, Graphics g) {
        if (!this.isFitOnCanvas()) {
            return false;
        }
        String mTitle = this.getTitle();
        this.setTitle("");
        if (mTitle != null && !mTitle.equals("")) {
            this.draw(g);
            this.setTitle(mTitle);
            if (!this.isFitOnCanvas()) {
                this.draw(g);
            }
            return false;
        }
        LOGGER.finest("Canvas = (" + this.winWidth + ", " + this.winHeight + ")");
        LOGGER.finest("BOUND MIN = (" + this.xboundmin + ", " + this.yboundmin + ")");
        LOGGER.finest("BOUND MAX = (" + this.xboundmax + ", " + this.yboundmax + ")");
        this.computeBoundingBox();
        cgraphics.setX(this.xboundmin);
        cgraphics.setX(this.xboundmax);
        cgraphics.setY(this.yboundmin);
        cgraphics.setY(this.yboundmax);
        LOGGER.finest("min = (" + cgraphics.minX + ", " + cgraphics.minY + ")");
        LOGGER.finest("max = (" + cgraphics.maxX + ", " + cgraphics.maxY + ")");
        int ySign = 1;
        int xSign = -1;
        if (this.xGap == -1.0f) {
            this.xGap = this.legend_XProp - this.chart_widthProp - this.chart_XProp;
        }
        if (this.winWidth > 0 && this.winHeight > 0) {
            int difY = 0;
            if (cgraphics.minY < 0) {
                difY -= cgraphics.minY;
                ySign = -1;
            }
            if (cgraphics.maxY > this.winHeight) {
                difY += cgraphics.maxY - this.winHeight;
            }
            int difX = 0;
            if (cgraphics.minX < 0) {
                if (this.chartType == 18) {
                    cgraphics.minX = 0;
                }
                difX -= cgraphics.minX;
                xSign = 1;
            }
            if (cgraphics.maxX > this.winWidth) {
                difX += cgraphics.maxX - this.winWidth;
            }
            if (difY <= 0 && difX <= 0) {
                this.chart_widthProp = this.legend_XProp - this.xGap - this.chart_XProp;
                this.setFitOnCanvas(false);
                return false;
            }
            if (difY > 0) {
                if (this.winHeight > cgraphics.maxY - cgraphics.minY) {
                    this.chart_YProp = (this.chart_YProp * (float)this.winHeight + (float)(ySign * difY)) / (float)this.winHeight;
                } else {
                    this.chart_heightProp = (this.chart_heightProp * (float)this.winHeight - (float)difY) / (float)this.winHeight;
                }
            }
            if (difX > 0) {
                this.chart_XProp = (this.chart_XProp * (float)this.winWidth + (float)(xSign * difX)) / (float)this.winWidth;
                this.chart_widthProp = (this.chart_widthProp * (float)this.winWidth - (float)difX) / (float)this.winWidth;
            }
            if (this.chart_heightProp < 0.3f || this.chart_heightProp > 1.0f) {
                this.chart_heightProp = 0.3f;
                this.setFitOnCanvas(false);
            }
            if (this.chart_widthProp < 0.3f || this.chart_widthProp > 1.0f) {
                this.chart_widthProp = this.legend_XProp - this.xGap - this.chart_XProp;
                this.setFitOnCanvas(false);
            }
            if (this.chart_YProp < 0.0f || this.chart_YProp > 1.0f) {
                this.chart_YProp = 0.2f;
            }
            if (this.chart_XProp < 0.0f || this.chart_XProp > 1.0f) {
                this.chart_XProp = 0.2f;
            }
            this.isComputed = false;
            LOGGER.finest("NEW XY = (" + this.chart_XProp + ", " + this.chart_YProp + ")");
            LOGGER.finest("NEW WH = (" + this.chart_widthProp + ", " + this.chart_heightProp + ")");
            this.draw(g);
            return true;
        }
        return false;
    }

    public boolean isFitOnCanvas() {
        return this.redrawToFitCanvas;
    }

    public void setFitOnCanvas(boolean b) {
        this.redrawToFitCanvas = b;
    }

    public boolean isNoDataToPlotMessageVisible() {
        return this.showNoDataToPlotMsg;
    }

    public void setNoDataToPlotMessageVisible(boolean b) {
        this.showNoDataToPlotMsg = b;
    }

    public String getNoDataToPlotMessage() {
        return this.noDataToPlotMsg;
    }

    public void setNoDataToPlotMessage(String msg) {
        this.noDataToPlotMsg = msg;
    }

    public Font getNoDataToPlotMessageFont() {
        return this.noDataToPlotMsgFont;
    }

    public void setNoDataToPlotMessageFont(Font font) {
        if (font != null) {
            this.noDataToPlotMsgFont = font;
        }
    }

    public Color getNoDataToPlotMessageColor() {
        return this.noDataToPlotMsgColor;
    }

    public void setNoDataToPlotMessageColor(Color color) {
        if (color != null) {
            this.noDataToPlotMsgColor = color;
        }
    }

    public int getNoDataToPlotMessageAngle() {
        return this.noDataToPlotMsgAngle;
    }

    public void setNoDataToPlotMessageAngle(int angle) {
        this.noDataToPlotMsgAngle = angle;
    }

    private void drawBackgroundImage(Graphics g, Component component) {
        if (this.backgroundImage != null && this.showbackgroundImage) {
            try {
                this.backgroundImage.draw(this, g, 0, 0, this.winWidth, this.winHeight, component);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to draw background image", ex);
            }
        }
    }

    public void drawDialPlotFGImage(Graphics g, Component component) {
    }

    public void drawDialPlotBGImage(Graphics g, Component component) {
    }

    public final void drawStringList(CGraphics g) {
        if (this.showStringList) {
            CString.drawCStrings(g, this.stringList);
        }
    }

    public void drawLabel(CGraphics g) {
        if (!this.is2DChart) {
            this.drawLabel3D(g);
            return;
        }
        if (g.g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g.g)).setTopLabels();
        }
        if (this.showTopValue) {
            CString.drawCStrings(g, this.topLabels);
        }
        if (this.getTopValueState2()) {
            CString.drawCStrings(g, this.topLabels2);
        }
        if (g.g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g.g)).resetTopLabels();
        }
    }

    public abstract void drawLabel3D(CGraphics var1);

    protected abstract void drawLineList(CGraphics var1);

    public abstract void draw3D(CGraphics var1, int var2);

    public abstract void drawAllAxis(CGraphics var1);

    public abstract void draw2D(CGraphics var1, int var2);

    public abstract void draw(CGraphics var1);

    public void drawChart(CGraphics g) {
    }

    public abstract void computeCoord(CGraphics var1, int var2, int var3, int var4, int var5);

    public void findMinMaxVal() {
        this.setDefaultMinMaxValue(true);
        this.mData.findMinMaxVal(this, true);
        this.checkMinMaxValue(true);
    }

    public void findMinMaxVal2() {
        this.setDefaultMinMaxValue(false);
        if (this.mData2 != null) {
            this.mData2.findMinMaxVal(this, false);
        }
        this.checkMinMaxValue(false);
    }

    public final void findMinMaxRadial() {
        this.maxCoord.z = -1.7976931348623157E308;
        this.maxCoord.y = -1.7976931348623157E308;
        this.maxCoord.x = -1.7976931348623157E308;
        this.minCoord.z = Double.MAX_VALUE;
        this.minCoord.y = Double.MAX_VALUE;
        this.minCoord.x = Double.MAX_VALUE;
        this.maxCoord.x = Math.PI * 2;
        this.minCoord.x = 0.0;
        this.mData.findMinMaxRadial();
        if (this.maxCoord.y == -1.7976931348623157E308) {
            this.minCoord.z = 0.0;
            this.minCoord.y = 0.0;
            this.minCoord.x = 0.0;
            this.maxCoord.z = 0.0;
            this.maxCoord.y = 0.0;
            this.maxCoord.x = 0.0;
        }
    }

    public final void findMinMaxCoord() {
        this.setDefaultMinMaxCoord();
        this.mData.findMinMaxCoord();
        if (this.maxCoord.x == -1.7976931348623157E308) {
            this.minCoord.z = 0.0;
            this.minCoord.y = 0.0;
            this.minCoord.x = 0.0;
            this.maxCoord.z = 0.0;
            this.maxCoord.y = 0.0;
            this.maxCoord.x = 0.0;
        }
    }

    public final void checkMinMaxValue(boolean first) {
        if (first) {
            if (this.maxvalue == -1.7976931348623157E308) {
                this.minvalue = 0.0;
                this.maxvalue = 0.0;
            }
        } else if (this.maxvalue2 == -1.7976931348623157E308) {
            this.minvalue2 = 0.0;
            this.maxvalue2 = 0.0;
        }
    }

    public final void findMinMaxSum() {
        this.setDefaultMinMaxValue(true);
        this.mData.findMinMaxSum();
        this.checkMinMaxValue(true);
    }

    public final void findMinMaxCumSum() {
        this.setDefaultMinMaxValue(true);
        this.mData.findMinMaxCumSum(true);
        this.checkMinMaxValue(true);
    }

    public final void findMinMaxCumSum2() {
        this.setDefaultMinMaxValue(false);
        this.mData2.findMinMaxCumSum(false);
        this.checkMinMaxValue(false);
    }

    public void setSize(int w, int h) {
        this.calculatePosition(null, this.component, w, h);
    }

    public Dimension getSize() {
        return new Dimension(this.winWidth, this.winHeight);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public int getScrollBarOption() {
        return this.scrollBarOption;
    }

    public void setScrollBarOption(int option) {
        if (option == 0 || option == 2 || option == 1) {
            this.scrollBarOption = option;
        } else {
            LOGGER.warning("Not a valid scroll bar option");
        }
    }

    public XMLFileQueryInfo getXMLFileQueryInfo() {
        return this.xmlFileQueryInfo;
    }

    public void setXMLFileQueryInfo(XMLFileQueryInfo info) {
        this.xmlFileQueryInfo = info;
    }

    public boolean isAutoRotate() {
        return this.autoRotate;
    }

    public void setAutoRotate(boolean b) {
        this.autoRotate = b;
    }

    public boolean isReferenceAtTop() {
        return this.isReferenceAtTop;
    }

    public void setReferenceAtTop(boolean b) {
        this.isReferenceAtTop = b;
    }

    public boolean isAdjustFont() {
        return this.isAdjustFont;
    }

    public void setAdjustFont(boolean state) {
        this.isAdjustFont = state;
    }

    public boolean isPopupMenuEnabled() {
        return this.enablePopupMenu;
    }

    public void setPopupMenuEnabled(boolean option) {
        this.enablePopupMenu = option;
    }

    public boolean isTypeMenuEnabled() {
        return this.enableTypeMenu;
    }

    public void setTypeMenuEnabled(boolean option) {
        this.enableTypeMenu = option;
    }

    public boolean isDimMenuEnabled() {
        return this.enableDimMenu;
    }

    public void setDimMenuEnabled(boolean option) {
        this.enableDimMenu = option;
    }

    public final String getTitle() {
        return this.mainTitle.getString();
    }

    public final void setTitle(String title) {
        this.mainTitle.setString(title);
    }

    public final boolean getNullDataLine() {
        return this.showNulldataLine;
    }

    public final void setNullDataLine(boolean b) {
        this.showNulldataLine = b;
    }

    public final boolean isApplyLineStyleToNullData() {
        return this.applyLineStyleToNullData;
    }

    public final void applyLineStyleToNullData(boolean b) {
        this.applyLineStyleToNullData = b;
    }

    public final boolean isZeroAsNullData() {
        return this.zeroAsNullData;
    }

    public final void setZeroAsNullData(boolean b) {
        this.zeroAsNullData = b;
    }

    public final boolean isNullDataAsZero() {
        return this.nullDataAsZero;
    }

    public final void setNullDataAsZero(boolean b) {
        this.nullDataAsZero = b;
    }

    public final boolean isDrawNullColumn() {
        return this.drawNullColumn;
    }

    public final void setDrawNullColumn(boolean b) {
        this.drawNullColumn = b;
        Chart.setDrawNullColumn(b, this.colData);
    }

    public final String getNullColumnName() {
        return this.nullColumnName;
    }

    public final void setNullColumnName(String str) {
        this.nullColumnName = str;
        Chart.setNullColumnName(str, this.colData);
    }

    public final boolean isShowNullInScatter() {
        return this.showNullInScatter;
    }

    public final void setShowNullInScatter(boolean b) {
        this.showNullInScatter = b;
    }

    public final int getScatterCubeWidth() {
        return this.scatterCubeWidth;
    }

    public final void setScatterCubeWidth(int b) {
        this.scatterCubeWidth = b;
    }

    public final boolean getFormatHint() {
        return this.formatHint;
    }

    public final void setFormatHint(boolean b) {
        this.formatHint = b;
    }

    public int getComboType() {
        return this.comboType;
    }

    public void setComboType(int comboType) {
        this.comboType = comboType;
        this.reCreateMultiDimData2();
    }

    public int getComboSeries() {
        return this.comboSeries;
    }

    public void setComboSeries(int comboSeries) {
        this.comboSeries = comboSeries;
        this.reCreateMultiDimData2();
    }

    public final int get_xshift() {
        return this.x_shift;
    }

    public final void set_xshift(int x_shift) {
        this.x_shift = x_shift;
    }

    public final int get_xlabelrow() {
        return this.xlabelrow;
    }

    public final void set_xlabelrow(int row) {
        this.xlabelrow = row;
    }

    public final boolean isLabelOutsidePlotArea(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].isLabelOutsidePlotArea();
        }
        return this.axis[_axis].isLabelOutsidePlotArea();
    }

    public final void setLabelOutsidePlotArea(int _axis, boolean b) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].setLabelOutsidePlotArea(b);
        } else {
            this.axis[_axis].setLabelOutsidePlotArea(b);
        }
    }

    public final void setAxisScale(int _axis, double min, double max, double step) {
        Axis ax = null;
        ax = _axis > 3 && this.colDataAxis != null ? this.colDataAxis[_axis - 4] : this.axis[_axis];
        ax.setMinScale(min);
        ax.setMaxScale(max);
        ax.setScaleStep(step);
        ax.autoscale = false;
    }

    public final Color getAxisTitleColor(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].title.getColor();
        }
        return this.axis[_axis].title.getColor();
    }

    public final void setAxisTitleColor(Color color, int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].title.setColor(color);
        } else {
            this.axis[_axis].title.setColor(color);
        }
    }

    public final String getAxisTitle(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].getTitle();
        }
        return this.axis[_axis].getTitle();
    }

    public final void setAxisTitle(String title, int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].setTitle(title);
        } else {
            this.axis[_axis].setTitle(title);
        }
    }

    public final ColData[] getColData() {
        return this.colData;
    }

    public final Font getMainTitleFont() {
        return this.mainTitle.getFont();
    }

    public final void setMainTitleFont(Font font) {
        this.mainTitle.setFont(font);
    }

    public final int getMainTitleAngle() {
        return this.mainTitle.getAngle();
    }

    public final void setMainTitleAngle(int angle) {
        this.mainTitle.setAngle(angle);
    }

    public final Color getMainTitleColor() {
        return this.mainTitle.getColor();
    }

    public final void setMainTitleColor(Color color) {
        this.mainTitle.setColor(color);
    }

    public Axis getAxis(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4];
        }
        return this.axis[_axis];
    }

    public final Font getAxisTitleFont(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].title.getFont();
        }
        return this.axis[_axis].title.getFont();
    }

    public final void setAxisTitleFont(int _axis, Font font, double angle) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].title.setFont(font, angle);
        } else {
            this.axis[_axis].title.setFont(font, angle);
        }
    }

    public final int getAxisTitleAngle(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].title.getAngle();
        }
        return this.axis[_axis].title.getAngle();
    }

    public float getFontResizeRatio() {
        return this.fontResizeRatio;
    }

    public void setFontResizeRatio(float ratio) {
        if (ratio >= 0.0f && ratio <= 3.0f) {
            this.fontResizeRatio = ratio;
        }
    }

    public void resizeFont(float ratio) {
        int m;
        Vector<IAnnotation> annoList;
        if (this.fontResizeRatio == 0.0f) {
            return;
        }
        ratio = 1.0f + ratio * this.fontResizeRatio;
        this.setMainTitleFont(this.adjustFontSize(this.getMainTitleFont(), ratio));
        this.setAxisTitleFont(0, this.adjustFontSize(this.getAxisTitleFont(0), ratio), this.getAxisTitleAngle(0));
        this.setAxisTitleFont(1, this.adjustFontSize(this.getAxisTitleFont(1), ratio), this.getAxisTitleAngle(1));
        this.setAxisTitleFont(2, this.adjustFontSize(this.getAxisTitleFont(2), ratio), this.getAxisTitleAngle(2));
        this.setAxisTitleFont(3, this.adjustFontSize(this.getAxisTitleFont(3), ratio), this.getAxisTitleAngle(3));
        this.setTickerFont(0, this.adjustFontSize(this.getTickerFont(0), ratio), this.getTickerAngle(0));
        this.setTickerFont(1, this.adjustFontSize(this.getTickerFont(1), ratio), this.getTickerAngle(1));
        this.setTickerFont(2, this.adjustFontSize(this.getTickerFont(2), ratio), this.getTickerAngle(2));
        this.setTickerFont(3, this.adjustFontSize(this.getTickerFont(3), ratio), this.getTickerAngle(3));
        if (this.colDataAxis != null) {
            for (int i = 0; i < this.colDataAxis.length; ++i) {
                if (this.colDataAxis[i] == null) continue;
                this.setAxisTitleFont(i + 4, this.adjustFontSize(this.getAxisTitleFont(i + 4), ratio), this.getAxisTitleAngle(i + 4));
                this.setTickerFont(i + 4, this.adjustFontSize(this.getTickerFont(i + 4), ratio), this.getTickerAngle(i + 4));
            }
        }
        if (this.legend != null) {
            this.legend.setFont(this.adjustFontSize(this.legend.getFont(), ratio), this.legend.getAngle());
        }
        if (this.legend2 != null) {
            this.legend2.setFont(this.adjustFontSize(this.legend2.getFont(), ratio), this.legend2.getAngle());
        }
        this.setTopValueFont(this.adjustFontSize(this.getTopValueFont(), ratio), this.getTopValueAngle());
        this.setTopValueFont2(this.adjustFontSize(this.getTopValueFont2(), ratio), this.getTopValueAngle2());
        if (Chart.isCircularChart(this.chartType)) {
            ((IPieChart)((Object)this)).getPieChart().setLabelFont(this.adjustFontSize(((IPieChart)((Object)this)).getPieChart().getLabelFont(), ratio));
            ((IPieChart)((Object)this)).getPieChart().setValueFont(this.adjustFontSize(((IPieChart)((Object)this)).getPieChart().getValueFont(), ratio));
            ((IPieChart)((Object)this)).getPieChart().setPercentFont(this.adjustFontSize(((IPieChart)((Object)this)).getPieChart().getPercentFont(), ratio));
        }
        if (this.annotationSet != null && (annoList = this.annotationSet.getAnnotationList()) != null) {
            annoList.trimToSize();
            for (m = 0; m < annoList.size(); ++m) {
                int angle = annoList.elementAt(m).getAngle();
                ((CAnnotation)annoList.elementAt(m)).setFont(this.adjustFontSize(((CAnnotation)annoList.elementAt(m)).getFont(), ratio), angle);
            }
        }
        if (this.gt != null) {
            this.gt.headFont = this.adjustFontSize(this.gt.headFont, ratio);
            this.gt.cellFont = this.adjustFontSize(this.gt.cellFont, ratio);
            this.gt.resizeTableByFontSize();
        }
        if (this.dataLineSet != null) {
            Vector<DataLine> lineList = this.dataLineSet.getDataLineList();
            if (lineList == null) {
                return;
            }
            lineList.trimToSize();
            for (m = 0; m < lineList.size(); ++m) {
                Vector<IAnnotation> lineAnnoList = lineList.elementAt(m).getAnnotations();
                if (lineAnnoList == null) continue;
                lineAnnoList.trimToSize();
                for (int n = 0; n < lineAnnoList.size(); ++n) {
                    int angle = lineAnnoList.elementAt(n).getAngle();
                    ((CAnnotation)lineAnnoList.elementAt(n)).setFont(this.adjustFontSize(((CAnnotation)lineAnnoList.elementAt(n)).getFont(), ratio), angle);
                }
            }
        }
    }

    private Font adjustFontSize(Font font, float ratio) {
        if (font == null) {
            return null;
        }
        int newFontSize = (int)((float)font.getSize() * ratio);
        if (newFontSize < 3) {
            newFontSize = 3;
        }
        return new Font(font.getFontName(), font.getStyle(), newFontSize);
    }

    public final boolean getLegendState() {
        return this.legend.showLegend;
    }

    public final void setLegendState(boolean state) {
        this.legend.showLegend = state;
    }

    public final boolean getLegendState2() {
        return this.legend2.showLegend;
    }

    public final void setLegendState2(boolean state) {
        this.legend2.showLegend = state;
    }

    public final float getLegendXOffset() {
        return this.legend_XProp;
    }

    public final void setLegendXOffset(float w) {
        this.legend_XProp = w;
        this.legend.setpos((int)((float)this.winWidth * this.legend_XProp), (int)((float)this.winHeight * this.legend_YProp));
    }

    public final float getLegendYOffset() {
        return this.legend_YProp;
    }

    public final void setLegendYOffset(float h) {
        this.legend_YProp = h;
        this.legend.setpos((int)((float)this.winWidth * this.legend_XProp), (int)((float)this.winHeight * this.legend_YProp));
    }

    public final float getLegendXOffset2() {
        return this.legend2_XProp;
    }

    public final void setLegendXOffset2(float w) {
        this.legend2_XProp = w;
        this.legend2.setpos((int)((float)this.winWidth * this.legend2_XProp), (int)((float)this.winHeight * this.legend2_YProp));
    }

    public final float getLegendYOffset2() {
        return this.legend2_YProp;
    }

    public final void setLegendYOffset2(float h) {
        this.legend2_YProp = h;
        this.legend2.setpos((int)((float)this.winWidth * this.legend2_XProp), (int)((float)this.winHeight * this.legend2_YProp));
    }

    public final float getTitleXOffset() {
        return this.title_XProp;
    }

    public final void setTitleXOffset(float w) {
        this.title_XProp = w;
        this.mainTitle.setpos(new Point3D((int)((float)this.winWidth * this.title_XProp), (int)((float)this.winHeight * this.title_YProp)));
    }

    public final float getTitleYOffset() {
        return this.title_YProp;
    }

    public final void setTitleYOffset(float h) {
        this.title_YProp = h;
        this.mainTitle.setpos(new Point3D((int)((float)this.winWidth * this.title_XProp), (int)((float)this.winHeight * this.title_YProp)));
    }

    public final int getTickerWidth(int ax) {
        this.setColDataAxisIfNull(ax);
        if (ax > 3 && this.colDataAxis != null) {
            Ticker tk;
            if (this.colDataAxis[ax - 4] != null && (tk = this.colDataAxis[ax - 4].ticker) != null) {
                if (this.chartType == 16 && !this.isSynchronizeRadarAxis()) {
                    return tk.radarYOffset;
                }
                if (this.chartType == 14) {
                    return tk.twidth;
                }
            }
        } else {
            Ticker tk = this.axis[ax].ticker;
            return tk != null ? tk.displacement : 0;
        }
        return 0;
    }

    public final void setTickerWidth(int ax, int value) {
        this.setColDataAxisIfNull(ax);
        if (ax > 3 && this.colDataAxis != null) {
            Ticker tk;
            if (this.colDataAxis[ax - 4] != null && (tk = this.colDataAxis[ax - 4].ticker) != null) {
                if (this.chartType == 16 && !this.isSynchronizeRadarAxis()) {
                    tk.radarYOffset = value;
                } else if (this.chartType == 14) {
                    tk.twidth = value;
                }
            }
        } else {
            Ticker tk = this.axis[ax].ticker;
            if (tk != null) {
                tk.twidth = value;
            }
        }
    }

    public final int getTickerDisplacement(int ax) {
        this.setColDataAxisIfNull(ax);
        if (ax > 3 && this.colDataAxis != null) {
            Ticker tk;
            if (this.colDataAxis[ax - 4] != null && (tk = this.colDataAxis[ax - 4].ticker) != null) {
                if (this.chartType == 16 && !this.isSynchronizeRadarAxis()) {
                    return tk.radarXOffset;
                }
                if (this.chartType == 14) {
                    return tk.displacement;
                }
            }
        } else {
            Ticker tk = this.axis[ax].ticker;
            return tk != null ? tk.displacement : 0;
        }
        return 0;
    }

    public final void setTickerDisplacement(int ax, int value) {
        this.setColDataAxisIfNull(ax);
        if (ax > 3 && this.colDataAxis != null) {
            Ticker tk;
            if (this.colDataAxis[ax - 4] != null && (tk = this.colDataAxis[ax - 4].ticker) != null) {
                if (this.chartType == 16 && !this.isSynchronizeRadarAxis()) {
                    tk.radarXOffset = value;
                } else if (this.chartType == 14) {
                    tk.displacement = value;
                }
            }
        } else {
            Ticker tk = this.axis[ax].ticker;
            if (tk != null) {
                tk.displacement = value;
            }
        }
    }

    private void setColDataAxisIfNull(int ax) {
        if (ax > 3 && (this.chartType == 14 || this.chartType == 16) && this.colDataAxis == null) {
            this.computeCoord(new CGraphics(null, this.component, 500, 500, null), this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
        }
    }

    public final boolean getBackgroundState() {
        return this.background.drawArea;
    }

    public final void setBackgroundState(boolean state) {
        this.background.drawArea = state;
    }

    public final Area getDesktopArea() {
        return this.desktopArea;
    }

    public final void setDesktopArea(Area area) {
        this.desktopArea = area;
    }

    public boolean getCandleStick() {
        return this.candleStick;
    }

    public void setCandleStick(boolean candle) {
        this.candleStick = candle;
    }

    public float getCandleWidth() {
        return this.candleWidth;
    }

    public void setCandleWidth(float candleW) {
        this.candleWidth = candleW;
    }

    public void setCandleColors(Color colorUp, Color colorDown) {
        this.candleUpColor = colorUp;
        this.candleDownColor = colorDown;
    }

    public Color getCandleUpColor() {
        return this.candleUpColor;
    }

    public Color getCandleDownColor() {
        return this.candleDownColor;
    }

    public boolean isXAxisAtTop() {
        return this.xAxisAtTop;
    }

    public void setXAxisAtTop(boolean bTop) {
        if (!this.is2DimChart() || this.isStackType() || this.chartType == 15 || this.chartType == 3 || this.chartType == 17 || this.chartType == 16 || this.chartType == 14 || this.chartType == 7) {
            bTop = false;
        }
        this.xAxisAtTop = bTop;
        this.a_x.xAtTop = bTop;
        this.a_y.xAtTop = bTop;
        this.a_x.ticker.onTop = bTop;
    }

    public boolean isLineInOriginalOrder() {
        return this.connectLineOrder;
    }

    public void setLineInOriginalOrder(boolean bOrig) {
        this.connectLineOrder = bOrig;
    }

    public final boolean getDataBorder() {
        return this.drawDataBorder;
    }

    public void setDataBorder(boolean needBorder) {
        this.drawDataBorder = needBorder;
    }

    public final boolean isDrawBorderForWhiteArea() {
        return this.drawBorderForWhiteArea;
    }

    public void setDrawBorderForWhiteArea(boolean needBorder) {
        this.drawBorderForWhiteArea = needBorder;
    }

    public final int getDataBorderThickness() {
        return this.dataBorderThickness;
    }

    public final void setDataBorderThickness(int thickness) {
        this.dataBorderThickness = thickness;
    }

    public final Color getDataBorderColor() {
        if (Chart.isCircularChart(this.chartType)) {
            return this.getPieBorderColor();
        }
        return this.dataBorderColor;
    }

    public final void setDataBorderColor(Color color) {
        this.dataBorderColor = color;
    }

    public final boolean getBubbleAreaToValue() {
        return this.bubbleAreaRelativeToValue;
    }

    public final void setBubbleAreaToValue(boolean bubbleArea) {
        this.bubbleAreaRelativeToValue = bubbleArea;
    }

    public final boolean is3DBubblesDrawn() {
        return this.bubble3D;
    }

    public final int get3DBubblesLight() {
        return this.bubble3DLight;
    }

    public final void set3DBubblesDrawn(boolean state, int lightIntensity) {
        this.bubble3D = state;
        this.bubble3DLight = lightIntensity;
        if (this.bubble3D) {
            this.setTranslucent(false);
        }
    }

    public final Point3D getGanttEndPoint() {
        return this.ganttEndPoint;
    }

    public final void setGanttEndPoint(Point3D pt3d) {
        this.ganttEndPoint = pt3d;
    }

    public final boolean isGanttArrowsDrawn() {
        return this.isGanttArrows;
    }

    public final void setGanttArrowsDrawn(boolean b) {
        this.isGanttArrows = b;
    }

    public final boolean isLabelDateTimeDisplay(int axisId) {
        return this.labelDateTime[axisId];
    }

    public final void setLabelDateTimeDisplay(int axisId, boolean b) {
        this.labelDateTime[axisId] = b;
        if (this.getAxis(axisId) != null) {
            this.getAxis((int)axisId).displayLabelAsDate = b;
        }
        this.newSurface();
    }

    public final boolean isDisplayByWeek(int axisId) {
        if (axisId >= this.displayByWeek.length) {
            return false;
        }
        return this.displayByWeek[axisId];
    }

    public final void setDisplayByWeek(int axisId, boolean state) {
        if (axisId >= this.displayByWeek.length) {
            return;
        }
        if (Math.abs(this.axis[axisId].maxScale - this.axis[axisId].minScale) < 8.64E7) {
            return;
        }
        if (this.displayByWeek[axisId] != state) {
            this.displayByWeek[axisId] = state;
            if (this.displayByWeek[axisId]) {
                this.axis[axisId].setDynamicAutoScale(false);
                this.axis[axisId].setScaleStep(0.0);
                this.axis[axisId].setScaleStepMonth(0);
                this.setLabelDateTimeDisplay(axisId, this.displayByWeek[axisId]);
                double minDouble = this.axis[axisId].minScale;
                double maxDouble = this.axis[axisId].maxScale;
                double dayDouble = 8.64E7;
                if (!IOUtil.isJava2D()) {
                    minDouble = Math.floor(minDouble / dayDouble) * dayDouble;
                }
                this.setAxisAutoScale(axisId, false);
                this.setAxisMinScale(axisId, minDouble);
                this.setAxisMaxScale(axisId, maxDouble);
                this.setAxisStepSize(axisId, dayDouble);
                this.setAxisStepMonth(axisId, 0);
                this.setAxisAutoOrigin(axisId, true);
                this.axis[axisId].ticker.centerLabels = false;
                this.setTickerDisplacement(axisId, -3);
                this.newSurface();
                int arrLength = (int)((maxDouble - minDouble) / dayDouble);
                arrLength = (int)(maxDouble - minDouble) % (int)dayDouble != 0 ? (arrLength += 3) : ++arrLength;
                String[] formattedStr = new String[arrLength];
                long[] tmplong = new long[arrLength];
                Date[] tmpDate = new Date[arrLength];
                for (int i = 0; i < arrLength; ++i) {
                    tmplong[i] = (long)(minDouble + dayDouble * (double)i);
                    tmpDate[i] = new Date(tmplong[i]);
                    int d = tmpDate[i].getDay();
                    formattedStr[i] = d == 0 ? "S\n" + this.axis[0].formating(tmplong[i]) : (d == 1 ? "M" : (d == 2 ? "T" : (d == 3 ? "W" : (d == 4 ? "T" : (d == 5 ? "F" : "S")))));
                }
                this.ganttOrigLabelsLength = this.axis[axisId].ticker.getOriginalTickerLabels(true).length;
                this.axis[axisId].ticker.setTickerLabels(formattedStr);
                this.setTickerFont(axisId, this.getTickerFont(axisId), 0);
            } else {
                this.setLabelDateTimeDisplay(axisId, this.labelDateTime[axisId]);
                this.setAxisAutoScale(axisId, true);
                String[] origTickerLabels = new String[this.ganttOrigLabelsLength];
                for (int i = 0; i < this.ganttOrigLabelsLength; ++i) {
                    origTickerLabels[i] = "";
                }
                this.axis[axisId].ticker.centerLabels = true;
                this.setTickerDisplacement(axisId, 3);
                this.axis[axisId].ticker.setTickerLabels(origTickerLabels);
            }
        }
    }

    public final Area getBackground() {
        return this.background;
    }

    public final void setBackground(Area area) {
        this.background = area;
    }

    public final boolean getbackgroundImageState() {
        return this.showbackgroundImage;
    }

    public final void setbackgroundImageState(boolean state) {
        this.showbackgroundImage = state;
    }

    public final ImageData getBackgroundImage() {
        return this.backgroundImage;
    }

    public final void setBackgroundImage(URL url, int option) {
        this.setBackgroundImage(url, null, option);
    }

    public final void setBackgroundImage(URL url, String relativeURL, int option) {
        if (url == null || option == 3) {
            this.showbackgroundImage = false;
            if (this.backgroundImage != null && option == 3) {
                this.backgroundImage.setOption(3);
            }
        } else {
            this.showbackgroundImage = true;
            if (this.backgroundImage != null) {
                this.backgroundImage.setImage(url);
                this.backgroundImage.setRelativeImage(relativeURL);
                if (relativeURL != null) {
                    this.backgroundImage.setImageFromRelativeURL();
                }
                this.backgroundImage.setOption(option);
            } else {
                this.backgroundImage = new ImageData(url, relativeURL, option);
            }
        }
        if (this.backgroundImage != null) {
            this.backgroundImage.setByteArray(null);
        }
    }

    public void setBackgroundImageByteArray(byte[] bytes) {
        if (this.backgroundImage != null) {
            this.backgroundImage.setByteArray(bytes);
        }
    }

    public final boolean getDialPlotFGImageState() {
        return this.showDialPlotFGImage;
    }

    public final void setDialPlotFGImageState(boolean state) {
        this.showDialPlotFGImage = state;
    }

    public final ImageData getDialPlotFGImage() {
        return this.dialPlotFGImage;
    }

    public final void setDialPlotFGImage(URL url, int option) {
        this.setDialPlotFGImage(url, null, option);
    }

    public final void setDialPlotFGImage(URL url, String relativeURL, int option) {
        if (url == null || option == 3) {
            this.showDialPlotFGImage = false;
            if (this.dialPlotFGImage != null && option == 3) {
                this.dialPlotFGImage.setOption(3);
            }
        } else {
            this.showDialPlotFGImage = true;
            if (this.dialPlotFGImage != null) {
                this.dialPlotFGImage.setImage(url);
                this.dialPlotFGImage.setRelativeImage(relativeURL);
                if (relativeURL != null) {
                    this.dialPlotFGImage.setImageFromRelativeURL();
                }
                this.dialPlotFGImage.setOption(option);
            } else {
                this.dialPlotFGImage = new ImageData(url, relativeURL, option);
            }
        }
        if (this.dialPlotFGImage != null) {
            this.dialPlotFGImage.setByteArray(null);
        }
    }

    public final double getDialPlotFGRatio() {
        return this.dialFGPlotSizeRatio;
    }

    public final void setDialPlotFGRatio(double ratio) {
        this.dialFGPlotSizeRatio = ratio;
    }

    public void setDialPlotFGImageByteArray(byte[] bytes) {
        if (this.dialPlotFGImage != null) {
            this.dialPlotFGImage.setByteArray(bytes);
        }
    }

    public final boolean getDialPlotBGImageState() {
        return this.showDialPlotBGImage;
    }

    public final void setDialPlotBGImageState(boolean state) {
        this.showDialPlotBGImage = state;
    }

    public final ImageData getDialPlotBGImage() {
        return this.dialPlotBGImage;
    }

    public final void setDialPlotBGImage(URL url, int option) {
        this.setDialPlotBGImage(url, null, option);
    }

    public final void setDialPlotBGImage(URL url, String relativeURL, int option) {
        if (url == null || option == 3) {
            this.showDialPlotBGImage = false;
            if (this.dialPlotBGImage != null && option == 3) {
                this.dialPlotBGImage.setOption(3);
            }
        } else {
            this.showDialPlotBGImage = true;
            if (this.dialPlotBGImage != null) {
                this.dialPlotBGImage.setImage(url);
                this.dialPlotBGImage.setRelativeImage(relativeURL);
                if (relativeURL != null) {
                    this.dialPlotBGImage.setImageFromRelativeURL();
                }
                this.dialPlotBGImage.setOption(option);
            } else {
                this.dialPlotBGImage = new ImageData(url, relativeURL, option);
            }
        }
        if (this.dialPlotBGImage != null) {
            this.dialPlotBGImage.setByteArray(null);
        }
    }

    public final double getDialPlotBGRatio() {
        return this.dialBGPlotSizeRatio;
    }

    public final void setDialPlotBGRatio(double ratio) {
        this.dialBGPlotSizeRatio = ratio;
    }

    public void setDialPlotBGImageByteArray(byte[] bytes) {
        if (this.dialPlotBGImage != null) {
            this.dialPlotBGImage.setByteArray(bytes);
        }
    }

    public final Area getBorder() {
        return this.border;
    }

    public final void setBorder(Area area) {
        this.border = area;
    }

    public final boolean getBorderState() {
        return this.border.drawBorder;
    }

    public final void setBorderState(boolean state) {
        this.border.drawBorder = state;
    }

    public final boolean getAxisState(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].bshow;
        }
        return this.axis[_axis].bshow;
    }

    public final boolean getGridState(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].grid.bshow;
        }
        return this.axis[_axis].grid.bshow;
    }

    public abstract void setAxisState(int var1, boolean var2);

    public final void setGridState(int _axis, boolean state) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].grid.bshow = state;
        } else {
            this.axis[_axis].grid.bshow = state;
        }
    }

    public final double getGridLine2DRatio(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].grid.getGridLine2DRatio();
        }
        return this.axis[_axis].grid.getGridLine2DRatio();
    }

    public final void setGridLine2DRatio(int _axis, double ratio) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].grid.setGridLine2DRatio(ratio);
        } else {
            this.axis[_axis].grid.setGridLine2DRatio(ratio);
        }
    }

    public final Color getGridColor(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].grid.color;
        }
        return this.axis[_axis].grid.color;
    }

    public final void setGridColor(int _axis, Color color) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].grid.setColor(color);
        } else {
            this.axis[_axis].grid.setColor(color);
        }
    }

    public final boolean getLineState() {
        return this.showLine;
    }

    public final void setLineState(boolean state) {
        this.showLine = state;
    }

    public final boolean getShowDataState() {
        return this.showData;
    }

    public final void setShowDataState(boolean state) {
        this.showData = state;
    }

    public final boolean getAreaState() {
        return this.showArea;
    }

    public final void setAreaState(boolean state) {
        this.showArea = state;
    }

    public final boolean getArrowState() {
        return this.showArrow;
    }

    public final void setArrowState(boolean state) {
        this.showArrow = state;
        this.a_x.thickness = this.a_y.thickness = (this.axisThickness = state ? Math.abs(this.axisThickness) : -Math.abs(this.axisThickness));
    }

    public final int getAxisThickness() {
        return Math.abs(this.axisThickness);
    }

    public final void setAxisThickness(int thick) {
        this.axisThickness = this.showArrow ? thick : -thick;
    }

    public final boolean getLineState2() {
        return this.showLine2;
    }

    public final void setLineState2(boolean state) {
        this.showLine2 = state;
    }

    public final boolean getAxisAutoScale(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].autoscale;
        }
        return this.axis[_axis].autoscale;
    }

    public final void setAxisAutoScale(int _axis, boolean auto) {
        if (this.remakeTable) {
            this.validatePosition();
        }
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].autoscale = auto;
        } else {
            this.axis[_axis].autoscale = auto;
        }
    }

    public final boolean getAxisDisplayLabelAsDate(int _axis) {
        return this.axis[_axis].displayLabelAsDate;
    }

    public final void setAxisDisplayLabelAsDate(int _axis, boolean displayDate) {
        this.axis[_axis].displayLabelAsDate = displayDate;
    }

    public final boolean getAxisAutoOrigin(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].autoOrigin;
        }
        return this.axis[_axis].autoOrigin;
    }

    public final void setAxisAutoOrigin(int _axis, boolean auto) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].autoOrigin = auto;
        } else {
            this.axis[_axis].autoOrigin = auto;
        }
    }

    public final boolean isAxisPaddingAdded(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].addAxisPadding;
        }
        return this.axis[_axis].addAxisPadding;
    }

    public final void setAxisPaddingAdded(int _axis, boolean stat) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].addAxisPadding = stat;
        } else {
            this.axis[_axis].addAxisPadding = stat;
        }
    }

    public final boolean getAxisLogScale(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].logScale;
        }
        return this.axis[_axis].logScale;
    }

    public final void setAxisLogScale(int _axis, boolean auto) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].logScale = auto;
        } else {
            this.axis[_axis].logScale = auto;
        }
    }

    public final boolean isShowLogValue(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].isShowLogValue();
        }
        return this.axis[_axis].isShowLogValue();
    }

    public final void setShowLogValue(int _axis, boolean state) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].setShowLogValue(state);
        } else {
            this.axis[_axis].setShowLogValue(state);
        }
    }

    public final boolean getLogSubTickersState(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].isShowSubTickers();
        }
        return this.axis[_axis].isShowSubTickers();
    }

    public final void setLogSubTickersState(int _axis, boolean state) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].setShowSubTickers(state);
        } else {
            this.axis[_axis].setShowSubTickers(state);
        }
    }

    public final double getBaseForLog(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].getBaseForLog();
        }
        return this.axis[_axis].getBaseForLog();
    }

    public final void setBaseForLog(int _axis, double value) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].setBaseForLog(value);
        } else {
            this.axis[_axis].setBaseForLog(value);
        }
    }

    public final double getAxisMinScale(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].getMinScale();
        }
        return this.axis[_axis].getMinScale();
    }

    public final double getAxisMaxScale(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].getMaxScale();
        }
        return this.axis[_axis].getMaxScale();
    }

    public final double getAxisStepSize(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].getScaleStep();
        }
        return this.axis[_axis].getScaleStep();
    }

    public final void setAxisMinScale(int _axis, double v) {
        this.setAxisMinScale(_axis, v, false);
    }

    public final void setAxisMinScale(int _axis, double v, boolean isDate) {
        if (this.remakeTable) {
            this.validatePosition();
        }
        if (_axis > 3 && this.colDataAxis != null) {
            if (!this.isDataLimitAtAxisScale() && this.colDataAxis[_axis - 4].stepsize != null && v > this.colDataAxis[_axis - 4].stepsize.minlimit) {
                if (isDate) {
                    java.sql.Date d = new java.sql.Date((long)this.colDataAxis[_axis - 4].stepsize.minlimit);
                    throw new IllegalArgumentException("Min must be before " + DateFormat.getDateTimeInstance().format(d));
                }
                throw new IllegalArgumentException("Min must be <= " + this.colDataAxis[_axis - 4].stepsize.minlimit);
            }
            this.colDataAxis[_axis - 4].setMinScale(v);
        } else {
            if (ENABLEMINMAXERRORCHECK && !this.isDataLimitAtAxisScale() && this.axis[_axis].stepsize != null && v > this.axis[_axis].stepsize.minlimit) {
                if (isDate) {
                    java.sql.Date d = new java.sql.Date((long)this.axis[_axis].stepsize.minlimit);
                    throw new IllegalArgumentException("Min must be before " + DateFormat.getDateTimeInstance().format(d));
                }
                throw new IllegalArgumentException("Min must be <= " + this.axis[_axis].stepsize.minlimit);
            }
            this.axis[_axis].setMinScale(v);
        }
    }

    public final void setAxisMaxScale(int _axis, double v) {
        this.setAxisMaxScale(_axis, v, false);
    }

    public final void setAxisMaxScale(int _axis, double v, boolean isDate) {
        if (this.remakeTable) {
            this.validatePosition();
        }
        if (_axis > 3 && this.colDataAxis != null) {
            if (!this.isDataLimitAtAxisScale() && this.colDataAxis[_axis - 4].stepsize != null && v < this.colDataAxis[_axis - 4].stepsize.maxlimit) {
                if (isDate) {
                    java.sql.Date d = new java.sql.Date((long)this.colDataAxis[_axis - 4].stepsize.maxlimit);
                    throw new IllegalArgumentException("Max must be after " + DateFormat.getDateTimeInstance().format(d));
                }
                throw new IllegalArgumentException("Max must be >= " + this.colDataAxis[_axis - 4].stepsize.maxlimit);
            }
            this.colDataAxis[_axis - 4].setMaxScale(v);
        } else {
            if (ENABLEMINMAXERRORCHECK && !this.isDataLimitAtAxisScale() && this.axis[_axis].stepsize != null && v < this.axis[_axis].stepsize.maxlimit) {
                if (isDate) {
                    java.sql.Date d = new java.sql.Date((long)this.axis[_axis].stepsize.maxlimit);
                    throw new IllegalArgumentException("Max must be after " + DateFormat.getDateTimeInstance().format(d));
                }
                throw new IllegalArgumentException("Max must be >= " + this.axis[_axis].stepsize.maxlimit);
            }
            this.axis[_axis].setMaxScale(v);
        }
    }

    public final void setAxisStepSize(int _axis, double v) {
        if (this.remakeTable) {
            this.validatePosition();
        }
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].setScaleStep(v);
        } else {
            this.axis[_axis].setScaleStep(v);
        }
    }

    public final void setAxisStepSize(int _axis, int y, int m, int d, int hr, int min) {
        int val = y * 12 + m;
        this.setAxisStepMonth(_axis, val);
        long scale = ((long)d * 86400L + (long)hr * 3600L + (long)min * 60L) * 1000L;
        this.setAxisStepSize(_axis, scale);
    }

    public final void setAxisStepMonth(int _axis, int v) {
        this.axis[_axis].setScaleStepMonth(v);
    }

    public int getAxisStepMonth(int _axis) {
        return this.axis[_axis].getScaleStepMonth();
    }

    public final boolean getWallFrameState() {
        return this.showWallFrame;
    }

    public final void setWallFrame(boolean state) {
        this.showWallFrame = state;
    }

    public abstract double getAnimateSpeed();

    public abstract void setAnimateSpeed(double var1);

    public boolean isChartVisible() {
        return this.showChart;
    }

    public void setChartVisible(boolean b) {
        this.showChart = b;
    }

    public final boolean getPointState() {
        return this.showPoint;
    }

    public final void setPointState(boolean state) {
        this.showPoint = state;
    }

    public final boolean getPointState2() {
        return this.showPoint2;
    }

    public final void setPointState2(boolean state) {
        this.showPoint2 = state;
    }

    public final boolean isDrawPointBorder() {
        return this.drawPointBorder;
    }

    public final void setDrawPointBorder(boolean b) {
        this.drawPointBorder = b;
    }

    public final boolean isDrawPointBorder2() {
        return this.drawPointBorder2;
    }

    public final void setDrawPointBorder2(boolean b) {
        this.drawPointBorder2 = b;
    }

    public final Color getDrawPointBorderColor() {
        return this.drawPointBorderColor;
    }

    public final void setDrawPointBorderColor(Color c) {
        this.drawPointBorderColor = c;
    }

    public final Color getDrawPointBorderColor2() {
        return this.drawPointBorderColor2;
    }

    public final void setDrawPointBorderColor2(Color c) {
        this.drawPointBorderColor2 = c;
    }

    public final boolean getLabelState() {
        return !Chart.isCircularChart(this.chartType) ? false : ((IPieChart)((Object)this)).getPieChart().showLabel;
    }

    public final void setLabelState(boolean state) {
        ((IPieChart)((Object)this)).getPieChart().showLabel = state;
    }

    public final boolean getCatLabelState() {
        return !Chart.isCircularChart(this.chartType) ? false : ((IPieChart)((Object)this)).getPieChart().showCategory;
    }

    public final void setCatLabelState(boolean state) {
        ((IPieChart)((Object)this)).getPieChart().showCategory = state;
    }

    public final boolean getConcentricDoughnut() {
        return this.chartType != 20 ? false : ((IPieChart)((Object)this)).getPieChart().concentricDoughnut;
    }

    public final void setConcentricDoughnut(boolean state) {
        ((IPieChart)((Object)this)).getPieChart().concentricDoughnut = state;
    }

    public final boolean getPercentState() {
        return !Chart.isCircularChart(this.chartType) ? false : ((IPieChart)((Object)this)).getPieChart().showPercent;
    }

    public final void setPercentState(boolean state) {
        ((IPieChart)((Object)this)).getPieChart().showPercent = state;
    }

    public final boolean getSmartState() {
        return !Chart.isCircularChart(this.chartType) ? false : ((IPieChart)((Object)this)).getPieChart().smartlabel;
    }

    public final void setSmartState(boolean state) {
        ((IPieChart)((Object)this)).getPieChart().smartlabel = state;
    }

    public final boolean isValueInLegend() {
        return !Chart.isCircularChart(this.chartType) ? false : ((IPieChart)((Object)this)).getPieChart().valInLegend;
    }

    public final void setValueInLegend(boolean state) {
        ((IPieChart)((Object)this)).getPieChart().valInLegend = state;
    }

    public final boolean getValueState() {
        return !Chart.isCircularChart(this.chartType) ? false : ((IPieChart)((Object)this)).getPieChart().showValue;
    }

    public final void setValueState(boolean state) {
        ((IPieChart)((Object)this)).getPieChart().showValue = state;
    }

    public final boolean getRadialBorderState() {
        return !Chart.isCircularChart(this.chartType) ? false : ((IPieChart)((Object)this)).getPieChart().radialBorder;
    }

    public final void setRadialBorderState(boolean state) {
        ((IPieChart)((Object)this)).getPieChart().radialBorder = state;
    }

    public final boolean getZeroLabelsVisibleState() {
        return !Chart.isCircularChart(this.chartType) ? false : ((IPieChart)((Object)this)).getPieChart().zeroLabelsVisible;
    }

    public final void setZeroLabelsVisibleState(boolean state) {
        ((IPieChart)((Object)this)).getPieChart().zeroLabelsVisible = state;
    }

    public final Color getPieBorderColor() {
        return !Chart.isCircularChart(this.chartType) ? Color.black : ((IPieChart)((Object)this)).getPieChart().pieBorderColor;
    }

    public final void setPieBorderColor(Color color) {
        ((IPieChart)((Object)this)).getPieChart().pieBorderColor = color;
    }

    public final boolean isPieExtendLineDrawn() {
        return !Chart.isCircularChart(this.chartType) ? false : ((IPieChart)((Object)this)).getPieChart().pieExtendLine;
    }

    public final void setPieExtendLineDrawn(boolean drawn) {
        ((IPieChart)((Object)this)).getPieChart().pieExtendLine = drawn;
    }

    public final boolean isPieLabelAtTheSide() {
        return !Chart.isCircularChart(this.chartType) ? false : ((IPieChart)((Object)this)).getPieChart().labelAtTheSide;
    }

    public final void setPieLabelAtTheSide(boolean drawn) {
        ((IPieChart)((Object)this)).getPieChart().labelAtTheSide = drawn;
    }

    public final int getPiePerRow() {
        return ((IPieChart)((Object)this)).getPieChart().getPiePerRow();
    }

    public final void setPiePerRow(int nPie) {
        ((IPieChart)((Object)this)).getPieChart().setPiePerRow(nPie);
    }

    public final double getGapRatioBetweenPies() {
        return ((IPieChart)((Object)this)).getPieChart().getGapRatioBetweenPies();
    }

    public final void setGapRatioBetweenPies(double ratio) {
        ((IPieChart)((Object)this)).getPieChart().setGapRatioBetweenPies(ratio);
    }

    public final boolean isDrawLinearlyForPies() {
        return ((IPieChart)((Object)this)).getPieChart().isDrawLinearly();
    }

    public final void setDrawLinearlyForPies(boolean b) {
        ((IPieChart)((Object)this)).getPieChart().setDrawLinearly(b);
    }

    public final boolean isBestFitForPies() {
        return ((IPieChart)((Object)this)).getPieChart().isBestFit();
    }

    public final void setBestFitForPies(boolean b) {
        ((IPieChart)((Object)this)).getPieChart().setBestFit(b);
    }

    @Deprecated
    public int getPieSectors() {
        return ((IPieChart)((Object)this)).getPieChart().pieSectors;
    }

    @Deprecated
    public void setPieSectors(int sectors) {
        ((IPieChart)((Object)this)).getPieChart().pieSectors = sectors == -1 ? -1 : (sectors < 24 ? 24 : (sectors > 500 ? 500 : sectors));
    }

    public int getDoughnutArcLength() {
        return ((IPieChart)((Object)this)).getPieChart().pieThickness[0];
    }

    public void setDoughnutArcLength(int thick) {
        ((IPieChart)((Object)this)).getPieChart().pieThickness[0] = thick < 1 ? 1 : (thick > 100 ? 100 : thick);
    }

    public final boolean getTickerLabelState(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].showTicker;
        }
        return this.axis[_axis].showTicker;
    }

    public final void setTickerLabelState(int _axis, boolean state) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].showTicker = state;
        } else {
            this.axis[_axis].showTicker = state;
        }
    }

    public final boolean getTickerLabelState(Axis _axis) {
        return _axis.showTicker;
    }

    public final void setTickerLabelState(Axis _axis, boolean state) {
        _axis.showTicker = state;
    }

    public final Object[] getOriginalTickerLabels(int _axis, boolean formated) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].ticker.getOriginalTickerLabels(formated);
        }
        return this.axis[_axis].ticker.getOriginalTickerLabels(formated);
    }

    public final void setTickerLabels(int _axis, String[] labels) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].ticker.setTickerLabels(labels);
        } else {
            this.axis[_axis].ticker.setTickerLabels(labels);
        }
    }

    public final void setTickerLineState(int _axis, boolean state) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].ticker.showline = state;
        } else {
            this.axis[_axis].ticker.showline = state;
        }
    }

    public final void setTickerLineState(Axis _axis, boolean state) {
        _axis.ticker.showline = state;
    }

    public final boolean getTickerLineState(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].ticker.showline;
        }
        return this.axis[_axis].ticker.showline;
    }

    public final void setTickerDrawInward(int _axis, boolean state) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].ticker.tickerInward = state;
        } else {
            this.axis[_axis].ticker.tickerInward = state;
        }
    }

    public final void setTickerDrawInward(Axis _axis, boolean state) {
        _axis.ticker.tickerInward = state;
    }

    public final boolean isTickerDrawInward(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].ticker.tickerInward;
        }
        return this.axis[_axis].ticker.tickerInward;
    }

    public final Color getTickerColor(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].ticker.color;
        }
        return this.axis[_axis].ticker.color;
    }

    public final void setTickerColor(int _axis, Color color) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].ticker.setTickerColor(color);
        } else {
            this.axis[_axis].ticker.setTickerColor(color);
        }
    }

    public final Font getTickerFont(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].ticker.font;
        }
        return this.axis[_axis].ticker.font;
    }

    public final void setTickerFont(int _axis, Font font, int angle) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].ticker.setFont(font, angle, false);
        } else {
            this.axis[_axis].ticker.setFont(font, angle, false);
        }
    }

    public final void setTickerFont(int _axis, Font font) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].ticker.setFont(font);
        } else {
            this.axis[_axis].ticker.setFont(font);
        }
    }

    public final int getTickerAngle(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].ticker.angle;
        }
        return this.axis[_axis].ticker.angle;
    }

    public final Color getLabelColor(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4].ticker.label_color;
        }
        return this.axis[_axis].ticker.label_color;
    }

    public final int getLabelStepSize(int colNo) {
        if (colNo >= this.nCol || colNo < 0) {
            return -1;
        }
        return this.colData[colNo].sepSize;
    }

    public final int getMaxLabelAndTickerCount(int colNo) {
        if (colNo >= this.nCol || colNo < 0) {
            return -1;
        }
        return this.colData[colNo].maxNumOfTickerAndLabel;
    }

    public final void setLabelColor(int _axis, Color color) {
        if (_axis > 3 && this.colDataAxis != null) {
            this.colDataAxis[_axis - 4].ticker.setLabelColor(color);
        } else {
            this.axis[_axis].ticker.setLabelColor(color);
        }
    }

    public Axis getAxisByID(int _axis) {
        if (_axis > 3 && this.colDataAxis != null) {
            return this.colDataAxis[_axis - 4];
        }
        return this.axis[_axis];
    }

    public final void setLabelStepSize(int colNo, int stepsize) {
        if (stepsize <= 0) {
            return;
        }
        this.colData[colNo].sepSize = stepsize;
    }

    public final void setMaxLabelAndTickerCount(int colNo, int ct) {
        this.colData[colNo].maxNumOfTickerAndLabel = ct;
    }

    public final void setLabelStepUnit(int colNo, int stepUnit) {
        this.colData[colNo].sepUnit = stepUnit;
    }

    public final void setLabelOrdering(int colNo, boolean isAscending) {
        this.colData[colNo].isAscending = isAscending;
        for (int k = 0; k < this.dataDim; ++k) {
            if (this.mDataMap[k] != colNo) continue;
            this.setFieldOrder(k, isAscending);
            break;
        }
    }

    public final void setLabelStartingDate(int colNo, boolean isAscending, Date date) {
        if (isAscending) {
            this.colData[colNo].setStartingDate(date);
        } else {
            this.colData[colNo].setEndingDate(date);
        }
    }

    public final void setTickerStepSize(int colNo, int stepsize) {
        if (colNo >= this.nCol || colNo < 0) {
            return;
        }
        if (stepsize <= 0) {
            return;
        }
        this.colData[colNo].tickerSepSize = stepsize;
    }

    public final int getTickerStepSize(int colNo) {
        if (colNo >= this.nCol || colNo < 0) {
            return -1;
        }
        return this.colData[colNo].tickerSepSize;
    }

    public final IFormat getLabelFormat(int colNo) {
        if (colNo >= this.nCol || colNo < 0) {
            return null;
        }
        return this.colData[colNo].dataFormat;
    }

    public final void setLabelFormat(int colNo, IFormat format) throws IllegalArgumentException {
        if (colNo == this.nCol && this.chartType == 11 && this.colData.length > this.nCol) {
            this.colData[colNo].dataFormat = format;
        }
        if (colNo >= this.nCol || colNo < 0) {
            return;
        }
        this.colData[colNo].dataFormat = format;
    }

    public final void setLabelStepSizeByAxis(int _axis, int stepsize) {
        if (stepsize <= 0) {
            return;
        }
        this.getAxisByID((int)_axis).columnField.sepSize = stepsize;
    }

    public final void setMaxLabelAndTickerCountByAxis(int _axis, int ct) {
        this.getAxisByID((int)_axis).columnField.maxNumOfTickerAndLabel = ct;
    }

    public final int getLabelStepSizeByAxis(int _axis) {
        return this.getAxisByID((int)_axis).columnField.sepSize;
    }

    public final int getMaxLabelAndTickerCountByAxis(int _axis) {
        return this.getAxisByID((int)_axis).columnField.maxNumOfTickerAndLabel;
    }

    public final void setLabelStepUnitByAxis(int _axis, int stepUnit) {
        this.getAxisByID((int)_axis).columnField.sepUnit = stepUnit;
    }

    public final void setLabelStartingDateByAxis(int _axis, boolean isAscending, Date date) {
        if (isAscending) {
            this.getAxisByID((int)_axis).columnField.setStartingDate(date);
        } else {
            this.getAxisByID((int)_axis).columnField.setEndingDate(date);
        }
    }

    public final void setTickerStepSizeByAxis(int _axis, int stepsize) {
        if (stepsize <= 0) {
            return;
        }
        this.getAxisByID((int)_axis).columnField.tickerSepSize = stepsize;
    }

    public final int getTickerStepSizeByAxis(int _axis) {
        return this.getAxisByID((int)_axis).columnField.tickerSepSize;
    }

    public final IFormat getLabelFormatByAxis(int _axis) {
        return this.getAxisByID((int)_axis).columnField.dataFormat;
    }

    public final void setLabelFormatByAxis(int _axis, IFormat format) throws IllegalArgumentException {
        this.getAxisByID((int)_axis).columnField.dataFormat = format;
    }

    public final IFormat getGanttLabelFormat() {
        if (this.hilowCol.low < this.nCol && this.hilowCol.low > 0) {
            return this.colData[this.hilowCol.low].dataFormat;
        }
        if (this.hilowCol.hi < this.nCol && this.hilowCol.hi > 0) {
            return this.colData[this.hilowCol.hi].dataFormat;
        }
        return null;
    }

    public final void setGanttLabelFormat(IFormat format) throws IllegalArgumentException {
        if (this.hilowCol.hi == -1) {
            int n = this.hilowCol.hi = this.bvalueCol ? this.valueCol : this.coordCol[0];
        }
        if (this.hilowCol.low == -1) {
            int n = this.hilowCol.low = this.bvalueCol ? this.valueCol : this.coordCol[1];
        }
        if (this.hilowCol.low < this.nCol && this.hilowCol.low > 0) {
            this.colData[this.hilowCol.low].dataFormat = format;
            if (this.hilowCol.hi < this.nCol && this.hilowCol.hi > 0) {
                this.colData[this.hilowCol.hi].dataFormat = format;
            }
        } else {
            LOGGER.warning("Gantt Chart Label DateTimeFormat has not been set");
        }
    }

    public final boolean isDataLimitAtAxisScale() {
        return this.isDataLimitAtAxisScale;
    }

    public final void setDataLimitAtAxisScale(boolean b) {
        this.isDataLimitAtAxisScale = b;
    }

    public final boolean getTopValueState() {
        return this.showTopValue;
    }

    public final void setTopValueState(boolean state) {
        this.showTopValue = state;
    }

    public boolean isTopLabelVisible(CString topLabel) {
        if (this.getTopValueState() && this.topLabels.contains(topLabel)) {
            return true;
        }
        return this.getTopValueState2() && this.topLabels2.contains(topLabel);
    }

    public final boolean getTopValueState2() {
        return this.showTopValue2;
    }

    public final void setTopValueState2(boolean state) {
        this.showTopValue2 = state;
    }

    public final boolean getStackLabelState() {
        return this.showStackLabel;
    }

    public final void setStackLabelState(boolean state) {
        this.showStackLabel = state;
    }

    public final boolean getStackTotalLabelState() {
        return this.showStackTotalLabel;
    }

    public final void setStackTotalLabelState(boolean state) {
        this.showStackTotalLabel = state;
    }

    public final boolean isLabelOnPositiveSide() {
        return this.isLabelOnPositiveSide;
    }

    public final void setLabelOnPositiveSide(boolean state) {
        if (state) {
            this.isLabelOnNegativeSide = false;
        }
        this.isLabelOnPositiveSide = state;
    }

    public final boolean isLabelOnNegativeSide() {
        return this.isLabelOnNegativeSide;
    }

    public final void setLabelOnNegativeSide(boolean state) {
        if (state) {
            this.isLabelOnPositiveSide = false;
        }
        this.isLabelOnNegativeSide = state;
    }

    public final Color getTopValueColor() {
        return this.topvalueLabel_color;
    }

    public final void setTopValueColor(Color c) {
        this.topvalueLabel_color = c;
        CString.setStringsColor(this.topLabels, c);
    }

    public final Color getTopValueColorOnNegativeSide() {
        return this.topvalueNegativeLabel_color;
    }

    public final void setTopValueColorOnNegativeSide(Color c) {
        this.topvalueNegativeLabel_color = c;
        this.isComputed = false;
    }

    public final Color getTopValueColor2() {
        return this.topvalueLabel2_color;
    }

    public final void setTopValueColor2(Color c) {
        this.topvalueLabel2_color = c;
        CString.setStringsColor(this.topLabels2, c);
    }

    public final int getTopValueAngle() {
        return this.topvalueLabel_angle;
    }

    public final Font getTopValueFont() {
        return this.topvalueLabel_font;
    }

    public final void setTopValueFont(Font f, int angle) {
        this.topvalueLabel_font = f;
        this.topvalueLabel_angle = angle;
        CString.setStringsFont(this.topLabels, f, angle);
    }

    public final int getTopValueAngle2() {
        return this.topvalueLabel2_angle;
    }

    public final Font getTopValueFont2() {
        return this.topvalueLabel2_font;
    }

    public final void setTopValueFont2(Font f, int angle) {
        this.topvalueLabel2_font = f;
        this.topvalueLabel2_angle = angle;
        CString.setStringsFont(this.topLabels2, f, angle);
    }

    public final Dimension getTopValueOffset() {
        if (this.is2DChart) {
            return new Dimension(this.toplabel_offset_up, this.toplabel_offset_side);
        }
        return new Dimension(this.toplabel_offset3D_up, this.toplabel_offset3D_side);
    }

    public final void setTopValueOffset(int xoffset, int yoffset) {
        if (this.is2DChart) {
            this.toplabel_offset_up = yoffset;
            this.toplabel_offset_side = xoffset;
        } else {
            this.toplabel_offset3D_up = yoffset;
            this.toplabel_offset3D_side = xoffset;
        }
    }

    public final Dimension getTopValueOffset2() {
        if (this.is2DChart) {
            return new Dimension(this.toplabel2_offset_up, this.toplabel2_offset_side);
        }
        return new Dimension(this.toplabel2_offset3D_up, this.toplabel2_offset3D_side);
    }

    public final void setTopValueOffset2(int xoffset, int yoffset) {
        if (this.is2DChart) {
            this.toplabel2_offset_up = yoffset;
            this.toplabel2_offset_side = xoffset;
        } else {
            this.toplabel2_offset3D_up = yoffset;
            this.toplabel2_offset3D_side = xoffset;
        }
    }

    public final int getDataDimension() {
        return this.dataDim;
    }

    public final int[] getDataMap() {
        return this.mDataMap;
    }

    public final int getValueMap() {
        return this.valueCol;
    }

    public final int getSubValueMap() {
        return this.subvalueCol;
    }

    public final int[] getCoordMap() {
        if (this.bcoordCol[2]) {
            return this.coordCol;
        }
        int[] map = new int[]{this.coordCol[0], this.coordCol[1], -1};
        return map;
    }

    public final int getChartType() {
        return this.chartType;
    }

    public final double getThickRatio() {
        return this.thickRatio;
    }

    public final void setThickRatio(double thickRatio) {
        this.thickRatio = thickRatio;
    }

    public final double getBarwidthRatio() {
        return this.barwidthRatio;
    }

    public final void setBarwidthRatio(double ratio) {
        this.barwidthRatio = ratio;
    }

    public final double getMaxBarWidthRatioToPlotArea() {
        return this.maxBarWidthRatioToPlotArea;
    }

    public final void setMaxBarWidthRatioToPlotArea(double ratio) {
        this.maxBarWidthRatioToPlotArea = ratio;
    }

    public boolean showOffsetTicker() {
        return this.showOffsetTicker;
    }

    public void setOffsetTicker(boolean b) {
        this.showOffsetTicker = b;
    }

    public final Area getWallBackground() {
        return this.wallbackground;
    }

    public final void setWallBackground(Area area) {
        this.wallbackground = area;
    }

    public final ColorSpectrum getColorSpectrum() {
        return this.colorSpectrum;
    }

    public final void setColorSpectrum(ColorSpectrum colorSpectrum) {
        this.colorSpectrum = colorSpectrum;
    }

    public abstract int get3DDrawType();

    public abstract void set3DDrawType(int var1);

    public final int getAxisTitle_HOffset(int ax) {
        return this.axis[ax].titleoffset;
    }

    public final void setAxisTitle_HOffset(int ax, int offset) {
        this.axis[ax].titleoffset = offset;
    }

    public final int getAxisTitle_VOffset(int ax) {
        return this.axis[ax].titlevoffset;
    }

    public final void setAxisTitle_VOffset(int ax, int offset) {
        this.axis[ax].titlevoffset = offset;
    }

    public abstract float[] getViewPoint();

    public abstract void setViewPoint(float[] var1);

    public abstract Point_3D[] getViewDirection();

    public abstract void setViewDirection(Point_3D[] var1);

    public abstract float[] getViewTranslate();

    public abstract void setViewTranslate(float[] var1);

    public abstract Point_3D getViewTranslation();

    public abstract void setViewTranslation(Point_3D var1);

    public abstract float[] getLightPos();

    public abstract void setLightPos(float[] var1);

    public abstract Point_3D getLightPosition();

    public abstract void setLightPosition(Point_3D var1);

    public abstract Color getAmbientLight();

    public abstract void setAmbientLight(Color var1);

    public abstract float[] getAmbient();

    public abstract void setAmbient(float[] var1);

    public abstract float[] getIntensity();

    public abstract void setIntensity(float[] var1);

    public abstract Color getLightIntensity();

    public abstract void setLightIntensity(Color var1);

    public abstract float getZoomfactor();

    public abstract void setZoomfactor(float var1);

    public abstract float getX_scale();

    public abstract float getY_scale();

    public abstract float getZ_scale();

    public abstract boolean isSwapAxis();

    public abstract void setSwapAxis(boolean var1);

    public boolean isJoinAxis() {
        return this.isJoinAxis && this.subvalueCol >= 0 || this.isShowDoubleValueForLine();
    }

    public void setJoinAxis(boolean state) {
        this.isJoinAxis = state;
        if (state) {
            if (DataLine.isBarChartType(this)) {
                if (this.a_s != null) {
                    this.a_s.addAxisPadding = this.a_x.addAxisPadding;
                }
            } else if (this.a_s != null) {
                this.a_s.addAxisPadding = this.a_y.addAxisPadding;
            }
        }
    }

    public boolean isGridAlignedWithTicker() {
        return this.isGridAlignedWithTicker;
    }

    public void setGridAlignedWithTicker(boolean state) {
        this.isGridAlignedWithTicker = state;
    }

    public boolean isGridInFront() {
        return this.isGridInFront;
    }

    public void setGridInFront(boolean state) {
        this.isGridInFront = state;
    }

    public float getChartWidthProp() {
        return this.chart_widthProp;
    }

    public void setChartWidthProp(float w) {
        this.chart_widthProp = w;
    }

    public float getChartHeightProp() {
        return this.chart_heightProp;
    }

    public void setChartHeightProp(float h) {
        this.chart_heightProp = h;
    }

    public float getChart_XProp() {
        return this.chart_XProp;
    }

    public void setChart_XProp(float w) {
        this.chart_XProp = w;
    }

    public float getChart_YProp() {
        return this.chart_YProp;
    }

    public void setChart_YProp(float h) {
        this.chart_YProp = h;
    }

    public Color getAxisColor() {
        if (this.is2DChart) {
            return this.axis[0].color;
        }
        return this.wallbackground.areaColor;
    }

    public abstract void setAxisColor(Color var1);

    public Color getAxisColor(int ax) {
        if (ax > 3 && this.colDataAxis != null) {
            return this.colDataAxis[ax - 4].color;
        }
        return this.getAxisColor();
    }

    public void setAxisColor(Color color, Axis ax) {
        for (Axis axi : this.axis) {
            if (ax != axi) continue;
            this.setAxisColor(color);
            return;
        }
        ax.setColor(color);
    }

    public void setAxisColor(Color color, int ax) {
        if (ax > 3 && this.colDataAxis != null) {
            this.colDataAxis[ax - 4].setColor(color);
        } else {
            this.setAxisColor(color);
        }
    }

    public Color getDataColor(MultiDimData mdata) {
        int chartType = mdata.chart.getChartType();
        if (this.uniqueColorForCol && (chartType == 0 || chartType == 1)) {
            return mdata.area.areaColor;
        }
        if (((chartType == 0 || chartType == 1) && (this.dataDim > 1 || mdata.parent == this.mData2) || chartType == 7 || this.isHiLow() || chartType == 2 && !this.is2DChart || chartType == 14) && mdata.parent != null) {
            return mdata.parent.area.areaColor;
        }
        return mdata.area.areaColor;
    }

    public void setDataColor(MultiDimData mdata, Color color) {
        int chartType = mdata.chart.getChartType();
        if (this.uniqueColorForCol && (chartType == 0 || chartType == 1)) {
            mdata.setColor(color);
            return;
        }
        if (chartType == 3 && this.is2DChart || chartType == 2 && this.is2DChart || chartType == 13 || chartType == 19 || chartType == 15 || chartType == 17 || chartType == 16 || ((chartType == 0 || chartType == 1) && !mdata.chart.isSingleColorForCategories() || Chart.isCircularChart(chartType)) && this.dataDim == 1 && (mdata.parent != this.mData2 || this.mData2 == null)) {
            mdata.setColor(color);
            return;
        }
        if (chartType == 0 || chartType == 1 || chartType == 7 || chartType == 14 || this.isHiLow() || chartType == 3 || Chart.isCircularChart(chartType) || chartType == 2 && !this.is2DChart || chartType == 16 || chartType == 12 && !this.is2DChart) {
            if (mdata.parent != null) {
                mdata = mdata.parent;
            }
            mdata.setColor(color);
            return;
        }
        if (chartType == 4 || chartType == 5 || chartType == 11 || chartType == 8) {
            int pos;
            MultiDimData pmdata = mdata.parent;
            for (pos = 0; pos < pmdata.multiData.length && pmdata.multiData[pos] != mdata; ++pos) {
            }
            mdata = pmdata.parent;
            for (MultiDimData element : mdata.multiData) {
                element.multiData[pos].setColor(color);
            }
            return;
        }
    }

    public final IFormat getSpecNumericFormat() {
        return this.colData[this.nCol].dataFormat;
    }

    public final void setSpecNumericFormat(IFormat format) {
        this.colData[this.nCol].dataFormat = format;
    }

    public final int getGridThickness(int ax) {
        if (ax > 3 && this.colDataAxis != null) {
            return this.colDataAxis[ax - 4].gridThickness;
        }
        return this.axis[ax].gridThickness;
    }

    public final void setGridThickness(int ax, int thickness) {
        if (ax > 3 && this.colDataAxis != null) {
            this.colDataAxis[ax - 4].gridThickness = thickness;
        } else {
            this.axis[ax].gridThickness = thickness;
        }
    }

    public final int getGridLineStyle(int ax) {
        if (ax > 3 && this.colDataAxis != null) {
            return this.colDataAxis[ax - 4].gridLineStyle;
        }
        return this.axis[ax].gridLineStyle;
    }

    public final void setGridLineStyle(int ax, int lineStyle) {
        if (ax > 3 && this.colDataAxis != null) {
            this.colDataAxis[ax - 4].gridLineStyle = lineStyle;
        } else {
            this.axis[ax].gridLineStyle = lineStyle;
        }
    }

    public final boolean isSkipGridOffset(int ax) {
        if (ax > 3 && this.colDataAxis != null) {
            return this.colDataAxis[ax - 4].skipGridOffset;
        }
        return this.axis[ax].skipGridOffset;
    }

    public final void setSkipGridOffset(int ax, boolean skipGridOffset) {
        if (ax > 3 && this.colDataAxis != null) {
            this.colDataAxis[ax - 4].skipGridOffset = skipGridOffset;
        } else {
            this.axis[ax].skipGridOffset = skipGridOffset;
        }
    }

    public final int getBorderThickness() {
        return this.border.depth;
    }

    public final void setBorderThickness(int thick) {
        this.border.depth = thick;
    }

    public final int[] getSeriesType() {
        if (this.getChartType() == 14) {
            return this.colData[this.mDataMap[0]].getFieldType();
        }
        if (this.isOverlayCombo()) {
            return this.colData[this.getComboSeries()].getFieldType();
        }
        return this.colData[this.mDataMap[0]].getFieldType();
    }

    public final void setSeriesType(int[] s) {
        this.setSeriesType(s, false);
    }

    public final void setSeriesType(int[] s, boolean updateOrigFieldType) {
        ColData colData1 = null;
        if (this.getChartType() == 14) {
            colData1 = this.colData[this.mDataMap[0]];
        } else if (this.isOverlayCombo()) {
            colData1 = this.colData[this.getComboSeries()];
        }
        if (colData1 != null) {
            colData1.setFieldType(s);
            if (updateOrigFieldType) {
                colData1.org_fieldType = s;
            }
        }
    }

    public final int[] getAxisPosition() {
        if (this.getChartType() == 14) {
            return this.colData[this.mDataMap[0]].getAxisPosition();
        }
        if (this.getChartType() == 16) {
            return this.colData[this.mDataMap[this.dataDim - 1]].getAxisPosition();
        }
        if (this.isOverlayCombo()) {
            return this.colData[this.getComboSeries()].getAxisPosition();
        }
        return this.colData[this.mDataMap[0]].getAxisPosition();
    }

    public final void setAxisPosition(int[] s) {
        this.setAxisPosition(s, false);
    }

    public final void setAxisPosition(int[] s, boolean updateOrigAxisPosition) {
        ColData colData1 = null;
        if (this.getChartType() == 14) {
            colData1 = this.colData[this.mDataMap[0]];
        } else if (this.getChartType() == 16) {
            colData1 = this.colData[this.mDataMap[this.dataDim - 1]];
        } else if (this.isOverlayCombo()) {
            colData1 = this.colData[this.getComboSeries()];
        }
        if (colData1 != null) {
            colData1.setAxisPosition(s);
            if (updateOrigAxisPosition) {
                colData1.org_showAxis = s;
            }
        }
    }

    public boolean drawSecAxisForOverlay() {
        if (this.chartType == 14 || this.isOverlayCombo()) {
            int[] isSec;
            for (int element : isSec = this.getAxisPosition()) {
                if (element != -2) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOverlayCombo() {
        return !this.processedChart && this.subvalueCol >= 0 && this.is2DimChart() && this.getComboType() == 3 && this.getComboSeries() >= 0;
    }

    public boolean isAutoAxisPosition() {
        return this.autoAxisPosition;
    }

    public void setAutoAxisPosition(boolean b) {
        this.autoAxisPosition = b;
    }

    public int getAxisGapOffset() {
        return this.axisGapOffset;
    }

    public void setAxisGapOffset(int f) {
        this.axisGapOffset = f;
    }

    public final double[] getHandLength() {
        return this.colData[this.mDataMap[0]].getHandLength();
    }

    public final void setHandLength(double[] s) {
        this.colData[this.mDataMap[0]].setHandLength(s);
    }

    public final int[] getLineThickess() {
        int[] thickness = new int[this.mData.multiData.length];
        for (int i = 0; i < thickness.length; ++i) {
            thickness[i] = this.mData.multiData[i].getLineThickness();
        }
        return thickness;
    }

    public final void setLineThickess(int[] thickness) {
        for (int i = 0; i < thickness.length; ++i) {
            if (i >= this.mData.multiData.length) continue;
            this.mData.multiData[i].setLineThickness(thickness[i]);
        }
    }

    public final boolean[] getHideDataItems(int c) {
        return c < this.nCol && c >= 0 ? this.colData[c].getHideData() : null;
    }

    public final void setHideDataItems(int c, boolean[] b) {
        if (c < this.nCol && c >= 0) {
            this.colData[c].setHideData(b);
        }
    }

    public final boolean[] getLegendItems(int c) {
        return c < this.nCol && c >= 0 ? this.colData[c].getHideLegend() : null;
    }

    public final void setLegendItems(int c, boolean[] b) {
        if (c < this.nCol && c >= 0) {
            this.colData[c].setHideLegend(b);
        }
    }

    public Color[] getDataColor() {
        if (this.dataColors != null) {
            return this.dataColors;
        }
        return new DataAttribute((MultiDimData)this.mData, (boolean)false, (boolean)this.is2DChart, (int)this.chartType, (boolean)false, (boolean)this.isUniqueColorForCol()).dataColor;
    }

    public void setDataColor(Color[] carray) {
        this.setDataColor(carray, carray[0], this.mData, false);
    }

    public void setDataColor(Color[] carray, Color rootColor) {
        this.setDataColor(carray, rootColor, this.mData, false);
    }

    public void setDataColor(Color[] carray, Color rootColor, MultiDimData md, boolean isMData2) {
        Color[] orgColor = this.dataColors;
        this.dataColors = carray;
        if (md == null) {
            return;
        }
        DataAttribute dattr = new DataAttribute(md, isMData2, md.chart.is2DChart, md.chart.chartType, false, this.isUniqueColorForCol());
        dattr.rootPointColor = rootColor;
        for (int i = 0; i < Math.min(carray.length, dattr.dataColor.length); ++i) {
            dattr.dataColor[i] = carray[i];
        }
        dattr.loadAttribute(md, md.chart.is2DChart, md.chart.chartType, this.isUniqueColorForCol());
        if (md == this.mData2) {
            this.dataColors = orgColor;
        }
    }

    public void clearChartDataSet() {
        DataAttribute dataAttr = new DataAttribute(this.mData, false, this.is2DChart, this.chartType);
        this.chartColorSet.setChartDataPointsColors(dataAttr.dataColor);
    }

    public Color[] getDataColor2() {
        return this.mData2 == null ? null : new DataAttribute((MultiDimData)this.mData2, (boolean)true, (boolean)this.mData2.chart.is2DChart, (int)this.mData2.chart.chartType).dataColor;
    }

    public void setDataColor2(Color[] carray) {
        this.setDataColor(carray, carray[0], this.mData2, true);
    }

    public void clearChartDataSet2() {
        if (this.mData2 != null) {
            DataAttribute dataAttr = new DataAttribute(this.mData2, true, this.is2DChart, this.chartType);
            this.chartColorSet2.setChartDataPointsColors(dataAttr.dataColor);
        }
    }

    public final Integer[] getDataShapeInt() {
        int[] shape = this.getDataShape();
        Integer[] shapeInt = new Integer[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            shapeInt[i] = shape[i];
        }
        return shapeInt;
    }

    public final int[] getDataShape() {
        return this.getDataShape(this.mData, true, false);
    }

    public final void setDataShape(Integer[] sarray) {
        int[] shape = new int[sarray.length];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = sarray[i];
        }
        this.setDataShape(shape, this.mData, true, false);
    }

    public final void setDataShape(int[] sarray) {
        this.setDataShape(sarray, this.mData, true, false);
    }

    private int[] getDataShape(MultiDimData md, boolean bshape, boolean isMData2) {
        if (md == null) {
            return null;
        }
        int[] shape = new DataAttribute((MultiDimData)md, (boolean)isMData2, (boolean)md.chart.is2DChart, (int)md.chart.chartType).dataShape;
        int[] obj = new int[shape.length];
        for (int i = 0; i < obj.length; ++i) {
            obj[i] = bshape ? shape[i] % 256 : shape[i] / 256;
        }
        return obj;
    }

    private void setDataShape(int[] shape, MultiDimData md, boolean bshape, boolean isMData2) {
        if (md == null) {
            return;
        }
        DataAttribute dattr = new DataAttribute(md, isMData2, md.chart.is2DChart, md.chart.chartType, false, md.chart.isUniqueColorForCol());
        for (int i = 0; i < Math.min(shape.length, dattr.dataShape.length); ++i) {
            dattr.dataShape[i] = bshape ? Point3D.shapefn(dattr.dataShape[i], shape[i]) : Line.stylefn(dattr.dataShape[i], shape[i]);
        }
        dattr.rootPointShape = dattr.dataShape[0];
        dattr.loadAttribute(md, this.is2DChart, this.chartType, md.chart.isUniqueColorForCol());
    }

    public final int[] getDataShape2() {
        return this.getDataShape(this.mData2, true, true);
    }

    public final void setDataShape2(Integer[] obj) {
        int[] shape = new int[obj.length];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = obj[i];
        }
        this.setDataShape(shape, this.mData2, true, true);
    }

    public final void setDataShape2(int[] shape) {
        this.setDataShape(shape, this.mData2, true, true);
    }

    public final Integer[] getDataShapeInt2() {
        int[] shape = this.getDataShape2();
        Integer[] shapeInt = new Integer[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            shapeInt[i] = shape[i];
        }
        return shapeInt;
    }

    public Integer[] getDataSizeInt() {
        int[] dSize = this.getDataSize(this.mData);
        Integer[] dSizeInt = new Integer[dSize.length];
        for (int i = 0; i < dSize.length; ++i) {
            dSizeInt[i] = dSize[i];
        }
        return dSizeInt;
    }

    public int[] getDataSize() {
        return this.getDataSize(this.mData);
    }

    public final void setDataSize(int[] sarray) {
        this.setDataSize(sarray, this.mData, false);
    }

    public final void setDataSize(Integer[] sarray) {
        int[] dSize = new int[sarray.length];
        for (int i = 0; i < dSize.length; ++i) {
            dSize[i] = sarray[i];
        }
        this.setDataSize(dSize);
    }

    private int[] getDataSize(MultiDimData md) {
        if (md == null) {
            return null;
        }
        return new DataAttribute((MultiDimData)md, (boolean)false, (boolean)md.chart.is2DChart, (int)md.chart.chartType).dataSize;
    }

    private void setDataSize(int[] size, MultiDimData md, boolean isMData2) {
        if (md == null) {
            return;
        }
        for (int i = 0; i < size.length; ++i) {
            if (size[i] <= 20) continue;
            size[i] = 20;
        }
        DataAttribute dattr = new DataAttribute(md, isMData2, md.chart.is2DChart, md.chart.chartType, false, md.chart.isUniqueColorForCol());
        dattr.dataSize = size;
        if (dattr.dataSize.length > 0) {
            dattr.rootPointSize = dattr.dataSize[0];
            dattr.loadAttribute(md, this.is2DChart, this.chartType, md.chart.isUniqueColorForCol());
        }
        if (!isMData2) {
            this.setDataPtSizes(size);
        }
    }

    public final int[] getDataSize2() {
        return this.getDataSize(this.mData2);
    }

    public final void setDataSize2(Integer[] sarray) {
        int[] dSize = new int[sarray.length];
        for (int i = 0; i < dSize.length; ++i) {
            dSize[i] = sarray[i];
        }
        this.setDataSize2(dSize);
    }

    public final void setDataSize2(int[] dSize) {
        this.setDataSize(dSize, this.mData2, true);
    }

    public final Integer[] getDataSizeInt2() {
        int[] dSize = this.getDataSize(this.mData2);
        Integer[] dSizeInt = new Integer[dSize.length];
        for (int i = 0; i < dSize.length; ++i) {
            dSizeInt[i] = dSize[i];
        }
        return dSizeInt;
    }

    public int[] getDataLineThickness() {
        return this.getDataLineThickness(this.mData);
    }

    public final void setDataLineThickness(int thickness) {
        this.setDataLineThickness(thickness, this.mData, false);
    }

    public final void setDataLineThickness(int[] sarray) {
        this.setDataLineThickness(sarray, this.mData, false);
    }

    private int[] getDataLineThickness(MultiDimData md) {
        if (md == null) {
            return null;
        }
        return new DataAttribute((MultiDimData)md, (boolean)false, (boolean)md.chart.is2DChart, (int)md.chart.chartType).lineThickness;
    }

    private void setDataLineThickness(int thickness, MultiDimData md, boolean isMData2) {
        if (md == null) {
            return;
        }
        if (thickness > 30) {
            thickness = 30;
        } else if (thickness < 1) {
            thickness = 1;
        }
        DataAttribute dattr = new DataAttribute(md, isMData2, md.chart.is2DChart, md.chart.chartType);
        for (int i = 0; i < dattr.lineThickness.length; ++i) {
            dattr.lineThickness[i] = thickness;
        }
        dattr.rootLineThickness = thickness;
        dattr.loadAttribute(md, this.is2DChart, this.chartType);
    }

    private void setDataLineThickness(int[] thickness, MultiDimData md, boolean isMData2) {
        if (md == null) {
            return;
        }
        for (int i = 0; i < thickness.length; ++i) {
            if (thickness[i] > 30) {
                thickness[i] = 30;
                continue;
            }
            if (thickness[i] >= 1) continue;
            thickness[i] = 1;
        }
        DataAttribute dattr = new DataAttribute(md, isMData2, md.chart.is2DChart, md.chart.chartType);
        dattr.lineThickness = thickness;
        if (dattr.lineThickness.length > 0) {
            dattr.rootLineThickness = dattr.lineThickness[0];
            dattr.loadAttribute(md, this.is2DChart, this.chartType);
        }
    }

    public final int[] getDataLineThickness2() {
        return this.getDataLineThickness(this.mData2);
    }

    public final void setDataLineThickness2(int thickness) {
        this.setDataLineThickness(thickness, this.mData2, true);
    }

    public final void setDataLineThickness2(int[] dSize) {
        this.setDataLineThickness(dSize, this.mData2, true);
    }

    public final int[] getLineStyle() {
        return this.getDataShape(this.mData, false, false);
    }

    public final void setLineStyle(int[] shape) {
        this.setDataShape(shape, this.mData, false, false);
    }

    public final void setLineStyle(Integer[] obj) {
        int[] shape = new int[obj.length];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = obj[i];
        }
        this.setLineStyle(shape);
    }

    public final Integer[] getLineStyleInt() {
        int[] style = this.getLineStyle();
        Integer[] styleInt = new Integer[style.length];
        for (int i = 0; i < style.length; ++i) {
            styleInt[i] = style[i];
        }
        return styleInt;
    }

    public final int[] getLineStyle2() {
        return this.getDataShape(this.mData2, false, true);
    }

    public final void setLineStyle2(Integer[] obj) {
        int[] shape = new int[obj.length];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = obj[i];
        }
        this.setLineStyle2(shape);
    }

    public final void setLineStyle2(int[] shape) {
        this.setDataShape(shape, this.mData2, false, true);
    }

    public final Integer[] getLineStyleInt2() {
        int[] style = this.getLineStyle2();
        Integer[] styleInt = new Integer[style.length];
        for (int i = 0; i < style.length; ++i) {
            styleInt[i] = style[i];
        }
        return styleInt;
    }

    public final int getDataColumnNo() {
        return this.nCol;
    }

    public final int getDataRowSize() {
        return this.nRow;
    }

    public final boolean is2DimChart() {
        return this.is2DChart;
    }

    public final boolean isHiLow() {
        return Chart.isHiLowChart(this.chartType);
    }

    public final boolean isSecOverlayAvailable() {
        if (!this.is2DimChart()) {
            return false;
        }
        return this.chartType == 0 || this.chartType == 4 || this.chartType == 8 || this.chartType == 9 || this.chartType == 10 || this.chartType == 11;
    }

    private boolean isValueCol(int col) throws IllegalArgumentException {
        if (col < 0 || col >= this.nCol) {
            throw new IllegalArgumentException("Invalid input, must be < " + this.nCol);
        }
        return DataType.isNumeric(this.colData[col].getDataType()) || DataType.isDateTime(this.colData[col].getDataType());
    }

    private boolean isStringCol(int col) throws IllegalArgumentException {
        if (col < 0 || col >= this.nCol) {
            throw new IllegalArgumentException("Invalid input, must be < " + this.nCol);
        }
        return !DataType.isNumeric(this.colData[col].getDataType()) || DataType.isInt(this.colData[col].getDataType()) || this.colData[col].getDataType() == 5;
    }

    public final boolean showLegend2() {
        return this.subvalueCol >= 0 && this.mData2 != null;
    }

    private boolean drawSecAxisForNormalDistribution() {
        if (Chart.isCircularChart(this.chartType) || this.chartType == 16 || this.chartType == 17) {
            return false;
        }
        if (this.dataDim != 1 || this.subvalueCol >= 0) {
            return false;
        }
        int categoryType = this.getCategoryType();
        if (categoryType == 12 || categoryType == -1 || categoryType == 1) {
            return false;
        }
        int size = this.dataLineSet.getSize();
        for (int i = 0; i < size; ++i) {
            if (this.dataLineSet.elementAt(i).getLineType() != 17) continue;
            return true;
        }
        return false;
    }

    public final boolean showSecAxis() {
        return this.showLegend2() || this.drawSecAxisForOverlay() || this.drawSecAxisForNormalDistribution();
    }

    protected final int getCoorddec(int i) {
        IFormat format = this.colData[i].dataFormat;
        if (format instanceof NumericFormat) {
            return ((NumericFormat)format).decimal;
        }
        if (format instanceof LocaleNumericFormat) {
            return ((LocaleNumericFormat)format).getNumberFormat().getMaximumFractionDigits();
        }
        return 0;
    }

    public final int getVdec() {
        return this.getCoorddec(this.valueCol);
    }

    protected final int getSubVdec() {
        return this.getCoorddec(this.subvalueCol);
    }

    public final double getUserOriginX() {
        return this.a_x.getAxisShift();
    }

    public final void setUserOriginX(double x) {
        this.a_x.setAxisShift(x);
    }

    public final double getUserOriginY() {
        return this.a_y.getAxisShift();
    }

    public final void setUserOriginY(double y) {
        this.a_y.setAxisShift(y);
    }

    public final boolean isTimeChart() {
        return this.isTSChart;
    }

    public final void setTimeChart(boolean t) {
        if (this.isTSChart != t) {
            this.colDataHasChangedBecauseOfAggrHistZoom = true;
        }
        this.isTSChart = t;
    }

    public final boolean isHistogram() {
        return this.histogram;
    }

    public final void setHistogram(boolean t) {
        if (this.histogram != t) {
            this.colDataHasChangedBecauseOfAggrHistZoom = true;
        }
        this.histogram = t;
    }

    public final boolean isAggregationChart() {
        return this.isAggregationChart;
    }

    public final void setAggregationChart(boolean t) {
        if (this.isAggregationChart != t) {
            this.colDataHasChangedBecauseOfAggrHistZoom = true;
        }
        this.isAggregationChart = t;
    }

    public final PreprocInfo getPreprocInfo() {
        return this.tsInfo;
    }

    public final void setPreprocInfo(PreprocInfo timeSeriesInfo) {
        this.tsInfo = timeSeriesInfo;
    }

    public boolean checkPreprocInfo() {
        int categoryType = this.getCategoryType();
        int seriesIndex = -1;
        int categoryIndex = -1;
        int sumByIndex = -1;
        int primaryIndex = -1;
        int secondaryIndex = -1;
        int i = 0;
        if (this.tsInfo == null) {
            this.setTimeChart(false);
            return false;
        }
        if (categoryType != 91 && categoryType != 92 && categoryType != 93) {
            this.setTimeChart(false);
        }
        if (this.isTSChart) {
            this.tsInfo.bRounded = true;
        }
        if (!this.processedChart) {
            LOGGER.finest("In PreprocInfo, setting category index to: " + this.getCategoryIndex());
            categoryIndex = this.originalMap[i] = this.getCategoryIndex();
            if (categoryIndex >= 0) {
                ++categoryIndex;
            }
            ++i;
            if (this.getSeriesIndex() >= 0) {
                seriesIndex = this.originalMap[i] = this.getSeriesIndex();
                ++seriesIndex;
                ++i;
            }
            if (this.getSumByIndex() >= 0) {
                sumByIndex = this.originalMap[i] = this.getSumByIndex();
                ++sumByIndex;
                ++i;
            }
            if (!this.histogram) {
                if (this.getPrimaryIndex() >= 0) {
                    primaryIndex = this.originalMap[i] = this.getPrimaryIndex();
                    ++primaryIndex;
                    ++i;
                }
                if (this.getSecondaryIndex() >= 0) {
                    secondaryIndex = this.originalMap[i] = this.getSecondaryIndex();
                    ++secondaryIndex;
                    ++i;
                }
                this.originalHiLowMap.copy(this.hilowCol);
            } else {
                this.originalMap[i] = this.getPrimaryIndex();
                primaryIndex = this.getCategoryIndex();
                ++primaryIndex;
                ++i;
            }
        } else {
            if (this.getSeriesIndex() >= 0) {
                seriesIndex = this.originalMap[this.getSeriesIndex()] + 1;
            }
            if (this.getCategoryIndex() >= 0) {
                categoryIndex = this.originalMap[this.getCategoryIndex()] + 1;
            }
            if (this.getSumByIndex() >= 0) {
                sumByIndex = this.originalMap[this.getSumByIndex()] + 1;
            }
            LOGGER.finest("Primary index is: " + this.getPrimaryIndex());
            LOGGER.finest("original map for this is: " + this.originalMap[this.getPrimaryIndex()]);
            if (!this.histogram) {
                if (this.getPrimaryIndex() >= 0) {
                    primaryIndex = this.originalMap[this.getPrimaryIndex()] + 1;
                }
                if (this.getSecondaryIndex() >= 0) {
                    secondaryIndex = this.originalMap[this.getSecondaryIndex()] + 1;
                }
            } else {
                primaryIndex = categoryIndex;
            }
        }
        if (!this.histogram) {
            this.tsInfo.aggrColIndex[0] = primaryIndex;
            this.tsInfo.aggrColIndex[1] = secondaryIndex;
            if (!this.isTSChart) {
                this.tsInfo.aggrOp[0] = this.primaryAggregate;
                this.tsInfo.aggrOp[1] = this.secondaryAggregate;
            }
        } else {
            this.tsInfo.aggrColIndex[0] = categoryIndex;
            this.tsInfo.aggrOp[0] = 0;
        }
        this.tsInfo.selectColIndex = categoryIndex;
        this.tsInfo.groupColIndex[0] = seriesIndex;
        this.tsInfo.groupColIndex[1] = sumByIndex;
        this.tsInfo.selectColType = this.getCategoryType();
        if (this.tsInfo.unit == -1 && !this.histogram) {
            this.tsInfo.unit = this.tsInfo.uUnit;
            this.tsInfo.intervalNum = this.tsInfo.uInterval;
        }
        return this.isTimeChart();
    }

    public void clearPreprocInfo() {
        this.tsInfo.isLinear = false;
        this.tsInfo.bRounded = false;
        this.tsInfo.lBound = null;
        this.tsInfo.uBound = null;
        this.tsInfo.unit = -1;
        this.tsInfo.aggrColIndex = new int[]{-1, -1, -1, -1, -1};
        this.tsInfo.aggrOp = new int[]{-1, -1, -1, -1, -1};
        this.tsInfo.intervalNum = 0;
    }

    public final void updateHyperLink(HyperLink hlink) {
        HyperLink lk = null;
        if (!hlink.link.trim().equals("") && (lk = this.findLink(hlink)) == null) {
            this.hyperlinkList.addElement(hlink);
        } else if (lk != null) {
            lk.link = hlink.link;
            lk.target = hlink.target;
            lk.hint = hlink.hint;
        }
    }

    public final void removeHyperLink(HyperLink hlink) {
        this.hyperlinkList.removeElement(hlink);
    }

    public final Vector<HyperLink> getHyperLinkList() {
        return this.hyperlinkList;
    }

    public final void setHyperLinkList(Vector<HyperLink> vec) {
        this.hyperlinkList = vec;
    }

    public final HyperLink findLink(HyperLink hlink) {
        for (int i = 0; i < this.hyperlinkList.size(); ++i) {
            HyperLink lk = this.hyperlinkList.elementAt(i);
            if (!lk.equals(hlink)) continue;
            return lk;
        }
        return null;
    }

    public Vector<FaceHyperLink> getSurfaceHyperLinkList() {
        return this.surfaceHyperLinkList;
    }

    public void setSurfaceHyperLinkList(Vector<FaceHyperLink> newLink) {
        this.surfaceHyperLinkList = newLink;
    }

    public Object addNewSurfaceLink(String link, String target, String hint, String xValue, String zValue) {
        return this.setSurfaceLink(null, link, target, hint, xValue, zValue, -1, -1);
    }

    public Object setSurfaceLink(Object faceHyperLink, String link, String target, String hint, String xValue, String zValue, int xIndex, int zIndex) {
        return faceHyperLink;
    }

    public void removeSurfaceLink(Object faceHyperLink) {
    }

    public void removeAllSurfaceLink() {
    }

    public Object findSurfaceLink(HyperLink link) {
        return null;
    }

    public HyperLink closestMatch(HyperLink link) {
        return null;
    }

    public void writeSurfaceHyperLinkList(DataOutput out) throws IOException {
    }

    public String[] getSurfaceHyperLinkInString(int index) {
        return null;
    }

    public void readSurfaceHyperLinkList(DataInput in, boolean isUTF) throws IOException {
        int linkCount = in.readInt();
        for (int i = 0; i < linkCount; ++i) {
            String xValue = IOUtil.readString(in, isUTF);
            String zValue = IOUtil.readString(in, isUTF);
            String link = IOUtil.readString(in, isUTF);
            String target = IOUtil.readString(in, isUTF);
            String string = IOUtil.readString(in, isUTF);
        }
    }

    public void addLine(PolyLine line) {
        this.lineList.addElement(line);
    }

    public void addLine(Vector<Vertex> line) {
        PolyLine pLine = new PolyLine();
        pLine.set(line.elements(), Color.black);
        this.lineList.addElement(pLine);
    }

    public void addText(ITextString s) {
        if (s instanceof PropCString) {
            this.stringList.addElement(s);
        } else {
            this.stringList.addElement(new PropCString(s));
        }
    }

    public void removeText(ITextString s) {
        this.stringList.removeElement(s);
    }

    public Vector<ITextString> getTextList() {
        return this.stringList;
    }

    public void removeAllLine() {
        this.lineList.removeAllElements();
    }

    public Vector<PolyLine> getLineList() {
        return this.lineList;
    }

    public void setPolyLines(Vector<PolyLine> lines) {
        this.removeAllLine();
        this.lineList = lines;
    }

    public void removeLine(PolyLine line) {
        int index = -1;
        for (int i = 0; i < this.lineList.size(); ++i) {
            if (!this.lineList.elementAt(i).equals(line)) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.lineList.removeElementAt(index);
        }
    }

    public void setDefaultMinMaxValue(boolean first) {
        double maxv = -1.7976931348623157E308;
        double minv = Double.MAX_VALUE;
        int size = this.dataLineSet.getSize();
        if (!Chart.isCircularChart(this.chartType) && size != 0) {
            for (int i = 0; i < size; ++i) {
                DataLine dl = this.dataLineSet.elementAt(i);
                if (!dl.isVisible() || dl.isSecondaryValueUsed() == first) continue;
                if (dl instanceof TrendLine) {
                    int lineType = dl.getLineType();
                    if ((lineType != 7 || DataLine.isBarChartType(this)) && (lineType != 8 || !DataLine.isBarChartType(this))) continue;
                    double v = dl.getLineValue();
                    if (v > maxv) {
                        maxv = v;
                    }
                    if (!(v < minv)) continue;
                    minv = v;
                    continue;
                }
                if (!(dl instanceof HorzVertLine) || dl.invalidchart() || (dl.getLineType() != 14 || DataLine.isBarChartType(this)) && (dl.getLineType() != 15 || !DataLine.isBarChartType(this)) || this.chartType == 18 && dl.getActualLineValue() == -1.7976931348623157E308) continue;
                double v = dl.getLineValue();
                if (v > maxv) {
                    maxv = v;
                }
                if (!(v < minv)) continue;
                minv = v;
            }
        }
        if (first) {
            this.maxvalue = maxv;
            this.minvalue = minv;
        } else {
            this.maxvalue2 = maxv;
            this.minvalue2 = minv;
        }
    }

    private void setDefaultMinMaxCoord() {
        double maxv = -1.7976931348623157E308;
        double minv = Double.MAX_VALUE;
        double maxh = -1.7976931348623157E308;
        double minh = Double.MAX_VALUE;
        this.maxCoord.z = -1.7976931348623157E308;
        this.maxCoord.y = -1.7976931348623157E308;
        this.maxCoord.x = -1.7976931348623157E308;
        this.minCoord.z = Double.MAX_VALUE;
        this.minCoord.y = Double.MAX_VALUE;
        this.minCoord.x = Double.MAX_VALUE;
        int size = this.dataLineSet.getSize();
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                double v;
                int lineType;
                DataLine dl = this.dataLineSet.elementAt(i);
                if (dl instanceof TrendLine) {
                    lineType = dl.getLineType();
                    v = dl.getLineValue();
                    if (lineType == 7) {
                        if (v > maxv) {
                            maxv = v;
                        }
                        if (v < minv) {
                            minv = v;
                        }
                    } else if (lineType == 8) {
                        if (v > maxh) {
                            maxh = v;
                        }
                        if (v < minh) {
                            minh = v;
                        }
                    }
                }
                if (!(dl instanceof HorzVertLine) || dl.invalidchart()) continue;
                lineType = dl.getLineType();
                v = dl.getLineValue();
                if (lineType == 14) {
                    if (v > maxv) {
                        maxv = v;
                    }
                    if (!(v < minv)) continue;
                    minv = v;
                    continue;
                }
                if (v > maxh) {
                    maxh = v;
                }
                if (!(v < minh)) continue;
                minh = v;
            }
            this.maxCoord.y = maxv;
            this.minCoord.y = minv;
            this.maxCoord.x = maxh;
            this.minCoord.x = minh;
        }
    }

    public abstract boolean inside(int var1, int var2);

    public abstract Object insideSelect(CGraphics var1, int var2, int var3, Object var4, int var5, String[] var6);

    public Object select(CGraphics g, int x, int y) {
        if (!this.isChartVisible()) {
            return null;
        }
        int i = 0;
        String[] stable = new String[]{"X", "Y", "Z", "2nd "};
        Object tempObj = null;
        Object target = this.legend.select(g, x, y);
        if (target != null) {
            this.targetName = target == this.legend.framearea ? "legend border" : (target == this.legend.area ? "legend background" : "legend label");
            return target;
        }
        target = this.legend2.select(g, x, y);
        if (target != null) {
            this.targetName = target == this.legend2.framearea ? "2nd legend border" : (target == this.legend2.area ? "2nd legend background" : "2nd legend label");
            return target;
        }
        if (this.isXZoomed && this.checkZoomStatus() && new Rectangle(this.chartxorigin, this.winHeight - this.chartyorigin, this.chartwidth, 9).contains(x, y)) {
            return "XSCROLLBAR";
        }
        if (this.isYZoomed && this.checkZoomStatus() && new Rectangle(this.chartxorigin - 11, this.winHeight - this.chartyorigin - this.chartheight, 9, this.chartheight).contains(x, y)) {
            return "YSCROLLBAR";
        }
        if (this.mainTitle.bshow && this.mainTitle.select(g, x, y)) {
            this.targetName = "main title";
            return this.mainTitle;
        }
        if (Chart.isCircularChart(this.chartType)) {
            target = ((IPieChart)((Object)this)).getPieChart().selectPieLabel(g, x, y);
            if (target != null) {
                String tmpStr = " = \"" + ((IPieChart)((Object)this)).getPieChart().getSelectedPieLabel(g, x, y) + "\"";
                this.targetName = target == ((IPieChart)((Object)this)).getPieChart().pieLabel ? "name label" + tmpStr : (target == ((IPieChart)((Object)this)).getPieChart().pieValue ? "value label" + tmpStr : (target == ((IPieChart)((Object)this)).getPieChart().piePercent ? "percentage label" + tmpStr : "category label" + tmpStr));
                return target;
            }
        } else if (this.chartType == 17) {
            if (this.axis[1].ticker != null && this.axis[1].ticker.showText && this.axis[1].showTicker && this.axis[1].ticker.selectLabel(g, x, y)) {
                this.targetName = "clock axis label = \"" + this.axis[1].ticker.getSelectedLabel(g, x, y) + "\"";
                return this.axis[1].ticker;
            }
        } else {
            int axisNo = this.showSecAxis() ? 4 : 3;
            for (i = 0; i < axisNo; ++i) {
                if (this.axis[i].ticker != null && this.axis[i].ticker.showText && this.axis[i].showTicker && this.axis[i].ticker.selectLabel(g, x, y) && (i != 2 || !this.is2DChart)) {
                    this.targetName = stable[i] + " axis label = \"" + this.axis[i].ticker.getSelectedLabel(g, x, y) + "\"";
                    return this.axis[i].ticker;
                }
                if (!this.axis[i].title.bshow || !this.axis[i].title.select(g, x, y)) continue;
                this.targetName = stable[i] + " axis title";
                return this.axis[i].title;
            }
        }
        if ((this.chartType == 14 || !this.isSynchronizeRadarAxis() && this.chartType == 16) && this.colDataAxis != null) {
            for (i = 0; i < this.colDataAxis.length; ++i) {
                if (this.colDataAxis[i] == null || this.colDataAxis[i].ticker == null || !this.colDataAxis[i].ticker.showText || !this.colDataAxis[i].showTicker || !this.colDataAxis[i].ticker.selectLabel(g, x, y) || i >= this.colData[this.mDataMap[this.dataDim - 1]].getFieldName().length) continue;
                this.targetName = this.colData[this.mDataMap[this.dataDim - 1]].getFieldName()[i] + " axis label = \"" + this.colDataAxis[i].ticker.getSelectedLabel(g, x, y) + "\"";
                return this.colDataAxis[i].ticker;
            }
        }
        if ((target = this.selectTopLabel(g, x, y)) != null) {
            this.targetName = " value label " + ((CString)target).str;
            target = this.topLabels;
            return target;
        }
        if (this.showLegend2() && (target = this.selectTopLabel2(g, x, y)) != null) {
            this.targetName = " value label " + ((CString)target).str;
            target = this.topLabels2;
            return target;
        }
        PolyLine line = this.selectLineList(x, y);
        if (line != null) {
            this.targetName = "line";
            return line;
        }
        CAnnotation annoObj = CAnnotation.select(g, x, y);
        if (annoObj != null) {
            return annoObj;
        }
        tempObj = this.insideSelect(g, x, y, target, i, stable);
        if (tempObj != null) {
            return tempObj;
        }
        if (this.chartType == 14 && this.colDataAxis != null) {
            for (i = 0; i < this.colDataAxis.length; ++i) {
                if (this.colDataAxis[i] == null || !this.colDataAxis[i].title.bshow || !this.colDataAxis[i].title.select(g, x, y)) continue;
                this.targetName = this.colData[this.mDataMap[0]].getFieldName()[i] + " axis title";
                return this.colDataAxis[i].title;
            }
        }
        if ((target = CString.selectStrings(g, x, y, this.stringList)) != null) {
            this.targetName = "text - " + ((CString)target).getString();
            return target;
        }
        this.targetName = "Desktop Area";
        return this.desktopArea;
    }

    protected DataLine selectDataLine(CGraphics g, int x, int y) {
        int size = this.dataLineSet.getSize();
        for (int i = 0; i < size; ++i) {
            DataLine dl = this.dataLineSet.elementAt(i);
            if (!dl.pick(g, x, y)) continue;
            return dl;
        }
        return null;
    }

    protected abstract PolyLine selectLineList(int var1, int var2);

    public abstract CString selectTopLabel(CGraphics var1, int var2, int var3);

    public abstract CString selectTopLabel2(CGraphics var1, int var2, int var3);

    public IDataLabelInfo getPrimaryDataLabelInfo() {
        return this.primaryDataLabelInfo;
    }

    public void setPrimaryDataLabelInfo(IDataLabelInfo labelInfo) {
        this.primaryDataLabelInfo = labelInfo;
    }

    public IDataLabelInfo getSecondaryDataLabelInfo() {
        return this.secondaryDataLabelInfo;
    }

    public void setSecondaryDataLabelInfo(IDataLabelInfo labelInfo) {
        this.secondaryDataLabelInfo = labelInfo;
    }

    public boolean isPrimaryDataLabelInfoNull() {
        return this.primaryDataLabelInfo == null;
    }

    public boolean isSecondaryDataLabelInfoNull() {
        return this.secondaryDataLabelInfo == null;
    }

    public String getInformation(MultiDimData data) {
        this.pickdata.clear();
        MultiDimData rootdata = data;
        int level = -1;
        while (rootdata.parent != null) {
            rootdata = rootdata.parent;
            ++level;
        }
        String string = this.pickdata.valueName = rootdata == this.mData ? this.colData[this.valueCol].getName() : this.colData[this.subvalueCol].getName();
        if (data.plotData != null && !data.plotData.isEmpty()) {
            if (data.plotData.element instanceof HiLowData) {
                if (this.chartType != 18) {
                    ((HiLowData)data.plotData.element).setpick(this.pickdata, this.colData[this.hilowCol.hi].dataFormat, this.colData, this.hilowCol, false);
                } else {
                    ((HiLowData)data.plotData.element).setpick(this.pickdata, this.colData[this.hilowCol.hi].dataFormat, this.colData, this.hilowCol, true);
                }
            } else {
                int axisIndex = -1;
                int i = -1;
                MultiDimData ddata = data;
                while (ddata.parent != null) {
                    ++i;
                    int pos = 0;
                    MultiDimData tempdata = ddata.parent;
                    for (pos = 0; pos < tempdata.multiData.length; ++pos) {
                        if (tempdata.multiData[pos] != ddata) continue;
                        ColData cdata = this.colData[ddata.chart.mDataMap[level - i]];
                        int[] axisPosition = cdata.getAxisPosition();
                        if (axisPosition == null || axisPosition.length <= pos) break;
                        axisIndex = axisPosition[pos];
                        --axisIndex;
                        break;
                    }
                    ddata = tempdata;
                }
                this.getDefaultFormatValue(data.plotData, axisIndex);
                if (this.chartType == 11 || Chart.isCircularChart(this.chartType)) {
                    this.getFormatPercent(data.plotData);
                }
            }
        }
        String[] cname = new String[3];
        String[] scname = new String[3];
        int pos = 0;
        int i = -1;
        while (data.parent != null) {
            ++i;
            MultiDimData tempdata = data.parent;
            for (pos = 0; pos < tempdata.multiData.length; ++pos) {
                if (tempdata.multiData[pos] != data) continue;
                ColData cdata = this.colData[data.chart.mDataMap[level - i]];
                Object obj = cdata.getFieldName(false)[pos];
                cname[i] = obj.toString();
                scname[i] = Chart.formatLabel(obj, cdata.dataFormat);
                break;
            }
            data = tempdata;
        }
        String rootname = this.colData[data.chart.mDataMap[0]].getName();
        if (Chart.isCircularChart(this.chartType) && data.chart.dataDim == 1) {
            this.pickdata.category = cname[0];
            this.pickdata.s_category = scname[0];
            this.pickdata.categoryName = rootname;
            return this.valueTable.getRunTimeValue(this.pickdata.toString());
        }
        switch (level) {
            case 0: {
                if (this.chartType == 19) break;
                if (Chart.isCoordinateType(this.chartType)) {
                    this.pickdata.series = cname[0];
                    this.pickdata.s_series = scname[0];
                    this.pickdata.seriesName = rootname;
                    break;
                }
                this.pickdata.category = cname[0];
                this.pickdata.s_category = scname[0];
                this.pickdata.categoryName = rootname;
                break;
            }
            case 1: {
                if (this.isStackType()) {
                    this.pickdata.sumBy = cname[0];
                    this.pickdata.category = cname[1];
                    this.pickdata.s_sumBy = scname[0];
                    this.pickdata.s_category = scname[1];
                    this.pickdata.categoryName = rootname;
                    this.pickdata.sumByName = this.colData[data.chart.mDataMap[1]].getName();
                    break;
                }
                if (this.chartType == 19) {
                    this.pickdata.series = cname[1];
                    this.pickdata.s_series = scname[1];
                    this.pickdata.seriesName = rootname;
                    break;
                }
                this.pickdata.series = cname[1];
                this.pickdata.s_series = scname[1];
                this.pickdata.category = cname[0];
                this.pickdata.s_category = scname[0];
                this.pickdata.seriesName = rootname;
                this.pickdata.categoryName = this.colData[data.chart.mDataMap[1]].getName();
                break;
            }
            default: {
                if (level < 0) break;
                this.pickdata.series = cname[2];
                this.pickdata.sumBy = cname[0];
                this.pickdata.category = cname[1];
                this.pickdata.s_series = scname[2];
                this.pickdata.s_sumBy = scname[0];
                this.pickdata.s_category = scname[1];
                this.pickdata.seriesName = rootname;
                this.pickdata.categoryName = this.colData[data.chart.mDataMap[1]].getName();
                this.pickdata.sumByName = this.colData[data.chart.mDataMap[2]].getName();
            }
        }
        if (level < 0 && this.showLine) {
            return "Data line";
        }
        return this.valueTable.getRunTimeValue(this.pickdata.toString());
    }

    public String getFormatPercent(PlotData data) {
        this.pickdata.percent = data.percentage;
        this.pickdata.s_percent = this.colData[this.nCol].dataFormat.format(data.percentage);
        return this.pickdata.s_percent;
    }

    public String getFormatValue(MultiDimData ddata, PlotData data) {
        return this.getFormatValue(ddata, data, -1);
    }

    public String getFormatValue(MultiDimData ddata, PlotData data, int axisIndex) {
        this.getInformation(ddata);
        return this.modifyFormatValue(this.pickdata, this.getDefaultFormatValue(data, axisIndex), ddata.isPrimary());
    }

    private String getDefaultFormatValue(PlotData data, int axisIndex) {
        double v;
        block22: {
            block21: {
                if (data.element instanceof Coordinate) {
                    Coordinate coord = (Coordinate)data.element;
                    double x = coord.x;
                    if (this.a_x.logScale) {
                        x = this.a_x.log(x);
                    }
                    double y = coord.y;
                    if (this.a_y.logScale) {
                        y = this.a_y.log(y);
                    }
                    if (this.chartType == 19 && this.isRadianForPolar()) {
                        x = x * 180.0 / Math.PI % 360.0;
                    }
                    this.pickdata.xvalue = x;
                    this.pickdata.s_xvalue = this.a_x.formating(x);
                    this.pickdata.yvalue = y;
                    this.pickdata.s_yvalue = this.a_y.formating(y);
                    if (this.chartType == 19) {
                        this.pickdata.radian = this.pickdata.s_yvalue;
                        this.pickdata.angle = this.pickdata.s_xvalue;
                        return "(Angle)" + this.pickdata.angle + ", (Radial)" + this.pickdata.radian;
                    }
                    if (this.chartType == 2 && (this.is2DChart || !this.bcoordCol[2])) {
                        return "(" + this.pickdata.s_xvalue + ", " + this.pickdata.s_yvalue + ")";
                    }
                    double z = coord.z;
                    if (this.a_z.logScale) {
                        z = this.a_z.log(z);
                    }
                    this.pickdata.zvalue = z;
                    this.pickdata.s_zvalue = this.a_z.formating(z);
                    return "(" + this.pickdata.s_xvalue + ", " + this.pickdata.s_yvalue + ", " + this.pickdata.s_zvalue + ")";
                }
                if (this.chartType == 15) {
                    this.pickdata.vhigh = data.getValue(1);
                    if (this.a_x.logScale) {
                        this.pickdata.vhigh = this.a_x.log(this.pickdata.vhigh);
                    }
                    this.pickdata.s_vhigh = this.a_x.formating(this.pickdata.vhigh);
                    this.pickdata.vlow = data.getValue(2);
                    if (this.a_x.logScale) {
                        this.pickdata.vlow = this.a_x.log(this.pickdata.vlow);
                    }
                    this.pickdata.s_vlow = this.a_x.formating(this.pickdata.vlow);
                    this.pickdata.vQuart = data.getValue(3);
                    if (this.a_x.logScale) {
                        this.pickdata.vQuart = this.a_x.log(this.pickdata.vQuart);
                    }
                    this.pickdata.s_vQuart = this.a_x.formating(this.pickdata.vQuart);
                    this.pickdata.v2Quart = data.getValue(4);
                    if (this.a_x.logScale) {
                        this.pickdata.v2Quart = this.a_x.log(this.pickdata.v2Quart);
                    }
                    this.pickdata.s_v2Quart = this.a_x.formating(this.pickdata.v2Quart);
                    this.pickdata.v3Quart = data.getValue(5);
                    if (this.a_x.logScale) {
                        this.pickdata.v3Quart = this.a_x.log(this.pickdata.v3Quart);
                    }
                    this.pickdata.s_v3Quart = this.a_x.formating(this.pickdata.v3Quart);
                    this.pickdata.s_value = "(" + this.pickdata.s_vlow + ", " + this.pickdata.s_vQuart + ", " + this.pickdata.s_v2Quart + ", " + this.pickdata.s_v3Quart + ", " + this.pickdata.s_vhigh + ")";
                    return this.pickdata.s_value;
                }
                v = data.getValue();
                if (axisIndex != -1) break block21;
                switch (this.chartType) {
                    case 1: 
                    case 5: {
                        if (this.a_x.logScale) {
                            v = this.a_x.log(v);
                            break;
                        }
                        break block22;
                    }
                    case 6: 
                    case 20: {
                        if (data.isPieOthersSector()) {
                            v = data.getPieOthersSum();
                            break;
                        }
                        break block22;
                    }
                    default: {
                        if (this.a_y.logScale) {
                            v = this.a_y.log(v);
                            break;
                        }
                        break block22;
                    }
                }
                break block22;
            }
            if (this.a_s.logScale) {
                v = this.a_s.log(v);
            }
        }
        this.pickdata.value = v;
        this.pickdata.s_value = data.isPieOthersSector() ? this.getDefaultFormatValue(v, axisIndex) : this.getDefaultFormatValue(data.getValue(), axisIndex);
        return this.pickdata.s_value;
    }

    public final String getFormatValue(MultiDimData ddata, double v) {
        return this.getFormatValue(ddata, v, -1);
    }

    public final String getFormatValue(MultiDimData ddata, double v, int axisIndex) {
        this.getInformation(ddata);
        return this.modifyFormatValue(this.pickdata, this.getDefaultFormatValue(v, axisIndex), ddata.isPrimary());
    }

    private String getDefaultFormatValue(double v, int axisIndex) {
        if (axisIndex == -1) {
            switch (this.chartType) {
                case 1: 
                case 5: 
                case 18: {
                    if (this.a_x.logScale) {
                        v = this.a_x.log(v);
                    }
                    return this.formatHint ? this.a_x.formating(v) : "" + v;
                }
                case 6: 
                case 20: {
                    return this.formatHint ? ((IPieChart)((Object)this)).getPieChart().formatingValue(v) : "" + v;
                }
                case 11: {
                    IFormat format = this.colData[this.valueCol].dataFormat;
                    if (this.a_y.logScale) {
                        v = this.a_y.log(v);
                    }
                    return this.formatHint && format != null ? format.format(v) : v + "";
                }
            }
            if (this.a_y.logScale) {
                v = this.a_y.log(v);
            }
            return this.formatHint ? this.a_y.formating(v) : "" + v;
        }
        if (this.a_s.logScale) {
            v = this.a_s.log(v);
        }
        if (axisIndex != -2) {
            return this.formatHint && this.getAxis(4 + axisIndex) != null ? this.getAxis(4 + axisIndex).formating(v) : "" + v;
        }
        return this.formatHint ? this.a_s.formating(v) : "" + v;
    }

    private String modifyFormatValue(PickData pickData, String defaultTopLabel, boolean firstAxis) {
        if (firstAxis && this.primaryDataLabelInfo != null) {
            return this.primaryDataLabelInfo.getDataLabel(pickData, defaultTopLabel);
        }
        if (!firstAxis && this.secondaryDataLabelInfo != null) {
            return this.secondaryDataLabelInfo.getDataLabel(pickData, defaultTopLabel);
        }
        return defaultTopLabel;
    }

    public final int[] getRecordDataType() {
        int[] dtype = new int[this.colData.length - 1];
        for (int i = 0; i < dtype.length; ++i) {
            dtype[i] = this.colData[i].getOriginalDataType();
        }
        return dtype;
    }

    public Object[] getRecord(int no) {
        if (no >= this.nRow) {
            return null;
        }
        Object[] record = new Object[this.colData.length - 1];
        for (int i = 0; i < record.length; ++i) {
            record[i] = this.colData[i].getDataSet().elementAt(no);
        }
        return record;
    }

    public void addRecord(Object[] record) {
        for (int i = 0; i < record.length; ++i) {
            this.colData[i].add(record[i]);
            this.colData[i].bGenUniqueName = false;
            this.colData[i].clearHashTable();
        }
        if (Chart.isCoordinateType(this.chartType)) {
            this.colData[this.nCol].bGenUniqueName = false;
            this.colData[this.nCol].clearHashTable();
        }
        Integer lastElt = null;
        if (this.colData[this.nCol].getDataSet().size() > 0 && this.nRow != 0) {
            lastElt = (Integer)this.colData[this.nCol].getDataSet().elementAt(this.colData[this.nCol].getDataSet().size() - 1);
        }
        int idx = lastElt != null && this.nRow != 0 ? lastElt : -1;
        ++this.nRow;
        this.colData[this.nCol].add(idx + 1);
        this.remakeTable = true;
    }

    public boolean removeRecord(int no) {
        if (no >= this.nRow || this.nRow == 0) {
            return false;
        }
        for (int i = 0; i <= this.nCol; ++i) {
            this.colData[i].getDataSet().removeElementAt(no);
            this.colData[i].bGenUniqueName = false;
            this.colData[i].clearHashTable();
        }
        --this.nRow;
        this.remakeTable = true;
        return true;
    }

    public void setRecord(Object[] record, int no) throws IllegalArgumentException {
        if (no >= this.colData[0].getSize()) {
            throw new IllegalArgumentException("Record no must be less than " + this.colData[0].getSize());
        }
        try {
            for (int i = 0; i < record.length; ++i) {
                this.colData[i].getDataSet().setElementAt(record[i], no);
                this.colData[i].bGenUniqueName = false;
                this.colData[i].clearHashTable();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to setup ColData", ex);
        }
        this.remakeTable = true;
    }

    public abstract void computeBoundingBox();

    public void setPositionFromOrigin(float centerPos) {
        this.computeBoundingBox();
        float newChartX = centerPos;
        float oldChartX = ((float)this.xboundmin + (float)(this.xboundmax - this.xboundmin) / 2.0f) / (float)this.winWidth;
        this.chart_XProp += newChartX - oldChartX;
    }

    public abstract void createSpace(int var1, int var2, int var3, int var4, float var5);

    public abstract void newSurface();

    protected Point transformCoord(Point_2D p) {
        return new Point((int)(p.getX() * (float)this.winWidth), (int)(p.getY() * (float)this.winHeight));
    }

    public abstract void zoomSpace(float var1);

    public abstract void translateSpace(float var1, float var2, float var3);

    public abstract void scaleSpace(float var1, float var2, float var3);

    public abstract void setLighting();

    public boolean notEnoughData() {
        return this.nRow <= 0;
    }

    public boolean isEmpty() {
        return this.sourceData == 0 && this.nRow <= 1;
    }

    public boolean isCircularChart() {
        return Chart.isCircularChart(this.chartType);
    }

    public boolean isPatternOn() {
        if (this.mData != null && this.mData.isPatternOn()) {
            return true;
        }
        return this.mData2 != null && this.mData2.isPatternOn();
    }

    public boolean isStackType() {
        return Chart.stackType(this.chartType);
    }

    public int getCategoryIndex() {
        int index = this.isStackType() ? (this.dataDim == 2 ? this.mDataMap[0] : this.mDataMap[1]) : (this.dataDim == 1 ? this.mDataMap[0] : this.mDataMap[1]);
        return index;
    }

    public int getSeriesIndex() {
        int index = this.isStackType() ? (this.dataDim == 2 ? -1 : this.mDataMap[0]) : (this.dataDim == 1 ? -1 : this.mDataMap[0]);
        return index;
    }

    public int getSumByIndex() {
        int index = this.isStackType() ? (this.dataDim == 2 ? this.mDataMap[1] : this.mDataMap[2]) : -1;
        return index;
    }

    public int getPrimaryIndex() {
        return this.valueCol;
    }

    public int getSecondaryIndex() {
        return this.subvalueCol;
    }

    public int getCategoryType() {
        int index = this.getCategoryIndex();
        return this.colData[index].getOriginalDataType();
    }

    public String getCategoryName() {
        int index = this.getCategoryIndex();
        return this.colData[index].getName();
    }

    public int getModifiedCategoryType() {
        int index = this.getCategoryIndex();
        return this.colData[index].getDataType();
    }

    public boolean isBackgroundTransparent() {
        return this.isBackgroundTransparent;
    }

    public void setBackgroundTransparent(boolean b) {
        this.isBackgroundTransparent = b;
    }

    public boolean isTransposed() {
        return this.isTransposed;
    }

    public void setTransposed(boolean value, boolean[] transposeCol) {
        this.isTransposed = value;
        this.transposeCol = transposeCol;
    }

    public boolean[] getTransposeColumn() {
        return this.transposeCol;
    }

    public String getXMLChartLocation() {
        return this.xmlChartLocation;
    }

    public void setXMLChartLocation(String str) {
        this.xmlChartLocation = str;
    }

    public void fillAggregators(int primaryAgg, int secondaryAgg) {
        this.primaryAggregate = primaryAgg;
        this.secondaryAggregate = secondaryAgg;
    }

    public boolean fillUsedColumns() {
        int i;
        boolean returnVal = false;
        this.countUnusedCol = 0;
        if (this.usedColumns == null) {
            this.usedColumns = new boolean[this.colData.length - 1];
            for (i = 0; i < this.usedColumns.length; ++i) {
                this.usedColumns[i] = false;
            }
        }
        if (this.drillDownVector != null && this.drillDownVector.size() > 0) {
            for (i = 0; i < this.dataDim; ++i) {
                this.usedColumns[this.originalMap[this.mDataMap[i]]] = true;
            }
        } else {
            for (i = 0; i < this.dataDim; ++i) {
                this.usedColumns[this.mDataMap[i]] = true;
            }
            this.usedColumns[this.valueCol] = true;
            if (this.subvalueCol >= 0) {
                this.usedColumns[this.subvalueCol] = true;
            }
        }
        for (i = 0; i < this.usedColumns.length; ++i) {
            LOGGER.finest("usedColumns[" + i + "] = " + this.usedColumns[i]);
            if (this.usedColumns[i] || this.colData[i] == null) continue;
            int dtype = this.colData[i].dataType;
            if (!DataType.isNumeric(dtype)) {
                ++this.countUnusedCol;
                continue;
            }
            if (!DataType.isInt(dtype) && dtype != 5) continue;
            ++this.countUnusedCol;
        }
        if (this.countUnusedCol > 0) {
            returnVal = true;
        }
        return returnVal;
    }

    public void fillUsedColumns(int[] datamap, int dim) {
        int i;
        if (this.usedColumns == null) {
            this.usedColumns = new boolean[this.colData.length - 1];
            for (i = 0; i < this.usedColumns.length; ++i) {
                this.usedColumns[i] = false;
            }
        }
        for (i = 0; i < dim; ++i) {
            this.usedColumns[datamap[i]] = true;
        }
    }

    public boolean fillUsedColumns2(Vector<ColMetaData> metaDataVector) {
        return this.fillUsedColumns2(metaDataVector, this.drillDownVector.size());
    }

    public boolean fillUsedColumns2(Vector<ColMetaData> metaDataVector, int numOfDrillLevel) {
        int i;
        boolean returnVal = false;
        this.usedColumns = null;
        this.countUnusedCol = 0;
        this.usedColumns = new boolean[metaDataVector.size()];
        for (i = 0; i < this.usedColumns.length; ++i) {
            this.usedColumns[i] = false;
        }
        for (int j = 0; j < numOfDrillLevel; ++j) {
            DrillDownInfo dInfo = this.drillDownVector.elementAt(j);
            for (int i2 = 0; i2 < dInfo.datadim; ++i2) {
                this.usedColumns[dInfo.mDataMap[i2]] = true;
            }
        }
        if (this.drillDownVector != null && this.drillDownVector.size() > 0 || this.isDynamicDrillDown) {
            for (i = 0; i < this.dataDim; ++i) {
                this.usedColumns[this.originalMap[this.mDataMap[i]]] = true;
            }
            this.usedColumns[this.originalMap[this.valueCol]] = true;
            if (this.subvalueCol >= 0) {
                this.usedColumns[this.originalMap[this.subvalueCol]] = true;
            }
        } else {
            for (i = 0; i < this.dataDim; ++i) {
                this.usedColumns[this.mDataMap[i]] = true;
            }
            this.usedColumns[this.valueCol] = true;
            if (this.subvalueCol >= 0) {
                this.usedColumns[this.subvalueCol] = true;
            }
        }
        for (i = 0; i < this.usedColumns.length; ++i) {
            ColMetaData cData;
            LOGGER.finest("usedColumns[" + i + "] = " + this.usedColumns[i]);
            if (this.usedColumns[i] || (cData = metaDataVector.elementAt(i)) == null) continue;
            int dtype = DataType.mapType(cData.sqlType);
            if (!DataType.isNumeric(dtype)) {
                ++this.countUnusedCol;
                continue;
            }
            if (!DataType.isInt(dtype) && dtype != 5) continue;
            ++this.countUnusedCol;
        }
        if (this.countUnusedCol > 0) {
            returnVal = true;
        }
        return returnVal;
    }

    public boolean isChartInReport() {
        return this.isChartInReport;
    }

    public void setChartInReport(boolean isChartInReport) {
        this.isChartInReport = isChartInReport;
    }

    public int[] getReportDrillDownMapping() {
        return this.rptMapping;
    }

    public void setReportDrillDownMapping(int[] mapping) {
        this.rptMapping = mapping;
    }

    public String getReportDrillDownLinkPrefix() {
        return this.rptDrillLinkPrefix;
    }

    public void setReportDrillDownLinkPrefix(String linkPrefix) {
        this.rptDrillLinkPrefix = linkPrefix;
    }

    public void reAssignDrillDownMap(int numOfDrillLevel) {
        for (int j = 0; j < numOfDrillLevel; ++j) {
            DrillDownInfo dInfo = this.drillDownVector.elementAt(j);
            if (dInfo.datadim == dInfo.mDataMap.length) continue;
            int[] map2 = new int[dInfo.datadim];
            for (int i = 0; i < dInfo.datadim; ++i) {
                map2[i] = dInfo.mDataMap[i];
            }
            dInfo.mDataMap = map2;
        }
    }

    public void setDrillDownPath(String path) {
        if (!(path = path.replace('\\', '/')).endsWith("/")) {
            path = path + "/";
        }
        this.drillTemplatePath = new String(path);
        if (this.currentNode != null) {
            for (int i = 0; i < this.currentNode.getChildCount(); ++i) {
                this.setDrillDownPathHelper(this.currentNode.getChildAt(i), path);
            }
        }
    }

    private void setDrillDownPathHelper(DrillDownNode node, String path) {
        if (node == null || path == null) {
            return;
        }
        String loc = node.getFileName();
        if (loc != null && !loc.trim().equals("")) {
            loc = loc.replace('\\', '/');
            if (!(path = path.replace('\\', '/')).endsWith("/")) {
                path = path + "/";
            }
            String fileName = quadbase.util.internal.QbUtil.getFileName(loc);
            node.setFileName(path + fileName);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.setDrillDownPathHelper(node.getChildAt(i), path);
        }
    }

    public boolean isFieldDrillDownEnabled() {
        return this.currentNode != null && this.currentNode.getChildCount() > 0;
    }

    public boolean isFieldDrillDownChart() {
        return this.isFieldDrillDownEnabled() || this.isSubFieldDrillDownChart;
    }

    public String getServletDirectory() {
        return this.servletDirectory;
    }

    public void setServletDirectory(String path) {
        this.servletDirectory = path;
    }

    public void addDrillDown(int cType, int[] dataMap, int dim, boolean isdrill2D) {
        if (this.drillDownVector == null) {
            this.drillDownVector = new Vector(10);
        }
        DrillDownInfo dInfo = new DrillDownInfo(cType, dataMap, dim, isdrill2D);
        this.drillDownVector.addElement(dInfo);
    }

    public void insertDrillDownAt(int number, int cType, int[] dataMap, int dim, boolean isdrill2D) {
        if (this.drillDownVector == null) {
            this.drillDownVector = new Vector(10);
        }
        DrillDownInfo dInfo = new DrillDownInfo(cType, dataMap, dim, isdrill2D);
        if (this.drillDownVector.size() == 0 || number >= this.drillDownVector.size()) {
            this.drillDownVector.addElement(dInfo);
        } else {
            this.drillDownVector.insertElementAt(dInfo, number);
        }
    }

    public void modifyDrillDown(int number, int cType, int[] dataMap, int dim, boolean isdrill2D) {
        if (this.drillDownVector == null || this.drillDownVector.size() == 0 || number >= this.drillDownVector.size()) {
            this.addDrillDown(cType, dataMap, dim, isdrill2D);
            return;
        }
        DrillDownInfo dInfo = this.drillDownVector.elementAt(number);
        if (dInfo == null) {
            this.addDrillDown(cType, dataMap, dim, isdrill2D);
        } else {
            dInfo.chartType = cType;
            dInfo.datadim = dim;
            dInfo.mDataMap = dataMap;
            dInfo.isDrill2D = isdrill2D;
            this.drillDownVector.setElementAt(dInfo, number);
        }
    }

    public int getDrillNumber() {
        return this.drillNumber;
    }

    public void incrementDrillNumber() {
        ++this.drillNumber;
    }

    public void decrementDrillNumber() {
        if (this.drillNumber > 0) {
            --this.drillNumber;
        }
    }

    public void resetDrillNumber() {
        this.drillNumber = 0;
    }

    public void removeDrillDown(int number) {
        if (this.drillDownVector == null || this.drillDownVector.size() <= number) {
            return;
        }
        DrillDownInfo dInfo = this.drillDownVector.elementAt(number);
        this.freeUsedColumns(dInfo.mDataMap, dInfo.datadim);
        this.drillDownVector.removeElementAt(number);
    }

    public boolean isDrillDownDefined() {
        if (this.drillDownVector == null) {
            return false;
        }
        return this.drillNumber < this.drillDownVector.size();
    }

    public int[] getDrillDownMap() {
        if (!this.isDrillDownDefined()) {
            return null;
        }
        return this.drillDownVector.elementAt((int)this.drillNumber).mDataMap;
    }

    public int getDrillDownDimension() {
        if (!this.isDrillDownDefined()) {
            return -1;
        }
        return this.drillDownVector.elementAt((int)this.drillNumber).datadim;
    }

    public int getDrillDownType() {
        if (!this.isDrillDownDefined()) {
            return -1;
        }
        return this.drillDownVector.elementAt((int)this.drillNumber).chartType;
    }

    public boolean isDrillDown2D() {
        return this.drillDownVector.elementAt((int)this.drillNumber).isDrill2D;
    }

    private void freeUsedColumns(int[] datamap, int dim) {
        if (this.usedColumns == null || datamap == null) {
            return;
        }
        for (int i = 0; i < dim; ++i) {
            this.usedColumns[datamap[i]] = false;
        }
    }

    public QueryFileInfo getQueryFileInfo() {
        if (this.queryFileInfo != null) {
            return this.queryFileInfo;
        }
        if (this.dbInfo instanceof QueryFileInfo) {
            this.setQueryFileInfo((QueryFileInfo)this.dbInfo);
            return (QueryFileInfo)this.dbInfo;
        }
        if (this.dbInfo instanceof QueryXMLFileInfo) {
            this.setQueryFileInfo((QueryXMLFileInfo)this.dbInfo);
            return (QueryFileInfo)this.dbInfo;
        }
        return null;
    }

    public void setQueryFileInfo(QueryFileInfo queryFileInfo) {
        this.queryFileInfo = queryFileInfo;
        this.valueTable.setQueryFileInfo(queryFileInfo);
    }

    public void validatePosition() {
        this.calculatePosition(null, this.component, this.winWidth, this.winHeight);
    }

    public boolean isComputed() {
        return this.isComputed;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public Vector<IAnnotation> getAnnotations() {
        return this.annotationSet.getAnnotationList();
    }

    @Override
    public void addAnnotation(IAnnotation annoObj) {
        this.annotationSet.addAnnotation(annoObj);
    }

    @Override
    public boolean removeAnnotation(IAnnotation annoObj) {
        return this.annotationSet.removeAnnotation(annoObj);
    }

    @Override
    public Position getReferencePosition() {
        float x = (float)this.chartxorigin / (float)this.winWidth;
        if (x < 0.0f) {
            x = 0.0f;
        } else if (x > 1.0f) {
            x = 1.0f;
        }
        int yorigin = this.is2DChart ? this.chartyorigin : this.winHeight - this.chartyorigin - this.chartheight;
        float y = (float)yorigin / (float)this.winHeight;
        if (y < 0.0f) {
            y = 0.0f;
        } else if (y > 1.0f) {
            y = 1.0f;
        }
        return new Position(x, y);
    }

    public void reCalculateAnnotationTextPosition(double oldChartWidth, double newChartWidth, double oldChartHeight, double newChartHeight) {
        Vector<IAnnotation> vec = this.annotationSet.getAnnotationList();
        if (vec != null) {
            int size = vec.size();
            for (int i = 0; i < size; ++i) {
                CAnnotation tmp = (CAnnotation)vec.elementAt(i);
                IReferenceObj refObj = tmp.getReferenceObject();
                if (refObj == null || !(refObj instanceof Chart)) continue;
                tmp.relativePos.x = (float)(newChartWidth / oldChartWidth) * tmp.relativePos.x;
            }
        }
        if (this.dataLineSet != null) {
            Vector<DataLine> lineList = this.dataLineSet.getDataLineList();
            if (lineList == null) {
                return;
            }
            lineList.trimToSize();
            for (int m = 0; m < lineList.size(); ++m) {
                int lineType;
                Vector<IAnnotation> lineAnnoList = lineList.elementAt(m).getAnnotations();
                if (lineAnnoList == null || (lineType = lineList.elementAt(m).getLineType()) != 15 && (!DataLine.isBarChartType(this) || !(lineList.elementAt(m) instanceof ControlLine))) continue;
                lineAnnoList.trimToSize();
                for (int n = 0; n < lineAnnoList.size(); ++n) {
                    CAnnotation tmp = (CAnnotation)lineAnnoList.elementAt(n);
                    tmp.relativePos.y = (float)(newChartHeight / oldChartHeight) * tmp.relativePos.y;
                }
            }
        }
    }

    public boolean isCatZoom() {
        if (this.chartType == 2) {
            return false;
        }
        boolean isVertChart = this.isVertical();
        if (!isVertChart && this.isYZoomed) {
            return true;
        }
        return isVertChart && this.isXZoomed;
    }

    public boolean isValueZoom() {
        if (this.isXValueZoom() || this.isYValueZoom()) {
            return true;
        }
        boolean isVertChart = this.isVertical();
        if (!isVertChart && this.isXZoomed) {
            return true;
        }
        return isVertChart && this.isYZoomed;
    }

    public boolean isXValueZoom() {
        if (this.chartType != 2) {
            return false;
        }
        return this.isXZoomed;
    }

    public boolean isYValueZoom() {
        if (this.chartType != 2) {
            return false;
        }
        return this.isYZoomed;
    }

    public void setXZoom(float startx, float ratio, boolean isZoomIn) {
        this.isVerticalChart = this.isVertical();
        if (isZoomIn) {
            this.isXZoomed = true;
            float[] xVal = new float[]{this.xmin, this.xratio};
            this.xZoomList.addElement(xVal);
            this.xmin += startx * this.xratio;
            this.xratio = ratio * this.xratio;
            this.xmin = this.limit(this.xmin, 0.005f, 1.0f - this.xratio);
            this.xratio = this.limit(this.xratio, 0.1f, 1.0f - this.xmin);
            if (!this.isVerticalChart || this.chartType == 2) {
                this.setValueZoom(xVal[0], xVal[1], this.xmin, this.xratio, true, false, 0);
            }
        } else if (ratio != 1.0f && this.xZoomList.size() > 0) {
            float[] xVal = this.xZoomList.lastElement();
            this.xmin = xVal[0];
            this.xratio = xVal[1];
            if (!this.isVerticalChart || this.chartType == 2) {
                this.setValueZoom(this.xmin, this.xratio, this.xmin, this.xratio, false, false, 0);
            }
            this.xZoomList.removeElement(xVal);
        } else {
            this.isXZoomed = false;
            this.xmin = 0.0f;
            this.xratio = 1.0f;
            if (!this.isVerticalChart || this.chartType == 2) {
                this.setValueZoom(this.xmin, this.xratio, this.xmin, this.xratio, false, true, 0);
            }
        }
    }

    public void setYZoom(float starty, float ratio, boolean isZoomIn) {
        this.isVerticalChart = this.isVertical();
        if (isZoomIn) {
            this.isYZoomed = true;
            float[] yVal = new float[]{this.ymin, this.yratio};
            this.yZoomList.addElement(yVal);
            this.ymin += starty * this.yratio;
            this.yratio = ratio * this.yratio;
            this.ymin = this.limit(this.ymin, 0.0f, 1.0f - this.yratio);
            this.yratio = this.limit(this.yratio, 0.1f, 1.0f - this.ymin);
            if (this.isVerticalChart || this.chartType == 2) {
                this.setValueZoom(yVal[0], yVal[1], this.ymin, this.yratio, true, false, 1);
            }
        } else if (ratio != 1.0f && this.yZoomList.size() > 0) {
            float[] yVal = this.yZoomList.lastElement();
            this.ymin = yVal[0];
            this.yratio = yVal[1];
            if (this.isVerticalChart || this.chartType == 2) {
                this.setValueZoom(this.ymin, this.yratio, this.ymin, this.yratio, false, false, 1);
            }
            this.yZoomList.removeElement(yVal);
        } else {
            this.isYZoomed = false;
            this.ymin = 0.0f;
            this.yratio = 1.0f;
            if (this.isVerticalChart || this.chartType == 2) {
                this.setValueZoom(this.ymin, this.yratio, this.ymin, this.yratio, false, true, 1);
            }
        }
    }

    private void setValueZoom(float lastMin, float lastRatio, float currMin, float currRatio, boolean isZoomIn, boolean isZoomHome, int axisId) {
        int i = 0;
        if (axisId > -1) {
            i = axisId;
        } else if (this.isVertical()) {
            i = 1;
        }
        boolean isInt = false;
        if (this.chartType == 2) {
            if (axisId == 0) {
                isInt = DataType.isInt(this.colData[this.coordCol[0]].getDataType());
            } else if (axisId == 1) {
                isInt = DataType.isInt(this.colData[this.coordCol[1]].getDataType());
            }
        } else {
            isInt = DataType.isInt(this.colData[this.valueCol].getDataType());
        }
        this.vAxisScale[0] = (float)this.axis[i].getMinScale();
        this.vAxisScale[1] = (float)this.axis[i].getMaxScale();
        this.vAxisScale[2] = (float)this.axis[i].getScaleStep();
        if (isZoomIn) {
            if (lastMin == 0.0f && lastRatio == 1.0f) {
                this.firstvminFlt = this.vAxisScale[0];
                this.firstvmaxFlt = this.vAxisScale[1];
                this.firstvstepFlt = this.vAxisScale[2];
            }
            this.lastvminFlt = this.vAxisScale[0];
            this.lastvmaxFlt = this.vAxisScale[1];
            this.lastvstepFlt = this.vAxisScale[2];
            if (isInt) {
                this.vAxisScale[0] = (float)Math.floor(this.firstvminFlt + currMin * (this.firstvmaxFlt - this.firstvminFlt));
                this.vAxisScale[2] = Math.round(this.firstvstepFlt * currRatio);
                if (this.vAxisScale[2] == 0.0f) {
                    this.vAxisScale[2] = 1.0f;
                }
                this.vAxisScale[1] = (float)Math.ceil(this.firstvminFlt + (currMin + currRatio) * (this.firstvmaxFlt - this.firstvminFlt));
                int tmp = (int)this.vAxisScale[0];
                while ((float)tmp < this.vAxisScale[1]) {
                    tmp += (int)this.vAxisScale[2];
                }
                this.vAxisScale[1] = tmp;
            } else {
                this.vAxisScale[0] = this.firstvminFlt + currMin * (this.firstvmaxFlt - this.firstvminFlt);
                this.vAxisScale[1] = this.firstvminFlt + (currMin + currRatio) * (this.firstvmaxFlt - this.firstvminFlt);
                this.vAxisScale[2] = this.firstvstepFlt * currRatio;
            }
        } else if (isZoomHome) {
            if (this.firstvminFlt != this.firstvmaxFlt) {
                this.vAxisScale[0] = this.firstvminFlt;
                this.vAxisScale[1] = this.firstvmaxFlt;
                this.vAxisScale[2] = this.firstvstepFlt;
            }
        } else if (this.lastvminFlt != this.lastvmaxFlt) {
            this.vAxisScale[0] = this.lastvminFlt;
            this.vAxisScale[1] = this.lastvmaxFlt;
            this.vAxisScale[2] = this.lastvstepFlt;
        }
        this.setAxisAutoOrigin(i, false);
        this.axis[i].setAxisShift(this.vAxisScale[0]);
        this.setAxisScale(i, this.vAxisScale[0], this.vAxisScale[1], this.vAxisScale[2]);
    }

    public boolean checkZoomStatus() {
        return this.is2DimChart() && this.chartType != 16 && this.chartType != 6 && this.chartType != 20 && this.chartType != 17 && this.chartType != 8 && this.chartType != 18 && this.chartType != 13 && this.chartType != 19;
    }

    private float limit(float x, float min, float max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public int calculateZoomedX(int oldX) {
        int tmpInt = -1;
        float tmpFlt = (float)(oldX - this.chartxorigin) / (float)this.chartwidth;
        tmpFlt = (tmpFlt - this.xmin) / this.xratio;
        tmpInt = this.chartxorigin + (int)(tmpFlt * (float)this.chartwidth);
        return tmpInt;
    }

    public int calculateZoomedY(int oldY) {
        int tmpInt = -1;
        float tmpFlt = (float)(oldY - this.chartyorigin) / (float)this.chartheight;
        tmpFlt = (tmpFlt - this.ymin) / this.yratio;
        tmpInt = this.chartyorigin + (int)(tmpFlt * (float)this.chartheight);
        return tmpInt;
    }

    public ChartParameterPage getParameterPage(String chartLoc, int format, String servletName) {
        if (this.dbInfo == null || !(this.dbInfo instanceof IQueryFileInfo)) {
            return null;
        }
        quadbase.common.util.IQueryInParam[] queryParamSet = null;
        queryParamSet = quadbase.util.internal.QbUtil.getInParam(this.dbInfo);
        ChartParameterPage paramPage = new ChartParameterPage(queryParamSet, (IQueryFileInfo)((Object)this.dbInfo), servletName, this.paramPageChartDisplayTypes, chartLoc, format, this.paramPageResetEnabled, this.paramPageLayout, this.extraFormContent);
        return paramPage;
    }

    public Hashtable<String, String> getFontMapping() {
        return this.fontMapping;
    }

    public void setFontMapping(Hashtable<String, String> mapping) {
        this.fontMapping = mapping;
    }

    public boolean hasHighlightOverlapControlArea() {
        Vector<ControlRange> controlArea = this.getControlRangeList();
        for (ControlRange controlRange : controlArea) {
            ControlRange cr = controlRange;
            if (!cr.isOverlapAreaHighlighted()) continue;
            return true;
        }
        return false;
    }

    public String getHtmlTarget() {
        return this.htmlTarget;
    }

    public void setHtmlTarget(String htmlTarget) {
        this.htmlTarget = htmlTarget;
    }

    public void updateBackground() {
        this.background.setpos(this.chartxorigin, this.chartyorigin, this.chartxorigin + this.chartwidth, this.chartyorigin + this.chartheight);
    }

    public boolean isDataValid() {
        boolean valid = true;
        MultiDimData tmpData = this.mData;
        try {
            block2: for (int k = 0; k < 1; ++k) {
                for (int i = 0; i < this.dataDim; ++i) {
                    if (this.mDataLen[i] == 0) {
                        valid = false;
                        continue block2;
                    }
                    if (this.mDataLen[i] != tmpData.multiData.length) {
                        valid = false;
                        continue block2;
                    }
                    for (int j = 0; j < this.mDataLen[i]; ++j) {
                        if (tmpData.multiData[j] != null) continue;
                        valid = false;
                        break;
                    }
                    tmpData = tmpData.multiData[0];
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "isDataValid check failed", ex);
            valid = false;
        }
        return valid;
    }

    public DataAttribute getUnusedDataAttribute() {
        return this.unusedDataAttribute;
    }

    public void setUnusedDataAttribute(DataAttribute da) {
        this.unusedDataAttribute = da;
    }

    public DataAttribute getUnusedDataAttribute2() {
        return this.unusedDataAttribute2;
    }

    public void setUnusedDataAttribute2(DataAttribute da) {
        this.unusedDataAttribute2 = da;
    }

    public void clearUnusedDataAttributes() {
        this.unusedDataAttribute = null;
        this.unusedDataAttribute2 = null;
    }

    public void reassignDataColors() {
        this.chartColorSet.resetColorIndex();
        if (this.mData != null) {
            if (this.mData.multiData.length > 0 && this.mData.multiData[0].area.automatic && this.mData.multiData[0].multiData == null) {
                this.mData.area.areaColor = this.mData.point.color = this.chartColorSet.getNextColor(this.mData.area.areaColor);
            }
            this.mData.assignColors(this.mData.area, false, this.chartColorSet);
        }
        if (this.mData2 != null) {
            this.setMultiDimDataShape(this.mData2);
            if (this.chartColorSet2 == null) {
                this.chartColorSet2 = new ChartColorSet(true);
            } else {
                this.chartColorSet2.resetColorIndex();
            }
            if (this.mData2.multiData.length > 0 && this.mData2.multiData[0].area.automatic && this.mData2.multiData[0].multiData == null) {
                this.mData2.area.areaColor = this.mData2.point.color = this.chartColorSet2.getNextColor(this.mData2.area.areaColor);
            }
            this.mData2.assignColors(this.mData2.area, false, this.chartColorSet2);
        }
    }

    public boolean isAlertEnabled() {
        return this.isControlRangeEnabled() && this.chartType != 18 && this.chartType != 15 && this.chartType != 13 && this.chartType != 11 && this.chartType != 9 && this.chartType != 10;
    }

    @Override
    public String[] getAllAlertIds() {
        if (!this.isAlertEnabled()) {
            return null;
        }
        Vector<ControlRange> controlRanges = this.getControlRangeList();
        if (controlRanges == null || controlRanges.size() == 0) {
            return null;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Iterator<ControlRange> iterator = controlRanges.iterator();
        while (iterator.hasNext()) {
            ControlRange controlRange;
            ControlRange cr = controlRange = iterator.next();
            result.add(cr.getTitle());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getTriggeredAlertIds() {
        if (!this.isAlertEnabled()) {
            return null;
        }
        if (this.notEnoughData()) {
            return null;
        }
        Vector<ControlRange> controlRanges = this.getControlRangeList();
        if (controlRanges == null || controlRanges.size() == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (ControlRange controlRange : controlRanges) {
            ControlRange cr = controlRange;
            if (result.contains(cr.getTitle()) || this.getAlertDetails(cr, this.mData).size() <= 0) continue;
            result.add(cr.getTitle());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Map<String, Vector<String>> getTriggeredAlertDetails() {
        if (!this.isAlertEnabled()) {
            return null;
        }
        if (this.notEnoughData()) {
            return null;
        }
        Vector<ControlRange> controlRanges = this.getControlRangeList();
        if (controlRanges == null || controlRanges.size() == 0) {
            return null;
        }
        HashMap<String, Vector<String>> result = new HashMap<String, Vector<String>>();
        for (ControlRange controlRange : controlRanges) {
            ControlRange cr = controlRange;
            Vector<String> details = this.getAlertDetails(cr, this.mData);
            if (details.size() <= 0) continue;
            if (result.containsKey(cr.getTitle())) {
                Vector<String> v = result.get(cr.getTitle());
                v.addAll(details);
                continue;
            }
            result.put(cr.getTitle(), details);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    private Vector<String> getAlertDetails(ControlRange cr, MultiDimData data) {
        if (!(cr.isScale1Enabled() || cr.isScale2Enabled() && this.chartType != 17)) {
            return null;
        }
        if (this.chartType == 2) {
            return this.getAlertDetailsScatter(cr, data);
        }
        if (this.isStackType()) {
            return this.getAlertDetailsStack(cr, data);
        }
        return this.getAlertDetailsOthers(cr, data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector<String> getAlertDetailsOthers(ControlRange cr, MultiDimData data) {
        Vector<String> result = new Vector<String>();
        if (data.plotData == null) {
            if (data.multiData == null) throw new IllegalStateException("plotData == null && multiData == null - this should never happen");
            for (MultiDimData element : data.multiData) {
                result.addAll(this.getAlertDetailsOthers(cr, element));
            }
            return result;
        } else {
            double value = data.plotData.getValue();
            if (!this.isInControlRange(cr, value, data.point)) return result;
            result.add(this.getInformation(data));
        }
        return result;
    }

    private Vector<String> getAlertDetailsStack(ControlRange cr, MultiDimData data) {
        Vector<String> result = new Vector<String>();
        if (data.multiData == null || data.multiData.length == 0) {
            throw new IllegalStateException("multiData is null or empty for a stack chart - this should never happen");
        }
        if (data.multiData[0].plotData == null) {
            for (MultiDimData element : data.multiData) {
                result.addAll(this.getAlertDetailsStack(cr, element));
            }
        } else {
            double value = 0.0;
            for (MultiDimData element : data.multiData) {
                value += element.plotData.getValue();
            }
            if (this.isInControlRange(cr, value, data.multiData[data.multiData.length - 1].point)) {
                result.add(this.getInformation(data) + "(" + this.colData[this.valueCol].getName() + ") " + value);
            }
        }
        return result;
    }

    private Vector<String> getAlertDetailsScatter(ControlRange cr, MultiDimData data) {
        Vector<String> result = new Vector<String>();
        if (data.multiData != null) {
            for (MultiDimData element : data.multiData) {
                result.addAll(this.getAlertDetailsScatter(cr, element));
            }
        } else if (!data.plotData.isEmpty()) {
            Coordinate coord = (Coordinate)data.plotData.element;
            if ((!cr.isScale1Enabled() || cr.getStartScale(this) <= coord.y && coord.y < cr.getEndScale(this)) && (!cr.isScale2Enabled() || cr.getStartScale2(this) <= coord.x && coord.x < cr.getEndScale2(this))) {
                result.add(this.getInformation(data));
            }
        }
        return result;
    }

    private boolean isInControlRange(ControlRange cr, double value, Point3D point) {
        if (!cr.isScale1Enabled() || cr.getStartScale(this) <= value && value < cr.getEndScale(this)) {
            if (cr.isScale2Enabled() && this.chartType != 17) {
                int x1 = cr.getX1(this);
                int x2 = cr.getX2(this);
                int y1 = cr.getY1(this);
                int y2 = cr.getY2(this);
                if (x1 == -1 || x2 == -1 || y1 == -1 || y2 == -1) {
                    return false;
                }
                if (cr.isHorizontalRange(this)) {
                    return y1 <= point.y && point.y < y2;
                }
                return x1 <= point.x && point.x < x2;
            }
            return true;
        }
        return false;
    }

    public int[] getDataPtShapes() {
        return this.dataPtShapes;
    }

    public void setDataPtShapes(int[] dataPtShapesFromTpl) {
        this.dataPtShapes = dataPtShapesFromTpl;
    }

    public int[] getDataPtSizes() {
        return this.dataPtSizes;
    }

    public void setDataPtSizes(int[] dataPtSizesFromTpl) {
        this.dataPtSizes = dataPtSizesFromTpl;
    }

    public boolean isDrawConnectLineArrows() {
        return this.drawConnectLineArrows;
    }

    public void setDrawConnectLineArrows(boolean drawConnectLineArrows) {
        this.drawConnectLineArrows = drawConnectLineArrows;
    }

    public boolean isShowPercentage() {
        return this.showPercentage;
    }

    public void setShowPercentage(boolean showPercentage) {
        this.showPercentage = showPercentage;
    }

    public int getBinNumber() {
        return this.binNumber;
    }

    public void setBinNumber(int binNumber) {
        this.binNumber = binNumber;
    }
}

