/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.ColData;
import quadbase.chart.DataFileInput;
import quadbase.chart.EJBAccess;
import quadbase.chart.ExcelAccess;
import quadbase.chart.ReadDataFile;
import quadbase.chart.SOAPAccess;
import quadbase.chart.SalesForceAccess;
import quadbase.chart.message.ReadDBqueryMeta;
import quadbase.chart.message.ReadDataFileMeta;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.XMLFieldInfo;
import quadbase.util.IRSMetaData;
import quadbase.util.IResultSet;
import quadbase.util.StreamResultSet;
import quadbase.util.internal.Coder;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.TransposeRS;

public class ColMetaData {
    private static final Logger LOGGER = Logger.getLogger(ColMetaData.class.getName());
    String columnName;
    int sqlType;

    public ColMetaData(String columnName, int sqlType) {
        this.columnName = columnName;
        this.sqlType = sqlType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    public void write(DataOutputStream dout) throws IOException {
        IOUtil.writeString(dout, Coder.encode(this.columnName));
        dout.writeInt(this.sqlType);
    }

    public static ColMetaData read(DataInputStream din, int version) throws IOException {
        String columnName = Coder.decode(IOUtil.readString(din, true), version);
        int sqlType = din.readInt();
        return new ColMetaData(columnName, sqlType);
    }

    public static Vector<ColMetaData> getVector(ColData[] colData) {
        Vector<ColMetaData> output = new Vector<ColMetaData>();
        int nColumn = colData.length - 1;
        for (int i = 0; i < nColumn; ++i) {
            output.addElement(new ColMetaData(colData[i].getName(), colData[i].getOriginalDataType()));
        }
        return output;
    }

    public static Vector<ColMetaData> getVector(XMLFieldInfo[] xmlInfo, boolean transposeData, boolean[] doTranspose) {
        Vector<ColMetaData> output = new Vector<ColMetaData>();
        if (transposeData) {
            int i;
            int[] transposeCol = new int[TransposeRS.countTransposeColumn(doTranspose)];
            int NCOL = doTranspose.length - transposeCol.length + 2;
            String[] colNames = new String[NCOL];
            int[] colTypes = new int[NCOL];
            Object[] seriesName = new Object[transposeCol.length];
            int j = 0;
            int k = 0;
            for (i = 0; i < doTranspose.length; ++i) {
                if (doTranspose[i]) {
                    colNames[j] = xmlInfo[i].getAlias();
                    colTypes[j++] = ColMetaData.getDataType(xmlInfo[i]);
                    continue;
                }
                colTypes[colNames.length - 1] = ColMetaData.getDataType(xmlInfo[i]);
                seriesName[k++] = xmlInfo[i].getAlias();
            }
            colNames[colNames.length - 2] = "ColumnLabel";
            colNames[colNames.length - 1] = "Value";
            colTypes[colNames.length - 2] = 12;
            TransposeRS.bestMap(seriesName, colTypes);
            for (i = 0; i < colNames.length; ++i) {
                output.addElement(new ColMetaData(colNames[i], colTypes[i]));
            }
            return output;
        }
        int nColumn = xmlInfo.length;
        for (int i = 0; i < nColumn; ++i) {
            output.addElement(new ColMetaData(xmlInfo[i].getAlias(), ColMetaData.getDataType(xmlInfo[i])));
        }
        return output;
    }

    private static int getDataType(XMLFieldInfo leafNode) {
        if (leafNode.getXMLType() == 1) {
            return DataType.findType(leafNode.getElementDataType());
        }
        if (leafNode.getXMLType() == 2) {
            return DataType.findType(leafNode.getAttributeDataType());
        }
        return -1;
    }

    public static Vector<ColMetaData> getEJBVector(String remoteName, boolean transpose, boolean[] transposeCol) {
        return EJBAccess.getColMetaData(remoteName, transpose, transposeCol);
    }

    public static Vector<ColMetaData> getVector(String dataFilename, boolean transposeData, boolean[] transposeCol) throws Exception {
        return ColMetaData.getVector(dataFilename, transposeData, transposeCol, 2);
    }

    public static Vector<ColMetaData> getVector(String dataFilename, boolean transposeData, boolean[] transposeCol, int dataType) throws Exception {
        return ColMetaData.getVector(dataFilename, transposeData, transposeCol, dataType, null);
    }

    public static Vector<ColMetaData> getVector(SOAPQueryFileInfo soapInfo, boolean transposeData, boolean[] transposeCol) {
        try {
            return ColMetaData.getVector(SOAPAccess.retrieveResult(soapInfo, transposeData, transposeCol));
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to get data from SOAP", ex);
            return null;
        }
    }

    public static Vector<ColMetaData> getVector(SalesForceQueryFileInfo sfQueryInfo, boolean transposeData, boolean[] transposeCol) {
        try {
            return ColMetaData.getVector(SalesForceAccess.getColData(sfQueryInfo, transposeData, transposeCol));
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to get data from SalesForce", ex);
            return null;
        }
    }

    public static Vector<ColMetaData> getVector(ExcelFileInfo excelInfo, boolean transposeData, boolean[] transposeCol) {
        try {
            return ColMetaData.getVector(ExcelAccess.getColData(excelInfo, transposeData, transposeCol));
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to get data from Excel file", ex);
            return null;
        }
    }

    private static Vector<ColMetaData> makeFromLocalDataFile(String dataFilename, boolean transposeData, boolean[] transposeCol, int dataType) throws Exception {
        DataInputStream inputStream = new ReadDataFile().getInputStream(dataFilename);
        IResultSet rs = IOUtil.isXMLFormat(dataFilename) || dataType == 4 ? new ReadDataFile().createXMLResultSet(dataFilename) : (dataType == 6 ? new ReadDataFile().getClassResultSet(dataFilename) : new StreamResultSet(inputStream));
        IRSMetaData metaData = rs.getMetaData();
        Vector<ColMetaData> output = new Vector<ColMetaData>();
        int nColumn = metaData.getColumnCount();
        for (int i = 1; i <= nColumn; ++i) {
            output.addElement(new ColMetaData(metaData.getColumnName(i), metaData.getColumnType(i)));
        }
        rs.close();
        if (transposeData) {
            return ColMetaData.transposeVector(output, transposeCol);
        }
        return output;
    }

    public static Vector<ColMetaData> getVector(Vector parameters, DBInfoBasic dbInfo, boolean transposeData, boolean[] transposeCol) throws Exception {
        if (ServerMessage.useServer) {
            return ReadDBqueryMeta.getMeta(parameters, dbInfo, transposeData, transposeCol);
        }
        return ColMetaData.makeFromLocalDB(parameters, dbInfo, transposeData, transposeCol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector<ColMetaData> makeFromLocalDB(Vector parameters, DBInfoBasic dbInfo, boolean transposeData, boolean[] transposeCol) throws Exception {
        Vector<ColMetaData> output = new Vector<ColMetaData>();
        Connection conn = dbInfo.openConnection();
        Statement stmt = null;
        PreparedStatement pStmt = null;
        CallableStatement callstmt = null;
        ResultSet rs = null;
        String query = dbInfo.getQuery();
        try {
            boolean hasParameter = QueryFileInfo.hasParameter(parameters);
            if (QueryParser.isCallableStmt(query)) {
                if (hasParameter) {
                    query = ColMetaData.findInParam(parameters).convertToJDBCquery(query);
                }
                callstmt = conn.prepareCall(query);
                if (hasParameter) {
                    ColMetaData.findInParam(parameters).setStmtValue(callstmt);
                }
                rs = callstmt.executeQuery();
                stmt = callstmt;
            } else if (QueryParser.isPreparedStmt(query)) {
                if (hasParameter) {
                    query = ColMetaData.findInParam(parameters).convertToJDBCquery(query);
                }
                pStmt = conn.prepareStatement(query);
                if (hasParameter) {
                    ColMetaData.findInParam(parameters).setStmtValue(pStmt);
                }
                rs = pStmt.executeQuery();
                stmt = pStmt;
            } else {
                stmt = conn.createStatement();
                rs = stmt.executeQuery(query);
            }
            ResultSetMetaData rsmd = rs.getMetaData();
            int nColumn = rsmd.getColumnCount();
            for (int j = 1; j <= nColumn; ++j) {
                int sqlType = rsmd.getColumnType(j);
                String columnName = rsmd.getColumnName(j);
                output.addElement(new ColMetaData(columnName, sqlType));
            }
        }
        catch (Throwable throwable) {
            CloseUtils.close(rs);
            CloseUtils.close(callstmt);
            CloseUtils.close(stmt);
            CloseUtils.close(conn);
            throw throwable;
        }
        CloseUtils.close(rs);
        CloseUtils.close(callstmt);
        CloseUtils.close(stmt);
        CloseUtils.close(conn);
        if (transposeData) {
            return ColMetaData.transposeVector(output, transposeCol);
        }
        return output;
    }

    private static QueryInParamSet findInParam(Vector parameter) {
        for (int i = 0; i < parameter.size(); ++i) {
            Object target = parameter.elementAt(i);
            if (!(target instanceof QueryInParamSet)) continue;
            return (QueryInParamSet)target;
        }
        return null;
    }

    static Vector<ColMetaData> transposeVector(Vector<ColMetaData> target, boolean[] transposeCol) throws IllegalArgumentException {
        if (transposeCol == null) {
            transposeCol = TransposeRS.getDefaultTransposeColumn(target.size());
        }
        Vector<ColMetaData> output = new Vector<ColMetaData>();
        int type = -5;
        for (int i = 0; i < target.size(); ++i) {
            if (!transposeCol[i]) {
                output.addElement(target.elementAt(i));
                continue;
            }
            if (type == -5) {
                type = target.elementAt(i).getSQLType();
                continue;
            }
            if (target.elementAt(i).getSQLType() == type) continue;
            type = 8;
        }
        output.addElement(new ColMetaData("ColumnLabel", 12));
        output.addElement(new ColMetaData("Value", type));
        return output;
    }

    public static Vector<ColMetaData> getVector(String dataFilename, boolean transposeData, boolean[] transposeCol, int dataType, QueryInParamSet inSet) throws Exception {
        if (ServerMessage.useServer || !ServerMessage.isLoadBalancer) {
            return ReadDataFileMeta.getMeta(dataFilename, transposeData, transposeCol, dataType, inSet);
        }
        return ColMetaData.makeFromLocalDataFile(dataFilename, transposeData, transposeCol, dataType, inSet);
    }

    private static Vector<ColMetaData> makeFromLocalDataFile(String dataFilename, boolean transposeData, boolean[] transposeCol, int dataType, QueryInParamSet inSet) throws Exception {
        if (inSet != null) {
            IResultSet rs = DataFileInput.getClassResultSet(dataFilename, inSet);
            IRSMetaData metaData = rs.getMetaData();
            Vector<ColMetaData> output = new Vector<ColMetaData>();
            int nColumn = metaData.getColumnCount();
            for (int i = 1; i <= nColumn; ++i) {
                output.addElement(new ColMetaData(metaData.getColumnName(i), metaData.getColumnType(i)));
            }
            rs.close();
            if (transposeData) {
                return ColMetaData.transposeVector(output, transposeCol);
            }
            return output;
        }
        return ColMetaData.makeFromLocalDataFile(dataFilename, transposeData, transposeCol, dataType);
    }
}

