/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import quadbase.chart.CAnnotation;
import quadbase.chart.Chart;
import quadbase.chart.HorzVertLine;
import quadbase.chart.MultiDimData;
import quadbase.util.IControlLine;

public abstract class ControlLine
extends HorzVertLine
implements IControlLine {
    protected double calculatedValue;
    public static int[] linetypeMap = new int[]{10, 11, 12, 13};
    public static final String[] defaultNames = new String[]{"Average", "Standard Deviation", "Minimum", "Maximum"};
    protected static final String[] shortName = new String[]{"Control-Avg", "Std-Dev", "Min", "Max"};

    protected ControlLine(Chart newChart, ControlLine cLine) {
        super(newChart, cLine);
        this.series = cLine.series;
        this.useSubvalue = cLine.useSubvalue;
        this.useAxis = cLine.useAxis;
    }

    @Override
    public Object clone() {
        ControlLine newLine = this.chart.dataLineSet.newControlLine(this);
        if (newLine.annoVector != null) {
            int nAnno = newLine.annoVector.size();
            for (int i = 0; i < nAnno; ++i) {
                ((CAnnotation)newLine.annoVector.elementAt(i)).setReferenceObject(newLine);
            }
        }
        return newLine;
    }

    public static boolean isControlLine(int linetype) {
        boolean result = false;
        for (int element : linetypeMap) {
            if (element != linetype % 100) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    protected String getShortName(int linetype) {
        String result = "";
        for (int i = 0; i < linetypeMap.length; ++i) {
            if (linetypeMap[i] != linetype % 100) continue;
            result = shortName[i];
            break;
        }
        return result;
    }

    public ControlLine(Chart chart) {
        super(chart);
        this.linetype = 10;
        this.coeff = 1;
        this.chart = chart;
    }

    public ControlLine(Chart chart, int linetype, String title) {
        super(chart, linetype, title);
        this.linetype = linetype;
        this.title = title;
        this.coeff = 1;
        this.chart = chart;
    }

    public ControlLine(Chart chart, int linetype, String title, int level) {
        super(chart, linetype, title);
        this.linetype = linetype;
        this.title = title;
        this.coeff = 1;
        this.chart = chart;
        this.level = level;
    }

    @Override
    public void useSecondaryValue(boolean state) {
        this.useSubvalue = state;
        if (state) {
            this.useAxis = -2;
        }
    }

    private void setupArray() {
        MultiDimData md;
        if (this.chart.mData2 == null) {
            this.useSubvalue = false;
        }
        boolean xscale = this.chart.a_x.logScale;
        boolean yscale = this.chart.a_y.logScale;
        MultiDimData multiDimData = md = this.useSubvalue ? this.chart.mData2 : this.chart.mData;
        if (!this.chart.isStackType()) {
            if (this.chart.dataDim == 1) {
                this.getArray(xscale, this.chart.a_x.getBaseForLog(), yscale, this.chart.a_y.getBaseForLog(), md, false, this.level);
            } else {
                this.getArray(xscale, this.chart.a_x.getBaseForLog(), yscale, this.chart.a_y.getBaseForLog(), md.multiData[this.findSeriesNo(this.series)], false, this.level);
            }
        } else if (this.chart.getSeriesIndex() >= 0) {
            if (this.useSubvalue && this.chart.getComboType() != 1) {
                this.getArray(xscale, this.chart.a_x.getBaseForLog(), yscale, this.chart.a_y.getBaseForLog(), md.multiData[this.findSeriesNo(this.series)], true, this.level, false);
            } else {
                this.getArray(xscale, this.chart.a_x.getBaseForLog(), yscale, this.chart.a_y.getBaseForLog(), md.multiData[this.findSeriesNo(this.series)], true, this.level, true);
            }
        } else if (this.useSubvalue && this.chart.getComboType() != 1) {
            this.getArray(xscale, this.chart.a_x.getBaseForLog(), yscale, this.chart.a_y.getBaseForLog(), md, true, this.level, false);
        } else {
            this.getArray(xscale, this.chart.a_x.getBaseForLog(), yscale, this.chart.a_y.getBaseForLog(), md, true, this.level, true);
        }
    }

    @Override
    public double getAverage() {
        this.setupArray();
        double sum = 0.0;
        Double[] array = ControlLine.isBarChartType(this.chart) ? this.x : this.y;
        int numElement = 0;
        for (Double element : array) {
            if (element == null) continue;
            sum += element.doubleValue();
            ++numElement;
        }
        if (numElement == 0) {
            return 0.0;
        }
        return sum / (double)numElement;
    }

    @Override
    public double getStandardDev() {
        int i;
        this.setupArray();
        Double[] array = ControlLine.isBarChartType(this.chart) ? this.x : this.y;
        int nValue = array.length;
        double stDev = 0.0;
        double mean = 0.0;
        int nNonNullValue = 0;
        for (i = 0; i < nValue; ++i) {
            if (array[i] == null) continue;
            mean += array[i].doubleValue();
            ++nNonNullValue;
        }
        mean /= (double)nNonNullValue;
        for (i = 0; i < nValue; ++i) {
            if (array[i] == null) continue;
            stDev = Math.pow(array[i] - mean, 2.0) + stDev;
        }
        if (nNonNullValue > 1) {
            stDev = Math.sqrt(stDev / (double)(nNonNullValue - 1));
        }
        return stDev;
    }

    private Double findFirstNonNullValue(Double[] array) {
        for (Double element : array) {
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public double getMin() {
        this.setupArray();
        if (!ControlLine.isBarChartType(this.chart)) {
            double smallest = this.findFirstNonNullValue(this.y);
            for (int i = 1; i < this.y.length; ++i) {
                if (this.y[i] == null || !(this.y[i] < smallest)) continue;
                smallest = this.y[i];
            }
            return smallest;
        }
        double smallest = this.findFirstNonNullValue(this.x);
        for (int i = 1; i < this.x.length; ++i) {
            if (this.x[i] == null || !(this.x[i] < smallest)) continue;
            smallest = this.x[i];
        }
        return smallest;
    }

    @Override
    public double getMax() {
        this.setupArray();
        if (!ControlLine.isBarChartType(this.chart)) {
            double largest = this.findFirstNonNullValue(this.y);
            for (int i = 1; i < this.y.length; ++i) {
                if (this.y[i] == null || !(this.y[i] > largest)) continue;
                largest = this.y[i];
            }
            return largest;
        }
        double largest = this.findFirstNonNullValue(this.x);
        for (int i = 1; i < this.x.length; ++i) {
            if (this.x[i] == null || !(this.x[i] > largest)) continue;
            largest = this.x[i];
        }
        return largest;
    }

    @Override
    public double getCalculatedValue() {
        switch (this.linetype % 100) {
            case 10: {
                return this.getAverage();
            }
            case 11: {
                double result = this.getAverage() + this.line_value * this.getStandardDev();
                return result;
            }
            case 12: {
                return this.getMin();
            }
            case 13: {
                return this.getMax();
            }
        }
        return 0.0;
    }

    @Override
    public int getPixelValue() {
        if (this.chart.mData2 == null) {
            this.useSubvalue = false;
        }
        int pixelValue = 0;
        if (this.showHorzLine()) {
            pixelValue = this.getHortLineYPixel();
        } else if (this.showVertLine()) {
            pixelValue = this.getVertLineXPixel();
        }
        return pixelValue;
    }

    @Override
    public boolean invalidchart() {
        int chartType = this.chart.chartType;
        return chartType == 6 || chartType == 20 || chartType == 17 || chartType == 15;
    }

    @Override
    public final void compute() {
        if (this.invalidchart()) {
            return;
        }
        this.makeTitle();
        this.calculatedValue = this.getCalculatedValue();
    }

    @Override
    public boolean showHorzLine() {
        int chartType = this.chart.chartType;
        return chartType == 0 || chartType == 2 || chartType == 12 || chartType == 3 && this.chart.getLayout() == 0 || chartType == 3 && !this.chart.is2DChart || chartType == 7 || chartType == 14 || chartType == 8 || chartType == 4 || chartType == 9 || chartType == 10;
    }

    @Override
    public boolean showVertLine() {
        int chartType = this.chart.chartType;
        return chartType == 1 || this.chart.is2DChart && chartType == 3 && this.chart.getLayout() == 1 || chartType == 5 || chartType == 15 || chartType == 18;
    }

    @Override
    protected int getHortLineYPixel() {
        if (this.chart.getAxis((int)(this.useAxis + 4)).stepsize != null) {
            return this.chart.getAxis((int)(this.useAxis + 4)).stepsize.interpolatePixel2(this.calculatedValue);
        }
        return this.useSubvalue ? this.chart.a_s.stepsize.interpolatePixel2(this.calculatedValue) : this.chart.a_y.stepsize.interpolatePixel2(this.calculatedValue);
    }

    @Override
    protected int getVertLineXPixel() {
        if (this.chart.getAxis((int)(this.useAxis + 3)).stepsize != null) {
            return this.chart.getAxis((int)(this.useAxis + 3)).stepsize.interpolatePixel2(this.calculatedValue);
        }
        return this.useSubvalue ? this.chart.a_s.stepsize.interpolatePixel2(this.calculatedValue) : this.chart.a_x.stepsize.interpolatePixel2(this.calculatedValue);
    }
}

