/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import quadbase.chart.CAnnotation;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ControlLine;
import quadbase.chart.DataLine;
import quadbase.chart.FunctionLine;
import quadbase.chart.HorzVertLine;
import quadbase.chart.TrendLine;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.util.IAnnotation;
import quadbase.util.IDataLine;
import quadbase.util.IFunction;
import quadbase.util.internal.IOUtil;

public abstract class DataLineSet {
    protected Chart chart;
    protected Vector<DataLine> dataLineList;

    public DataLineSet(Chart chart) {
        this.chart = chart;
        this.dataLineList = new Vector();
    }

    private void invalidateLegend() {
        this.chart.legend.invalidate();
        this.chart.legend2.invalidate();
    }

    public void setDataLineList(Vector<DataLine> v) {
        this.invalidateLegend();
        this.dataLineList = v;
    }

    public int getSize() {
        return this.dataLineList.size();
    }

    public DataLine elementAt(int i) {
        return this.dataLineList.elementAt(i);
    }

    public final IDataLine findDataLineObj(IDataLine tr) {
        int i = this.findDataLine(tr);
        if (i >= 0) {
            return this.dataLineList.elementAt(i);
        }
        return null;
    }

    public final int findDataLine(IDataLine dline) {
        for (int i = 0; i < this.dataLineList.size(); ++i) {
            if (!this.dataLineList.elementAt(i).equals((DataLine)dline)) continue;
            return i;
        }
        return -1;
    }

    public static final int findDataLine(Vector<IDataLine> v, IDataLine dline) {
        for (int i = 0; i < v.size(); ++i) {
            if (!v.elementAt(i).equals(dline)) continue;
            return i;
        }
        return -1;
    }

    public void updateDataLine(IDataLine dline) {
        this.invalidateLegend();
        int pos = this.findDataLine(dline);
        if (pos >= 0) {
            this.dataLineList.setElementAt((DataLine)dline, pos);
        } else {
            this.dataLineList.addElement((DataLine)dline);
        }
    }

    public void removeDataLine(IDataLine dline) {
        this.invalidateLegend();
        int pos = this.findDataLine(dline);
        if (pos >= 0) {
            this.dataLineList.removeElementAt(pos);
        }
    }

    public final Vector<DataLine> getDataLineList() {
        return this.dataLineList;
    }

    public final Vector getTrendLineList() {
        Vector<DataLine> v = new Vector<DataLine>();
        for (int i = 0; i < this.dataLineList.size(); ++i) {
            DataLine target = this.dataLineList.elementAt(i);
            if (!(target instanceof TrendLine)) continue;
            v.addElement(target);
        }
        return v;
    }

    public final void setTrendLineList(Vector<TrendLine> v) {
        int i;
        for (i = 0; i < this.dataLineList.size(); ++i) {
            DataLine target = this.dataLineList.elementAt(i);
            if (!(target instanceof TrendLine)) continue;
            this.dataLineList.remove(i);
            --i;
        }
        for (i = 0; i < v.size(); ++i) {
            this.dataLineList.add(v.elementAt(i));
        }
    }

    public final Vector getHorzVertLineList() {
        Vector<DataLine> v = new Vector<DataLine>();
        for (int i = 0; i < this.dataLineList.size(); ++i) {
            DataLine target = this.dataLineList.elementAt(i);
            if (!(target instanceof HorzVertLine) || target instanceof ControlLine) continue;
            v.addElement(target);
        }
        return v;
    }

    public final void setHorzVertLineList(Vector<DataLine> vec) {
        int i;
        for (i = 0; i < this.dataLineList.size(); ++i) {
            DataLine target = this.dataLineList.elementAt(i);
            if (!(target instanceof HorzVertLine)) continue;
            this.dataLineList.remove(i);
            --i;
        }
        for (i = 0; i < vec.size(); ++i) {
            this.dataLineList.add(vec.elementAt(i));
        }
    }

    public final Vector getControlLineList() {
        Vector<DataLine> v = new Vector<DataLine>();
        for (int i = 0; i < this.dataLineList.size(); ++i) {
            DataLine target = this.dataLineList.elementAt(i);
            if (!(target instanceof ControlLine)) continue;
            v.addElement(target);
        }
        return v;
    }

    public final void setControlLineList(Vector<DataLine> vec) {
        int i;
        for (i = 0; i < this.dataLineList.size(); ++i) {
            DataLine target = this.dataLineList.elementAt(i);
            if (!(target instanceof ControlLine)) continue;
            this.dataLineList.remove(i);
            --i;
        }
        for (i = 0; i < vec.size(); ++i) {
            this.dataLineList.add(vec.elementAt(i));
        }
    }

    public void setdataLineList(Vector<DataLine> vec) {
        this.invalidateLegend();
        this.dataLineList = vec;
    }

    public abstract void computeDataLines(boolean var1);

    public abstract TrendLine newTrendLine(Chart var1);

    public abstract TrendLine newTrendLine(int var1, int var2, String var3);

    protected abstract TrendLine newTrendLine(TrendLine var1);

    public abstract HorzVertLine newHorzVertLine(int var1, String var2);

    protected abstract HorzVertLine newHorzVertLine(HorzVertLine var1);

    public abstract ControlLine newControlLine(int var1, String var2);

    public abstract ControlLine newControlLine(int var1, String var2, int var3);

    protected abstract ControlLine newControlLine(ControlLine var1);

    public abstract FunctionLine newFunctionLine(IFunction var1, String var2);

    protected abstract FunctionLine newFunctionLine(FunctionLine var1);

    public final void drawDataLineList() {
        for (int i = 0; i < this.dataLineList.size(); ++i) {
            this.dataLineList.elementAt(i).draw(this.chart.cgraphics);
        }
    }

    CAnnotation selectAnnotation(CGraphics g, int x, int y) {
        int size = this.dataLineList.size();
        for (int i = 0; i < size; ++i) {
            DataLine dl = this.dataLineList.elementAt(i);
            Vector<IAnnotation> annoVector = dl.getAnnotations();
            if (annoVector == null) continue;
            int nAnno = annoVector.size();
            for (int j = 0; j < nAnno; ++j) {
                CAnnotation annoObj = (CAnnotation)annoVector.elementAt(j);
                if (annoObj.selectPart(g, x, y) == null) continue;
                return annoObj;
            }
        }
        return null;
    }

    public void write(DataOutput out) throws IOException {
        int i;
        int size;
        int nSave = size = this.dataLineList.size();
        for (i = 0; i < size; ++i) {
            if (this.dataLineList.elementAt((int)i).linetype != 16) continue;
            --nSave;
        }
        out.writeInt(nSave);
        for (i = 0; i < size; ++i) {
            DataLine currentLine = this.dataLineList.elementAt(i);
            if (currentLine.linetype == 16) continue;
            this.writeSingle(out, currentLine);
        }
    }

    public void read(DataInput in, int version) throws IOException {
        if (version >= 37) {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.updateDataLine(this.readSingle(in, version));
            }
        }
    }

    private void writeSingle(DataOutput dout, DataLine dline) throws IOException {
        dout.writeInt(dline.linetype);
        dout.writeInt(dline.coeff);
        IOUtil.writeString(dout, dline.title);
        IOUtil.writeString(dout, dline.series);
        dout.writeInt(dline.hlco_value);
        IOUtil.writeColor(dout, dline.color);
        dout.writeInt(dline.thickness);
        dout.writeBoolean(dline.positive_line);
        dout.writeBoolean(dline.hideTitle);
        dout.writeBoolean(dline.useSubvalue);
        if (dout instanceof VersioningDataOutput) {
            ((VersioningDataOutput)dout).writeInt(dline.useAxis, (short)6601);
        }
        dout.writeDouble(dline.line_value);
        dout.writeBoolean(dline.showValue);
        IOUtil.writeString(dout, dline.valueHint);
        dout.writeInt(dline.lineStyle);
        boolean hasAnnotation = dline.annoVector != null && dline.annoVector.size() > 0;
        dout.writeBoolean(hasAnnotation);
        if (hasAnnotation) {
            int nAnno = dline.annoVector.size();
            dout.writeInt(nAnno);
            for (int i = 0; i < nAnno; ++i) {
                ((CAnnotation)dline.annoVector.elementAt(i)).write(dout);
            }
        }
        dline.write(dout);
    }

    private DataLine readSingle(DataInput din, int version) throws IOException {
        boolean hasAnnotation;
        boolean utf = version >= 50;
        int lineType = din.readInt();
        int coeff = din.readInt();
        String title = IOUtil.readString(din, utf);
        DataLine dline = null;
        if (DataLineSet.isTrendLine(lineType)) {
            dline = this.newTrendLine(lineType, coeff, title);
        } else if (DataLineSet.isControlLine(lineType)) {
            dline = this.newControlLine(lineType, title);
        } else if (DataLineSet.isHorzVertLine(lineType)) {
            dline = this.newHorzVertLine(lineType, title);
        }
        dline.series = IOUtil.readString(din, utf);
        dline.hlco_value = din.readInt();
        dline.color = IOUtil.readColor(din);
        dline.thickness = din.readInt();
        dline.positive_line = din.readBoolean();
        if (version >= 40) {
            dline.hideTitle = din.readBoolean();
        }
        if (version >= 47) {
            dline.useSubvalue = din.readBoolean();
        }
        if (version >= 6601) {
            dline.useAxis = din.readInt();
        }
        if (version >= 51) {
            dline.line_value = din.readDouble();
        }
        if (version >= 54) {
            dline.showValue = din.readBoolean();
            dline.valueHint = IOUtil.readString(din, true);
        }
        if (version > 72) {
            dline.lineStyle = din.readInt();
        }
        if (version > 70 && (hasAnnotation = din.readBoolean())) {
            int nAnno = din.readInt();
            for (int i = 0; i < nAnno; ++i) {
                dline.addAnnotation(CAnnotation.read(din, version, dline.chart, dline));
            }
        }
        dline.read(din, version);
        return dline;
    }

    private static boolean isTrendLine(int lineType) {
        return TrendLine.isTrendLine(lineType);
    }

    private static boolean isControlLine(int lineType) {
        return ControlLine.isControlLine(lineType);
    }

    private static boolean isHorzVertLine(int lineType) {
        return HorzVertLine.isHorzVertLine(lineType);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< DataLineSet >>\n");
        int size = this.dataLineList.size();
        sb.append("size\t\t= " + size + "\n");
        for (int i = 0; i < size; ++i) {
            sb.append(this.dataLineList.elementAt(i));
        }
        return sb.toString();
    }
}

