/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.util.internal.IOUtil;

public class DeleteFile {
    private static final Logger LOGGER = Logger.getLogger(DeleteFile.class.getName());
    String filename = null;
    int index;
    ServerMessage sm;

    public DeleteFile(String fileName, int index) {
        this.filename = fileName;
        if (this.filename.endsWith(".tpl")) {
            this.filename = this.filename.substring(0, this.filename.length() - 5);
        }
        this.index = index;
    }

    public boolean delete() throws Exception {
        int code;
        int drillNum = this.index;
        boolean returnVal = false;
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            String previousFile = this.filename + drillNum + ".tpl";
            File file = new File(previousFile);
            if (file.exists()) {
                returnVal = file.delete();
            }
            String nextFile = this.filename + ++drillNum + ".tpl";
            File nfile = new File(nextFile);
            while (nfile.exists()) {
                nfile.renameTo(file);
                previousFile = nextFile;
                file = new File(previousFile);
                nextFile = this.filename + ++drillNum + ".tpl";
                nfile = new File(nextFile);
            }
            return returnVal;
        }
        IConnection socket = ServerMessage.createConnection();
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(25330);
            out.writeBoolean(false);
            out.writeInt(this.index);
            IOUtil.writeString(out, this.filename);
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            DataInputStream din = new DataInputStream(socket.getInputStream());
            code = din.readInt();
            socket.close();
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Failed to close socket", ex2);
            }
            LOGGER.log(Level.WARNING, "Failed to write data to remote server", ex);
            throw ex;
        }
        switch (code) {
            case 0: {
                return true;
            }
        }
        return false;
    }
}

