/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.applet.Applet;
import java.io.File;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;

public class DrillDownNode {
    private static final Logger LOGGER = Logger.getLogger(DrillDownNode.class.getName());
    public static final String DRILLDOWN_DIR = "drilltemplates/";
    private String filename = "";
    private boolean useAbsolutePath = false;
    private boolean saved = true;
    private Object chart = null;
    private int[] mapping = new int[0];
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };
    protected DrillDownNode parent = null;
    protected Vector children;
    protected transient String userObject;
    private boolean selected = false;

    public DrillDownNode() {
        this(null);
    }

    public DrillDownNode(String userObject) {
        this.userObject = userObject;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String qf) {
        this.filename = qf == null ? "" : qf;
    }

    public int[] getColumnMapping() {
        return this.mapping;
    }

    public void setColumnMapping(int[] m) {
        if (m != null) {
            this.mapping = m;
        }
    }

    public DrillDownNode createNewChild(String name) {
        DrillDownNode newChild = new DrillDownNode(name);
        this.add(newChild);
        String newFile = this.getRoot().getFileName();
        newFile = newFile.substring(newFile.lastIndexOf(92) + 1);
        newFile = newFile.substring(newFile.lastIndexOf(47) + 1);
        if (newFile.toUpperCase().endsWith(".CHT")) {
            newFile = newFile.substring(0, newFile.length() - 4);
        }
        if (newFile.toUpperCase().endsWith(".TPL")) {
            newFile = newFile.substring(0, newFile.length() - 4);
        }
        if (newFile.toUpperCase().endsWith(".XML")) {
            newFile = newFile.substring(0, newFile.length() - 4);
        }
        newFile = newFile.replace(' ', '_');
        newFile = DRILLDOWN_DIR + newFile;
        Applet applet = ServerMessage.getApplet();
        newFile = this.useAbsolutePath ? (ServerMessage.useServer || !ServerMessage.isLoadBalancer || applet == null ? IOUtil.getWorkingDirectory() + File.separator + newFile + "_lvl" + newChild.getLevel() + this.getChildCount() : IOUtil.getCodeBase(applet) + newFile + "_lvl" + newChild.getLevel() + this.getChildCount()) : newFile + "_lvl" + newChild.getLevel() + this.getChildCount();
        String tmp = newFile;
        int ct = 0;
        try {
            while (new FileInfo(newFile + ".tpl").exists()) {
                newFile = tmp + "_" + ct++;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to choose a filename", ex);
        }
        newChild.setFileName(newFile + ".tpl");
        return newChild;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean state) {
        this.saved = state;
    }

    public Object getDrillDownChart() {
        return this.chart;
    }

    public void setDrillDownChart(Object r) {
        this.chart = r;
    }

    public boolean equals(DrillDownNode _node) {
        return this.getFileName().equals(_node.getFileName());
    }

    public void insert(DrillDownNode newChild, int childIndex) {
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(newChild)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        DrillDownNode oldParent = newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    public void remove(int childIndex) {
        DrillDownNode child = this.getChildAt(childIndex);
        this.children.removeElementAt(childIndex);
        child.setParent(null);
    }

    public void setParent(DrillDownNode newParent) {
        this.parent = newParent;
    }

    public DrillDownNode getParent() {
        return this.parent;
    }

    public DrillDownNode getChildAt(int index) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return (DrillDownNode)this.children.elementAt(index);
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int getIndex(DrillDownNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            return -1;
        }
        return this.children.indexOf(aChild);
    }

    public Enumeration children() {
        if (this.children == null) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public void setName(String userObject) {
        this.userObject = userObject;
    }

    public String getName() {
        return this.userObject;
    }

    public void removeFromParent() {
        DrillDownNode parent = this.getParent();
        if (parent != null) {
            parent.remove(this);
        }
    }

    public void remove(DrillDownNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(aChild));
    }

    public void removeAllChildren() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public void add(DrillDownNode newChild) {
        if (newChild != null && newChild.getParent() == this) {
            this.insert(newChild, this.getChildCount() - 1);
        } else {
            this.insert(newChild, this.getChildCount());
        }
    }

    public boolean isNodeAncestor(DrillDownNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        DrillDownNode ancestor = this;
        do {
            if (ancestor != anotherNode) continue;
            return true;
        } while ((ancestor = ancestor.getParent()) != null);
        return false;
    }

    public boolean isNodeDescendant(DrillDownNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        return anotherNode.isNodeAncestor(this);
    }

    public DrillDownNode getSharedAncestor(DrillDownNode aNode) {
        DrillDownNode node2;
        DrillDownNode node1;
        int diff;
        if (aNode == this) {
            return this;
        }
        if (aNode == null) {
            return null;
        }
        int level1 = this.getLevel();
        int level2 = aNode.getLevel();
        if (level2 > level1) {
            diff = level2 - level1;
            node1 = aNode;
            node2 = this;
        } else {
            diff = level1 - level2;
            node1 = this;
            node2 = aNode;
        }
        while (diff > 0) {
            node1 = node1.getParent();
            --diff;
        }
        do {
            if (node1 == node2) {
                return node1;
            }
            node1 = node1.getParent();
            node2 = node2.getParent();
        } while (node1 != null);
        if (node1 != null || node2 != null) {
            throw new Error("nodes should be null");
        }
        return null;
    }

    public boolean isNodeRelated(DrillDownNode aNode) {
        return aNode != null && this.getRoot() == aNode.getRoot();
    }

    public int getLevel() {
        int levels = 0;
        DrillDownNode ancestor = this;
        while ((ancestor = ancestor.getParent()) != null) {
            ++levels;
        }
        return levels;
    }

    public DrillDownNode getRoot() {
        DrillDownNode previous;
        DrillDownNode ancestor = this;
        do {
            previous = ancestor;
        } while ((ancestor = ancestor.getParent()) != null);
        return previous;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public boolean isNodeChild(DrillDownNode aNode) {
        boolean retval = aNode == null ? false : (this.getChildCount() == 0 ? false : aNode.getParent() == this);
        return retval;
    }

    public DrillDownNode getFirstChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(0);
    }

    public DrillDownNode getLastChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(this.getChildCount() - 1);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public String toString() {
        if (this.userObject == null) {
            return null;
        }
        if (this.selected) {
            return "** " + this.userObject + " **";
        }
        return this.userObject;
    }

    protected Object clone() {
        DrillDownNode newNode = null;
        try {
            newNode = (DrillDownNode)super.clone();
            newNode.children = null;
            newNode.parent = null;
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.SEVERE, "Failed to clone DrillDownNode object", e);
            throw new Error(e.toString());
        }
        return newNode;
    }

    public String getUserObject() {
        return this.userObject;
    }

    public void setSelected(boolean state) {
        this.selected = state;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

