/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import quadbase.chart.ColData;
import quadbase.chart.ColDataResultSet;
import quadbase.chart.DBAccess;
import quadbase.chart.DataFileInput;
import quadbase.chart.PreprocInfo;
import quadbase.common.client.MessageSender;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.ExcelReader;
import quadbase.common.util.internal.IOUtil;
import quadbase.util.IResultSet;
import quadbase.util.internal.TransposeRS;

public class ExcelAccess {
    public static ColData[] getColData(ExcelFileInfo excelInfo) throws Exception {
        return ExcelAccess.getColData(excelInfo, false, (boolean[])null);
    }

    public static ColData[] getColData(ExcelFileInfo excelInfo, boolean doTranspose, int[] transposeCol) throws Exception {
        boolean[] transposeColBool = TransposeRS.getTransposeColumn(transposeCol);
        return ExcelAccess.getColData(excelInfo, doTranspose, transposeColBool);
    }

    public static ColData[] getColData(ExcelFileInfo excelInfo, boolean doTranspose, boolean[] transposeCol) throws Exception {
        return ExcelAccess.getColData(excelInfo, doTranspose, transposeCol, null, 0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColData[] getColData(ExcelFileInfo excelInfo, boolean doTranspose, boolean[] transposeCol, PreprocInfo procInfo, int startIndex, int count) throws Exception {
        ColDataResultSet cdrs;
        IResultSet rs;
        int i;
        if (ServerMessage.useServer) {
            MessageSender ms = new MessageSender(12001);
            DataOutputStream dout = ms.getDataOutput();
            dout.writeInt(12002);
            excelInfo.write(dout);
            dout.writeBoolean(doTranspose);
            if (doTranspose) {
                IOUtil.writeBooleans(dout, transposeCol);
            }
            dout.writeBoolean(procInfo != null);
            if (procInfo != null) {
                procInfo.writeAsStream(dout);
            }
            dout.writeInt(startIndex);
            dout.writeInt(count);
            try (DataInputStream in = ms.sendAndReceive();){
                in.readInt();
                ColData[] colDataArray = DataFileInput.getColDataFromStream(in);
                return colDataArray;
            }
        }
        ExcelReader reader = new ExcelReader(excelInfo, startIndex, count);
        String[] columnNames = reader.getColumnNames();
        int[] dataTypes = reader.getDataTypes();
        if (dataTypes == null || dataTypes.length == 0) {
            ColData[] colData = new ColData[]{new ColData("qbCount", 4, 1)};
            return colData;
        }
        Vector data = reader.getData();
        ColData[] colData = new ColData[columnNames.length + 1];
        for (i = 0; i < colData.length - 1; ++i) {
            colData[i] = new ColData(columnNames[i], dataTypes[i], data.size(), colData.length);
        }
        colData[colData.length - 1] = new ColData("qbCount", 4, colData.length);
        for (i = 0; i < data.size(); ++i) {
            Vector row = (Vector)data.get(i);
            for (int j = 0; j < row.size(); ++j) {
                colData[j].add(row.get(j));
            }
            colData[colData.length - 1].add(i);
        }
        if ((doTranspose || procInfo != null) && (rs = DBAccess.processResultSet(cdrs = new ColDataResultSet(colData), false, doTranspose, transposeCol, null, procInfo)) != null) {
            colData = ColData.getColData(rs);
        }
        return colData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getSheetNames(String path) throws Exception {
        if (ServerMessage.useServer) {
            MessageSender ms = new MessageSender(12001);
            DataOutputStream dout = ms.getDataOutput();
            dout.writeInt(12003);
            IOUtil.writeString(dout, path);
            try (DataInputStream in = ms.sendAndReceive();){
                in.readInt();
                String[] stringArray = IOUtil.readStrings(in);
                return stringArray;
            }
        }
        ExcelFileInfo excelInfo = new ExcelFileInfo(path);
        return new ExcelReader(excelInfo, 0, -1).getSheetNames();
    }
}

