/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Area;
import quadbase.chart.CAnnotation;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.INativeExport;
import quadbase.chart.IOUtil2;
import quadbase.chart.SaveChart;
import quadbase.chart.WriteDataFile;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DeleteFile;
import quadbase.util.PickData;
import quadbase.util.gif.GifEncoder;
import quadbase.util.gif.GifEncoder87a;
import quadbase.util.internal.BMPEncoder;
import quadbase.util.internal.ExcelEncoder;
import quadbase.util.internal.FlashEncoder;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.ImageEncoder;
import quadbase.util.internal.PDFEncoder;
import quadbase.util.internal.SVGEncoder;
import quadbase.util.internal.WMFEncoder;

public abstract class ExportChart {
    private static final Logger LOGGER = Logger.getLogger(ExportChart.class.getName());
    public static final int CHT = 0;
    public static final int GIF = 1;
    public static final int BMP = 2;
    public static final int JPEG_C = 4;
    public static final int TPL = 5;
    public static final int GIF_C = 6;
    public static final int JPEG = 7;
    public static final int WMF = 8;
    public static final int GIF_N = 9;
    public static final int PNG = 10;
    public static final int TXT = 11;
    public static final int XML = 12;
    public static final int PDF = 13;
    public static final int SVG = 14;
    public static final int GIF_R = 1;
    public static final int FLASH = 15;
    public static final int PAC = 16;
    public static final int CHT_DATA = 17;
    public static final int EXCEL = 18;
    public static final int COMPRESSION_DEFAULT = 0;
    public static final int COMPRESSION_FAST = 1;
    public static final int COMPRESSION_MAX = 2;
    public static final int COMPRESSION_NONE = 3;
    protected Chart ch = null;

    public ExportChart(Chart chart) {
        this.ch = chart;
    }

    public void do_directExport(String filename, String mapFilename, int format, int w, int h, Component component) throws Exception {
        this.do_directExport(filename, mapFilename, null, format, w, h, component, null, null, null, false, 99);
    }

    public void do_directExport(String filename, String mapFilename, int format, int w, int h, Component component, boolean generateDataMapFile, int quality) throws Exception {
        this.do_directExport(filename, mapFilename, null, format, w, h, component, null, null, null, generateDataMapFile, quality);
    }

    public void do_directExport(String filename, String drillDownChartName, int format, int w, int h, Component component, String servletLoc, PickData[] pickData, String[] argv, int quality) throws Exception {
        this.do_directExport(filename, filename, drillDownChartName, format, w, h, component, servletLoc, pickData, argv, true, quality);
    }

    private void do_directExport(String fileName, String subFileName, String chartLocation, int format, int w, int h, Component component, String servletLoc, PickData[] pickData, String[] argv, boolean generateSubFile, int quality) throws Exception {
        ByteArrayOutputStream image = new ByteArrayOutputStream(1024);
        DataOutputStream out = new DataOutputStream(image);
        ByteArrayOutputStream subFile = new ByteArrayOutputStream(1024);
        DataOutputStream subOut = new DataOutputStream(subFile);
        boolean fileIsCreated = this.do_directExport(out, subOut, fileName, subFileName, chartLocation, format, w, h, component, servletLoc, pickData, argv, generateSubFile, quality);
        subOut.close();
        subFile.close();
        out.close();
        image.close();
        WriteDataFile writeFile = new WriteDataFile();
        switch (format) {
            case 17: {
                writeFile.output(image.toByteArray(), this.getFileName(fileName, ".cht"));
                break;
            }
            case 0: {
                writeFile.output(image.toByteArray(), this.getFileName(fileName, ".cht"));
                if (!generateSubFile) break;
                writeFile.output(subFile.toByteArray(), this.getFileName(subFileName, ".xml"));
                break;
            }
            case 16: {
                writeFile.output(image.toByteArray(), this.getFileName(fileName, ".pac"));
                break;
            }
            case 8: {
                writeFile.output(image.toByteArray(), this.getFileName(fileName, ".wmf"));
                break;
            }
            case 15: {
                if (fileIsCreated) break;
                writeFile.output(image.toByteArray(), this.getFileName(fileName, ".swf"));
                break;
            }
            case 2: {
                writeFile.output(image.toByteArray(), this.getFileName(fileName, ".bmp"));
                break;
            }
            case 13: {
                if (fileIsCreated) break;
                writeFile.output(image.toByteArray(), this.getFileName(fileName, ".pdf"));
                break;
            }
            case 18: {
                if (fileIsCreated) break;
                writeFile.output(image.toByteArray(), this.getFileName(fileName, ".xls"));
                break;
            }
            case 14: {
                if (fileIsCreated) break;
                writeFile.output(image.toByteArray(), this.getFileName(fileName, ".svg"));
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                if (subFileName != null) {
                    subFileName = this.getFileName(subFileName, ".map");
                    if (generateSubFile || this.ch.getHyperLinkList() != null && this.ch.getHyperLinkList().size() > 0 && subFileName != null || servletLoc != null && chartLocation != null && subFileName != null) {
                        writeFile.output(subFile.toByteArray(), subFileName);
                    } else if (new FileInfo(subFileName).exists()) {
                        new DeleteFile(subFileName).delete();
                    }
                }
                if (fileIsCreated) break;
                if (format == 10) {
                    writeFile.output(image.toByteArray(), this.getFileName(fileName, ".png"));
                    break;
                }
                if (format == 7 || format == 4) {
                    writeFile.output(image.toByteArray(), this.getFileName(fileName, ".jpg"));
                    break;
                }
                writeFile.output(image.toByteArray(), this.getFileName(fileName, ".gif"));
                break;
            }
            default: {
                writeFile.output(image.toByteArray(), this.getFileName(fileName, ".tpl"));
                if (!generateSubFile) break;
                writeFile.output(subFile.toByteArray(), this.getFileName(subFileName, ".xml"));
            }
        }
    }

    private String getFileName(String fileName, String ext) {
        if (fileName == null) {
            return null;
        }
        if (fileName.toLowerCase().endsWith(ext)) {
            return fileName;
        }
        return fileName + ext;
    }

    public boolean do_directExport(OutputStream out, OutputStream subOut, String fileName, String subFileName, String chartLocation, int format, int w, int h, Component component, String servletLoc, PickData[] pickData, String[] argv, boolean generateSubFile, int quality) throws Exception {
        if (subFileName == null) {
            subFileName = "CHART";
        }
        Dimension currentChartSize = this.ch.getSize();
        boolean fileIsCreated = false;
        switch (format) {
            case 0: 
            case 16: {
                this.ch.setSize(w, h);
                SaveChart saveChart = new SaveChart(this.ch);
                if (format == 16) {
                    saveChart.pack = true;
                }
                saveChart.setDrillDownNode(this.ch.currentNode);
                if (out != null) {
                    DataOutputStream dout = new DataOutputStream(out);
                    saveChart.saveToDataOutput(dout, false);
                    dout.close();
                }
                if (subOut != null && generateSubFile && fileName != null) {
                    saveChart.createXMLChartFile(subOut, fileName + ".cht");
                }
                this.ch.setSize(currentChartSize.width, currentChartSize.height);
                break;
            }
            case 17: {
                this.ch.setSize(w, h);
                SaveChart saveChart = new SaveChart(this.ch);
                saveChart.saveChartWithFixData(true);
                if (this.ch.annotationSet != null && this.ch.annotationSet.getAllAnnotations() != null) {
                    for (int i = 0; i < this.ch.annotationSet.getAnnotationList().size(); ++i) {
                        ((CAnnotation)this.ch.annotationSet.getAnnotationList().elementAt(i)).setValue(this.ch.valueTable.getRunTimeValue(((CAnnotation)this.ch.annotationSet.getAnnotationList().elementAt(i)).getOriginalValue()));
                    }
                }
                this.ch.mainTitle.setValue(this.ch.valueTable.getRunTimeValue(this.ch.mainTitle.getValue()));
                if (out != null) {
                    DataOutputStream dout = new DataOutputStream(out);
                    saveChart.saveToDataOutput(dout, false);
                    dout.close();
                }
                this.ch.setSize(currentChartSize.width, currentChartSize.height);
                break;
            }
            case 15: {
                if (IOUtil.isFlashIncluded()) {
                    Color originalColor = null;
                    boolean origGradientEnabled = false;
                    Area desktopArea = this.ch.getDesktopArea();
                    if (this.ch.isBackgroundTransparent()) {
                        origGradientEnabled = desktopArea.isGradientEnabled();
                        originalColor = desktopArea.areaColor;
                        desktopArea.areaColor = new Color(originalColor.getRed(), originalColor.getGreen(), originalColor.getBlue(), 0);
                        desktopArea.setGradientEnabled(false);
                    }
                    FlashEncoder.createFlashImage(this, out, w, h, component, servletLoc != null, chartLocation, servletLoc, pickData, argv);
                    if (originalColor == null) break;
                    desktopArea.areaColor = originalColor;
                    desktopArea.setGradientEnabled(origGradientEnabled);
                    break;
                }
                if ((ServerMessage.useServer || !ServerMessage.isLoadBalancer) && fileName != null) {
                    IOUtil2.exportToServer(15, this.ch, fileName, w, h, this.ch.flashFrameCount, this.ch.flashFrameRate);
                    fileIsCreated = true;
                    break;
                }
                throw new Exception("Please include FlashExport.jar in your classpath");
            }
            case 8: {
                if (out == null) break;
                WMFEncoder.createWMFImage(this, out, w, h, component);
                break;
            }
            case 14: {
                if (IOUtil.isSVGIncluded()) {
                    SVGEncoder.createSVGImage(this, out, w, h, component);
                    break;
                }
                if ((ServerMessage.useServer || !ServerMessage.isLoadBalancer) && fileName != null) {
                    IOUtil2.exportToServer(14, this.ch, fileName, w, h);
                    fileIsCreated = true;
                    break;
                }
                throw new Exception("Please include SVGExport.jar in your classpath");
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                Image image = null;
                boolean origGradientEnabled = false;
                Area desktopArea = this.ch.getDesktopArea();
                Color originalColor = null;
                if (format == 10) {
                    if (this.ch.isBackgroundTransparent()) {
                        originalColor = desktopArea.areaColor;
                        origGradientEnabled = desktopArea.isGradientEnabled();
                        desktopArea.areaColor = new Color(originalColor.getRed(), originalColor.getGreen(), originalColor.getBlue(), 0);
                        desktopArea.setGradientEnabled(false);
                    } else {
                        desktopArea.areaColor = new Color(desktopArea.areaColor.getRed(), desktopArea.areaColor.getGreen(), desktopArea.areaColor.getBlue());
                    }
                }
                image = !this.ch.isBufferedImageUsed() || out == null ? this.createChartImage(w, h, component, servletLoc != null, generateSubFile) : ImageEncoder.createImage(this, w, h, component, servletLoc != null, generateSubFile);
                if (originalColor != null) {
                    desktopArea.areaColor = originalColor;
                    desktopArea.setGradientEnabled(origGradientEnabled);
                }
                if (out != null) {
                    switch (format) {
                        case 1: 
                        case 9: {
                            if (format != 9) {
                                this.ch.resetXY();
                            }
                            if (this.ch.isBackgroundTransparent() && !this.ch.getbackgroundImageState()) {
                                GifEncoder gifEncoder = new GifEncoder(image, w, h, this.ch.getMinX(), this.ch.getMinY(), this.ch.getMaxX(), this.ch.getMaxY(), this.ch.desktopArea.areaColor.getRGB(), out);
                                gifEncoder.setTransparentColor(this.ch.desktopArea.areaColor);
                                gifEncoder.encode();
                                break;
                            }
                            new GifEncoder87a(image, w, h, this.ch.getMinX(), this.ch.getMinY(), this.ch.getMaxX(), this.ch.getMaxY(), this.ch.desktopArea.areaColor.getRGB()).write(out);
                            break;
                        }
                        case 7: {
                            if (IOUtil.isJava2D()) {
                                ImageEncoder.encode(ImageEncoder.ExportFormat.JPEG, image, out, quality);
                                break;
                            }
                            throw new Exception("Please include ExportLib.jar in your classpath");
                        }
                        case 2: {
                            new BMPEncoder(image).write(out);
                            break;
                        }
                        case 10: {
                            if (IOUtil.isJava2D()) {
                                ImageEncoder.encode(ImageEncoder.ExportFormat.PNG, image, out, quality, this.ch.isBackgroundTransparent());
                                break;
                            }
                            throw new Exception("Please include ExportLib.jar in your classpath");
                        }
                        default: {
                            int dtype;
                            int n = dtype = format == 6 ? 1 : 2;
                            if (ServerMessage.useServer || !ServerMessage.isLoadBalancer) {
                                IOUtil2.exportToServer(dtype, image, fileName, false, quality);
                            } else {
                                int width = image.getWidth(null);
                                int height = image.getHeight(null);
                                int[] buf = IOUtil.getImageBuffer(width, height, image);
                                ExportChart.nativeExport(dtype, buf, width, height, fileName, quality);
                            }
                            fileIsCreated = true;
                        }
                    }
                }
                if (format != 2 && subOut != null) {
                    if (this.ch.isFieldDrillDownEnabled() && servletLoc != null) {
                        String loc = this.ch.currentNode.getChildAt(0).getFileName();
                        this.createFieldDrillDownMap(subOut, subFileName, loc, servletLoc, argv);
                    } else if (servletLoc != null && chartLocation != null) {
                        this.createDrillDownMap(subOut, subFileName, chartLocation, servletLoc, pickData, argv);
                    } else if (generateSubFile || this.ch.getHyperLinkList() != null && this.ch.getHyperLinkList().size() > 0) {
                        this.createImageMap(subOut, subFileName);
                    }
                }
                if (image == null) break;
                image.flush();
                break;
            }
            case 13: {
                if ((ServerMessage.useServer || !ServerMessage.isLoadBalancer) && fileName != null) {
                    IOUtil2.exportToServer(13, this.ch, fileName, w, h, this.ch.flashFrameCount, this.ch.flashFrameRate);
                    fileIsCreated = true;
                    break;
                }
                try {
                    new PDFEncoder().export(this.ch, out, w, h);
                    break;
                }
                catch (ClassNotFoundException e) {
                    LOGGER.log(Level.SEVERE, "JAR file for PDF export not found", e);
                    throw new ClassNotFoundException("JAR file for PDF export not found.", e);
                }
            }
            case 18: {
                if ((ServerMessage.useServer || !ServerMessage.isLoadBalancer) && fileName != null) {
                    IOUtil2.exportToServer(18, this.ch, fileName, w, h, this.ch.flashFrameCount, this.ch.flashFrameRate);
                    fileIsCreated = true;
                    break;
                }
                new ExcelEncoder().export(this.ch, out, w, h);
                break;
            }
            default: {
                this.ch.setSize(w, h);
                SaveChart saveChart = new SaveChart(this.ch);
                saveChart.setDrillDownNode(this.ch.currentNode);
                if (out != null) {
                    DataOutputStream dout = new DataOutputStream(out);
                    saveChart.saveToDataOutput(dout, true);
                    dout.close();
                }
                if (subOut != null && generateSubFile && fileName != null) {
                    saveChart.createXMLChartFile(subOut, fileName + ".tpl");
                }
                this.ch.setSize(currentChartSize.width, currentChartSize.height);
            }
        }
        return fileIsCreated;
    }

    public Image createChartImage(int width, int height, Component component, boolean isGIFDrillDown, boolean generateSubFile) {
        Chart chart = this.ch;
        if (isGIFDrillDown) {
            if (chart.currentNode != null && chart.currentNode.getRoot().getChildCount() > 0) {
                CGraphics.fieldDrillDownMap = true;
            } else {
                CGraphics.drillDownMap = true;
            }
        }
        chart.imagemap = generateSubFile || this.ch.getHyperLinkList() != null && this.ch.getHyperLinkList().size() > 0;
        Image image = IOUtil.getOffScreenImage(chart, component, width, height);
        if (chart.isDataValid() && (isGIFDrillDown || chart.imagemap)) {
            this.createImageMapForFaceObject(chart, isGIFDrillDown);
        }
        chart.imagemap = false;
        CGraphics.drillDownMap = false;
        CGraphics.fieldDrillDownMap = false;
        return image;
    }

    public abstract void createImageMapForFaceObject(Chart var1, boolean var2);

    protected abstract void createImageMap(OutputStream var1, String var2) throws Exception;

    protected abstract void createDrillDownMap(OutputStream var1, String var2, String var3, String var4, PickData[] var5, String[] var6) throws Exception;

    protected abstract void createFieldDrillDownMap(OutputStream var1, String var2, String var3, String var4, String[] var5) throws Exception;

    public static void nativeExport(int dtype, int[] buffer, int width, int height, String filename, int quality) throws IOException {
        INativeExport exportObj;
        try {
            Class<?> exportClass = Class.forName("quadbase.chart.NativeExport");
            exportObj = (INativeExport)exportClass.newInstance();
        }
        catch (Exception ee) {
            LOGGER.log(Level.SEVERE, "Native export failed! Please make sure this version of EspressChart supports native export.", ee);
            throw new IOException("Native export failed! Please make sure this version of EspressChart supports native export.\n" + ee);
        }
        exportObj.nativeExport(dtype, buffer, width, height, filename, quality);
    }

    public Chart getChart() {
        return this.ch;
    }
}

