/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import quadbase.common.util.internal.DataType;

public class FilterInfo {
    int size;
    int[] dataType;
    int[] compareOp;
    int[] colIndex;
    Object[] value;

    public FilterInfo(int[] dataType, int[] compareOp, int[] colIndex, Object[] value) {
        this.size = dataType.length;
        this.dataType = dataType;
        this.compareOp = compareOp;
        this.colIndex = colIndex;
        this.value = value;
    }

    public int getSize() {
        return this.size;
    }

    public int[] getDataType() {
        return this.dataType;
    }

    public int[] getCompareOp() {
        return this.compareOp;
    }

    public int[] getColIndex() {
        return this.colIndex;
    }

    public Object[] getValue() {
        return this.value;
    }

    public void writeAsStream(DataOutput dout) throws IOException {
        int size = this.getSize();
        dout.writeInt(size);
        for (int i = 0; i < size; ++i) {
            dout.writeInt(this.dataType[i]);
            dout.writeInt(this.compareOp[i]);
            dout.writeInt(this.colIndex[i]);
            DataType.write(dout, this.value[i]);
        }
    }

    public static FilterInfo readAsStream(DataInput din, int version) throws IOException {
        int size = din.readInt();
        int[] dataType = new int[size];
        int[] compareOp = new int[size];
        int[] colIndex = new int[size];
        Object[] value = new Object[size];
        for (int i = 0; i < size; ++i) {
            int type;
            dataType[i] = type = din.readInt();
            compareOp[i] = din.readInt();
            colIndex[i] = din.readInt();
            value[i] = DataType.read(din, type, version, true);
        }
        return new FilterInfo(dataType, compareOp, colIndex, value);
    }
}

