/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import quadbase.chart.CAnnotation;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.DataLine;
import quadbase.util.IFunction;
import quadbase.util.IFunctionLine;
import quadbase.util.Point_2D;
import quadbase.util.Position;

public class FunctionLine
extends DataLine
implements IFunctionLine {
    protected IFunction function;

    public FunctionLine(Chart chart, IFunction function, String title) {
        this.chart = chart;
        this.linetype = 16;
        this.function = function;
        this.title = title;
    }

    public FunctionLine(Chart newChart, FunctionLine fline) {
        int nAnno;
        this.chart = newChart;
        this.function = fline.function;
        this.linetype = fline.linetype;
        this.title = fline.title;
        this.thickness = fline.thickness;
        this.color = fline.color;
        this.hideTitle = fline.hideTitle;
        this.showValue = fline.showValue;
        this.valueHint = fline.valueHint;
        Vector targetVector = fline.annoVector;
        int n = nAnno = targetVector == null ? 0 : targetVector.size();
        if (nAnno > 0) {
            this.annoVector = new Vector();
            for (int i = 0; i < nAnno; ++i) {
                CAnnotation tempAnno = ((CAnnotation)targetVector.elementAt(i)).copy(newChart);
                tempAnno.setReferenceObject(this);
                this.annoVector.addElement(tempAnno);
            }
        }
    }

    @Override
    public Object clone() {
        return new FunctionLine(this.chart, this);
    }

    @Override
    protected String getShortName(int linetype) {
        return "Function Line";
    }

    @Override
    public final void setColor(Color color) {
        this.color = color;
    }

    @Override
    public final void setFunction(IFunction func) {
        this.function = func;
    }

    @Override
    public final IFunction getFunction() {
        return this.function;
    }

    @Override
    public void compute() {
    }

    protected Point_2D getAbsPosition() {
        return null;
    }

    @Override
    protected void drawLine(CGraphics g) {
    }

    @Override
    public void prepare3DLine() {
    }

    @Override
    public void setLineType(int dtype) {
    }

    @Override
    public void setCoeff(int coeff) {
    }

    @Override
    public boolean invalidchart() {
        return !this.chart.is2DChart || !Chart.isCoordinateType(this.chart.chartType);
    }

    @Override
    protected void fillLine(CGraphics g, int x1, int y1, int x2, int y2, int thickness) {
    }

    @Override
    public Position getReferencePosition() {
        return null;
    }

    @Override
    protected void write(DataOutput dout) throws IOException {
    }

    @Override
    protected void read(DataInput din, int version) throws IOException {
    }
}

