/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.util.Date;
import quadbase.chart.CGraphics;
import quadbase.chart.Point3D;

public abstract class Grid {
    public Color color = Color.black;
    public Point3D[] coord;
    public int max;
    public int min;
    public int orient;
    public boolean bshow;
    protected double gridLine2DRatio = 1.0;

    public Grid(int direction, boolean showgrid) {
        this.orient = direction;
        this.bshow = showgrid;
    }

    public void set(Point3D[] p, int minp, int maxp) {
        this.coord = p;
        this.max = maxp;
        this.min = minp;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public abstract boolean select(CGraphics var1, int var2, int var3);

    public abstract void set(Object var1, Point3D[] var2, int var3, int var4);

    public abstract void draw(CGraphics var1, boolean var2, boolean var3, int var4);

    public abstract void draw(CGraphics var1, int var2, boolean var3, int var4);

    public abstract void draw(CGraphics var1, int var2, boolean var3, int var4, int var5);

    public abstract void draw(CGraphics var1, int var2, boolean var3, int var4, int var5, boolean var6);

    public abstract void draw(CGraphics var1, int var2, int var3, int var4, boolean var5, Date var6, int var7, Object[] var8);

    public abstract void draw(CGraphics var1, int var2, int var3, int var4, int var5, boolean var6, Date var7, int var8, Object[] var9);

    public Grid copy(Grid g) {
        g.color = this.color;
        if (this.coord != null) {
            Point3D[] newPoint = new Point3D[this.coord.length];
            System.arraycopy(this.coord, 0, newPoint, 0, this.coord.length);
            g.coord = newPoint;
        }
        g.max = this.max;
        g.min = this.min;
        g.gridLine2DRatio = this.gridLine2DRatio;
        return g;
    }

    public void setGridLine2DRatio(double ratio) {
        if (ratio < 0.0) {
            ratio = 0.0;
        }
        if (ratio > 1.0) {
            ratio = 1.0;
        }
        this.gridLine2DRatio = ratio;
    }

    public double getGridLine2DRatio() {
        return this.gridLine2DRatio;
    }
}

