/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.sql.Date;
import quadbase.chart.ColData;
import quadbase.chart.HiLowMap;
import quadbase.util.IFormat;
import quadbase.util.PickData;

public class HiLowData {
    public static final double SpecNo = -1.7976931348623157E308;
    public double vhi = -1.7976931348623157E308;
    public double vlow = -1.7976931348623157E308;
    public double vclose = -1.7976931348623157E308;
    public double vopen = -1.7976931348623157E308;

    public HiLowData() {
    }

    public HiLowData(double vhi, double vlow, double vopen, double vclose) {
        this.vhi = vhi;
        this.vlow = vlow;
        this.vopen = vopen;
        this.vclose = vclose;
    }

    public double max() {
        double l;
        double d = l = this.vhi > this.vlow ? this.vhi : this.vlow;
        if (this.vclose != -1.7976931348623157E308 && this.vclose > l) {
            l = this.vclose;
        }
        if (this.vopen != -1.7976931348623157E308 && this.vopen > l) {
            l = this.vopen;
        }
        return l;
    }

    public double min() {
        double s;
        double d = s = this.vhi > this.vlow ? this.vlow : this.vhi;
        if (this.vclose != -1.7976931348623157E308 && this.vclose < s) {
            s = this.vclose;
        }
        if (this.vopen != -1.7976931348623157E308 && this.vopen < s) {
            s = this.vopen;
        }
        return s;
    }

    public double getcloseValue() {
        return this.vclose != -1.7976931348623157E308 ? this.vclose : this.vhi;
    }

    public void setpick(PickData pd, IFormat dataFormat, ColData[] cdata, HiLowMap map, boolean isGantt) {
        pd.vhigh = this.vhi;
        pd.vlow = this.vlow;
        pd.vopen = this.vopen;
        pd.vclose = this.vclose;
        pd.s_vhigh = dataFormat != null ? dataFormat.format(this.vhi) : this.vhi + "";
        pd.s_vlow = dataFormat != null ? dataFormat.format(this.vlow) : this.vlow + "";
        pd.high_name = cdata[map.hi].getName();
        pd.low_name = cdata[map.low].getName();
        if (map.open < 0) {
            pd.vopen = -1.7976931348623157E308;
        }
        if (map.close < 0) {
            pd.vclose = -1.7976931348623157E308;
        }
        if (pd.vopen != -1.7976931348623157E308) {
            pd.s_vopen = dataFormat != null ? dataFormat.format(this.vopen) : this.vopen + "";
            pd.open_name = cdata[map.open].getName();
        } else {
            pd.open_name = null;
            pd.s_vopen = null;
        }
        if (pd.vclose != -1.7976931348623157E308) {
            pd.s_vclose = dataFormat != null ? dataFormat.format(this.vclose) : this.vclose + "";
            pd.close_name = cdata[map.close].getName();
        } else {
            pd.close_name = null;
            pd.s_vclose = null;
        }
        if (isGantt) {
            pd.venddate = (long)this.vhi;
            pd.vstartdate = (long)this.vlow;
            pd.s_vstartdate = dataFormat != null ? dataFormat.format(new Date((long)this.vlow)) : new Date((long)this.vlow).toString();
            pd.s_venddate = dataFormat != null ? dataFormat.format(new Date((long)this.vhi)) : new Date((long)this.vhi).toString();
            pd.startdateName = cdata[map.low].getName();
            pd.enddateName = cdata[map.hi].getName();
        }
    }
}

