/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import quadbase.chart.CAnnotation;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.DataLine;
import quadbase.util.IHorzVertLine;
import quadbase.util.Point_2D;
import quadbase.util.Position;
import quadbase.util.internal.IOUtil;

public abstract class HorzVertLine
extends DataLine
implements IHorzVertLine {
    Color colorBelowLine = null;
    Color colorAboveLine = null;
    public static int[] linetypeMap = new int[]{14, 15};
    public static final String[] defaultNames = new String[]{"Horizontal line", "Vertical line"};
    protected static final String[] shortName = new String[]{"Horz", "Vert"};

    public static boolean isHorzVertLine(int linetype) {
        boolean result = false;
        for (int element : linetypeMap) {
            if (element != linetype % 100) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    protected String getShortName(int linetype) {
        String result = "";
        for (int i = 0; i < linetypeMap.length; ++i) {
            if (linetypeMap[i] != linetype % 100) continue;
            result = shortName[i];
            break;
        }
        return result;
    }

    public HorzVertLine(Chart chart) {
        this.chart = chart;
        this.linetype = 14;
        this.coeff = 1;
    }

    protected HorzVertLine(Chart newChart, HorzVertLine hvLine) {
        int nAnno;
        this.chart = newChart;
        this.linetype = hvLine.linetype;
        this.coeff = 1;
        this.title = hvLine.title;
        this.thickness = hvLine.thickness;
        this.hlco_value = hvLine.hlco_value;
        this.color = hvLine.color;
        this.hideTitle = hvLine.hideTitle;
        this.useSubvalue = hvLine.useSubvalue;
        this.useAxis = hvLine.useAxis;
        this.line_value = hvLine.line_value;
        this.showValue = hvLine.showValue;
        this.valueHint = hvLine.valueHint;
        this.lineStyle = hvLine.lineStyle;
        this.colorBelowLine = hvLine.colorBelowLine;
        this.colorAboveLine = hvLine.colorAboveLine;
        int n = nAnno = hvLine.annoVector == null ? 0 : hvLine.annoVector.size();
        if (nAnno > 0) {
            this.annoVector = new Vector();
            for (int i = 0; i < nAnno; ++i) {
                CAnnotation tempAnno = ((CAnnotation)hvLine.annoVector.elementAt(i)).copy(newChart);
                tempAnno.setReferenceObject(this);
                this.annoVector.addElement(tempAnno);
            }
        }
    }

    @Override
    public Object clone() {
        HorzVertLine newLine = this.chart.dataLineSet.newHorzVertLine(this);
        if (newLine.annoVector != null) {
            int nAnno = newLine.annoVector.size();
            for (int i = 0; i < nAnno; ++i) {
                ((CAnnotation)newLine.annoVector.elementAt(i)).setReferenceObject(newLine);
            }
        }
        return newLine;
    }

    public HorzVertLine(Chart chart, int linetype, String title) {
        this.chart = chart;
        this.linetype = linetype;
        this.title = title;
        this.coeff = 1;
    }

    @Override
    public final void setCoeff(int coeff) {
    }

    @Override
    public final void setLineType(int linetype) {
        this.linetype = linetype;
    }

    @Override
    public final void setColorAboveLine(Color color) {
        this.colorAboveLine = color;
    }

    @Override
    public final Color getColorAboveLine() {
        return this.colorAboveLine;
    }

    @Override
    public final void setColorBelowLine(Color color) {
        this.colorBelowLine = color;
    }

    @Override
    public final Color getColorBelowLine() {
        return this.colorBelowLine;
    }

    public static boolean invalidchart(Chart chart) {
        return chart.isCircularChart() || chart.chartType == 17 || chart.chartType == 19;
    }

    @Override
    public boolean invalidchart() {
        return this.chart.isCircularChart() || this.chart.chartType == 17 || this.chart.chartType == 19;
    }

    @Override
    public void compute() {
        if (this.invalidchart()) {
            return;
        }
        this.makeTitle();
    }

    private void setTickerPosition() {
        if (this.chart.a_y.ticker == null || this.chart.a_x.ticker == null) {
            if (this.chart.cgraphics == null) {
                this.chart.cgraphics = new CGraphics(null, this.chart.component, this.chart.winHeight, this.chart.winWidth, this.chart);
            }
            this.chart.computeCoord(this.chart.cgraphics, this.chart.chartxorigin, this.chart.chartxorigin + this.chart.chartwidth, this.chart.chartyorigin, this.chart.chartheight + this.chart.chartyorigin);
        }
    }

    public int getPixelValue() {
        if (this.chart.mData2 == null && this.chart.chartType != 14) {
            this.useSubvalue = false;
        }
        int pixelValue = 0;
        if (this.showHorzLine()) {
            if (!HorzVertLine.isBarChartType(this.chart) || this.chart.chartType == 2 || this.chart.chartType == 19 || this.chart.chartType == 12 || this.chart.chartType == 13) {
                pixelValue = this.getHortLineYPixel();
            } else {
                this.setTickerPosition();
                pixelValue = this.getHortLineYPixel2();
            }
        } else if (this.showVertLine()) {
            if (HorzVertLine.isBarChartType(this.chart) || this.chart.chartType == 2 || this.chart.chartType == 19 || this.chart.chartType == 12 || this.chart.chartType == 13) {
                pixelValue = this.getVertLineXPixel();
            } else {
                this.setTickerPosition();
                pixelValue = this.getVertLineXPixel2();
            }
        }
        return pixelValue;
    }

    @Override
    void fillLine(CGraphics g, int x1, int y1, int x2, int y2, int thickness) {
        g.fillLine(x1, y1, x2, y2, thickness, this.lineStyle);
        if (y1 == y2) {
            this.chart.hLineX1 = x1;
            this.chart.hLineX2 = x2;
            this.chart.hLineY = y1;
        }
    }

    public boolean showHorzLine() {
        return this.chart.chartType == 16 || this.linetype % 100 == 14;
    }

    public boolean showVertLine() {
        return this.linetype % 100 == 15 && this.chart.chartType != 16;
    }

    protected abstract Point_2D getAbsPosition();

    @Override
    public Position getReferencePosition() {
        int x = 0;
        int y = 0;
        Point_2D absPos = this.getAbsPosition();
        x = (int)absPos.getX();
        y = (int)absPos.getY();
        float refPosX = (float)x / (float)this.chart.winWidth;
        float refPosY = (float)y / (float)this.chart.winHeight;
        if (refPosX < 0.0f) {
            refPosX = 0.0f;
        } else if (refPosX > 1.0f) {
            refPosX = 1.0f;
        }
        if (refPosY < 0.0f) {
            refPosY = 0.0f;
        } else if (refPosY > 1.0f) {
            refPosY = 1.0f;
        }
        return new Position(refPosX, refPosY);
    }

    @Override
    protected void write(DataOutput dout) throws IOException {
        boolean isColorBelowDefined = this.colorBelowLine != null;
        dout.writeBoolean(isColorBelowDefined);
        if (isColorBelowDefined) {
            IOUtil.writeColor(dout, this.colorBelowLine);
        }
        boolean isColorAboveDefined = this.colorAboveLine != null;
        dout.writeBoolean(isColorAboveDefined);
        if (isColorAboveDefined) {
            IOUtil.writeColor(dout, this.colorAboveLine);
        }
    }

    @Override
    protected void read(DataInput din, int version) throws IOException {
        if (version >= 91) {
            boolean isColorAboveDefined;
            boolean isColorBelowDefined = din.readBoolean();
            if (isColorBelowDefined) {
                this.colorBelowLine = IOUtil.readColor(din);
            }
            if (isColorAboveDefined = din.readBoolean()) {
                this.colorAboveLine = IOUtil.readColor(din);
            }
        }
    }
}

