/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Image;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.Time;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Area;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.HiLowData;
import quadbase.chart.Point3D;
import quadbase.chart.PropCString;
import quadbase.chart.SaveChart;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.util.SimpleSpreadSheet;
import quadbase.util.StreamResultSet;
import quadbase.util.internal.IOUtil;

public final class IOUtil2 {
    private static final Logger LOGGER = Logger.getLogger(IOUtil2.class.getName());

    public static final void writeCString(DataOutput out, CString str) throws IOException {
        IOUtil.writeString(out, str.str);
        IOUtil.writeFont(out, str.font);
        IOUtil2.writePoint3D(out, str.pos);
        IOUtil.writeColor(out, str.color);
        out.writeInt(str.direction);
        out.writeDouble(str.angle);
        out.writeBoolean(str.bshow);
        out.writeInt(str.placement);
        out.writeBoolean(str.automatic);
    }

    public static final void writePropCString(DataOutput out, PropCString str) throws IOException {
        IOUtil.writeString(out, str.str);
        out.writeFloat(str.xprop);
        out.writeFloat(str.yprop);
        IOUtil.writeFont(out, str.font);
        IOUtil.writeColor(out, str.color);
        out.writeInt((int)str.angle);
    }

    public static final PropCString readPropCString(DataInput in, boolean isUTF) throws IOException {
        return new PropCString(IOUtil.readString(in, isUTF), in.readFloat(), in.readFloat(), IOUtil.readFont(in, isUTF), IOUtil.readColor(in), in.readInt());
    }

    public static final CString readCString(DataInput in, boolean isUTF) throws IOException {
        CString s = new CString(IOUtil.readString(in, isUTF), IOUtil.readFont(in, isUTF), IOUtil2.readPoint3D(in), IOUtil.readColor(in), in.readInt(), in.readDouble());
        s.bshow = in.readBoolean();
        s.placement = in.readInt();
        s.automatic = in.readBoolean();
        return s;
    }

    public static final void writeArea(DataOutput out, Area area) throws IOException {
        IOUtil.writeColor(out, area.areaColor);
        out.writeBoolean(area.drawBorder);
        out.writeBoolean(area.drawArea);
        out.writeBoolean(area.automatic);
        IOUtil2.writePoint3D(out, area.p1);
        IOUtil2.writePoint3D(out, area.p2);
        VersioningDataOutput vOut = (VersioningDataOutput)out;
        vOut.writeBoolean(area.isGradientEnabled(), (short)4103);
        vOut.writeBoolean(area.is3DShadingEnabled(), (short)4103);
        vOut.writeDouble(area.getGradientStartX(), (short)4103);
        vOut.writeDouble(area.getGradientStartY(), (short)4103);
        vOut.writeDouble(area.getGradientEndX(), (short)4103);
        vOut.writeDouble(area.getGradientEndY(), (short)4103);
        vOut.writeBoolean(area.getGradientDesColor() != null, (short)4103);
        if (area.getGradientDesColor() != null) {
            IOUtil.writeColor(vOut, area.getGradientDesColor(), (short)4103);
        }
        vOut.writeInt(area.getGradientShade(), (short)4103);
        vOut.writeBoolean(area.isGradientCyclic(), (short)4103);
    }

    public static final void writePoint3D(DataOutput out, Point3D p) throws IOException {
        out.writeInt(p.x);
        out.writeInt(p.y);
        out.writeInt(p.z);
        out.writeInt(p.shape);
        IOUtil.writeColor(out, p.color);
        out.writeBoolean(p.automatic);
    }

    public static final Point3D readPoint3D(DataInput in) throws IOException {
        Point3D p = new Point3D(in.readInt(), in.readInt(), in.readInt());
        p.shape = in.readInt();
        p.color = IOUtil.readColor(in);
        p.automatic = in.readBoolean();
        return p;
    }

    public static final Area readArea(DataInput in, int version, Chart ch) throws IOException {
        Area area = ch.newArea();
        area.areaColor = IOUtil.readColor(in);
        if (version < 26) {
            IOUtil.readColor(in);
        }
        area.drawBorder = in.readBoolean();
        area.drawArea = in.readBoolean();
        area.automatic = in.readBoolean();
        area.p1 = IOUtil2.readPoint3D(in);
        area.p2 = IOUtil2.readPoint3D(in);
        if (version <= 7099 && version >= 4103) {
            area.setGradientEnabled(in.readBoolean());
            area.set3DShadingEnabled(in.readBoolean());
            area.setGradientStartX(in.readDouble());
            area.setGradientStartY(in.readDouble());
            area.setGradientEndX(in.readDouble());
            area.setGradientEndY(in.readDouble());
            if (in.readBoolean()) {
                area.setGradientDesColor(IOUtil.readColor(in));
            }
            area.setGradientShade(in.readInt());
            area.setGradientCyclic(in.readBoolean());
        }
        return area;
    }

    public static void exportToServer(int dtype, Image image, String filename, boolean url, int quality) throws Exception {
        boolean absolutePath;
        if ((filename = filename.replace('\\', '/')).startsWith("file:/")) {
            absolutePath = true;
            if ((filename = filename.substring(6)).startsWith("//") || filename.startsWith("/") && filename.indexOf(":/") >= 0) {
                filename = filename.substring(1);
            }
        } else if (filename.startsWith("http:/") || filename.startsWith("https:/")) {
            absolutePath = false;
        } else {
            boolean bl = absolutePath = filename.startsWith("/") || filename.indexOf(":/") >= 0;
        }
        if (!absolutePath) {
            filename = IOUtil.extractHostPath(filename, ServerMessage.getApplet());
        }
        IConnection socket = ServerMessage.createConnection();
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream();
            DataOutputStream dsout = new DataOutputStream(bstream);
            dsout.writeShort(29203);
            dsout.writeBoolean(false);
            IOUtil.writeString(dsout, filename);
            dsout.writeInt(quality);
            dsout.writeBoolean(absolutePath);
            int width = image.getWidth(null);
            dsout.writeInt(width);
            int height = image.getHeight(null);
            dsout.writeInt(height);
            dsout.writeInt(dtype);
            dsout.writeBoolean(url);
            dsout.flush();
            int size = width * height;
            int[] buffer = IOUtil.getImageBuffer(width, height, image);
            byte[] array = bstream.toByteArray();
            socket.setContentLength(buffer.length * 4 + array.length);
            socket.getOutputStream().write(array);
            BufferedOutputStream bs = new BufferedOutputStream(socket.getOutputStream(), 1024);
            DataOutputStream out = new DataOutputStream(bs);
            int i = 0;
            while (i < size) {
                out.writeInt(buffer[i++]);
            }
            bs.flush();
            DataInputStream din = new DataInputStream(socket.getInputStream());
            String errMessage = IOUtil2.getErrorString(din.readInt());
            String reason = IOUtil.readString(din, true);
            socket.close();
            if (errMessage != null) {
                throw new IOException(errMessage + "\n" + reason);
            }
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINE, "Failed to close socket", ex2);
            }
            LOGGER.log(Level.SEVERE, "Failed to export image", ex);
            throw ex;
        }
    }

    public static void exportToServer(int dtype, Chart chart, String filename, int width, int height) throws Exception {
        IOUtil2.exportToServer(dtype, chart, filename, width, height, chart.flashFrameCount, chart.flashFrameRate);
    }

    public static void exportToServer(int dtype, Chart chart, String filename, int width, int height, int flashFrameCount, float flashFrameRate) throws Exception {
        boolean absolutePath;
        if ((filename = filename.replace('\\', '/')).startsWith("file:/")) {
            absolutePath = true;
            if ((filename = filename.substring(6)).startsWith("//") || filename.startsWith("/") && filename.indexOf(":/") >= 0) {
                filename = filename.substring(1);
            }
        } else if (filename.startsWith("http:/") || filename.startsWith("https:/")) {
            absolutePath = false;
        } else {
            boolean bl = absolutePath = filename.startsWith("/") || filename.indexOf(":/") >= 0;
        }
        if (!absolutePath) {
            filename = IOUtil.extractHostPath(filename, ServerMessage.getApplet());
        }
        IConnection socket = ServerMessage.createConnection();
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream();
            DataOutputStream dsout = new DataOutputStream(bstream);
            dsout.writeShort(29302);
            dsout.writeBoolean(false);
            IOUtil.writeString(dsout, filename);
            dsout.writeBoolean(absolutePath);
            dsout.writeInt(dtype);
            dsout.writeInt(width);
            dsout.writeInt(height);
            dsout.writeInt(flashFrameCount);
            dsout.writeFloat(flashFrameRate);
            byte[] buffer = IOUtil2.exportChartToByteArray(chart);
            dsout.flush();
            byte[] array = bstream.toByteArray();
            socket.setContentLength(buffer.length + array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().write(buffer);
            DataInputStream din = new DataInputStream(socket.getInputStream());
            String errMessage = IOUtil2.getErrorString(din.readInt());
            String reason = IOUtil.readString(din, true);
            socket.close();
            if (errMessage != null) {
                throw new IOException(errMessage + "\n" + reason);
            }
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.INFO, "Failed to close socket", ex2);
            }
            LOGGER.log(Level.SEVERE, "Failed to export flash chart", ex);
            throw ex;
        }
    }

    public static final String getErrorString(int code) {
        String scode;
        if (code == 0) {
            return null;
        }
        switch (code) {
            case 5: {
                scode = "Access Denied.";
                break;
            }
            case 2: {
                scode = "Server out of memory.\n Please try again later.";
                break;
            }
            case 1: 
            case 3: {
                scode = "";
                break;
            }
            case 4: {
                scode = "Too many users logged onto the server. \n Please try again later.";
                break;
            }
            default: {
                scode = LanguageEncoder.getText("Unknown error code") + " " + code + "!";
            }
        }
        return scode;
    }

    public static ColData[] getColData(String s) throws Exception {
        String s2 = "";
        boolean outside = true;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                outside = !outside;
            } else if (c == '|' && outside) {
                c = '\n';
            }
            s2 = s2 + c;
        }
        StreamTokenizer st = new StreamTokenizer(new StringReader(s2));
        return IOUtil2.readRecord(st);
    }

    public static ColData[] readRecord(StreamTokenizer st) throws Exception {
        st.eolIsSignificant(true);
        Vector vec1 = new Vector();
        do {
            if (StreamResultSet.readLine(st, vec1, true) != 0) continue;
            throw new IOException("Premature EOF encountered when reading column types!");
        } while (vec1.size() == 0);
        if (IOUtil2.isTypeHeader(vec1)) {
            return IOUtil2.readColumnFormat(st, vec1);
        }
        return IOUtil2.readSpreadSheetFormat(st, vec1);
    }

    private static boolean isTypeHeader(Vector vec1) {
        int nCol = vec1.size();
        for (int i = 0; i < nCol; ++i) {
            Object current = vec1.elementAt(i);
            if (current instanceof Number) {
                return false;
            }
            try {
                DataType.findType((String)current);
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Invalid type name", ex);
                return false;
            }
        }
        return true;
    }

    private static ColData[] readColumnFormat(StreamTokenizer st, Vector vec1) throws Exception {
        int i;
        Vector vec2 = new Vector();
        do {
            if (StreamResultSet.readLine(st, vec2, false) != 0) continue;
            throw new IOException("Premature EOF encountered when reading column names!");
        } while (vec2.size() == 0);
        int nCol = vec1.size();
        if (vec2.size() != nCol) {
            throw new IOException("The number of column names must be = " + nCol);
        }
        ColData[] colData = new ColData[nCol + 1];
        for (i = 0; i < nCol; ++i) {
            colData[i] = new ColData((String)vec2.elementAt(i), DataType.findType((String)vec1.elementAt(i)), colData.length);
        }
        while (!ServerMessage.exceedLimit(colData[0].getSize()) && StreamResultSet.readLine(st, vec1, true) == 1) {
            if (vec1.size() == 0) continue;
            if (vec1.size() != nCol) {
                throw new IOException("Insufficient fields for record on line " + st.lineno());
            }
            for (i = 0; i < nCol; ++i) {
                colData[i].add(StreamResultSet.createObject(colData[i].getDataType(), vec1.elementAt(i), st));
            }
        }
        colData[nCol] = new ColData("qbCount", 4, colData.length);
        for (i = 0; i < colData[0].getSize(); ++i) {
            colData[nCol].add(i);
        }
        return colData;
    }

    private static ColData[] readSpreadSheetFormat(StreamTokenizer st, Vector vec1) throws Exception {
        int i;
        int currentType;
        Vector<Object> columnHeaderObject = new Vector<Object>();
        Object temp = DataType.makeDefaultObject(vec1.elementAt(0));
        int columnHeaderType = DataType.findType(temp);
        columnHeaderObject.addElement(temp);
        int nCol = vec1.size();
        for (int i2 = 1; i2 < nCol; ++i2) {
            temp = DataType.makeDefaultObject(vec1.elementAt(i2));
            currentType = DataType.findType(temp);
            if (currentType != columnHeaderType) {
                throw new IllegalArgumentException("All values on the column header must use the same data type.\nThe first column header type detected is " + DataType.getTypeName(columnHeaderType) + ", but the type of " + temp + " is " + DataType.getTypeName(currentType) + ".");
            }
            columnHeaderObject.addElement(temp);
        }
        Vector[] arrayBuffer = new Vector[nCol];
        for (int i3 = 0; i3 < nCol; ++i3) {
            arrayBuffer[i3] = new Vector();
        }
        Vector<Object> rowHeaderObject = new Vector<Object>();
        int rowHeaderType = 14;
        Vector rowBuffer = new Vector();
        while (StreamResultSet.readLine(st, rowBuffer, true) == 1) {
            if (rowBuffer.size() == 0) continue;
            if (rowBuffer.size() != nCol + 1) {
                throw new IOException("Insufficient fields for record on line " + st.lineno());
            }
            temp = DataType.makeDefaultObject(rowBuffer.elementAt(0));
            if (rowHeaderType == 14) {
                rowHeaderType = DataType.findType(temp);
            } else {
                currentType = DataType.findType(temp);
                if (currentType != rowHeaderType) {
                    throw new IllegalArgumentException("All values on the row header must have the same data type.\nThe first row header type detected is " + DataType.getTypeName(rowHeaderType) + ", but the type of " + temp + " is " + DataType.getTypeName(currentType) + ".");
                }
            }
            rowHeaderObject.addElement(temp);
            for (i = 1; i <= nCol; ++i) {
                temp = DataType.makeDefaultObject(rowBuffer.elementAt(i));
                int arrayDataType = DataType.mapType(DataType.findType(temp));
                if (!DataType.isNumeric(arrayDataType) || arrayDataType == 0) {
                    throw new IllegalArgumentException("All values in the array must be numeric");
                }
                arrayBuffer[i - 1].addElement(temp);
            }
        }
        Object[] columnHeaderArray = new Object[nCol];
        for (i = 0; i < nCol; ++i) {
            columnHeaderArray[i] = columnHeaderObject.elementAt(i);
        }
        int nRow = rowHeaderObject.size();
        Object[] rowHeaderArray = new Object[nRow];
        for (int i4 = 0; i4 < nRow; ++i4) {
            rowHeaderArray[i4] = rowHeaderObject.elementAt(i4);
        }
        Object[][] valueArray = new Object[nRow][nCol];
        for (int i5 = 0; i5 < nRow; ++i5) {
            for (int j = 0; j < nCol; ++j) {
                temp = arrayBuffer[j].elementAt(i5);
                valueArray[i5][j] = temp instanceof Double ? temp : Double.valueOf(((Number)temp).doubleValue());
            }
        }
        SimpleSpreadSheet sss = new SimpleSpreadSheet(rowHeaderArray, columnHeaderArray, valueArray);
        return ColData.getColData(sss);
    }

    public static final double getValue(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof Boolean) {
            if (((Boolean)obj).booleanValue()) {
                return 1.0;
            }
            return 0.0;
        }
        if (obj instanceof Time) {
            int offset = TimeZone.getDefault().getOffset(0L);
            return ((Time)obj).getTime() + (long)offset;
        }
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        if (obj instanceof HiLowData) {
            return ((HiLowData)obj).getcloseValue();
        }
        return 0.0;
    }

    public static final byte[] exportChartToByteArray(Chart chart) throws Exception {
        SaveChart saveChart = new SaveChart(chart);
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        saveChart.saveToDataOutput(out, false);
        out.close();
        fstream.close();
        return fstream.toByteArray();
    }
}

