/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import java.util.logging.Logger;
import quadbase.chart.ImageMapNode;
import quadbase.common.awt.Arc;
import quadbase.common.util.internal.QbUtil;

public class ImageMap {
    private static final Logger LOGGER = Logger.getLogger(ImageMap.class.getName());
    protected Vector vec;
    protected String name;

    public ImageMap(String name, Vector vec) {
        int idx = name.lastIndexOf(47);
        if (idx < 0) {
            idx = name.lastIndexOf(92);
        }
        this.name = idx > 0 ? name.substring(idx + 1) : name;
        this.vec = vec;
    }

    public void write(OutputStream out) {
        PrintWriter writer = new PrintWriter(out, true);
        this.exportMap(writer);
        writer.close();
    }

    public void exportMap(PrintWriter out) {
        if (this.vec != null) {
            out.println("<MAP NAME=\"" + this.name + "\">");
            for (int i = this.vec.size() - 1; i >= 0; --i) {
                ImageMapNode node = (ImageMapNode)this.vec.elementAt(i);
                String nodeLink = null;
                if (node.link == "") {
                    nodeLink = "title=\"" + QbUtil.removeUnsafeChars(node.hint) + "\" alt=\"" + QbUtil.removeUnsafeChars(node.hint) + "\"";
                } else {
                    String target = "";
                    if (node.link != null && !node.link.startsWith("javascript:")) {
                        target = node.target;
                    }
                    nodeLink = "target=\"" + target + "\" href=\"" + QbUtil.tokenizeAndEscapeGETParameters(node.link) + "\" title=\"" + QbUtil.removeUnsafeChars(node.hint) + "\" alt=\"" + QbUtil.removeUnsafeChars(node.hint) + "\"";
                }
                if (this.isInstanceofFace(node, nodeLink, out)) continue;
                if (node.obj instanceof Rectangle) {
                    Rectangle r = (Rectangle)node.obj;
                    out.println("<area " + nodeLink + " shape=\"rect\" coords=\"" + r.x + "," + r.y + "," + (r.x + r.width) + "," + (r.y + r.height) + "\"/>");
                    continue;
                }
                if (node.obj instanceof Polygon) {
                    int j;
                    Polygon p = (Polygon)node.obj;
                    out.print("<area " + nodeLink + " shape=\"poly\" coords=\"");
                    for (j = 0; j < p.npoints - 1; ++j) {
                        out.print(p.xpoints[j] + "," + p.ypoints[j] + ",");
                    }
                    out.print(p.xpoints[j] + "," + p.ypoints[j]);
                    out.println("\"/>");
                    continue;
                }
                if (node.obj instanceof Arc) {
                    Arc ar = (Arc)node.obj;
                    if (ar.angle < 360) {
                        this.outputArc(out, nodeLink, ar.x, ar.y, ar.w / 2, ar.h / 2, (double)ar.startangle * Math.PI / 180.0, (double)(ar.startangle + ar.angle) * Math.PI / 180.0, ar.arcLen);
                        continue;
                    }
                    out.println("<area " + nodeLink + " shape=\"circle\" coords=\"" + ar.x + "," + ar.y + "," + Math.max(ar.w, ar.h) / 2 + "\"/>");
                    continue;
                }
                LOGGER.warning("Unknown object" + node.obj);
            }
            out.println("</MAP>");
            out.flush();
        }
    }

    protected boolean isInstanceofFace(ImageMapNode node, String nodeLink, PrintWriter out) {
        return false;
    }

    private void outputArc(PrintWriter out, String nodeLink, int x, int y, int w, int h, double angle1, double angle2, int arcLen) {
        int x1 = x + (int)((double)w * Math.cos(angle1));
        int y1 = y - (int)((double)h * Math.sin(angle1));
        int x2 = x + (int)((double)w * Math.cos(angle2));
        int y2 = y - (int)((double)h * Math.sin(angle2));
        if ((y1 - y2) * (y1 - y2) + (x1 - x2) * (x1 - x2) < 400) {
            if (arcLen == 100) {
                out.println("<area " + nodeLink + " shape=poly coords=\"" + x + "," + y + "," + x2 + "," + y2 + "," + x1 + "," + y1 + "\">");
            } else {
                int x3 = x + (int)((double)(w * (100 - arcLen) / 100) * Math.cos(angle2));
                int y3 = y - (int)((double)(h * (100 - arcLen) / 100) * Math.sin(angle2));
                int x4 = x + (int)((double)(w * (100 - arcLen) / 100) * Math.cos(angle1));
                int y4 = y - (int)((double)(h * (100 - arcLen) / 100) * Math.sin(angle1));
                out.println("<area " + nodeLink + " shape=poly coords=\"" + x4 + "," + y4 + "," + x3 + "," + y3 + "," + x2 + "," + y2 + "," + x1 + "," + y1 + "\">");
            }
        } else {
            double half = (angle1 + angle2) / 2.0;
            this.outputArc(out, nodeLink, x, y, w, h, angle1, half, arcLen);
            this.outputArc(out, nodeLink, x, y, w, h, half, angle2, arcLen);
        }
    }
}

