/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Polygon;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.ArcAngle;
import quadbase.chart.Area;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ChartColorSet;
import quadbase.chart.Coordinate;
import quadbase.chart.HiLowData;
import quadbase.chart.IPieChart;
import quadbase.chart.KeyPair;
import quadbase.chart.PieChart;
import quadbase.chart.PlotData;
import quadbase.chart.Point3D;
import quadbase.chart.QbPattern;
import quadbase.chart.StepSize;
import quadbase.common.util.internal.IFlashGraphics;

public abstract class MultiDimData {
    private static final Logger LOGGER = Logger.getLogger(MultiDimData.class.getName());
    public MultiDimData[] multiData;
    public MultiDimData[] originalMultiData;
    public MultiDimData parent;
    public PlotData plotData;
    public Chart chart;
    public int level;
    public Area area;
    public Area area2;
    public HiLowData hilow;
    public HiLowData orgHilow;
    public Point3D point;
    public Point3D flashPoint;
    protected int lineThickness = 2;
    public ArcAngle arcAngle;
    public int[] order;
    private int[] outilerPos;
    public CString topLabel = null;
    public CString flashLabel = null;
    public CString stackTotalLabel = null;

    public MultiDimData(int lv, Chart _chart, MultiDimData p) {
        this.chart = _chart;
        this.parent = p;
        this.level = lv;
    }

    protected MultiDimData() {
    }

    public MultiDimData resortOriginalMultiDimData() {
        if (this.originalMultiData == null) {
            return this;
        }
        MultiDimData newData = this.copyMultiDimData();
        newData.multiData = new MultiDimData[this.originalMultiData.length];
        for (int i = 0; i < this.originalMultiData.length; ++i) {
            newData.multiData[i] = this.originalMultiData[i];
            newData.multiData[i].parent = newData;
        }
        newData.originalMultiData = null;
        return newData;
    }

    public Object topNMultiDimData(int len) {
        MultiDimData newData = this.copyMultiDimData();
        if (newData.multiData.length < len) {
            len = newData.multiData.length;
        }
        newData.originalMultiData = this.multiData;
        newData.multiData = new MultiDimData[len];
        for (int i = 0; i < len; ++i) {
            newData.multiData[i] = this.multiData[i];
        }
        return newData;
    }

    public abstract MultiDimData copyMultiDimData();

    protected MultiDimData copyMultiDimData(MultiDimData newData) {
        try {
            newData.multiData = new MultiDimData[this.multiData.length];
            for (int i = 0; i < newData.multiData.length; ++i) {
                newData.multiData[i] = this.multiData[i];
                newData.multiData[i].parent = newData;
            }
            newData.parent = this.parent;
            newData.plotData = this.plotData;
            newData.chart = this.chart;
            newData.level = this.level;
            newData.area = this.area;
            newData.area2 = this.area2;
            newData.hilow = this.hilow;
            newData.orgHilow = this.orgHilow;
            newData.point = this.point;
            newData.flashPoint = this.flashPoint;
            newData.lineThickness = this.lineThickness;
            newData.arcAngle = this.arcAngle;
            newData.order = this.order;
            newData.outilerPos = this.outilerPos;
            newData.topLabel = this.topLabel;
            newData.flashLabel = this.flashLabel;
            newData.stackTotalLabel = this.stackTotalLabel;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to copy multi dimensional data", e);
        }
        return newData;
    }

    public int count() {
        if (this.multiData == null || this.multiData.length == 0) {
            return 1;
        }
        return this.multiData.length * this.multiData[0].count();
    }

    public double getValue(int[] loc) {
        try {
            if (this.level < this.chart.dataDim) {
                return this.multiData[loc[this.level]].getValue(loc);
            }
            return this.plotData.getValue();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to get value", ex);
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public double getValue(int[] loc, Axis axis) {
        return this.getValue(loc, axis.maxScale, axis.minScale);
    }

    public double getValue(int[] loc, StepSize sp) {
        return this.getValue(loc, sp.maxvalue, sp.minvalue);
    }

    public double getValue(int[] loc, double max, double min) {
        if (this.level < this.chart.dataDim) {
            return this.multiData[loc[this.level]].getValue(loc, max, min);
        }
        double tmp = this.plotData.getValue();
        if (tmp > max) {
            return max;
        }
        if (tmp < min) {
            return min;
        }
        return tmp;
    }

    public boolean isPrimary() {
        MultiDimData cur = this;
        while (cur.parent != null) {
            cur = cur.parent;
        }
        return cur == this.chart.mData;
    }

    public boolean isSecondary() {
        MultiDimData cur = this;
        while (cur.parent != null) {
            cur = cur.parent;
        }
        return cur == this.chart.mData2;
    }

    public PlotData getPlotData(int[] loc) {
        if (this.level < this.chart.dataDim) {
            return this.multiData[loc[this.level]].getPlotData(loc);
        }
        return this.plotData;
    }

    public int[] getOutilerPosition() {
        return this.outilerPos;
    }

    public void setOutilerPosition(int[] newPos) {
        this.outilerPos = newPos;
    }

    public void setPercentage(int[] loc, float percent) {
        if (this.level < this.chart.dataDim) {
            this.multiData[loc[this.level]].setPercentage(loc, percent);
        } else {
            this.plotData.setPercentage(percent);
        }
    }

    public MultiDimData getAnyLeafNode() {
        if (this.level + 1 < this.chart.dataDim) {
            return this.multiData[0].getAnyLeafNode();
        }
        if (this.multiData != null) {
            return this.multiData[0];
        }
        return this;
    }

    public Object getElement(int[] loc) {
        if (this.level < this.chart.dataDim) {
            if (loc[this.level] < this.multiData.length) {
                return this.multiData[loc[this.level]].getElement(loc);
            }
            return this.originalMultiData[loc[this.level]].getElement(loc);
        }
        return this.plotData.element;
    }

    public void setShape(int shape) {
        this.point.shape = shape;
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.setShape(shape);
            }
        }
    }

    public void setSize(int size) {
        this.point.size = size;
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.setSize(size);
            }
        }
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(int thick) {
        this.lineThickness = thick;
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.setLineThickness(thick);
            }
        }
    }

    public boolean isPatternOn() {
        if (this.area.areaColor instanceof QbPattern && ((QbPattern)this.area.areaColor).getPatternImage() != null) {
            return true;
        }
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                if (!element.isPatternOn()) continue;
                return true;
            }
        }
        return false;
    }

    public void setColor(Color color) {
        this.area.setColor(color);
        this.point.color = color;
        this.setFaceColor(color);
    }

    public Color getColor() {
        return this.area.areaColor;
    }

    public void setAreaCoord(int xmin, int xmax, HiLowData hilow, HiLowData orgData, int zmin, int zmax, int[] loc) {
        if (this.level < this.chart.dataDim) {
            this.multiData[loc[this.level]].setAreaCoord(xmin, xmax, hilow, orgData, zmin, zmax, loc);
            return;
        }
        this.setAreaCoord(xmin, xmax, (int)hilow.vlow, (int)hilow.vhi, zmin, zmax);
        if (hilow.vclose != -1.7976931348623157E308) {
            this.area2 = this.chart.copyArea(this.area);
            this.area.p1.y = (int)hilow.vclose;
            this.area2.p2.y = (int)hilow.vclose;
        }
        this.point.x = (xmin + xmax) / 2;
        this.point.z = (zmin + zmax) / 2;
        this.point.y = hilow.vclose != -1.7976931348623157E308 ? (int)hilow.vclose : (int)hilow.vhi;
        this.point.color = this.area.areaColor;
        this.hilow = hilow;
        this.orgHilow = orgData;
    }

    private void setAreaCoord(int xmin, int xmax, int ymin, int ymax, int zmin, int zmax) {
        if (this.chart.isStackType()) {
            this.point.x = (xmin + xmax) / 2;
            this.point.y = ymin;
            if (ymin <= ymax) {
                this.area.setpos(xmin, ymin, zmin, xmax, ymax, zmax);
            } else {
                this.area.setpos(xmin, ymax, zmin, xmax, ymin, zmax);
            }
        } else {
            this.point.x = xmin;
            this.point.y = (ymin + ymax) / 2;
            if (xmin <= xmax) {
                this.area.setpos(xmin, ymin, zmin, xmax, ymax, zmax);
            } else {
                this.area.setpos(xmax, ymin, zmin, xmin, ymax, zmax);
            }
        }
        this.point.z = (zmin + zmax) / 2;
        this.point.color = this.area.areaColor;
    }

    public void setAreaCoord(int xmin, int xmax, int ymin, int ymax, int zmin, int zmax, int[] loc) {
        if (this.level < this.chart.dataDim) {
            this.multiData[loc[this.level]].setAreaCoord(xmin, xmax, ymin, ymax, zmin, zmax, loc);
            return;
        }
        this.setAreaCoord(xmin, xmax, ymin, ymax, zmin, zmax);
    }

    public void setAreaCoord(int xmin, int xmax, HiLowData hilow, HiLowData orgData, int[] loc) {
        if (this.level < this.chart.dataDim) {
            this.multiData[loc[this.level]].setAreaCoord(xmin, xmax, hilow, orgData, loc);
            return;
        }
        this.hilow = hilow;
        this.orgHilow = orgData;
        if (this.chart.isCatZoom()) {
            xmin = this.chart.calculateZoomedX(xmin);
            xmax = this.chart.calculateZoomedX(xmax);
            LOGGER.finest("XMIN = " + xmin + ", XMAX = " + xmax);
            if (xmin > xmax) {
                int tmp = xmin;
                xmin = xmax;
                xmax = tmp;
            }
            int chartXMin = this.chart.chartxorigin;
            int chartXMax = this.chart.chartxorigin + this.chart.chartwidth;
            if (xmin < chartXMin) {
                if (xmax < chartXMin) {
                    xmin = -1;
                    xmax = -1;
                } else {
                    xmin = chartXMin;
                }
            }
            if (xmax > chartXMax) {
                if (xmin > chartXMax) {
                    xmin = -1;
                    xmax = -1;
                } else {
                    xmax = chartXMax;
                }
            }
        }
        int ymin = (int)hilow.vhi;
        int ymax = (int)hilow.vlow;
        int close = (int)hilow.vclose;
        if (this.chart.isValueZoom()) {
            LOGGER.finest("MULTIDIMDATA:  ADJUST COL VALUE");
            int origin = this.chart.chartyorigin;
            int top = this.chart.chartyorigin + this.chart.chartheight;
            LOGGER.finest("OLD ymin = " + ymin + ", ymax = " + ymax);
            LOGGER.finest("CHART TOP = " + top + ", ORG = " + origin);
            if (ymin > top) {
                ymin = top;
            }
            if (ymin < origin) {
                ymin = origin;
            }
            if (ymax < origin) {
                ymax = origin;
            }
            if (ymax > top) {
                ymax = top;
            }
            if (hilow.vclose != -1.7976931348623157E308) {
                if (close < origin) {
                    close = origin;
                }
                if (close > top) {
                    close = top;
                }
            }
            LOGGER.finest("NEW ymin = " + ymin + ", ymax = " + ymax);
        }
        this.area.setpos(xmin, ymin, xmax, ymax);
        if (hilow.vclose != -1.7976931348623157E308) {
            this.area2 = this.chart.copyArea(this.area);
            this.area.p2.y = close;
            this.area2.p1.y = close;
            this.point.y = close;
        } else {
            this.point.y = ymin;
        }
        this.point.x = (xmin + xmax) / 2;
        this.point.color = this.area.areaColor;
    }

    public void setAreaCoord(HiLowData hilow, int ymin, int ymax, int[] loc) {
        if (this.level < this.chart.dataDim) {
            this.multiData[loc[this.level]].setAreaCoord(hilow, ymin, ymax, loc);
            return;
        }
        this.hilow = hilow;
        this.area.setpos((int)hilow.vlow, ymin, (int)hilow.vhi, ymax);
        if (hilow.vclose != -1.7976931348623157E308) {
            this.area2 = this.chart.copyArea(this.area);
            this.area.p2.x = (int)hilow.vclose;
            this.area2.p1.x = (int)hilow.vclose;
            this.point.x = (int)hilow.vclose;
        } else {
            this.point.x = (int)hilow.vhi;
        }
        this.point.y = (ymin + ymax) / 2;
        this.point.color = this.area.areaColor;
    }

    public void setAreaCoord(int xmin, int xmax, int ymin, int ymax, int[] loc) {
        this.setAreaCoord(xmin, xmax, ymin, ymax, loc, false);
    }

    public void setAreaCoord(int xmin, int xmax, int ymin, int ymax, int[] loc, boolean isCatZoomed) {
        int top;
        int origin;
        if (this.level < this.chart.dataDim) {
            this.multiData[loc[this.level]].setAreaCoord(xmin, xmax, ymin, ymax, loc, isCatZoomed);
            return;
        }
        if (this.chart.isCatZoom()) {
            int tmp;
            if (this.chart.isVertical()) {
                LOGGER.finest("X AXIS IS CAT");
                xmin = this.chart.calculateZoomedX(xmin);
                xmax = this.chart.calculateZoomedX(xmax);
                LOGGER.finest("XMIN = " + xmin + ", XMAX = " + xmax);
                if (xmin > xmax) {
                    tmp = xmin;
                    xmin = xmax;
                    xmax = tmp;
                }
                int chartXMin = this.chart.chartxorigin;
                int chartXMax = this.chart.chartxorigin + this.chart.chartwidth;
                if (xmin < chartXMin) {
                    if (xmax < chartXMin) {
                        xmin = -1;
                        xmax = -1;
                    } else {
                        xmin = chartXMin;
                    }
                }
                if (xmax > chartXMax) {
                    if (xmin > chartXMax) {
                        xmin = -1;
                        xmax = -1;
                    } else {
                        xmax = chartXMax;
                    }
                }
            } else {
                ymin = this.chart.calculateZoomedY(ymin);
                ymax = this.chart.calculateZoomedY(ymax);
                LOGGER.finest("Y AXIS IS CAT");
                LOGGER.finest("YMIN = " + ymin + ", YMAX = " + ymax);
                if (ymin > ymax) {
                    tmp = ymin;
                    ymin = ymax;
                    ymax = tmp;
                }
                int chartYMin = this.chart.chartyorigin;
                int chartYMax = this.chart.chartyorigin + this.chart.chartheight;
                if (ymin < chartYMin) {
                    if (ymax < chartYMin) {
                        ymin = -1;
                        ymax = -1;
                    } else {
                        ymin = chartYMin;
                    }
                }
                if (ymax > chartYMax) {
                    if (ymin > chartYMax) {
                        ymin = -1;
                        ymax = -1;
                    } else {
                        ymax = chartYMax;
                    }
                }
            }
        }
        int oymin = ymin;
        int oxmin = xmin;
        if (this.chart.isValueZoom()) {
            LOGGER.finest("MULTIDIMDATA:  ADJUST COL VALUE");
            if (this.chart.isVertical()) {
                origin = this.chart.chartyorigin;
                top = this.chart.chartyorigin + this.chart.chartheight;
                LOGGER.finest("OLD ymin = " + ymin + ", ymax = " + ymax);
                LOGGER.finest("CHART TOP = " + top + ", ORG = " + origin);
                if (ymin > top) {
                    ymin = top;
                }
                if (ymin < origin) {
                    ymin = origin;
                }
                if (ymax < origin) {
                    ymax = origin;
                }
                if (ymax > top) {
                    ymax = top;
                }
                LOGGER.finest("NEW ymin = " + ymin + ", ymax = " + ymax);
            } else {
                origin = this.chart.chartxorigin;
                int wide = this.chart.chartxorigin + this.chart.chartwidth;
                LOGGER.finest("OLD xmin = " + xmin + ", xmax = " + xmax);
                LOGGER.finest("CHART WIDE = " + wide + ", ORG = " + origin);
                if (xmax > wide) {
                    xmax = wide;
                }
                if (xmin < origin) {
                    xmin = origin;
                }
                if (xmin > wide) {
                    xmin = wide;
                }
                if (xmax < origin) {
                    xmax = origin;
                }
                LOGGER.finest("NEW xmin = " + xmin + ", xmax = " + xmax);
            }
        }
        this.area.setpos(xmin, ymin, xmin, xmax, ymax, xmax);
        if (this.chart.chartType == 1 || this.chart.chartType == 5 || this.chart.chartType == 18) {
            origin = this.chart.chartxorigin;
            top = this.chart.chartxorigin + this.chart.chartwidth;
            this.point.x = oxmin > top || oxmin < origin ? -100 : oxmin;
            this.point.y = (ymin + ymax) / 2;
        } else {
            this.point.x = (xmin + xmax) / 2;
            origin = this.chart.chartyorigin;
            top = this.chart.chartyorigin + this.chart.chartheight;
            this.point.y = oymin > top || oymin < origin ? -100 : oymin;
        }
        this.point.color = this.area.areaColor;
    }

    protected boolean isPointVisible() {
        if (this.chart.chartType == 2 || this.chart.chartType == 13 || this.chart.chartType == 19) {
            if (this.plotData.isEmpty()) {
                return false;
            }
            Coordinate coord = (Coordinate)this.plotData.element;
            if (coord == null) {
                return false;
            }
            double x = coord.x;
            double y = coord.y;
            StepSize xstep = this.chart.a_x.stepsize;
            StepSize ystep = this.chart.a_y.stepsize;
            if (xstep.axis.logScale) {
                x = xstep.axis.log(x);
            }
            if (ystep.axis.logScale) {
                y = ystep.axis.log(y);
            }
            if (this.chart.isAreaCutOffSupport() && y > this.chart.getAreaCutOffPoint()) {
                return false;
            }
            if (this.chart.bcoordCol[2] && this.chart.chartType == 2) {
                double z = coord.z;
                StepSize zstep = this.chart.a_z.stepsize;
                return !(x < xstep.minvalue || x > xstep.maxvalue || y < ystep.minvalue || y > ystep.maxvalue || z < zstep.minvalue || z > zstep.maxvalue);
            }
            if (this.chart.chartType == 19) {
                double tmpY = Math.abs(y);
                return !(tmpY < ystep.minvalue) && !(tmpY > ystep.maxvalue);
            }
            return !(x < xstep.minvalue || x > xstep.maxvalue || y < ystep.minvalue || y > ystep.maxvalue);
        }
        return true;
    }

    public abstract void setPointCoord(int var1, int var2, int[] var3);

    public abstract void setFlashPointCoord(int var1, int var2, int[] var3);

    public abstract void setPointCoord(int var1, int var2, int var3, int[] var4);

    public abstract void setFlashPointCoord(int var1, int var2, int var3, int[] var4);

    public void findMinMaxVal(Chart pChart, boolean firstvalue) {
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.findMinMaxVal(pChart, firstvalue);
            }
        } else if (this.chart.chartType == 15 && firstvalue) {
            double[] out;
            double d;
            double d2;
            double val = this.plotData.getValue(1);
            if (d2 > pChart.maxvalue) {
                pChart.maxvalue = val;
            }
            val = this.plotData.getValue(2);
            if (d < pChart.minvalue) {
                pChart.minvalue = val;
            }
            if ((out = this.plotData.getOutiler()) != null) {
                if (out[0] < pChart.minvalue) {
                    pChart.minvalue = out[0];
                }
                if (out[out.length - 1] > pChart.maxvalue) {
                    pChart.maxvalue = out[out.length - 1];
                }
            }
        } else {
            if (this.plotData.isEmpty()) {
                return;
            }
            if (!(this.plotData.element instanceof HiLowData)) {
                if (firstvalue) {
                    double d;
                    double val = this.plotData.getValue();
                    if (d > pChart.maxvalue) {
                        pChart.maxvalue = val;
                    }
                    if (val < pChart.minvalue) {
                        pChart.minvalue = val;
                    }
                } else {
                    double d;
                    double val = this.plotData.getValue();
                    if (d > pChart.maxvalue2) {
                        pChart.maxvalue2 = val;
                    }
                    if (val < pChart.minvalue2) {
                        pChart.minvalue2 = val;
                    }
                }
            } else {
                double val = ((HiLowData)this.plotData.element).max();
                if (val > pChart.maxvalue) {
                    pChart.maxvalue = val;
                }
                if ((val = ((HiLowData)this.plotData.element).min()) < pChart.minvalue) {
                    pChart.minvalue = val;
                }
            }
        }
    }

    public double[] getAvgVal(Chart pChart, double sum, int count) {
        if (this.level < this.chart.dataDim) {
            int n = 0;
            MultiDimData[] multiDimDataArray = this.multiData;
            int n2 = multiDimDataArray.length;
            if (n < n2) {
                MultiDimData element = multiDimDataArray[n];
                return element.getAvgVal(pChart, sum, count);
            }
        } else {
            if (this.plotData.isEmpty()) {
                return new double[]{sum, count};
            }
            return new double[]{sum += this.plotData.getValue(), ++count};
        }
        return new double[]{sum, count};
    }

    public void findMinMaxCoord() {
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.findMinMaxCoord();
            }
        } else {
            double d;
            double d2;
            double d3;
            if (this.plotData.isEmpty()) {
                return;
            }
            if (this.plotData.element == null) {
                double x = 0.0;
                if (0.0 > this.chart.maxCoord.x) {
                    this.chart.maxCoord.x = x;
                }
                if (x < this.chart.minCoord.x) {
                    this.chart.minCoord.x = x;
                }
                double y = 0.0;
                if (0.0 > this.chart.maxCoord.y) {
                    this.chart.maxCoord.y = y;
                }
                if (y < this.chart.minCoord.y) {
                    this.chart.minCoord.y = y;
                }
                double z = 0.0;
                if (0.0 > this.chart.maxCoord.z) {
                    this.chart.maxCoord.z = z;
                }
                if (z < this.chart.minCoord.z) {
                    this.chart.minCoord.z = z;
                }
                return;
            }
            double x = ((Coordinate)this.plotData.element).x;
            if (d3 > this.chart.maxCoord.x) {
                this.chart.maxCoord.x = x;
            }
            if (x < this.chart.minCoord.x) {
                this.chart.minCoord.x = x;
            }
            double y = ((Coordinate)this.plotData.element).y;
            if (d2 > this.chart.maxCoord.y) {
                this.chart.maxCoord.y = y;
            }
            if (y < this.chart.minCoord.y) {
                this.chart.minCoord.y = y;
            }
            double z = ((Coordinate)this.plotData.element).z;
            if (d > this.chart.maxCoord.z) {
                this.chart.maxCoord.z = z;
            }
            if (z < this.chart.minCoord.z) {
                this.chart.minCoord.z = z;
            }
        }
        if (this.chart.isAreaCutOffSupport() && this.chart.maxCoord.y > this.chart.getAreaCutOffPoint()) {
            this.chart.maxCoord.y = this.chart.getAreaCutOffPoint();
        }
    }

    public void findMinMaxRadial() {
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.findMinMaxRadial();
            }
        } else {
            double d;
            if (this.plotData.isEmpty()) {
                return;
            }
            double y = Math.abs(((Coordinate)this.plotData.element).y);
            if (d > this.chart.maxCoord.y) {
                this.chart.maxCoord.y = y;
            }
            if (y < this.chart.minCoord.y) {
                this.chart.minCoord.y = y;
            }
        }
    }

    public void findMinMaxSum() {
        if (this.level < this.chart.dataDim - 1) {
            for (MultiDimData element : this.multiData) {
                element.findMinMaxSum();
            }
        } else {
            double sum1 = 0.0;
            double sum2 = 0.0;
            for (MultiDimData element : this.multiData) {
                double t = element.plotData.getValue();
                if (t > 0.0) {
                    sum1 += t;
                } else {
                    sum2 += t;
                }
                if (sum1 > this.chart.maxvalue) {
                    this.chart.maxvalue = sum1;
                }
                if (!(sum2 < this.chart.minvalue)) continue;
                this.chart.minvalue = sum2;
            }
        }
    }

    public void findMinMaxCumSum(boolean firstvalue) {
        if (this.level < this.chart.dataDim - 1) {
            for (MultiDimData element : this.multiData) {
                element.findMinMaxCumSum(firstvalue);
            }
        } else {
            double sum = 0.0;
            for (MultiDimData element : this.multiData) {
                sum += element.plotData.getValue();
                if (firstvalue) {
                    if (sum > this.chart.maxvalue) {
                        this.chart.maxvalue = sum;
                    }
                    if (!(sum < this.chart.minvalue)) continue;
                    this.chart.minvalue = sum;
                    continue;
                }
                if (sum > this.chart.maxvalue2) {
                    this.chart.maxvalue2 = sum;
                }
                if (!(sum < this.chart.minvalue2)) continue;
                this.chart.minvalue2 = sum;
            }
        }
    }

    public void add(int[] loc, int recNo, boolean firstvalue) {
        if (this.level < this.chart.dataDim) {
            this.multiData[loc[this.level]].add(loc, recNo, firstvalue);
        } else {
            this.plotData.add(recNo, firstvalue);
        }
    }

    public abstract void drawFace(CGraphics var1);

    public void drawLine(CGraphics g) {
        this.drawLine(g, this.point, this.lineThickness);
    }

    public abstract void drawLine(CGraphics var1, Point3D var2, int var3);

    public void drawLine(CGraphics g, MultiDimData primaryData) {
        this.drawLine(g, this.point, this.lineThickness, primaryData);
    }

    public abstract void drawLine(CGraphics var1, Point3D var2, int var3, MultiDimData var4);

    public abstract void prepare3DPoint(Object var1, double var2, Point3D var4);

    public abstract void prepare3DLine(Object var1, double var2, double var4, Point3D var6, boolean var7);

    public void sortPoint() {
        if (this.level < this.chart.dataDim - 1) {
            for (MultiDimData element : this.multiData) {
                element.sortPoint();
            }
        } else {
            int i;
            KeyPair[] pair = new KeyPair[this.order.length];
            for (i = 0; i < this.order.length; ++i) {
                pair[i] = new KeyPair(i, this.multiData[i].point.x);
            }
            Object[] result = KeyPair.sortkey(pair);
            for (i = 0; i < this.order.length; ++i) {
                this.order[i] = (Integer)result[i];
            }
        }
    }

    public void drawArea(CGraphics g) {
        this.drawArea(g, this.area);
    }

    public void drawPoint(CGraphics g) {
        this.drawPoint(g, this.point);
    }

    public abstract void prepare3DBox(Object var1);

    public abstract void prepare3DPie(Object var1, double var2);

    public abstract void prepare3DDoughnut(Object var1, double var2);

    public abstract void prepare3DPoint(Object var1, double var2);

    public abstract void prepare3DLine(Object var1, double var2, double var4, boolean var6);

    public abstract void prepare3DLine(Object var1, double var2, double var4);

    public abstract void prepare3DArea(Object var1, double var2, int var4);

    public abstract void prepare3DStackArea(Object var1, double var2, int var4);

    public abstract void prepare3DArea(Object var1, double var2, int var4, Area var5);

    public abstract void prepare3DStackArea(Object var1, double var2, int var4, Area var5);

    public abstract void addArea(Object var1, Point3D var2, Point3D var3, Point3D var4, Point3D var5, double var6, Area var8);

    public abstract void prepare3DPie(Object var1, double var2, Area var4);

    public abstract void drawHLCOArea(CGraphics var1, Area var2);

    private void drawArea(CGraphics g, Area parea) {
        this.drawArea(g, parea, 0);
    }

    public boolean isAngleLessThanThreshold() {
        if (this.chart.colorArrayForPieThreshold == null) {
            return false;
        }
        if (this.chart.colorArrayForPieThreshold.length == 0) {
            return false;
        }
        if (this.chart.colorThresholdForPie <= 0.0) {
            return false;
        }
        return this.arcAngle.angle <= 3.6 * this.chart.colorThresholdForPie;
    }

    public Color getThresholdColor(Color originalColor) {
        int idx = -1;
        for (MultiDimData element : this.parent.multiData) {
            if (element == null) continue;
            if (element == this) {
                ++idx;
                break;
            }
            if (!element.isAngleLessThanThreshold()) continue;
            ++idx;
        }
        Color c = this.chart.colorArrayForPieThreshold[idx % this.chart.colorArrayForPieThreshold.length];
        if (originalColor instanceof QbPattern) {
            QbPattern newColor = new QbPattern(c, ((QbPattern)originalColor).getPatternTypeID());
            if (((QbPattern)originalColor).getPatternTypeID() == QbPattern.CUSTOMPATTERN) {
                newColor.setPatternImage(((QbPattern)originalColor).getPatternImage());
            }
            return newColor;
        }
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }

    private void drawArea(CGraphics g, Area parea, int pieIndex) {
        if (this.level < this.chart.dataDim) {
            if (this.chart.chartType == 18) {
                for (int i = this.multiData.length - 1; i >= 0; --i) {
                    if (i == this.multiData.length - 1) {
                        this.chart.setGanttEndPoint(null);
                    }
                    this.multiData[i].drawArea(g, this.area.automatic ? parea : this.area, this.chart.dataDim == 1 ? 0 : i);
                }
            } else {
                for (int i = 0; i < this.multiData.length; ++i) {
                    if (i == 0) {
                        this.chart.setGanttEndPoint(null);
                    }
                    this.multiData[i].drawArea(g, this.area.automatic ? parea : this.area, this.chart.dataDim == 1 ? 0 : i);
                }
            }
        } else {
            boolean drawBorder;
            PieChart pchart;
            if (this.chart.chartType == 6) {
                pchart = ((IPieChart)((Object)this.chart)).getPieChart();
                if (this.chart.dataDim == 2) {
                    this.area.areaColor = parea.areaColor;
                }
                g.setColor(this.area.areaColor);
                drawBorder = this.chart.drawDataBorder;
                if (this.area.areaColor.getRGB() == Color.white.getRGB() && this.chart.isDrawBorderForWhiteArea()) {
                    drawBorder = true;
                }
                if (this.chart.mDataLen[0] == 1) {
                    g.fillArc(pchart.center[pieIndex].x, pchart.center[pieIndex].y, pchart.piewidth[pieIndex], pchart.pieheight[pieIndex], 0, 360, this, drawBorder, false, this.chart.getPieBorderColor());
                    return;
                }
                if (this.arcAngle.angle > 0.0) {
                    if (this.isAngleLessThanThreshold()) {
                        Color thresholdColor = this.getThresholdColor(this.area.areaColor);
                        if (this.chart.dataDim == 1) {
                            this.area.areaColor = thresholdColor;
                        }
                        g.setColor(thresholdColor);
                        if (this.area.areaColor.getRGB() == Color.white.getRGB() && this.chart.isDrawBorderForWhiteArea()) {
                            drawBorder = true;
                        }
                    }
                    if (this.plotData.bSlice && pchart.sliceDistance != 0.0 && (!pchart.isSectorGapEnabled() || this.arcAngle.angle < 320.0)) {
                        if (!pchart.isSectorGapEnabled() || pchart.sliceDistance <= 0.0) {
                            double angle = (this.arcAngle.start + this.arcAngle.angle / 2.0) * Math.PI / 180.0;
                            g.fillArc((int)((double)pchart.center[pieIndex].x + (double)pchart.piewidth[pieIndex] * pchart.sliceDistance * Math.cos(angle) / 2.0), (int)((double)pchart.center[pieIndex].y + (double)pchart.pieheight[pieIndex] * pchart.sliceDistance * Math.sin(angle) / 2.0), pchart.piewidth[pieIndex], pchart.pieheight[pieIndex], (int)Math.floor(this.arcAngle.start), (int)Math.ceil(this.arcAngle.angle), this, drawBorder, true, this.chart.getPieBorderColor());
                        } else {
                            double d = (double)pchart.piewidth[pieIndex] * pchart.sliceDistance / 2.0;
                            double gap = Math.asin(d / 2.0 / (double)pchart.piewidth[pieIndex] / 2.0) * 4.0 * 180.0 / Math.PI;
                            double a = d / Math.sin(this.arcAngle.angle / 2.0 * Math.PI / 180.0);
                            double rw = (double)pchart.piewidth[pieIndex] - a * 2.0;
                            double rh = (double)pchart.pieheight[pieIndex] - a * 2.0;
                            double angle = (this.arcAngle.start + this.arcAngle.angle / 2.0) * Math.PI / 180.0;
                            if (!pchart.isExplodedAll() || !pchart.isSectorAlike()) {
                                if (gap * 2.0 > this.arcAngle.angle - 2.0 && (gap = Math.floor((this.arcAngle.angle - 2.0) / 2.0)) < 0.0) {
                                    gap = 0.0;
                                }
                                g.fillArc((int)Math.rint(pchart.center[pieIndex].x), (int)Math.rint(pchart.center[pieIndex].y), pchart.piewidth[pieIndex], pchart.pieheight[pieIndex], (int)Math.rint(this.arcAngle.start + gap), (int)Math.rint(this.arcAngle.angle - gap * 2.0), this, drawBorder, true, this.chart.getPieBorderColor());
                            } else if (a > 0.0 && rw > 0.0 && rh > 0.0) {
                                g.fillArc((int)Math.rint((double)pchart.center[pieIndex].x + a * Math.cos(angle)), (int)Math.rint((double)pchart.center[pieIndex].y + a * Math.sin(angle)), (int)Math.rint(rw), (int)Math.rint(rh), (int)Math.rint(this.arcAngle.start), (int)Math.rint(this.arcAngle.angle), this, drawBorder, true, this.chart.getPieBorderColor());
                            }
                        }
                    } else {
                        g.fillArc(pchart.center[pieIndex].x, pchart.center[pieIndex].y, pchart.piewidth[pieIndex], pchart.pieheight[pieIndex], (int)Math.floor(this.arcAngle.start), (int)Math.ceil(this.arcAngle.angle), this, drawBorder, true, this.chart.getPieBorderColor());
                    }
                }
            }
            if (this.chart.chartType == 20) {
                pchart = ((IPieChart)((Object)this.chart)).getPieChart();
                if (this.chart.dataDim == 2) {
                    this.area.areaColor = parea.areaColor;
                }
                g.setColor(this.area.areaColor);
                drawBorder = this.chart.drawDataBorder;
                if (this.area.areaColor.getRGB() == Color.white.getRGB() && this.chart.isDrawBorderForWhiteArea()) {
                    drawBorder = true;
                }
                if (this.chart.mDataLen[0] == 1) {
                    g.fillDoughnutArc(pchart.center[pieIndex].x, pchart.center[pieIndex].y, pchart.piewidth[pieIndex], pchart.pieheight[pieIndex], 0, 360, this, drawBorder, false, this.chart.getPieBorderColor(), pchart.pieThickness[0]);
                    return;
                }
                if (this.arcAngle.angle > 0.0) {
                    if (this.isAngleLessThanThreshold()) {
                        Color thresholdColor = this.getThresholdColor(this.area.areaColor);
                        if (this.chart.dataDim == 1) {
                            this.area.areaColor = thresholdColor;
                        }
                        g.setColor(thresholdColor);
                        if (this.area.areaColor.getRGB() == Color.white.getRGB() && this.chart.isDrawBorderForWhiteArea()) {
                            drawBorder = true;
                        }
                    }
                    if (this.plotData.bSlice && pchart.sliceDistance != 0.0 && (!pchart.isSectorGapEnabled() || this.arcAngle.angle < 320.0)) {
                        if (!pchart.isSectorGapEnabled() || pchart.sliceDistance <= 0.0) {
                            double angle = (this.arcAngle.start + this.arcAngle.angle / 2.0) * Math.PI / 180.0;
                            g.fillDoughnutArc((int)((double)pchart.center[pieIndex].x + (double)pchart.piewidth[pieIndex] * pchart.sliceDistance * Math.cos(angle) / 2.0), (int)((double)pchart.center[pieIndex].y + (double)pchart.pieheight[pieIndex] * pchart.sliceDistance * Math.sin(angle) / 2.0), pchart.piewidth[pieIndex], pchart.pieheight[pieIndex], (int)Math.floor(this.arcAngle.start), (int)Math.ceil(this.arcAngle.angle), this, drawBorder, true, this.chart.getPieBorderColor(), pchart.pieThickness[pieIndex]);
                        } else {
                            double d = (double)pchart.piewidth[0] * pchart.sliceDistance / 2.0;
                            double a = d / Math.sin(this.arcAngle.angle / 2.0 * Math.PI / 180.0);
                            double rw = (double)pchart.piewidth[0] - a * 2.0;
                            double rh = (double)pchart.pieheight[0] - a * 2.0;
                            int gap = (int)Math.rint(pchart.sliceDistance * 360.0 / 4.0);
                            if (a > 0.0 && rw > 0.0 && rh > 0.0) {
                                g.fillDoughnutArc((int)Math.rint(pchart.center[pieIndex].x), (int)Math.rint(pchart.center[pieIndex].y), pchart.piewidth[pieIndex], pchart.pieheight[pieIndex], (int)Math.rint(this.arcAngle.start) + gap, (int)Math.rint(this.arcAngle.angle) - (gap * 2 + 1), this, drawBorder, true, this.chart.getPieBorderColor(), pchart.pieThickness[pieIndex]);
                            }
                        }
                    } else {
                        g.fillDoughnutArc(pchart.center[pieIndex].x, pchart.center[pieIndex].y, pchart.piewidth[pieIndex], pchart.pieheight[pieIndex], (int)Math.floor(this.arcAngle.start), (int)Math.ceil(this.arcAngle.angle), this, drawBorder, true, this.chart.getPieBorderColor(), pchart.pieThickness[pieIndex]);
                    }
                }
            } else if (!this.plotData.isEmpty()) {
                if (this.chart.chartType == 10 && this.hilow != null) {
                    this.drawHLCOArea(g, parea);
                } else {
                    if (this.chart.getDataBorder() && this.chart.getDataBorderThickness() > 0 && (this.chart.is2DimChart() || this.chart.get3DDrawType() != 0)) {
                        int depth = this.area.depth;
                        boolean drawBlackBorder = this.area.drawBlackBorder;
                        Color borderColor = this.area.borderColor;
                        this.area.depth = this.chart.getDataBorderThickness();
                        this.area.drawBlackBorder = true;
                        this.area.borderColor = this.chart.getDataBorderColor();
                        this.area.draw(g, this.area.automatic ? parea : this.area, this, this.chart.isShowShadowOnPoint());
                        this.area.depth = depth;
                        this.area.drawBlackBorder = drawBlackBorder;
                        this.area.borderColor = borderColor;
                    } else {
                        this.area.draw(g, this.area.automatic ? parea : this.area, this, this.chart.isShowShadowOnPoint());
                    }
                    if (this.chart.chartType == 18 && this.chart.isGanttArrowsDrawn()) {
                        Point3D prevPt = this.getPreviousPoint();
                        if (prevPt != null) {
                            Point3D currPt = this.getCurrentPoint(prevPt);
                            g.setColor(Color.black);
                            g.fillLine(prevPt.x, prevPt.y, currPt.x, prevPt.y, 2);
                            g.fillLine(currPt.x, prevPt.y, currPt.x, currPt.y, 2);
                            int[] ptsX = new int[5];
                            int[] ptsY = new int[5];
                            ptsX[0] = ptsX[4] = currPt.x - 1;
                            ptsX[1] = ptsX[0] + 2;
                            ptsY[1] = ptsY[4] = currPt.y;
                            ptsY[0] = ptsY[4];
                            ptsX[2] = ptsX[0] + 6;
                            ptsX[3] = ptsX[0] - 4;
                            ptsY[2] = ptsY[3] = ptsY[0] - (currPt.y - prevPt.y) / 7;
                            g.fillPolygon(new Polygon(ptsX, ptsY, 5), null);
                        }
                        this.setPreviousPoint();
                    }
                    if (this.area2 != null) {
                        this.area2.setColor(this.area.automatic ? parea.areaColor.darker() : this.area.areaColor.darker());
                        this.area2.draw(g, this.area2, this, this.chart.isShowShadowOnPoint());
                    }
                }
            }
        }
    }

    protected abstract void drawPoint3D(CGraphics var1, Point3D var2);

    private void drawPoint(CGraphics g, Point3D p) {
        if (this.level < this.chart.dataDim) {
            for (MultiDimData element : this.multiData) {
                element.drawPoint(g, this.point.automatic ? p : this.point);
            }
        } else if (!this.plotData.isEmpty()) {
            if (g.g instanceof IFlashGraphics) {
                ((IFlashGraphics)((Object)g.g)).setToolTipsAndLink(this);
            }
            this.drawPoint3D(g, p);
            if (g.g instanceof IFlashGraphics) {
                ((IFlashGraphics)((Object)g.g)).resetToolTipsAndLink();
            }
        }
    }

    private Point3D getPreviousPoint() {
        return this.chart.getGanttEndPoint();
    }

    private void setPreviousPoint() {
        Point3D point3d = new Point3D();
        Area currArea = this.area;
        point3d.x = currArea.p1.x > currArea.p2.x ? currArea.p1.x : currArea.p2.x;
        point3d.y = (currArea.p1.y + currArea.p2.y) / 2;
        this.chart.setGanttEndPoint(point3d);
    }

    private Point3D getCurrentPoint(Point3D prevPt) {
        Point3D currPt = new Point3D();
        Area currArea = this.area;
        int n = currPt.x = currArea.p1.x < currArea.p2.x ? currArea.p1.x : currArea.p2.x;
        if (prevPt.x + 5 > currPt.x) {
            currPt.x = prevPt.x + 5;
        }
        currPt.y = currArea.p1.y > prevPt.y ? (currArea.p1.y > currArea.p2.y ? currArea.p2.y : currArea.p1.y) : (currArea.p1.y < currArea.p2.y ? currArea.p2.y : currArea.p1.y);
        return currPt;
    }

    public void randomColor(Area parea) {
        this.assignColors(parea, false, null);
    }

    public void assignColors(Area parea, boolean grayScale, ChartColorSet chartColorSet) {
        block18: {
            block16: {
                block17: {
                    if (chartColorSet == null) {
                        chartColorSet = new ChartColorSet(false);
                    }
                    if (Chart.stackType(this.chart.chartType)) break block16;
                    if (this.level >= this.chart.dataDim) break block17;
                    if (this.area.automatic) {
                        this.area.setColor(this.chart.getSpace(), parea.areaColor);
                    } else if (this.multiData.length > 0 && this.multiData[0].area.automatic) {
                        this.area.areaColor = this.point.color = chartColorSet.getNextColor(this.area.areaColor);
                    }
                    for (MultiDimData element : this.multiData) {
                        element.assignColors(this.area, grayScale, chartColorSet);
                    }
                    this.area.areaColor = this.point.color = this.multiData[0].area.areaColor;
                    break block18;
                }
                if (this.area.automatic) {
                    this.area.setColor(this.chart.getSpace(), parea.areaColor);
                } else {
                    this.area.areaColor = grayScale ? (this.point.color = chartColorSet.getRandomGrayScale()) : (this.point.color = chartColorSet.getNextColor(this.area.areaColor));
                    this.area.setColor(this.chart.getSpace(), this.area.areaColor);
                }
                if (this.area2 == null) break block18;
                this.area2.setColor(this.chart.getSpace(), this.area.automatic ? parea.areaColor.darker() : this.area.areaColor.darker());
                break block18;
            }
            chartColorSet.resetColorIndex();
            if (this.chart.dataDim == 2) {
                for (int i = 0; i < this.chart.mDataLen[1]; ++i) {
                    MultiDimData b = this.multiData[0].multiData[i];
                    b.area.automatic = false;
                    int shape = b.point.shape;
                    int size = b.point.size;
                    b.point.automatic = false;
                    b.point.color = b.area.areaColor = chartColorSet.getNextColor(b.area.areaColor);
                    this.chart.mddSetColor(b, b);
                    b.setFaceColor(b.area.areaColor);
                    for (int j = 1; j < this.chart.mDataLen[0]; ++j) {
                        if (j >= this.multiData.length) {
                            return;
                        }
                        MultiDimData a = this.multiData[j].multiData[i];
                        this.chart.mddSetColor(a, b);
                        a.setFaceColor(b.area.areaColor);
                        a.area.automatic = false;
                        a.point.automatic = false;
                        a.point.setShape(shape);
                        a.point.setSize(size);
                        a.point.setColor(b.point.color);
                    }
                }
            } else if (this.chart.dataDim == 3) {
                for (int i = 0; i < this.chart.mDataLen[0]; ++i) {
                    for (int j = 0; j < this.chart.mDataLen[2]; ++j) {
                        MultiDimData b = this.multiData[i].multiData[0].multiData[j];
                        b.area.automatic = false;
                        int shape = b.point.shape;
                        int size = b.point.size;
                        b.point.automatic = false;
                        b.point.color = b.area.areaColor = chartColorSet.getNextColor(b.area.areaColor);
                        this.chart.mddSetColor(b, b);
                        b.setFaceColor(b.area.areaColor);
                        for (int k = 1; k < this.chart.mDataLen[1]; ++k) {
                            MultiDimData a = this.multiData[i].multiData[k].multiData[j];
                            this.chart.mddSetColor(a, b);
                            a.setFaceColor(b.point.color);
                            a.area.automatic = false;
                            a.point.automatic = false;
                            a.point.setShape(shape);
                            a.point.setSize(size);
                            a.point.setColor(b.point.color);
                        }
                    }
                }
            }
        }
    }

    public abstract void randomColor(Point3D var1);

    public abstract void setFaceColor(Area var1);

    public abstract void setFaceColor(Color var1);

    public abstract void prepare3DBox(Object var1, Area var2);

    public Object select(CGraphics g, int x, int y) {
        return this.select(g, x, y, this.chart.chartType);
    }

    public Object select(CGraphics g, int x, int y, int chartType) {
        return this.select(g, x, y, chartType, false);
    }

    public Object select(CGraphics g, int x, int y, int chartType, boolean isStep) {
        return null;
    }

    public abstract Object select2(CGraphics var1, int var2, int var3);

    public abstract int selectLine(CGraphics var1, int var2, int var3);

    public abstract MultiDimData selectArea(CGraphics var1, int var2, int var3);

    public abstract MultiDimData selectStackArea(CGraphics var1, int var2, int var3);

    public abstract MultiDimData selectPie(CGraphics var1, int var2, int var3);

    public boolean insideDoughnutArc(int cx, int cy, int w, int h, int startAngle, int endAngle, int x, int y) {
        int arcLen = w / 2;
        if (!this.insideArc(cx, cy, w, h, startAngle, endAngle, x, y)) {
            return false;
        }
        return !this.insideArc(cx, cy, w - arcLen, h - arcLen, startAngle, endAngle, x, y);
    }

    public boolean insideArc(int cx, int cy, int w, int h, int startAngle, int endAngle, int x, int y) {
        double d;
        if ((double)((cx - x) * (cx - x)) / ((double)(w /= 2) * (double)w) + (double)((cy - y) * (cy - y)) / ((double)(h /= 2) * (double)h) > 1.0) {
            return false;
        }
        if (startAngle >= 360) {
            startAngle %= 360;
        }
        if (endAngle - startAngle >= 360) {
            return true;
        }
        endAngle += startAngle;
        double angle = Math.atan2(cy - y, x - cx);
        if (d < 0.0) {
            angle += Math.PI * 2;
        }
        angle *= 57.29577951308232;
        if ((startAngle %= 360) > (endAngle %= 360)) {
            endAngle += 360;
        }
        if (angle >= (double)startAngle && angle <= (double)endAngle) {
            return true;
        }
        return (angle += 360.0) >= (double)startAngle && angle <= (double)endAngle;
    }

    public void reorder(int[] neworder, int lv) {
        if (this.level < lv) {
            for (MultiDimData element : this.multiData) {
                element.reorder(neworder, lv);
            }
        } else {
            MultiDimData[] newMultiData = new MultiDimData[this.multiData.length];
            for (int i = 0; i < this.multiData.length; ++i) {
                newMultiData[i] = neworder[i] < this.multiData.length ? this.multiData[neworder[i]] : this.originalMultiData[neworder[i]];
            }
            this.multiData = newMultiData;
        }
    }

    public abstract void prepare_stacklabel(boolean var1);

    public abstract void prepare_label(boolean var1);

    public abstract void prepare_secondary_label(boolean var1);

    public abstract void prepare_label(boolean var1, MultiDimData var2);

    public abstract void prepare_label3D(boolean var1);

    public abstract void prepare_secondary_label3D(boolean var1);

    public abstract void prepare_stacklabel3D(boolean var1);

    protected int getOffsetLeft(int alignment) {
        if (alignment == 4) {
            return this.chart.dataBorderThickness / 2 + 2;
        }
        if (alignment == 3) {
            return -(this.chart.dataBorderThickness / 2 + 2);
        }
        return 0;
    }

    public int getTopLabelHeight() {
        if (this.chart == null || this.chart.cgraphics == null) {
            return 0;
        }
        CString str = new CString("ABC48yg", this.chart.topvalueLabel_font, null, this.chart.topvalueLabel_color, 0, this.chart.topvalueLabel_angle);
        return str.getFontHeight(this.chart.cgraphics);
    }

    public MultiDimData getRootMData() {
        MultiDimData rootMData = this;
        while (rootMData.parent != null) {
            rootMData = rootMData.parent;
        }
        return rootMData;
    }

    protected void addLabels(boolean bcreate, Color c, Point3D p, String str, int align) {
        this.addLabels(bcreate, c, p, str, align, this, null);
    }

    protected void addLabels(boolean bcreate, Color c, Point3D p, String str, int align, MultiDimData data, Point3D flashPt) {
        this.addLabels(bcreate, c, p, str, align, data, flashPt, true);
    }

    protected void addLabels(boolean bcreate, Color c, Point3D p, String str, int align, MultiDimData data, Point3D flashPt, boolean showLabelInFlash) {
        if (bcreate) {
            data.topLabel = new CString(str, this.chart.topvalueLabel_font, p, c, align, this.chart.topvalueLabel_angle);
            data.topLabel.showLabelInFlash = showLabelInFlash;
            this.chart.topLabels.addElement(data.topLabel);
            if (flashPt != null) {
                data.flashLabel = new CString(str, this.chart.topvalueLabel_font, flashPt, c, align, this.chart.topvalueLabel_angle);
                data.flashLabel.showLabelInFlash = showLabelInFlash;
            }
        } else {
            CString s = (CString)this.chart.topLabels.elementAt(this.chart.toplabel_count);
            s.setFont(this.chart.topvalueLabel_font, this.chart.topvalueLabel_angle);
            s.setColor(c);
            s.setString(str);
            s.setpos(p);
            data.topLabel = s;
            data.topLabel.showLabelInFlash = showLabelInFlash;
            if (flashPt != null) {
                CString s2 = (CString)this.chart.topLabels.elementAt(this.chart.toplabel_count);
                s2.setFont(this.chart.topvalueLabel_font, this.chart.topvalueLabel_angle);
                s2.setColor(c);
                s2.setString(str);
                s2.setpos(flashPt);
                data.flashLabel = s2;
                data.flashLabel.showLabelInFlash = showLabelInFlash;
            }
            ++this.chart.toplabel_count;
        }
    }

    protected void addStackTotalLabel(boolean bcreate, Color c, Point3D p, String str) {
        MultiDimData data = this.multiData[this.multiData.length - 1];
        if (bcreate) {
            int align = this.getCStringAlignForBarChart(this.chart.topLabel_Alignment, false);
            data.stackTotalLabel = new CString(str, this.chart.topvalueLabel_font, p, c, align, this.chart.topvalueLabel_angle);
            this.chart.topLabels.addElement(data.stackTotalLabel);
        } else {
            CString s = (CString)this.chart.topLabels.elementAt(this.chart.toplabel_count);
            s.setFont(this.chart.topvalueLabel_font, this.chart.topvalueLabel_angle);
            s.setColor(c);
            s.setString(str);
            s.setpos(p);
            data.stackTotalLabel = s;
            ++this.chart.toplabel_count;
        }
    }

    protected void addLabels2(boolean bcreate, Point3D p, String str, int align) {
        if (bcreate) {
            this.topLabel = new CString(str, this.chart.topvalueLabel2_font, p, this.chart.topvalueLabel2_color, align, this.chart.topvalueLabel2_angle);
            this.chart.topLabels2.addElement(this.topLabel);
        } else {
            this.topLabel = (CString)this.chart.topLabels2.elementAt(this.chart.toplabel2_count);
            this.topLabel.setFont(this.chart.topvalueLabel2_font, this.chart.topvalueLabel2_angle);
            this.topLabel.setColor(this.chart.topvalueLabel2_color);
            this.topLabel.setString(str);
            this.topLabel.setpos(p);
            ++this.chart.toplabel2_count;
        }
    }

    protected int getCStringAlignForBarChart(int labelAlign, boolean isNegative) {
        switch (labelAlign) {
            case 0: 
            case 4: {
                return isNegative ? 4 : 2;
            }
            case 2: 
            case 3: {
                return isNegative ? 2 : 4;
            }
        }
        return 0;
    }
}

