/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.INativeExport;

public class NativeExport
implements INativeExport {
    private static final Logger LOGGER = Logger.getLogger(NativeExport.class.getName());
    static boolean nativeCode = false;

    static native int exportImage(int var0, int[] var1, int var2, int var3, String var4, int var5);

    public NativeExport() throws IOException {
        this.tryload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryload() throws IOException {
        if (!nativeCode) {
            try {
                NativeExport nativeExport = this;
                synchronized (nativeExport) {
                    System.loadLibrary("qbimg");
                    nativeCode = true;
                }
            }
            catch (Error err) {
                LOGGER.log(Level.SEVERE, "Failed to load image libray 'qbimg'", err);
                throw new IOException("Failed to load image library 'qbimg'");
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to load image libray 'qbimg'", ex);
                throw new IOException("Failed to load image library 'qbimg'");
            }
        }
    }

    @Override
    public synchronized void nativeExport(int dtype, int[] buffer, int width, int height, String filename, int quality) throws IOException {
        this.tryload();
        try {
            if (NativeExport.exportImage(dtype, buffer, width, height, filename, quality) == 0) {
                throw new IOException("Export failed!");
            }
        }
        catch (Error err) {
            nativeCode = false;
            LOGGER.log(Level.SEVERE, "Failed to link library. Please make sure that your JVM is JDK1.1 compatible.", err);
            throw new IOException("Failed to link library. Please make sure  that your JVM is JDK1.1 compatible.");
        }
        catch (Exception ex) {
            nativeCode = false;
            LOGGER.log(Level.SEVERE, "Export failed.", ex);
            throw new IOException("Export failed.");
        }
    }
}

