/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.lang.reflect.Constructor;
import quadbase.chart.ColData;
import quadbase.common.util.IOLAPResultSet;

public class OLAPAccess {
    IOLAPResultSet olapRS;
    String connectionString;
    String MDXQuery;
    String uri;
    String datasource;
    String catalog;
    public static final int OLAPDATA_TRANSPOSECOLUMNBREAK = 0;
    public static final int OLAPDATA_DIRECT = 1;
    public static final int OLAPDATA_CONCATENATELABEL = 2;

    public OLAPAccess(IOLAPResultSet olapRS, String connectionString, String MDXQuery, String uri, String datasource, String catalog) {
        this.olapRS = olapRS;
        this.connectionString = connectionString;
        this.MDXQuery = MDXQuery;
        this.uri = uri;
        this.datasource = datasource;
        this.catalog = catalog;
    }

    public ColData[] retrieveResult(int inputMethod) throws Exception {
        ColData[] colData = null;
        if (this.olapRS == null) {
            this.olapRS = this.connectionString != null && !this.connectionString.equals("") ? this.createMondrianResultSetInstance(this.connectionString, this.MDXQuery) : this.createXMLAResultSetInstance(this.uri, this.datasource, this.catalog, this.MDXQuery);
        }
        colData = inputMethod == 0 ? OLAPAccess.getColDataForCrossTab(this.olapRS) : (inputMethod == 2 ? OLAPAccess.getColDataForChart(this.olapRS) : OLAPAccess.getColDataForSummary(this.olapRS));
        return colData;
    }

    public static final ColData[] getColDataForChart(IOLAPResultSet rs) throws Exception {
        int colCt = 4;
        ColData[] colData = new ColData[colCt];
        if (rs.getRowBreakColumnHeader() != null && rs.getRowBreakColumnHeader().length > 1) {
            String rowBKHeader = "";
            for (int i = 0; i < rs.getRowBreakColumnHeader().length; ++i) {
                rowBKHeader = i == 0 ? rs.getRowBreakColumnHeader()[i] : rowBKHeader + "." + rs.getRowBreakColumnHeader()[i];
            }
            colData[0] = new ColData(rowBKHeader, rs.getRowLabelDataType(), colData.length);
        } else {
            colData[0] = new ColData("", rs.getRowLabelDataType(), colData.length);
        }
        for (int k = 0; k < rs.getRowCount(); ++k) {
            Object val = "";
            for (int i = 0; i < rs.getRowBreakCount(); ++i) {
                val = i == 0 ? rs.getRowLabel(k)[i] : val + "." + rs.getRowLabel(k)[i];
            }
            for (int l = 0; l < rs.getColumnCount(); ++l) {
                colData[0].add(val);
            }
        }
        colData[1] = new ColData("ColBreak", rs.getColumnLabelDataType(), colData.length);
        Object[] colLabel = new Object[rs.getColumnCount()];
        for (int k = 0; k < rs.getColumnCount(); ++k) {
            for (int j = 0; j < rs.getColumnBreakCount(); ++j) {
                colLabel[k] = j == 0 ? rs.getColumnLabel(k)[j] : colLabel[k] + "." + rs.getColumnLabel(k)[j];
            }
        }
        for (int l = 0; l < rs.getRowCount(); ++l) {
            for (Object element : colLabel) {
                colData[1].add(element);
            }
        }
        colData[2] = new ColData("Value", rs.getCellDataType(), colData.length);
        colData[3] = new ColData("qbCount", 4, colData.length);
        int recNo = 0;
        for (int k = 0; k < rs.getRowCount(); ++k) {
            for (int l = 0; l < rs.getColumnCount(); ++l) {
                colData[2].add(rs.getCell(l, k));
                colData[3].add(recNo++);
            }
        }
        return colData;
    }

    public static final ColData[] getColDataForCrossTab(IOLAPResultSet rs) throws Exception {
        int l;
        int i;
        int rowLength = rs.getRowBreakCount() + rs.getColumnBreakCount() + 2;
        ColData[] colData = new ColData[rowLength];
        for (i = 0; i < rs.getRowBreakCount(); ++i) {
            colData[i] = rs.getRowBreakColumnHeader() != null && rs.getRowBreakColumnHeader().length > 1 ? new ColData(rs.getRowBreakColumnHeader()[i], rs.getRowLabelDataType(), colData.length) : new ColData("", rs.getRowLabelDataType(), colData.length);
            for (int k = 0; k < rs.getRowCount(); ++k) {
                Object val = rs.getRowLabel(k)[i];
                for (l = 0; l < rs.getColumnCount(); ++l) {
                    colData[i].add(val);
                }
            }
        }
        for (int j = 0; j < rs.getColumnBreakCount(); ++j) {
            colData[i] = new ColData("ColBreak" + j, rs.getColumnLabelDataType(), colData.length);
            for (int l2 = 0; l2 < rs.getRowCount(); ++l2) {
                for (int k = 0; k < rs.getColumnCount(); ++k) {
                    colData[i].add(rs.getColumnLabel(k)[j]);
                }
            }
            ++i;
        }
        colData[i] = new ColData("Value", rs.getCellDataType(), colData.length);
        colData[i + 1] = new ColData("qbCount", 4, colData.length);
        int recNo = 0;
        for (int k = 0; k < rs.getRowCount(); ++k) {
            for (l = 0; l < rs.getColumnCount(); ++l) {
                colData[i].add(rs.getCell(l, k));
                colData[i + 1].add(recNo++);
            }
        }
        return colData;
    }

    public static final ColData[] getColDataForSummary(IOLAPResultSet rs) throws Exception {
        int i;
        int colLength = rs.getRowBreakCount() + rs.getColumnCount() + 1;
        ColData[] colData = new ColData[colLength];
        for (i = 0; i < rs.getRowBreakCount(); ++i) {
            colData[i] = rs.getRowBreakColumnHeader() != null && rs.getRowBreakColumnHeader().length > 1 ? new ColData(rs.getRowBreakColumnHeader()[i], rs.getRowLabelDataType(), colData.length) : new ColData("", rs.getRowLabelDataType(), colData.length);
            for (int k = 0; k < rs.getRowCount(); ++k) {
                Object val = rs.getRowLabel(k)[i];
                colData[i].add(val);
            }
        }
        for (int j = 0; j < rs.getColumnCount(); ++j) {
            colData[i + j] = new ColData((String)rs.getColumnLabel(j)[rs.getColumnBreakCount() - 1], rs.getCellDataType(), colData.length);
        }
        colData[colLength - 1] = new ColData("qbCount", 4, colData.length);
        int recNo = 0;
        for (int k = 0; k < rs.getRowCount(); ++k) {
            for (int l = 0; l < rs.getColumnCount(); ++l) {
                colData[l + i].add(rs.getCell(l, k));
                colData[colLength - 1].add(recNo++);
            }
        }
        return colData;
    }

    public IOLAPResultSet createMondrianResultSetInstance(String connectionString, String MDXQuery) throws Exception {
        Class[] argsClass = new Class[]{String.class, String.class};
        Object[] argsValue = new Object[]{connectionString, MDXQuery};
        Class<?> objClass = Class.forName("quadbase.common.OLAP.MondrianResultSet");
        Constructor<?> objCons = objClass.getConstructor(argsClass);
        return (IOLAPResultSet)objCons.newInstance(argsValue);
    }

    public IOLAPResultSet createXMLAResultSetInstance(String uri, String datasource, String catalog, String MDXQuery) throws Exception {
        Class[] argsClass = new Class[]{String.class, String.class, String.class, String.class};
        Object[] argsValue = new Object[]{uri, datasource, catalog, MDXQuery};
        Class<?> objClass = Class.forName("quadbase.common.OLAP.XMLAResultSet");
        Constructor<?> objCons = objClass.getConstructor(argsClass);
        return (IOLAPResultSet)objCons.newInstance(argsValue);
    }
}

