/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.util.Date;
import java.util.Vector;
import quadbase.chart.Chart;
import quadbase.chart.Coordinate;
import quadbase.chart.HiLowData;
import quadbase.chart.IOUtil2;
import quadbase.util.internal.BooleanCompare;
import quadbase.util.internal.ICompareObject;
import quadbase.util.internal.NumberCompare;
import quadbase.util.internal.SortObject;

public class PlotData {
    public Chart chart;
    public Object element = null;
    public boolean bSlice = false;
    public float percentage = 0.0f;
    Vector<Object> dataList = new Vector();
    public Object maxValue = null;
    public Object minValue = null;
    public Object halfValue = null;
    public Object quartValue = null;
    public Object threeQuartValue = null;
    public static final int VAL = 0;
    public static final int VALMAX = 1;
    public static final int VALMIN = 2;
    public static final int VAL25 = 3;
    public static final int VAL50 = 4;
    public static final int VAL75 = 5;
    private static final Double NOTUSE_HLCO_COL = -1.7976931348623157E308;
    private boolean isNullForScatter = false;
    private double pieOthersSum = 0.0;

    public PlotData(Chart ch) {
        this.chart = ch;
    }

    public final boolean isEmpty() {
        if (this.pieOthersSum > 0.0) {
            return false;
        }
        if (this.chart.isNullDataAsZero()) {
            return false;
        }
        if (this.element == null) {
            return true;
        }
        if (this.chart.chartType == 2 && !this.chart.isShowNullInScatter()) {
            return this.isNullForScatter;
        }
        if (this.chart.isZeroAsNullData()) {
            return this.getValue() == 0.0;
        }
        return false;
    }

    public final void setPercentage(float percent) {
        this.percentage = percent;
    }

    public final void add(int recNo, boolean firstvalue) {
        if (firstvalue) {
            Object obj = this.makeData(recNo);
            if (obj != null) {
                if (this.chart.chartType == 15) {
                    this.dataList.addElement(obj);
                } else {
                    this.element = obj;
                }
            }
        } else {
            Object obj = this.getObj(this.chart.subvalueCol, recNo);
            if (obj != null) {
                this.element = obj;
            }
        }
    }

    private final Object getObj(int col, int recNo) {
        return col < 0 ? NOTUSE_HLCO_COL : this.chart.colData[col].getData(recNo);
    }

    private final double getD(int col, int recNo) {
        double v = this.chart.colData[this.chart.coordCol[col]].getValue(recNo);
        return v;
    }

    private final boolean isNull(int recNo) {
        if (this.chart.colData[this.chart.coordCol[0]].getData(recNo) == null) {
            return true;
        }
        return this.chart.colData[this.chart.coordCol[1]].getData(recNo) == null;
    }

    private final boolean isNullHiLow(int recNo) {
        if (this.chart.colData[this.chart.hilowCol.hi].getData(recNo) == null) {
            return true;
        }
        return this.chart.colData[this.chart.hilowCol.low].getData(recNo) == null;
    }

    private final double getV(int col, int recNo) {
        return col < 0 ? -1.7976931348623157E308 : this.chart.colData[col].getValue(recNo);
    }

    private final Object makeData(int recNo) {
        switch (this.chart.chartType) {
            case 12: 
            case 13: 
            case 19: {
                double d0 = this.getD(0, recNo);
                double d1 = this.getD(1, recNo);
                return new Coordinate(d0, d1, !this.chart.bcoordCol[2] ? 0.0 : this.getD(2, recNo));
            }
            case 2: {
                double d0 = this.getD(0, recNo);
                double d1 = this.getD(1, recNo);
                this.isNullForScatter = this.isNull(recNo);
                return new Coordinate(d0, d1, this.chart.is2DChart || !this.chart.bcoordCol[2] ? 0.0 : this.getD(2, recNo));
            }
            case 9: 
            case 10: {
                Object o3;
                Object o2;
                Object o0 = this.getObj(this.chart.hilowCol.hi, recNo);
                Object o1 = this.getObj(this.chart.hilowCol.low, recNo);
                if (this.chart.chartType == 10) {
                    o2 = this.getObj(this.chart.hilowCol.open, recNo);
                    o3 = this.getObj(this.chart.hilowCol.close, recNo);
                } else {
                    o2 = NOTUSE_HLCO_COL;
                    o3 = NOTUSE_HLCO_COL;
                }
                if (this.isEmptyHLCO(o0, o1, o2, o3)) {
                    return null;
                }
                return new HiLowData(IOUtil2.getValue(o0), IOUtil2.getValue(o1), IOUtil2.getValue(o2), IOUtil2.getValue(o3));
            }
            case 18: {
                double d0 = this.getV(this.chart.hilowCol.hi, recNo);
                double d1 = this.getV(this.chart.hilowCol.low, recNo);
                if (this.isNullHiLow(recNo)) {
                    return null;
                }
                double d3 = this.getV(this.chart.hilowCol.open, recNo);
                return new HiLowData(d0, d1, d3, this.getV(this.chart.hilowCol.close, recNo));
            }
        }
        return this.getObj(this.chart.valueCol, recNo);
    }

    private boolean isEmptyHLCO(Object o0, Object o1, Object o2, Object o3) {
        if (o0 != null && o0 != NOTUSE_HLCO_COL) {
            return false;
        }
        if (o1 != null && o1 != NOTUSE_HLCO_COL) {
            return false;
        }
        if (o2 != null && o2 != NOTUSE_HLCO_COL) {
            return false;
        }
        return o3 == null || o3 == NOTUSE_HLCO_COL;
    }

    public final boolean isPieOthersSector() {
        return this.pieOthersSum > 0.0;
    }

    public final double getPieOthersSum() {
        return this.pieOthersSum;
    }

    public final void setPieOthersSum(double sum) {
        this.pieOthersSum = sum;
    }

    public final double getValue() {
        double v = IOUtil2.getValue(this.element);
        if (v == Double.NEGATIVE_INFINITY || v == Double.POSITIVE_INFINITY || v == Double.NaN) {
            v = 0.0;
        }
        return v;
    }

    public double getValue(int valueType) {
        double v;
        if (this.maxValue == null) {
            this.computeBoxData();
        }
        if ((v = valueType == 1 ? IOUtil2.getValue(this.maxValue) : (valueType == 2 ? IOUtil2.getValue(this.minValue) : (valueType == 3 ? IOUtil2.getValue(this.quartValue) : (valueType == 5 ? IOUtil2.getValue(this.threeQuartValue) : (valueType == 4 ? IOUtil2.getValue(this.halfValue) : IOUtil2.getValue(this.element)))))) == Double.NEGATIVE_INFINITY || v == Double.POSITIVE_INFINITY || v == Double.NaN) {
            v = 0.0;
        }
        return v;
    }

    public double[] getOutiler() {
        if (this.threeQuartValue == null) {
            this.computeBoxData();
        }
        if (this.dataList.size() == 0) {
            return null;
        }
        double[] outiler = new double[this.dataList.size()];
        for (int i = 0; i < this.dataList.size(); ++i) {
            outiler[i] = IOUtil2.getValue(this.dataList.elementAt(i));
        }
        return outiler;
    }

    private void computeBoxData() {
        int i;
        if (this.dataList.size() == 0) {
            return;
        }
        int nRow = this.dataList.size();
        ICompareObject[] obj = new ICompareObject[nRow];
        for (int i2 = 0; i2 < nRow; ++i2) {
            Object obj2 = this.dataList.elementAt(i2);
            if (obj2 instanceof Number) {
                obj[i2] = new NumberCompare((Number)obj2);
                continue;
            }
            if (obj2 instanceof Date) {
                obj[i2] = new NumberCompare(((Date)obj2).getTime());
                continue;
            }
            if (!(obj2 instanceof Boolean)) continue;
            obj[i2] = new BooleanCompare((Boolean)obj2);
        }
        Object[] newList = SortObject.sort(obj, true);
        if (nRow > 1) {
            for (int i3 = 1; i3 < 4; ++i3) {
                double ratio = 0.25 * (double)i3;
                double gap = nRow - 1;
                gap = 1.0 / gap;
                int lowIndex = (int)Math.floor(ratio / gap);
                double val = ((ratio - (double)lowIndex * gap) * IOUtil2.getValue(newList[lowIndex + 1]) + ((double)(lowIndex + 1) * gap - ratio) * IOUtil2.getValue(newList[lowIndex])) / gap;
                if (i3 == 1) {
                    this.quartValue = val;
                    continue;
                }
                if (i3 == 2) {
                    this.element = this.halfValue = Double.valueOf(val);
                    continue;
                }
                if (i3 != 3) continue;
                this.threeQuartValue = val;
            }
        } else {
            this.halfValue = this.threeQuartValue = newList[0];
            this.quartValue = this.threeQuartValue;
        }
        this.dataList.removeAllElements();
        double range = (IOUtil2.getValue(this.threeQuartValue) - IOUtil2.getValue(this.quartValue)) * 1.5;
        double limit = IOUtil2.getValue(this.quartValue) - range;
        for (i = 0; i < newList.length && IOUtil2.getValue(newList[i]) < limit; ++i) {
            this.dataList.addElement(newList[i]);
        }
        if (i > newList.length - 1) {
            i = newList.length - 1;
        }
        this.minValue = newList[i];
        limit = IOUtil2.getValue(this.threeQuartValue) + range;
        for (i = nRow - 1; i >= 0 && IOUtil2.getValue(newList[i]) > limit; --i) {
            this.dataList.addElement(newList[i]);
        }
        if (i >= 0) {
            this.maxValue = newList[i];
        }
        if (IOUtil2.getValue(newList[nRow - 1]) > IOUtil2.getValue(this.maxValue)) {
            this.maxValue = newList[nRow - 1];
        }
    }
}

