/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.util.logging.Logger;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.MultiDimData;
import quadbase.chart.QbPattern;
import quadbase.chart.StepSize;
import quadbase.util.IGradientSupport;
import quadbase.util.internal.Graphics2DTool;
import quadbase.util.internal.IOUtil;

public class Point3D {
    private static final Logger LOGGER = Logger.getLogger(Point3D.class.getName());
    public static final int MAX_SIZE = 20;
    public static final int RADIUS = 3;
    public static final int CROSS = 0;
    public static final int CIRCLE = 1;
    public static final int SQUARE = 2;
    public static final int TRIANGLE = 3;
    public static final int PLUS = 4;
    public static final int STAR = 5;
    public static final int DASH = 6;
    public static final int NOSYMBOL = 7;
    public static final int INVERSE_TRIANGLE = 8;
    public static final int DIAMOND = 9;
    public static final int TOTALSHAPE = 10;
    public static final int BACK_LINE = 100;
    public static int shapeCount = 0;
    public static final String[] shapeNames = new String[]{"Cross", "Circle", "Square", "Triangle", "Plus", "Star", "Line", "No Symbol", "Inverse Triangle", "Diamond"};
    public int x;
    public int y;
    public int z;
    public int shape;
    public int size = 0;
    public Color color = Color.black;
    public boolean automatic = true;
    public boolean is2D = true;
    public Color borderColor = Color.black;

    public Point3D(int _x, int _y, int _z) {
        this.x = _x;
        this.y = _y;
        this.z = _z;
    }

    public Point3D(int _x, int _y) {
        this.x = _x;
        this.y = _y;
        this.z = 0;
    }

    public Point3D(int _x, int _y, Color _color, int _shape) {
        this(_x, _y);
        this.color = _color;
        this.shape = _shape;
    }

    public Point3D(int _x, int _y, Color _color, int _shape, int _size) {
        this(_x, _y, _color, _shape);
        this.size = _size;
    }

    public Point3D(int _x, int _y, Color _color, int _shape, int _size, Color _borderColor) {
        this(_x, _y, _color, _shape);
        this.size = _size;
        this.borderColor = _borderColor;
    }

    public Point3D() {
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public Point3D(Color _color) {
        this();
        this.color = _color;
    }

    public Point3D(Color _color, int _shape) {
        this(_color);
        this.shape = _shape;
    }

    public void setShape(int _shape) {
        this.shape = _shape;
    }

    public void setSize(int _size) {
        this.size = _size;
    }

    public void setShape() {
        if (shapeCount == 7) {
            shapeCount = (shapeCount + 1) % 10;
        }
        this.shape = shapeCount;
        shapeCount = (shapeCount + 1) % 10;
    }

    public void setColor(Color _color) {
        this.color = _color;
    }

    public void setBorderColor(Color _color) {
        this.borderColor = _color;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public void drawPt(CGraphics g) {
        this.drawPoints(g, this, this.color, this.shape, this.size, false, false, this.borderColor, null, null);
    }

    public void drawPt(CGraphics g, boolean drawBorder, boolean drawSymbolWithLine, IGradientSupport gradientSupport) {
        this.drawPoints(g, this, this.color, this.shape, this.size, drawBorder, drawSymbolWithLine, this.borderColor, null, gradientSupport);
    }

    public void drawPt(CGraphics g, Point3D p, IGradientSupport gradientSupport) {
        this.drawPoints(g, this, p.color, p.shape, p.size, false, false, this.borderColor, null, gradientSupport);
    }

    public void drawPt(CGraphics g, Point3D p, boolean drawBorder, Color borderColor, MultiDimData data, IGradientSupport gradientSupport) {
        this.drawPoints(g, this, p.color, p.shape, p.size, drawBorder, false, borderColor, data, gradientSupport);
    }

    private void drawPoints(CGraphics g, Point3D p, Color color, int shape, int size, boolean drawBorder, boolean drawSymbolWithLine, Color borderColor, MultiDimData data, IGradientSupport gradientSupport) {
        if (shape < 0) {
            return;
        }
        if (borderColor.getRGB() != Color.black.getRGB()) {
            borderColor = color.darker();
        }
        Color orgColor = null;
        Color orgBorderColor = null;
        if (g.chart.flashRatio != 1.0) {
            orgColor = color;
            orgBorderColor = borderColor;
            color = new Color(orgColor.getRed(), orgColor.getGreen(), orgColor.getBlue(), (int)Math.rint(255.0 * g.chart.flashRatio));
            borderColor = new Color(orgBorderColor.getRed(), orgBorderColor.getGreen(), orgBorderColor.getBlue(), (int)Math.rint(255.0 * g.chart.flashRatio));
        }
        g.setColor(color);
        if (size < -2) {
            g.fillArea(p.x - 1, p.y - 1, p.x + 1, p.y + 1, 1, 1, data, false, 0, gradientSupport);
            return;
        }
        int ptRadius = 3;
        if (size < 0) {
            ptRadius += size;
            size = 0;
        }
        if ((shape %= 256) > 100) {
            shape -= 100;
            drawSymbolWithLine = true;
        }
        if (shape != 6 && shape != 7 && drawSymbolWithLine) {
            if (!drawBorder) {
                g.fillLine(p.x - (int)((double)(ptRadius + size + 1) * 1.5), p.y, p.x + (int)((double)(ptRadius + size + 1) * 1.5), p.y, (ptRadius + size) / 2, data);
            } else {
                g.fillLine(p.x - (int)((double)(ptRadius + size + 1) * 1.5), p.y, p.x + (int)((double)(ptRadius + size + 1) * 1.5), p.y, (ptRadius + size) / 2, data, 0, true, true, borderColor);
            }
        }
        switch (shape) {
            case 7: {
                break;
            }
            case 0: {
                if (!drawBorder) {
                    g.fillLine(p.x - ptRadius - size, p.y - ptRadius - size, p.x + ptRadius + size, p.y + ptRadius + size, ptRadius + size, data);
                    g.fillLine(p.x + ptRadius + size, p.y - ptRadius - size, p.x - ptRadius - size, p.y + ptRadius + size, ptRadius + size, data);
                    break;
                }
                g.fillLine(p.x - ptRadius - size, p.y - ptRadius - size, p.x + ptRadius + size, p.y + ptRadius + size, ptRadius + size, data, 0, true, true, borderColor);
                g.fillLine(p.x + ptRadius + size, p.y - ptRadius - size, p.x - ptRadius - size, p.y + ptRadius + size, ptRadius + size, data, 0, true, true, borderColor);
                break;
            }
            case 1: {
                if (size == 0) {
                    size = 1;
                }
                g.fillOval(p.x - ptRadius - size, p.y - ptRadius - size, p.x + ptRadius + size, p.y + ptRadius + size, data, false);
                for (int i = 1; i < ptRadius + size; ++i) {
                    g.drawOval(p.x - i, p.y - i, p.x + i, p.y + i);
                }
                if (!drawBorder) break;
                g.setColor(borderColor);
                g.drawOval(p.x - ptRadius - --size, p.y - ptRadius - size, p.x + ptRadius + size, p.y + ptRadius + size);
                g.setColor(color);
                break;
            }
            case 2: {
                if (!drawBorder) {
                    g.fillArea(p.x - ptRadius - size, p.y - ptRadius - size, p.x + ptRadius + size, p.y + ptRadius + size, 1, 1, data, false, 0, gradientSupport);
                    break;
                }
                g.fillArea(p.x - ptRadius - size, p.y - ptRadius - size, p.x + ptRadius + size, p.y + ptRadius + size, 0, 1, data, false, 0, gradientSupport);
                g.setColor(borderColor);
                g.drawRect(p.x - ptRadius - size, g.height - p.y - ptRadius - size, (ptRadius + size) * 2, (ptRadius + size) * 2);
                g.setColor(color);
                break;
            }
            case 3: {
                if (size == 0) {
                    size = 1;
                }
                int[] px = new int[]{p.x + ptRadius + size, p.x - ptRadius - size, p.x};
                int[] py = new int[]{p.y - ptRadius - size, p.y - ptRadius - size, p.y + ptRadius + size};
                g.fillPolygon(new Polygon(px, py, 3), data);
                if (!drawBorder) break;
                g.setColor(borderColor);
                g.drawLine(px[0], py[0], px[2], py[2]);
                g.drawLine(px[1], py[1], px[2], py[2]);
                g.drawLine(px[0], py[0], px[1], py[1]);
                g.setColor(color);
                break;
            }
            case 8: {
                if (size == 0) {
                    size = 1;
                }
                int[] px = new int[]{p.x + ptRadius + size, p.x - ptRadius - size, p.x};
                int[] py = new int[]{p.y + ptRadius + size, p.y + ptRadius + size, p.y - ptRadius - size};
                g.fillPolygon(new Polygon(px, py, 3), data);
                if (!drawBorder) break;
                g.setColor(borderColor);
                g.drawLine(px[0], py[0], px[2], py[2]);
                g.drawLine(px[1], py[1], px[2], py[2]);
                g.drawLine(px[0], py[0], px[1], py[1]);
                g.setColor(color);
                break;
            }
            case 4: {
                if (!drawBorder) {
                    g.fillLine(p.x - ptRadius - size - 1, p.y, p.x + ptRadius + size + 1, p.y, ptRadius + size, data);
                    g.fillLine(p.x, p.y - ptRadius - size, p.x, p.y + ptRadius + size, ptRadius + size, data);
                    break;
                }
                g.fillLine(p.x - ptRadius - size - 1, p.y, p.x + ptRadius + size + 1, p.y, ptRadius + size, data, 0, true, true, borderColor);
                g.fillLine(p.x, p.y - ptRadius - size, p.x, p.y + ptRadius + size, ptRadius + size, data, 0, true, true, borderColor);
                break;
            }
            case 5: {
                if (!drawBorder) {
                    g.fillLine(p.x, p.y - ptRadius - size, p.x, p.y + ptRadius + size, ptRadius + size, data);
                    g.fillLine(p.x, p.y - ptRadius - size, p.x, p.y + ptRadius + size, ptRadius + size, data);
                    g.fillLine(p.x - ptRadius - size, p.y - ptRadius - size, p.x + ptRadius + size, p.y + ptRadius + size, ptRadius + size, data);
                    g.fillLine(p.x + ptRadius + size, p.y - ptRadius - size, p.x - ptRadius - size, p.y + ptRadius + size, ptRadius + size, data);
                    break;
                }
                g.fillLine(p.x, p.y - ptRadius - size, p.x, p.y + ptRadius + size, ptRadius + size, data, 0, true, true, borderColor);
                g.fillLine(p.x - ptRadius - size - 1, p.y, p.x + ptRadius + size + 1, p.y, ptRadius + size, data, 0, true, true, borderColor);
                g.fillLine(p.x - ptRadius - size, p.y - ptRadius - size, p.x + ptRadius + size, p.y + ptRadius + size, ptRadius + size, data, 0, true, true, borderColor);
                g.fillLine(p.x + ptRadius + size, p.y - ptRadius - size, p.x - ptRadius - size, p.y + ptRadius + size, ptRadius + size, data, 0, true, true, borderColor);
                break;
            }
            case 6: {
                if (!drawBorder) {
                    g.fillLine(p.x - ptRadius - size - 1, p.y, p.x + ptRadius + size + 1, p.y, ptRadius + size, data);
                    break;
                }
                g.fillLine(p.x - ptRadius - size - 1, p.y, p.x + ptRadius + size + 1, p.y, ptRadius + size, data, 0, true, true, borderColor);
                break;
            }
            case 9: {
                if (size == 0) {
                    size = 1;
                }
                int[] px = new int[]{p.x, p.x + ptRadius + size, p.x, p.x - ptRadius - size};
                int[] py = new int[]{p.y + ptRadius + size, p.y, p.y - ptRadius - size, p.y};
                g.fillPolygon(new Polygon(px, py, 4), data);
                if (!drawBorder) break;
                g.setColor(borderColor);
                g.drawLine(px[3], py[3], px[0], py[0]);
                g.drawLine(px[2], py[2], px[3], py[3]);
                g.drawLine(px[1], py[1], px[2], py[2]);
                g.drawLine(px[0], py[0], px[1], py[1]);
                g.setColor(color);
                break;
            }
            default: {
                LOGGER.warning("Unknown shape " + shape);
            }
        }
        if (g.chart.flashRatio != 1.0) {
            color = orgColor;
            borderColor = orgBorderColor;
        }
    }

    public void drawBubble(CGraphics cg, Color color, double zValue) {
        Graphics g = cg.g;
        g.setColor(color);
        Color colorBorder = color;
        Chart chart = cg.chart;
        StepSize xstep = chart.a_x.stepsize;
        if (chart.bubbleAreaRelativeToValue) {
            zValue = Math.sqrt(zValue);
        }
        int radius = (int)(zValue * chart.axisUnitToRadiusRatio * chart.flashRatio * xstep.width_dvalue);
        int diameter = 2 * radius;
        if (chart.bubbleDrawMode == 0) {
            g.drawOval(this.x - radius, cg.height - this.y - radius, diameter, diameter);
        } else if (chart.bubbleDrawMode == 1) {
            if (!chart.bubble3D) {
                if (color instanceof QbPattern && ((QbPattern)color).getPatternTypeID() != 0) {
                    Graphics2DTool.fillPatternOval(g, (QbPattern)color, this.x - radius, cg.height - this.y - radius, diameter, diameter);
                } else if (chart.getPrimaryDataGradientSupport().isGradientEnabled()) {
                    Graphics2DTool.fillGradientOval(g, chart, color, this.x - radius, cg.height - this.y - radius, diameter, diameter, chart.getPrimaryDataGradientSupport());
                } else {
                    g.fillOval(this.x - radius, cg.height - this.y - radius, diameter, diameter);
                }
            } else {
                int red = color.getRed();
                int green = color.getGreen();
                int blue = color.getBlue();
                int lastX = this.x - radius;
                int lastY = cg.height - this.y - radius;
                int j = 95;
                double shadowInt = (100.0 - (double)chart.bubble3DLight) / 100.0;
                colorBorder = new Color(red * (100 - (int)((double)j * shadowInt)) / 100, green * (100 - (int)((double)j * shadowInt)) / 100, blue * (100 - (int)((double)j * shadowInt)) / 100);
                int patternID = 0;
                if (color instanceof QbPattern) {
                    patternID = ((QbPattern)color).getPatternTypeID();
                }
                for (int i = j; i >= 1; --i) {
                    Color tempColor;
                    double thisDiameter = (double)diameter * (double)(i + 5) / 100.0;
                    int thisX = lastX + (int)(((double)diameter - thisDiameter) * 3.0 / 10.0);
                    int thisY = lastY + (int)(((double)diameter - thisDiameter) * 3.0 / 10.0);
                    if (patternID > 0) {
                        tempColor = new Color(red * (100 - (int)((double)i * shadowInt)) / 100, green * (100 - (int)((double)i * shadowInt)) / 100, blue * (100 - (int)((double)i * shadowInt)) / 100);
                        QbPattern pattern = new QbPattern(tempColor, patternID);
                        Graphics2DTool.fillPatternOval(g, pattern, thisX, thisY, (int)thisDiameter, (int)thisDiameter);
                        continue;
                    }
                    if (cg.chart.getPrimaryDataGradientSupport().isGradientEnabled()) {
                        tempColor = new Color(red * (100 - (int)((double)i * shadowInt)) / 100, green * (100 - (int)((double)i * shadowInt)) / 100, blue * (100 - (int)((double)i * shadowInt)) / 100);
                        Graphics2DTool.fillGradientOval(g, chart, tempColor, thisX, thisY, (int)thisDiameter, (int)thisDiameter, chart.getPrimaryDataGradientSupport());
                        continue;
                    }
                    g.setColor(new Color(red * (100 - (int)((double)i * shadowInt)) / 100, green * (100 - (int)((double)i * shadowInt)) / 100, blue * (100 - (int)((double)i * shadowInt)) / 100));
                    g.fillOval(thisX, thisY, (int)thisDiameter, (int)thisDiameter);
                }
                if (IOUtil.isJava2D() && chart.bubble3D) {
                    chart.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(colorBorder);
                    g.drawOval(this.x - radius, cg.height - this.y - radius, diameter, diameter);
                }
            }
            if (chart.drawDataBorder) {
                g.setColor(Color.black);
                g.drawOval(this.x - radius, cg.height - this.y - radius, diameter, diameter);
            }
        }
    }

    public boolean isInsideBubble(CGraphics cg, double zValue, int xMouse, int yMouse) {
        Chart chart = cg.chart;
        StepSize xstep = chart.a_x.stepsize;
        int radius = (int)(zValue * chart.axisUnitToRadiusRatio * xstep.width_dvalue);
        return (this.x - xMouse) * (this.x - xMouse) + (this.y - yMouse) * (this.y - yMouse) <= radius * radius;
    }

    public Point3D copy() {
        Point3D newp = new Point3D(this.x, this.y, this.z);
        newp.color = this.color;
        newp.shape = this.shape;
        newp.automatic = this.automatic;
        newp.is2D = this.is2D;
        return newp;
    }

    public static final int shapefn(int s1, int s2) {
        int val = (s1 /= 256) * 256 + s2 % 256;
        int shapeID = s1 % 256;
        if (shapeID > 100) {
            return s1 * 256 + (shapeID - 100) % 10 + 100;
        }
        return val;
    }
}

