/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.Point3D;
import quadbase.util.ITextString;
import quadbase.util.Position;

public class PropCString
extends CString
implements ITextString {
    public float xprop;
    public float yprop;

    public PropCString(String s, float xprop, float yprop, Font font, Color color, int angle) {
        super(s, font, new Point3D(), color, 0, angle);
        this.xprop = xprop;
        this.yprop = yprop;
    }

    public PropCString(ITextString t) {
        this.set(t);
    }

    public void set(ITextString t) {
        this.setValue(t.getValue());
        this.setFont(t.getFont());
        this.setAngle(t.getAngle());
        this.setColor(t.getColor());
        this.setPosition(t.getPosition());
    }

    @Override
    public void draw(CGraphics g) {
        Chart c = g.chart;
        this.pos.x = (int)((float)c.chartxorigin + (float)c.chartwidth * this.xprop);
        this.pos.y = (int)((float)c.chartyorigin + (float)c.chartheight * this.yprop);
        super.draw(g);
    }

    @Override
    public Dimension getOffset() {
        throw new IllegalArgumentException("Offsets not supported.");
    }

    @Override
    public void setOffset(Dimension offset) {
        throw new IllegalArgumentException("Offsets not supported.");
    }

    @Override
    public Position getPosition() {
        return new Position(this.xprop, this.yprop);
    }

    @Override
    public void setPosition(Position pos) {
        this.xprop = pos.getX();
        this.yprop = pos.getY();
    }

    public boolean equals(ITextString t) {
        return t != null && this.getValue().equals(t.getValue()) && this.getFont().equals(t.getFont()) && this.getAngle() == t.getAngle() && this.getColor().equals(t.getColor()) && this.getPosition().equals(t.getPosition());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< PropCString >>\n");
        sb.append("parent class: ").append(super.toString());
        sb.append("xprop\t\t= ").append(this.xprop).append("\n");
        sb.append("yprop\t\t= ").append(this.yprop).append("\n");
        return sb.toString();
    }
}

