/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.applet.Applet;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.DataFileInput;
import quadbase.chart.FilterInfo;
import quadbase.chart.IOUtil2;
import quadbase.chart.LoadChart;
import quadbase.chart.PreprocInfo;
import quadbase.chart.SaveChart;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.pak.PakFile;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.CastUtil;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.HttpsIO;
import quadbase.common.util.internal.OrgUtil;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.util.IResultSet;
import quadbase.util.XMLQueryResultSet;
import quadbase.util.internal.IOUtil;

public class ReadDataFile {
    private static final Logger LOGGER = Logger.getLogger(ReadDataFile.class.getName());
    InputStream inputstream;

    public DataInputStream getInputStream(String filename) throws Exception {
        return this.getInputStream((FileInMemTable)null, filename);
    }

    public DataInputStream getInputStream(Chart chart, String filename) throws Exception {
        return this.getInputStream(chart == null ? null : chart.getSubFilesTable(), filename);
    }

    public DataInputStream getInputStream(FileInMemTable subFilesTable, String filename) throws Exception {
        DataInputStream din;
        block20: {
            if (subFilesTable != null) {
                this.inputstream = Chart.getSubFileStream(subFilesTable, filename);
                if (this.inputstream != null) {
                    return new DataInputStream(this.inputstream);
                }
            }
            Applet applet = ServerMessage.getApplet();
            String urlfile = filename;
            filename = filename.replace('\\', '/');
            try {
                if (filename.startsWith("http://") || filename.startsWith("file://") || filename.startsWith("jar:")) {
                    try {
                        this.inputstream = new URL(urlfile).openConnection().getInputStream();
                        din = new DataInputStream(this.inputstream);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to open a connection", ex);
                        din = ReadDataFile.getFromServer(filename, false, null, null, null, 20876);
                    }
                    break block20;
                }
                if (filename.startsWith("https://")) {
                    try {
                        din = new DataInputStream(HttpsIO.getHttpsInputStream(filename));
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to open secured connection", ex);
                        din = ReadDataFile.getFromServer(filename, false, null, null, null, 20876);
                    }
                    break block20;
                }
                if (filename.toLowerCase().startsWith("zip:")) {
                    PakFile pakFile = new PakFile(filename);
                    this.inputstream = pakFile.getInputStream();
                    din = new DataInputStream(this.inputstream);
                    break block20;
                }
                if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
                    if (OrgUtil.isChartData(filename)) {
                        return new DataInputStream(new ByteArrayInputStream(OrgUtil.getChartData(filename)));
                    }
                    if (!filename.startsWith("/") && filename.indexOf(58) < 0) {
                        if (applet != null) {
                            this.inputstream = new URL(IOUtil.getCodeBase(applet) + filename).openStream();
                            din = new DataInputStream(this.inputstream);
                        } else {
                            this.inputstream = IOUtil.createFileInputStream(filename);
                            din = new DataInputStream(this.inputstream);
                        }
                    } else {
                        this.inputstream = new FileInputStream(filename);
                        din = new DataInputStream(this.inputstream);
                    }
                    break block20;
                }
                return ReadDataFile.getFromServer(filename, false, null, null, null, 20876);
            }
            catch (Exception ex) {
                if (this.inputstream != null) {
                    try {
                        this.inputstream.close();
                    }
                    catch (Exception ex2) {
                        LOGGER.log(Level.FINEST, "Failed to close connection", ex2);
                    }
                }
                LOGGER.log(Level.FINE, "Failed to get input stream", ex);
                throw ex;
            }
        }
        return din;
    }

    IResultSet createXMLResultSet(String filename) throws Exception {
        Applet applet = ServerMessage.getApplet();
        String urlfile = filename;
        filename = filename.replace('\\', '/');
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (filename.startsWith("http://") || filename.startsWith("https://") || filename.startsWith("file://")) {
                return this.createXMLResultSetInstance(new Class[]{String.class}, new Object[]{urlfile});
            }
            if (!filename.startsWith("/") && filename.indexOf(58) < 0) {
                if (applet != null) {
                    return this.createXMLResultSetInstance(new Class[]{String.class}, new Object[]{IOUtil.getCodeBase(applet) + filename});
                }
                return this.createXMLResultSetInstance(new Class[]{File.class}, new Object[]{IOUtil.createFile(filename)});
            }
            return this.createXMLResultSetInstance(new Class[]{File.class}, new Object[]{new File(filename)});
        }
        return this.createXMLResultSetInstance(new Class[]{InputStream.class}, new Object[]{this.getInputStream(filename)});
    }

    private IResultSet createXMLResultSetInstance(Class[] argsClass, Object[] argsValue) throws Exception {
        Class<?> objClass = Class.forName("quadbase.util.XMLResultSet");
        Constructor<?> objCons = objClass.getConstructor(argsClass);
        return (IResultSet)objCons.newInstance(argsValue);
    }

    public Chart createXMLChart(String filename, Component comp) throws Exception {
        return this.createXMLChart(filename, comp, false, null);
    }

    public Chart createXMLChart(String filename, Component comp, boolean isEnterpriseServer, Vector parameters) throws Exception {
        Applet applet = ServerMessage.getApplet();
        String urlfile = filename;
        filename = filename.replace('\\', '/');
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (filename.startsWith("http://") || filename.startsWith("https://") || filename.startsWith("file://")) {
                return this.createXMLChartInstance(new Class[]{String.class, Component.class}, new Object[]{urlfile, comp}, isEnterpriseServer, parameters);
            }
            if (!filename.startsWith("/") && filename.indexOf(58) < 0) {
                if (applet != null) {
                    return this.createXMLChartInstance(new Class[]{String.class, Component.class}, new Object[]{IOUtil.getCodeBase(applet) + filename, comp}, isEnterpriseServer, parameters);
                }
                return this.createXMLChartInstance(new Class[]{File.class, Component.class}, new Object[]{IOUtil.createFile(filename), comp}, isEnterpriseServer, parameters);
            }
            return this.createXMLChartInstance(new Class[]{File.class, Component.class}, new Object[]{new File(filename), comp}, isEnterpriseServer, parameters);
        }
        LoadChart lc = new LoadChart();
        if (parameters != null) {
            lc.setParameterField(parameters);
        }
        return lc.load(comp, ReadDataFile.getFromServer(filename, false, null, null, null, 24578), false, null, isEnterpriseServer);
    }

    private Chart createXMLChartInstance(Class[] argsClass, Object[] argsValue, boolean isEnterpriseServer, Vector parameters) throws Exception {
        Class<?> objClass = Class.forName("quadbase.chart.xml.XMLChart");
        Constructor<?> objCons = objClass.getConstructor(argsClass);
        Object xmlChart = objCons.newInstance(argsValue);
        if (parameters != null) {
            Method objMethod1 = objClass.getMethod("setParameterField", Vector.class);
            objMethod1.invoke(xmlChart, parameters);
        }
        Method objMethod = objClass.getMethod("createChart", Boolean.class);
        return (Chart)objMethod.invoke(xmlChart, isEnterpriseServer);
    }

    public Chart applyXMLTemplate(String filename, Component comp, Chart chart) throws Exception {
        Applet applet = ServerMessage.getApplet();
        String urlfile = filename;
        filename = filename.replace('\\', '/');
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (filename.startsWith("http://") || filename.startsWith("https://") || filename.startsWith("file://")) {
                return this.applyXMLTemplateInstance(new Class[]{String.class, Component.class}, new Object[]{urlfile, comp}, chart);
            }
            if (!filename.startsWith("/") && filename.indexOf(58) < 0) {
                if (applet != null) {
                    return this.applyXMLTemplateInstance(new Class[]{String.class, Component.class}, new Object[]{IOUtil.getCodeBase(applet) + filename, comp}, chart);
                }
                return this.applyXMLTemplateInstance(new Class[]{File.class, Component.class}, new Object[]{IOUtil.createFile(filename), comp}, chart);
            }
            return this.applyXMLTemplateInstance(new Class[]{File.class, Component.class}, new Object[]{new File(filename), comp}, chart);
        }
        return new LoadChart().load(comp, ReadDataFile.getFromServer(filename, false, null, null, null, chart, 27678), false, null);
    }

    private Chart applyXMLTemplateInstance(Class[] argsClass, Object[] argsValue, Chart chart) throws Exception {
        Class<?> objClass = Class.forName("quadbase.chart.xml.XMLChart");
        Constructor<?> objCons = objClass.getConstructor(argsClass);
        Object xmlChart = objCons.newInstance(argsValue);
        Method objMethod = objClass.getMethod("createChart", Chart.class);
        return (Chart)objMethod.invoke(xmlChart, chart);
    }

    IResultSet getClassResultSet(String className) throws Exception {
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            Class<?> objClass = null;
            Constructor<?> objCons = null;
            Object resultSetClass = null;
            Object obj = null;
            try {
                objClass = Class.forName(className);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to get class by name", ex);
                throw new Exception(className + " not found!");
            }
            try {
                objCons = objClass.getConstructor(new Class[0]);
                resultSetClass = objCons.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to create class", ex);
                throw new Exception("Cannot create " + className + "!");
            }
            try {
                Method objMethod = objClass.getMethod("getResultSet", new Class[0]);
                obj = objMethod.invoke(resultSetClass, new Object[0]);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Can't get ResultSet", ex);
                throw new Exception("Cannot execute getResultSet()");
            }
            if (obj instanceof IResultSet) {
                return (IResultSet)obj;
            }
            try {
                Class.forName("quadbase.reportdesigner.util.IResultSet");
                return CastUtil.castToChartResultSet(obj);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Not compatible ResultSet", ex);
                throw new Exception("Not compatible resultset!");
            }
        }
        DataInputStream din = ReadDataFile.getFromServer(className, false, null, null, null, null, 32415, 6);
        return ColData.getResultSet(DataFileInput.getColDataFromStream(din));
    }

    IResultSet createXMLQueryResultSet(XMLFileQueryInfo xmlInfo) throws Exception {
        Applet applet = ServerMessage.getApplet();
        String filename = xmlInfo.getFileName();
        byte[] data = xmlInfo.getData();
        if (data != null) {
            return new XMLQueryResultSet(new ByteArrayInputStream(data), xmlInfo.getFieldInfo(), xmlInfo.getCondition(), xmlInfo.getConditionInfo(), xmlInfo.getInSet());
        }
        if ((filename = filename.replace('\\', '/')).startsWith("http://") || filename.startsWith("https://") || filename.startsWith("file://")) {
            return new XMLQueryResultSet(xmlInfo);
        }
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (!filename.startsWith("/") && filename.indexOf(58) < 0) {
                if (applet != null) {
                    xmlInfo.setFileName(IOUtil.getCodeBase(applet) + filename);
                    return new XMLQueryResultSet(xmlInfo);
                }
                return new XMLQueryResultSet(IOUtil.createFile(filename), xmlInfo.getFieldInfo(), xmlInfo.getCondition(), xmlInfo.getConditionInfo(), xmlInfo.getDTDName(), xmlInfo.isVerify(), xmlInfo.getInSet());
            }
            xmlInfo.setFileName(filename);
            return new XMLQueryResultSet(xmlInfo);
        }
        return new XMLQueryResultSet(this.getInputStream(filename), xmlInfo.getFieldInfo(), xmlInfo.getCondition(), xmlInfo.getConditionInfo(), xmlInfo.getDTDName(), xmlInfo.isVerify(), xmlInfo.getInSet());
    }

    public void close() throws Exception {
        if (this.inputstream != null) {
            this.inputstream.close();
        }
    }

    private static DataInputStream getFromServer(String file, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, int messageType) throws Exception {
        return ReadDataFile.getFromServer(file, isTransposed, transposeCol, filterInfo, procInfo, null, messageType, 0);
    }

    private static DataInputStream getFromServer(String file, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, Chart chart, int messageType) throws Exception {
        return ReadDataFile.getFromServer(file, isTransposed, transposeCol, filterInfo, procInfo, chart, messageType, 0);
    }

    private static DataInputStream getFromServer(String file, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, Chart chart, int messageType, int dataType) throws Exception {
        return ReadDataFile.getFromServer(file, isTransposed, transposeCol, filterInfo, procInfo, chart, messageType, null, dataType, false, null, null);
    }

    static DataInputStream getFromServer(String file, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, Chart chart, int messageType, XMLFileQueryInfo xmlInfo, int dataType, boolean drawNullColumn, String nullHandleName, String encoding) throws Exception {
        byte[] indata;
        file = file.replace('\\', '/');
        IConnection socket = ServerMessage.createConnection();
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(messageType);
        if (messageType == 20876) {
            dout.writeBoolean(false);
        }
        IOUtil.writeString(dout, file);
        if (messageType != 20876 && messageType != 24578) {
            if (messageType == 32415 || messageType == 24327) {
                dout.writeBoolean(isTransposed);
                IOUtil.writeBooleans(dout, transposeCol);
                dout.writeBoolean(procInfo != null);
                if (procInfo != null) {
                    procInfo.writeAsStream(dout);
                }
                dout.writeInt(dataType);
                dout.writeBoolean(drawNullColumn);
                IOUtil.writeStr(dout, nullHandleName);
                IOUtil.writeStr(dout, encoding);
                if (messageType == 24327) {
                    xmlInfo.write(dout);
                }
            } else if (messageType == 27678) {
                ByteArrayOutputStream chtStream = new ByteArrayOutputStream(2048);
                DataOutputStream chtOut = new DataOutputStream(chtStream);
                new SaveChart(chart).saveToDataOutput(chtOut, false);
                byte[] chartData = chtStream.toByteArray();
                dout.writeInt(chartData.length);
                dout.write(chartData, 0, chartData.length);
                if (chtOut != null) {
                    chtOut.close();
                }
                if (chtStream != null) {
                    chtStream.close();
                }
            } else if (messageType == 28816) {
                dout.writeBoolean(isTransposed);
                IOUtil.writeBooleans(dout, transposeCol);
                dout.writeBoolean(filterInfo != null);
                if (filterInfo != null) {
                    filterInfo.writeAsStream(dout);
                }
                dout.writeBoolean(procInfo != null);
                if (procInfo != null) {
                    procInfo.writeAsStream(dout);
                }
                dout.writeInt(dataType);
                dout.writeBoolean(drawNullColumn);
                IOUtil.writeStr(dout, nullHandleName);
                IOUtil.writeStr(dout, encoding);
            }
        }
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            socket.close();
            LOGGER.log(Level.FINEST, "Failed to write data to server", ex);
            throw ex;
        }
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil2.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int len = dstream.readInt();
            indata = new byte[len];
            dstream.readFully(indata, 0, len);
            dstream.close();
            socket.close();
        }
        catch (Exception ex) {
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            LOGGER.log(Level.FINE, "Failed to read data from server", ex);
            throw ex;
        }
        catch (Error err) {
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            LOGGER.log(Level.FINE, "Failed to read data from server", err);
            throw new Exception(err.getMessage());
        }
        return new DataInputStream(new ByteArrayInputStream(indata));
    }

    public static DataInput getFromServer(String className, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, QueryInParamSet paramSet) throws Exception {
        IConnection socket = null;
        try {
            socket = ServerMessage.createConnection();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(25333);
            out.writeInt(2);
            IOUtil.writeString(out, className);
            out.writeBoolean(true);
            out.writeBoolean(isTransposed);
            IOUtil.writeBooleans(out, transposeCol);
            out.writeBoolean(filterInfo != null);
            if (filterInfo != null) {
                filterInfo.writeAsStream(out);
            }
            out.writeBoolean(procInfo != null);
            if (procInfo != null) {
                procInfo.writeAsStream(out);
            }
            out.writeInt(0);
            out.writeInt(-1);
            out.writeBoolean(paramSet != null);
            if (paramSet != null) {
                paramSet.write(out);
            }
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil2.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int len = dstream.readInt();
            byte[] indata = new byte[len];
            dstream.readFully(indata, 0, len);
            dstream.close();
            socket.close();
            return new DataInputStream(new ByteArrayInputStream(indata));
        }
        catch (Exception ex) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            LOGGER.log(Level.FINE, "Communication with server failed", ex);
            throw ex;
        }
        catch (Error err) {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            LOGGER.log(Level.FINE, "Communication with server failed", err);
            throw new Exception(err.getMessage());
        }
    }
}

