/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.CGraphics;
import quadbase.chart.DataAttribute;
import quadbase.chart.Line;
import quadbase.chart.MultiDimData;
import quadbase.chart.Point3D;

public class StackChart {
    private static final Logger LOGGER = Logger.getLogger(StackChart.class.getName());

    public static MultiDimData selectLine(CGraphics g, int x, int y, MultiDimData data, int[] mDataLen, int dataDim) {
        Point3D lastpoint = null;
        if (dataDim == 2) {
            DataAttribute dattribute = null;
            try {
                dattribute = new DataAttribute(data, false, g.chart.is2DimChart(), g.chart.getChartType(), true);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Can't create new DataAttribute", ex);
            }
            for (int i = 0; i < mDataLen[1]; ++i) {
                lastpoint = null;
                for (int j = 0; j < mDataLen[0]; ++j) {
                    double stepR;
                    int rX;
                    MultiDimData a = data.multiData[j].multiData[i];
                    if (a.plotData.isEmpty()) {
                        lastpoint = null;
                        continue;
                    }
                    boolean isLineVisible = true;
                    if (dattribute != null && i < dattribute.lineThickness.length && dattribute.lineThickness[i] <= 0) {
                        isLineVisible = false;
                    }
                    Point3D currpoint = a.point;
                    if (lastpoint != null && isLineVisible && (g.chart.selectStep == null || i >= g.chart.selectStep.length || !g.chart.selectStep[i] ? Line.pickLine(lastpoint.x, g.height - lastpoint.y, currpoint.x, g.height - currpoint.y, x, y) : Line.pickLine(lastpoint.x, g.height - lastpoint.y, rX = lastpoint.x + (int)((double)(currpoint.x - lastpoint.x) * (stepR = g.chart.getStepLineRatio2())), g.height - lastpoint.y, x, y) || Line.pickLine(rX, g.height - lastpoint.y, rX, g.height - currpoint.y, x, y) || Line.pickLine(rX, g.height - currpoint.y, currpoint.x, g.height - currpoint.y, x, y))) {
                        return a;
                    }
                    lastpoint = currpoint;
                }
            }
        } else {
            for (int i = 0; i < mDataLen[0]; ++i) {
                for (int j = 0; j < mDataLen[2]; ++j) {
                    lastpoint = null;
                    for (int k = 0; k < mDataLen[1]; ++k) {
                        MultiDimData a = data.multiData[i].multiData[k].multiData[j];
                        if (a.plotData.isEmpty()) {
                            lastpoint = null;
                            continue;
                        }
                        Point3D currpoint = a.point;
                        if (lastpoint != null && Line.pickLine(lastpoint.x, g.height - lastpoint.y, currpoint.x, g.height - currpoint.y, x, y)) {
                            return a;
                        }
                        lastpoint = currpoint;
                    }
                }
            }
        }
        return null;
    }
}

