/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.util.Date;
import java.util.Vector;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.Point3D;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.DateTime;

public abstract class Ticker {
    public Axis axis;
    public Object[] name;
    public CString[] label;
    public int length;
    String[] tickerLabel = null;
    int tickerLabelCount = 0;
    public Color color = Color.black;
    public Color label_color = Color.black;
    public Font font = CString.defaultfont;
    public int displacement = 0;
    public int twidth = 6;
    public int tickerH = 4;
    public int angle;
    public boolean automatic = true;
    public boolean centerLabels = true;
    public boolean showline = true;
    public boolean showText = true;
    public boolean tickerInward = false;
    public boolean reverseSide;
    public boolean onTop = false;
    public int topY = 0;
    public Point3D[] point;
    public Point maxp;
    public Point minp;
    protected boolean xyzchart;
    private boolean initMinMax;
    protected Point3D[] subTickers;
    public int radarXOffset = 0;
    public int radarYOffset = 0;

    public Ticker(Axis axis) {
        this.axis = axis;
        this.maxp = new Point(0, 0);
        this.minp = new Point(0, 0);
    }

    public Point3D[] getPoints() {
        return this.point;
    }

    public void setTickerLabels(String[] label) {
        this.tickerLabel = label;
    }

    public String[] getTickerLabels() {
        return this.tickerLabel;
    }

    public Object[] getOriginalTickerLabels(boolean formatedLabel) {
        Vector<Object> object = new Vector<Object>();
        if (this.axis.columnField == null) {
            return new Object[0];
        }
        int inc = this.axis.columnField.sepSize;
        int sepUnit = this.axis.columnField.sepUnit;
        if (sepUnit != -1) {
            Date startPt = null;
            if (this.axis.columnField.isAscending) {
                startPt = new Date(this.axis.columnField.getStartingDate().getTime());
            } else {
                startPt = new Date(this.axis.columnField.getEndingDate().getTime());
                inc *= -1;
            }
            int dataType = this.axis.columnField.dataType;
            for (int i = 0; i < this.length; ++i) {
                int value = DateTime.compare(sepUnit, (Date)this.name[i], startPt, dataType);
                if (this.axis.columnField.isAscending) {
                    while (value > 0) {
                        startPt = DateTime.increment(sepUnit, inc, startPt);
                        value = DateTime.compare(sepUnit, (Date)this.name[i], startPt, dataType);
                    }
                } else {
                    while (value < 0) {
                        startPt = DateTime.increment(sepUnit, inc, startPt);
                        value = DateTime.compare(sepUnit, (Date)this.name[i], startPt, dataType);
                    }
                }
                if (value != 0) continue;
                if (formatedLabel) {
                    object.addElement(this.format(this.name[i]));
                    continue;
                }
                object.addElement(this.name[i]);
            }
        } else {
            for (int i = 0; i < this.length; i += inc) {
                if (formatedLabel) {
                    object.addElement(this.format(this.name[i]));
                    continue;
                }
                object.addElement(this.name[i]);
            }
        }
        Object[] result = new Object[object.size()];
        for (int i = 0; i < object.size(); ++i) {
            result[i] = object.elementAt(i);
        }
        return result;
    }

    public void setSubTickers(Point3D[] point) {
        this.subTickers = point;
    }

    public abstract void modify(Object[] var1, Object var2, Point3D[] var3, boolean var4, boolean var5);

    public void modify(Object[] name, Point3D[] point, boolean _reverseSide) {
        this.length = name.length;
        this.name = name;
        this.reverseSide = _reverseSide;
        this.point = point;
        if (this.label != null && this.label[0] != null && this.automatic) {
            this.automatic = this.label[0].automatic;
        }
        this.label = new CString[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.label[i] = new CString(this.format(name[i]));
            this.label[i].setFont(this.font, this.angle);
            this.label[i].setColor(this.label_color);
            this.label[i].setAutomatic(this.automatic);
        }
    }

    private String format(Object obj) {
        if (this.axis.columnField != null && this.axis.columnField.dataType == 2 && obj instanceof Integer && obj.toString().endsWith(".0")) {
            int i = Double.valueOf(obj.toString()).intValue();
            return String.valueOf(i);
        }
        if (this.axis.columnField != null) {
            return Chart.formatLabel(obj, this.axis.columnField.dataFormat);
        }
        return obj.toString();
    }

    public final void setY(int y) {
        this.topY = y;
    }

    public final void setFont(Font font) {
        this.setFont(font, this.angle, this.automatic);
    }

    public final void setFont(Font font, int angle) {
        this.setFont(font, angle, this.automatic);
    }

    public final void setFont(Font font, int angle, boolean auto) {
        this.font = font;
        this.angle = angle;
        this.axis.font = font;
        this.automatic = auto;
        if (this.label != null) {
            for (CString element : this.label) {
                element.setAutomatic(auto);
                element.setFont(font, angle);
            }
        }
    }

    public final CString getString() {
        if (this.label != null) {
            return this.label[0];
        }
        CString tmp = new CString();
        tmp.setFont(this.font, this.angle);
        return tmp;
    }

    public void draw(CGraphics g) {
        this.draw(g, this.point);
    }

    public abstract void copy3DptsArray(CGraphics var1, Point3D[] var2);

    public void draw(CGraphics g, Point3D[] point) {
        block67: {
            int tickerSep;
            int i;
            int angle2;
            if (this.label == null || !this.axis.showTicker && !this.showline) {
                return;
            }
            if (this.automatic) {
                this.automatic = this.label[0].automatic;
            }
            for (int i2 = 0; i2 < this.label.length; ++i2) {
                this.label[i2].initFont = true;
            }
            int fheight = this.label[0].getFontWidthHeight(g);
            this.copy3DptsArray(g, point);
            int n = angle2 = this.angle >= 0 ? this.angle : this.angle + 360;
            angle2 = angle2 >= 5 && angle2 <= 85 || angle2 >= 185 && angle2 <= 265 ? 1 : (angle2 >= 95 && angle2 <= 175 || angle2 >= 275 && angle2 <= 355 ? 2 : 0);
            g.setColor(this.axis.grid.color);
            int inc = this.axis.columnField.tickerSepSize;
            int maxLabelCt = this.axis.columnField.maxNumOfTickerAndLabel;
            inc = Axis.calcMaxInc(maxLabelCt, this.length, inc);
            int sepUnit = this.axis.columnField.sepUnit;
            int rowheight = 0;
            this.tickerLabelCount = 0;
            for (i = 0; i < this.length && i < point.length; ++i) {
                boolean display = sepUnit == -1 ? i % inc == 0 : false;
                rowheight = g.chart != null ? i % g.chart.xlabelrow * fheight : 0;
                if (this.axis.orient == 0 || this.axis.orient == 3 && (this.axis.startp.y == this.axis.endp.y || this.axis.reversexlabel)) {
                    boolean drawOnTop;
                    if (this.axis.orient == 3) {
                        rowheight = 0;
                    }
                    if (this.axis.orient == 0 && this.axis.isLabelOutsidePlotArea()) {
                        this.reverseSide = false;
                    }
                    boolean bl = drawOnTop = this.axis.orient == 0 && this.onTop;
                    if (drawOnTop) {
                        point[i].y = this.topY;
                    }
                    if (this.reverseSide || drawOnTop) {
                        this.label[i].pos.y = !this.axis.reversexlabel ? point[i].y + (this.axis.thickness / 2 + this.twidth) + rowheight : point[i].y + this.twidth + rowheight;
                        int n2 = angle2 == 0 ? 1 : (this.label[i].placement = angle2 == 1 ? 5 : 8);
                        if (display) {
                            this.drawLine(g, point[i].x, this.label[i].pos.y - this.twidth + this.tickerH, i, point);
                        }
                    } else if (g.chart != null && g.chart.is2DimChart() && this.axis.isLabelOutsidePlotArea()) {
                        this.label[i].pos.y = g.chart.a_y.startp.y - (this.axis.thickness / 2 + this.twidth + 2) - rowheight;
                        int n3 = angle2 == 0 ? 3 : (this.label[i].placement = angle2 == 1 ? 7 : 6);
                        if (display) {
                            this.drawLine(g, point[i].x, this.label[i].pos.y + this.twidth - this.tickerH, point[i].x, g.chart.a_y.startp.y);
                        }
                    } else {
                        this.label[i].pos.y = point[i].y - (this.axis.thickness / 2 + this.twidth + 2) - rowheight;
                        int n4 = angle2 == 0 ? 3 : (this.label[i].placement = angle2 == 1 ? 7 : 6);
                        if (display) {
                            this.drawLine(g, point[i].x, this.label[i].pos.y + this.twidth - this.tickerH, i, point);
                        }
                    }
                    this.label[i].pos.x = point[i].x + this.displacement;
                    continue;
                }
                if (this.axis.orient == 1 && this.axis.isLabelOutsidePlotArea()) {
                    this.reverseSide = false;
                }
                if (this.reverseSide) {
                    this.label[i].pos.x = point[i].x + this.axis.thickness / 2 + this.twidth;
                    if (this.axis.orient == 2) {
                        this.label[i].placement = angle2 == 0 ? 3 : (angle2 == 1 ? 7 : 6);
                    } else {
                        int n5 = angle2 == 0 ? 2 : (this.label[i].placement = angle2 == 1 ? 6 : 5);
                    }
                    if (display) {
                        this.drawLine(g, this.label[i].pos.x - this.twidth + 3, point[i].y, i, point);
                    }
                } else if (g.chart != null && g.chart.is2DimChart() && this.axis.isLabelOutsidePlotArea()) {
                    this.label[i].pos.x = g.chart.a_x.startp.x - (this.axis.thickness / 2 + this.twidth);
                    int n6 = angle2 == 0 ? 4 : (this.label[i].placement = angle2 == 1 ? 7 : 8);
                    if (display) {
                        this.drawLine(g, this.label[i].pos.x + this.twidth - this.tickerH, point[i].y, g.chart.a_x.startp.x, point[i].y);
                    }
                } else {
                    this.label[i].pos.x = point[i].x - (this.axis.thickness / 2 + this.twidth);
                    int n7 = angle2 == 0 ? 4 : (this.label[i].placement = angle2 == 1 ? 7 : 8);
                    if (display) {
                        this.drawLine(g, this.label[i].pos.x + this.twidth - this.tickerH, point[i].y, i, point);
                    }
                }
                this.label[i].pos.y = point[i].y + this.displacement;
            }
            if (this.subTickers != null && this.axis.logScale && this.axis.isShowSubTickers()) {
                if (!g.chart.is2DimChart()) {
                    this.draw3DSubTickers(g);
                } else {
                    int stwidth = 6;
                    for (int i3 = 0; i3 < this.subTickers.length; ++i3) {
                        if (this.axis.orient == 0 || this.axis.orient == 3 && (this.axis.startp.y == this.axis.endp.y || this.axis.reversexlabel)) {
                            boolean drawOnTop;
                            tickerSep = (int)((double)(stwidth - this.tickerH) / 2.0);
                            if (this.axis.orient == 0 && this.axis.isLabelOutsidePlotArea()) {
                                this.reverseSide = false;
                            }
                            int newY = 0;
                            boolean bl = drawOnTop = this.axis.orient == 0 && this.onTop;
                            if (drawOnTop) {
                                this.subTickers[i3].y = this.topY;
                            }
                            if (this.reverseSide || drawOnTop) {
                                newY = !this.axis.reversexlabel ? this.subTickers[i3].y + (this.axis.thickness / 2 + stwidth) + rowheight : this.subTickers[i3].y + stwidth + rowheight;
                                this.drawLine(g, this.subTickers[i3].x, newY - tickerSep, i3, this.subTickers);
                                continue;
                            }
                            if (g.chart != null && g.chart.is2DimChart() && this.axis.isLabelOutsidePlotArea()) {
                                newY = g.chart.a_y.startp.y - (this.axis.thickness / 2 + stwidth + 2) - rowheight;
                                this.drawLine(g, this.subTickers[i3].x, newY + tickerSep, this.subTickers[i3].x, g.chart.a_y.startp.y);
                                continue;
                            }
                            newY = this.subTickers[i3].y - (this.axis.thickness / 2 + stwidth + 2) - rowheight;
                            this.drawLine(g, this.subTickers[i3].x, newY + tickerSep, i3, this.subTickers);
                            continue;
                        }
                        if (this.axis.orient == 1 && this.axis.isLabelOutsidePlotArea()) {
                            this.reverseSide = false;
                        }
                        tickerSep = (int)((double)(stwidth - this.tickerH) * 2.0);
                        int newX = 0;
                        if (this.reverseSide) {
                            newX = this.subTickers[i3].x + this.axis.thickness / 2 + stwidth;
                            this.drawLine(g, newX - tickerSep, this.subTickers[i3].y, i3, this.subTickers);
                            continue;
                        }
                        if (g.chart != null && g.chart.is2DimChart() && this.axis.isLabelOutsidePlotArea()) {
                            newX = g.chart.a_x.startp.x - (this.axis.thickness / 2 + stwidth);
                            this.drawLine(g, newX + tickerSep, this.subTickers[i3].y, g.chart.a_x.startp.x, this.subTickers[i3].y);
                            continue;
                        }
                        newX = this.subTickers[i3].x - (this.axis.thickness / 2 + stwidth);
                        this.drawLine(g, newX + tickerSep, this.subTickers[i3].y, i3, this.subTickers);
                    }
                }
            }
            if ((this.axis.orient == 0 || this.axis.orient == 2) && this.automatic) {
                this.angle = 0;
                for (i = 0; i < this.length - 1; ++i) {
                    if (this.label[i + 1].pos.x - this.label[i].pos.x >= g.getFontMetrics(QbUtil.resizeViewerFont(this.label[i].font, g.chart != null ? g.chart.isAdjustFont() : false)).stringWidth(this.label[i].str) + 3) continue;
                    this.angle = 90;
                    for (int j = 0; j < this.length; ++j) {
                        this.label[j].setDirection(2);
                    }
                    break;
                }
                if (this.angle == 0) {
                    for (int j = 0; j < this.length; ++j) {
                        this.label[j].setDirection(0);
                    }
                }
            }
            if (!this.axis.showTicker) break block67;
            this.initMinMax = true;
            if (sepUnit != -1) {
                inc = this.axis.columnField.sepSize;
                if (sepUnit == 7) {
                    sepUnit = DateTime.getAutoScaleUnit(this.axis.columnField.calcStartingDate(), this.axis.columnField.calcEndingDate());
                } else if (this.axis.columnField.dataType == 8 && sepUnit <= 2) {
                    sepUnit = 3;
                }
                Date startPt = null;
                if (this.axis.columnField.isAscending) {
                    startPt = new Date(this.axis.columnField.getStartingDate().getTime());
                } else {
                    startPt = new Date(this.axis.columnField.getEndingDate().getTime());
                    inc *= -1;
                }
                Point3D[] startPoint = new Point3D[2];
                tickerSep = this.axis.columnField.tickerSepSize;
                int dataType = this.axis.columnField.dataType;
                boolean showTickerForLastDataPoint = false;
                for (int i4 = 0; i4 < this.length && i4 < point.length; ++i4) {
                    int value = DateTime.compare(sepUnit, (Date)this.name[i4], startPt, dataType);
                    boolean isIncremented = false;
                    if (this.axis.columnField.isAscending) {
                        while (value > 0) {
                            startPt = DateTime.increment(sepUnit, inc, startPt);
                            isIncremented = true;
                            value = DateTime.compare(sepUnit, (Date)this.name[i4], startPt, dataType);
                        }
                    } else {
                        while (value < 0) {
                            startPt = DateTime.increment(sepUnit, inc, startPt);
                            isIncremented = true;
                            value = DateTime.compare(sepUnit, (Date)this.name[i4], startPt, dataType);
                        }
                    }
                    if (value == 0 || isIncremented && i4 != 0) {
                        int drawLabelIdx = i4;
                        if (drawLabelIdx >= 0) {
                            this.drawTickerAndLabel(g, drawLabelIdx);
                        }
                        if (value == 0) {
                            startPt = DateTime.increment(sepUnit, inc, startPt);
                        }
                    } else if (showTickerForLastDataPoint && i4 == this.length - 1) {
                        this.drawTickerAndLabel(g, i4);
                    }
                    if (value != 0 || this.axis.is3D) continue;
                    if (startPoint[0] != null) {
                        int j;
                        if (this.axis.orient == 0) {
                            int x_inc = (point[i4].x - startPoint[0].x) / tickerSep;
                            for (j = 1; j < tickerSep; ++j) {
                                startPoint[0].x += x_inc;
                                startPoint[1].x += x_inc;
                                this.drawLine(g, startPoint[0].x, startPoint[0].y, 1, startPoint);
                            }
                        } else {
                            int y_inc = (point[i4].y - startPoint[0].y) / tickerSep;
                            for (j = 1; j < tickerSep; ++j) {
                                startPoint[0].y += y_inc;
                                startPoint[1].y += y_inc;
                                this.drawLine(g, startPoint[0].x, startPoint[0].y, 1, startPoint);
                            }
                        }
                    }
                    if (this.axis.orient == 0) {
                        startPoint[0] = new Point3D(point[i4].x, this.label[i4].pos.y + this.twidth - this.tickerH);
                        if (this.axis.isLabelOutsidePlotArea()) {
                            startPoint[1] = new Point3D(point[i4].x, g.chart.a_y.startp.y);
                            continue;
                        }
                        startPoint[1] = new Point3D(point[i4].x, point[i4].y);
                        continue;
                    }
                    startPoint[0] = new Point3D(this.label[i4].pos.x + this.twidth - this.tickerH, point[i4].y);
                    startPoint[1] = this.axis.isLabelOutsidePlotArea() ? new Point3D(g.chart.a_x.startp.x, point[i4].y) : new Point3D(point[i4].x, point[i4].y);
                }
            } else {
                inc = this.axis.columnField.sepSize;
                maxLabelCt = this.axis.columnField.maxNumOfTickerAndLabel;
                inc = Axis.calcMaxInc(maxLabelCt, this.length, inc);
                for (i = 0; i < this.length && i < point.length; i += inc) {
                    this.drawLabel(g, i, this.maxp, this.minp);
                }
            }
        }
    }

    private void drawTickerAndLabel(CGraphics g, int drawLabelIdx) {
        this.drawLabel(g, drawLabelIdx, this.maxp, this.minp);
        if (this.axis.orient == 0) {
            if (this.axis.isLabelOutsidePlotArea()) {
                this.drawLine(g, this.point[drawLabelIdx].x, this.label[drawLabelIdx].pos.y + this.twidth - this.tickerH, this.point[drawLabelIdx].x, g.chart.a_y.startp.y);
            } else {
                this.drawLine(g, this.point[drawLabelIdx].x, this.label[drawLabelIdx].pos.y + this.twidth - this.tickerH, drawLabelIdx, this.point);
            }
        } else if (this.axis.isLabelOutsidePlotArea()) {
            this.drawLine(g, this.label[drawLabelIdx].pos.x + this.twidth - this.tickerH, this.point[drawLabelIdx].y, g.chart.a_x.startp.x, this.point[drawLabelIdx].y);
        } else {
            this.drawLine(g, this.label[drawLabelIdx].pos.x + this.twidth - this.tickerH, this.point[drawLabelIdx].y, drawLabelIdx, this.point);
        }
    }

    public void drawLabel(CGraphics g, int i, Point maxp, Point minp) {
        CString s = this.label[i];
        if (s.pos.x == 0 && s.pos.y == 0 && s.pos.z == 0) {
            return;
        }
        if (this.tickerLabel != null && this.tickerLabelCount < this.tickerLabel.length && this.tickerLabel[this.tickerLabelCount] != null && !this.tickerLabel[this.tickerLabelCount].equals("")) {
            s.setString(this.tickerLabel[this.tickerLabelCount]);
        }
        ++this.tickerLabelCount;
        if (this.showText) {
            s.draw(g, this.centerLabels);
        }
        if (s.str.equals("")) {
            return;
        }
        if (this.initMinMax) {
            minp.x = s.minx;
            minp.y = s.miny;
            maxp.x = s.maxx;
            maxp.y = s.maxy;
            this.initMinMax = false;
        } else {
            if (s.minx < minp.x) {
                minp.x = s.minx;
            }
            if (s.miny < minp.y) {
                minp.y = s.miny;
            }
            if (s.maxx > maxp.x) {
                maxp.x = s.maxx;
            }
            if (s.maxy > maxp.y) {
                maxp.y = s.maxy;
            }
        }
    }

    public void drawLabel(CGraphics g, int i, double angle2, int centerX, int centerY) {
        if (angle2 == 0.0) {
            this.drawLabel(g, i, this.maxp, this.minp);
        } else {
            int d;
            CString s = this.label[i];
            double height = s.pos.y - centerY;
            double twidth2 = centerX - s.pos.x;
            double len = Math.sqrt(Math.pow(twidth2, 2.0) + Math.pow(height, 2.0));
            double angle1 = angle2 - Math.atan(twidth2 / height);
            s.pos.x = centerX + (int)(Math.sin(angle1) * len) - this.radarXOffset;
            s.pos.y = centerY + (int)(Math.cos(angle1) * len) + this.radarYOffset;
            int angle = (int)Math.rint(angle2 * 180.0 / Math.PI);
            if (angle > 0 + (d = 10) && angle < 90 - d) {
                this.label[i].placement = 0;
            }
            if (angle >= 90 - d && angle <= 90 + d) {
                this.label[i].placement = 1;
            }
            if (angle > 90 + d && angle < 180 - d) {
                this.label[i].placement = 0;
            }
            if (angle >= 180 - d && angle <= 180 + d) {
                this.label[i].placement = 2;
            }
            if (angle > 180 + d && angle < 270 - d) {
                this.label[i].placement = 0;
            }
            if (angle >= 270 - d && angle <= 270 + d) {
                this.label[i].placement = 3;
            }
            if (angle > 270 + d && angle < 360 - d) {
                this.label[i].placement = 0;
            }
            this.drawLabel(g, i, this.maxp, this.minp);
        }
    }

    public abstract void drawLine(CGraphics var1, int var2, int var3, int var4, Point3D[] var5);

    public abstract void drawLine(CGraphics var1, int var2, int var3, int var4, int var5);

    public abstract void draw3DSubTickers(CGraphics var1);

    protected int calcOppositePt(int startPt, int desPt) {
        return startPt + (startPt - desPt);
    }

    public abstract boolean select(CGraphics var1, int var2, int var3);

    public final boolean selectLabel(CGraphics g, int x, int y) {
        return CString.selectStrings(g, x, y, this.label) != null;
    }

    public final String getSelectedLabel(CGraphics g, int x, int y) {
        return CString.selectStrings((CGraphics)g, (int)x, (int)y, (CString[])this.label).str;
    }

    public final Ticker copy(Ticker newTicker) {
        newTicker.label = this.label;
        newTicker.tickerLabel = this.tickerLabel;
        newTicker.showline = this.showline;
        newTicker.showText = this.showText;
        newTicker.tickerInward = this.tickerInward;
        newTicker.color = this.color;
        newTicker.label_color = this.label_color;
        newTicker.font = this.font;
        newTicker.angle = this.angle;
        newTicker.twidth = this.twidth;
        newTicker.displacement = this.displacement;
        newTicker.onTop = this.onTop;
        newTicker.topY = this.topY;
        newTicker.automatic = this.automatic;
        return newTicker;
    }

    public final void setTickerColor(Color color) {
        this.color = color;
    }

    public final void setLabelColor(Color l_color) {
        this.label_color = l_color;
        if (this.label != null) {
            for (CString element : this.label) {
                element.setColor(this.label_color);
            }
        }
    }

    public final Object getGLBound(int x) {
        int i;
        for (i = this.point.length - 1; i >= 0 && this.point[i].x > x; --i) {
        }
        if (i <= -1) {
            return null;
        }
        return this.name[i];
    }

    public final Object getLUBound(int x) {
        int i;
        for (i = 0; i < this.point.length && this.point[i].x < x; ++i) {
        }
        if (i >= this.point.length) {
            return null;
        }
        return this.name[i];
    }
}

